﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/workspaces/model/ReconnectEnum.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace WorkSpaces
  {
    namespace Model
    {
      namespace ReconnectEnumMapper
      {

        static const int ENABLED_HASH = HashingUtils::HashString("ENABLED");
        static const int DISABLED_HASH = HashingUtils::HashString("DISABLED");


        ReconnectEnum GetReconnectEnumForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == ENABLED_HASH)
          {
            return ReconnectEnum::ENABLED;
          }
          else if (hashCode == DISABLED_HASH)
          {
            return ReconnectEnum::DISABLED;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<ReconnectEnum>(hashCode);
          }

          return ReconnectEnum::NOT_SET;
        }

        Aws::String GetNameForReconnectEnum(ReconnectEnum enumValue)
        {
          switch(enumValue)
          {
          case ReconnectEnum::NOT_SET:
            return {};
          case ReconnectEnum::ENABLED:
            return "ENABLED";
          case ReconnectEnum::DISABLED:
            return "DISABLED";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace ReconnectEnumMapper
    } // namespace Model
  } // namespace WorkSpaces
} // namespace Aws
