﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/supplychain/SupplyChain_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/supplychain/model/DataIntegrationFlow.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace SupplyChain
{
namespace Model
{
  /**
   * <p>The response parameters for ListDataIntegrationFlows.</p><p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/ListDataIntegrationFlowsResponse">AWS
   * API Reference</a></p>
   */
  class ListDataIntegrationFlowsResult
  {
  public:
    AWS_SUPPLYCHAIN_API ListDataIntegrationFlowsResult();
    AWS_SUPPLYCHAIN_API ListDataIntegrationFlowsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_SUPPLYCHAIN_API ListDataIntegrationFlowsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The response parameters for ListDataIntegrationFlows.</p>
     */
    inline const Aws::Vector<DataIntegrationFlow>& GetFlows() const{ return m_flows; }
    inline void SetFlows(const Aws::Vector<DataIntegrationFlow>& value) { m_flows = value; }
    inline void SetFlows(Aws::Vector<DataIntegrationFlow>&& value) { m_flows = std::move(value); }
    inline ListDataIntegrationFlowsResult& WithFlows(const Aws::Vector<DataIntegrationFlow>& value) { SetFlows(value); return *this;}
    inline ListDataIntegrationFlowsResult& WithFlows(Aws::Vector<DataIntegrationFlow>&& value) { SetFlows(std::move(value)); return *this;}
    inline ListDataIntegrationFlowsResult& AddFlows(const DataIntegrationFlow& value) { m_flows.push_back(value); return *this; }
    inline ListDataIntegrationFlowsResult& AddFlows(DataIntegrationFlow&& value) { m_flows.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The pagination token to fetch the next page of the DataIntegrationFlows.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListDataIntegrationFlowsResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListDataIntegrationFlowsResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListDataIntegrationFlowsResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListDataIntegrationFlowsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListDataIntegrationFlowsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListDataIntegrationFlowsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<DataIntegrationFlow> m_flows;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace SupplyChain
} // namespace Aws
