﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/servicediscovery/model/ServiceTypeOption.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace ServiceDiscovery
  {
    namespace Model
    {
      namespace ServiceTypeOptionMapper
      {

        static const int HTTP_HASH = HashingUtils::HashString("HTTP");


        ServiceTypeOption GetServiceTypeOptionForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == HTTP_HASH)
          {
            return ServiceTypeOption::HTTP;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<ServiceTypeOption>(hashCode);
          }

          return ServiceTypeOption::NOT_SET;
        }

        Aws::String GetNameForServiceTypeOption(ServiceTypeOption enumValue)
        {
          switch(enumValue)
          {
          case ServiceTypeOption::NOT_SET:
            return {};
          case ServiceTypeOption::HTTP:
            return "HTTP";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace ServiceTypeOptionMapper
    } // namespace Model
  } // namespace ServiceDiscovery
} // namespace Aws
