﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/quicksight/model/StatePersistenceConfigurations.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace QuickSight
{
namespace Model
{

StatePersistenceConfigurations::StatePersistenceConfigurations() : 
    m_enabled(false),
    m_enabledHasBeenSet(false)
{
}

StatePersistenceConfigurations::StatePersistenceConfigurations(JsonView jsonValue)
  : StatePersistenceConfigurations()
{
  *this = jsonValue;
}

StatePersistenceConfigurations& StatePersistenceConfigurations::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("Enabled"))
  {
    m_enabled = jsonValue.GetBool("Enabled");

    m_enabledHasBeenSet = true;
  }

  return *this;
}

JsonValue StatePersistenceConfigurations::Jsonize() const
{
  JsonValue payload;

  if(m_enabledHasBeenSet)
  {
   payload.WithBool("Enabled", m_enabled);

  }

  return payload;
}

} // namespace Model
} // namespace QuickSight
} // namespace Aws
