﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/qconnect/model/ListMessageTemplatesResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::QConnect::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListMessageTemplatesResult::ListMessageTemplatesResult()
{
}

ListMessageTemplatesResult::ListMessageTemplatesResult(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  *this = result;
}

ListMessageTemplatesResult& ListMessageTemplatesResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("messageTemplateSummaries"))
  {
    Aws::Utils::Array<JsonView> messageTemplateSummariesJsonList = jsonValue.GetArray("messageTemplateSummaries");
    for(unsigned messageTemplateSummariesIndex = 0; messageTemplateSummariesIndex < messageTemplateSummariesJsonList.GetLength(); ++messageTemplateSummariesIndex)
    {
      m_messageTemplateSummaries.push_back(messageTemplateSummariesJsonList[messageTemplateSummariesIndex].AsObject());
    }
  }

  if(jsonValue.ValueExists("nextToken"))
  {
    m_nextToken = jsonValue.GetString("nextToken");

  }


  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if(requestIdIter != headers.end())
  {
    m_requestId = requestIdIter->second;
  }


  return *this;
}
