﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/pipes/model/EcsEnvironmentFileType.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace Pipes
  {
    namespace Model
    {
      namespace EcsEnvironmentFileTypeMapper
      {

        static const int s3_HASH = HashingUtils::HashString("s3");


        EcsEnvironmentFileType GetEcsEnvironmentFileTypeForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == s3_HASH)
          {
            return EcsEnvironmentFileType::s3;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<EcsEnvironmentFileType>(hashCode);
          }

          return EcsEnvironmentFileType::NOT_SET;
        }

        Aws::String GetNameForEcsEnvironmentFileType(EcsEnvironmentFileType enumValue)
        {
          switch(enumValue)
          {
          case EcsEnvironmentFileType::NOT_SET:
            return {};
          case EcsEnvironmentFileType::s3:
            return "s3";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace EcsEnvironmentFileTypeMapper
    } // namespace Model
  } // namespace Pipes
} // namespace Aws
