﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/mediaconvert/model/ImscStylePassthrough.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace MediaConvert
  {
    namespace Model
    {
      namespace ImscStylePassthroughMapper
      {

        static const int ENABLED_HASH = HashingUtils::HashString("ENABLED");
        static const int DISABLED_HASH = HashingUtils::HashString("DISABLED");


        ImscStylePassthrough GetImscStylePassthroughForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == ENABLED_HASH)
          {
            return ImscStylePassthrough::ENABLED;
          }
          else if (hashCode == DISABLED_HASH)
          {
            return ImscStylePassthrough::DISABLED;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<ImscStylePassthrough>(hashCode);
          }

          return ImscStylePassthrough::NOT_SET;
        }

        Aws::String GetNameForImscStylePassthrough(ImscStylePassthrough enumValue)
        {
          switch(enumValue)
          {
          case ImscStylePassthrough::NOT_SET:
            return {};
          case ImscStylePassthrough::ENABLED:
            return "ENABLED";
          case ImscStylePassthrough::DISABLED:
            return "DISABLED";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace ImscStylePassthroughMapper
    } // namespace Model
  } // namespace MediaConvert
} // namespace Aws
