﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/mediaconvert/model/H265GopBReference.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace MediaConvert
  {
    namespace Model
    {
      namespace H265GopBReferenceMapper
      {

        static const int DISABLED_HASH = HashingUtils::HashString("DISABLED");
        static const int ENABLED_HASH = HashingUtils::HashString("ENABLED");


        H265GopBReference GetH265GopBReferenceForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == DISABLED_HASH)
          {
            return H265GopBReference::DISABLED;
          }
          else if (hashCode == ENABLED_HASH)
          {
            return H265GopBReference::ENABLED;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<H265GopBReference>(hashCode);
          }

          return H265GopBReference::NOT_SET;
        }

        Aws::String GetNameForH265GopBReference(H265GopBReference enumValue)
        {
          switch(enumValue)
          {
          case H265GopBReference::NOT_SET:
            return {};
          case H265GopBReference::DISABLED:
            return "DISABLED";
          case H265GopBReference::ENABLED:
            return "ENABLED";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace H265GopBReferenceMapper
    } // namespace Model
  } // namespace MediaConvert
} // namespace Aws
