﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/mailmanager/model/DeleteTrafficPolicyRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::MailManager::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

DeleteTrafficPolicyRequest::DeleteTrafficPolicyRequest() : 
    m_trafficPolicyIdHasBeenSet(false)
{
}

Aws::String DeleteTrafficPolicyRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_trafficPolicyIdHasBeenSet)
  {
   payload.WithString("TrafficPolicyId", m_trafficPolicyId);

  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DeleteTrafficPolicyRequest::GetRequestSpecificHeaders() const
{
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "MailManagerSvc.DeleteTrafficPolicy"));
  return headers;

}




