﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/license-manager-linux-subscriptions/model/ListRegisteredSubscriptionProvidersResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::LicenseManagerLinuxSubscriptions::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListRegisteredSubscriptionProvidersResult::ListRegisteredSubscriptionProvidersResult()
{
}

ListRegisteredSubscriptionProvidersResult::ListRegisteredSubscriptionProvidersResult(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  *this = result;
}

ListRegisteredSubscriptionProvidersResult& ListRegisteredSubscriptionProvidersResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("NextToken"))
  {
    m_nextToken = jsonValue.GetString("NextToken");

  }

  if(jsonValue.ValueExists("RegisteredSubscriptionProviders"))
  {
    Aws::Utils::Array<JsonView> registeredSubscriptionProvidersJsonList = jsonValue.GetArray("RegisteredSubscriptionProviders");
    for(unsigned registeredSubscriptionProvidersIndex = 0; registeredSubscriptionProvidersIndex < registeredSubscriptionProvidersJsonList.GetLength(); ++registeredSubscriptionProvidersIndex)
    {
      m_registeredSubscriptionProviders.push_back(registeredSubscriptionProvidersJsonList[registeredSubscriptionProvidersIndex].AsObject());
    }
  }


  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if(requestIdIter != headers.end())
  {
    m_requestId = requestIdIter->second;
  }


  return *this;
}
