﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/lexv2-runtime/LexRuntimeV2_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace LexRuntimeV2
{
namespace Model
{

  /**
   * <p>Information about the value provided for a slot and Amazon Lex V2's
   * interpretation.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/runtime.lex.v2-2020-08-07/Value">AWS
   * API Reference</a></p>
   */
  class Value
  {
  public:
    AWS_LEXRUNTIMEV2_API Value();
    AWS_LEXRUNTIMEV2_API Value(Aws::Utils::Json::JsonView jsonValue);
    AWS_LEXRUNTIMEV2_API Value& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_LEXRUNTIMEV2_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The part of the user's response to the slot elicitation that Amazon Lex V2
     * determines is relevant to the slot value.</p>
     */
    inline const Aws::String& GetOriginalValue() const{ return m_originalValue; }
    inline bool OriginalValueHasBeenSet() const { return m_originalValueHasBeenSet; }
    inline void SetOriginalValue(const Aws::String& value) { m_originalValueHasBeenSet = true; m_originalValue = value; }
    inline void SetOriginalValue(Aws::String&& value) { m_originalValueHasBeenSet = true; m_originalValue = std::move(value); }
    inline void SetOriginalValue(const char* value) { m_originalValueHasBeenSet = true; m_originalValue.assign(value); }
    inline Value& WithOriginalValue(const Aws::String& value) { SetOriginalValue(value); return *this;}
    inline Value& WithOriginalValue(Aws::String&& value) { SetOriginalValue(std::move(value)); return *this;}
    inline Value& WithOriginalValue(const char* value) { SetOriginalValue(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The value that Amazon Lex V2 determines for the slot, given the user input.
     * The actual value depends on the setting of the value selection strategy for the
     * bot. You can choose to use the value entered by the user, or you can have Amazon
     * Lex V2 choose the first value in the <code>resolvedValues</code> list.</p>
     */
    inline const Aws::String& GetInterpretedValue() const{ return m_interpretedValue; }
    inline bool InterpretedValueHasBeenSet() const { return m_interpretedValueHasBeenSet; }
    inline void SetInterpretedValue(const Aws::String& value) { m_interpretedValueHasBeenSet = true; m_interpretedValue = value; }
    inline void SetInterpretedValue(Aws::String&& value) { m_interpretedValueHasBeenSet = true; m_interpretedValue = std::move(value); }
    inline void SetInterpretedValue(const char* value) { m_interpretedValueHasBeenSet = true; m_interpretedValue.assign(value); }
    inline Value& WithInterpretedValue(const Aws::String& value) { SetInterpretedValue(value); return *this;}
    inline Value& WithInterpretedValue(Aws::String&& value) { SetInterpretedValue(std::move(value)); return *this;}
    inline Value& WithInterpretedValue(const char* value) { SetInterpretedValue(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>A list of values that Amazon Lex V2 determines are possible resolutions for
     * the user input. The first value matches the <code>interpretedValue</code>.</p>
     */
    inline const Aws::Vector<Aws::String>& GetResolvedValues() const{ return m_resolvedValues; }
    inline bool ResolvedValuesHasBeenSet() const { return m_resolvedValuesHasBeenSet; }
    inline void SetResolvedValues(const Aws::Vector<Aws::String>& value) { m_resolvedValuesHasBeenSet = true; m_resolvedValues = value; }
    inline void SetResolvedValues(Aws::Vector<Aws::String>&& value) { m_resolvedValuesHasBeenSet = true; m_resolvedValues = std::move(value); }
    inline Value& WithResolvedValues(const Aws::Vector<Aws::String>& value) { SetResolvedValues(value); return *this;}
    inline Value& WithResolvedValues(Aws::Vector<Aws::String>&& value) { SetResolvedValues(std::move(value)); return *this;}
    inline Value& AddResolvedValues(const Aws::String& value) { m_resolvedValuesHasBeenSet = true; m_resolvedValues.push_back(value); return *this; }
    inline Value& AddResolvedValues(Aws::String&& value) { m_resolvedValuesHasBeenSet = true; m_resolvedValues.push_back(std::move(value)); return *this; }
    inline Value& AddResolvedValues(const char* value) { m_resolvedValuesHasBeenSet = true; m_resolvedValues.push_back(value); return *this; }
    ///@}
  private:

    Aws::String m_originalValue;
    bool m_originalValueHasBeenSet = false;

    Aws::String m_interpretedValue;
    bool m_interpretedValueHasBeenSet = false;

    Aws::Vector<Aws::String> m_resolvedValues;
    bool m_resolvedValuesHasBeenSet = false;
  };

} // namespace Model
} // namespace LexRuntimeV2
} // namespace Aws
