﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/kinesisanalyticsv2/model/ListApplicationOperationsRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::KinesisAnalyticsV2::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

ListApplicationOperationsRequest::ListApplicationOperationsRequest() : 
    m_applicationNameHasBeenSet(false),
    m_limit(0),
    m_limitHasBeenSet(false),
    m_nextTokenHasBeenSet(false),
    m_operationHasBeenSet(false),
    m_operationStatus(OperationStatus::NOT_SET),
    m_operationStatusHasBeenSet(false)
{
}

Aws::String ListApplicationOperationsRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_applicationNameHasBeenSet)
  {
   payload.WithString("ApplicationName", m_applicationName);

  }

  if(m_limitHasBeenSet)
  {
   payload.WithInteger("Limit", m_limit);

  }

  if(m_nextTokenHasBeenSet)
  {
   payload.WithString("NextToken", m_nextToken);

  }

  if(m_operationHasBeenSet)
  {
   payload.WithString("Operation", m_operation);

  }

  if(m_operationStatusHasBeenSet)
  {
   payload.WithString("OperationStatus", OperationStatusMapper::GetNameForOperationStatus(m_operationStatus));
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection ListApplicationOperationsRequest::GetRequestSpecificHeaders() const
{
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "KinesisAnalytics_20180523.ListApplicationOperations"));
  return headers;

}




