﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/inspector2/Inspector2_EXPORTS.h>
#include <aws/core/utils/DateTime.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace Inspector2
{
namespace Model
{

  /**
   * <p>The details of an exploit available for a finding discovered in your
   * environment.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ExploitabilityDetails">AWS
   * API Reference</a></p>
   */
  class ExploitabilityDetails
  {
  public:
    AWS_INSPECTOR2_API ExploitabilityDetails();
    AWS_INSPECTOR2_API ExploitabilityDetails(Aws::Utils::Json::JsonView jsonValue);
    AWS_INSPECTOR2_API ExploitabilityDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_INSPECTOR2_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The date and time of the last exploit associated with a finding discovered in
     * your environment.</p>
     */
    inline const Aws::Utils::DateTime& GetLastKnownExploitAt() const{ return m_lastKnownExploitAt; }
    inline bool LastKnownExploitAtHasBeenSet() const { return m_lastKnownExploitAtHasBeenSet; }
    inline void SetLastKnownExploitAt(const Aws::Utils::DateTime& value) { m_lastKnownExploitAtHasBeenSet = true; m_lastKnownExploitAt = value; }
    inline void SetLastKnownExploitAt(Aws::Utils::DateTime&& value) { m_lastKnownExploitAtHasBeenSet = true; m_lastKnownExploitAt = std::move(value); }
    inline ExploitabilityDetails& WithLastKnownExploitAt(const Aws::Utils::DateTime& value) { SetLastKnownExploitAt(value); return *this;}
    inline ExploitabilityDetails& WithLastKnownExploitAt(Aws::Utils::DateTime&& value) { SetLastKnownExploitAt(std::move(value)); return *this;}
    ///@}
  private:

    Aws::Utils::DateTime m_lastKnownExploitAt;
    bool m_lastKnownExploitAtHasBeenSet = false;
  };

} // namespace Model
} // namespace Inspector2
} // namespace Aws
