﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/guardduty/model/ListMalwareProtectionPlansResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::GuardDuty::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListMalwareProtectionPlansResult::ListMalwareProtectionPlansResult()
{
}

ListMalwareProtectionPlansResult::ListMalwareProtectionPlansResult(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  *this = result;
}

ListMalwareProtectionPlansResult& ListMalwareProtectionPlansResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("malwareProtectionPlans"))
  {
    Aws::Utils::Array<JsonView> malwareProtectionPlansJsonList = jsonValue.GetArray("malwareProtectionPlans");
    for(unsigned malwareProtectionPlansIndex = 0; malwareProtectionPlansIndex < malwareProtectionPlansJsonList.GetLength(); ++malwareProtectionPlansIndex)
    {
      m_malwareProtectionPlans.push_back(malwareProtectionPlansJsonList[malwareProtectionPlansIndex].AsObject());
    }
  }

  if(jsonValue.ValueExists("nextToken"))
  {
    m_nextToken = jsonValue.GetString("nextToken");

  }


  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if(requestIdIter != headers.end())
  {
    m_requestId = requestIdIter->second;
  }


  return *this;
}
