﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/glue/model/DescribeEntityRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Glue::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

DescribeEntityRequest::DescribeEntityRequest() : 
    m_connectionNameHasBeenSet(false),
    m_catalogIdHasBeenSet(false),
    m_entityNameHasBeenSet(false),
    m_nextTokenHasBeenSet(false),
    m_dataStoreApiVersionHasBeenSet(false)
{
}

Aws::String DescribeEntityRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_connectionNameHasBeenSet)
  {
   payload.WithString("ConnectionName", m_connectionName);

  }

  if(m_catalogIdHasBeenSet)
  {
   payload.WithString("CatalogId", m_catalogId);

  }

  if(m_entityNameHasBeenSet)
  {
   payload.WithString("EntityName", m_entityName);

  }

  if(m_nextTokenHasBeenSet)
  {
   payload.WithString("NextToken", m_nextToken);

  }

  if(m_dataStoreApiVersionHasBeenSet)
  {
   payload.WithString("DataStoreApiVersion", m_dataStoreApiVersion);

  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DescribeEntityRequest::GetRequestSpecificHeaders() const
{
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSGlue.DescribeEntity"));
  return headers;

}




