﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/geo-routes/model/WaypointOptimizationOriginOptions.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace GeoRoutes
{
namespace Model
{

WaypointOptimizationOriginOptions::WaypointOptimizationOriginOptions() : 
    m_idHasBeenSet(false)
{
}

WaypointOptimizationOriginOptions::WaypointOptimizationOriginOptions(JsonView jsonValue)
  : WaypointOptimizationOriginOptions()
{
  *this = jsonValue;
}

WaypointOptimizationOriginOptions& WaypointOptimizationOriginOptions::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("Id"))
  {
    m_id = jsonValue.GetString("Id");

    m_idHasBeenSet = true;
  }

  return *this;
}

JsonValue WaypointOptimizationOriginOptions::Jsonize() const
{
  JsonValue payload;

  if(m_idHasBeenSet)
  {
   payload.WithString("Id", m_id);

  }

  return payload;
}

} // namespace Model
} // namespace GeoRoutes
} // namespace Aws
