﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/finspace/model/CodeConfiguration.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace finspace
{
namespace Model
{

CodeConfiguration::CodeConfiguration() : 
    m_s3BucketHasBeenSet(false),
    m_s3KeyHasBeenSet(false),
    m_s3ObjectVersionHasBeenSet(false)
{
}

CodeConfiguration::CodeConfiguration(JsonView jsonValue)
  : CodeConfiguration()
{
  *this = jsonValue;
}

CodeConfiguration& CodeConfiguration::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("s3Bucket"))
  {
    m_s3Bucket = jsonValue.GetString("s3Bucket");

    m_s3BucketHasBeenSet = true;
  }

  if(jsonValue.ValueExists("s3Key"))
  {
    m_s3Key = jsonValue.GetString("s3Key");

    m_s3KeyHasBeenSet = true;
  }

  if(jsonValue.ValueExists("s3ObjectVersion"))
  {
    m_s3ObjectVersion = jsonValue.GetString("s3ObjectVersion");

    m_s3ObjectVersionHasBeenSet = true;
  }

  return *this;
}

JsonValue CodeConfiguration::Jsonize() const
{
  JsonValue payload;

  if(m_s3BucketHasBeenSet)
  {
   payload.WithString("s3Bucket", m_s3Bucket);

  }

  if(m_s3KeyHasBeenSet)
  {
   payload.WithString("s3Key", m_s3Key);

  }

  if(m_s3ObjectVersionHasBeenSet)
  {
   payload.WithString("s3ObjectVersion", m_s3ObjectVersion);

  }

  return payload;
}

} // namespace Model
} // namespace finspace
} // namespace Aws
