﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/emr-serverless/model/GetJobRunRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/http/URI.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::EMRServerless::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

GetJobRunRequest::GetJobRunRequest() : 
    m_applicationIdHasBeenSet(false),
    m_jobRunIdHasBeenSet(false),
    m_attempt(0),
    m_attemptHasBeenSet(false)
{
}

Aws::String GetJobRunRequest::SerializePayload() const
{
  return {};
}

void GetJobRunRequest::AddQueryStringParameters(URI& uri) const
{
    Aws::StringStream ss;
    if(m_attemptHasBeenSet)
    {
      ss << m_attempt;
      uri.AddQueryStringParameter("attempt", ss.str());
      ss.str("");
    }

}



