﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/elasticloadbalancingv2/model/ZonalCapacityReservationState.h>
#include <aws/core/utils/xml/XmlSerializer.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::Utils::Xml;
using namespace Aws::Utils;

namespace Aws
{
namespace ElasticLoadBalancingv2
{
namespace Model
{

ZonalCapacityReservationState::ZonalCapacityReservationState() : 
    m_stateHasBeenSet(false),
    m_availabilityZoneHasBeenSet(false),
    m_effectiveCapacityUnits(0.0),
    m_effectiveCapacityUnitsHasBeenSet(false)
{
}

ZonalCapacityReservationState::ZonalCapacityReservationState(const XmlNode& xmlNode)
  : ZonalCapacityReservationState()
{
  *this = xmlNode;
}

ZonalCapacityReservationState& ZonalCapacityReservationState::operator =(const XmlNode& xmlNode)
{
  XmlNode resultNode = xmlNode;

  if(!resultNode.IsNull())
  {
    XmlNode stateNode = resultNode.FirstChild("State");
    if(!stateNode.IsNull())
    {
      m_state = stateNode;
      m_stateHasBeenSet = true;
    }
    XmlNode availabilityZoneNode = resultNode.FirstChild("AvailabilityZone");
    if(!availabilityZoneNode.IsNull())
    {
      m_availabilityZone = Aws::Utils::Xml::DecodeEscapedXmlText(availabilityZoneNode.GetText());
      m_availabilityZoneHasBeenSet = true;
    }
    XmlNode effectiveCapacityUnitsNode = resultNode.FirstChild("EffectiveCapacityUnits");
    if(!effectiveCapacityUnitsNode.IsNull())
    {
      m_effectiveCapacityUnits = StringUtils::ConvertToDouble(StringUtils::Trim(Aws::Utils::Xml::DecodeEscapedXmlText(effectiveCapacityUnitsNode.GetText()).c_str()).c_str());
      m_effectiveCapacityUnitsHasBeenSet = true;
    }
  }

  return *this;
}

void ZonalCapacityReservationState::OutputToStream(Aws::OStream& oStream, const char* location, unsigned index, const char* locationValue) const
{
  if(m_stateHasBeenSet)
  {
      Aws::StringStream stateLocationAndMemberSs;
      stateLocationAndMemberSs << location << index << locationValue << ".State";
      m_state.OutputToStream(oStream, stateLocationAndMemberSs.str().c_str());
  }

  if(m_availabilityZoneHasBeenSet)
  {
      oStream << location << index << locationValue << ".AvailabilityZone=" << StringUtils::URLEncode(m_availabilityZone.c_str()) << "&";
  }

  if(m_effectiveCapacityUnitsHasBeenSet)
  {
        oStream << location << index << locationValue << ".EffectiveCapacityUnits=" << StringUtils::URLEncode(m_effectiveCapacityUnits) << "&";
  }

}

void ZonalCapacityReservationState::OutputToStream(Aws::OStream& oStream, const char* location) const
{
  if(m_stateHasBeenSet)
  {
      Aws::String stateLocationAndMember(location);
      stateLocationAndMember += ".State";
      m_state.OutputToStream(oStream, stateLocationAndMember.c_str());
  }
  if(m_availabilityZoneHasBeenSet)
  {
      oStream << location << ".AvailabilityZone=" << StringUtils::URLEncode(m_availabilityZone.c_str()) << "&";
  }
  if(m_effectiveCapacityUnitsHasBeenSet)
  {
        oStream << location << ".EffectiveCapacityUnits=" << StringUtils::URLEncode(m_effectiveCapacityUnits) << "&";
  }
}

} // namespace Model
} // namespace ElasticLoadBalancingv2
} // namespace Aws
