﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/elasticache/model/CreateUserGroupRequest.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

using namespace Aws::ElastiCache::Model;
using namespace Aws::Utils;

CreateUserGroupRequest::CreateUserGroupRequest() : 
    m_userGroupIdHasBeenSet(false),
    m_engineHasBeenSet(false),
    m_userIdsHasBeenSet(false),
    m_tagsHasBeenSet(false)
{
}

Aws::String CreateUserGroupRequest::SerializePayload() const
{
  Aws::StringStream ss;
  ss << "Action=CreateUserGroup&";
  if(m_userGroupIdHasBeenSet)
  {
    ss << "UserGroupId=" << StringUtils::URLEncode(m_userGroupId.c_str()) << "&";
  }

  if(m_engineHasBeenSet)
  {
    ss << "Engine=" << StringUtils::URLEncode(m_engine.c_str()) << "&";
  }

  if(m_userIdsHasBeenSet)
  {
    if (m_userIds.empty())
    {
      ss << "UserIds=&";
    }
    else
    {
      unsigned userIdsCount = 1;
      for(auto& item : m_userIds)
      {
        ss << "UserIds.member." << userIdsCount << "="
            << StringUtils::URLEncode(item.c_str()) << "&";
        userIdsCount++;
      }
    }
  }

  if(m_tagsHasBeenSet)
  {
    if (m_tags.empty())
    {
      ss << "Tags=&";
    }
    else
    {
      unsigned tagsCount = 1;
      for(auto& item : m_tags)
      {
        item.OutputToStream(ss, "Tags.member.", tagsCount, "");
        tagsCount++;
      }
    }
  }

  ss << "Version=2015-02-02";
  return ss.str();
}


void  CreateUserGroupRequest::DumpBodyToUrl(Aws::Http::URI& uri ) const
{
  uri.SetQueryString(SerializePayload());
}
