﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/ssm-incidents/model/CreateReplicationSetRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::SSMIncidents::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

CreateReplicationSetRequest::CreateReplicationSetRequest() : 
    m_clientToken(Aws::Utils::UUID::RandomUUID()),
    m_clientTokenHasBeenSet(true),
    m_regionsHasBeenSet(false)
{
}

Aws::String CreateReplicationSetRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_clientTokenHasBeenSet)
  {
   payload.WithString("clientToken", m_clientToken);

  }

  if(m_regionsHasBeenSet)
  {
   JsonValue regionsJsonMap;
   for(auto& regionsItem : m_regions)
   {
     regionsJsonMap.WithObject(regionsItem.first, regionsItem.second.Jsonize());
   }
   payload.WithObject("regions", std::move(regionsJsonMap));

  }

  return payload.View().WriteReadable();
}




