﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/s3control/model/ListMultiRegionAccessPointsResult.h>
#include <aws/core/utils/xml/XmlSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>

#include <utility>

using namespace Aws::S3Control::Model;
using namespace Aws::Utils::Xml;
using namespace Aws::Utils;
using namespace Aws;

ListMultiRegionAccessPointsResult::ListMultiRegionAccessPointsResult()
{
}

ListMultiRegionAccessPointsResult::ListMultiRegionAccessPointsResult(const Aws::AmazonWebServiceResult<XmlDocument>& result)
{
  *this = result;
}

ListMultiRegionAccessPointsResult& ListMultiRegionAccessPointsResult::operator =(const Aws::AmazonWebServiceResult<XmlDocument>& result)
{
  const XmlDocument& xmlDocument = result.GetPayload();
  XmlNode resultNode = xmlDocument.GetRootElement();

  if(!resultNode.IsNull())
  {
    XmlNode accessPointsNode = resultNode.FirstChild("AccessPoints");
    if(!accessPointsNode.IsNull())
    {
      XmlNode accessPointsMember = accessPointsNode.FirstChild("AccessPoint");
      while(!accessPointsMember.IsNull())
      {
        m_accessPoints.push_back(accessPointsMember);
        accessPointsMember = accessPointsMember.NextNode("AccessPoint");
      }

    }
    XmlNode nextTokenNode = resultNode.FirstChild("NextToken");
    if(!nextTokenNode.IsNull())
    {
      m_nextToken = Aws::Utils::Xml::DecodeEscapedXmlText(nextTokenNode.GetText());
    }
  }

  return *this;
}
