﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/redshift-data/model/ListStatementsRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::RedshiftDataAPIService::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

ListStatementsRequest::ListStatementsRequest() : 
    m_maxResults(0),
    m_maxResultsHasBeenSet(false),
    m_nextTokenHasBeenSet(false),
    m_roleLevel(false),
    m_roleLevelHasBeenSet(false),
    m_statementNameHasBeenSet(false),
    m_status(StatusString::NOT_SET),
    m_statusHasBeenSet(false)
{
}

Aws::String ListStatementsRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_maxResultsHasBeenSet)
  {
   payload.WithInteger("MaxResults", m_maxResults);

  }

  if(m_nextTokenHasBeenSet)
  {
   payload.WithString("NextToken", m_nextToken);

  }

  if(m_roleLevelHasBeenSet)
  {
   payload.WithBool("RoleLevel", m_roleLevel);

  }

  if(m_statementNameHasBeenSet)
  {
   payload.WithString("StatementName", m_statementName);

  }

  if(m_statusHasBeenSet)
  {
   payload.WithString("Status", StatusStringMapper::GetNameForStatusString(m_status));
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection ListStatementsRequest::GetRequestSpecificHeaders() const
{
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "RedshiftData.ListStatements"));
  return headers;

}




