﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/nimble/model/GetLaunchProfileInitializationResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>

#include <utility>

using namespace Aws::NimbleStudio::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

GetLaunchProfileInitializationResult::GetLaunchProfileInitializationResult()
{
}

GetLaunchProfileInitializationResult::GetLaunchProfileInitializationResult(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  *this = result;
}

GetLaunchProfileInitializationResult& GetLaunchProfileInitializationResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("launchProfileInitialization"))
  {
    m_launchProfileInitialization = jsonValue.GetObject("launchProfileInitialization");

  }



  return *this;
}
