﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/iotsitewise/model/BatchGetAssetPropertyAggregatesResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>

#include <utility>

using namespace Aws::IoTSiteWise::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

BatchGetAssetPropertyAggregatesResult::BatchGetAssetPropertyAggregatesResult()
{
}

BatchGetAssetPropertyAggregatesResult::BatchGetAssetPropertyAggregatesResult(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  *this = result;
}

BatchGetAssetPropertyAggregatesResult& BatchGetAssetPropertyAggregatesResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("errorEntries"))
  {
    Array<JsonView> errorEntriesJsonList = jsonValue.GetArray("errorEntries");
    for(unsigned errorEntriesIndex = 0; errorEntriesIndex < errorEntriesJsonList.GetLength(); ++errorEntriesIndex)
    {
      m_errorEntries.push_back(errorEntriesJsonList[errorEntriesIndex].AsObject());
    }
  }

  if(jsonValue.ValueExists("successEntries"))
  {
    Array<JsonView> successEntriesJsonList = jsonValue.GetArray("successEntries");
    for(unsigned successEntriesIndex = 0; successEntriesIndex < successEntriesJsonList.GetLength(); ++successEntriesIndex)
    {
      m_successEntries.push_back(successEntriesJsonList[successEntriesIndex].AsObject());
    }
  }

  if(jsonValue.ValueExists("skippedEntries"))
  {
    Array<JsonView> skippedEntriesJsonList = jsonValue.GetArray("skippedEntries");
    for(unsigned skippedEntriesIndex = 0; skippedEntriesIndex < skippedEntriesJsonList.GetLength(); ++skippedEntriesIndex)
    {
      m_skippedEntries.push_back(skippedEntriesJsonList[skippedEntriesIndex].AsObject());
    }
  }

  if(jsonValue.ValueExists("nextToken"))
  {
    m_nextToken = jsonValue.GetString("nextToken");

  }



  return *this;
}
