﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/model/ScanEc2InstanceWithFindingsResult.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace GuardDuty
{
namespace Model
{

  /**
   * <p>An object that contains information on the status of all Malware Protection
   * data sources.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/MalwareProtectionConfigurationResult">AWS
   * API Reference</a></p>
   */
  class AWS_GUARDDUTY_API MalwareProtectionConfigurationResult
  {
  public:
    MalwareProtectionConfigurationResult();
    MalwareProtectionConfigurationResult(Aws::Utils::Json::JsonView jsonValue);
    MalwareProtectionConfigurationResult& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>Describes the configuration of Malware Protection for EC2 instances with
     * findings.</p>
     */
    inline const ScanEc2InstanceWithFindingsResult& GetScanEc2InstanceWithFindings() const{ return m_scanEc2InstanceWithFindings; }

    /**
     * <p>Describes the configuration of Malware Protection for EC2 instances with
     * findings.</p>
     */
    inline bool ScanEc2InstanceWithFindingsHasBeenSet() const { return m_scanEc2InstanceWithFindingsHasBeenSet; }

    /**
     * <p>Describes the configuration of Malware Protection for EC2 instances with
     * findings.</p>
     */
    inline void SetScanEc2InstanceWithFindings(const ScanEc2InstanceWithFindingsResult& value) { m_scanEc2InstanceWithFindingsHasBeenSet = true; m_scanEc2InstanceWithFindings = value; }

    /**
     * <p>Describes the configuration of Malware Protection for EC2 instances with
     * findings.</p>
     */
    inline void SetScanEc2InstanceWithFindings(ScanEc2InstanceWithFindingsResult&& value) { m_scanEc2InstanceWithFindingsHasBeenSet = true; m_scanEc2InstanceWithFindings = std::move(value); }

    /**
     * <p>Describes the configuration of Malware Protection for EC2 instances with
     * findings.</p>
     */
    inline MalwareProtectionConfigurationResult& WithScanEc2InstanceWithFindings(const ScanEc2InstanceWithFindingsResult& value) { SetScanEc2InstanceWithFindings(value); return *this;}

    /**
     * <p>Describes the configuration of Malware Protection for EC2 instances with
     * findings.</p>
     */
    inline MalwareProtectionConfigurationResult& WithScanEc2InstanceWithFindings(ScanEc2InstanceWithFindingsResult&& value) { SetScanEc2InstanceWithFindings(std::move(value)); return *this;}


    /**
     * <p>The GuardDuty Malware Protection service role.</p>
     */
    inline const Aws::String& GetServiceRole() const{ return m_serviceRole; }

    /**
     * <p>The GuardDuty Malware Protection service role.</p>
     */
    inline bool ServiceRoleHasBeenSet() const { return m_serviceRoleHasBeenSet; }

    /**
     * <p>The GuardDuty Malware Protection service role.</p>
     */
    inline void SetServiceRole(const Aws::String& value) { m_serviceRoleHasBeenSet = true; m_serviceRole = value; }

    /**
     * <p>The GuardDuty Malware Protection service role.</p>
     */
    inline void SetServiceRole(Aws::String&& value) { m_serviceRoleHasBeenSet = true; m_serviceRole = std::move(value); }

    /**
     * <p>The GuardDuty Malware Protection service role.</p>
     */
    inline void SetServiceRole(const char* value) { m_serviceRoleHasBeenSet = true; m_serviceRole.assign(value); }

    /**
     * <p>The GuardDuty Malware Protection service role.</p>
     */
    inline MalwareProtectionConfigurationResult& WithServiceRole(const Aws::String& value) { SetServiceRole(value); return *this;}

    /**
     * <p>The GuardDuty Malware Protection service role.</p>
     */
    inline MalwareProtectionConfigurationResult& WithServiceRole(Aws::String&& value) { SetServiceRole(std::move(value)); return *this;}

    /**
     * <p>The GuardDuty Malware Protection service role.</p>
     */
    inline MalwareProtectionConfigurationResult& WithServiceRole(const char* value) { SetServiceRole(value); return *this;}

  private:

    ScanEc2InstanceWithFindingsResult m_scanEc2InstanceWithFindings;
    bool m_scanEc2InstanceWithFindingsHasBeenSet;

    Aws::String m_serviceRole;
    bool m_serviceRoleHasBeenSet;
  };

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
