/*
 * ControlService.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2025 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifdef FLOW_GRPC_ENABLED
#include <fmt/format.h>
#include <chrono>

#include "fdbctl/ControlService.h"

namespace fdbctl {

using namespace std::chrono_literals;

ControlServiceImpl::ControlServiceImpl(Reference<IDatabase> db) : Service(), db_(db) {}

} // namespace fdbctl
#endif // FLOW_GRPC_ENABLED
