# -*- mode: ruby; -*-

Gem::Specification.new do |s|
  s.name = 'fdb'
  s.version = '7.4.0'
  s.date = Time.new.strftime '%Y-%m-%d'
  s.summary = "Ruby bindings for the FoundationDB database"
  s.description = <<-EOF
Ruby bindings for the FoundationDB database.

Complete documentation of the FoundationDB Ruby API can be found at:
https://apple.github.io/foundationdb/api-ruby.html.
EOF
  s.authors = ["FoundationDB"]
  s.email = 'fdb-dist@apple.com'
  s.files = ["LICENSE", "lib/fdb.rb", "lib/fdbdirectory.rb", "lib/fdbimpl.rb", "lib/fdblocality.rb", "lib/fdboptions.rb", "lib/fdbsubspace.rb", "lib/fdbtuple.rb", "lib/fdbimpl_v609.rb"]
  s.homepage = 'https://www.foundationdb.org'
  s.license = 'Apache-2.0'
  s.add_dependency('ffi', '~> 1.1', '>= 1.1.5')
  s.required_ruby_version = '>= 1.9.3'
  s.requirements << 'These bindings require the FoundationDB client. The client can be obtained from https://github.com/apple/foundationdb/releases'
end
