/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.tuple;

import com.apple.foundationdb.FDB;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.IterableComparator;
import com.apple.foundationdb.tuple.StringUtil;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.Versionstamp;
import java.math.BigInteger;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

class TupleUtil {
    private static final byte nil = 0;
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final BigInteger LONG_MIN_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    private static final int UUID_BYTES = 16;
    private static final IterableComparator iterableComparator = new IterableComparator();
    private static final byte BYTES_CODE = 1;
    private static final byte STRING_CODE = 2;
    private static final byte NESTED_CODE = 5;
    private static final byte INT_ZERO_CODE = 20;
    private static final byte POS_INT_END = 29;
    private static final byte NEG_INT_START = 11;
    private static final byte FLOAT_CODE = 32;
    private static final byte DOUBLE_CODE = 33;
    private static final byte FALSE_CODE = 38;
    private static final byte TRUE_CODE = 39;
    private static final byte UUID_CODE = 48;
    private static final byte VERSIONSTAMP_CODE = 51;
    private static final byte[] NULL_ARR = new byte[]{0};
    private static final byte[] NULL_ESCAPED_ARR = new byte[]{0, -1};

    private static boolean useOldVersionOffsetFormat() {
        return FDB.instance().getAPIVersion() < 520;
    }

    private static int encodeFloatBits(float f) {
        int n = Float.floatToRawIntBits(f);
        return n < 0 ? ~n : n ^ Integer.MIN_VALUE;
    }

    private static long encodeDoubleBits(double d) {
        long l = Double.doubleToRawLongBits(d);
        return l < 0L ? l ^ 0xFFFFFFFFFFFFFFFFL : l ^ Long.MIN_VALUE;
    }

    private static float decodeFloatBits(int n) {
        int n2 = n >= 0 ? ~n : n ^ Integer.MIN_VALUE;
        return Float.intBitsToFloat(n2);
    }

    private static double decodeDoubleBits(long l) {
        long l2 = l >= 0L ? l ^ 0xFFFFFFFFFFFFFFFFL : l ^ Long.MIN_VALUE;
        return Double.longBitsToDouble(l2);
    }

    private static int minimalByteCount(long l) {
        return (71 - Long.numberOfLeadingZeros(l >= 0L ? l : -l)) / 8;
    }

    private static int minimalByteCount(BigInteger bigInteger) {
        int n = bigInteger.compareTo(BigInteger.ZERO) >= 0 ? bigInteger.bitLength() : bigInteger.negate().bitLength();
        return (n + 7) / 8;
    }

    private static void adjustVersionPosition300(byte[] byArray, int n) {
        int n2 = byArray.length - 2;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, 2).order(ByteOrder.LITTLE_ENDIAN);
        int n3 = byteBuffer.getShort() + n;
        if (n3 > 65535) {
            throw new IllegalArgumentException("Tuple has incomplete version at position " + n3 + " which is greater than the maximum " + 65535);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Tuple has an incomplete version at a negative position");
        }
        byteBuffer.position(n2);
        byteBuffer.putShort((short)n3);
    }

    private static void adjustVersionPosition520(byte[] byArray, int n) {
        int n2 = byArray.length - 4;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, 4).order(ByteOrder.LITTLE_ENDIAN);
        int n3 = byteBuffer.getInt() + n;
        if (n3 < 0) {
            throw new IllegalArgumentException("Tuple has an incomplete version at a negative position");
        }
        byteBuffer.position(n2);
        byteBuffer.putInt(n3);
    }

    static void adjustVersionPosition(byte[] byArray, int n) {
        if (TupleUtil.useOldVersionOffsetFormat()) {
            TupleUtil.adjustVersionPosition300(byArray, n);
        } else {
            TupleUtil.adjustVersionPosition520(byArray, n);
        }
    }

    static int getCodeFor(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof byte[]) {
            return 1;
        }
        if (object instanceof String) {
            return 2;
        }
        if (object instanceof Float) {
            return 32;
        }
        if (object instanceof Double) {
            return 33;
        }
        if (object instanceof Boolean) {
            return 38;
        }
        if (object instanceof UUID) {
            return 48;
        }
        if (object instanceof Number) {
            return 20;
        }
        if (object instanceof Versionstamp) {
            return 51;
        }
        if (object instanceof List) {
            return 5;
        }
        if (object instanceof Tuple) {
            return 5;
        }
        throw new IllegalArgumentException("Unsupported data type: " + object.getClass().getName());
    }

    static void encode(EncodeState encodeState, Object object, boolean bl) {
        if (object == null) {
            if (bl) {
                encodeState.add(NULL_ESCAPED_ARR);
            } else {
                encodeState.add((byte)0);
            }
        } else if (object instanceof byte[]) {
            TupleUtil.encode(encodeState, (byte[])object);
        } else if (object instanceof String) {
            TupleUtil.encode(encodeState, (String)object);
        } else if (object instanceof Float) {
            TupleUtil.encode(encodeState, (Float)object);
        } else if (object instanceof Double) {
            TupleUtil.encode(encodeState, (Double)object);
        } else if (object instanceof Boolean) {
            TupleUtil.encode(encodeState, (Boolean)object);
        } else if (object instanceof UUID) {
            TupleUtil.encode(encodeState, (UUID)object);
        } else if (object instanceof BigInteger) {
            TupleUtil.encode(encodeState, (BigInteger)object);
        } else if (object instanceof Number) {
            TupleUtil.encode(encodeState, ((Number)object).longValue());
        } else if (object instanceof Versionstamp) {
            TupleUtil.encode(encodeState, (Versionstamp)object);
        } else if (object instanceof List) {
            TupleUtil.encode(encodeState, (List)object);
        } else if (object instanceof Tuple) {
            TupleUtil.encode(encodeState, (Tuple)object);
        } else {
            throw new IllegalArgumentException("Unsupported data type: " + object.getClass().getName());
        }
    }

    static void encode(EncodeState encodeState, Object object) {
        TupleUtil.encode(encodeState, object, false);
    }

    static void encode(EncodeState encodeState, byte[] byArray) {
        encodeState.add((byte)1).addNullEscaped(byArray).add((byte)0);
    }

    static void encode(EncodeState encodeState, String string) {
        StringUtil.validate(string);
        byte[] byArray = string.getBytes(UTF8);
        encodeState.add((byte)2).addNullEscaped(byArray).add((byte)0);
    }

    static void encode(EncodeState encodeState, BigInteger bigInteger) {
        if (bigInteger.equals(BigInteger.ZERO)) {
            encodeState.add((byte)20);
            return;
        }
        int n = TupleUtil.minimalByteCount(bigInteger);
        if (n > 255) {
            throw new IllegalArgumentException("BigInteger magnitude is too large (more than 255 bytes)");
        }
        if (bigInteger.compareTo(BigInteger.ZERO) > 0) {
            byte[] byArray = bigInteger.toByteArray();
            if (n > 8) {
                encodeState.add((byte)29);
                encodeState.add((byte)n);
                encodeState.add(byArray, byArray.length - n, n);
            } else {
                encodeState.add((byte)(20 + n));
                encodeState.add(byArray, byArray.length - n, n);
            }
        } else {
            byte[] byArray = bigInteger.subtract(BigInteger.ONE).toByteArray();
            if (n > 8) {
                encodeState.add((byte)11);
                encodeState.add((byte)(n ^ 0xFF));
                if (byArray.length >= n) {
                    encodeState.add(byArray, byArray.length - n, n);
                } else {
                    for (int i = 0; i < n - byArray.length; ++i) {
                        encodeState.add((byte)0);
                    }
                    encodeState.add(byArray, 0, byArray.length);
                }
            } else {
                encodeState.add((byte)(20 - n));
                if (byArray.length >= n) {
                    encodeState.add(byArray, byArray.length - n, n);
                } else {
                    for (int i = 0; i < n - byArray.length; ++i) {
                        encodeState.add((byte)0);
                    }
                    encodeState.add(byArray, 0, byArray.length);
                }
            }
        }
    }

    static void encode(EncodeState encodeState, long l) {
        if (l == 0L) {
            encodeState.add((byte)20);
            return;
        }
        int n = TupleUtil.minimalByteCount(l);
        encodeState.add((byte)(20 + (l >= 0L ? n : -n)));
        long l2 = Long.reverseBytes(l >= 0L ? l : l - 1L) >> 64 - 8 * n;
        for (int i = 0; i < n; ++i) {
            encodeState.add((byte)(l2 & 0xFFL));
            l2 >>= 8;
        }
    }

    static void encode(EncodeState encodeState, Float f) {
        encodeState.add((byte)32).add(TupleUtil.encodeFloatBits(f.floatValue()));
    }

    static void encode(EncodeState encodeState, Double d) {
        encodeState.add((byte)33).add(TupleUtil.encodeDoubleBits(d));
    }

    static void encode(EncodeState encodeState, Boolean bl) {
        encodeState.add(bl != false ? (byte)39 : 38);
    }

    static void encode(EncodeState encodeState, UUID uUID) {
        encodeState.add((byte)48).add(uUID.getMostSignificantBits()).add(uUID.getLeastSignificantBits());
    }

    static void encode(EncodeState encodeState, Versionstamp versionstamp) {
        encodeState.add((byte)51);
        if (versionstamp.isComplete()) {
            encodeState.add(versionstamp.getBytes());
        } else {
            encodeState.add(versionstamp.getBytes(), encodeState.totalLength);
        }
    }

    static void encode(EncodeState encodeState, List<?> list) {
        encodeState.add((byte)5);
        for (Object obj : list) {
            TupleUtil.encode(encodeState, obj, true);
        }
        encodeState.add((byte)0);
    }

    static void encode(EncodeState encodeState, Tuple tuple) {
        TupleUtil.encode(encodeState, tuple.elements);
    }

    static void decode(DecodeState decodeState, byte[] byArray, int n, int n2) {
        byte by = byArray[n];
        int n3 = n + 1;
        if (by == 0) {
            decodeState.add(null, n3);
        } else if (by == 1) {
            byte[] byArray2;
            int n4 = decodeState.findNullTerminator(byArray, n3, n2);
            if (decodeState.nullCount == 0) {
                byArray2 = Arrays.copyOfRange(byArray, n3, n4);
            } else {
                ByteBuffer byteBuffer = ByteBuffer.allocate(n4 - n3 - decodeState.nullCount);
                ByteArrayUtil.replace(byArray, n3, n4 - n3, NULL_ESCAPED_ARR, NULL_ARR, byteBuffer);
                byArray2 = byteBuffer.array();
            }
            decodeState.add(byArray2, n4 + 1);
        } else if (by == 2) {
            String string;
            ByteBuffer byteBuffer;
            int n5 = decodeState.findNullTerminator(byArray, n3, n2);
            if (decodeState.nullCount == 0) {
                byteBuffer = ByteBuffer.wrap(byArray, n3, n5 - n3);
            } else {
                byteBuffer = ByteBuffer.allocate(n5 - n3 - decodeState.nullCount);
                ByteArrayUtil.replace(byArray, n3, n5 - n3, NULL_ESCAPED_ARR, NULL_ARR, byteBuffer);
                byteBuffer.position(0);
            }
            try {
                CharsetDecoder charsetDecoder = UTF8.newDecoder().onMalformedInput(CodingErrorAction.REPORT);
                string = charsetDecoder.decode(byteBuffer).toString();
            }
            catch (CharacterCodingException characterCodingException) {
                throw new IllegalArgumentException("malformed UTF-8 string", characterCodingException);
            }
            decodeState.add(string, n5 + 1);
        } else if (by == 32) {
            int n6 = ByteBuffer.wrap(byArray, n3, 4).getInt();
            float f = TupleUtil.decodeFloatBits(n6);
            decodeState.add(Float.valueOf(f), n3 + 4);
        } else if (by == 33) {
            long l = ByteBuffer.wrap(byArray, n3, 8).getLong();
            double d = TupleUtil.decodeDoubleBits(l);
            decodeState.add(d, n3 + 8);
        } else if (by == 38) {
            decodeState.add(false, n3);
        } else if (by == 39) {
            decodeState.add(true, n3);
        } else if (by == 48) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n3, 16).order(ByteOrder.BIG_ENDIAN);
            long l = byteBuffer.getLong();
            long l2 = byteBuffer.getLong();
            decodeState.add(new UUID(l, l2), n3 + 16);
        } else if (by == 29) {
            int n7 = byArray[n3] & 0xFF;
            byte[] byArray3 = new byte[n7 + 1];
            System.arraycopy(byArray, n3 + 1, byArray3, 1, n7);
            BigInteger bigInteger = new BigInteger(byArray3);
            decodeState.add(bigInteger, n3 + n7 + 1);
        } else if (by == 11) {
            int n8 = (byArray[n3] ^ 0xFF) & 0xFF;
            byte[] byArray4 = new byte[n8 + 1];
            System.arraycopy(byArray, n3 + 1, byArray4, 1, n8);
            BigInteger bigInteger = new BigInteger(byArray4);
            BigInteger bigInteger2 = BigInteger.ONE.shiftLeft(n8 * 8).subtract(BigInteger.ONE);
            decodeState.add(bigInteger.subtract(bigInteger2), n3 + n8 + 1);
        } else if (by > 11 && by < 29) {
            boolean bl = by >= 20;
            int n9 = bl ? by - 20 : 20 - by;
            int n10 = n3 + n9;
            if (n2 < n10) {
                throw new IllegalArgumentException("Invalid tuple (possible truncation)");
            }
            if (bl && (n9 < 8 || byArray[n3] > 0)) {
                long l = 0L;
                for (int i = n3; i < n10; ++i) {
                    l = l << 8 | (long)(byArray[i] & 0xFF);
                }
                decodeState.add(l, n10);
            } else if (!(bl || n9 >= 8 && byArray[n3] >= 0)) {
                long l = -1L;
                for (int i = n3; i < n10; ++i) {
                    l = l << 8 | (long)(byArray[i] & 0xFF);
                }
                decodeState.add(l + 1L, n10);
            } else {
                byte[] byArray5 = new byte[9];
                System.arraycopy(byArray, n3, byArray5, byArray5.length - n9, n9);
                if (!bl) {
                    for (int i = byArray5.length - n9; i < byArray5.length; ++i) {
                        byArray5[i] = (byte)(byArray5[i] ^ 0xFF);
                    }
                }
                BigInteger bigInteger = new BigInteger(byArray5);
                if (!bl) {
                    bigInteger = bigInteger.negate();
                }
                if (bigInteger.compareTo(LONG_MIN_VALUE) >= 0 && bigInteger.compareTo(LONG_MAX_VALUE) <= 0) {
                    decodeState.add(bigInteger.longValue(), n10);
                } else {
                    decodeState.add(bigInteger, n10);
                }
            }
        } else if (by == 51) {
            if (n3 + 12 > n2) {
                throw new IllegalArgumentException("Invalid tuple (possible truncation)");
            }
            Versionstamp versionstamp = Versionstamp.fromBytes(Arrays.copyOfRange(byArray, n3, n3 + 12));
            decodeState.add(versionstamp, n3 + 12);
        } else if (by == 5) {
            DecodeState decodeState2 = new DecodeState();
            int n11 = n3;
            boolean bl = false;
            while (n11 < n2) {
                if (byArray[n11] == 0) {
                    if (n11 + 1 < n2 && byArray[n11 + 1] == -1) {
                        decodeState2.add(null, n11 + 2);
                        n11 += 2;
                        continue;
                    }
                    ++n11;
                    bl = true;
                    break;
                }
                TupleUtil.decode(decodeState2, byArray, n11, n2);
                n11 = decodeState2.end;
            }
            if (!bl) {
                throw new IllegalArgumentException("No terminator found for nested tuple starting at " + n3);
            }
            decodeState.add(decodeState2.values, n11);
        } else {
            throw new IllegalArgumentException("Unknown tuple data type " + by + " at index " + n);
        }
    }

    static int compareItems(Object object, Object object2) {
        int n;
        if (object == object2) {
            return 0;
        }
        int n2 = TupleUtil.getCodeFor(object);
        if (n2 != (n = TupleUtil.getCodeFor(object2))) {
            return Integer.compare(n2, n);
        }
        if (n2 == 0) {
            return 0;
        }
        if (n2 == 1) {
            return ByteArrayUtil.compareUnsigned((byte[])object, (byte[])object2);
        }
        if (n2 == 2) {
            return StringUtil.compareUtf8((String)object, (String)object2);
        }
        if (n2 == 20) {
            if (object instanceof Long && object2 instanceof Long) {
                return Long.compare((Long)object, (Long)object2);
            }
            BigInteger bigInteger = object instanceof BigInteger ? (BigInteger)object : BigInteger.valueOf(((Number)object).longValue());
            BigInteger bigInteger2 = object2 instanceof BigInteger ? (BigInteger)object2 : BigInteger.valueOf(((Number)object2).longValue());
            return bigInteger.compareTo(bigInteger2);
        }
        if (n2 == 32) {
            int n3 = TupleUtil.encodeFloatBits(((Float)object).floatValue());
            int n4 = TupleUtil.encodeFloatBits(((Float)object2).floatValue());
            return Integer.compareUnsigned(n3, n4);
        }
        if (n2 == 33) {
            long l = TupleUtil.encodeDoubleBits((Double)object);
            long l2 = TupleUtil.encodeDoubleBits((Double)object2);
            return Long.compareUnsigned(l, l2);
        }
        if (n2 == 38) {
            return Boolean.compare((Boolean)object, (Boolean)object2);
        }
        if (n2 == 48) {
            UUID uUID = (UUID)object;
            UUID uUID2 = (UUID)object2;
            int n5 = Long.compareUnsigned(uUID.getMostSignificantBits(), uUID2.getMostSignificantBits());
            if (n5 != 0) {
                return n5;
            }
            return Long.compareUnsigned(uUID.getLeastSignificantBits(), uUID2.getLeastSignificantBits());
        }
        if (n2 == 51) {
            return ((Versionstamp)object).compareTo((Versionstamp)object2);
        }
        if (n2 == 5) {
            return iterableComparator.compare((Iterable)object, (Iterable)object2);
        }
        throw new IllegalArgumentException("Unknown tuple data type: " + object.getClass());
    }

    static List<Object> unpack(byte[] byArray) {
        try {
            DecodeState decodeState = new DecodeState();
            int n = 0;
            int n2 = byArray.length;
            while (n < n2) {
                TupleUtil.decode(decodeState, byArray, n, n2);
                n = decodeState.end;
            }
            return decodeState.values;
        }
        catch (IndexOutOfBoundsException | BufferOverflowException runtimeException) {
            throw new IllegalArgumentException("Invalid tuple (possible truncation)", runtimeException);
        }
    }

    static void encodeAll(EncodeState encodeState, List<Object> list) {
        for (Object object : list) {
            TupleUtil.encode(encodeState, object);
        }
    }

    static void pack(ByteBuffer byteBuffer, List<Object> list) {
        ByteOrder byteOrder = byteBuffer.order();
        EncodeState encodeState = new EncodeState(byteBuffer);
        TupleUtil.encodeAll(encodeState, list);
        byteBuffer.order(byteOrder);
        if (encodeState.versionPos >= 0) {
            throw new IllegalArgumentException("Incomplete Versionstamp included in vanilla tuple pack");
        }
    }

    static byte[] pack(List<Object> list, int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        TupleUtil.pack(byteBuffer, list);
        return byteBuffer.array();
    }

    static byte[] packWithVersionstamp(List<Object> list, int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        EncodeState encodeState = new EncodeState(byteBuffer);
        TupleUtil.encodeAll(encodeState, list);
        if (encodeState.versionPos < 0) {
            throw new IllegalArgumentException("No incomplete Versionstamp included in tuple packInternal with versionstamp");
        }
        if (TupleUtil.useOldVersionOffsetFormat() && encodeState.versionPos > 65535) {
            throw new IllegalArgumentException("Tuple has incomplete version at position " + encodeState.versionPos + " which is greater than the maximum " + 65535);
        }
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        if (TupleUtil.useOldVersionOffsetFormat()) {
            byteBuffer.putShort((short)encodeState.versionPos);
        } else {
            byteBuffer.putInt(encodeState.versionPos);
        }
        return byteBuffer.array();
    }

    static int getPackedSize(List<?> list, boolean bl) {
        int n = 0;
        for (Object obj : list) {
            int n2;
            Object object;
            if (obj == null) {
                n += bl ? 2 : 1;
                continue;
            }
            if (obj instanceof byte[]) {
                object = (byte[])obj;
                n += 2 + ((byte[])object).length + ByteArrayUtil.nullCount((byte[])obj);
                continue;
            }
            if (obj instanceof String) {
                int n3 = StringUtil.packedSize((String)obj);
                n += 2 + n3;
                continue;
            }
            if (obj instanceof Float) {
                n += 5;
                continue;
            }
            if (obj instanceof Double) {
                n += 9;
                continue;
            }
            if (obj instanceof Boolean) {
                ++n;
                continue;
            }
            if (obj instanceof UUID) {
                n += 17;
                continue;
            }
            if (obj instanceof BigInteger) {
                object = (BigInteger)obj;
                n += n2 + ((n2 = TupleUtil.minimalByteCount((BigInteger)object)) <= 8 ? 1 : 2);
                continue;
            }
            if (obj instanceof Number) {
                n += 1 + TupleUtil.minimalByteCount(((Number)obj).longValue());
                continue;
            }
            if (obj instanceof Versionstamp) {
                n += 13;
                object = (Versionstamp)obj;
                if (((Versionstamp)object).isComplete()) continue;
                n2 = TupleUtil.useOldVersionOffsetFormat() ? 2 : 4;
                n += n2;
                continue;
            }
            if (obj instanceof List) {
                n += 2 + TupleUtil.getPackedSize((List)obj, true);
                continue;
            }
            if (obj instanceof Tuple) {
                n += 2 + ((Tuple)obj).getPackedSize(true);
                continue;
            }
            throw new IllegalArgumentException("unknown type " + obj.getClass() + " for tuple packing");
        }
        return n;
    }

    static boolean hasIncompleteVersionstamp(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            if (obj == null) continue;
            if (obj instanceof Versionstamp) {
                bl = !((Versionstamp)obj).isComplete();
            } else if (obj instanceof Tuple) {
                bl = TupleUtil.hasIncompleteVersionstamp(((Tuple)obj).getRawItems());
            } else if (obj instanceof Collection) {
                bl = TupleUtil.hasIncompleteVersionstamp((Collection)obj);
            }
            if (!bl) continue;
            return bl;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        DecodeState decodeState;
        byte[] byArray;
        try {
            byArray = TupleUtil.pack(Collections.singletonList(4), 2);
            decodeState = new DecodeState();
            TupleUtil.decode(decodeState, byArray, 0, byArray.length);
            int n = ((Number)decodeState.values.get(0)).intValue();
            assert (4 == n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error " + exception.getMessage());
        }
        try {
            byArray = TupleUtil.pack(Collections.singletonList("\u021aest \u0218tring"), 15);
            decodeState = new DecodeState();
            TupleUtil.decode(decodeState, byArray, 0, byArray.length);
            String string = (String)decodeState.values.get(0);
            System.out.println("contents -> " + string);
            assert ("\u021aest \u0218tring".equals(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error " + exception.getMessage());
        }
    }

    private TupleUtil() {
    }

    static class EncodeState {
        final ByteBuffer encodedBytes;
        int totalLength;
        int versionPos;

        EncodeState(ByteBuffer byteBuffer) {
            this.encodedBytes = byteBuffer;
            this.encodedBytes.order(ByteOrder.BIG_ENDIAN);
            this.totalLength = 0;
            this.versionPos = -1;
        }

        EncodeState add(byte[] byArray, int n) {
            if (n >= 0 && this.versionPos >= 0) {
                throw new IllegalArgumentException("Multiple incomplete Versionstamps included in Tuple");
            }
            this.encodedBytes.put(byArray);
            this.totalLength += byArray.length;
            this.versionPos = n;
            return this;
        }

        EncodeState add(byte[] byArray) {
            this.encodedBytes.put(byArray);
            this.totalLength += byArray.length;
            return this;
        }

        EncodeState add(byte[] byArray, int n, int n2) {
            this.encodedBytes.put(byArray, n, n2);
            this.totalLength += n2;
            return this;
        }

        EncodeState addNullEscaped(byte[] byArray) {
            int n = ByteArrayUtil.nullCount(byArray);
            if (n == 0) {
                this.encodedBytes.put(byArray);
            } else {
                ByteArrayUtil.replace(byArray, 0, byArray.length, NULL_ARR, NULL_ESCAPED_ARR, this.encodedBytes);
            }
            this.totalLength += byArray.length + n;
            return this;
        }

        EncodeState add(byte by) {
            this.encodedBytes.put(by);
            ++this.totalLength;
            return this;
        }

        EncodeState add(int n) {
            this.encodedBytes.putInt(n);
            this.totalLength += 4;
            return this;
        }

        EncodeState add(long l) {
            this.encodedBytes.putLong(l);
            this.totalLength += 8;
            return this;
        }
    }

    static class DecodeState {
        final List<Object> values = new ArrayList<Object>();
        int end = 0;
        int nullCount;

        DecodeState() {
        }

        void add(Object object, int n) {
            this.values.add(object);
            this.end = n;
        }

        int findNullTerminator(byte[] byArray, int n, int n2) {
            this.nullCount = 0;
            int n3 = n;
            while (n3 < n2) {
                if (byArray[n3] == 0) {
                    if (n3 + 1 >= n2 || byArray[n3 + 1] != -1) {
                        return n3;
                    }
                    ++this.nullCount;
                    n3 += 2;
                    continue;
                }
                ++n3;
            }
            throw new IllegalArgumentException("No terminator found for bytes starting at " + n);
        }
    }
}

