/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.Cluster;
import com.apple.foundationdb.Database;
import com.apple.foundationdb.DirectBufferPool;
import com.apple.foundationdb.EventKeeper;
import com.apple.foundationdb.FDBDatabase;
import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.JNIUtil;
import com.apple.foundationdb.NetworkOptions;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class FDB {
    static FDB singleton = null;
    public static final ExecutorService DEFAULT_EXECUTOR;
    private final int apiVersion;
    private volatile boolean netStarted = false;
    private volatile boolean netStopped = false;
    volatile boolean warnOnUnclosed = true;
    private boolean enableDirectBufferQueries = false;
    private boolean useShutdownHook = true;
    private Thread shutdownHook;
    private final Semaphore netRunning = new Semaphore(1);
    private final NetworkOptions options;

    private FDB(int n) {
        this.apiVersion = n;
        this.options = new NetworkOptions(this::Network_setOption);
    }

    public NetworkOptions options() {
        return this.options;
    }

    public static boolean isAPIVersionSelected() {
        return singleton != null;
    }

    public static FDB instance() throws FDBException {
        if (singleton != null) {
            return singleton;
        }
        throw new FDBException("API version is not set", 2200);
    }

    public static FDB selectAPIVersion(int n) throws FDBException {
        if (singleton != null) {
            if (n != singleton.getAPIVersion()) {
                throw new IllegalArgumentException("FoundationDB API already started at different version");
            }
            return singleton;
        }
        if (n < 510) {
            throw new IllegalArgumentException("API version not supported (minimum 510)");
        }
        if (n > 800) {
            throw new IllegalArgumentException(String.format("API version not supported (maximum %d)", 800));
        }
        FDB.Select_API_version(n);
        singleton = new FDB(n);
        return singleton;
    }

    public synchronized void disableShutdownHook() {
        this.useShutdownHook = false;
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHook = null;
        }
    }

    public void setUnclosedWarning(boolean bl) {
        this.warnOnUnclosed = bl;
    }

    public int getAPIVersion() {
        return this.apiVersion;
    }

    public void enableDirectBufferQuery(boolean bl) {
        this.enableDirectBufferQueries = bl;
    }

    public boolean isDirectBufferQueriesEnabled() {
        return this.enableDirectBufferQueries;
    }

    public void resizeDirectBufferPool(int n, int n2) {
        DirectBufferPool.getInstance().resize(n, n2);
    }

    @Deprecated
    public Cluster createCluster() throws IllegalStateException, FDBException {
        return this.createCluster(null);
    }

    @Deprecated
    public Cluster createCluster(String string) throws IllegalStateException, FDBException {
        return this.createCluster(string, DEFAULT_EXECUTOR);
    }

    @Deprecated
    public Cluster createCluster(String string, Executor executor) throws FDBException, IllegalStateException {
        return new Cluster(string, executor);
    }

    public Database open() throws FDBException {
        return this.open(null);
    }

    public Database open(String string) throws FDBException {
        return this.open(string, DEFAULT_EXECUTOR);
    }

    public Database open(String string, EventKeeper eventKeeper) throws FDBException {
        return this.open(string, DEFAULT_EXECUTOR, eventKeeper);
    }

    public Database open(String string, Executor executor) throws FDBException {
        return this.open(string, executor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database open(String string, Executor executor, EventKeeper eventKeeper) throws FDBException {
        FDB fDB = this;
        synchronized (fDB) {
            if (!this.isConnected()) {
                this.startNetwork();
            }
        }
        return new FDBDatabase(this.Database_create(string), executor, eventKeeper);
    }

    public void startNetwork() throws FDBException, IllegalStateException {
        this.startNetwork(Executors.newSingleThreadExecutor(runnable -> {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            thread.setName("fdb-network-thread");
            return thread;
        }));
    }

    public synchronized void startNetwork(Executor executor) throws FDBException, IllegalStateException {
        if (this.netStopped) {
            throw new IllegalStateException("Network has been stopped and cannot be restarted");
        }
        if (this.netStarted) {
            return;
        }
        if (this.useShutdownHook) {
            this.shutdownHook = new Thread(this::stopNetwork, "fdb-shutdown-hook");
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
        this.Network_setup();
        this.netStarted = true;
        executor.execute(() -> {
            boolean bl = false;
            try {
                while (!bl) {
                    try {
                        FDB fDB = this;
                        synchronized (fDB) {
                            if (this.netStopped) {
                                return;
                            }
                        }
                        this.netRunning.acquire();
                        bl = true;
                    }
                    catch (InterruptedException interruptedException) {}
                }
                try {
                    this.Network_run();
                    return;
                }
                catch (Throwable throwable) {
                    System.err.println("Unhandled error in FoundationDB network thread: " + throwable.getMessage());
                    return;
                }
            }
            finally {
                if (bl) {
                    this.netRunning.release();
                }
                FDB fDB = this;
                synchronized (fDB) {
                    this.netStopped = true;
                }
            }
        });
    }

    private synchronized boolean isConnected() {
        return this.netStarted && !this.netStopped;
    }

    public synchronized void stopNetwork() throws FDBException {
        if (!this.netStarted || this.netStopped) {
            this.netStopped = true;
            return;
        }
        this.Network_stop();
        this.netStarted = true;
        this.netStopped = true;
        while (true) {
            try {
                this.netRunning.acquire();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    protected static boolean evalErrorPredicate(int n, int n2) {
        if (singleton == null) {
            throw new IllegalStateException("FDB API not yet initialized");
        }
        return singleton.Error_predicate(n, n2);
    }

    static native void Select_API_version(int var0) throws FDBException;

    private native void Network_setOption(int var1, byte[] var2) throws FDBException;

    private native void Network_setup() throws FDBException;

    private native void Network_run() throws FDBException;

    private native void Network_stop() throws FDBException;

    private native boolean Error_predicate(int var1, int var2);

    private native long Database_create(String var1) throws FDBException;

    static {
        try {
            JNIUtil.loadLibrary("fdb_c");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JNIUtil.loadLibrary("fdb_java");
        DaemonThreadFactory daemonThreadFactory = new DaemonThreadFactory(Executors.defaultThreadFactory());
        DEFAULT_EXECUTOR = Executors.newCachedThreadPool(daemonThreadFactory);
    }

    static class DaemonThreadFactory
    implements ThreadFactory {
        private final ThreadFactory factory;
        private static AtomicInteger threadCount = new AtomicInteger();

        DaemonThreadFactory(ThreadFactory threadFactory) {
            this.factory = threadFactory;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = this.factory.newThread(runnable);
            thread.setName("fdb-java-" + threadCount.incrementAndGet());
            thread.setDaemon(true);
            return thread;
        }
    }
}

