# This file will be configured to contain variables for CPack. These variables
# should be set in the CMake list file of the project before CPack module is
# included. The list of available CPACK_xxx variables and their associated
# documentation may be obtained using
#  cpack --help-variable-list
#
# Some variables are common to all generators (e.g. CPACK_PACKAGE_NAME)
# and some are specific to a generator
# (e.g. CPACK_NSIS_EXTRA_INSTALL_COMMANDS). The generator specific variables
# usually begin with CPACK_<GENNAME>_xxxx.


set(CPACK_ARCHIVE_CLIENTS-TGZ_FILE_NAME "foundationdb-clients_7.4.0-1.SNAPSHOT.x86_64")
set(CPACK_ARCHIVE_COMPONENT_INSTALL "ON")
set(CPACK_ARCHIVE_SERVER-TGZ_FILE_NAME "foundationdb-server_7.4.0-1.SNAPSHOT.x86_64")
set(CPACK_BUILD_SOURCE_DIRS "/codebuild/output/src467010379/src/github.com/apple/foundationdb;/codebuild/output/src467010379/src/github.com/apple/foundationdb/build_output")
set(CPACK_CMAKE_GENERATOR "Ninja")
set(CPACK_COMPONENTS_ALL "Unspecified;clients-versioned;server-deb;server-el9;server-versioned")
set(CPACK_COMPONENT_CLIENTS-DEB_DISPLAY_NAME "foundationdb-clients")
set(CPACK_COMPONENT_CLIENTS-EL9_DISPLAY_NAME "foundationdb-clients")
set(CPACK_COMPONENT_CLIENTS-TGZ_DISPLAY_NAME "foundationdb-clients")
set(CPACK_COMPONENT_CLIENTS-VERSIONED_DISPLAY_NAME "foundationdb7.4.0.20251010033641prerelease-clients")
set(CPACK_COMPONENT_SERVER-DEB_DEPENDS "clients-deb")
set(CPACK_COMPONENT_SERVER-DEB_DISPLAY_NAME "foundationdb-server")
set(CPACK_COMPONENT_SERVER-EL9_DEPENDS "clients-el9")
set(CPACK_COMPONENT_SERVER-EL9_DISPLAY_NAME "foundationdb-server")
set(CPACK_COMPONENT_SERVER-TGZ_DEPENDS "clients-tgz")
set(CPACK_COMPONENT_SERVER-TGZ_DISPLAY_NAME "foundationdb-server")
set(CPACK_COMPONENT_SERVER-VERSIONED_DEPENDS "clients-versioned")
set(CPACK_COMPONENT_SERVER-VERSIONED_DISPLAY_NAME "foundationdb7.4.0.20251010033641prerelease-server")
set(CPACK_COMPONENT_UNSPECIFIED_HIDDEN "TRUE")
set(CPACK_COMPONENT_UNSPECIFIED_REQUIRED "TRUE")
set(CPACK_DEBIAN_CLIENTS-DEB_FILE_NAME "foundationdb-clients_7.4.0-1.SNAPSHOT_amd64.deb")
set(CPACK_DEBIAN_CLIENTS-DEB_PACKAGE_CONTROL_EXTRA "/codebuild/output/src467010379/src/github.com/apple/foundationdb/packaging/deb/DEBIAN-foundationdb-clients/postinst")
set(CPACK_DEBIAN_CLIENTS-DEB_PACKAGE_DEPENDS "adduser, libc6 (>= 2.12)")
set(CPACK_DEBIAN_CLIENTS-DEB_PACKAGE_NAME "foundationdb-clients")
set(CPACK_DEBIAN_CLIENTS-VERSIONED_FILE_NAME "foundationdb7.4.0.20251010033641prerelease-clients-1.versioned_amd64.deb")
set(CPACK_DEBIAN_CLIENTS-VERSIONED_PACKAGE_CONTROL_EXTRA "/codebuild/output/src467010379/src/github.com/apple/foundationdb/build_output/packaging/multiversion/clients/postinst;/codebuild/output/src467010379/src/github.com/apple/foundationdb/build_output/packaging/multiversion/clients/prerm")
set(CPACK_DEBIAN_CLIENTS-VERSIONED_PACKAGE_NAME "foundationdb7.4.0.20251010033641prerelease-clients")
set(CPACK_DEBIAN_DEBUGINFO_PACKAGE "OFF")
set(CPACK_DEBIAN_ENABLE_COMPONENT_DEPENDS "ON")
set(CPACK_DEBIAN_PACKAGE_HOMEPAGE "https://www.foundationdb.org")
set(CPACK_DEBIAN_PACKAGE_SECTION "database")
set(CPACK_DEBIAN_SERVER-DEB_FILE_NAME "foundationdb-server_7.4.0-1.SNAPSHOT_amd64.deb")
set(CPACK_DEBIAN_SERVER-DEB_PACKAGE_CONTROL_EXTRA "/codebuild/output/src467010379/src/github.com/apple/foundationdb/packaging/deb/DEBIAN-foundationdb-server/conffiles;/codebuild/output/src467010379/src/github.com/apple/foundationdb/packaging/deb/DEBIAN-foundationdb-server/preinst;/codebuild/output/src467010379/src/github.com/apple/foundationdb/packaging/deb/DEBIAN-foundationdb-server/postinst;/codebuild/output/src467010379/src/github.com/apple/foundationdb/packaging/deb/DEBIAN-foundationdb-server/prerm;/codebuild/output/src467010379/src/github.com/apple/foundationdb/packaging/deb/DEBIAN-foundationdb-server/postrm")
set(CPACK_DEBIAN_SERVER-DEB_PACKAGE_DEPENDS "adduser, libc6 (>= 2.12), foundationdb-clients (= 7.4.0)")
set(CPACK_DEBIAN_SERVER-DEB_PACKAGE_NAME "foundationdb-server")
set(CPACK_DEBIAN_SERVER-DEB_PACKAGE_RECOMMENDS "python (>= 2.6)")
set(CPACK_DEBIAN_SERVER-VERSIONED_FILE_NAME "foundationdb7.4.0.20251010033641prerelease-server-1.versioned_amd64.deb")
set(CPACK_DEBIAN_SERVER-VERSIONED_PACKAGE_CONTROL_EXTRA "/codebuild/output/src467010379/src/github.com/apple/foundationdb/build_output/packaging/multiversion/server/postinst;/codebuild/output/src467010379/src/github.com/apple/foundationdb/build_output/packaging/multiversion/server/prerm")
set(CPACK_DEBIAN_SERVER-VERSIONED_PACKAGE_NAME "foundationdb7.4.0.20251010033641prerelease-server")
set(CPACK_DEB_COMPONENT_INSTALL "ON")
set(CPACK_DEFAULT_PACKAGE_DESCRIPTION_FILE "/usr/local/share/cmake-3.31/Templates/CPack.GenericDescription.txt")
set(CPACK_DEFAULT_PACKAGE_DESCRIPTION_SUMMARY "foundationdb built using CMake")
set(CPACK_GENERATOR "TBZ2;TGZ;TXZ;TZ")
set(CPACK_IGNORE_FILES "/CVS/;/\\.svn/;/\\.bzr/;/\\.hg/;/\\.git/;\\.swp\$;\\.#;/#")
set(CPACK_INNOSETUP_ARCHITECTURE "x64")
set(CPACK_INSTALLED_DIRECTORIES "/codebuild/output/src467010379/src/github.com/apple/foundationdb;/")
set(CPACK_INSTALL_CMAKE_PROJECTS "")
set(CPACK_INSTALL_PREFIX "/usr/local")
set(CPACK_MODULE_PATH "/codebuild/output/src467010379/src/github.com/apple/foundationdb/cmake;/codebuild/output/src467010379/src/github.com/apple/foundationdb/cmake/;/opt/grpc_clang/lib/cmake/grpc/modules")
set(CPACK_NSIS_DISPLAY_NAME "foundationdb 7.4.0")
set(CPACK_NSIS_INSTALLER_ICON_CODE "")
set(CPACK_NSIS_INSTALLER_MUI_ICON_CODE "")
set(CPACK_NSIS_INSTALL_ROOT "$PROGRAMFILES")
set(CPACK_NSIS_PACKAGE_NAME "foundationdb 7.4.0")
set(CPACK_NSIS_UNINSTALL_NAME "Uninstall")
set(CPACK_OBJCOPY_EXECUTABLE "/usr/local/bin/llvm-objcopy")
set(CPACK_OBJDUMP_EXECUTABLE "/usr/local/bin/llvm-objdump")
set(CPACK_OUTPUT_CONFIG_FILE "/codebuild/output/src467010379/src/github.com/apple/foundationdb/build_output/CPackConfig.cmake")
set(CPACK_OUTPUT_FILE_PREFIX "/codebuild/output/src467010379/src/github.com/apple/foundationdb/build_output/packages")
set(CPACK_PACKAGE_CHECKSUM "SHA256")
set(CPACK_PACKAGE_CONTACT "The FoundationDB Community")
set(CPACK_PACKAGE_DEFAULT_LOCATION "/")
set(CPACK_PACKAGE_DESCRIPTION_FILE "/codebuild/output/src467010379/src/github.com/apple/foundationdb/packaging/description")
set(CPACK_PACKAGE_DESCRIPTION_SUMMARY "FoundationDB is a scalable, fault-tolerant, ordered key-value store with full ACID transactions.")
set(CPACK_PACKAGE_FILE_NAME "foundationdb-7.4.0-Source")
set(CPACK_PACKAGE_HOMEPAGE_URL "http://www.foundationdb.org/")
set(CPACK_PACKAGE_ICON "/codebuild/output/src467010379/src/github.com/apple/foundationdb/packaging/foundationdb.ico")
set(CPACK_PACKAGE_INSTALL_DIRECTORY "foundationdb 7.4.0")
set(CPACK_PACKAGE_INSTALL_REGISTRY_KEY "foundationdb 7.4.0")
set(CPACK_PACKAGE_NAME "foundationdb")
set(CPACK_PACKAGE_RELOCATABLE "true")
set(CPACK_PACKAGE_VENDOR "FoundationDB")
set(CPACK_PACKAGE_VERSION "7.4.0")
set(CPACK_PACKAGE_VERSION_MAJOR "7")
set(CPACK_PACKAGE_VERSION_MINOR "4")
set(CPACK_PACKAGE_VERSION_PATCH "0")
set(CPACK_PROJECT_CONFIG_FILE "/codebuild/output/src467010379/src/github.com/apple/foundationdb/build_output/packaging/CPackConfig.cmake")
set(CPACK_READELF_EXECUTABLE "/usr/local/bin/llvm-readelf")
set(CPACK_RESOURCE_FILE_LICENSE "/usr/local/share/cmake-3.31/Templates/CPack.GenericLicense.txt")
set(CPACK_RESOURCE_FILE_README "/usr/local/share/cmake-3.31/Templates/CPack.GenericDescription.txt")
set(CPACK_RESOURCE_FILE_WELCOME "/usr/local/share/cmake-3.31/Templates/CPack.GenericWelcome.txt")
set(CPACK_RPM_BUILD_SOURCE_DIRS_PREFIX "/usr/src")
set(CPACK_RPM_CLIENTS-EL9_DEBUGINFO_FILE_NAME "foundationdb-clients-7.4.0-1.SNAPSHOT.el9-debuginfo.x86_64.rpm")
set(CPACK_RPM_CLIENTS-EL9_FILE_NAME "foundationdb-clients-7.4.0-1.SNAPSHOT.el9.x86_64.rpm")
set(CPACK_RPM_CLIENTS-EL9_PACKAGE_NAME "foundationdb-clients")
set(CPACK_RPM_CLIENTS-EL9_POST_INSTALL_SCRIPT_FILE "/codebuild/output/src467010379/src/github.com/apple/foundationdb/packaging/rpm/scripts/postclients.sh")
set(CPACK_RPM_CLIENTS-EL9_PRE_INSTALL_SCRIPT_FILE "/codebuild/output/src467010379/src/github.com/apple/foundationdb/packaging/rpm/scripts/preclients.sh")
set(CPACK_RPM_CLIENTS-EL9_USER_FILELIST "%dir /etc/foundationdb")
set(CPACK_RPM_CLIENTS-VERSIONED_DEBUGINFO_FILE_NAME "foundationdb7.4.0.20251010033641prerelease-clients-1.versioned-debuginfo.x86_64.rpm")
set(CPACK_RPM_CLIENTS-VERSIONED_FILE_NAME "foundationdb7.4.0.20251010033641prerelease-clients-1.versioned.x86_64.rpm")
set(CPACK_RPM_CLIENTS-VERSIONED_PACKAGE_NAME "foundationdb7.4.0.20251010033641prerelease-clients")
set(CPACK_RPM_CLIENTS-VERSIONED_POST_INSTALL_SCRIPT_FILE "/codebuild/output/src467010379/src/github.com/apple/foundationdb/build_output/packaging/multiversion/clients/postinst-el9")
set(CPACK_RPM_CLIENTS-VERSIONED_PRE_UNINSTALL_SCRIPT_FILE "/codebuild/output/src467010379/src/github.com/apple/foundationdb/build_output/packaging/multiversion/clients/prerm")
set(CPACK_RPM_COMPONENT_INSTALL "ON")
set(CPACK_RPM_DEBUGINFO_PACKAGE "OFF")
set(CPACK_RPM_EXCLUDE_FROM_AUTO_FILELIST_ADDITION "/usr/sbin;/usr/share/java;/usr/lib;/usr/lib64/cmake;/etc/foundationdb;/usr/lib64/pkgconfig;/usr/lib64/python2.7;/usr/lib64/python2.7/site-packages;/var;/var/log;/var/lib;/lib;/lib/systemd;/lib/systemd/system;/etc/rc.d/init.d;/usr/lib/pkgconfig;/usr/lib/foundationdb;/usr/lib/cmake;/usr/lib/foundationdb-7.4.0.20251010033641/etc/foundationdb")
set(CPACK_RPM_PACKAGE_GROUP "b6ec58714ba663162fa6b5d60a8e138f1fccc569")
set(CPACK_RPM_PACKAGE_LICENSE "Apache 2.0")
set(CPACK_RPM_PACKAGE_NAME "foundationdb")
set(CPACK_RPM_PACKAGE_RELEASE "1")
set(CPACK_RPM_PACKAGE_SOURCES "ON")
set(CPACK_RPM_SERVER-EL9_DEBUGINFO_FILE_NAME "foundationdb-server-7.4.0-1.SNAPSHOT.el9-debuginfo.x86_64.rpm")
set(CPACK_RPM_SERVER-EL9_FILE_NAME "foundationdb-server-7.4.0-1.SNAPSHOT.el9.x86_64.rpm")
set(CPACK_RPM_SERVER-EL9_PACKAGE_NAME "foundationdb-server")
set(CPACK_RPM_SERVER-EL9_PACKAGE_REQUIRES "foundationdb-clients = 7.4.0")
set(CPACK_RPM_SERVER-EL9_POST_INSTALL_SCRIPT_FILE "/codebuild/output/src467010379/src/github.com/apple/foundationdb/packaging/rpm/scripts/postserver.sh")
set(CPACK_RPM_SERVER-EL9_PRE_INSTALL_SCRIPT_FILE "/codebuild/output/src467010379/src/github.com/apple/foundationdb/packaging/rpm/scripts/preserver.sh")
set(CPACK_RPM_SERVER-EL9_PRE_UNINSTALL_SCRIPT_FILE "/codebuild/output/src467010379/src/github.com/apple/foundationdb/packaging/rpm/scripts/preunserver.sh")
set(CPACK_RPM_SERVER-EL9_USER_FILELIST "%config(noreplace) /etc/foundationdb/foundationdb.conf;%attr(0700,foundationdb,foundationdb) /var/log/foundationdb;%attr(0700,foundationdb,foundationdb) /var/lib/foundationdb")
set(CPACK_RPM_SERVER-VERSIONED_DEBUGINFO_FILE_NAME "foundationdb7.4.0.20251010033641prerelease-server-1.versioned-debuginfo.x86_64.rpm")
set(CPACK_RPM_SERVER-VERSIONED_FILE_NAME "foundationdb7.4.0.20251010033641prerelease-server-1.versioned.x86_64.rpm")
set(CPACK_RPM_SERVER-VERSIONED_PACKAGE_NAME "foundationdb7.4.0.20251010033641prerelease-server")
set(CPACK_RPM_SERVER-VERSIONED_PACKAGE_REQUIRES "foundationdb7.4.0.20251010033641prerelease-clients")
set(CPACK_RPM_SERVER-VERSIONED_POST_INSTALL_SCRIPT_FILE "/codebuild/output/src467010379/src/github.com/apple/foundationdb/build_output/packaging/multiversion/server/postinst-rpm")
set(CPACK_RPM_SERVER-VERSIONED_PRE_UNINSTALL_SCRIPT_FILE "/codebuild/output/src467010379/src/github.com/apple/foundationdb/build_output/packaging/multiversion/server/prerm")
set(CPACK_SET_DESTDIR "OFF")
set(CPACK_SOURCE_GENERATOR "TBZ2;TGZ;TXZ;TZ")
set(CPACK_SOURCE_IGNORE_FILES "/CVS/;/\\.svn/;/\\.bzr/;/\\.hg/;/\\.git/;\\.swp\$;\\.#;/#")
set(CPACK_SOURCE_INSTALLED_DIRECTORIES "/codebuild/output/src467010379/src/github.com/apple/foundationdb;/")
set(CPACK_SOURCE_OUTPUT_CONFIG_FILE "/codebuild/output/src467010379/src/github.com/apple/foundationdb/build_output/CPackSourceConfig.cmake")
set(CPACK_SOURCE_PACKAGE_FILE_NAME "foundationdb-7.4.0-Source")
set(CPACK_SOURCE_RPM "OFF")
set(CPACK_SOURCE_TBZ2 "ON")
set(CPACK_SOURCE_TGZ "ON")
set(CPACK_SOURCE_TOPLEVEL_TAG "Linux-Source")
set(CPACK_SOURCE_TXZ "ON")
set(CPACK_SOURCE_TZ "ON")
set(CPACK_SOURCE_ZIP "OFF")
set(CPACK_STRIP_FILES "")
set(CPACK_SYSTEM_NAME "Linux")
set(CPACK_THREADS "1")
set(CPACK_TOPLEVEL_TAG "Linux-Source")
set(CPACK_WIX_SIZEOF_VOID_P "8")

if(NOT CPACK_PROPERTIES_FILE)
  set(CPACK_PROPERTIES_FILE "/codebuild/output/src467010379/src/github.com/apple/foundationdb/build_output/CPackProperties.cmake")
endif()

if(EXISTS ${CPACK_PROPERTIES_FILE})
  include(${CPACK_PROPERTIES_FILE})
endif()
