/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.tuple.ByteArrayUtil;

public class KeySelector {
    private final byte[] key;
    private final boolean orEqual;
    private final int offset;

    public KeySelector(byte[] byArray, boolean bl, int n) {
        this.key = byArray;
        this.orEqual = bl;
        this.offset = n;
    }

    public static KeySelector lastLessThan(byte[] byArray) {
        return new KeySelector(byArray, false, 0);
    }

    public static KeySelector lastLessOrEqual(byte[] byArray) {
        return new KeySelector(byArray, true, 0);
    }

    public static KeySelector firstGreaterThan(byte[] byArray) {
        return new KeySelector(byArray, true, 1);
    }

    public static KeySelector firstGreaterOrEqual(byte[] byArray) {
        return new KeySelector(byArray, false, 1);
    }

    public KeySelector add(int n) {
        return new KeySelector(this.getKey(), this.orEqual(), this.getOffset() + n);
    }

    public byte[] getKey() {
        byte[] byArray = new byte[this.key.length];
        System.arraycopy(this.key, 0, byArray, 0, this.key.length);
        return byArray;
    }

    public String toString() {
        return String.format("(%s, %s, %d)", ByteArrayUtil.printable(this.getKey()), Boolean.toString(this.orEqual()), this.getOffset());
    }

    public boolean orEqual() {
        return this.orEqual;
    }

    public int getOffset() {
        return this.offset;
    }
}

