#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
/*
 * UnitPerf.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbrpc/ActorFuzz.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // has to be last include

															#line 28 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitPerf.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via sleepyActor()
															#line 26 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
template <class SleepyActorActor>
															#line 26 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
class SleepyActorActorState {
															#line 35 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitPerf.actor.g.cpp.py_gen"
public:
															#line 26 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
	SleepyActorActorState(double const& interval,int* const& counter) 
															#line 26 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
															#line 26 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
		 : interval(interval),
															#line 26 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
		   counter(counter)
															#line 44 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitPerf.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("sleepyActor", reinterpret_cast<unsigned long>(this));

	}
	~SleepyActorActorState() 
	{
		fdb_probe_actor_destroy("sleepyActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 27 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
			;
															#line 59 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitPerf.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SleepyActorActorState();
		static_cast<SleepyActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 28 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(interval);
															#line 28 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
		if (static_cast<SleepyActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 91 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitPerf.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<SleepyActorActor*>(this)->actor_wait_state = 1;
															#line 28 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SleepyActorActor, 0, Void >*>(static_cast<SleepyActorActor*>(this)));
															#line 96 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitPerf.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 29 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
		++*counter;
															#line 105 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitPerf.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 29 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
		++*counter;
															#line 114 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitPerf.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SleepyActorActor*>(this)->actor_wait_state > 0) static_cast<SleepyActorActor*>(this)->actor_wait_state = 0;
		static_cast<SleepyActorActor*>(this)->ActorCallback< SleepyActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SleepyActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sleepyActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SleepyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sleepyActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SleepyActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sleepyActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SleepyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sleepyActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SleepyActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sleepyActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SleepyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sleepyActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 26 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
	double interval;
															#line 26 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
	int* counter;
															#line 198 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitPerf.actor.g.cpp.py_gen"
};
// This generated class is to be used only via sleepyActor()
															#line 26 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
class SleepyActorActor final : public Actor<Void>, public ActorCallback< SleepyActorActor, 0, Void >, public FastAllocated<SleepyActorActor>, public SleepyActorActorState<SleepyActorActor> {
															#line 203 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitPerf.actor.g.cpp.py_gen"
public:
	using FastAllocated<SleepyActorActor>::operator new;
	using FastAllocated<SleepyActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11928025664575269888UL, 10801435598524189696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SleepyActorActor, 0, Void >;
															#line 26 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
	SleepyActorActor(double const& interval,int* const& counter) 
															#line 220 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitPerf.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   SleepyActorActorState<SleepyActorActor>(interval, counter),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("sleepyActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11834794927120576512UL, 1990217319637140224UL);
		ActorExecutionContextHelper __helper(static_cast<SleepyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("sleepyActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("sleepyActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SleepyActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 26 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
[[nodiscard]] Future<Void> sleepyActor( double const& interval, int* const& counter ) {
															#line 26 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
	return Future<Void>(new SleepyActorActor(interval, counter));
															#line 253 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitPerf.actor.g.cpp.py_gen"
}

#line 32 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"

															#line 258 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitPerf.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via unitPerfTest()
															#line 33 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
template <class UnitPerfTestActor>
															#line 33 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
class UnitPerfTestActorState {
															#line 265 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitPerf.actor.g.cpp.py_gen"
public:
															#line 33 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
	UnitPerfTestActorState() 
															#line 33 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
	{
															#line 271 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitPerf.actor.g.cpp.py_gen"
		fdb_probe_actor_create("unitPerfTest", reinterpret_cast<unsigned long>(this));

	}
	~UnitPerfTestActorState() 
	{
		fdb_probe_actor_destroy("unitPerfTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 34 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
			printf("\n");
															#line 36 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
			counter = 0;
															#line 37 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
			sleepy = std::vector<Future<Void>>();
															#line 38 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
			sleepy.reserve(100000);
															#line 39 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
			for(int i = 0;i < 100000;i++) {
															#line 40 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
				sleepy.push_back(sleepyActor(.1, &counter));
															#line 295 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitPerf.actor.g.cpp.py_gen"
			}
															#line 42 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(10);
															#line 42 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
			if (static_cast<UnitPerfTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 301 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitPerf.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UnitPerfTestActor*>(this)->actor_wait_state = 1;
															#line 42 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UnitPerfTestActor, 0, Void >*>(static_cast<UnitPerfTestActor*>(this)));
															#line 306 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitPerf.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UnitPerfTestActorState();
		static_cast<UnitPerfTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 43 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
		sleepy.clear();
															#line 44 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
		TraceEvent("Completed").detail("Count", counter);
															#line 45 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
		printf("Completed: %d\n", counter);
															#line 47 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
		printf("\n");
															#line 48 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
		if (!static_cast<UnitPerfTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UnitPerfTestActorState(); static_cast<UnitPerfTestActor*>(this)->destroy(); return 0; }
															#line 337 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitPerf.actor.g.cpp.py_gen"
		new (&static_cast<UnitPerfTestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UnitPerfTestActorState();
		static_cast<UnitPerfTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 43 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
		sleepy.clear();
															#line 44 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
		TraceEvent("Completed").detail("Count", counter);
															#line 45 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
		printf("Completed: %d\n", counter);
															#line 47 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
		printf("\n");
															#line 48 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
		if (!static_cast<UnitPerfTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UnitPerfTestActorState(); static_cast<UnitPerfTestActor*>(this)->destroy(); return 0; }
															#line 357 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitPerf.actor.g.cpp.py_gen"
		new (&static_cast<UnitPerfTestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UnitPerfTestActorState();
		static_cast<UnitPerfTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UnitPerfTestActor*>(this)->actor_wait_state > 0) static_cast<UnitPerfTestActor*>(this)->actor_wait_state = 0;
		static_cast<UnitPerfTestActor*>(this)->ActorCallback< UnitPerfTestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UnitPerfTestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("unitPerfTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnitPerfTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unitPerfTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UnitPerfTestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("unitPerfTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnitPerfTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unitPerfTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UnitPerfTestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("unitPerfTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnitPerfTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unitPerfTest", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 36 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
	int counter;
															#line 37 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
	std::vector<Future<Void>> sleepy;
															#line 444 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitPerf.actor.g.cpp.py_gen"
};
// This generated class is to be used only via unitPerfTest()
															#line 33 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
class UnitPerfTestActor final : public Actor<Void>, public ActorCallback< UnitPerfTestActor, 0, Void >, public FastAllocated<UnitPerfTestActor>, public UnitPerfTestActorState<UnitPerfTestActor> {
															#line 449 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitPerf.actor.g.cpp.py_gen"
public:
	using FastAllocated<UnitPerfTestActor>::operator new;
	using FastAllocated<UnitPerfTestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7576009829770371584UL, 3073751083102801920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UnitPerfTestActor, 0, Void >;
															#line 33 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
	UnitPerfTestActor() 
															#line 466 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitPerf.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UnitPerfTestActorState<UnitPerfTestActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("unitPerfTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14893675150674561024UL, 14051452804778149120UL);
		ActorExecutionContextHelper __helper(static_cast<UnitPerfTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("unitPerfTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("unitPerfTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UnitPerfTestActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 33 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
[[nodiscard]] Future<Void> unitPerfTest(  ) {
															#line 33 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"
	return Future<Void>(new UnitPerfTestActor());
															#line 499 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitPerf.actor.g.cpp.py_gen"
}

#line 50 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/UnitPerf.actor.cpp"

struct UnitPerfWorkload : TestWorkload {
	static constexpr auto NAME = "UnitPerf";
	bool enabled;

	UnitPerfWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		enabled = !clientId; // only do this on the "first" client
	}

	Future<Void> setup(Database const& cx) override { return Void(); }
	Future<Void> start(Database const& cx) override {
		if (enabled)
			return unitPerfTest();
		return Void();
	}
	Future<bool> check(Database const& cx) override { return true; }
	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<UnitPerfWorkload> UnitPerfWorkloadFactory;
