#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
/*
 * ResolverBug.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "flow/ProcessEvents.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/ResolverBug.h"
#include "fdbserver/ServerDBInfo.actor.h"

#include "flow/actorcompiler.h" // has to be last include

namespace {

struct ResolverBugWorkload : TestWorkload {
	constexpr static auto NAME = "ResolverBug";
	bool disableFailureInjections;
	ResolverBug resolverBug;
	Standalone<VectorRef<KeyValueRef>> cycleOptions;
	KeyRef controlKey = "workload_control"_sr;
	Promise<Void> bugFound;

	ResolverBugWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		disableFailureInjections = getOption(options, "disableFailureInjections"_sr, true);
		resolverBug.ignoreTooOldProbability = getOption(options, "ignoreTooOldProbability"_sr, 0.0);
		resolverBug.ignoreWriteSetProbability = getOption(options, "ignoreWriteSetProbability"_sr, 0.0);
		resolverBug.ignoreReadSetProbability = getOption(options, "ignoreReadSetProbability"_sr, 0.0);

		for (auto& o : options) {
			if (o.key.startsWith("cycle_"_sr)) {
				KeyValueRef option;
				option.key = o.key.removePrefix("cycle_"_sr);
				option.value = o.value;
				cycleOptions.push_back_deep(cycleOptions.arena(), option);
				o.value = ""_sr;
			}
		}

		if (clientId == 0) {
			SimBugInjector().enable();
			auto bug = SimBugInjector().enable<ResolverBug>(ResolverBugID());
			*bug = resolverBug;
			bug->cycleState.resize(clientCount, 0);
			SimBugInjector().disable();
		}
	}

	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		if (disableFailureInjections) {
			out.insert("all");
		}
	}

	Reference<TestWorkload> createCycle() {
		WorkloadContext wcx;
		wcx.clientId = clientId;
		wcx.clientCount = clientCount;
		wcx.ccr = ccr;
		wcx.dbInfo = dbInfo;
		wcx.options = cycleOptions;
		wcx.sharedRandomNumber = sharedRandomNumber;
		return IWorkloadFactory::create("Cycle", wcx);
	}

																#line 81 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
// This generated class is to be used only via waitForPhase()
															#line 79 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
template <class WaitForPhaseActor>
															#line 79 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
class WaitForPhaseActorState {
															#line 87 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
public:
															#line 79 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	WaitForPhaseActorState(std::shared_ptr<ResolverBug> const& bug,int const& phase) 
															#line 79 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
															#line 79 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		 : bug(bug),
															#line 79 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		   phase(phase)
															#line 96 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("waitForPhase", reinterpret_cast<unsigned long>(this));

	}
	~WaitForPhaseActorState() 
	{
		fdb_probe_actor_destroy("waitForPhase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 80 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
			;
															#line 111 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForPhaseActorState();
		static_cast<WaitForPhaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 83 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		if (!static_cast<WaitForPhaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForPhaseActorState(); static_cast<WaitForPhaseActor*>(this)->destroy(); return 0; }
															#line 134 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		new (&static_cast<WaitForPhaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitForPhaseActorState();
		static_cast<WaitForPhaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 80 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		if (!(bug->currentPhase != phase))
															#line 153 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 81 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(0.5);
															#line 81 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		if (static_cast<WaitForPhaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 161 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WaitForPhaseActor*>(this)->actor_wait_state = 1;
															#line 81 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForPhaseActor, 0, Void >*>(static_cast<WaitForPhaseActor*>(this)));
															#line 166 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForPhaseActor*>(this)->actor_wait_state > 0) static_cast<WaitForPhaseActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForPhaseActor*>(this)->ActorCallback< WaitForPhaseActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForPhaseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForPhase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPhaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPhase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForPhaseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForPhase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPhaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPhase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForPhaseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForPhase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPhaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPhase", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 79 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	std::shared_ptr<ResolverBug> bug;
															#line 79 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	int phase;
															#line 275 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
};
// This generated class is to be used only via waitForPhase()
															#line 79 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
class WaitForPhaseActor final : public Actor<Void>, public ActorCallback< WaitForPhaseActor, 0, Void >, public FastAllocated<WaitForPhaseActor>, public WaitForPhaseActorState<WaitForPhaseActor> {
															#line 280 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
public:
	using FastAllocated<WaitForPhaseActor>::operator new;
	using FastAllocated<WaitForPhaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14390906509531365376UL, 15571397890785818880UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForPhaseActor, 0, Void >;
															#line 79 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	WaitForPhaseActor(std::shared_ptr<ResolverBug> const& bug,int const& phase) 
															#line 297 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WaitForPhaseActorState<WaitForPhaseActor>(bug, phase),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForPhase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5954428966756295680UL, 14234342098206507264UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPhaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForPhase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForPhase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForPhaseActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 79 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
[[nodiscard]] static Future<Void> waitForPhase( std::shared_ptr<ResolverBug> const& bug, int const& phase ) {
															#line 79 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	return Future<Void>(new WaitForPhaseActor(bug, phase));
															#line 329 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
}

#line 85 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"

																#line 334 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
// This generated class is to be used only via waitForPhaseDone()
															#line 86 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
template <class WaitForPhaseDoneActor>
															#line 86 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
class WaitForPhaseDoneActorState {
															#line 340 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
public:
															#line 86 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	WaitForPhaseDoneActorState(std::shared_ptr<ResolverBug> const& bug,int const& phase,int const& clientCount) 
															#line 86 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
															#line 86 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		 : bug(bug),
															#line 86 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		   phase(phase),
															#line 86 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		   clientCount(clientCount)
															#line 351 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("waitForPhaseDone", reinterpret_cast<unsigned long>(this));

	}
	~WaitForPhaseDoneActorState() 
	{
		fdb_probe_actor_destroy("waitForPhaseDone", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 87 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
			;
															#line 366 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForPhaseDoneActorState();
		static_cast<WaitForPhaseDoneActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 90 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		if (!static_cast<WaitForPhaseDoneActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForPhaseDoneActorState(); static_cast<WaitForPhaseDoneActor*>(this)->destroy(); return 0; }
															#line 389 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		new (&static_cast<WaitForPhaseDoneActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitForPhaseDoneActorState();
		static_cast<WaitForPhaseDoneActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 87 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		if (!(std::count(bug->cycleState.begin(), bug->cycleState.end(), phase) != clientCount))
															#line 408 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 88 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(0.5);
															#line 88 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		if (static_cast<WaitForPhaseDoneActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 416 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WaitForPhaseDoneActor*>(this)->actor_wait_state = 1;
															#line 88 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForPhaseDoneActor, 0, Void >*>(static_cast<WaitForPhaseDoneActor*>(this)));
															#line 421 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForPhaseDoneActor*>(this)->actor_wait_state > 0) static_cast<WaitForPhaseDoneActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForPhaseDoneActor*>(this)->ActorCallback< WaitForPhaseDoneActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForPhaseDoneActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForPhaseDone", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPhaseDoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPhaseDone", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForPhaseDoneActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForPhaseDone", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPhaseDoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPhaseDone", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForPhaseDoneActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForPhaseDone", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPhaseDoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPhaseDone", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 86 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	std::shared_ptr<ResolverBug> bug;
															#line 86 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	int phase;
															#line 86 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	int clientCount;
															#line 532 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
};
// This generated class is to be used only via waitForPhaseDone()
															#line 86 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
class WaitForPhaseDoneActor final : public Actor<Void>, public ActorCallback< WaitForPhaseDoneActor, 0, Void >, public FastAllocated<WaitForPhaseDoneActor>, public WaitForPhaseDoneActorState<WaitForPhaseDoneActor> {
															#line 537 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
public:
	using FastAllocated<WaitForPhaseDoneActor>::operator new;
	using FastAllocated<WaitForPhaseDoneActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9006516856133710592UL, 15594731489238654208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForPhaseDoneActor, 0, Void >;
															#line 86 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	WaitForPhaseDoneActor(std::shared_ptr<ResolverBug> const& bug,int const& phase,int const& clientCount) 
															#line 554 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WaitForPhaseDoneActorState<WaitForPhaseDoneActor>(bug, phase, clientCount),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForPhaseDone", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4784210581516168192UL, 7713141369604293120UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPhaseDoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForPhaseDone");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForPhaseDone", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForPhaseDoneActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 86 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
[[nodiscard]] static Future<Void> waitForPhaseDone( std::shared_ptr<ResolverBug> const& bug, int const& phase, int const& clientCount ) {
															#line 86 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	return Future<Void>(new WaitForPhaseDoneActor(bug, phase, clientCount));
															#line 586 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
}

#line 92 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"

	struct ReportTraces {
		ReportTraces() { g_traceProcessEvents = true; }
		~ReportTraces() { g_traceProcessEvents = false; }
	};

	struct OnTestFailure {
		std::shared_ptr<ResolverBug> bug;
		OnTestFailure(std::shared_ptr<ResolverBug> bug) : bug(bug) {}

		void operator()(StringRef, auto const& data, Error const&) {
			BaseTraceEvent* trace = std::any_cast<BaseTraceEvent*>(data);
			if (trace->getSeverity() == SevError) {
				bug->bugFound = true;
			}
		}
	};

																#line 608 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
// This generated class is to be used only via driveWorkload()
															#line 110 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
template <class DriveWorkloadActor>
															#line 110 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
class DriveWorkloadActorState {
															#line 614 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
public:
															#line 110 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	DriveWorkloadActorState(std::shared_ptr<ResolverBug> const& bug,int const& clientCount) 
															#line 110 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
															#line 110 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		 : bug(bug),
															#line 110 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		   clientCount(clientCount),
															#line 111 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		   _(),
															#line 112 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		   onTestFailure(bug),
															#line 113 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		   ev("TraceEvent::TestFailure"_sr, onTestFailure)
															#line 629 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("driveWorkload", reinterpret_cast<unsigned long>(this));

	}
	~DriveWorkloadActorState() 
	{
		fdb_probe_actor_destroy("driveWorkload", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 114 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
			;
															#line 644 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DriveWorkloadActorState();
		static_cast<DriveWorkloadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 115 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		bug->currentPhase = 1;
															#line 116 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		StrictFuture<Void> __when_expr_0 = waitForPhaseDone(bug, 1, clientCount);
															#line 116 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		if (static_cast<DriveWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 678 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DriveWorkloadActor*>(this)->actor_wait_state = 1;
															#line 116 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DriveWorkloadActor, 0, Void >*>(static_cast<DriveWorkloadActor*>(this)));
															#line 683 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 117 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		SimBugInjector().enable();
															#line 118 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		bug->currentPhase = 2;
															#line 119 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForPhaseDone(bug, 2, clientCount);
															#line 119 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		if (static_cast<DriveWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 698 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DriveWorkloadActor*>(this)->actor_wait_state = 2;
															#line 119 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DriveWorkloadActor, 1, Void >*>(static_cast<DriveWorkloadActor*>(this)));
															#line 703 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 117 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		SimBugInjector().enable();
															#line 118 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		bug->currentPhase = 2;
															#line 119 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForPhaseDone(bug, 2, clientCount);
															#line 119 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		if (static_cast<DriveWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 718 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DriveWorkloadActor*>(this)->actor_wait_state = 2;
															#line 119 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DriveWorkloadActor, 1, Void >*>(static_cast<DriveWorkloadActor*>(this)));
															#line 723 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DriveWorkloadActor*>(this)->actor_wait_state > 0) static_cast<DriveWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<DriveWorkloadActor*>(this)->ActorCallback< DriveWorkloadActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DriveWorkloadActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("driveWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DriveWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("driveWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DriveWorkloadActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("driveWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DriveWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("driveWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DriveWorkloadActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("driveWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DriveWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("driveWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 120 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		SimBugInjector().disable();
															#line 121 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		bug->currentPhase = 3;
															#line 122 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForPhaseDone(bug, 3, clientCount);
															#line 122 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		if (static_cast<DriveWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 813 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<DriveWorkloadActor*>(this)->actor_wait_state = 3;
															#line 122 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DriveWorkloadActor, 2, Void >*>(static_cast<DriveWorkloadActor*>(this)));
															#line 818 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 120 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		SimBugInjector().disable();
															#line 121 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		bug->currentPhase = 3;
															#line 122 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForPhaseDone(bug, 3, clientCount);
															#line 122 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		if (static_cast<DriveWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 833 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<DriveWorkloadActor*>(this)->actor_wait_state = 3;
															#line 122 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DriveWorkloadActor, 2, Void >*>(static_cast<DriveWorkloadActor*>(this)));
															#line 838 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DriveWorkloadActor*>(this)->actor_wait_state > 0) static_cast<DriveWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<DriveWorkloadActor*>(this)->ActorCallback< DriveWorkloadActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DriveWorkloadActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("driveWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DriveWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("driveWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DriveWorkloadActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("driveWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DriveWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("driveWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DriveWorkloadActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("driveWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DriveWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("driveWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DriveWorkloadActor*>(this)->actor_wait_state > 0) static_cast<DriveWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<DriveWorkloadActor*>(this)->ActorCallback< DriveWorkloadActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DriveWorkloadActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("driveWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DriveWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("driveWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DriveWorkloadActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("driveWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DriveWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("driveWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DriveWorkloadActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("driveWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DriveWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("driveWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 110 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	std::shared_ptr<ResolverBug> bug;
															#line 110 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	int clientCount;
															#line 111 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	ReportTraces _;
															#line 112 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	OnTestFailure onTestFailure;
															#line 113 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	ProcessEvents::Event ev;
															#line 1015 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
};
// This generated class is to be used only via driveWorkload()
															#line 110 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
class DriveWorkloadActor final : public Actor<Void>, public ActorCallback< DriveWorkloadActor, 0, Void >, public ActorCallback< DriveWorkloadActor, 1, Void >, public ActorCallback< DriveWorkloadActor, 2, Void >, public FastAllocated<DriveWorkloadActor>, public DriveWorkloadActorState<DriveWorkloadActor> {
															#line 1020 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
public:
	using FastAllocated<DriveWorkloadActor>::operator new;
	using FastAllocated<DriveWorkloadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2954233266850725888UL, 7450952297417467136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DriveWorkloadActor, 0, Void >;
friend struct ActorCallback< DriveWorkloadActor, 1, Void >;
friend struct ActorCallback< DriveWorkloadActor, 2, Void >;
															#line 110 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	DriveWorkloadActor(std::shared_ptr<ResolverBug> const& bug,int const& clientCount) 
															#line 1039 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DriveWorkloadActorState<DriveWorkloadActor>(bug, clientCount),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("driveWorkload", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14682928277559563264UL, 11507489543853368320UL);
		ActorExecutionContextHelper __helper(static_cast<DriveWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("driveWorkload");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("driveWorkload", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DriveWorkloadActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DriveWorkloadActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DriveWorkloadActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 110 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
[[nodiscard]] static Future<Void> driveWorkload( std::shared_ptr<ResolverBug> const& bug, int const& clientCount ) {
															#line 110 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	return Future<Void>(new DriveWorkloadActor(bug, clientCount));
															#line 1073 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
}

#line 125 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"

																#line 1078 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 126 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
template <class _startActor>
															#line 126 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
class _startActorState {
															#line 1084 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
public:
															#line 126 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	_startActorState(ResolverBugWorkload* const& self,Database const& cx) 
															#line 126 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
															#line 126 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		 : self(self),
															#line 126 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		   cx(cx),
															#line 127 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		   cycle(),
															#line 128 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		   bug(SimBugInjector().get<ResolverBug>(ResolverBugID(), true))
															#line 1097 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 129 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
			;
															#line 1112 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 130 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		StrictFuture<Void> __when_expr_0 = waitForPhase(bug, 1);
															#line 130 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1144 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 130 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 1149 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 131 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		cycle = self->createCycle();
															#line 132 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cycle->setup(cx);
															#line 132 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1162 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 132 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 1167 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 131 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		cycle = self->createCycle();
															#line 132 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cycle->setup(cx);
															#line 132 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1180 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 132 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 1185 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 133 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		bug->cycleState[self->clientId] = 1;
															#line 134 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForPhase(bug, 2);
															#line 134 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1273 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 134 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1278 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 133 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		bug->cycleState[self->clientId] = 1;
															#line 134 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForPhase(bug, 2);
															#line 134 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1291 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 134 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1296 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 135 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		StrictFuture<Void> __when_expr_3 = cycle->start(cx);
															#line 135 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1382 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 135 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 1387 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 135 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		StrictFuture<Void> __when_expr_3 = cycle->start(cx);
															#line 135 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1398 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 135 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 1403 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 136 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		bug->cycleState[self->clientId] = 2;
															#line 137 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		StrictFuture<Void> __when_expr_4 = waitForPhase(bug, 3);
															#line 137 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1491 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 137 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 1496 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 136 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		bug->cycleState[self->clientId] = 2;
															#line 137 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		StrictFuture<Void> __when_expr_4 = waitForPhase(bug, 3);
															#line 137 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1509 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 137 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 1514 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 138 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		StrictFuture<Void> __when_expr_5 = success(cycle->check(cx));
															#line 138 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1600 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 138 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 1605 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 138 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		StrictFuture<Void> __when_expr_5 = success(cycle->check(cx));
															#line 138 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1616 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 138 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 1621 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 139 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		bug->cycleState[self->clientId] = 3;
															#line 1705 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 139 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		bug->cycleState[self->clientId] = 3;
															#line 1714 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 126 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	ResolverBugWorkload* self;
															#line 126 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	Database cx;
															#line 127 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	Reference<TestWorkload> cycle;
															#line 128 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	std::shared_ptr<ResolverBug> bug;
															#line 1802 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 126 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1807 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17363033468411192832UL, 4916928861216094976UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
															#line 126 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	_startActor(ResolverBugWorkload* const& self,Database const& cx) 
															#line 1829 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 126 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
[[nodiscard]] static Future<Void> _start( ResolverBugWorkload* const& self, Database const& cx ) {
															#line 126 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 1866 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
}

#line 142 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"

																#line 1871 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
// This generated class is to be used only via onBug()
															#line 143 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
template <class OnBugActor>
															#line 143 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
class OnBugActorState {
															#line 1877 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
public:
															#line 143 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	OnBugActorState(std::shared_ptr<ResolverBug> const& bug) 
															#line 143 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
															#line 143 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		 : bug(bug)
															#line 1884 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("onBug", reinterpret_cast<unsigned long>(this));

	}
	~OnBugActorState() 
	{
		fdb_probe_actor_destroy("onBug", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 144 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
			;
															#line 1899 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OnBugActorState();
		static_cast<OnBugActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 145 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		if (bug->bugFound)
															#line 1929 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		{
															#line 146 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
			TraceEvent("NegativeTestSuccess").log();
															#line 147 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
			if (!static_cast<OnBugActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OnBugActorState(); static_cast<OnBugActor*>(this)->destroy(); return 0; }
															#line 1935 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
			new (&static_cast<OnBugActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~OnBugActorState();
			static_cast<OnBugActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 149 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(0.5);
															#line 149 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		if (static_cast<OnBugActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1945 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<OnBugActor*>(this)->actor_wait_state = 1;
															#line 149 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OnBugActor, 0, Void >*>(static_cast<OnBugActor*>(this)));
															#line 1950 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OnBugActor*>(this)->actor_wait_state > 0) static_cast<OnBugActor*>(this)->actor_wait_state = 0;
		static_cast<OnBugActor*>(this)->ActorCallback< OnBugActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OnBugActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("onBug", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnBugActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onBug", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OnBugActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("onBug", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnBugActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onBug", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OnBugActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("onBug", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OnBugActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onBug", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 143 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	std::shared_ptr<ResolverBug> bug;
															#line 2044 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
};
// This generated class is to be used only via onBug()
															#line 143 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
class OnBugActor final : public Actor<Void>, public ActorCallback< OnBugActor, 0, Void >, public FastAllocated<OnBugActor>, public OnBugActorState<OnBugActor> {
															#line 2049 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
public:
	using FastAllocated<OnBugActor>::operator new;
	using FastAllocated<OnBugActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13233797580499925248UL, 14918009483733604864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< OnBugActor, 0, Void >;
															#line 143 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	OnBugActor(std::shared_ptr<ResolverBug> const& bug) 
															#line 2066 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   OnBugActorState<OnBugActor>(bug),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("onBug", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16055241588293532928UL, 7719768982818685696UL);
		ActorExecutionContextHelper __helper(static_cast<OnBugActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("onBug");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("onBug", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OnBugActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 143 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
[[nodiscard]] static Future<Void> onBug( std::shared_ptr<ResolverBug> const& bug ) {
															#line 143 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"
	return Future<Void>(new OnBugActor(bug));
															#line 2098 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ResolverBug.actor.g.cpp.py_gen"
}

#line 152 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ResolverBug.actor.cpp"

	Future<Void> start(const Database& cx) override {
		std::vector<Future<Void>> futures;
		auto bug = SimBugInjector().get<ResolverBug>(ResolverBugID(), true);
		if (clientId == 0) {
			futures.push_back(driveWorkload(bug, clientCount));
		}
		futures.push_back(_start(this, cx->clone()));
		return onBug(bug) || waitForAll(futures);
	}
	Future<bool> check(Database const& cx) override { return true; };

private:
	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<ResolverBugWorkload> workloadFactory;

} // namespace
