#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
/*
 * ReadWrite.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <boost/lexical_cast.hpp>
#include <utility>
#include <vector>

#include "fdbclient/FDBTypes.h"
#include "fdbrpc/DDSketch.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "fdbserver/workloads/ReadWriteWorkload.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "flow/TDMetric.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct ReadWriteCommonImpl {
	// trace methods
																#line 41 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
// This generated class is to be used only via traceDumpWorkers()
															#line 39 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
template <class TraceDumpWorkersActor>
															#line 39 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
class TraceDumpWorkersActorState {
															#line 47 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
public:
															#line 39 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	TraceDumpWorkersActorState(Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 39 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
															#line 39 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		 : db(db)
															#line 54 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("traceDumpWorkers", reinterpret_cast<unsigned long>(this));

	}
	~TraceDumpWorkersActorState() 
	{
		fdb_probe_actor_destroy("traceDumpWorkers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 41 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				;
															#line 70 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TraceDumpWorkersActorState();
		static_cast<TraceDumpWorkersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 61 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			TraceEvent(SevError, "FailedToDumpWorkers").error(e);
															#line 62 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 102 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 43 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		StrictFuture<Void> __when_expr_0 = db->onChange();
															#line 42 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (static_cast<TraceDumpWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 125 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 45 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		StrictFuture<ErrorOr<std::vector<WorkerDetails>>> __when_expr_1 = db->get().clusterInterface.getWorkers.tryGetReply(GetWorkersRequest());
															#line 129 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<TraceDumpWorkersActor*>(this)->actor_wait_state = 1;
															#line 43 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TraceDumpWorkersActor, 0, Void >*>(static_cast<TraceDumpWorkersActor*>(this)));
															#line 45 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TraceDumpWorkersActor, 1, ErrorOr<std::vector<WorkerDetails>> >*>(static_cast<TraceDumpWorkersActor*>(this)));
															#line 136 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(ErrorOr<std::vector<WorkerDetails>> const& workerList,int loopDepth) 
	{
															#line 47 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (workerList.present())
															#line 163 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 48 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			std::vector<Future<ErrorOr<Void>>> dumpRequests;
															#line 49 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			dumpRequests.reserve(workerList.get().size());
															#line 50 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			for(int i = 0;i < workerList.get().size();i++) {
															#line 51 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				dumpRequests.push_back(workerList.get()[i].interf.traceBatchDumpRequest.tryGetReply( TraceBatchDumpRequest()));
															#line 173 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			}
															#line 53 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			StrictFuture<Void> __when_expr_2 = waitForAll(dumpRequests);
															#line 53 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			if (static_cast<TraceDumpWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 179 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2when1(__when_expr_2.get(), loopDepth); };
			static_cast<TraceDumpWorkersActor*>(this)->actor_wait_state = 2;
															#line 53 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TraceDumpWorkersActor, 2, Void >*>(static_cast<TraceDumpWorkersActor*>(this)));
															#line 184 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1when2cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when2(ErrorOr<std::vector<WorkerDetails>> && workerList,int loopDepth) 
	{
															#line 47 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (workerList.present())
															#line 198 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 48 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			std::vector<Future<ErrorOr<Void>>> dumpRequests;
															#line 49 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			dumpRequests.reserve(workerList.get().size());
															#line 50 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			for(int i = 0;i < workerList.get().size();i++) {
															#line 51 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				dumpRequests.push_back(workerList.get()[i].interf.traceBatchDumpRequest.tryGetReply( TraceBatchDumpRequest()));
															#line 208 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			}
															#line 53 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			StrictFuture<Void> __when_expr_2 = waitForAll(dumpRequests);
															#line 53 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			if (static_cast<TraceDumpWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 214 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2when1(__when_expr_2.get(), loopDepth); };
			static_cast<TraceDumpWorkersActor*>(this)->actor_wait_state = 2;
															#line 53 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TraceDumpWorkersActor, 2, Void >*>(static_cast<TraceDumpWorkersActor*>(this)));
															#line 219 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1when2cont1(loopDepth);
		}

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TraceDumpWorkersActor*>(this)->actor_wait_state > 0) static_cast<TraceDumpWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<TraceDumpWorkersActor*>(this)->ActorCallback< TraceDumpWorkersActor, 0, Void >::remove();
		static_cast<TraceDumpWorkersActor*>(this)->ActorCallback< TraceDumpWorkersActor, 1, ErrorOr<std::vector<WorkerDetails>> >::remove();

	}
	void a_callback_fire(ActorCallback< TraceDumpWorkersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("traceDumpWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TraceDumpWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceDumpWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TraceDumpWorkersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("traceDumpWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TraceDumpWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceDumpWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TraceDumpWorkersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("traceDumpWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TraceDumpWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceDumpWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1when2cont1(int loopDepth) 
	{
															#line 56 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(1.0);
															#line 56 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (static_cast<TraceDumpWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 299 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<TraceDumpWorkersActor*>(this)->actor_wait_state = 3;
															#line 56 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TraceDumpWorkersActor, 3, Void >*>(static_cast<TraceDumpWorkersActor*>(this)));
															#line 304 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when2cont2(Void const& _,int loopDepth) 
	{
															#line 54 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (!static_cast<TraceDumpWorkersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~TraceDumpWorkersActorState(); static_cast<TraceDumpWorkersActor*>(this)->destroy(); return 0; }
															#line 313 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		new (&static_cast<TraceDumpWorkersActor*>(this)->SAV< bool >::value()) bool(true);
		this->~TraceDumpWorkersActorState();
		static_cast<TraceDumpWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2cont2(Void && _,int loopDepth) 
	{
															#line 54 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (!static_cast<TraceDumpWorkersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~TraceDumpWorkersActorState(); static_cast<TraceDumpWorkersActor*>(this)->destroy(); return 0; }
															#line 325 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		new (&static_cast<TraceDumpWorkersActor*>(this)->SAV< bool >::value()) bool(true);
		this->~TraceDumpWorkersActorState();
		static_cast<TraceDumpWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TraceDumpWorkersActor*>(this)->actor_wait_state > 0) static_cast<TraceDumpWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<TraceDumpWorkersActor*>(this)->ActorCallback< TraceDumpWorkersActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TraceDumpWorkersActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("traceDumpWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TraceDumpWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceDumpWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TraceDumpWorkersActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("traceDumpWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TraceDumpWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceDumpWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TraceDumpWorkersActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("traceDumpWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TraceDumpWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceDumpWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1when2cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TraceDumpWorkersActor*>(this)->actor_wait_state > 0) static_cast<TraceDumpWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<TraceDumpWorkersActor*>(this)->ActorCallback< TraceDumpWorkersActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TraceDumpWorkersActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("traceDumpWorkers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TraceDumpWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when2cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceDumpWorkers", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TraceDumpWorkersActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("traceDumpWorkers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TraceDumpWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when2cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceDumpWorkers", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TraceDumpWorkersActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("traceDumpWorkers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TraceDumpWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceDumpWorkers", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TraceDumpWorkersActor, 1, ErrorOr<std::vector<WorkerDetails>> >*,ErrorOr<std::vector<WorkerDetails>> const& value) 
	{
		fdb_probe_actor_enter("traceDumpWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TraceDumpWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceDumpWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TraceDumpWorkersActor, 1, ErrorOr<std::vector<WorkerDetails>> >*,ErrorOr<std::vector<WorkerDetails>> && value) 
	{
		fdb_probe_actor_enter("traceDumpWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TraceDumpWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceDumpWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TraceDumpWorkersActor, 1, ErrorOr<std::vector<WorkerDetails>> >*,Error err) 
	{
		fdb_probe_actor_enter("traceDumpWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TraceDumpWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceDumpWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 39 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 554 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
};
// This generated class is to be used only via traceDumpWorkers()
															#line 39 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
class TraceDumpWorkersActor final : public Actor<bool>, public ActorCallback< TraceDumpWorkersActor, 0, Void >, public ActorCallback< TraceDumpWorkersActor, 1, ErrorOr<std::vector<WorkerDetails>> >, public ActorCallback< TraceDumpWorkersActor, 2, Void >, public ActorCallback< TraceDumpWorkersActor, 3, Void >, public FastAllocated<TraceDumpWorkersActor>, public TraceDumpWorkersActorState<TraceDumpWorkersActor> {
															#line 559 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
public:
	using FastAllocated<TraceDumpWorkersActor>::operator new;
	using FastAllocated<TraceDumpWorkersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11982026039741002496UL, 16307527221933257472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TraceDumpWorkersActor, 0, Void >;
friend struct ActorCallback< TraceDumpWorkersActor, 1, ErrorOr<std::vector<WorkerDetails>> >;
friend struct ActorCallback< TraceDumpWorkersActor, 2, Void >;
friend struct ActorCallback< TraceDumpWorkersActor, 3, Void >;
															#line 39 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	TraceDumpWorkersActor(Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 579 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   TraceDumpWorkersActorState<TraceDumpWorkersActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("traceDumpWorkers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11744248667456440064UL, 343757719516736000UL);
		ActorExecutionContextHelper __helper(static_cast<TraceDumpWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("traceDumpWorkers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("traceDumpWorkers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TraceDumpWorkersActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TraceDumpWorkersActor, 2, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TraceDumpWorkersActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 39 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
[[nodiscard]] static Future<bool> traceDumpWorkers( Reference<AsyncVar<ServerDBInfo> const> const& db ) {
															#line 39 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	return Future<bool>(new TraceDumpWorkersActor(db));
															#line 613 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
}

#line 65 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"

																#line 618 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
// This generated class is to be used only via tracePeriodically()
															#line 66 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
template <class TracePeriodicallyActor>
															#line 66 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
class TracePeriodicallyActorState {
															#line 624 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
public:
															#line 66 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	TracePeriodicallyActorState(ReadWriteCommon* const& self) 
															#line 66 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
															#line 66 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		 : self(self),
															#line 67 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   start(now()),
															#line 68 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   elapsed(0.0),
															#line 69 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   last_ops(0)
															#line 637 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("tracePeriodically", reinterpret_cast<unsigned long>(this));

	}
	~TracePeriodicallyActorState() 
	{
		fdb_probe_actor_destroy("tracePeriodically", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 71 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			;
															#line 652 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TracePeriodicallyActorState();
		static_cast<TracePeriodicallyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 72 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		elapsed += self->periodicLoggingInterval;
															#line 73 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delayUntil(start + elapsed);
															#line 73 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (static_cast<TracePeriodicallyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 686 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TracePeriodicallyActor*>(this)->actor_wait_state = 1;
															#line 73 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TracePeriodicallyActor, 0, Void >*>(static_cast<TracePeriodicallyActor*>(this)));
															#line 691 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 75 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		TraceEvent((self->description() + "_RowReadLatency").c_str()) .detail("Mean", self->readLatencies.mean()) .detail("Median", self->readLatencies.median()) .detail("Percentile5", self->readLatencies.percentile(.05)) .detail("Percentile95", self->readLatencies.percentile(.95)) .detail("Percentile99", self->readLatencies.percentile(.99)) .detail("Percentile99_9", self->readLatencies.percentile(.999)) .detail("Max", self->readLatencies.max()) .detail("Count", self->readLatencyCount) .detail("Elapsed", elapsed);
															#line 86 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		TraceEvent((self->description() + "_GRVLatency").c_str()) .detail("Mean", self->GRVLatencies.mean()) .detail("Median", self->GRVLatencies.median()) .detail("Percentile5", self->GRVLatencies.percentile(.05)) .detail("Percentile95", self->GRVLatencies.percentile(.95)) .detail("Percentile99", self->GRVLatencies.percentile(.99)) .detail("Percentile99_9", self->GRVLatencies.percentile(.999)) .detail("Max", self->GRVLatencies.max());
															#line 95 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		TraceEvent((self->description() + "_CommitLatency").c_str()) .detail("Mean", self->commitLatencies.mean()) .detail("Median", self->commitLatencies.median()) .detail("Percentile5", self->commitLatencies.percentile(.05)) .detail("Percentile95", self->commitLatencies.percentile(.95)) .detail("Percentile99", self->commitLatencies.percentile(.99)) .detail("Percentile99_9", self->commitLatencies.percentile(.999)) .detail("Max", self->commitLatencies.max());
															#line 104 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		TraceEvent((self->description() + "_TotalLatency").c_str()) .detail("Mean", self->latencies.mean()) .detail("Median", self->latencies.median()) .detail("Percentile5", self->latencies.percentile(.05)) .detail("Percentile95", self->latencies.percentile(.95)) .detail("Percentile99", self->latencies.percentile(.99)) .detail("Percentile99_9", self->latencies.percentile(.999)) .detail("Max", self->latencies.max());
															#line 113 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		int64_t ops = (self->aTransactions.getValue() * (self->readsPerTransactionA + self->writesPerTransactionA)) + (self->bTransactions.getValue() * (self->readsPerTransactionB + self->writesPerTransactionB));
															#line 116 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		bool recordBegin = self->shouldRecord(std::max(now() - self->periodicLoggingInterval, self->clientBegin));
															#line 117 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		bool recordEnd = self->shouldRecord(now());
															#line 118 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (recordBegin && recordEnd)
															#line 714 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 119 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			std::string ts = format("T=%04.0fs:", elapsed);
															#line 120 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Operations/sec", (ops - last_ops) / self->periodicLoggingInterval, Averaged::False);
															#line 124 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Mean Latency (ms)", 1000 * self->latencies.mean(), Averaged::True);
															#line 126 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Median Latency (ms, averaged)", 1000 * self->latencies.median(), Averaged::True);
															#line 128 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "5% Latency (ms, averaged)", 1000 * self->latencies.percentile(.05), Averaged::True);
															#line 130 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "95% Latency (ms, averaged)", 1000 * self->latencies.percentile(.95), Averaged::True);
															#line 133 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Mean Row Read Latency (ms)", 1000 * self->readLatencies.mean(), Averaged::True);
															#line 135 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Median Row Read Latency (ms, averaged)", 1000 * self->readLatencies.median(), Averaged::True);
															#line 137 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back(ts + "5% Row Read Latency (ms, averaged)", 1000 * self->readLatencies.percentile(.05), Averaged::True);
															#line 140 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back(ts + "95% Row Read Latency (ms, averaged)", 1000 * self->readLatencies.percentile(.95), Averaged::True);
															#line 144 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Mean Total Read Latency (ms)", 1000 * self->fullReadLatencies.mean(), Averaged::True);
															#line 146 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back(ts + "Median Total Read Latency (ms, averaged)", 1000 * self->fullReadLatencies.median(), Averaged::True);
															#line 149 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back(ts + "5% Total Read Latency (ms, averaged)", 1000 * self->fullReadLatencies.percentile(.05), Averaged::True);
															#line 152 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back(ts + "95% Total Read Latency (ms, averaged)", 1000 * self->fullReadLatencies.percentile(.95), Averaged::True);
															#line 156 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Mean GRV Latency (ms)", 1000 * self->GRVLatencies.mean(), Averaged::True);
															#line 158 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Median GRV Latency (ms, averaged)", 1000 * self->GRVLatencies.median(), Averaged::True);
															#line 160 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "5% GRV Latency (ms, averaged)", 1000 * self->GRVLatencies.percentile(.05), Averaged::True);
															#line 162 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "95% GRV Latency (ms, averaged)", 1000 * self->GRVLatencies.percentile(.95), Averaged::True);
															#line 165 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Mean Commit Latency (ms)", 1000 * self->commitLatencies.mean(), Averaged::True);
															#line 167 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Median Commit Latency (ms, averaged)", 1000 * self->commitLatencies.median(), Averaged::True);
															#line 169 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back(ts + "5% Commit Latency (ms, averaged)", 1000 * self->commitLatencies.percentile(.05), Averaged::True);
															#line 172 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back(ts + "95% Commit Latency (ms, averaged)", 1000 * self->commitLatencies.percentile(.95), Averaged::True);
															#line 177 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Max Latency (ms, averaged)", 1000 * self->latencies.max(), Averaged::True);
															#line 179 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Max Row Read Latency (ms, averaged)", 1000 * self->readLatencies.max(), Averaged::True);
															#line 181 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Max Total Read Latency (ms, averaged)", 1000 * self->fullReadLatencies.max(), Averaged::True);
															#line 183 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Max GRV Latency (ms, averaged)", 1000 * self->GRVLatencies.max(), Averaged::True);
															#line 185 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Max Commit Latency (ms, averaged)", 1000 * self->commitLatencies.max(), Averaged::True);
															#line 770 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 188 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		last_ops = ops;
															#line 191 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->latencies.clear();
															#line 192 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->readLatencies.clear();
															#line 193 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->fullReadLatencies.clear();
															#line 194 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->GRVLatencies.clear();
															#line 195 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->commitLatencies.clear();
															#line 198 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->readLatencyTotal = 0.0;
															#line 199 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->readLatencyCount = 0;
															#line 788 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 75 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		TraceEvent((self->description() + "_RowReadLatency").c_str()) .detail("Mean", self->readLatencies.mean()) .detail("Median", self->readLatencies.median()) .detail("Percentile5", self->readLatencies.percentile(.05)) .detail("Percentile95", self->readLatencies.percentile(.95)) .detail("Percentile99", self->readLatencies.percentile(.99)) .detail("Percentile99_9", self->readLatencies.percentile(.999)) .detail("Max", self->readLatencies.max()) .detail("Count", self->readLatencyCount) .detail("Elapsed", elapsed);
															#line 86 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		TraceEvent((self->description() + "_GRVLatency").c_str()) .detail("Mean", self->GRVLatencies.mean()) .detail("Median", self->GRVLatencies.median()) .detail("Percentile5", self->GRVLatencies.percentile(.05)) .detail("Percentile95", self->GRVLatencies.percentile(.95)) .detail("Percentile99", self->GRVLatencies.percentile(.99)) .detail("Percentile99_9", self->GRVLatencies.percentile(.999)) .detail("Max", self->GRVLatencies.max());
															#line 95 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		TraceEvent((self->description() + "_CommitLatency").c_str()) .detail("Mean", self->commitLatencies.mean()) .detail("Median", self->commitLatencies.median()) .detail("Percentile5", self->commitLatencies.percentile(.05)) .detail("Percentile95", self->commitLatencies.percentile(.95)) .detail("Percentile99", self->commitLatencies.percentile(.99)) .detail("Percentile99_9", self->commitLatencies.percentile(.999)) .detail("Max", self->commitLatencies.max());
															#line 104 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		TraceEvent((self->description() + "_TotalLatency").c_str()) .detail("Mean", self->latencies.mean()) .detail("Median", self->latencies.median()) .detail("Percentile5", self->latencies.percentile(.05)) .detail("Percentile95", self->latencies.percentile(.95)) .detail("Percentile99", self->latencies.percentile(.99)) .detail("Percentile99_9", self->latencies.percentile(.999)) .detail("Max", self->latencies.max());
															#line 113 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		int64_t ops = (self->aTransactions.getValue() * (self->readsPerTransactionA + self->writesPerTransactionA)) + (self->bTransactions.getValue() * (self->readsPerTransactionB + self->writesPerTransactionB));
															#line 116 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		bool recordBegin = self->shouldRecord(std::max(now() - self->periodicLoggingInterval, self->clientBegin));
															#line 117 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		bool recordEnd = self->shouldRecord(now());
															#line 118 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (recordBegin && recordEnd)
															#line 811 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 119 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			std::string ts = format("T=%04.0fs:", elapsed);
															#line 120 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Operations/sec", (ops - last_ops) / self->periodicLoggingInterval, Averaged::False);
															#line 124 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Mean Latency (ms)", 1000 * self->latencies.mean(), Averaged::True);
															#line 126 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Median Latency (ms, averaged)", 1000 * self->latencies.median(), Averaged::True);
															#line 128 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "5% Latency (ms, averaged)", 1000 * self->latencies.percentile(.05), Averaged::True);
															#line 130 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "95% Latency (ms, averaged)", 1000 * self->latencies.percentile(.95), Averaged::True);
															#line 133 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Mean Row Read Latency (ms)", 1000 * self->readLatencies.mean(), Averaged::True);
															#line 135 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Median Row Read Latency (ms, averaged)", 1000 * self->readLatencies.median(), Averaged::True);
															#line 137 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back(ts + "5% Row Read Latency (ms, averaged)", 1000 * self->readLatencies.percentile(.05), Averaged::True);
															#line 140 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back(ts + "95% Row Read Latency (ms, averaged)", 1000 * self->readLatencies.percentile(.95), Averaged::True);
															#line 144 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Mean Total Read Latency (ms)", 1000 * self->fullReadLatencies.mean(), Averaged::True);
															#line 146 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back(ts + "Median Total Read Latency (ms, averaged)", 1000 * self->fullReadLatencies.median(), Averaged::True);
															#line 149 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back(ts + "5% Total Read Latency (ms, averaged)", 1000 * self->fullReadLatencies.percentile(.05), Averaged::True);
															#line 152 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back(ts + "95% Total Read Latency (ms, averaged)", 1000 * self->fullReadLatencies.percentile(.95), Averaged::True);
															#line 156 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Mean GRV Latency (ms)", 1000 * self->GRVLatencies.mean(), Averaged::True);
															#line 158 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Median GRV Latency (ms, averaged)", 1000 * self->GRVLatencies.median(), Averaged::True);
															#line 160 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "5% GRV Latency (ms, averaged)", 1000 * self->GRVLatencies.percentile(.05), Averaged::True);
															#line 162 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "95% GRV Latency (ms, averaged)", 1000 * self->GRVLatencies.percentile(.95), Averaged::True);
															#line 165 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Mean Commit Latency (ms)", 1000 * self->commitLatencies.mean(), Averaged::True);
															#line 167 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Median Commit Latency (ms, averaged)", 1000 * self->commitLatencies.median(), Averaged::True);
															#line 169 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back(ts + "5% Commit Latency (ms, averaged)", 1000 * self->commitLatencies.percentile(.05), Averaged::True);
															#line 172 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back(ts + "95% Commit Latency (ms, averaged)", 1000 * self->commitLatencies.percentile(.95), Averaged::True);
															#line 177 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Max Latency (ms, averaged)", 1000 * self->latencies.max(), Averaged::True);
															#line 179 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Max Row Read Latency (ms, averaged)", 1000 * self->readLatencies.max(), Averaged::True);
															#line 181 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Max Total Read Latency (ms, averaged)", 1000 * self->fullReadLatencies.max(), Averaged::True);
															#line 183 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Max GRV Latency (ms, averaged)", 1000 * self->GRVLatencies.max(), Averaged::True);
															#line 185 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->periodicMetrics.emplace_back( ts + "Max Commit Latency (ms, averaged)", 1000 * self->commitLatencies.max(), Averaged::True);
															#line 867 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 188 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		last_ops = ops;
															#line 191 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->latencies.clear();
															#line 192 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->readLatencies.clear();
															#line 193 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->fullReadLatencies.clear();
															#line 194 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->GRVLatencies.clear();
															#line 195 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->commitLatencies.clear();
															#line 198 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->readLatencyTotal = 0.0;
															#line 199 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->readLatencyCount = 0;
															#line 885 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TracePeriodicallyActor*>(this)->actor_wait_state > 0) static_cast<TracePeriodicallyActor*>(this)->actor_wait_state = 0;
		static_cast<TracePeriodicallyActor*>(this)->ActorCallback< TracePeriodicallyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TracePeriodicallyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tracePeriodically", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TracePeriodicallyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracePeriodically", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TracePeriodicallyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tracePeriodically", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TracePeriodicallyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracePeriodically", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TracePeriodicallyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tracePeriodically", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TracePeriodicallyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracePeriodically", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 66 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	ReadWriteCommon* self;
															#line 67 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	double start;
															#line 68 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	double elapsed;
															#line 69 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	int64_t last_ops;
															#line 973 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
};
// This generated class is to be used only via tracePeriodically()
															#line 66 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
class TracePeriodicallyActor final : public Actor<Void>, public ActorCallback< TracePeriodicallyActor, 0, Void >, public FastAllocated<TracePeriodicallyActor>, public TracePeriodicallyActorState<TracePeriodicallyActor> {
															#line 978 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
public:
	using FastAllocated<TracePeriodicallyActor>::operator new;
	using FastAllocated<TracePeriodicallyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3601470272615203328UL, 7075091908219437312UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TracePeriodicallyActor, 0, Void >;
															#line 66 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	TracePeriodicallyActor(ReadWriteCommon* const& self) 
															#line 995 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TracePeriodicallyActorState<TracePeriodicallyActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tracePeriodically", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15798896764292167168UL, 11037908824035524864UL);
		ActorExecutionContextHelper __helper(static_cast<TracePeriodicallyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tracePeriodically");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tracePeriodically", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TracePeriodicallyActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 66 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
[[nodiscard]] static Future<Void> tracePeriodically( ReadWriteCommon* const& self ) {
															#line 66 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	return Future<Void>(new TracePeriodicallyActor(self));
															#line 1027 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
}

#line 202 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
																#line 1031 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
// This generated class is to be used only via logLatency()
															#line 202 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
template <class LogLatencyActor>
															#line 202 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
class LogLatencyActorState {
															#line 1037 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
public:
															#line 202 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	LogLatencyActorState(Future<Optional<Value>> const& f,DDSketch<double>* const& latencies,double* const& totalLatency,int* const& latencyCount,EventMetricHandle<ReadMetric> const& readMetric,bool const& shouldRecord) 
															#line 202 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
															#line 202 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		 : f(f),
															#line 202 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   latencies(latencies),
															#line 202 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   totalLatency(totalLatency),
															#line 202 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   latencyCount(latencyCount),
															#line 202 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   readMetric(readMetric),
															#line 202 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   shouldRecord(shouldRecord),
															#line 208 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   readBegin(now())
															#line 1056 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("logLatency", reinterpret_cast<unsigned long>(this));

	}
	~LogLatencyActorState() 
	{
		fdb_probe_actor_destroy("logLatency", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 209 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = f;
															#line 209 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			if (static_cast<LogLatencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1073 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LogLatencyActor*>(this)->actor_wait_state = 1;
															#line 209 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LogLatencyActor, 0, Optional<Value> >*>(static_cast<LogLatencyActor*>(this)));
															#line 1078 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LogLatencyActorState();
		static_cast<LogLatencyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& value,int loopDepth) 
	{
															#line 211 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		double latency = now() - readBegin;
															#line 212 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		readMetric->readLatency = latency * 1e9;
															#line 213 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		readMetric->log();
															#line 215 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (shouldRecord)
															#line 1107 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 216 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			*totalLatency += latency;
															#line 217 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			++*latencyCount;
															#line 218 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			latencies->addSample(latency);
															#line 1115 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 220 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (!static_cast<LogLatencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LogLatencyActorState(); static_cast<LogLatencyActor*>(this)->destroy(); return 0; }
															#line 1119 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		new (&static_cast<LogLatencyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LogLatencyActorState();
		static_cast<LogLatencyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && value,int loopDepth) 
	{
															#line 211 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		double latency = now() - readBegin;
															#line 212 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		readMetric->readLatency = latency * 1e9;
															#line 213 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		readMetric->log();
															#line 215 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (shouldRecord)
															#line 1137 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 216 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			*totalLatency += latency;
															#line 217 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			++*latencyCount;
															#line 218 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			latencies->addSample(latency);
															#line 1145 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 220 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (!static_cast<LogLatencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LogLatencyActorState(); static_cast<LogLatencyActor*>(this)->destroy(); return 0; }
															#line 1149 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		new (&static_cast<LogLatencyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LogLatencyActorState();
		static_cast<LogLatencyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& value,int loopDepth) 
	{
		loopDepth = a_body1cont1(value, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && value,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LogLatencyActor*>(this)->actor_wait_state > 0) static_cast<LogLatencyActor*>(this)->actor_wait_state = 0;
		static_cast<LogLatencyActor*>(this)->ActorCallback< LogLatencyActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< LogLatencyActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("logLatency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogLatencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logLatency", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LogLatencyActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("logLatency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogLatencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logLatency", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LogLatencyActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("logLatency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogLatencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logLatency", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 202 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	Future<Optional<Value>> f;
															#line 202 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	DDSketch<double>* latencies;
															#line 202 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	double* totalLatency;
															#line 202 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	int* latencyCount;
															#line 202 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	EventMetricHandle<ReadMetric> readMetric;
															#line 202 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	bool shouldRecord;
															#line 208 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	double readBegin;
															#line 1246 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
};
// This generated class is to be used only via logLatency()
															#line 202 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
class LogLatencyActor final : public Actor<Void>, public ActorCallback< LogLatencyActor, 0, Optional<Value> >, public FastAllocated<LogLatencyActor>, public LogLatencyActorState<LogLatencyActor> {
															#line 1251 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
public:
	using FastAllocated<LogLatencyActor>::operator new;
	using FastAllocated<LogLatencyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8851350694654040064UL, 2581306823677655808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LogLatencyActor, 0, Optional<Value> >;
															#line 202 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	LogLatencyActor(Future<Optional<Value>> const& f,DDSketch<double>* const& latencies,double* const& totalLatency,int* const& latencyCount,EventMetricHandle<ReadMetric> const& readMetric,bool const& shouldRecord) 
															#line 1268 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   LogLatencyActorState<LogLatencyActor>(f, latencies, totalLatency, latencyCount, readMetric, shouldRecord),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("logLatency", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10170994824737762048UL, 197458950419200512UL);
		ActorExecutionContextHelper __helper(static_cast<LogLatencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("logLatency");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("logLatency", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LogLatencyActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 202 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
[[nodiscard]] static Future<Void> logLatency( Future<Optional<Value>> const& f, DDSketch<double>* const& latencies, double* const& totalLatency, int* const& latencyCount, EventMetricHandle<ReadMetric> const& readMetric, bool const& shouldRecord ) {
															#line 202 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	return Future<Void>(new LogLatencyActor(f, latencies, totalLatency, latencyCount, readMetric, shouldRecord));
															#line 1300 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
}

#line 222 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
																#line 1304 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
// This generated class is to be used only via logLatency()
															#line 222 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
template <class LogLatencyActor1>
															#line 222 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
class LogLatencyActor1State {
															#line 1310 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
public:
															#line 222 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	LogLatencyActor1State(Future<RangeResult> const& f,DDSketch<double>* const& latencies,double* const& totalLatency,int* const& latencyCount,EventMetricHandle<ReadMetric> const& readMetric,bool const& shouldRecord) 
															#line 222 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
															#line 222 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		 : f(f),
															#line 222 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   latencies(latencies),
															#line 222 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   totalLatency(totalLatency),
															#line 222 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   latencyCount(latencyCount),
															#line 222 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   readMetric(readMetric),
															#line 222 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   shouldRecord(shouldRecord),
															#line 228 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   readBegin(now())
															#line 1329 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("logLatency", reinterpret_cast<unsigned long>(this));

	}
	~LogLatencyActor1State() 
	{
		fdb_probe_actor_destroy("logLatency", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 229 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = f;
															#line 229 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			if (static_cast<LogLatencyActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1346 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LogLatencyActor1*>(this)->actor_wait_state = 1;
															#line 229 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LogLatencyActor1, 0, RangeResult >*>(static_cast<LogLatencyActor1*>(this)));
															#line 1351 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LogLatencyActor1State();
		static_cast<LogLatencyActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& value,int loopDepth) 
	{
															#line 231 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		double latency = now() - readBegin;
															#line 232 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		readMetric->readLatency = latency * 1e9;
															#line 233 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		readMetric->log();
															#line 235 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (shouldRecord)
															#line 1380 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 236 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			*totalLatency += latency;
															#line 237 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			++*latencyCount;
															#line 238 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			latencies->addSample(latency);
															#line 1388 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 240 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (!static_cast<LogLatencyActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LogLatencyActor1State(); static_cast<LogLatencyActor1*>(this)->destroy(); return 0; }
															#line 1392 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		new (&static_cast<LogLatencyActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~LogLatencyActor1State();
		static_cast<LogLatencyActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && value,int loopDepth) 
	{
															#line 231 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		double latency = now() - readBegin;
															#line 232 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		readMetric->readLatency = latency * 1e9;
															#line 233 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		readMetric->log();
															#line 235 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (shouldRecord)
															#line 1410 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 236 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			*totalLatency += latency;
															#line 237 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			++*latencyCount;
															#line 238 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			latencies->addSample(latency);
															#line 1418 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 240 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (!static_cast<LogLatencyActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LogLatencyActor1State(); static_cast<LogLatencyActor1*>(this)->destroy(); return 0; }
															#line 1422 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		new (&static_cast<LogLatencyActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~LogLatencyActor1State();
		static_cast<LogLatencyActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& value,int loopDepth) 
	{
		loopDepth = a_body1cont1(value, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && value,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LogLatencyActor1*>(this)->actor_wait_state > 0) static_cast<LogLatencyActor1*>(this)->actor_wait_state = 0;
		static_cast<LogLatencyActor1*>(this)->ActorCallback< LogLatencyActor1, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< LogLatencyActor1, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("logLatency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogLatencyActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logLatency", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LogLatencyActor1, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("logLatency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogLatencyActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logLatency", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LogLatencyActor1, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("logLatency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogLatencyActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logLatency", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 222 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	Future<RangeResult> f;
															#line 222 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	DDSketch<double>* latencies;
															#line 222 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	double* totalLatency;
															#line 222 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	int* latencyCount;
															#line 222 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	EventMetricHandle<ReadMetric> readMetric;
															#line 222 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	bool shouldRecord;
															#line 228 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	double readBegin;
															#line 1519 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
};
// This generated class is to be used only via logLatency()
															#line 222 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
class LogLatencyActor1 final : public Actor<Void>, public ActorCallback< LogLatencyActor1, 0, RangeResult >, public FastAllocated<LogLatencyActor1>, public LogLatencyActor1State<LogLatencyActor1> {
															#line 1524 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
public:
	using FastAllocated<LogLatencyActor1>::operator new;
	using FastAllocated<LogLatencyActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8851350694654040064UL, 2581306823677655808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LogLatencyActor1, 0, RangeResult >;
															#line 222 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	LogLatencyActor1(Future<RangeResult> const& f,DDSketch<double>* const& latencies,double* const& totalLatency,int* const& latencyCount,EventMetricHandle<ReadMetric> const& readMetric,bool const& shouldRecord) 
															#line 1541 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   LogLatencyActor1State<LogLatencyActor1>(f, latencies, totalLatency, latencyCount, readMetric, shouldRecord),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("logLatency", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7142511557076950784UL, 858887124400239872UL);
		ActorExecutionContextHelper __helper(static_cast<LogLatencyActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("logLatency");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("logLatency", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LogLatencyActor1, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 222 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
[[nodiscard]] static Future<Void> logLatency( Future<RangeResult> const& f, DDSketch<double>* const& latencies, double* const& totalLatency, int* const& latencyCount, EventMetricHandle<ReadMetric> const& readMetric, bool const& shouldRecord ) {
															#line 222 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	return Future<Void>(new LogLatencyActor1(f, latencies, totalLatency, latencyCount, readMetric, shouldRecord));
															#line 1573 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
}

#line 242 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"

																#line 1578 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
// This generated class is to be used only via setup()
															#line 243 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
template <class SetupActor>
															#line 243 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
class SetupActorState {
															#line 1584 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
public:
															#line 243 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	SetupActorState(Database const& cx,ReadWriteCommon* const& self) 
															#line 243 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
															#line 243 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		 : cx(cx),
															#line 243 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   self(self)
															#line 1593 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("setup", reinterpret_cast<unsigned long>(this));

	}
	~SetupActorState() 
	{
		fdb_probe_actor_destroy("setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 244 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			if (!self->doSetup)
															#line 1608 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			{
															#line 245 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				if (!static_cast<SetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActorState(); static_cast<SetupActor*>(this)->destroy(); return 0; }
															#line 1612 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
				new (&static_cast<SetupActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~SetupActorState();
				static_cast<SetupActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 247 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			loadTime = Promise<double>();
															#line 248 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			ratesAtKeyCounts = Promise<std::vector<std::pair<uint64_t, double>>>();
															#line 250 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			StrictFuture<Void> __when_expr_0 = bulkSetup(cx, self, self->nodeCount, loadTime, self->insertionCountsToMeasure.empty(), self->warmingDelay, self->maxInsertRate, self->insertionCountsToMeasure, ratesAtKeyCounts);
															#line 250 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			if (static_cast<SetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1626 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetupActor*>(this)->actor_wait_state = 1;
															#line 250 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetupActor, 0, Void >*>(static_cast<SetupActor*>(this)));
															#line 1631 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetupActorState();
		static_cast<SetupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 260 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->loadTime = loadTime.getFuture().get();
															#line 261 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->ratesAtKeyCounts = ratesAtKeyCounts.getFuture().get();
															#line 263 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (!static_cast<SetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActorState(); static_cast<SetupActor*>(this)->destroy(); return 0; }
															#line 1658 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		new (&static_cast<SetupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupActorState();
		static_cast<SetupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 260 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->loadTime = loadTime.getFuture().get();
															#line 261 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->ratesAtKeyCounts = ratesAtKeyCounts.getFuture().get();
															#line 263 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (!static_cast<SetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActorState(); static_cast<SetupActor*>(this)->destroy(); return 0; }
															#line 1674 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		new (&static_cast<SetupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupActorState();
		static_cast<SetupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetupActor*>(this)->actor_wait_state > 0) static_cast<SetupActor*>(this)->actor_wait_state = 0;
		static_cast<SetupActor*>(this)->ActorCallback< SetupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 243 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	Database cx;
															#line 243 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	ReadWriteCommon* self;
															#line 247 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	Promise<double> loadTime;
															#line 248 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	Promise<std::vector<std::pair<uint64_t, double>>> ratesAtKeyCounts;
															#line 1765 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
};
// This generated class is to be used only via setup()
															#line 243 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
class SetupActor final : public Actor<Void>, public ActorCallback< SetupActor, 0, Void >, public FastAllocated<SetupActor>, public SetupActorState<SetupActor> {
															#line 1770 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
public:
	using FastAllocated<SetupActor>::operator new;
	using FastAllocated<SetupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17573840482026100736UL, 11748247652283401216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetupActor, 0, Void >;
															#line 243 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	SetupActor(Database const& cx,ReadWriteCommon* const& self) 
															#line 1787 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   SetupActorState<SetupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13998344965578828288UL, 688267501332814080UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetupActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 243 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
[[nodiscard]] static Future<Void> setup( Database const& cx, ReadWriteCommon* const& self ) {
															#line 243 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	return Future<Void>(new SetupActor(cx, self));
															#line 1819 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
}

#line 265 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
};

Future<Void> ReadWriteCommon::tracePeriodically() {
	return ReadWriteCommonImpl::tracePeriodically(this);
}

Future<Void> ReadWriteCommon::logLatency(Future<Optional<Value>> f, bool shouldRecord) {
	return ReadWriteCommonImpl::logLatency(
	    f, &readLatencies, &readLatencyTotal, &readLatencyCount, readMetric, shouldRecord);
}

Future<Void> ReadWriteCommon::logLatency(Future<RangeResult> f, bool shouldRecord) {
	return ReadWriteCommonImpl::logLatency(
	    f, &readLatencies, &readLatencyTotal, &readLatencyCount, readMetric, shouldRecord);
}

Future<Void> ReadWriteCommon::setup(Database const& cx) {
	return ReadWriteCommonImpl::setup(cx, this);
}

Future<bool> ReadWriteCommon::check(Database const& cx) {
	clients.clear();

	if (!cancelWorkersAtDuration && now() < metricsStart + metricsDuration)
		metricsDuration = now() - metricsStart;

	g_traceBatch.dump();
	if (clientId == 0)
		return ReadWriteCommonImpl::traceDumpWorkers(dbInfo);
	else
		return true;
}

void ReadWriteCommon::getMetrics(std::vector<PerfMetric>& m) {
	double duration = metricsDuration;
	int reads = (aTransactions.getValue() * readsPerTransactionA) + (bTransactions.getValue() * readsPerTransactionB);
	int writes =
	    (aTransactions.getValue() * writesPerTransactionA) + (bTransactions.getValue() * writesPerTransactionB);
	m.emplace_back("Measured Duration", duration, Averaged::True);
	m.emplace_back(
	    "Transactions/sec", (aTransactions.getValue() + bTransactions.getValue()) / duration, Averaged::False);
	m.emplace_back("Operations/sec", ((reads + writes) / duration), Averaged::False);
	m.push_back(aTransactions.getMetric());
	m.push_back(bTransactions.getMetric());
	m.push_back(retries.getMetric());
	m.emplace_back("Mean load time (seconds)", loadTime, Averaged::True);
	m.emplace_back("Read rows", reads, Averaged::False);
	m.emplace_back("Write rows", writes, Averaged::False);
	m.emplace_back("Read rows/sec", reads / duration, Averaged::False);
	m.emplace_back("Write rows/sec", writes / duration, Averaged::False);
	m.emplace_back(
	    "Bytes read/sec", (reads * (keyBytes + (minValueBytes + maxValueBytes) * 0.5)) / duration, Averaged::False);
	m.emplace_back(
	    "Bytes written/sec", (writes * (keyBytes + (minValueBytes + maxValueBytes) * 0.5)) / duration, Averaged::False);
	m.insert(m.end(), periodicMetrics.begin(), periodicMetrics.end());

	std::vector<std::pair<uint64_t, double>>::iterator ratesItr = ratesAtKeyCounts.begin();
	for (; ratesItr != ratesAtKeyCounts.end(); ratesItr++)
		m.emplace_back(format("%lld keys imported bytes/sec", ratesItr->first), ratesItr->second, Averaged::False);
}

Standalone<KeyValueRef> ReadWriteCommon::operator()(uint64_t n) {
	return KeyValueRef(keyForIndex(n, false), randomValue());
}

bool ReadWriteCommon::shouldRecord(double checkTime) {
	double timeSinceStart = checkTime - clientBegin;
	return timeSinceStart >= metricsStart && timeSinceStart < (metricsStart + metricsDuration);
}

static Future<Version> nextRV;
static Version lastRV = invalidVersion;

															#line 1896 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getNextRV()
															#line 338 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
template <class GetNextRVActor>
															#line 338 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
class GetNextRVActorState {
															#line 1903 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
public:
															#line 338 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	GetNextRVActorState(Database const& db) 
															#line 338 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
															#line 338 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		 : db(db),
															#line 339 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   tr(db)
															#line 1912 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getNextRV", reinterpret_cast<unsigned long>(this));

	}
	~GetNextRVActorState() 
	{
		fdb_probe_actor_destroy("getNextRV", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 340 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			;
															#line 1927 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetNextRVActorState();
		static_cast<GetNextRVActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 342 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 342 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			if (static_cast<GetNextRVActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1960 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetNextRVActor*>(this)->actor_wait_state = 1;
															#line 342 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetNextRVActor, 0, Version >*>(static_cast<GetNextRVActor*>(this)));
															#line 1965 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 345 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 345 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			if (static_cast<GetNextRVActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1989 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetNextRVActor*>(this)->actor_wait_state = 2;
															#line 345 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetNextRVActor, 1, Void >*>(static_cast<GetNextRVActor*>(this)));
															#line 1994 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& v,int loopDepth) 
	{
															#line 343 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (!static_cast<GetNextRVActor*>(this)->SAV<Version>::futures) { (void)(v); this->~GetNextRVActorState(); static_cast<GetNextRVActor*>(this)->destroy(); return 0; }
															#line 2009 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		new (&static_cast<GetNextRVActor*>(this)->SAV< Version >::value()) Version(v);
		this->~GetNextRVActorState();
		static_cast<GetNextRVActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && v,int loopDepth) 
	{
															#line 343 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (!static_cast<GetNextRVActor*>(this)->SAV<Version>::futures) { (void)(v); this->~GetNextRVActorState(); static_cast<GetNextRVActor*>(this)->destroy(); return 0; }
															#line 2021 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		new (&static_cast<GetNextRVActor*>(this)->SAV< Version >::value()) Version(v);
		this->~GetNextRVActorState();
		static_cast<GetNextRVActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetNextRVActor*>(this)->actor_wait_state > 0) static_cast<GetNextRVActor*>(this)->actor_wait_state = 0;
		static_cast<GetNextRVActor*>(this)->ActorCallback< GetNextRVActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< GetNextRVActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getNextRV", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNextRVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNextRV", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetNextRVActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getNextRV", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNextRVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNextRV", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetNextRVActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getNextRV", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetNextRVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNextRV", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetNextRVActor*>(this)->actor_wait_state > 0) static_cast<GetNextRVActor*>(this)->actor_wait_state = 0;
		static_cast<GetNextRVActor*>(this)->ActorCallback< GetNextRVActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetNextRVActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getNextRV", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNextRVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNextRV", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetNextRVActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getNextRV", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNextRVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNextRV", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetNextRVActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getNextRV", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetNextRVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNextRV", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 338 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	Database db;
															#line 339 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	Transaction tr;
															#line 2195 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getNextRV()
															#line 338 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
class GetNextRVActor final : public Actor<Version>, public ActorCallback< GetNextRVActor, 0, Version >, public ActorCallback< GetNextRVActor, 1, Void >, public FastAllocated<GetNextRVActor>, public GetNextRVActorState<GetNextRVActor> {
															#line 2200 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetNextRVActor>::operator new;
	using FastAllocated<GetNextRVActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13054935240865625856UL, 13158966807565985280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetNextRVActor, 0, Version >;
friend struct ActorCallback< GetNextRVActor, 1, Void >;
															#line 338 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	GetNextRVActor(Database const& db) 
															#line 2218 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		 : Actor<Version>(),
		   GetNextRVActorState<GetNextRVActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getNextRV", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14387613445957692928UL, 13813558698116350208UL);
		ActorExecutionContextHelper __helper(static_cast<GetNextRVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getNextRV");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getNextRV", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetNextRVActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetNextRVActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 338 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
[[nodiscard]] static Future<Version> getNextRV( Database const& db ) {
															#line 338 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	return Future<Version>(new GetNextRVActor(db));
															#line 2252 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
}

#line 349 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"

static Future<Version> getInconsistentReadVersion(Database const& db) {
	if (!nextRV.isValid() || nextRV.isReady()) { // if no getNextRV() running
		if (nextRV.isValid())
			lastRV = nextRV.get();
		nextRV = getNextRV(db);
	}
	if (lastRV == invalidVersion)
		return nextRV;
	else
		return lastRV;
}

struct ReadWriteWorkload : ReadWriteCommon {
	static constexpr auto NAME = "ReadWrite";
	// use ReadWrite as a ramp up workload
	bool rampUpLoad; // indicate this is a ramp up workload
	int rampSweepCount; // how many times of ramp up
	bool rampTransactionType; // choose transaction type based on client start time
	bool rampUpConcurrency; // control client concurrency

	// transaction setting
	bool batchPriority;
	bool rangeReads; // read operations are all single key range read
	bool dependentReads; // read operations are issued sequentially
	bool inconsistentReads; // read with previous read version
	bool adjacentReads; // keys are adjacent within a transaction
	bool adjacentWrites;
	int extraReadConflictRangesPerTransaction, extraWriteConflictRangesPerTransaction;
	ReadType readType;
	bool cacheResult;
	Optional<Key> transactionTag;

	int transactionsTagThrottled{ 0 };

	// hot traffic pattern
	double hotKeyFraction, forceHotProbability = 0; // key based hot traffic setting

	ReadWriteWorkload(WorkloadContext const& wcx)
	  : ReadWriteCommon(wcx), dependentReads(false), adjacentReads(false), adjacentWrites(false) {
		extraReadConflictRangesPerTransaction = getOption(options, "extraReadConflictRangesPerTransaction"_sr, 0);
		extraWriteConflictRangesPerTransaction = getOption(options, "extraWriteConflictRangesPerTransaction"_sr, 0);
		dependentReads = getOption(options, "dependentReads"_sr, false);
		inconsistentReads = getOption(options, "inconsistentReads"_sr, false);
		adjacentReads = getOption(options, "adjacentReads"_sr, false);
		adjacentWrites = getOption(options, "adjacentWrites"_sr, false);
		rampUpLoad = getOption(options, "rampUpLoad"_sr, false);
		rampSweepCount = getOption(options, "rampSweepCount"_sr, 1);
		rangeReads = getOption(options, "rangeReads"_sr, false);
		rampTransactionType = getOption(options, "rampTransactionType"_sr, false);
		rampUpConcurrency = getOption(options, "rampUpConcurrency"_sr, false);
		batchPriority = getOption(options, "batchPriority"_sr, false);
		descriptionString = getOption(options, "description"_sr, "ReadWrite"_sr);
		readType = static_cast<ReadType>(getOption(options, "readType"_sr, (int)ReadType::NORMAL));
		cacheResult = getOption(options, "cacheResult"_sr, true);
		if (hasOption(options, "transactionTag"_sr)) {
			transactionTag = getOption(options, "transactionTag"_sr, ""_sr);
		}

		if (rampUpConcurrency)
			ASSERT(rampSweepCount == 2); // Implementation is hard coded to ramp up and down

		{
			// with P(hotTrafficFraction) an access is directed to one of a fraction
			//   of hot keys, else it is directed to a disjoint set of cold keys
			hotKeyFraction = getOption(options, "hotKeyFraction"_sr, 0.0);
			double hotTrafficFraction = getOption(options, "hotTrafficFraction"_sr, 0.0);
			ASSERT(hotKeyFraction >= 0 && hotTrafficFraction <= 1);
			ASSERT(hotKeyFraction <= hotTrafficFraction); // hot keys should be actually hot!
			// p(Cold key) = (1-FHP) * (1-hkf)
			// p(Cold key) = (1-htf)
			// solving for FHP gives:
			forceHotProbability = (hotTrafficFraction - hotKeyFraction) / (1 - hotKeyFraction);
		}
	}

	template <class Trans>
	void setupTransaction(Trans& tr) {
		if (batchPriority) {
			tr.setOption(FDBTransactionOptions::PRIORITY_BATCH);
		}
		if (transactionTag.present() && tr.getTags().size() == 0) {
			tr.setOption(FDBTransactionOptions::AUTO_THROTTLE_TAG, transactionTag.get());
		}

		if (cacheResult) {
			// Enabled is the default, but sometimes set it explicitly
			if (BUGGIFY) {
				tr.setOption(FDBTransactionOptions::READ_SERVER_SIDE_CACHE_ENABLE);
			}
		} else {
			tr.setOption(FDBTransactionOptions::READ_SERVER_SIDE_CACHE_DISABLE);
		}

		// ReadTypes of LOW, NORMAL, and HIGH can be set through transaction options, so setOption for those
		if (readType == ReadType::LOW) {
			tr.setOption(FDBTransactionOptions::READ_PRIORITY_LOW);
		} else if (readType == ReadType::NORMAL) {
			tr.setOption(FDBTransactionOptions::READ_PRIORITY_NORMAL);
		} else if (readType == ReadType::HIGH) {
			tr.setOption(FDBTransactionOptions::READ_PRIORITY_HIGH);
		} else {
			// Otherwise fall back to NativeAPI readOptions
			tr.getTransaction().trState->readOptions.withDefault(ReadOptions()).type = readType;
		}
	}

	void getMetrics(std::vector<PerfMetric>& m) override {
		ReadWriteCommon::getMetrics(m);
		if (!rampUpLoad) {
			m.emplace_back("Mean Latency (ms)", 1000 * latencies.mean(), Averaged::True);
			m.emplace_back("Median Latency (ms, averaged)", 1000 * latencies.median(), Averaged::True);
			m.emplace_back("90% Latency (ms, averaged)", 1000 * latencies.percentile(0.90), Averaged::True);
			m.emplace_back("98% Latency (ms, averaged)", 1000 * latencies.percentile(0.98), Averaged::True);
			m.emplace_back("Max Latency (ms, averaged)", 1000 * latencies.max(), Averaged::True);

			m.emplace_back("Mean Row Read Latency (ms)", 1000 * readLatencies.mean(), Averaged::True);
			m.emplace_back("Median Row Read Latency (ms, averaged)", 1000 * readLatencies.median(), Averaged::True);
			m.emplace_back("Max Row Read Latency (ms, averaged)", 1000 * readLatencies.max(), Averaged::True);

			m.emplace_back("Mean Total Read Latency (ms)", 1000 * fullReadLatencies.mean(), Averaged::True);
			m.emplace_back(
			    "Median Total Read Latency (ms, averaged)", 1000 * fullReadLatencies.median(), Averaged::True);
			m.emplace_back("Max Total Latency (ms, averaged)", 1000 * fullReadLatencies.max(), Averaged::True);

			m.emplace_back("Mean GRV Latency (ms)", 1000 * GRVLatencies.mean(), Averaged::True);
			m.emplace_back("Median GRV Latency (ms, averaged)", 1000 * GRVLatencies.median(), Averaged::True);
			m.emplace_back("Max GRV Latency (ms, averaged)", 1000 * GRVLatencies.max(), Averaged::True);

			m.emplace_back("Mean Commit Latency (ms)", 1000 * commitLatencies.mean(), Averaged::True);
			m.emplace_back("Median Commit Latency (ms, averaged)", 1000 * commitLatencies.median(), Averaged::True);
			m.emplace_back("Max Commit Latency (ms, averaged)", 1000 * commitLatencies.max(), Averaged::True);
			if (transactionTag.present()) {
				m.emplace_back("Transaction Tag Throttled", transactionsTagThrottled, Averaged::False);
			}
		}
	}

	Future<Void> start(Database const& cx) override { return timeout(_start(cx, this), testDuration, Void()); }

																#line 2396 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
// This generated class is to be used only via readOp()
															#line 489 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
template <class Trans, class ReadOpActor>
															#line 489 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
class ReadOpActorState {
															#line 2402 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
public:
															#line 489 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	ReadOpActorState(Trans* const& tr,std::vector<int64_t> const& keys,ReadWriteWorkload* const& self,bool const& shouldRecord) 
															#line 489 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
															#line 489 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		 : tr(tr),
															#line 489 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   keys(keys),
															#line 489 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   self(self),
															#line 489 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   shouldRecord(shouldRecord)
															#line 2415 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("readOp", reinterpret_cast<unsigned long>(this));

	}
	~ReadOpActorState() 
	{
		fdb_probe_actor_destroy("readOp", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 491 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			if (!keys.size())
															#line 2430 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			{
															#line 492 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				if (!static_cast<ReadOpActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReadOpActorState(); static_cast<ReadOpActor*>(this)->destroy(); return 0; }
															#line 2434 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
				new (&static_cast<ReadOpActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ReadOpActorState();
				static_cast<ReadOpActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 493 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			if (!self->dependentReads)
															#line 2442 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			{
															#line 494 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				std::vector<Future<Void>> readers;
															#line 495 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				if (self->rangeReads)
															#line 2448 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
				{
															#line 496 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
					for(int op = 0;op < keys.size();op++) {
															#line 497 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
						++self->totalReadsMetric;
															#line 498 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
						readers.push_back(self->logLatency( tr->getRange(KeyRangeRef(self->keyForIndex(keys[op]), Key(strinc(self->keyForIndex(keys[op])))), GetRangeLimits(-1, 80000)), shouldRecord));
															#line 2456 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
					}
				}
				else
				{
															#line 504 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
					for(int op = 0;op < keys.size();op++) {
															#line 505 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
						++self->totalReadsMetric;
															#line 506 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
						readers.push_back(self->logLatency(tr->get(self->keyForIndex(keys[op])), shouldRecord));
															#line 2467 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
					}
				}
															#line 509 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				StrictFuture<Void> __when_expr_0 = waitForAll(readers);
															#line 509 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				if (static_cast<ReadOpActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2474 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReadOpActor*>(this)->actor_wait_state = 1;
															#line 509 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadOpActor, 0, Void >*>(static_cast<ReadOpActor*>(this)));
															#line 2479 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 511 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				op = int();
															#line 512 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				op = 0;
															#line 2488 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadOpActorState();
		static_cast<ReadOpActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 517 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (!static_cast<ReadOpActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReadOpActorState(); static_cast<ReadOpActor*>(this)->destroy(); return 0; }
															#line 2512 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		new (&static_cast<ReadOpActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReadOpActorState();
		static_cast<ReadOpActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadOpActor*>(this)->actor_wait_state > 0) static_cast<ReadOpActor*>(this)->actor_wait_state = 0;
		static_cast<ReadOpActor*>(this)->ActorCallback< ReadOpActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadOpActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readOp", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadOpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readOp", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadOpActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readOp", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadOpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readOp", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadOpActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readOp", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadOpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readOp", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont8(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 512 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (!(op < keys.size()))
															#line 2624 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 513 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		++self->totalReadsMetric;
															#line 514 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->logLatency(tr->get(self->keyForIndex(keys[op])), shouldRecord);
															#line 514 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (static_cast<ReadOpActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2634 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadOpActor*>(this)->actor_wait_state = 2;
															#line 514 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadOpActor, 1, Void >*>(static_cast<ReadOpActor*>(this)));
															#line 2639 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 512 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		op++;
															#line 2661 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 512 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		op++;
															#line 2670 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadOpActor*>(this)->actor_wait_state > 0) static_cast<ReadOpActor*>(this)->actor_wait_state = 0;
		static_cast<ReadOpActor*>(this)->ActorCallback< ReadOpActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadOpActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readOp", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadOpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readOp", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadOpActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readOp", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadOpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readOp", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadOpActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readOp", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadOpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readOp", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 489 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	Trans* tr;
															#line 489 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	std::vector<int64_t> keys;
															#line 489 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	ReadWriteWorkload* self;
															#line 489 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	bool shouldRecord;
															#line 511 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	int op;
															#line 2760 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
};
// This generated class is to be used only via readOp()
															#line 489 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
template <class Trans>
															#line 489 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
class ReadOpActor final : public Actor<Void>, public ActorCallback< ReadOpActor<Trans>, 0, Void >, public ActorCallback< ReadOpActor<Trans>, 1, Void >, public FastAllocated<ReadOpActor<Trans>>, public ReadOpActorState<Trans, ReadOpActor<Trans>> {
															#line 2767 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
public:
	using FastAllocated<ReadOpActor<Trans>>::operator new;
	using FastAllocated<ReadOpActor<Trans>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8936146787559475200UL, 14521549706908408064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadOpActor<Trans>, 0, Void >;
friend struct ActorCallback< ReadOpActor<Trans>, 1, Void >;
															#line 489 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	ReadOpActor(Trans* const& tr,std::vector<int64_t> const& keys,ReadWriteWorkload* const& self,bool const& shouldRecord) 
															#line 2785 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ReadOpActorState<Trans, ReadOpActor<Trans>>(tr, keys, self, shouldRecord),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readOp", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15853825162189741056UL, 8477943874070745600UL);
		ActorExecutionContextHelper __helper(static_cast<ReadOpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readOp");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readOp", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadOpActor<Trans>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadOpActor<Trans>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 489 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
template <class Trans>
															#line 489 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
[[nodiscard]] static Future<Void> readOp( Trans* const& tr, std::vector<int64_t> const& keys, ReadWriteWorkload* const& self, bool const& shouldRecord ) {
															#line 489 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	return Future<Void>(new ReadOpActor<Trans>(tr, keys, self, shouldRecord));
															#line 2820 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
}

#line 519 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"

																#line 2825 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 520 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
template <class _startActor>
															#line 520 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
class _startActorState {
															#line 2831 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
public:
															#line 520 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	_startActorState(Database const& cx,ReadWriteWorkload* const& self) 
															#line 520 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
															#line 520 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		 : cx(cx),
															#line 520 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   self(self),
															#line 522 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   keys()
															#line 2842 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 523 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			keys.push_back(deterministicRandom()->randomInt64(0, self->nodeCount));
															#line 524 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			startTime = now();
															#line 525 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			;
															#line 2861 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 540 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(std::max(0.1, 1.0 - (now() - startTime)));
															#line 540 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2886 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 540 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 2891 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 526 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		tr = Transaction(cx);
															#line 2907 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		try {
															#line 528 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->setupTransaction(tr);
															#line 529 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->readOp(&tr, keys, self, false);
															#line 529 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2915 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 529 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 2920 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 533 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			if (e.code() == error_code_tag_throttled)
															#line 2955 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			{
															#line 534 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				++self->transactionsTagThrottled;
															#line 2959 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			}
															#line 536 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 536 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2965 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 536 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 2970 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 530 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.warmRange(allKeys);
															#line 530 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2987 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 530 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 2992 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 530 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.warmRange(allKeys);
															#line 530 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3003 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 530 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 3008 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 542 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		std::vector<Future<Void>> clients;
															#line 543 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (self->enableReadLatencyLogging)
															#line 3268 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 544 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			clients.push_back(self->tracePeriodically());
															#line 3272 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 546 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->clientBegin = now();
															#line 547 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		for(int c = 0;c < self->actorCount;c++) {
															#line 548 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			Future<Void> worker;
															#line 549 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			if (self->useRYW)
															#line 3282 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			{
															#line 550 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				worker = self->randomReadWriteClient<ReadYourWritesTransaction>( cx, self, self->actorCount / self->transactionsPerSecond, c);
															#line 3286 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			}
			else
			{
															#line 553 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				worker = self->randomReadWriteClient<Transaction>( cx, self, self->actorCount / self->transactionsPerSecond, c);
															#line 3292 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			}
															#line 555 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			clients.push_back(worker);
															#line 3296 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 558 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (!self->cancelWorkersAtDuration)
															#line 3300 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 559 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->clients = clients;
															#line 3304 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 561 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->cancelWorkersAtDuration ? timeout(waitForAll(clients), self->testDuration, Void()) : delay(self->testDuration);
															#line 561 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3310 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 561 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 3315 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 542 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		std::vector<Future<Void>> clients;
															#line 543 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (self->enableReadLatencyLogging)
															#line 3326 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 544 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			clients.push_back(self->tracePeriodically());
															#line 3330 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 546 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->clientBegin = now();
															#line 547 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		for(int c = 0;c < self->actorCount;c++) {
															#line 548 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			Future<Void> worker;
															#line 549 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			if (self->useRYW)
															#line 3340 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			{
															#line 550 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				worker = self->randomReadWriteClient<ReadYourWritesTransaction>( cx, self, self->actorCount / self->transactionsPerSecond, c);
															#line 3344 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			}
			else
			{
															#line 553 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				worker = self->randomReadWriteClient<Transaction>( cx, self, self->actorCount / self->transactionsPerSecond, c);
															#line 3350 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			}
															#line 555 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			clients.push_back(worker);
															#line 3354 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 558 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (!self->cancelWorkersAtDuration)
															#line 3358 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 559 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->clients = clients;
															#line 3362 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 561 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->cancelWorkersAtDuration ? timeout(waitForAll(clients), self->testDuration, Void()) : delay(self->testDuration);
															#line 561 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3368 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 561 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 3373 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 563 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 3457 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 563 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 3469 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 520 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	Database cx;
															#line 520 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	ReadWriteWorkload* self;
															#line 522 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	std::vector<int64_t> keys;
															#line 524 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	double startTime;
															#line 526 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	Transaction tr;
															#line 3562 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 520 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 3567 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17756485341720060160UL, 10685618535025354752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
															#line 520 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	_startActor(Database const& cx,ReadWriteWorkload* const& self) 
															#line 3588 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 520 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, ReadWriteWorkload* const& self ) {
															#line 520 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 3624 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
}

#line 565 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"

	int64_t getRandomKey(uint64_t nodeCount) {
		if (forceHotProbability && deterministicRandom()->random01() < forceHotProbability)
			return deterministicRandom()->randomInt64(0, nodeCount * hotKeyFraction) /
			       hotKeyFraction; // spread hot keys over keyspace
		else
			return deterministicRandom()->randomInt64(0, nodeCount);
	}

	double sweepAlpha(double startTime) {
		double sweepDuration = testDuration / rampSweepCount;
		double numSweeps = (now() - startTime) / sweepDuration;
		int currentSweep = (int)numSweeps;
		double alpha = numSweeps - currentSweep;
		if (currentSweep % 2)
			alpha = 1 - alpha;
		return alpha;
	}

																#line 3647 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
// This generated class is to be used only via randomReadWriteClient()
															#line 584 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
template <class Trans, class RandomReadWriteClientActor>
															#line 584 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
class RandomReadWriteClientActorState {
															#line 3653 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
public:
															#line 584 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	RandomReadWriteClientActorState(Database const& cx,ReadWriteWorkload* const& self,double const& delay,int const& clientIndex) 
															#line 584 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
															#line 584 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		 : cx(cx),
															#line 584 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   self(self),
															#line 584 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   delay(delay),
															#line 584 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   clientIndex(clientIndex),
															#line 586 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   startTime(now()),
															#line 587 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   lastTime(now()),
															#line 588 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   GRVStartTime(),
															#line 589 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   debugID()
															#line 3674 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("randomReadWriteClient", reinterpret_cast<unsigned long>(this));

	}
	~RandomReadWriteClientActorState() 
	{
		fdb_probe_actor_destroy("randomReadWriteClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 591 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			if (self->rampUpConcurrency)
															#line 3689 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			{
															#line 592 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				StrictFuture<Void> __when_expr_0 = ::delay(self->testDuration / 2 * (double(clientIndex) / self->actorCount + double(self->clientId) / self->clientCount / self->actorCount));
															#line 592 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				if (static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3695 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state = 1;
															#line 592 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RandomReadWriteClientActor, 0, Void >*>(static_cast<RandomReadWriteClientActor*>(this)));
															#line 3700 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RandomReadWriteClientActorState();
		static_cast<RandomReadWriteClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 601 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		;
															#line 3728 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 595 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		TraceEvent("ClientStarting") .detail("ActorIndex", clientIndex) .detail("ClientIndex", self->clientId) .detail("NumActors", clientIndex * self->clientCount + self->clientId + 1);
															#line 3737 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 595 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		TraceEvent("ClientStarting") .detail("ActorIndex", clientIndex) .detail("ClientIndex", self->clientId) .detail("NumActors", clientIndex * self->clientCount + self->clientId + 1);
															#line 3746 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state > 0) static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomReadWriteClientActor*>(this)->ActorCallback< RandomReadWriteClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomReadWriteClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RandomReadWriteClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RandomReadWriteClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 602 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		StrictFuture<Void> __when_expr_1 = poisson(&lastTime, delay);
															#line 602 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3839 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state = 2;
															#line 602 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RandomReadWriteClientActor, 1, Void >*>(static_cast<RandomReadWriteClientActor*>(this)));
															#line 3844 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 604 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (self->rampUpConcurrency)
															#line 3853 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 605 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			if (now() - startTime >= self->testDuration / 2 * (2 - (double(clientIndex) / self->actorCount + double(self->clientId) / self->clientCount / self->actorCount)))
															#line 3857 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			{
															#line 608 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				TraceEvent("ClientStopping") .detail("ActorIndex", clientIndex) .detail("ClientIndex", self->clientId) .detail("NumActors", clientIndex * self->clientCount + self->clientId);
															#line 612 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				StrictFuture<Void> __when_expr_2 = Never();
															#line 612 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				if (static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3865 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
				static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state = 3;
															#line 612 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RandomReadWriteClientActor, 2, Void >*>(static_cast<RandomReadWriteClientActor*>(this)));
															#line 3870 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 604 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (self->rampUpConcurrency)
															#line 3889 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 605 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			if (now() - startTime >= self->testDuration / 2 * (2 - (double(clientIndex) / self->actorCount + double(self->clientId) / self->clientCount / self->actorCount)))
															#line 3893 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			{
															#line 608 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				TraceEvent("ClientStopping") .detail("ActorIndex", clientIndex) .detail("ClientIndex", self->clientId) .detail("NumActors", clientIndex * self->clientCount + self->clientId);
															#line 612 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				StrictFuture<Void> __when_expr_2 = Never();
															#line 612 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				if (static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3901 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
				static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state = 3;
															#line 612 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RandomReadWriteClientActor, 2, Void >*>(static_cast<RandomReadWriteClientActor*>(this)));
															#line 3906 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state > 0) static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomReadWriteClientActor*>(this)->ActorCallback< RandomReadWriteClientActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomReadWriteClientActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RandomReadWriteClientActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RandomReadWriteClientActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 616 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (!self->rampUpLoad || deterministicRandom()->random01() < self->sweepAlpha(startTime))
															#line 4000 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 617 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			tstart = now();
															#line 618 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			aTransaction = deterministicRandom()->random01() > (self->rampTransactionType ? self->sweepAlpha(startTime) : self->alpha);
															#line 621 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			keys = std::vector<int64_t>();
															#line 622 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			values = std::vector<Value>();
															#line 623 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			extra_ranges = std::vector<KeyRange>();
															#line 624 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			int reads = aTransaction ? self->readsPerTransactionA : self->readsPerTransactionB;
															#line 625 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			writes = aTransaction ? self->writesPerTransactionA : self->writesPerTransactionB;
															#line 626 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			extra_read_conflict_ranges = writes ? self->extraReadConflictRangesPerTransaction : 0;
															#line 627 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			extra_write_conflict_ranges = writes ? self->extraWriteConflictRangesPerTransaction : 0;
															#line 628 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			if (!self->adjacentReads)
															#line 4022 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			{
															#line 629 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				for(int op = 0;op < reads;op++) {
															#line 630 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
					keys.push_back(self->getRandomKey(self->nodeCount));
															#line 4028 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 632 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				int startKey = self->getRandomKey(self->nodeCount - reads);
															#line 633 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				for(int op = 0;op < reads;op++) {
															#line 634 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
					keys.push_back(startKey + op);
															#line 4039 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
				}
			}
															#line 637 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			values.reserve(writes);
															#line 638 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			for(int op = 0;op < writes;op++) {
															#line 639 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				values.push_back(self->randomValue());
															#line 4048 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			}
															#line 641 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			extra_ranges.reserve(extra_read_conflict_ranges + extra_write_conflict_ranges);
															#line 642 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			for(int op = 0;op < extra_read_conflict_ranges + extra_write_conflict_ranges;op++) {
															#line 643 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				extra_ranges.push_back(singleKeyRange(deterministicRandom()->randomUniqueID().toString()));
															#line 4056 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			}
															#line 645 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			tr = Trans(cx);
															#line 647 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			if (tstart - self->clientBegin > self->debugTime && tstart - self->clientBegin <= self->debugTime + self->debugInterval)
															#line 4062 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			{
															#line 649 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				debugID = deterministicRandom()->randomUniqueID();
															#line 650 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				tr.debugTransaction(debugID);
															#line 651 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				g_traceBatch.addEvent( "TransactionDebug", debugID.first(), "ReadWrite.randomReadWriteClient.Before");
															#line 4070 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			}
			else
			{
															#line 654 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				debugID = UID();
															#line 4076 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			}
															#line 657 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->transactionSuccessMetric->retries = 0;
															#line 658 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->transactionSuccessMetric->commitLatency = -1;
															#line 660 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			;
															#line 4084 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopBody1cont2loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state > 0) static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomReadWriteClientActor*>(this)->ActorCallback< RandomReadWriteClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomReadWriteClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RandomReadWriteClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RandomReadWriteClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont5(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(int loopDepth) 
	{
															#line 728 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (debugID != UID())
															#line 4197 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 729 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", debugID.first(), "ReadWrite.randomReadWriteClient.After");
															#line 4201 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 731 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		tr = Trans();
															#line 733 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		double transactionLatency = now() - tstart;
															#line 734 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->transactionSuccessMetric->totalLatency = transactionLatency * 1e9;
															#line 735 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->transactionSuccessMetric->log();
															#line 737 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (self->shouldRecord())
															#line 4213 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 738 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			if (aTransaction)
															#line 4217 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			{
															#line 739 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				++self->aTransactions;
															#line 4221 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			}
			else
			{
															#line 741 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				++self->bTransactions;
															#line 4227 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			}
															#line 743 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->latencies.addSample(transactionLatency);
															#line 4231 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 662 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->setupTransaction(tr);
															#line 664 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			GRVStartTime = now();
															#line 665 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->transactionFailureMetric->startLatency = -1;
															#line 667 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			StrictFuture<Version> __when_expr_3 = self->inconsistentReads ? getInconsistentReadVersion(cx) : tr.getReadVersion();
															#line 667 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			if (static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4257 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1cont2loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont2loopBody1when1(__when_expr_3.get(), loopDepth); };
			static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state = 4;
															#line 667 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RandomReadWriteClientActor, 3, Version >*>(static_cast<RandomReadWriteClientActor*>(this)));
															#line 4262 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 711 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			if (e.code() == error_code_tag_throttled)
															#line 4297 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			{
															#line 712 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				++self->transactionsTagThrottled;
															#line 4301 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			}
															#line 715 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->transactionFailureMetric->errorCode = e.code();
															#line 716 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->transactionFailureMetric->log();
															#line 718 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			StrictFuture<Void> __when_expr_6 = tr.onError(e);
															#line 718 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			if (static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4311 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1cont2loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
			static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state = 7;
															#line 718 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RandomReadWriteClientActor, 6, Void >*>(static_cast<RandomReadWriteClientActor*>(this)));
															#line 4316 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont2(Version const& v,int loopDepth) 
	{
															#line 669 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (self->inconsistentReads)
															#line 4331 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 670 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			tr.setVersion(v);
															#line 4335 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 672 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		double grvLatency = now() - GRVStartTime;
															#line 673 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->transactionSuccessMetric->startLatency = grvLatency * 1e9;
															#line 674 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->transactionFailureMetric->startLatency = grvLatency * 1e9;
															#line 675 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (self->shouldRecord())
															#line 4345 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 676 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->GRVLatencies.addSample(grvLatency);
															#line 4349 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 678 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		readStart = now();
															#line 679 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->readOp(&tr, keys, self, self->shouldRecord());
															#line 679 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4357 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1cont2loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont2loopBody1cont2when1(__when_expr_4.get(), loopDepth); };
		static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state = 5;
															#line 679 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RandomReadWriteClientActor, 4, Void >*>(static_cast<RandomReadWriteClientActor*>(this)));
															#line 4362 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont2(Version && v,int loopDepth) 
	{
															#line 669 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (self->inconsistentReads)
															#line 4371 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 670 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			tr.setVersion(v);
															#line 4375 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 672 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		double grvLatency = now() - GRVStartTime;
															#line 673 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->transactionSuccessMetric->startLatency = grvLatency * 1e9;
															#line 674 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->transactionFailureMetric->startLatency = grvLatency * 1e9;
															#line 675 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (self->shouldRecord())
															#line 4385 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 676 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->GRVLatencies.addSample(grvLatency);
															#line 4389 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 678 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		readStart = now();
															#line 679 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->readOp(&tr, keys, self, self->shouldRecord());
															#line 679 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4397 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1cont2loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont2loopBody1cont2when1(__when_expr_4.get(), loopDepth); };
		static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state = 5;
															#line 679 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RandomReadWriteClientActor, 4, Void >*>(static_cast<RandomReadWriteClientActor*>(this)));
															#line 4402 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1when1(Version const& v,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1when1(Version && v,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state > 0) static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomReadWriteClientActor*>(this)->ActorCallback< RandomReadWriteClientActor, 3, Version >::remove();

	}
	void a_callback_fire(ActorCallback< RandomReadWriteClientActor, 3, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RandomReadWriteClientActor, 3, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RandomReadWriteClientActor, 3, Version >*,Error err) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 681 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		double readLatency = now() - readStart;
															#line 682 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (self->shouldRecord())
															#line 4488 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 683 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->fullReadLatencies.addSample(readLatency);
															#line 4492 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 685 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (!writes)
															#line 4496 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
			return a_body1cont1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 688 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (self->adjacentWrites)
															#line 4502 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 689 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			int64_t startKey = self->getRandomKey(self->nodeCount - writes);
															#line 690 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			for(int op = 0;op < writes;op++) {
															#line 691 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				tr.set(self->keyForIndex(startKey + op, false), values[op]);
															#line 4510 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 693 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			for(int op = 0;op < writes;op++) {
															#line 694 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				tr.set(self->keyForIndex(self->getRandomKey(self->nodeCount), false), values[op]);
															#line 4519 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			}
		}
															#line 696 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		for(int op = 0;op < extra_read_conflict_ranges;op++) {
															#line 697 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			tr.addReadConflictRange(extra_ranges[op]);
															#line 4526 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 698 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		for(int op = 0;op < extra_write_conflict_ranges;op++) {
															#line 699 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			tr.addWriteConflictRange(extra_ranges[op + extra_read_conflict_ranges]);
															#line 4532 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 701 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		commitStart = now();
															#line 702 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		StrictFuture<Void> __when_expr_5 = tr.commit();
															#line 702 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4540 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1cont2loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont2loopBody1cont3when1(__when_expr_5.get(), loopDepth); };
		static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state = 6;
															#line 702 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RandomReadWriteClientActor, 5, Void >*>(static_cast<RandomReadWriteClientActor*>(this)));
															#line 4545 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 681 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		double readLatency = now() - readStart;
															#line 682 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (self->shouldRecord())
															#line 4556 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 683 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->fullReadLatencies.addSample(readLatency);
															#line 4560 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 685 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (!writes)
															#line 4564 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
			return a_body1cont1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 688 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (self->adjacentWrites)
															#line 4570 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 689 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			int64_t startKey = self->getRandomKey(self->nodeCount - writes);
															#line 690 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			for(int op = 0;op < writes;op++) {
															#line 691 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				tr.set(self->keyForIndex(startKey + op, false), values[op]);
															#line 4578 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 693 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			for(int op = 0;op < writes;op++) {
															#line 694 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
				tr.set(self->keyForIndex(self->getRandomKey(self->nodeCount), false), values[op]);
															#line 4587 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			}
		}
															#line 696 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		for(int op = 0;op < extra_read_conflict_ranges;op++) {
															#line 697 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			tr.addReadConflictRange(extra_ranges[op]);
															#line 4594 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 698 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		for(int op = 0;op < extra_write_conflict_ranges;op++) {
															#line 699 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			tr.addWriteConflictRange(extra_ranges[op + extra_read_conflict_ranges]);
															#line 4600 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 701 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		commitStart = now();
															#line 702 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		StrictFuture<Void> __when_expr_5 = tr.commit();
															#line 702 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4608 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1cont2loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont2loopBody1cont3when1(__when_expr_5.get(), loopDepth); };
		static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state = 6;
															#line 702 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RandomReadWriteClientActor, 5, Void >*>(static_cast<RandomReadWriteClientActor*>(this)));
															#line 4613 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state > 0) static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomReadWriteClientActor*>(this)->ActorCallback< RandomReadWriteClientActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomReadWriteClientActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont2loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RandomReadWriteClientActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont2loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RandomReadWriteClientActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont2loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 704 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		double commitLatency = now() - commitStart;
															#line 705 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->transactionSuccessMetric->commitLatency = commitLatency * 1e9;
															#line 706 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (self->shouldRecord())
															#line 4701 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 707 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->commitLatencies.addSample(commitLatency);
															#line 4705 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
		return a_body1cont1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 704 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		double commitLatency = now() - commitStart;
															#line 705 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		self->transactionSuccessMetric->commitLatency = commitLatency * 1e9;
															#line 706 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (self->shouldRecord())
															#line 4719 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 707 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			self->commitLatencies.addSample(commitLatency);
															#line 4723 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
		return a_body1cont1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state > 0) static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomReadWriteClientActor*>(this)->ActorCallback< RandomReadWriteClientActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomReadWriteClientActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont2loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RandomReadWriteClientActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont2loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RandomReadWriteClientActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 720 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		++self->transactionSuccessMetric->retries;
															#line 721 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		++self->totalRetriesMetric;
															#line 723 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (self->shouldRecord())
															#line 4812 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 724 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			++self->retries;
															#line 4816 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 720 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		++self->transactionSuccessMetric->retries;
															#line 721 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		++self->totalRetriesMetric;
															#line 723 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (self->shouldRecord())
															#line 4830 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
															#line 724 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			++self->retries;
															#line 4834 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state > 0) static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomReadWriteClientActor*>(this)->ActorCallback< RandomReadWriteClientActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomReadWriteClientActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RandomReadWriteClientActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RandomReadWriteClientActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 584 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	Database cx;
															#line 584 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	ReadWriteWorkload* self;
															#line 584 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	double delay;
															#line 584 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	int clientIndex;
															#line 586 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	double startTime;
															#line 587 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	double lastTime;
															#line 588 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	double GRVStartTime;
															#line 589 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	UID debugID;
															#line 617 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	double tstart;
															#line 618 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	bool aTransaction;
															#line 621 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	std::vector<int64_t> keys;
															#line 622 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	std::vector<Value> values;
															#line 623 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	std::vector<KeyRange> extra_ranges;
															#line 625 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	int writes;
															#line 626 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	int extra_read_conflict_ranges;
															#line 627 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	int extra_write_conflict_ranges;
															#line 645 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	Trans tr;
															#line 678 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	double readStart;
															#line 701 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	double commitStart;
															#line 4953 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
};
// This generated class is to be used only via randomReadWriteClient()
															#line 584 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
template <class Trans>
															#line 584 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
class RandomReadWriteClientActor final : public Actor<Void>, public ActorCallback< RandomReadWriteClientActor<Trans>, 0, Void >, public ActorCallback< RandomReadWriteClientActor<Trans>, 1, Void >, public ActorCallback< RandomReadWriteClientActor<Trans>, 2, Void >, public ActorCallback< RandomReadWriteClientActor<Trans>, 3, Version >, public ActorCallback< RandomReadWriteClientActor<Trans>, 4, Void >, public ActorCallback< RandomReadWriteClientActor<Trans>, 5, Void >, public ActorCallback< RandomReadWriteClientActor<Trans>, 6, Void >, public FastAllocated<RandomReadWriteClientActor<Trans>>, public RandomReadWriteClientActorState<Trans, RandomReadWriteClientActor<Trans>> {
															#line 4960 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
public:
	using FastAllocated<RandomReadWriteClientActor<Trans>>::operator new;
	using FastAllocated<RandomReadWriteClientActor<Trans>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10639668032842936832UL, 5431152612936331776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RandomReadWriteClientActor<Trans>, 0, Void >;
friend struct ActorCallback< RandomReadWriteClientActor<Trans>, 1, Void >;
friend struct ActorCallback< RandomReadWriteClientActor<Trans>, 2, Void >;
friend struct ActorCallback< RandomReadWriteClientActor<Trans>, 3, Version >;
friend struct ActorCallback< RandomReadWriteClientActor<Trans>, 4, Void >;
friend struct ActorCallback< RandomReadWriteClientActor<Trans>, 5, Void >;
friend struct ActorCallback< RandomReadWriteClientActor<Trans>, 6, Void >;
															#line 584 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	RandomReadWriteClientActor(Database const& cx,ReadWriteWorkload* const& self,double const& delay,int const& clientIndex) 
															#line 4983 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RandomReadWriteClientActorState<Trans, RandomReadWriteClientActor<Trans>>(cx, self, delay, clientIndex),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12898104532379093504UL, 5927556942979663104UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("randomReadWriteClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RandomReadWriteClientActor<Trans>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RandomReadWriteClientActor<Trans>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RandomReadWriteClientActor<Trans>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RandomReadWriteClientActor<Trans>, 3, Version >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RandomReadWriteClientActor<Trans>, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RandomReadWriteClientActor<Trans>, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< RandomReadWriteClientActor<Trans>, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 584 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
template <class Trans>
															#line 584 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
[[nodiscard]] Future<Void> randomReadWriteClient( Database const& cx, ReadWriteWorkload* const& self, double const& delay, int const& clientIndex ) {
															#line 584 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	return Future<Void>(new RandomReadWriteClientActor<Trans>(cx, self, delay, clientIndex));
															#line 5023 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
}

#line 748 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
};

															#line 5029 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via trackInsertionCount()
															#line 750 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
template <class TrackInsertionCountActor>
															#line 750 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
class TrackInsertionCountActorState {
															#line 5036 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
public:
															#line 750 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	TrackInsertionCountActorState(Database const& cx,std::vector<uint64_t> const& countsOfInterest,double const& checkInterval) 
															#line 750 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
															#line 750 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		 : cx(cx),
															#line 750 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   countsOfInterest(countsOfInterest),
															#line 750 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   checkInterval(checkInterval),
															#line 753 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   keyPrefix(KeyRangeRef(std::string("keycount"), std::string("keycount") + char(255))),
															#line 754 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   bytesPrefix(KeyRangeRef(std::string("bytesstored"), std::string("bytesstored") + char(255))),
															#line 755 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   tr(cx),
															#line 756 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   lastInsertionCount(0),
															#line 757 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   currentCountIndex(0),
															#line 759 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   countInsertionRates(),
															#line 761 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		   startTime(now())
															#line 5061 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("trackInsertionCount", reinterpret_cast<unsigned long>(this));

	}
	~TrackInsertionCountActorState() 
	{
		fdb_probe_actor_destroy("trackInsertionCount", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 763 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			;
															#line 5076 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TrackInsertionCountActorState();
		static_cast<TrackInsertionCountActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 793 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (!static_cast<TrackInsertionCountActor*>(this)->SAV<std::vector<std::pair<uint64_t, double>>>::futures) { (void)(countInsertionRates); this->~TrackInsertionCountActorState(); static_cast<TrackInsertionCountActor*>(this)->destroy(); return 0; }
															#line 5099 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		new (&static_cast<TrackInsertionCountActor*>(this)->SAV< std::vector<std::pair<uint64_t, double>> >::value()) std::vector<std::pair<uint64_t, double>>(std::move(countInsertionRates)); // state_var_RVO
		this->~TrackInsertionCountActorState();
		static_cast<TrackInsertionCountActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 763 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (!(currentCountIndex < countsOfInterest.size()))
															#line 5118 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 765 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			countFuture = tr.getRange(keyPrefix, 1000000000);
															#line 766 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			bytesFuture = tr.getRange(bytesPrefix, 1000000000);
															#line 767 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(countFuture) && success(bytesFuture);
															#line 767 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			if (static_cast<TrackInsertionCountActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5131 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TrackInsertionCountActor*>(this)->actor_wait_state = 1;
															#line 767 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TrackInsertionCountActor, 0, Void >*>(static_cast<TrackInsertionCountActor*>(this)));
															#line 5136 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 789 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 789 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			if (static_cast<TrackInsertionCountActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5173 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<TrackInsertionCountActor*>(this)->actor_wait_state = 3;
															#line 789 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TrackInsertionCountActor, 2, Void >*>(static_cast<TrackInsertionCountActor*>(this)));
															#line 5178 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 769 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		RangeResult counts = countFuture.get();
															#line 770 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		RangeResult bytes = bytesFuture.get();
															#line 772 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		uint64_t numInserted = 0;
															#line 773 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		for(int i = 0;i < counts.size();i++) {
															#line 774 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			numInserted += *(uint64_t*)counts[i].value.begin();
															#line 5201 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 776 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		uint64_t bytesInserted = 0;
															#line 777 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		for(int i = 0;i < bytes.size();i++) {
															#line 778 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			bytesInserted += *(uint64_t*)bytes[i].value.begin();
															#line 5209 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 780 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		for(;currentCountIndex < countsOfInterest.size() && countsOfInterest[currentCountIndex] > lastInsertionCount && countsOfInterest[currentCountIndex] <= numInserted;) {
															#line 783 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			countInsertionRates.emplace_back(countsOfInterest[currentCountIndex++], bytesInserted / (now() - startTime));
															#line 5215 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 786 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		lastInsertionCount = numInserted;
															#line 787 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(checkInterval);
															#line 787 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (static_cast<TrackInsertionCountActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5223 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<TrackInsertionCountActor*>(this)->actor_wait_state = 2;
															#line 787 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TrackInsertionCountActor, 1, Void >*>(static_cast<TrackInsertionCountActor*>(this)));
															#line 5228 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 769 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		RangeResult counts = countFuture.get();
															#line 770 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		RangeResult bytes = bytesFuture.get();
															#line 772 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		uint64_t numInserted = 0;
															#line 773 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		for(int i = 0;i < counts.size();i++) {
															#line 774 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			numInserted += *(uint64_t*)counts[i].value.begin();
															#line 5245 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 776 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		uint64_t bytesInserted = 0;
															#line 777 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		for(int i = 0;i < bytes.size();i++) {
															#line 778 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			bytesInserted += *(uint64_t*)bytes[i].value.begin();
															#line 5253 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 780 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		for(;currentCountIndex < countsOfInterest.size() && countsOfInterest[currentCountIndex] > lastInsertionCount && countsOfInterest[currentCountIndex] <= numInserted;) {
															#line 783 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
			countInsertionRates.emplace_back(countsOfInterest[currentCountIndex++], bytesInserted / (now() - startTime));
															#line 5259 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		}
															#line 786 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		lastInsertionCount = numInserted;
															#line 787 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(checkInterval);
															#line 787 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		if (static_cast<TrackInsertionCountActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5267 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<TrackInsertionCountActor*>(this)->actor_wait_state = 2;
															#line 787 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TrackInsertionCountActor, 1, Void >*>(static_cast<TrackInsertionCountActor*>(this)));
															#line 5272 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TrackInsertionCountActor*>(this)->actor_wait_state > 0) static_cast<TrackInsertionCountActor*>(this)->actor_wait_state = 0;
		static_cast<TrackInsertionCountActor*>(this)->ActorCallback< TrackInsertionCountActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackInsertionCountActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackInsertionCount", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInsertionCountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInsertionCount", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TrackInsertionCountActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackInsertionCount", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInsertionCountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInsertionCount", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TrackInsertionCountActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackInsertionCount", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInsertionCountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInsertionCount", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TrackInsertionCountActor*>(this)->actor_wait_state > 0) static_cast<TrackInsertionCountActor*>(this)->actor_wait_state = 0;
		static_cast<TrackInsertionCountActor*>(this)->ActorCallback< TrackInsertionCountActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackInsertionCountActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackInsertionCount", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInsertionCountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInsertionCount", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TrackInsertionCountActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackInsertionCount", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInsertionCountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInsertionCount", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TrackInsertionCountActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackInsertionCount", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInsertionCountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInsertionCount", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TrackInsertionCountActor*>(this)->actor_wait_state > 0) static_cast<TrackInsertionCountActor*>(this)->actor_wait_state = 0;
		static_cast<TrackInsertionCountActor*>(this)->ActorCallback< TrackInsertionCountActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackInsertionCountActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackInsertionCount", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInsertionCountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInsertionCount", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TrackInsertionCountActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackInsertionCount", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInsertionCountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInsertionCount", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TrackInsertionCountActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackInsertionCount", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInsertionCountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInsertionCount", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 750 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	Database cx;
															#line 750 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	std::vector<uint64_t> countsOfInterest;
															#line 750 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	double checkInterval;
															#line 753 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	KeyRange keyPrefix;
															#line 754 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	KeyRange bytesPrefix;
															#line 755 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	Transaction tr;
															#line 756 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	uint64_t lastInsertionCount;
															#line 757 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	int currentCountIndex;
															#line 759 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	std::vector<std::pair<uint64_t, double>> countInsertionRates;
															#line 761 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	double startTime;
															#line 765 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	Future<RangeResult> countFuture;
															#line 766 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	Future<RangeResult> bytesFuture;
															#line 5563 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
};
// This generated class is to be used only via trackInsertionCount()
															#line 750 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
class TrackInsertionCountActor final : public Actor<std::vector<std::pair<uint64_t, double>>>, public ActorCallback< TrackInsertionCountActor, 0, Void >, public ActorCallback< TrackInsertionCountActor, 1, Void >, public ActorCallback< TrackInsertionCountActor, 2, Void >, public FastAllocated<TrackInsertionCountActor>, public TrackInsertionCountActorState<TrackInsertionCountActor> {
															#line 5568 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
public:
	using FastAllocated<TrackInsertionCountActor>::operator new;
	using FastAllocated<TrackInsertionCountActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7624482334503214592UL, 9443676967430901504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<uint64_t, double>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TrackInsertionCountActor, 0, Void >;
friend struct ActorCallback< TrackInsertionCountActor, 1, Void >;
friend struct ActorCallback< TrackInsertionCountActor, 2, Void >;
															#line 750 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	TrackInsertionCountActor(Database const& cx,std::vector<uint64_t> const& countsOfInterest,double const& checkInterval) 
															#line 5587 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
		 : Actor<std::vector<std::pair<uint64_t, double>>>(),
		   TrackInsertionCountActorState<TrackInsertionCountActor>(cx, countsOfInterest, checkInterval),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("trackInsertionCount", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9893615855509859072UL, 10619741812671108608UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInsertionCountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("trackInsertionCount");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("trackInsertionCount", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TrackInsertionCountActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TrackInsertionCountActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TrackInsertionCountActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 750 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
[[nodiscard]] Future<std::vector<std::pair<uint64_t, double>>> trackInsertionCount( Database const& cx, std::vector<uint64_t> const& countsOfInterest, double const& checkInterval ) {
															#line 750 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"
	return Future<std::vector<std::pair<uint64_t, double>>>(new TrackInsertionCountActor(cx, countsOfInterest, checkInterval));
															#line 5622 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadWrite.actor.g.cpp.py_gen"
}

#line 795 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/workloads/ReadWrite.actor.cpp"

WorkloadFactory<ReadWriteWorkload> ReadWriteWorkloadFactory;
