#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
/*
 * BackupProgress.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/BackupProgress.actor.h"

#include "fdbclient/FDBTypes.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "flow/UnitTest.h"
#include "flow/actorcompiler.h" // This must be the last #include.

void BackupProgress::addBackupStatus(const WorkerBackupStatus& status) {
	auto& it = progress[status.epoch];
	auto lb = it.lower_bound(status.tag);
	if (lb != it.end() && status.tag == lb->first) {
		if (lb->second < status.version) {
			lb->second = status.version;
		}
	} else {
		it.insert(lb, { status.tag, status.version });
	}

	auto tagIt = epochTags.find(status.epoch);
	if (tagIt == epochTags.end()) {
		epochTags.insert({ status.epoch, status.totalTags });
	} else {
		ASSERT(status.totalTags == tagIt->second);
	}
}

void BackupProgress::updateTagVersions(std::map<Tag, Version>* tagVersions,
                                       std::set<Tag>* tags,
                                       const std::map<Tag, Version>& progress,
                                       Version endVersion,
                                       Version adjustedBeginVersion,
                                       LogEpoch epoch) {
	for (const auto& [tag, savedVersion] : progress) {
		// If tag is not in "tags", it means the old epoch has more tags than
		// new epoch's tags. Just ignore the tag here.
		auto n = tags->erase(tag);
		if (n > 0 && savedVersion < endVersion - 1) {
			const Version beginVersion =
			    (savedVersion + 1 > adjustedBeginVersion) ? (savedVersion + 1) : adjustedBeginVersion;
			tagVersions->insert({ tag, beginVersion });
			TraceEvent("BackupVersionRange", dbgid)
			    .detail("OldEpoch", epoch)
			    .detail("Tag", tag.toString())
			    .detail("BeginVersion", savedVersion + 1)
			    .detail("AdjustedBeginVersion", beginVersion)
			    .detail("EndVersion", endVersion);
		}
	}
}

std::map<std::tuple<LogEpoch, Version, int>, std::map<Tag, Version>> BackupProgress::getUnfinishedBackup() {
	std::map<std::tuple<LogEpoch, Version, int>, std::map<Tag, Version>> toRecruit;

	if (!backupStartedValue.present())
		return toRecruit; // No active backups

	Version lastEnd = invalidVersion;
	for (const auto& [epoch, info] : epochInfos) {
		std::set<Tag> tags = enumerateLogRouterTags(info.logRouterTags);
		std::map<Tag, Version> tagVersions;

		// Sometimes, an epoch's begin version is lower than the previous epoch's
		// end version. In this case, adjust the epoch's begin version to be the
		// same as previous end version.
		Version adjustedBeginVersion = lastEnd > info.epochBegin ? lastEnd : info.epochBegin;
		lastEnd = info.epochEnd;

		auto progressIt = progress.lower_bound(epoch);
		if (progressIt != progress.end() && progressIt->first == epoch) {
			std::set<Tag> toCheck = tags;
			for (auto current = progressIt; current != progress.begin() && !toCheck.empty();) {
				auto prev = std::prev(current);
				// Previous epoch is gone, consolidate the progress.
				for (auto [tag, version] : prev->second) {
					if (toCheck.contains(tag)) {
						progressIt->second[tag] = std::max(version, progressIt->second[tag]);
						toCheck.erase(tag);
					}
				}
				current = prev;
			}
			updateTagVersions(&tagVersions, &tags, progressIt->second, info.epochEnd, adjustedBeginVersion, epoch);
		} else {
			auto rit = std::find_if(
			    progress.rbegin(),
			    progress.rend(),
			    [epoch = epoch](const std::pair<LogEpoch, std::map<Tag, Version>>& p) { return p.first < epoch; });
			while (!(rit == progress.rend())) {
				// A partial recovery can result in empty epoch that copies previous
				// epoch's version range. In this case, we should check previous
				// epoch's savedVersion.
				int savedMore = 0;
				for (auto [tag, version] : rit->second) {
					if (version >= info.epochBegin) {
						savedMore++;
					}
				}
				if (savedMore > 0) {
					// The logRouterTags are the same
					// ASSERT(info.logRouterTags == epochTags[rit->first]);

					updateTagVersions(&tagVersions, &tags, rit->second, info.epochEnd, adjustedBeginVersion, epoch);
					if (tags.empty())
						break;
				}
				rit++;
			}
		}

		for (const Tag& tag : tags) { // tags without progress data
			tagVersions.insert({ tag, adjustedBeginVersion });
			TraceEvent("BackupVersionRange", dbgid)
			    .detail("OldEpoch", epoch)
			    .detail("Tag", tag.toString())
			    .detail("BeginVersion", info.epochBegin)
			    .detail("AdjustedBeginVersion", adjustedBeginVersion)
			    .detail("EndVersion", info.epochEnd);
		}
		if (!tagVersions.empty()) {
			toRecruit[{ epoch, info.epochEnd, info.logRouterTags }] = tagVersions;
		}
	}
	return toRecruit;
}

// Save each tag's savedVersion for all epochs into "bStatus".
															#line 150 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getBackupProgress()
															#line 148 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
template <class GetBackupProgressActor>
															#line 148 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
class GetBackupProgressActorState {
															#line 157 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
public:
															#line 148 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	GetBackupProgressActorState(Database const& cx,UID const& dbgid,Reference<BackupProgress> const& bStatus,bool const& logging) 
															#line 148 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
															#line 148 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		 : cx(cx),
															#line 148 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		   dbgid(dbgid),
															#line 148 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		   bStatus(bStatus),
															#line 148 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		   logging(logging),
															#line 149 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		   tr(cx)
															#line 172 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getBackupProgress", reinterpret_cast<unsigned long>(this));

	}
	~GetBackupProgressActorState() 
	{
		fdb_probe_actor_destroy("getBackupProgress", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 151 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			;
															#line 187 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetBackupProgressActorState();
		static_cast<GetBackupProgressActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 153 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 154 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 155 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 156 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			fValue = tr.get(backupStartedKey);
															#line 157 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(backupProgressKeys, CLIENT_KNOBS->TOO_MANY);
															#line 157 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			if (static_cast<GetBackupProgressActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 228 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetBackupProgressActor*>(this)->actor_wait_state = 1;
															#line 157 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetBackupProgressActor, 0, RangeResult >*>(static_cast<GetBackupProgressActor*>(this)));
															#line 233 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 177 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 177 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			if (static_cast<GetBackupProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 257 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetBackupProgressActor*>(this)->actor_wait_state = 3;
															#line 177 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetBackupProgressActor, 2, Void >*>(static_cast<GetBackupProgressActor*>(this)));
															#line 262 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 158 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		ASSERT(!results.more && results.size() < CLIENT_KNOBS->TOO_MANY);
															#line 160 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = fValue;
															#line 160 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		if (static_cast<GetBackupProgressActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 281 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetBackupProgressActor*>(this)->actor_wait_state = 2;
															#line 160 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetBackupProgressActor, 1, Optional<Value> >*>(static_cast<GetBackupProgressActor*>(this)));
															#line 286 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __results,int loopDepth) 
	{
															#line 157 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		results = __results;
															#line 295 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __results,int loopDepth) 
	{
		results = std::move(__results);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetBackupProgressActor*>(this)->actor_wait_state > 0) static_cast<GetBackupProgressActor*>(this)->actor_wait_state = 0;
		static_cast<GetBackupProgressActor*>(this)->ActorCallback< GetBackupProgressActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetBackupProgressActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getBackupProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBackupProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetBackupProgressActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getBackupProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBackupProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetBackupProgressActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getBackupProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBackupProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Optional<Value> const& value,int loopDepth) 
	{
															#line 161 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		bStatus->setBackupStartedValue(value);
															#line 162 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		for( auto& it : results ) {
															#line 163 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			const UID workerID = decodeBackupProgressKey(it.key);
															#line 164 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			const WorkerBackupStatus status = decodeBackupProgressValue(it.value);
															#line 165 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			bStatus->addBackupStatus(status);
															#line 166 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			if (logging)
															#line 384 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
			{
															#line 167 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
				TraceEvent("GotBackupProgress", dbgid) .detail("BackupWorker", workerID) .detail("Epoch", status.epoch) .detail("Version", status.version) .detail("Tag", status.tag.toString()) .detail("TotalTags", status.totalTags);
															#line 388 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
			}
		}
															#line 175 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		if (!static_cast<GetBackupProgressActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetBackupProgressActorState(); static_cast<GetBackupProgressActor*>(this)->destroy(); return 0; }
															#line 393 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
		new (&static_cast<GetBackupProgressActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetBackupProgressActorState();
		static_cast<GetBackupProgressActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<Value> && value,int loopDepth) 
	{
															#line 161 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		bStatus->setBackupStartedValue(value);
															#line 162 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		for( auto& it : results ) {
															#line 163 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			const UID workerID = decodeBackupProgressKey(it.key);
															#line 164 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			const WorkerBackupStatus status = decodeBackupProgressValue(it.value);
															#line 165 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			bStatus->addBackupStatus(status);
															#line 166 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			if (logging)
															#line 415 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
			{
															#line 167 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
				TraceEvent("GotBackupProgress", dbgid) .detail("BackupWorker", workerID) .detail("Epoch", status.epoch) .detail("Version", status.version) .detail("Tag", status.tag.toString()) .detail("TotalTags", status.totalTags);
															#line 419 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
			}
		}
															#line 175 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		if (!static_cast<GetBackupProgressActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetBackupProgressActorState(); static_cast<GetBackupProgressActor*>(this)->destroy(); return 0; }
															#line 424 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
		new (&static_cast<GetBackupProgressActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetBackupProgressActorState();
		static_cast<GetBackupProgressActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetBackupProgressActor*>(this)->actor_wait_state > 0) static_cast<GetBackupProgressActor*>(this)->actor_wait_state = 0;
		static_cast<GetBackupProgressActor*>(this)->ActorCallback< GetBackupProgressActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetBackupProgressActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getBackupProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBackupProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetBackupProgressActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getBackupProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBackupProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetBackupProgressActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getBackupProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBackupProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetBackupProgressActor*>(this)->actor_wait_state > 0) static_cast<GetBackupProgressActor*>(this)->actor_wait_state = 0;
		static_cast<GetBackupProgressActor*>(this)->ActorCallback< GetBackupProgressActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetBackupProgressActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getBackupProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBackupProgress", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetBackupProgressActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getBackupProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBackupProgress", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetBackupProgressActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getBackupProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBackupProgress", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 148 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	Database cx;
															#line 148 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	UID dbgid;
															#line 148 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	Reference<BackupProgress> bStatus;
															#line 148 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	bool logging;
															#line 149 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	Transaction tr;
															#line 156 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	Future<Optional<Value>> fValue;
															#line 157 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	RangeResult results;
															#line 608 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getBackupProgress()
															#line 148 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
class GetBackupProgressActor final : public Actor<Void>, public ActorCallback< GetBackupProgressActor, 0, RangeResult >, public ActorCallback< GetBackupProgressActor, 1, Optional<Value> >, public ActorCallback< GetBackupProgressActor, 2, Void >, public FastAllocated<GetBackupProgressActor>, public GetBackupProgressActorState<GetBackupProgressActor> {
															#line 613 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetBackupProgressActor>::operator new;
	using FastAllocated<GetBackupProgressActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14341840040035238912UL, 1328065055588077312UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetBackupProgressActor, 0, RangeResult >;
friend struct ActorCallback< GetBackupProgressActor, 1, Optional<Value> >;
friend struct ActorCallback< GetBackupProgressActor, 2, Void >;
															#line 148 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	GetBackupProgressActor(Database const& cx,UID const& dbgid,Reference<BackupProgress> const& bStatus,bool const& logging) 
															#line 632 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetBackupProgressActorState<GetBackupProgressActor>(cx, dbgid, bStatus, logging),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getBackupProgress", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9203706318277777920UL, 8609133948190877696UL);
		ActorExecutionContextHelper __helper(static_cast<GetBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getBackupProgress");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getBackupProgress", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetBackupProgressActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetBackupProgressActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetBackupProgressActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 148 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
[[nodiscard]] Future<Void> getBackupProgress( Database const& cx, UID const& dbgid, Reference<BackupProgress> const& bStatus, bool const& logging ) {
															#line 148 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	return Future<Void>(new GetBackupProgressActor(cx, dbgid, bStatus, logging));
															#line 667 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
}

#line 181 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"

// This function scans all backup progress entries to find the one matching the given
// (epoch, tag) pair. When found, it deletes the old key and writes a new key with the
// new workerID, effectively transferring ownership from the failed worker to the
// replacement worker.
															#line 676 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via _takeover()
															#line 186 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
template <class _takeoverActor>
															#line 186 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
class _takeoverActorState {
															#line 683 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
public:
															#line 186 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	_takeoverActorState(Database const& cx,UID const& newWorkerID,LogEpoch const& backupEpoch,Tag const& tag) 
															#line 186 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
															#line 186 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		 : cx(cx),
															#line 186 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		   newWorkerID(newWorkerID),
															#line 186 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		   backupEpoch(backupEpoch),
															#line 186 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		   tag(tag),
															#line 187 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		   tr(cx)
															#line 698 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_takeover", reinterpret_cast<unsigned long>(this));

	}
	~_takeoverActorState() 
	{
		fdb_probe_actor_destroy("_takeover", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 189 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			;
															#line 713 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_takeoverActorState();
		static_cast<_takeoverActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 191 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 192 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 193 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 195 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 195 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			if (static_cast<_takeoverActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 752 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_takeoverActor*>(this)->actor_wait_state = 1;
															#line 195 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _takeoverActor, 0, Version >*>(static_cast<_takeoverActor*>(this)));
															#line 757 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 241 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 241 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			if (static_cast<_takeoverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 781 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<_takeoverActor*>(this)->actor_wait_state = 4;
															#line 241 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _takeoverActor, 3, Void >*>(static_cast<_takeoverActor*>(this)));
															#line 786 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 196 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(backupProgressKeys, CLIENT_KNOBS->TOO_MANY);
															#line 196 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		if (static_cast<_takeoverActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 803 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<_takeoverActor*>(this)->actor_wait_state = 2;
															#line 196 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _takeoverActor, 1, RangeResult >*>(static_cast<_takeoverActor*>(this)));
															#line 808 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& __readVersion,int loopDepth) 
	{
															#line 195 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		readVersion = __readVersion;
															#line 817 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && __readVersion,int loopDepth) 
	{
		readVersion = std::move(__readVersion);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_takeoverActor*>(this)->actor_wait_state > 0) static_cast<_takeoverActor*>(this)->actor_wait_state = 0;
		static_cast<_takeoverActor*>(this)->ActorCallback< _takeoverActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< _takeoverActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("_takeover", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_takeoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_takeover", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _takeoverActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("_takeover", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_takeoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_takeover", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _takeoverActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("_takeover", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_takeoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_takeover", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 197 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		ASSERT(!results.more && results.size() < CLIENT_KNOBS->TOO_MANY);
															#line 200 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		maxTagVersion = invalidVersion;
															#line 201 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		RangeForbody1loopBody1cont3Iterator0 = std::begin(results);
															#line 900 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& __results,int loopDepth) 
	{
															#line 196 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		results = __results;
															#line 909 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && __results,int loopDepth) 
	{
		results = std::move(__results);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_takeoverActor*>(this)->actor_wait_state > 0) static_cast<_takeoverActor*>(this)->actor_wait_state = 0;
		static_cast<_takeoverActor*>(this)->ActorCallback< _takeoverActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _takeoverActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_takeover", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_takeoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_takeover", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _takeoverActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_takeover", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_takeoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_takeover", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _takeoverActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_takeover", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_takeoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_takeover", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
															#line 233 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		TraceEvent("BackupProgressNoTakeover", newWorkerID) .detail("Epoch", backupEpoch) .detail("Tag", tag) .detail("ReadVersion", readVersion) .detail("MaxTagVersion", maxTagVersion) .detail("TotalProgressEntries", results.size());
															#line 239 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		if (!static_cast<_takeoverActor*>(this)->SAV<Version>::futures) { (void)(maxTagVersion == invalidVersion ? readVersion : maxTagVersion); this->~_takeoverActorState(); static_cast<_takeoverActor*>(this)->destroy(); return 0; }
															#line 990 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
		new (&static_cast<_takeoverActor*>(this)->SAV< Version >::value()) Version(maxTagVersion == invalidVersion ? readVersion : maxTagVersion);
		this->~_takeoverActorState();
		static_cast<_takeoverActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 201 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		if (!(RangeForbody1loopBody1cont3Iterator0 != std::end(results)))
															#line 1009 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 201 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		auto& it = *RangeForbody1loopBody1cont3Iterator0;
															#line 1015 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
		{
															#line 202 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			status = decodeBackupProgressValue(it.value);
															#line 203 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			if (status.tag != tag)
															#line 1021 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
			{
				return a_body1loopBody1cont3continue1(loopDepth); // continue
			}
															#line 206 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			if (status.epoch == backupEpoch)
															#line 1027 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
			{
															#line 207 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
				UID oldWorkerID = decodeBackupProgressKey(it.key);
															#line 208 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
				savedVersion = status.version;
															#line 211 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
				tr.clear(it.key);
															#line 214 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
				Key newKey = backupProgressKeyFor(newWorkerID);
															#line 215 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
				tr.set(newKey, it.value);
															#line 217 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
				TraceEvent("BackupProgressTakeover", newWorkerID) .detail("Epoch", backupEpoch) .detail("Tag", tag) .detail("SavedVersion", savedVersion) .detail("OldWorkerID", oldWorkerID) .detail("NewWorkerID", newWorkerID);
															#line 224 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
				StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 224 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
				if (static_cast<_takeoverActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1045 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3loopBody1when1(__when_expr_2.get(), loopDepth); };
				static_cast<_takeoverActor*>(this)->actor_wait_state = 3;
															#line 224 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _takeoverActor, 2, Void >*>(static_cast<_takeoverActor*>(this)));
															#line 1050 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 227 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
				maxTagVersion = std::max(maxTagVersion, status.version);
															#line 1057 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
				loopDepth = a_body1loopBody1cont3loopBody1cont3(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3continue1(int loopDepth) 
	{
															#line 201 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		++RangeForbody1loopBody1cont3Iterator0;
															#line 1081 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1(int loopDepth) 
	{
															#line 201 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		++RangeForbody1loopBody1cont3Iterator0;
															#line 1090 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 225 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		if (!static_cast<_takeoverActor*>(this)->SAV<Version>::futures) { (void)(savedVersion); this->~_takeoverActorState(); static_cast<_takeoverActor*>(this)->destroy(); return 0; }
															#line 1105 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
		new (&static_cast<_takeoverActor*>(this)->SAV< Version >::value()) Version(std::move(savedVersion)); // state_var_RVO
		this->~_takeoverActorState();
		static_cast<_takeoverActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 225 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		if (!static_cast<_takeoverActor*>(this)->SAV<Version>::futures) { (void)(savedVersion); this->~_takeoverActorState(); static_cast<_takeoverActor*>(this)->destroy(); return 0; }
															#line 1117 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
		new (&static_cast<_takeoverActor*>(this)->SAV< Version >::value()) Version(std::move(savedVersion)); // state_var_RVO
		this->~_takeoverActorState();
		static_cast<_takeoverActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_takeoverActor*>(this)->actor_wait_state > 0) static_cast<_takeoverActor*>(this)->actor_wait_state = 0;
		static_cast<_takeoverActor*>(this)->ActorCallback< _takeoverActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _takeoverActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_takeover", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_takeoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_takeover", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _takeoverActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_takeover", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_takeoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_takeover", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _takeoverActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_takeover", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_takeoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_takeover", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_takeoverActor*>(this)->actor_wait_state > 0) static_cast<_takeoverActor*>(this)->actor_wait_state = 0;
		static_cast<_takeoverActor*>(this)->ActorCallback< _takeoverActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _takeoverActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_takeover", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_takeoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_takeover", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _takeoverActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_takeover", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_takeoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_takeover", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _takeoverActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_takeover", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_takeoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_takeover", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 186 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	Database cx;
															#line 186 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	UID newWorkerID;
															#line 186 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	LogEpoch backupEpoch;
															#line 186 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	Tag tag;
															#line 187 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	Transaction tr;
															#line 195 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	Version readVersion;
															#line 196 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	RangeResult results;
															#line 200 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	Version maxTagVersion;
															#line 201 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	decltype(std::begin(std::declval<RangeResult>())) RangeForbody1loopBody1cont3Iterator0;
															#line 202 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	WorkerBackupStatus status;
															#line 208 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	Version savedVersion;
															#line 1309 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _takeover()
															#line 186 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
class _takeoverActor final : public Actor<Version>, public ActorCallback< _takeoverActor, 0, Version >, public ActorCallback< _takeoverActor, 1, RangeResult >, public ActorCallback< _takeoverActor, 2, Void >, public ActorCallback< _takeoverActor, 3, Void >, public FastAllocated<_takeoverActor>, public _takeoverActorState<_takeoverActor> {
															#line 1314 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
public:
	using FastAllocated<_takeoverActor>::operator new;
	using FastAllocated<_takeoverActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12846952959546100992UL, 11929995201072325120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _takeoverActor, 0, Version >;
friend struct ActorCallback< _takeoverActor, 1, RangeResult >;
friend struct ActorCallback< _takeoverActor, 2, Void >;
friend struct ActorCallback< _takeoverActor, 3, Void >;
															#line 186 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	_takeoverActor(Database const& cx,UID const& newWorkerID,LogEpoch const& backupEpoch,Tag const& tag) 
															#line 1334 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
		 : Actor<Version>(),
		   _takeoverActorState<_takeoverActor>(cx, newWorkerID, backupEpoch, tag),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_takeover", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11728858846504727040UL, 544174853306144768UL);
		ActorExecutionContextHelper __helper(static_cast<_takeoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_takeover");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_takeover", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _takeoverActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _takeoverActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _takeoverActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _takeoverActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 186 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
[[nodiscard]] Future<Version> _takeover( Database const& cx, UID const& newWorkerID, LogEpoch const& backupEpoch, Tag const& tag ) {
															#line 186 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	return Future<Version>(new _takeoverActor(cx, newWorkerID, backupEpoch, tag));
															#line 1370 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
}

#line 245 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"

Future<Version> BackupProgress::takeover(Database cx, UID newWorkerID, LogEpoch backupEpoch, Tag tag) {
	return _takeover(cx, newWorkerID, backupEpoch, tag);
}

															#line 1379 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase250()
															#line 250 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
template <class FlowTestCase250Actor>
															#line 250 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
class FlowTestCase250ActorState {
															#line 1386 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
public:
															#line 250 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	FlowTestCase250ActorState(UnitTestParameters const& params) 
															#line 250 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
															#line 250 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		 : params(params)
															#line 1393 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase250", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase250ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase250", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 251 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			std::map<LogEpoch, ILogSystem::EpochTagsVersionsInfo> epochInfos;
															#line 253 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			const int epoch1 = 2, begin1 = 1, end1 = 100;
															#line 254 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			const Tag tag1(tagLocalityLogRouter, 0);
															#line 255 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			epochInfos.insert({ epoch1, ILogSystem::EpochTagsVersionsInfo(1, begin1, end1) });
															#line 256 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			BackupProgress progress(UID(0, 0), epochInfos);
															#line 257 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			progress.setBackupStartedValue(Optional<Value>("1"_sr));
															#line 259 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			std::map<std::tuple<LogEpoch, Version, int>, std::map<Tag, Version>> unfinished = progress.getUnfinishedBackup();
															#line 261 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			ASSERT(unfinished.size() == 1);
															#line 262 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			for( const auto& [epochVersionCount, tagVersion] : unfinished ) {
															#line 263 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
				ASSERT(std::get<0>(epochVersionCount) == epoch1 && std::get<1>(epochVersionCount) == end1 && std::get<2>(epochVersionCount) == 1);
															#line 265 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
				ASSERT(tagVersion.size() == 1 && tagVersion.begin()->first == tag1 && tagVersion.begin()->second == begin1);
															#line 1428 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
			}
															#line 268 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			const int saved1 = 50, totalTags = 1;
															#line 269 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			WorkerBackupStatus status1(epoch1, saved1, tag1, totalTags);
															#line 270 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			progress.addBackupStatus(status1);
															#line 271 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			unfinished = progress.getUnfinishedBackup();
															#line 272 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			ASSERT(unfinished.size() == 1);
															#line 273 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			for( const auto& [epochVersionCount, tagVersion] : unfinished ) {
															#line 274 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
				ASSERT(std::get<0>(epochVersionCount) == epoch1 && std::get<1>(epochVersionCount) == end1 && std::get<2>(epochVersionCount) == 1);
															#line 276 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
				ASSERT(tagVersion.size() == 1 && tagVersion.begin()->first == tag1 && tagVersion.begin()->second == saved1 + 1);
															#line 1446 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
			}
															#line 279 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			if (!static_cast<FlowTestCase250Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase250ActorState(); static_cast<FlowTestCase250Actor*>(this)->destroy(); return 0; }
															#line 1450 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase250Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase250ActorState();
			static_cast<FlowTestCase250Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase250ActorState();
		static_cast<FlowTestCase250Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 250 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	UnitTestParameters params;
															#line 1474 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase250()
															#line 250 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
class FlowTestCase250Actor final : public Actor<Void>, public FastAllocated<FlowTestCase250Actor>, public FlowTestCase250ActorState<FlowTestCase250Actor> {
															#line 1479 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase250Actor>::operator new;
	using FastAllocated<FlowTestCase250Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10450548684758726912UL, 1973404776045298176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 250 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	FlowTestCase250Actor(UnitTestParameters const& params) 
															#line 1495 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase250ActorState<FlowTestCase250Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase250", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9920254734471664640UL, 16911881472727424768UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase250Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase250");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase250", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 250 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
static Future<Void> flowTestCase250( UnitTestParameters const& params ) {
															#line 250 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	return Future<Void>(new FlowTestCase250Actor(params));
															#line 1527 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase250, "/BackupProgress/Unfinished")

#line 281 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
