#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
/*
 * ConfigureCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbcli/FlowLineNoise.h"
#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/ManagementAPI.actor.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

															#line 37 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via configureCommandActor()
															#line 35 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
template <class ConfigureCommandActorActor>
															#line 35 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
class ConfigureCommandActorActorState {
															#line 43 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
public:
															#line 35 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
	ConfigureCommandActorActorState(Reference<IDatabase> const& db,Database const& localDb,std::vector<StringRef> const& tokens,LineNoise* const& linenoise,Future<Void> const& warn) 
															#line 35 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
															#line 35 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		 : db(db),
															#line 35 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		   localDb(localDb),
															#line 35 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		   tokens(tokens),
															#line 35 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		   linenoise(linenoise),
															#line 35 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		   warn(warn),
															#line 40 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		   result(),
															#line 41 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		   s(),
															#line 42 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		   startToken(1),
															#line 43 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		   force(false)
															#line 66 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("configureCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~ConfigureCommandActorActorState() 
	{
		fdb_probe_actor_destroy("configureCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 44 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
			if (tokens.size() < 2)
															#line 81 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
			{
															#line 45 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
				result = ConfigurationResult::NO_OPTIONS_PROVIDED;
															#line 85 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
				loopDepth = a_body1cont1(loopDepth);
			}
			else
			{
															#line 47 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
				if (tokens[startToken] == "FORCE"_sr)
															#line 92 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
				{
															#line 48 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
					force = true;
															#line 49 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
					startToken = 2;
															#line 98 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
				}
															#line 52 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
				conf = Optional<ConfigureAutoResult>();
															#line 53 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
				if (tokens[startToken] == "auto"_sr)
															#line 104 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
				{
															#line 55 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
					tr = db->createTransaction();
															#line 56 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
					if (!tr->isValid())
															#line 110 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
					{
															#line 57 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
						StrictFuture<StatusObject> __when_expr_0 = StatusClient::statusFetcher(localDb);
															#line 57 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
						if (static_cast<ConfigureCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 116 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
						if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
						static_cast<ConfigureCommandActorActor*>(this)->actor_wait_state = 1;
															#line 57 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
						__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConfigureCommandActorActor, 0, StatusObject >*>(static_cast<ConfigureCommandActorActor*>(this)));
															#line 121 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					else
					{
															#line 60 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
						statusValueF = tr->get("\xff\xff/status/json"_sr);
															#line 61 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
						StrictFuture<Optional<Value>> __when_expr_1 = safeThreadFutureToFuture(statusValueF);
															#line 61 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
						if (static_cast<ConfigureCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 132 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
						if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
						static_cast<ConfigureCommandActorActor*>(this)->actor_wait_state = 2;
															#line 61 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
						__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConfigureCommandActorActor, 1, Optional<Value> >*>(static_cast<ConfigureCommandActorActor*>(this)));
															#line 137 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
				}
				else
				{
					loopDepth = a_body1cont3(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConfigureCommandActorActorState();
		static_cast<ConfigureCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 163 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		bool ret = true;
															#line 164 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		switch (result) { case ConfigurationResult::NO_OPTIONS_PROVIDED: case ConfigurationResult::CONFLICTING_OPTIONS: case ConfigurationResult::UNKNOWN_OPTION: case ConfigurationResult::INCOMPLETE_CONFIGURATION: printUsage("configure"_sr); ret = false; break; case ConfigurationResult::INVALID_CONFIGURATION: fprintf(stderr, "ERROR: These changes would make the configuration invalid\n"); ret = false; break; case ConfigurationResult::STORAGE_MIGRATION_DISABLED: fprintf(stderr, "ERROR: Storage engine type cannot be changed because " "storage_migration_type=disabled.\n"); fprintf(stderr, "Type `configure perpetual_storage_wiggle=1 storage_migration_type=gradual' to enable gradual " "migration with the perpetual wiggle, or `configure " "storage_migration_type=aggressive' for aggressive migration.\n"); ret = false; break; case ConfigurationResult::DATABASE_ALREADY_CREATED: fprintf(stderr, "ERROR: Database already exists! To change configuration, don't say `new'\n"); ret = false; break; case ConfigurationResult::DATABASE_CREATED: printf("Database created\n"); break; case ConfigurationResult::DATABASE_CREATED_WARN_SHARDED_ROCKSDB_EXPERIMENTAL: printf("Database created\n"); fprintf( stderr, "WARN: Sharded RocksDB storage engine type is still in experimental stage, not yet production tested.\n"); break; case ConfigurationResult::DATABASE_UNAVAILABLE: fprintf(stderr, "ERROR: The database is unavailable\n"); fprintf(stderr, "Type `configure FORCE <TOKEN...>' to configure without this check\n"); ret = false; break; case ConfigurationResult::STORAGE_IN_UNKNOWN_DCID: fprintf(stderr, "ERROR: All storage servers must be in one of the known regions\n"); fprintf(stderr, "Type `configure FORCE <TOKEN...>' to configure without this check\n"); ret = false; break; case ConfigurationResult::REGION_NOT_FULLY_REPLICATED: fprintf(stderr, "ERROR: When usable_regions > 1, all regions with priority >= 0 must be fully replicated " "before changing the configuration\n"); fprintf(stderr, "Type `configure FORCE <TOKEN...>' to configure without this check\n"); ret = false; break; case ConfigurationResult::MULTIPLE_ACTIVE_REGIONS: fprintf(stderr, "ERROR: When changing usable_regions, only one region can have priority >= 0\n"); fprintf(stderr, "Type `configure FORCE <TOKEN...>' to configure without this check\n"); ret = false; break; case ConfigurationResult::REGIONS_CHANGED: fprintf(stderr, "ERROR: The region configuration cannot be changed while simultaneously changing usable_regions\n"); fprintf(stderr, "Type `configure FORCE <TOKEN...>' to configure without this check\n"); ret = false; break; case ConfigurationResult::NOT_ENOUGH_WORKERS: fprintf(stderr, "ERROR: Not enough processes exist to support the specified configuration\n"); fprintf(stderr, "Type `configure FORCE <TOKEN...>' to configure without this check\n"); ret = false; break; case ConfigurationResult::REGION_REPLICATION_MISMATCH: fprintf(stderr, "ERROR: `three_datacenter' replication is incompatible with region configuration\n"); fprintf(stderr, "Type `configure FORCE <TOKEN...>' to configure without this check\n"); ret = false; break; case ConfigurationResult::DCID_MISSING: fprintf(stderr, "ERROR: `No storage servers in one of the specified regions\n"); fprintf(stderr, "Type `configure FORCE <TOKEN...>' to configure without this check\n"); ret = false; break; case ConfigurationResult::SUCCESS: printf("Configuration changed\n"); break; case ConfigurationResult::LOCKED_NOT_NEW: fprintf(stderr, "ERROR: `only new databases can be configured as locked`\n"); ret = false; break; case ConfigurationResult::SUCCESS_WARN_PPW_GRADUAL: printf("Configuration changed, with warnings\n"); fprintf(stderr, "WARN: To make progress toward the desired storage type with storage_migration_type=gradual, the " "Perpetual Wiggle must be enabled.\n"); fprintf(stderr, "Type `configure perpetual_storage_wiggle=1' to enable the perpetual wiggle, or `configure " "storage_migration_type=gradual' to set the gradual migration type.\n"); break; case ConfigurationResult::SUCCESS_WARN_SHARDED_ROCKSDB_EXPERIMENTAL: printf("Configuration changed\n"); fprintf( stderr, "WARN: Sharded RocksDB storage engine type is still in experimental stage, not yet production tested.\n"); break; case ConfigurationResult::DATABASE_IS_REGISTERED: fprintf(stderr, "ERROR: a result of type `ConfigurationResult::DATABASE_IS_REGISTERED` was unexpectedly seen.\n"); ret = false; break; case ConfigurationResult::ENCRYPTION_AT_REST_MODE_ALREADY_SET: fprintf(stderr, "ERROR: A cluster cannot change its encryption_at_rest state after database creation.\n"); ret = false; break; case ConfigurationResult::INVALID_STORAGE_TYPE: fprintf(stderr, "ERROR: Invalid storage type for storage or TLog.\n"); ret = false; break; default: ASSERT(false); ret = false; };
															#line 281 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		if (!static_cast<ConfigureCommandActorActor*>(this)->SAV<bool>::futures) { (void)(ret); this->~ConfigureCommandActorActorState(); static_cast<ConfigureCommandActorActor*>(this)->destroy(); return 0; }
															#line 171 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
		new (&static_cast<ConfigureCommandActorActor*>(this)->SAV< bool >::value()) bool(ret);
		this->~ConfigureCommandActorActorState();
		static_cast<ConfigureCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 156 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		StrictFuture<ConfigurationResult> __when_expr_3 = ManagementAPI::changeConfig( db, std::vector<StringRef>(tokens.begin() + startToken, tokens.end()), conf, force);
															#line 156 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		if (static_cast<ConfigureCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 185 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<ConfigureCommandActorActor*>(this)->actor_wait_state = 4;
															#line 156 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ConfigureCommandActorActor, 3, ConfigurationResult >*>(static_cast<ConfigureCommandActorActor*>(this)));
															#line 190 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 71 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		if (warn.isValid())
															#line 199 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
		{
															#line 72 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
			warn.cancel();
															#line 203 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
		}
															#line 74 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		conf = parseConfig(s);
															#line 76 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		if (!conf.get().isValid())
															#line 209 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
		{
															#line 77 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
			printf("Unable to provide advice for the current configuration.\n");
															#line 78 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
			if (!static_cast<ConfigureCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ConfigureCommandActorActorState(); static_cast<ConfigureCommandActorActor*>(this)->destroy(); return 0; }
															#line 215 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
			new (&static_cast<ConfigureCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
			this->~ConfigureCommandActorActorState();
			static_cast<ConfigureCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 81 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		bool noChanges = conf.get().old_replication == conf.get().auto_replication && conf.get().old_logs == conf.get().auto_logs && conf.get().old_commit_proxies == conf.get().auto_commit_proxies && conf.get().old_grv_proxies == conf.get().auto_grv_proxies && conf.get().old_resolvers == conf.get().auto_resolvers && conf.get().old_processes_with_transaction == conf.get().auto_processes_with_transaction && conf.get().old_machines_with_transaction == conf.get().auto_machines_with_transaction;
															#line 89 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		bool noDesiredChanges = noChanges && conf.get().old_logs == conf.get().desired_logs && conf.get().old_commit_proxies == conf.get().desired_commit_proxies && conf.get().old_grv_proxies == conf.get().desired_grv_proxies && conf.get().old_resolvers == conf.get().desired_resolvers;
															#line 94 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		std::string outputString;
															#line 96 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		outputString += "\nYour cluster has:\n\n";
															#line 97 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		outputString += format("  processes %d\n", conf.get().processes);
															#line 98 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		outputString += format("  machines  %d\n", conf.get().machines);
															#line 100 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		if (noDesiredChanges)
															#line 235 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
		{
															#line 101 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
			outputString += "\nConfigure recommends keeping your current configuration:\n\n";
															#line 239 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
		}
		else
		{
															#line 102 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
			if (noChanges)
															#line 245 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
			{
															#line 103 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
				outputString += "\nConfigure cannot modify the configuration because some parameters have been set manually:\n\n";
															#line 249 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
			}
			else
			{
															#line 106 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
				outputString += "\nConfigure recommends the following changes:\n\n";
															#line 255 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
			}
		}
															#line 107 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		outputString += " ------------------------------------------------------------------- \n";
															#line 108 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		outputString += "| parameter                   | old              | new              |\n";
															#line 109 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		outputString += " ------------------------------------------------------------------- \n";
															#line 110 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		outputString += format("| replication                 | %16s | %16s |\n", conf.get().old_replication.c_str(), conf.get().auto_replication.c_str());
															#line 113 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		outputString += format("| logs                        | %16d | %16d |", conf.get().old_logs, conf.get().auto_logs);
															#line 115 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		outputString += conf.get().auto_logs != conf.get().desired_logs ? format(" (manually set; would be %d)\n", conf.get().desired_logs) : "\n";
															#line 118 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		outputString += format("| commit_proxies              | %16d | %16d |", conf.get().old_commit_proxies, conf.get().auto_commit_proxies);
															#line 121 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		outputString += conf.get().auto_commit_proxies != conf.get().desired_commit_proxies ? format(" (manually set; would be %d)\n", conf.get().desired_commit_proxies) : "\n";
															#line 124 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		outputString += format("| grv_proxies                 | %16d | %16d |", conf.get().old_grv_proxies, conf.get().auto_grv_proxies);
															#line 127 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		outputString += conf.get().auto_grv_proxies != conf.get().desired_grv_proxies ? format(" (manually set; would be %d)\n", conf.get().desired_grv_proxies) : "\n";
															#line 130 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		outputString += format( "| resolvers                   | %16d | %16d |", conf.get().old_resolvers, conf.get().auto_resolvers);
															#line 132 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		outputString += conf.get().auto_resolvers != conf.get().desired_resolvers ? format(" (manually set; would be %d)\n", conf.get().desired_resolvers) : "\n";
															#line 135 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		outputString += format("| transaction-class processes | %16d | %16d |\n", conf.get().old_processes_with_transaction, conf.get().auto_processes_with_transaction);
															#line 138 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		outputString += format("| transaction-class machines  | %16d | %16d |\n", conf.get().old_machines_with_transaction, conf.get().auto_machines_with_transaction);
															#line 141 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		outputString += " ------------------------------------------------------------------- \n\n";
															#line 143 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		std::printf("%s", outputString.c_str());
															#line 145 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		if (noChanges)
															#line 292 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
		{
															#line 146 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
			if (!static_cast<ConfigureCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ConfigureCommandActorActorState(); static_cast<ConfigureCommandActorActor*>(this)->destroy(); return 0; }
															#line 296 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
			new (&static_cast<ConfigureCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
			this->~ConfigureCommandActorActorState();
			static_cast<ConfigureCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 149 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		StrictFuture<Optional<std::string>> __when_expr_2 = linenoise->read("Would you like to make these changes? [y/n]> ");
															#line 149 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		if (static_cast<ConfigureCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 306 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<ConfigureCommandActorActor*>(this)->actor_wait_state = 3;
															#line 149 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConfigureCommandActorActor, 2, Optional<std::string> >*>(static_cast<ConfigureCommandActorActor*>(this)));
															#line 311 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(StatusObject const& _s,int loopDepth) 
	{
															#line 58 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		s = _s;
															#line 320 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(StatusObject && _s,int loopDepth) 
	{
															#line 58 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		s = _s;
															#line 329 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when1(StatusObject const& _s,int loopDepth) 
	{
		loopDepth = a_body1cont6(_s, loopDepth);

		return loopDepth;
	}
	int a_body1when1(StatusObject && _s,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_s), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConfigureCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ConfigureCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureCommandActorActor*>(this)->ActorCallback< ConfigureCommandActorActor, 0, StatusObject >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureCommandActorActor, 0, StatusObject >*,StatusObject const& value) 
	{
		fdb_probe_actor_enter("configureCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConfigureCommandActorActor, 0, StatusObject >*,StatusObject && value) 
	{
		fdb_probe_actor_enter("configureCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConfigureCommandActorActor, 0, StatusObject >*,Error err) 
	{
		fdb_probe_actor_enter("configureCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont8(Optional<Value> const& statusValue,int loopDepth) 
	{
															#line 62 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		if (!statusValue.present())
															#line 413 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
		{
															#line 63 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
			fprintf(stderr, "ERROR: Failed to get status json from the cluster\n");
															#line 64 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
			if (!static_cast<ConfigureCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ConfigureCommandActorActorState(); static_cast<ConfigureCommandActorActor*>(this)->destroy(); return 0; }
															#line 419 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
			new (&static_cast<ConfigureCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
			this->~ConfigureCommandActorActorState();
			static_cast<ConfigureCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 66 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		json_spirit::mValue mv;
															#line 67 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		json_spirit::read_string(statusValue.get().toString(), mv);
															#line 68 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		s = StatusObject(mv.get_obj());
															#line 431 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Optional<Value> && statusValue,int loopDepth) 
	{
															#line 62 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		if (!statusValue.present())
															#line 440 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
		{
															#line 63 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
			fprintf(stderr, "ERROR: Failed to get status json from the cluster\n");
															#line 64 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
			if (!static_cast<ConfigureCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ConfigureCommandActorActorState(); static_cast<ConfigureCommandActorActor*>(this)->destroy(); return 0; }
															#line 446 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
			new (&static_cast<ConfigureCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
			this->~ConfigureCommandActorActorState();
			static_cast<ConfigureCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 66 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		json_spirit::mValue mv;
															#line 67 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		json_spirit::read_string(statusValue.get().toString(), mv);
															#line 68 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		s = StatusObject(mv.get_obj());
															#line 458 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Optional<Value> const& statusValue,int loopDepth) 
	{
		loopDepth = a_body1cont8(statusValue, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Optional<Value> && statusValue,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(statusValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConfigureCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ConfigureCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureCommandActorActor*>(this)->ActorCallback< ConfigureCommandActorActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureCommandActorActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("configureCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConfigureCommandActorActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("configureCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConfigureCommandActorActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("configureCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont11(Optional<std::string> const& line,int loopDepth) 
	{
															#line 151 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		if (!line.present() || (line.get() != "y" && line.get() != "Y"))
															#line 542 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
		{
															#line 152 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
			if (!static_cast<ConfigureCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ConfigureCommandActorActorState(); static_cast<ConfigureCommandActorActor*>(this)->destroy(); return 0; }
															#line 546 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
			new (&static_cast<ConfigureCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
			this->~ConfigureCommandActorActorState();
			static_cast<ConfigureCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Optional<std::string> && line,int loopDepth) 
	{
															#line 151 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		if (!line.present() || (line.get() != "y" && line.get() != "Y"))
															#line 560 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
		{
															#line 152 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
			if (!static_cast<ConfigureCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ConfigureCommandActorActorState(); static_cast<ConfigureCommandActorActor*>(this)->destroy(); return 0; }
															#line 564 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
			new (&static_cast<ConfigureCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
			this->~ConfigureCommandActorActorState();
			static_cast<ConfigureCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Optional<std::string> const& line,int loopDepth) 
	{
		loopDepth = a_body1cont11(line, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Optional<std::string> && line,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(line), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ConfigureCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ConfigureCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureCommandActorActor*>(this)->ActorCallback< ConfigureCommandActorActor, 2, Optional<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureCommandActorActor, 2, Optional<std::string> >*,Optional<std::string> const& value) 
	{
		fdb_probe_actor_enter("configureCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ConfigureCommandActorActor, 2, Optional<std::string> >*,Optional<std::string> && value) 
	{
		fdb_probe_actor_enter("configureCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ConfigureCommandActorActor, 2, Optional<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("configureCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont19(ConfigurationResult const& r,int loopDepth) 
	{
															#line 158 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		result = r;
															#line 653 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont19(ConfigurationResult && r,int loopDepth) 
	{
															#line 158 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
		result = r;
															#line 662 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(ConfigurationResult const& r,int loopDepth) 
	{
		loopDepth = a_body1cont19(r, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(ConfigurationResult && r,int loopDepth) 
	{
		loopDepth = a_body1cont19(std::move(r), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ConfigureCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ConfigureCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureCommandActorActor*>(this)->ActorCallback< ConfigureCommandActorActor, 3, ConfigurationResult >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureCommandActorActor, 3, ConfigurationResult >*,ConfigurationResult const& value) 
	{
		fdb_probe_actor_enter("configureCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ConfigureCommandActorActor, 3, ConfigurationResult >*,ConfigurationResult && value) 
	{
		fdb_probe_actor_enter("configureCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ConfigureCommandActorActor, 3, ConfigurationResult >*,Error err) 
	{
		fdb_probe_actor_enter("configureCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 35 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 35 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
	Database localDb;
															#line 35 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 35 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
	LineNoise* linenoise;
															#line 35 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
	Future<Void> warn;
															#line 40 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
	ConfigurationResult result;
															#line 41 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
	StatusObject s;
															#line 42 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
	int startToken;
															#line 43 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
	bool force;
															#line 52 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
	Optional<ConfigureAutoResult> conf;
															#line 55 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 60 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
	ThreadFuture<Optional<Value>> statusValueF;
															#line 766 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via configureCommandActor()
															#line 35 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
class ConfigureCommandActorActor final : public Actor<bool>, public ActorCallback< ConfigureCommandActorActor, 0, StatusObject >, public ActorCallback< ConfigureCommandActorActor, 1, Optional<Value> >, public ActorCallback< ConfigureCommandActorActor, 2, Optional<std::string> >, public ActorCallback< ConfigureCommandActorActor, 3, ConfigurationResult >, public FastAllocated<ConfigureCommandActorActor>, public ConfigureCommandActorActorState<ConfigureCommandActorActor> {
															#line 771 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<ConfigureCommandActorActor>::operator new;
	using FastAllocated<ConfigureCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4791442105028440064UL, 18014607361732844544UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConfigureCommandActorActor, 0, StatusObject >;
friend struct ActorCallback< ConfigureCommandActorActor, 1, Optional<Value> >;
friend struct ActorCallback< ConfigureCommandActorActor, 2, Optional<std::string> >;
friend struct ActorCallback< ConfigureCommandActorActor, 3, ConfigurationResult >;
															#line 35 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
	ConfigureCommandActorActor(Reference<IDatabase> const& db,Database const& localDb,std::vector<StringRef> const& tokens,LineNoise* const& linenoise,Future<Void> const& warn) 
															#line 791 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   ConfigureCommandActorActorState<ConfigureCommandActorActor>(db, localDb, tokens, linenoise, warn),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("configureCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6290999020879577344UL, 12273842124786192128UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("configureCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("configureCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConfigureCommandActorActor, 0, StatusObject >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ConfigureCommandActorActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ConfigureCommandActorActor, 2, Optional<std::string> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ConfigureCommandActorActor, 3, ConfigurationResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 35 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
[[nodiscard]] Future<bool> configureCommandActor( Reference<IDatabase> const& db, Database const& localDb, std::vector<StringRef> const& tokens, LineNoise* const& linenoise, Future<Void> const& warn ) {
															#line 35 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"
	return Future<bool>(new ConfigureCommandActorActor(db, localDb, tokens, linenoise, warn));
															#line 826 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/fdbcli/ConfigureCommand.actor.g.cpp.py_gen"
}

#line 283 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/fdbcli/ConfigureCommand.actor.cpp"

void configureGenerator(const char* text,
                        const char* line,
                        std::vector<std::string>& lc,
                        std::vector<StringRef> const& tokens) {
	const char* opts[] = { "new",
		                   "single",
		                   "double",
		                   "triple",
		                   "three_data_hall",
		                   "three_datacenter",
		                   "ssd",
		                   "ssd-1",
		                   "ssd-2",
		                   "memory",
		                   "memory-1",
		                   "memory-2",
		                   "memory-radixtree",
		                   "commit_proxies=",
		                   "grv_proxies=",
		                   "logs=",
		                   "resolvers=",
		                   "perpetual_storage_wiggle=",
		                   "perpetual_storage_wiggle_locality=",
		                   // TODO(zhewu): update fdbcli command documentation.
		                   "perpetual_storage_wiggle_engine=",
		                   "storage_migration_type=",
		                   "encryption_at_rest_mode=",
		                   nullptr };
	arrayGenerator(text, line, opts, lc);
}

CommandFactory configureFactory(
    "configure",
    CommandHelp(
        "configure [new|tss]"
        "<single|double|triple|three_data_hall|three_datacenter|ssd|memory|memory-radixtree|proxies=<PROXIES>|"
        "commit_proxies=<COMMIT_PROXIES>|grv_proxies=<GRV_PROXIES>|logs=<LOGS>|resolvers=<RESOLVERS>>*|"
        "count=<TSS_COUNT>|perpetual_storage_wiggle=<WIGGLE_SPEED>|perpetual_storage_wiggle_locality="
        "<<LOCALITY_KEY>:<LOCALITY_VALUE>|0>|storage_migration_type={disabled|gradual|aggressive}"
        "|encryption_at_rest_mode={disabled|domain_aware|cluster_aware}"
        "|exclude=<ADDRESS...>",
        "change the database configuration",
        "The `new' option, if present, initializes a new database with the given configuration rather than changing "
        "the configuration of an existing one. When used, both a redundancy mode and a storage engine must be "
        "specified.\n\ntss: when enabled, configures the testing storage server for the cluster instead."
        "When used with new to set up tss for the first time, it requires both a count and a storage engine."
        "To disable the testing storage server, run \"configure tss count=0\"\n\n"
        "Redundancy mode:\n  single - one copy of the data.  Not fault tolerant.\n  double - two copies "
        "of data (survive one failure).\n  triple - three copies of data (survive two failures).\n  three_data_hall - "
        "See the Admin Guide.\n  three_datacenter - See the Admin Guide.\n\nStorage engine:\n  ssd - B-Tree storage "
        "engine optimized for solid state disks.\n  memory - Durable in-memory storage engine for small "
        "datasets.\n\nproxies=<PROXIES>: Sets the desired number of proxies in the cluster. The proxy role is being "
        "deprecated and split into GRV proxy and Commit proxy, now prefer configure 'grv_proxies' and 'commit_proxies' "
        "separately. Generally we should follow that 'commit_proxies' is three times of 'grv_proxies' and "
        "'grv_proxies' "
        "should be not more than 4. If 'proxies' is specified, it will be converted to 'grv_proxies' and "
        "'commit_proxies'. "
        "Must be at least 2 (1 GRV proxy, 1 Commit proxy), or set to -1 which restores the number of proxies to the "
        "default value.\n\ncommit_proxies=<COMMIT_PROXIES>: Sets the desired number of commit proxies in the cluster. "
        "Must be at least 1, or set to -1 which restores the number of commit proxies to the default "
        "value.\n\ngrv_proxies=<GRV_PROXIES>: Sets the desired number of GRV proxies in the cluster. Must be at least "
        "1, or set to -1 which restores the number of GRV proxies to the default value.\n\nlogs=<LOGS>: Sets the "
        "desired number of log servers in the cluster. Must be at least 1, or set to -1 which restores the number of "
        "logs to the default value.\n\nresolvers=<RESOLVERS>: Sets the desired number of resolvers in the cluster. "
        "Must be at least 1, or set to -1 which restores the number of resolvers to the default value.\n\n"
        "perpetual_storage_wiggle=<WIGGLE_SPEED>: Set the value speed (a.k.a., the number of processes that the Data "
        "Distributor should wiggle at a time). Currently, only 0 and 1 are supported. The value 0 means to disable the "
        "perpetual storage wiggle.\n\n"
        "perpetual_storage_wiggle_locality=<<LOCALITY_KEY>:<LOCALITY_VALUE>|0>: Set the process filter for wiggling. "
        "The processes that match the given locality key and locality value are only wiggled. The value 0 will disable "
        "the locality filter and matches all the processes for wiggling.\n\n"
        "encryption_at_rest_mode=<disabled|domain_aware|cluster_aware>: Sets the cluster encryption data at-rest "
        "support for the "
        "database. The configuration can be updated ONLY at the time of database creation and once set can't be "
        "updated for the lifetime of the database.\n\n"
        "exclude=<ADDRESS...>: Sets the addresses in the format of IP1:port1,IP2:port2 pairs to be excluded during "
        "recruitment. Note this should be only used when the database is unavailable because of the faulty processes "
        "that are blocking the recovery from completion. The number of addresses should be less than the replication "
        "factor to avoid data loss.\n\n"

        "See the FoundationDB Administration Guide for more information."),
    &configureGenerator);

} // namespace fdb_cli
