#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
/*
 * Tester.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// When actually compiled (NO_INTELLISENSE), include the generated version of this file.  In intellisense use the source
// version.
#if defined(NO_INTELLISENSE) && !defined(FDB_FLOW_TESTER_TESTER_ACTOR_G_H)
#define FDB_FLOW_TESTER_TESTER_ACTOR_G_H
#include "tester/Tester.actor.g.h"
#elif !defined(FDB_FLOW_TESTER_TESTER_ACTOR_H)
#define FDB_FLOW_TESTER_TESTER_ACTOR_H

#pragma once

#include <utility>

#include "flow/IDispatched.h"
#include "bindings/flow/fdb_flow.h"
#include "bindings/flow/IDirectory.h"
#include "bindings/flow/Subspace.h"
#include "bindings/flow/DirectoryLayer.h"
#include "flow/actorcompiler.h" // This must be the last #include.

constexpr bool LOG_ALL = false;
constexpr bool LOG_INSTRUCTIONS = LOG_ALL || false;
constexpr bool LOG_OPS = LOG_ALL || false;
constexpr bool LOG_DIRS = LOG_ALL || false;
constexpr bool LOG_ERRORS = LOG_ALL || false;

struct FlowTesterData;

struct StackItem {
	StackItem() : index(-1) {}
	StackItem(uint32_t i, Future<Standalone<StringRef>> v) : index(i), value(v) {}
	StackItem(uint32_t i, Standalone<StringRef> v) : index(i), value(v) {}
	uint32_t index;
	Future<Standalone<StringRef>> value;
};

struct FlowTesterStack {
	uint32_t index;
	std::vector<StackItem> data;

	void push(Future<Standalone<StringRef>> value) { data.push_back(StackItem(index, value)); }

	void push(Standalone<StringRef> value) { push(Future<Standalone<StringRef>>(value)); }

	void push(const StackItem& item) { data.push_back(item); }

	void pushTuple(StringRef value, bool utf8 = false) {
		FDB::Tuple t;
		t.append(value, utf8);
		data.push_back(StackItem(index, t.pack()));
	}

	void pushError(int errorCode) {
		FDB::Tuple t;
		t.append("ERROR"_sr);
		t.append(format("%d", errorCode));
		// pack above as error string into another tuple
		pushTuple(t.pack().toString());
	}

	std::vector<StackItem> pop(uint32_t count = 1) {
		std::vector<StackItem> items;
		while (!data.empty() && count > 0) {
			items.push_back(data.back());
			data.pop_back();
			count--;
		}
		return items;
	}

	Future<std::vector<FDB::Tuple>> waitAndPop(int count);
	Future<FDB::Tuple> waitAndPop();

	void dup() {
		if (data.empty())
			return;
		data.push_back(data.back());
	}

	void clear() { data.clear(); }
};

struct InstructionData : public ReferenceCounted<InstructionData> {
	bool isDatabase;
	bool isSnapshot;
	StringRef instruction;
	Reference<FDB::Transaction> tr;

	InstructionData(bool _isDatabase, bool _isSnapshot, StringRef _instruction, Reference<FDB::Transaction> _tr)
	  : isDatabase(_isDatabase), isSnapshot(_isSnapshot), instruction(_instruction), tr(_tr) {}
};

struct FlowTesterData;

struct InstructionFunc
  : IDispatched<InstructionFunc,
                std::string,
                std::function<Future<Void>(Reference<FlowTesterData> data, Reference<InstructionData> instruction)>> {
	static Future<Void> call(std::string op, Reference<FlowTesterData> data, Reference<InstructionData> instruction) {
		ASSERT(data);
		ASSERT(instruction);

		auto it = dispatches().find(op);
		if (it == dispatches().end()) {
			fprintf(stderr, "Unrecognized instruction: %s\n", op.c_str());
			ASSERT(false);
		}

		return dispatch(op)(data, instruction);
	}
};
#define REGISTER_INSTRUCTION_FUNC(Op) REGISTER_COMMAND(InstructionFunc, Op, name, call)

struct DirectoryOrSubspace {
	Optional<Reference<FDB::IDirectory>> directory;
	Optional<FDB::Subspace*> subspace;

	DirectoryOrSubspace() {}
	DirectoryOrSubspace(Reference<FDB::IDirectory> directory) : directory(directory) {}
	DirectoryOrSubspace(FDB::Subspace* subspace) : subspace(subspace) {}
	DirectoryOrSubspace(Reference<FDB::DirectorySubspace> dirSubspace)
	  : directory(dirSubspace), subspace(dirSubspace.getPtr()) {}

	bool valid() { return directory.present() || subspace.present(); }

	std::string typeString() {
		if (directory.present() && subspace.present()) {
			return "DirectorySubspace";
		} else if (directory.present()) {
			return "IDirectory";
		} else if (subspace.present()) {
			return "Subspace";
		} else {
			return "InvalidDirectory";
		}
	}
};

struct DirectoryTesterData {
	std::vector<DirectoryOrSubspace> directoryList;
	int directoryListIndex;
	int directoryErrorIndex;

	Reference<FDB::IDirectory> directory() {
		ASSERT(directoryListIndex < directoryList.size());
		ASSERT(directoryList[directoryListIndex].directory.present());
		return directoryList[directoryListIndex].directory.get();
	}

	FDB::Subspace* subspace() {
		ASSERT(directoryListIndex < directoryList.size());
		ASSERT(directoryList[directoryListIndex].subspace.present());
		return directoryList[directoryListIndex].subspace.get();
	}

	DirectoryTesterData() : directoryListIndex(0), directoryErrorIndex(0) {
		directoryList.push_back(Reference<FDB::IDirectory>(new FDB::DirectoryLayer()));
	}

	template <class T>
	void push(T item) {
		directoryList.push_back(DirectoryOrSubspace(item));
		if (LOG_DIRS) {
			printf("Pushed %s at %lu\n", directoryList.back().typeString().c_str(), directoryList.size() - 1);
			fflush(stdout);
		}
	}

	void push() { push(DirectoryOrSubspace()); }
};

struct FlowTesterData : public ReferenceCounted<FlowTesterData> {
	FDB::API* api;
	Reference<FDB::Database> db;
	Standalone<FDB::RangeResultRef> instructions;
	Standalone<StringRef> trName;
	FlowTesterStack stack;
	FDB::Version lastVersion;
	DirectoryTesterData directoryData;

	std::vector<Future<Void>> subThreads;

	Future<Void> processInstruction(Reference<InstructionData> instruction) {
		return InstructionFunc::call(
		    instruction->instruction.toString(), Reference<FlowTesterData>::addRef(this), instruction);
	}

	FlowTesterData(FDB::API* api) { this->api = api; }
};

std::string tupleToString(FDB::Tuple const& tuple);

															#line 214 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.h.py_gen"
namespace {
// This generated class is to be used only via executeMutation()
															#line 212 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
template <class F, class ExecuteMutationActor>
															#line 212 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
class ExecuteMutationActorState {
															#line 221 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.h.py_gen"
public:
															#line 212 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
	ExecuteMutationActorState(Reference<InstructionData> const& instruction,F const& func) 
															#line 212 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
															#line 212 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
		 : instruction(instruction),
															#line 212 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
		   func(func)
															#line 230 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("executeMutation", reinterpret_cast<unsigned long>(this));

	}
	~ExecuteMutationActorState() 
	{
		fdb_probe_actor_destroy("executeMutation", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 214 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
			;
															#line 245 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.h.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExecuteMutationActorState();
		static_cast<ExecuteMutationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 216 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
			StrictFuture<decltype(std::declval<F>()().getValue())> __when_expr_0 = func();
															#line 216 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
			if (static_cast<ExecuteMutationActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 278 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.h.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ExecuteMutationActor*>(this)->actor_wait_state = 1;
															#line 216 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExecuteMutationActor, 0, decltype(std::declval<F>()().getValue()) >*>(static_cast<ExecuteMutationActor*>(this)));
															#line 283 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.h.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 222 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
			if (instruction->isDatabase)
															#line 305 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.h.py_gen"
			{
															#line 223 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
				StrictFuture<Void> __when_expr_2 = instruction->tr->onError(e);
															#line 223 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
				if (static_cast<ExecuteMutationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 311 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.h.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
				static_cast<ExecuteMutationActor*>(this)->actor_wait_state = 3;
															#line 223 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ExecuteMutationActor, 2, Void >*>(static_cast<ExecuteMutationActor*>(this)));
															#line 316 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.h.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 225 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 323 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.h.py_gen"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 217 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
		if (instruction->isDatabase)
															#line 338 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.h.py_gen"
		{
															#line 218 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
			StrictFuture<Void> __when_expr_1 = instruction->tr->commit();
															#line 218 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
			if (static_cast<ExecuteMutationActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 344 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.h.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<ExecuteMutationActor*>(this)->actor_wait_state = 2;
															#line 218 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExecuteMutationActor, 1, Void >*>(static_cast<ExecuteMutationActor*>(this)));
															#line 349 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.h.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(decltype(std::declval<F>()().getValue()) const& __result,int loopDepth) 
	{
															#line 216 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
		result = __result;
															#line 363 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.h.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(decltype(std::declval<F>()().getValue()) && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExecuteMutationActor*>(this)->actor_wait_state > 0) static_cast<ExecuteMutationActor*>(this)->actor_wait_state = 0;
		static_cast<ExecuteMutationActor*>(this)->ActorCallback< ExecuteMutationActor, 0, decltype(std::declval<F>()().getValue()) >::remove();

	}
	void a_callback_fire(ActorCallback< ExecuteMutationActor, 0, decltype(std::declval<F>()().getValue()) >*,decltype(std::declval<F>()().getValue()) const& value) 
	{
		fdb_probe_actor_enter("executeMutation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExecuteMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("executeMutation", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExecuteMutationActor, 0, decltype(std::declval<F>()().getValue()) >*,decltype(std::declval<F>()().getValue()) && value) 
	{
		fdb_probe_actor_enter("executeMutation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExecuteMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("executeMutation", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExecuteMutationActor, 0, decltype(std::declval<F>()().getValue()) >*,Error err) 
	{
		fdb_probe_actor_enter("executeMutation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExecuteMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("executeMutation", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 220 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
		if (!static_cast<ExecuteMutationActor*>(this)->SAV<decltype(std::declval<F>()().getValue())>::futures) { (void)(result); this->~ExecuteMutationActorState(); static_cast<ExecuteMutationActor*>(this)->destroy(); return 0; }
															#line 442 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.h.py_gen"
		new (&static_cast<ExecuteMutationActor*>(this)->SAV< decltype(std::declval<F>()().getValue()) >::value()) decltype(std::declval<F>()().getValue())(std::move(result)); // state_var_RVO
		this->~ExecuteMutationActorState();
		static_cast<ExecuteMutationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ExecuteMutationActor*>(this)->actor_wait_state > 0) static_cast<ExecuteMutationActor*>(this)->actor_wait_state = 0;
		static_cast<ExecuteMutationActor*>(this)->ActorCallback< ExecuteMutationActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExecuteMutationActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("executeMutation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExecuteMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("executeMutation", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ExecuteMutationActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("executeMutation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExecuteMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("executeMutation", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ExecuteMutationActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("executeMutation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExecuteMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("executeMutation", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ExecuteMutationActor*>(this)->actor_wait_state > 0) static_cast<ExecuteMutationActor*>(this)->actor_wait_state = 0;
		static_cast<ExecuteMutationActor*>(this)->ActorCallback< ExecuteMutationActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExecuteMutationActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("executeMutation", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExecuteMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("executeMutation", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ExecuteMutationActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("executeMutation", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExecuteMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("executeMutation", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ExecuteMutationActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("executeMutation", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExecuteMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("executeMutation", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 212 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
	Reference<InstructionData> instruction;
															#line 212 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
	F func;
															#line 216 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
	decltype(std::declval<F>()().getValue()) result;
															#line 636 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.h.py_gen"
};
// This generated class is to be used only via executeMutation()
															#line 212 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
template <class F>
															#line 212 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
class ExecuteMutationActor final : public Actor<decltype(std::declval<F>()().getValue())>, public ActorCallback< ExecuteMutationActor<F>, 0, decltype(std::declval<F>()().getValue()) >, public ActorCallback< ExecuteMutationActor<F>, 1, Void >, public ActorCallback< ExecuteMutationActor<F>, 2, Void >, public FastAllocated<ExecuteMutationActor<F>>, public ExecuteMutationActorState<F, ExecuteMutationActor<F>> {
															#line 643 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.h.py_gen"
public:
	using FastAllocated<ExecuteMutationActor<F>>::operator new;
	using FastAllocated<ExecuteMutationActor<F>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15475202039063800832UL, 5853375848650585856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<decltype(std::declval<F>()().getValue())>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExecuteMutationActor<F>, 0, decltype(std::declval<F>()().getValue()) >;
friend struct ActorCallback< ExecuteMutationActor<F>, 1, Void >;
friend struct ActorCallback< ExecuteMutationActor<F>, 2, Void >;
															#line 212 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
	ExecuteMutationActor(Reference<InstructionData> const& instruction,F const& func) 
															#line 662 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.h.py_gen"
		 : Actor<decltype(std::declval<F>()().getValue())>(),
		   ExecuteMutationActorState<F, ExecuteMutationActor<F>>(instruction, func),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("executeMutation", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(570614943463201536UL, 10919577791408577536UL);
		ActorExecutionContextHelper __helper(static_cast<ExecuteMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("executeMutation");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("executeMutation", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExecuteMutationActor<F>, 0, decltype(std::declval<F>()().getValue()) >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ExecuteMutationActor<F>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ExecuteMutationActor<F>, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 212 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
template <class F>
															#line 212 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
[[nodiscard]] Future<decltype(std::declval<F>()().getValue())> executeMutation( Reference<InstructionData> const& instruction, F const& func ) {
															#line 212 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"
	return Future<decltype(std::declval<F>()().getValue())>(new ExecuteMutationActor<F>(instruction, func));
															#line 699 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.h.py_gen"
}

#line 230 "/codebuild/output/src2047728441/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.h"

#include "flow/unactorcompiler.h"
#endif
