/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.Versionstamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;

public class TuplePerformanceTest {
    private final Random r;
    private final int ignoreIterations;
    private final int iterations;
    private final GeneratedTypes generatedTypes;

    public TuplePerformanceTest(Random random, int n, int n2, GeneratedTypes generatedTypes) {
        this.r = random;
        this.ignoreIterations = n;
        this.iterations = n2;
        this.generatedTypes = generatedTypes;
    }

    public Tuple createMultiTypeTuple(int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            double d = this.r.nextDouble();
            if (d < 0.1) {
                arrayList.add(null);
                continue;
            }
            if (d < 0.2) {
                byte[] byArray = new byte[this.r.nextInt(20)];
                this.r.nextBytes(byArray);
                arrayList.add(byArray);
                continue;
            }
            if (d < 0.3) {
                char[] cArray = new char[this.r.nextInt(20)];
                for (int j = 0; j < cArray.length; ++j) {
                    cArray[j] = (char)(97 + this.r.nextInt(26));
                }
                arrayList.add(new String(cArray));
                continue;
            }
            if (d < 0.4) {
                arrayList.add(this.r.nextInt(10000000) * (this.r.nextBoolean() ? -1 : 1));
                continue;
            }
            if (d < 0.5) {
                arrayList.add(Float.valueOf(this.r.nextFloat()));
                continue;
            }
            if (d < 0.6) {
                arrayList.add(this.r.nextDouble());
                continue;
            }
            if (d < 0.7) {
                arrayList.add(this.r.nextBoolean());
                continue;
            }
            if (d < 0.8) {
                arrayList.add(UUID.randomUUID());
                continue;
            }
            if (d < 0.9) {
                byte[] byArray = new byte[12];
                this.r.nextBytes(byArray);
                Versionstamp versionstamp = Versionstamp.fromBytes((byte[])byArray);
                arrayList.add(versionstamp);
                continue;
            }
            int n2 = this.r.nextInt(n);
            Tuple tuple = this.createTuple(n2);
            arrayList.add(tuple);
        }
        return Tuple.fromList(arrayList);
    }

    public Tuple createLongsTuple(int n) {
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        for (int i = 0; i < n; ++i) {
            int n2 = this.r.nextInt(9);
            long l = 0L;
            for (int j = 0; j < n2; ++j) {
                int n3 = this.r.nextInt(256);
                l = (l << 8) + (long)n3;
            }
            arrayList.add(l);
        }
        return Tuple.fromList(arrayList);
    }

    public Tuple createFloatingPointTuple(int n) {
        ArrayList<Number> arrayList = new ArrayList<Number>(n);
        for (int i = 0; i < n; ++i) {
            double d = this.r.nextDouble();
            if (d < 0.4) {
                arrayList.add(Float.valueOf(this.r.nextFloat()));
                continue;
            }
            if (d < 0.8) {
                arrayList.add(this.r.nextDouble());
                continue;
            }
            if (d < 0.9) {
                arrayList.add(Float.valueOf(Float.intBitsToFloat(this.r.nextInt())));
                continue;
            }
            arrayList.add(Double.longBitsToDouble(this.r.nextLong()));
        }
        return Tuple.fromList(arrayList);
    }

    public Tuple createStringLikeTuple(int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            int n2;
            Object[] objectArray;
            double d = this.r.nextDouble();
            if (d < 0.4) {
                objectArray = new byte[this.r.nextInt(20)];
                this.r.nextBytes((byte[])objectArray);
                arrayList.add(objectArray);
                continue;
            }
            if (d < 0.8) {
                objectArray = new int[this.r.nextInt(20)];
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    objectArray[n2] = this.r.nextInt(127);
                }
                arrayList.add(new String((int[])objectArray, 0, objectArray.length));
                continue;
            }
            if (d < 0.9) {
                objectArray = new byte[this.r.nextInt(20)];
                arrayList.add(objectArray);
                continue;
            }
            objectArray = new int[this.r.nextInt(20)];
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                int n3 = this.r.nextInt(0x10FFFF);
                while (Character.isSurrogate((char)n3)) {
                    n3 = this.r.nextInt(0x10FFFF);
                }
                objectArray[n2] = n3;
            }
            arrayList.add(new String((int[])objectArray, 0, objectArray.length));
        }
        return Tuple.fromList(arrayList);
    }

    public Tuple createTuple(int n) {
        switch (this.generatedTypes) {
            case ALL: {
                return this.createMultiTypeTuple(n);
            }
            case LONG: {
                return this.createLongsTuple(n);
            }
            case FLOATING_POINT: {
                return this.createFloatingPointTuple(n);
            }
            case STRING_LIKE: {
                return this.createStringLikeTuple(n);
            }
        }
        throw new IllegalStateException("unknown generated types " + (Object)((Object)this.generatedTypes));
    }

    public void run() {
        System.out.println("Warming up test...");
        for (int i = 0; i < this.ignoreIterations; ++i) {
            int n = this.r.nextInt(20);
            this.createTuple(n).pack();
        }
        System.gc();
        System.out.println("Beginning to record values...");
        Subspace subspace = new Subspace(Tuple.from((Object[])new Object[]{"test", "subspace"}));
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        long l9 = 0L;
        long l10 = 0L;
        long l11 = 0L;
        for (int i = 0; i < this.iterations; ++i) {
            if (i % 100000 == 0) {
                System.out.println("   iteration " + i);
            }
            int n = this.r.nextInt(20);
            Tuple tuple = this.createTuple(n);
            long l12 = System.nanoTime();
            byte[] byArray = tuple.pack();
            long l13 = System.nanoTime();
            l += l13 - l12;
            l10 += (long)tuple.size();
            l11 += (long)tuple.getPackedSize();
            l12 = System.nanoTime();
            Tuple tuple2 = Tuple.fromBytes((byte[])byArray);
            l13 = System.nanoTime();
            l2 += l13 - l12;
            Tuple tuple3 = Tuple.fromList((List)tuple.getItems());
            Tuple tuple4 = Tuple.fromList((List)tuple2.getItems());
            l12 = System.nanoTime();
            if (!tuple3.equals((Object)tuple4)) {
                throw new RuntimeException("deserialized did not match serialized: " + tuple + " -- " + tuple2);
            }
            l13 = System.nanoTime();
            l3 += l13 - l12;
            l12 = System.nanoTime();
            if (!tuple.equals((Object)tuple2)) {
                throw new RuntimeException("deserialized did not match serialized: " + tuple + " -- " + tuple2);
            }
            l13 = System.nanoTime();
            l4 += l13 - l12;
            tuple3 = Tuple.fromList((List)tuple.getItems());
            l12 = System.nanoTime();
            int n2 = tuple3.getPackedSize();
            l13 = System.nanoTime();
            if (n2 != tuple.pack().length) {
                throw new RuntimeException("packed size did not match actual packed length: " + tuple + " --  " + tuple3.getPackedSize() + " instead of " + tuple.getPackedSize());
            }
            l5 += l13 - l12;
            l12 = System.nanoTime();
            byte[] byArray2 = subspace.pack(tuple);
            l13 = System.nanoTime();
            if (!Arrays.equals(ByteArrayUtil.join((byte[][])new byte[][]{subspace.getKey(), byArray}), byArray2)) {
                throw new RuntimeException("subspace pack not equal to concatenation of parts");
            }
            l8 += l13 - l12;
            l12 = System.nanoTime();
            Tuple tuple5 = subspace.unpack(byArray2);
            l13 = System.nanoTime();
            if (!Tuple.fromList((List)tuple.getItems()).equals((Object)Tuple.fromList((List)tuple5.getItems())) || !tuple.equals((Object)tuple5)) {
                throw new RuntimeException("does not unpack equally from subspace");
            }
            if (!Arrays.equals(tuple.pack(), tuple5.pack())) {
                throw new RuntimeException("does not pack equally from subspace");
            }
            l9 += l13 - l12;
            l12 = System.nanoTime();
            int n3 = tuple.hashCode();
            l13 = System.nanoTime();
            l6 += l13 - l12;
            l12 = System.nanoTime();
            int n4 = tuple.hashCode();
            l13 = System.nanoTime();
            if (n3 != n4) {
                throw new RuntimeException("hash unstable");
            }
            l7 += l13 - l12;
        }
        System.out.println("Test ended.");
        System.out.printf("  Total elements:                        %d%n", l10);
        System.out.printf("  Total bytes:                           %d kB%n", l11 / 1000L);
        System.out.printf("  Bytes per tuple:                       %f B%n", (double)l11 * 1.0 / (double)this.iterations);
        System.out.printf("  Pack time:                             %f s%n", (double)l * 1.0E-9);
        System.out.printf("  Pack time per tuple:                   %f \u03bcs%n", (double)l * 0.001 / (double)this.iterations);
        System.out.printf("  Pack time per kB:                      %f \u03bcs%n", (double)l * 1.0 / (double)l11);
        System.out.printf("  Serialization rate:                    %f objects / \u03bcs%n", (double)l10 * 1000.0 / (double)l);
        System.out.printf("  Unpack time:                           %f s%n", (double)l2 * 1.0E-9);
        System.out.printf("  Unpack time per tuple:                 %f \u03bcs%n", (double)l2 * 0.001 / (double)this.iterations);
        System.out.printf("  Equals time:                           %f s%n", (double)l3 * 1.0E-9);
        System.out.printf("  Equals time per tuple:                 %f \u03bcs%n", (double)l3 * 0.001 / (double)this.iterations);
        System.out.printf("  Equals time (using packed):            %f s%n", (double)l4 * 1.0E-9);
        System.out.printf("  Equals time (using packed) per tuple:  %f \u03bcs%n", (double)l4 * 0.001 / (double)this.iterations);
        System.out.printf("  Size time:                             %f s%n", (double)l5 * 1.0E-9);
        System.out.printf("  Size time per tuple:                   %f \u03bcs%n", (double)l5 * 0.001 / (double)this.iterations);
        System.out.printf("  Subspace pack time:                    %f s%n", (double)l8 * 1.0E-9);
        System.out.printf("  Subspace pack time per tuple:          %f \u03bcs%n", (double)l8 * 0.001 / (double)this.iterations);
        System.out.printf("  Subspace unpack time:                  %f s%n", (double)l9 * 1.0E-9);
        System.out.printf("  Subspace unpack time per tuple:        %f \u03bcs%n", (double)l9 * 0.001 / (double)this.iterations);
        System.out.printf("  Hash time:                             %f s%n", (double)l6 * 1.0E-9);
        System.out.printf("  Hash time per tuple:                   %f \u03bcs%n", (double)l6 * 0.001 / (double)this.iterations);
        System.out.printf("  Second hash time:                      %f s%n", (double)l7 * 1.0E-9);
        System.out.printf("  Second hash time per tuple:            %f \u03bcs%n", (double)l7 * 0.001 / (double)this.iterations);
    }

    public static void main(String[] stringArray) {
        TuplePerformanceTest tuplePerformanceTest = new TuplePerformanceTest(new Random(), 100000, 10000000, GeneratedTypes.ALL);
        tuplePerformanceTest.run();
    }

    private static enum GeneratedTypes {
        ALL,
        LONG,
        FLOATING_POINT,
        STRING_LIKE;

    }
}

