#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
/*
 * ListTenantGroups.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(METACLUSTER_LISTTENANTGROUPS_ACTOR_G_H)
#define METACLUSTER_LISTTENANTGROUPS_ACTOR_G_H
#include "metacluster/ListTenantGroups.actor.g.h"
#elif !defined(METACLUSTER_LISTTENANTGROUPS_ACTOR_H)
#define METACLUSTER_LISTTENANTGROUPS_ACTOR_H

#include "fdbclient/Tenant.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"

#include "metacluster/MetaclusterTypes.h"

#include "flow/actorcompiler.h" // has to be last include

namespace metacluster {

															#line 40 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenantGroups.actor.g.h"
// This generated class is to be used only via listTenantGroupsTransaction()
															#line 38 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
template <class Transaction, class ListTenantGroupsTransactionActor>
															#line 38 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
class ListTenantGroupsTransactionActorState {
															#line 46 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenantGroups.actor.g.h"
public:
															#line 38 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
	ListTenantGroupsTransactionActorState(Transaction const& tr,TenantGroupName const& begin,TenantGroupName const& end,int const& limit) 
															#line 38 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
															#line 38 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
		 : tr(tr),
															#line 38 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
		   begin(begin),
															#line 38 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
		   end(end),
															#line 38 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
		   limit(limit)
															#line 59 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenantGroups.actor.g.h"
	{
		fdb_probe_actor_create("listTenantGroupsTransaction", reinterpret_cast<unsigned long>(this));

	}
	~ListTenantGroupsTransactionActorState() 
	{
		fdb_probe_actor_destroy("listTenantGroupsTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 41 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
			CODE_PROBE(true, "List tenant groups");
															#line 42 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
			tr->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 44 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
			StrictFuture<KeyBackedRangeResult<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>>> __when_expr_0 = metadata::management::tenantMetadata().tenantGroupMap.getRange(tr, begin, end, limit);
															#line 44 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
			if (static_cast<ListTenantGroupsTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 80 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenantGroups.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ListTenantGroupsTransactionActor*>(this)->actor_wait_state = 1;
															#line 44 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListTenantGroupsTransactionActor, 0, KeyBackedRangeResult<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> >*>(static_cast<ListTenantGroupsTransactionActor*>(this)));
															#line 85 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenantGroups.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListTenantGroupsTransactionActorState();
		static_cast<ListTenantGroupsTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(KeyBackedRangeResult<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> const& results,int loopDepth) 
	{
															#line 47 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
		if (!static_cast<ListTenantGroupsTransactionActor*>(this)->SAV<std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>>>::futures) { (void)(results.results); this->~ListTenantGroupsTransactionActorState(); static_cast<ListTenantGroupsTransactionActor*>(this)->destroy(); return 0; }
															#line 108 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenantGroups.actor.g.h"
		new (&static_cast<ListTenantGroupsTransactionActor*>(this)->SAV< std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> >::value()) std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>>(results.results);
		this->~ListTenantGroupsTransactionActorState();
		static_cast<ListTenantGroupsTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(KeyBackedRangeResult<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> && results,int loopDepth) 
	{
															#line 47 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
		if (!static_cast<ListTenantGroupsTransactionActor*>(this)->SAV<std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>>>::futures) { (void)(results.results); this->~ListTenantGroupsTransactionActorState(); static_cast<ListTenantGroupsTransactionActor*>(this)->destroy(); return 0; }
															#line 120 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenantGroups.actor.g.h"
		new (&static_cast<ListTenantGroupsTransactionActor*>(this)->SAV< std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> >::value()) std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>>(results.results);
		this->~ListTenantGroupsTransactionActorState();
		static_cast<ListTenantGroupsTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(KeyBackedRangeResult<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> const& results,int loopDepth) 
	{
		loopDepth = a_body1cont1(results, loopDepth);

		return loopDepth;
	}
	int a_body1when1(KeyBackedRangeResult<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> && results,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListTenantGroupsTransactionActor*>(this)->actor_wait_state > 0) static_cast<ListTenantGroupsTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<ListTenantGroupsTransactionActor*>(this)->ActorCallback< ListTenantGroupsTransactionActor, 0, KeyBackedRangeResult<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< ListTenantGroupsTransactionActor, 0, KeyBackedRangeResult<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> >*,KeyBackedRangeResult<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> const& value) 
	{
		fdb_probe_actor_enter("listTenantGroupsTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupsTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantGroupsTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListTenantGroupsTransactionActor, 0, KeyBackedRangeResult<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> >*,KeyBackedRangeResult<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> && value) 
	{
		fdb_probe_actor_enter("listTenantGroupsTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupsTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantGroupsTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListTenantGroupsTransactionActor, 0, KeyBackedRangeResult<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("listTenantGroupsTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupsTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantGroupsTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 38 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
	Transaction tr;
															#line 38 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
	TenantGroupName begin;
															#line 38 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
	TenantGroupName end;
															#line 38 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
	int limit;
															#line 211 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenantGroups.actor.g.h"
};
// This generated class is to be used only via listTenantGroupsTransaction()
															#line 38 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
template <class Transaction>
															#line 38 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
class ListTenantGroupsTransactionActor final : public Actor<std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>>>, public ActorCallback< ListTenantGroupsTransactionActor<Transaction>, 0, KeyBackedRangeResult<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> >, public FastAllocated<ListTenantGroupsTransactionActor<Transaction>>, public ListTenantGroupsTransactionActorState<Transaction, ListTenantGroupsTransactionActor<Transaction>> {
															#line 218 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenantGroups.actor.g.h"
public:
	using FastAllocated<ListTenantGroupsTransactionActor<Transaction>>::operator new;
	using FastAllocated<ListTenantGroupsTransactionActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14937167970762003456UL, 12305613637356064768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListTenantGroupsTransactionActor<Transaction>, 0, KeyBackedRangeResult<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> >;
															#line 38 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
	ListTenantGroupsTransactionActor(Transaction const& tr,TenantGroupName const& begin,TenantGroupName const& end,int const& limit) 
															#line 235 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenantGroups.actor.g.h"
		 : Actor<std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>>>(),
		   ListTenantGroupsTransactionActorState<Transaction, ListTenantGroupsTransactionActor<Transaction>>(tr, begin, end, limit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listTenantGroupsTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8927590815170552320UL, 3409258469446972928UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupsTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listTenantGroupsTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listTenantGroupsTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListTenantGroupsTransactionActor<Transaction>, 0, KeyBackedRangeResult<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 38 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
template <class Transaction>
															#line 38 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
[[nodiscard]] Future<std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>>> listTenantGroupsTransaction( Transaction const& tr, TenantGroupName const& begin, TenantGroupName const& end, int const& limit ) {
															#line 38 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
	return Future<std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>>>(new ListTenantGroupsTransactionActor<Transaction>(tr, begin, end, limit));
															#line 269 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenantGroups.actor.g.h"
}

#line 49 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"

															#line 274 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenantGroups.actor.g.h"
// This generated class is to be used only via listTenantGroups()
															#line 50 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
template <class DB, class ListTenantGroupsActor>
															#line 50 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
class ListTenantGroupsActorState {
															#line 280 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenantGroups.actor.g.h"
public:
															#line 50 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
	ListTenantGroupsActorState(Reference<DB> const& db,TenantGroupName const& begin,TenantGroupName const& end,int const& limit) 
															#line 50 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
															#line 50 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
		 : db(db),
															#line 50 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
		   begin(begin),
															#line 50 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
		   end(end),
															#line 50 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
		   limit(limit),
															#line 55 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
		   tr(db->createTransaction())
															#line 295 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenantGroups.actor.g.h"
	{
		fdb_probe_actor_create("listTenantGroups", reinterpret_cast<unsigned long>(this));

	}
	~ListTenantGroupsActorState() 
	{
		fdb_probe_actor_destroy("listTenantGroups", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 57 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
			;
															#line 310 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenantGroups.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListTenantGroupsActorState();
		static_cast<ListTenantGroupsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 59 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 60 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
			tr->setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 61 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
			StrictFuture<std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>>> __when_expr_0 = listTenantGroupsTransaction(tr, begin, end, limit);
															#line 61 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
			if (static_cast<ListTenantGroupsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 347 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenantGroups.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ListTenantGroupsActor*>(this)->actor_wait_state = 1;
															#line 61 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListTenantGroupsActor, 0, std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> >*>(static_cast<ListTenantGroupsActor*>(this)));
															#line 352 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenantGroups.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 65 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 65 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
			if (static_cast<ListTenantGroupsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 376 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenantGroups.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ListTenantGroupsActor*>(this)->actor_wait_state = 2;
															#line 65 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListTenantGroupsActor, 1, Void >*>(static_cast<ListTenantGroupsActor*>(this)));
															#line 381 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenantGroups.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> const& tenantGroups,int loopDepth) 
	{
															#line 63 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
		if (!static_cast<ListTenantGroupsActor*>(this)->SAV<std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>>>::futures) { (void)(tenantGroups); this->~ListTenantGroupsActorState(); static_cast<ListTenantGroupsActor*>(this)->destroy(); return 0; }
															#line 396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenantGroups.actor.g.h"
		new (&static_cast<ListTenantGroupsActor*>(this)->SAV< std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> >::value()) std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>>(tenantGroups);
		this->~ListTenantGroupsActorState();
		static_cast<ListTenantGroupsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> && tenantGroups,int loopDepth) 
	{
															#line 63 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
		if (!static_cast<ListTenantGroupsActor*>(this)->SAV<std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>>>::futures) { (void)(tenantGroups); this->~ListTenantGroupsActorState(); static_cast<ListTenantGroupsActor*>(this)->destroy(); return 0; }
															#line 408 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenantGroups.actor.g.h"
		new (&static_cast<ListTenantGroupsActor*>(this)->SAV< std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> >::value()) std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>>(tenantGroups);
		this->~ListTenantGroupsActorState();
		static_cast<ListTenantGroupsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> const& tenantGroups,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(tenantGroups, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> && tenantGroups,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(tenantGroups), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListTenantGroupsActor*>(this)->actor_wait_state > 0) static_cast<ListTenantGroupsActor*>(this)->actor_wait_state = 0;
		static_cast<ListTenantGroupsActor*>(this)->ActorCallback< ListTenantGroupsActor, 0, std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< ListTenantGroupsActor, 0, std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> >*,std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> const& value) 
	{
		fdb_probe_actor_enter("listTenantGroups", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantGroups", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListTenantGroupsActor, 0, std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> >*,std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> && value) 
	{
		fdb_probe_actor_enter("listTenantGroups", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantGroups", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListTenantGroupsActor, 0, std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("listTenantGroups", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantGroups", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ListTenantGroupsActor*>(this)->actor_wait_state > 0) static_cast<ListTenantGroupsActor*>(this)->actor_wait_state = 0;
		static_cast<ListTenantGroupsActor*>(this)->ActorCallback< ListTenantGroupsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ListTenantGroupsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("listTenantGroups", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantGroups", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ListTenantGroupsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("listTenantGroups", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantGroups", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ListTenantGroupsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("listTenantGroups", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantGroups", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 50 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
	Reference<DB> db;
															#line 50 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
	TenantGroupName begin;
															#line 50 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
	TenantGroupName end;
															#line 50 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
	int limit;
															#line 55 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 588 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenantGroups.actor.g.h"
};
// This generated class is to be used only via listTenantGroups()
															#line 50 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
template <class DB>
															#line 50 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
class ListTenantGroupsActor final : public Actor<std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>>>, public ActorCallback< ListTenantGroupsActor<DB>, 0, std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> >, public ActorCallback< ListTenantGroupsActor<DB>, 1, Void >, public FastAllocated<ListTenantGroupsActor<DB>>, public ListTenantGroupsActorState<DB, ListTenantGroupsActor<DB>> {
															#line 595 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenantGroups.actor.g.h"
public:
	using FastAllocated<ListTenantGroupsActor<DB>>::operator new;
	using FastAllocated<ListTenantGroupsActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(299595774812004096UL, 8824383536823819520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListTenantGroupsActor<DB>, 0, std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> >;
friend struct ActorCallback< ListTenantGroupsActor<DB>, 1, Void >;
															#line 50 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
	ListTenantGroupsActor(Reference<DB> const& db,TenantGroupName const& begin,TenantGroupName const& end,int const& limit) 
															#line 613 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenantGroups.actor.g.h"
		 : Actor<std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>>>(),
		   ListTenantGroupsActorState<DB, ListTenantGroupsActor<DB>>(db, begin, end, limit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listTenantGroups", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3210088546958859520UL, 16625951499276179968UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listTenantGroups");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listTenantGroups", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListTenantGroupsActor<DB>, 0, std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ListTenantGroupsActor<DB>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 50 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
template <class DB>
															#line 50 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
[[nodiscard]] Future<std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>>> listTenantGroups( Reference<DB> const& db, TenantGroupName const& begin, TenantGroupName const& end, int const& limit ) {
															#line 50 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"
	return Future<std::vector<std::pair<TenantGroupName, MetaclusterTenantGroupEntry>>>(new ListTenantGroupsActor<DB>(db, begin, end, limit));
															#line 648 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenantGroups.actor.g.h"
}

#line 69 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenantGroups.actor.h"

} // namespace metacluster

#include "flow/unactorcompiler.h"
#endif