#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
/*
 * RestoreValidation.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// RestoreValidationWorkload triggers and monitors a ValidateRestore audit to verify that
// backup/restore operations correctly restored all data.
//
// This workload is designed to work with BackupAndRestoreValidation workload:
// 1. BackupAndRestoreValidation performs backup and restore with a prefix (e.g., \xff\x02/rlog/)
// 2. BackupAndRestoreValidation sets a completion marker when fully done
// 3. RestoreValidationWorkload waits for the completion marker
// 4. RestoreValidationWorkload triggers a ValidateRestore audit via the audit_storage API
// 5. The audit compares source keys (normalKeys) with restored keys (prefix + normalKeys)
// 6. RestoreValidationWorkload monitors audit progress and reports success/failure
//
// The workload includes:
// - Synchronization: Waits for restore completion marker to avoid racing with restore
// - Retry logic: Retries audit scheduling on transient failures (up to 5 times)
// - Timeout handling: 60s timeout on audit scheduling to detect cluster recovery issues
// - Progress monitoring: Polls audit status every checkInterval seconds
// - Error detection: Fails the test if audit finds missing or mismatched keys

#include "fdbclient/Audit.h"
#include "fdbclient/AuditUtils.actor.h"
#include "fdbclient/ClusterConnectionFile.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct RestoreValidationWorkload : TestWorkload {
	static constexpr auto NAME = "RestoreValidation";

	double validateAfter;
	KeyRange validationRange;
	int expectedPhase; // Expected AuditPhase (2 = Complete)
	bool expectSuccess;
	double checkInterval;
	double maxWaitTime;

	RestoreValidationWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		validateAfter = getOption(options, "validateAfter"_sr, 50.0);
		validationRange = normalKeys;
		expectedPhase = getOption(options, "expectedPhase"_sr, (int)AuditPhase::Complete);
		expectSuccess = getOption(options, "expectSuccess"_sr, true);
		checkInterval = getOption(options, "checkInterval"_sr, 5.0);
		maxWaitTime = getOption(options, "maxWaitTime"_sr, 300.0);

		TraceEvent("RestoreValidationWorkloadInit")
		    .detail("ValidateAfter", validateAfter)
		    .detail("ExpectedPhase", expectedPhase)
		    .detail("ExpectSuccess", expectSuccess)
		    .detail("MaxWaitTime", maxWaitTime);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		if (clientId == 0) {
			return _start(this, cx);
		}
		return Void();
	}

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 87 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 85 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
template <class _startActor>
															#line 85 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
class _startActorState {
															#line 93 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
public:
															#line 85 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
	_startActorState(RestoreValidationWorkload* const& self,Database const& cx) 
															#line 85 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
															#line 85 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		 : self(self),
															#line 85 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		   cx(cx)
															#line 102 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 87 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			if (self->clientId != 0)
															#line 117 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			{
															#line 88 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 121 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
				new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~_startActorState();
				static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 92 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			TraceEvent("RestoreValidationWorkloadWaiting").detail("WaitTime", self->validateAfter);
															#line 93 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(self->validateAfter);
															#line 93 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 133 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 93 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 138 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 97 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		completionMarker = "\xff\x02/restoreValidationComplete"_sr;
															#line 98 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		restoreComplete = false;
															#line 99 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		checkAttempts = 0;
															#line 101 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		TraceEvent("RestoreValidationWaitingForRestoreCompletion") .detail("CompletionMarker", printable(completionMarker));
															#line 104 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		;
															#line 169 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 97 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		completionMarker = "\xff\x02/restoreValidationComplete"_sr;
															#line 98 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		restoreComplete = false;
															#line 99 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		checkAttempts = 0;
															#line 101 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		TraceEvent("RestoreValidationWaitingForRestoreCompletion") .detail("CompletionMarker", printable(completionMarker));
															#line 104 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		;
															#line 186 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 147 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		TraceEvent("RestoreValidationWorkloadStarting").detail("Range", self->validationRange);
															#line 149 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		auditRetryCount = 0;
															#line 150 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		maxAuditRetries = 5;
															#line 152 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		;
															#line 276 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 106 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			tr = Transaction(cx);
															#line 107 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 108 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 110 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr.get(completionMarker);
															#line 110 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 301 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 110 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Optional<Value> >*>(static_cast<_startActor*>(this)));
															#line 306 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 127 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 341 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			{
															#line 128 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 345 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			}
															#line 131 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			if (e.code() == error_code_grv_proxy_memory_limit_exceeded || e.code() == error_code_commit_proxy_memory_limit_exceeded || e.code() == error_code_database_locked || e.code() == error_code_transaction_too_old || e.code() == error_code_future_version || e.code() == error_code_audit_storage_failed || e.code() == error_code_tag_throttled)
															#line 349 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			{
															#line 136 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				TraceEvent(SevWarn, "RestoreValidationRetryableError") .error(e) .detail("CheckAttempts", checkAttempts);
															#line 139 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				StrictFuture<Void> __when_expr_3 = delay(1.0);
															#line 139 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 357 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 139 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 362 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 142 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 369 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Optional<Value> const& markerValue,int loopDepth) 
	{
															#line 111 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		if (markerValue.present())
															#line 384 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		{
															#line 112 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			restoreComplete = true;
															#line 113 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			TraceEvent("RestoreValidationRestoreComplete").detail("CheckAttempts", checkAttempts);
															#line 390 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 117 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		checkAttempts++;
															#line 120 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		if (checkAttempts % 12 == 0)
															#line 397 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		{
															#line 121 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			TraceEvent("RestoreValidationStillWaitingForRestore") .detail("CheckAttempts", checkAttempts) .detail("WaitTimeSeconds", checkAttempts * 5);
															#line 401 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		}
															#line 125 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(5.0);
															#line 125 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 407 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 125 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 412 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Optional<Value> && markerValue,int loopDepth) 
	{
															#line 111 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		if (markerValue.present())
															#line 421 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		{
															#line 112 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			restoreComplete = true;
															#line 113 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			TraceEvent("RestoreValidationRestoreComplete").detail("CheckAttempts", checkAttempts);
															#line 427 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 117 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		checkAttempts++;
															#line 120 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		if (checkAttempts % 12 == 0)
															#line 434 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		{
															#line 121 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			TraceEvent("RestoreValidationStillWaitingForRestore") .detail("CheckAttempts", checkAttempts) .detail("WaitTimeSeconds", checkAttempts * 5);
															#line 438 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		}
															#line 125 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(5.0);
															#line 125 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 444 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 125 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 449 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Value> const& markerValue,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(markerValue, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Value> && markerValue,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(markerValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 342 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 726 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
		try {
															#line 155 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			auditType = AuditType::ValidateRestore;
															#line 156 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			clusterFile = cx->getConnectionRecord();
															#line 158 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			TraceEvent("RestoreValidationTriggeringAudit") .detail("AuditType", (int)auditType) .detail("Range", self->validationRange) .detail("RetryCount", auditRetryCount);
															#line 165 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			auditId = UID();
															#line 752 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			try {
															#line 167 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				StrictFuture<UID> __when_expr_4 = timeoutError( auditStorage( clusterFile, self->validationRange, auditType, KeyValueStoreType::END, self->maxWaitTime), 60.0);
															#line 167 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch2(actor_cancelled(), loopDepth);
															#line 758 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont3loopBody1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont3loopBody1when1(__when_expr_4.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 167 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, UID >*>(static_cast<_startActor*>(this)));
															#line 763 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont3loopBody1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont3loopBody1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 319 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 804 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			{
															#line 320 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 808 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			}
															#line 323 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			if (e.code() == error_code_audit_storage_failed && auditRetryCount < maxAuditRetries)
															#line 812 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			{
															#line 324 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				auditRetryCount++;
															#line 325 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				double backoff = std::min(10.0, 2.0 * auditRetryCount);
															#line 326 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				TraceEvent(SevWarn, "RestoreValidationAuditRetry") .error(e) .detail("RetryCount", auditRetryCount) .detail("MaxRetries", maxAuditRetries) .detail("BackoffSeconds", backoff);
															#line 331 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				StrictFuture<Void> __when_expr_7 = delay(backoff);
															#line 331 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 824 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
				if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1Catch1when1(__when_expr_7.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 331 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 829 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 334 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				TraceEvent(SevError, "RestoreValidationError") .errorUnsuppressed(e) .detail("RetryCount", auditRetryCount);
															#line 337 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 838 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2(int loopDepth) 
	{
															#line 187 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		TraceEvent("RestoreValidationAuditScheduled") .detail("AuditID", auditId) .detail("RetryCount", auditRetryCount);
															#line 192 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		startTime = now();
															#line 193 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		lastReportTime = startTime;
															#line 194 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		completed = false;
															#line 195 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		finalPhase = AuditPhase::Invalid;
															#line 196 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		errorMessage = std::string();
															#line 198 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		;
															#line 865 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 173 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 875 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			{
															#line 174 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				TraceEvent(SevWarn, "RestoreValidationAuditScheduleTimeout") .detail("RetryCount", auditRetryCount) .detail("MaxRetries", maxAuditRetries);
															#line 178 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				if (auditRetryCount < maxAuditRetries)
															#line 881 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
				{
															#line 179 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
					return a_body1cont3loopBody1Catch1(audit_storage_failed(), loopDepth);
															#line 885 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
				}
				else
				{
															#line 181 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
					return a_body1cont3loopBody1Catch1(e, loopDepth);
															#line 891 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
				}
			}
															#line 184 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			return a_body1cont3loopBody1Catch1(e, loopDepth);
															#line 896 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3(UID const& scheduleResult,int loopDepth) 
	{
															#line 171 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		auditId = scheduleResult;
															#line 910 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3(UID && scheduleResult,int loopDepth) 
	{
															#line 171 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		auditId = scheduleResult;
															#line 919 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(UID const& scheduleResult,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(scheduleResult, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(UID && scheduleResult,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(std::move(scheduleResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, UID >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, UID >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont3loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont6(int loopDepth) 
	{
															#line 283 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		TraceEvent("RestoreValidationComplete") .detail("AuditID", auditId) .detail("FinalPhase", (int)finalPhase) .detail("ExpectedPhase", self->expectedPhase) .detail("ErrorMessage", errorMessage) .detail("ElapsedTime", now() - startTime);
															#line 290 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		if (self->expectSuccess)
															#line 1018 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		{
															#line 291 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			if (finalPhase != AuditPhase::Complete)
															#line 1022 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			{
															#line 293 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				TraceEvent(SevWarn, "RestoreValidationUnexpectedPhase") .detail("AuditID", auditId) .detail("FinalPhase", (int)finalPhase) .detail("ExpectedPhase", self->expectedPhase) .detail("ErrorMessage", errorMessage);
															#line 298 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				return a_body1cont3loopBody1Catch1(audit_storage_failed(), loopDepth);
															#line 1028 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			}
															#line 300 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			if (!errorMessage.empty())
															#line 1032 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			{
															#line 301 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				TraceEvent(SevError, "RestoreValidationUnexpectedError") .detail("AuditID", auditId) .detail("ErrorMessage", errorMessage);
															#line 304 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				return a_body1cont3loopBody1Catch1(audit_storage_error(), loopDepth);
															#line 1038 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			}
		}
		else
		{
															#line 307 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			if (finalPhase == AuditPhase::Complete)
															#line 1045 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			{
															#line 308 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				TraceEvent(SevError, "RestoreValidationUnexpectedSuccess") .detail("AuditID", auditId) .detail("ExpectedPhase", self->expectedPhase);
															#line 311 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				return a_body1cont3loopBody1Catch1(audit_storage_task_outdated(), loopDepth);
															#line 1051 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			}
		}
															#line 315 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		TraceEvent("RestoreValidationSuccess").detail("AuditID", auditId);
															#line 1056 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 199 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		StrictFuture<Void> __when_expr_5 = delay(self->checkInterval);
															#line 199 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1074 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont3loopBody1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont2loopBody1when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 199 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 1079 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 203 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		auditStates = std::vector<AuditStorageState>();
															#line 1101 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		try {
															#line 205 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			StrictFuture<std::vector<AuditStorageState>> __when_expr_6 = timeoutError(getAuditStates(cx, auditType, true), 60.0);
															#line 205 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1cont2loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1107 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont3loopBody1cont2loopBody1cont1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont3loopBody1cont2loopBody1cont1when1(__when_expr_6.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 205 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, std::vector<AuditStorageState> >*>(static_cast<_startActor*>(this)));
															#line 1112 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1cont2loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3loopBody1cont2loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 203 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		auditStates = std::vector<AuditStorageState>();
															#line 1127 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		try {
															#line 205 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			StrictFuture<std::vector<AuditStorageState>> __when_expr_6 = timeoutError(getAuditStates(cx, auditType, true), 60.0);
															#line 205 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1cont2loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1133 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont3loopBody1cont2loopBody1cont1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont3loopBody1cont2loopBody1cont1when1(__when_expr_6.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 205 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, std::vector<AuditStorageState> >*>(static_cast<_startActor*>(this)));
															#line 1138 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1cont2loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3loopBody1cont2loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont3loopBody1cont2loopBody1cont2(int loopDepth) 
	{
															#line 225 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		foundOurAudit = false;
															#line 226 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		allComplete = true;
															#line 227 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		anyError = false;
															#line 229 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		for( const auto& auditState : auditStates ) {
															#line 230 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			if (auditState.id == auditId)
															#line 1236 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			{
															#line 231 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				foundOurAudit = true;
															#line 233 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				if (auditState.getPhase() == AuditPhase::Running)
															#line 1242 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
				{
															#line 234 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
					allComplete = false;
															#line 1246 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
				}
				else
				{
															#line 235 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
					if (auditState.getPhase() == AuditPhase::Error || auditState.getPhase() == AuditPhase::Failed)
															#line 1252 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
					{
															#line 237 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
						anyError = true;
															#line 238 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
						finalPhase = auditState.getPhase();
															#line 239 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
						if (!auditState.error.empty())
															#line 1260 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
						{
															#line 240 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
							errorMessage = auditState.error;
															#line 1264 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
						}
						else
						{
															#line 242 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
							errorMessage = "Unknown error";
															#line 1270 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
						}
					}
					else
					{
															#line 244 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
						if (auditState.getPhase() == AuditPhase::Complete)
															#line 1277 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
						{
															#line 245 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
							finalPhase = AuditPhase::Complete;
															#line 1281 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
						}
					}
				}
			}
		}
															#line 250 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		if (!foundOurAudit)
															#line 1289 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		{
															#line 251 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			TraceEvent(SevWarn, "RestoreValidationNoAuditStates") .detail("AuditID", auditId) .detail("ElapsedTime", now() - startTime);
															#line 1293 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		}
		else
		{
															#line 256 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			if (now() - lastReportTime >= 10.0)
															#line 1299 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			{
															#line 257 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				TraceEvent("RestoreValidationProgress") .detail("AuditID", auditId) .detail("AllComplete", allComplete) .detail("AnyError", anyError) .detail("FinalPhase", (int)finalPhase) .detail("ElapsedTime", now() - startTime);
															#line 263 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				lastReportTime = now();
															#line 1305 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			}
															#line 266 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			if (allComplete || anyError)
															#line 1309 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			{
															#line 267 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				completed = true;
															#line 1313 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
				return a_body1cont3loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
			}
		}
															#line 273 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		if (now() - startTime > self->maxWaitTime)
															#line 1319 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		{
															#line 274 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			TraceEvent(SevError, "RestoreValidationTimeout") .detail("AuditID", auditId) .detail("ElapsedTime", now() - startTime) .detail("MaxWaitTime", self->maxWaitTime);
															#line 278 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			return a_body1cont3loopBody1Catch1(timed_out(), std::max(0, loopDepth - 1));
															#line 1325 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1cont3loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 209 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 1336 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
			{
															#line 211 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
				if (now() - startTime > self->maxWaitTime)
															#line 1340 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
				{
															#line 212 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
					TraceEvent(SevError, "RestoreValidationTimeout") .detail("AuditID", auditId) .detail("ElapsedTime", now() - startTime) .detail("MaxWaitTime", self->maxWaitTime) .detail("Reason", "getAuditStates timed out");
															#line 217 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
					return a_body1cont3loopBody1Catch1(timed_out(), std::max(0, loopDepth - 1));
															#line 1346 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
				}
				return a_body1cont3loopBody1cont2loopHead1(loopDepth); // continue
			}
															#line 221 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
			return a_body1cont3loopBody1Catch1(e, std::max(0, loopDepth - 1));
															#line 1352 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont3loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2loopBody1cont3(std::vector<AuditStorageState> const& states,int loopDepth) 
	{
															#line 207 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		auditStates = states;
															#line 1366 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont2loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2loopBody1cont3(std::vector<AuditStorageState> && states,int loopDepth) 
	{
															#line 207 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
		auditStates = states;
															#line 1375 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont2loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2loopBody1cont1when1(std::vector<AuditStorageState> const& states,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont2loopBody1cont3(states, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2loopBody1cont1when1(std::vector<AuditStorageState> && states,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont2loopBody1cont3(std::move(states), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, std::vector<AuditStorageState> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3loopBody1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1cont2loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1cont2loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3loopBody1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1cont2loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1cont2loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, std::vector<AuditStorageState> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3loopBody1cont2loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1cont2loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1cont2loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont3loopBody1cont2loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3loopBody1cont2loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont3loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont3loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont3loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 85 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
	RestoreValidationWorkload* self;
															#line 85 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
	Database cx;
															#line 97 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
	Key completionMarker;
															#line 98 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
	bool restoreComplete;
															#line 99 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
	int checkAttempts;
															#line 106 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
	Transaction tr;
															#line 149 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
	int auditRetryCount;
															#line 150 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
	int maxAuditRetries;
															#line 155 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
	AuditType auditType;
															#line 156 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
	Reference<IClusterConnectionRecord> clusterFile;
															#line 165 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
	UID auditId;
															#line 192 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
	double startTime;
															#line 193 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
	double lastReportTime;
															#line 194 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
	bool completed;
															#line 195 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
	AuditPhase finalPhase;
															#line 196 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
	std::string errorMessage;
															#line 203 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
	std::vector<AuditStorageState> auditStates;
															#line 225 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
	bool foundOurAudit;
															#line 226 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
	bool allComplete;
															#line 227 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
	bool anyError;
															#line 1601 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 85 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Optional<Value> >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, UID >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, std::vector<AuditStorageState> >, public ActorCallback< _startActor, 7, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1606 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9235378086476401664UL, 342479379298553600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Optional<Value> >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, UID >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, std::vector<AuditStorageState> >;
friend struct ActorCallback< _startActor, 7, Void >;
															#line 85 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
	_startActor(RestoreValidationWorkload* const& self,Database const& cx) 
															#line 1630 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, UID >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, std::vector<AuditStorageState> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 85 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
[[nodiscard]] static Future<Void> _start( RestoreValidationWorkload* const& self, Database const& cx ) {
															#line 85 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 1669 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreValidation.actor.g.cpp"
}

#line 344 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreValidation.actor.cpp"
};

WorkloadFactory<RestoreValidationWorkload> RestoreValidationWorkloadFactory;
