#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
/*
 * PubSubMultiples.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/pubsub.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct PubSubMultiplesWorkload : TestWorkload {
	static constexpr auto NAME = "PubSubMultiples";

	double testDuration, messagesPerSecond;
	int actorCount, inboxesPerActor;

	std::vector<Future<Void>> inboxWatchers;
	PerfIntCounter messages;

	PubSubMultiplesWorkload(WorkloadContext const& wcx) : TestWorkload(wcx), messages("Messages") {
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		messagesPerSecond = getOption(options, "messagesPerSecond"_sr, 500.0) / clientCount;
		actorCount = getOption(options, "actorsPerClient"_sr, 20);
		inboxesPerActor = getOption(options, "inboxesPerActor"_sr, 20);
	}

	Future<Void> setup(Database const& cx) override { return createNodes(this, cx); }
	Future<Void> start(Database const& cx) override {
		Future<Void> _ = startTests(this, cx);
		return delay(testDuration);
	}
	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override { m.push_back(messages.getMetric()); }

	Key keyForFeed(int i) { return StringRef(format("/PSM/feeds/%d", i)); }
	Key keyForInbox(int i) { return StringRef(format("/PSM/inbox/%d", i)); }
	Value valueForUInt(uint64_t i) { return StringRef(format("%llx", i)); }

																#line 58 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
// This generated class is to be used only via createNodeSwath()
															#line 56 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
template <class CreateNodeSwathActor>
															#line 56 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
class CreateNodeSwathActorState {
															#line 64 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
public:
															#line 56 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
	CreateNodeSwathActorState(PubSubMultiplesWorkload* const& self,int const& actor,Database const& cx) 
															#line 56 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
															#line 56 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		 : self(self),
															#line 56 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		   actor(actor),
															#line 56 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		   cx(cx),
															#line 57 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		   ps(cx),
															#line 58 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		   feeds(),
															#line 59 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		   inboxes(),
															#line 60 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		   idx()
															#line 83 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
	{
		fdb_probe_actor_create("createNodeSwath", reinterpret_cast<unsigned long>(this));

	}
	~CreateNodeSwathActorState() 
	{
		fdb_probe_actor_destroy("createNodeSwath", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 61 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
			idx = 0;
															#line 98 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CreateNodeSwathActorState();
		static_cast<CreateNodeSwathActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 67 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		tr = Transaction(cx);
															#line 68 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		;
															#line 123 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 61 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		if (!(idx < self->inboxesPerActor))
															#line 139 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 62 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		StrictFuture<uint64_t> __when_expr_0 = ps.createFeed(StringRef());
															#line 62 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		if (static_cast<CreateNodeSwathActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 147 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CreateNodeSwathActor*>(this)->actor_wait_state = 1;
															#line 62 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CreateNodeSwathActor, 0, uint64_t >*>(static_cast<CreateNodeSwathActor*>(this)));
															#line 152 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(uint64_t const& feedIdx,int loopDepth) 
	{
															#line 63 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		feeds.push_back(feedIdx);
															#line 64 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		StrictFuture<uint64_t> __when_expr_1 = ps.createInbox(StringRef());
															#line 64 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		if (static_cast<CreateNodeSwathActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 178 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CreateNodeSwathActor*>(this)->actor_wait_state = 2;
															#line 64 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateNodeSwathActor, 1, uint64_t >*>(static_cast<CreateNodeSwathActor*>(this)));
															#line 183 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(uint64_t && feedIdx,int loopDepth) 
	{
															#line 63 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		feeds.push_back(feedIdx);
															#line 64 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		StrictFuture<uint64_t> __when_expr_1 = ps.createInbox(StringRef());
															#line 64 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		if (static_cast<CreateNodeSwathActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 196 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CreateNodeSwathActor*>(this)->actor_wait_state = 2;
															#line 64 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateNodeSwathActor, 1, uint64_t >*>(static_cast<CreateNodeSwathActor*>(this)));
															#line 201 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(uint64_t const& feedIdx,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(feedIdx, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(uint64_t && feedIdx,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(feedIdx), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CreateNodeSwathActor*>(this)->actor_wait_state > 0) static_cast<CreateNodeSwathActor*>(this)->actor_wait_state = 0;
		static_cast<CreateNodeSwathActor*>(this)->ActorCallback< CreateNodeSwathActor, 0, uint64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CreateNodeSwathActor, 0, uint64_t >*,uint64_t const& value) 
	{
		fdb_probe_actor_enter("createNodeSwath", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNodeSwathActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createNodeSwath", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CreateNodeSwathActor, 0, uint64_t >*,uint64_t && value) 
	{
		fdb_probe_actor_enter("createNodeSwath", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNodeSwathActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createNodeSwath", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CreateNodeSwathActor, 0, uint64_t >*,Error err) 
	{
		fdb_probe_actor_enter("createNodeSwath", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNodeSwathActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createNodeSwath", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(uint64_t const& inboxIdx,int loopDepth) 
	{
															#line 65 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		inboxes.push_back(inboxIdx);
															#line 61 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		idx++;
															#line 287 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(uint64_t && inboxIdx,int loopDepth) 
	{
															#line 65 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		inboxes.push_back(inboxIdx);
															#line 61 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		idx++;
															#line 298 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(uint64_t const& inboxIdx,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(inboxIdx, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(uint64_t && inboxIdx,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(inboxIdx), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CreateNodeSwathActor*>(this)->actor_wait_state > 0) static_cast<CreateNodeSwathActor*>(this)->actor_wait_state = 0;
		static_cast<CreateNodeSwathActor*>(this)->ActorCallback< CreateNodeSwathActor, 1, uint64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CreateNodeSwathActor, 1, uint64_t >*,uint64_t const& value) 
	{
		fdb_probe_actor_enter("createNodeSwath", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNodeSwathActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createNodeSwath", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CreateNodeSwathActor, 1, uint64_t >*,uint64_t && value) 
	{
		fdb_probe_actor_enter("createNodeSwath", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNodeSwathActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createNodeSwath", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CreateNodeSwathActor, 1, uint64_t >*,Error err) 
	{
		fdb_probe_actor_enter("createNodeSwath", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNodeSwathActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createNodeSwath", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 82 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		if (!static_cast<CreateNodeSwathActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateNodeSwathActorState(); static_cast<CreateNodeSwathActor*>(this)->destroy(); return 0; }
															#line 382 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
		new (&static_cast<CreateNodeSwathActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateNodeSwathActorState();
		static_cast<CreateNodeSwathActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 70 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
			for(int idx = 0;idx < self->inboxesPerActor;idx++) {
															#line 71 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
				int offset = (self->clientId * self->clientCount * self->actorCount * self->inboxesPerActor) + (actor * self->actorCount * self->inboxesPerActor) + idx;
															#line 73 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
				tr.set(self->keyForFeed(offset), self->valueForUInt(feeds[idx]));
															#line 74 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
				tr.set(self->keyForInbox(offset), self->valueForUInt(inboxes[idx]));
															#line 408 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
			}
															#line 76 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 76 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
			if (static_cast<CreateNodeSwathActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 414 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CreateNodeSwathActor*>(this)->actor_wait_state = 3;
															#line 76 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateNodeSwathActor, 2, Void >*>(static_cast<CreateNodeSwathActor*>(this)));
															#line 419 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 79 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 79 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
			if (static_cast<CreateNodeSwathActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 456 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<CreateNodeSwathActor*>(this)->actor_wait_state = 4;
															#line 79 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CreateNodeSwathActor, 3, Void >*>(static_cast<CreateNodeSwathActor*>(this)));
															#line 461 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CreateNodeSwathActor*>(this)->actor_wait_state > 0) static_cast<CreateNodeSwathActor*>(this)->actor_wait_state = 0;
		static_cast<CreateNodeSwathActor*>(this)->ActorCallback< CreateNodeSwathActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateNodeSwathActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createNodeSwath", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNodeSwathActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createNodeSwath", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CreateNodeSwathActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createNodeSwath", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNodeSwathActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createNodeSwath", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CreateNodeSwathActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createNodeSwath", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNodeSwathActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createNodeSwath", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CreateNodeSwathActor*>(this)->actor_wait_state > 0) static_cast<CreateNodeSwathActor*>(this)->actor_wait_state = 0;
		static_cast<CreateNodeSwathActor*>(this)->ActorCallback< CreateNodeSwathActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateNodeSwathActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createNodeSwath", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNodeSwathActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createNodeSwath", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CreateNodeSwathActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createNodeSwath", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNodeSwathActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createNodeSwath", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CreateNodeSwathActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createNodeSwath", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNodeSwathActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createNodeSwath", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 56 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
	PubSubMultiplesWorkload* self;
															#line 56 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
	int actor;
															#line 56 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
	Database cx;
															#line 57 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
	PubSub ps;
															#line 58 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
	std::vector<uint64_t> feeds;
															#line 59 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
	std::vector<uint64_t> inboxes;
															#line 60 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
	int idx;
															#line 67 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
	Transaction tr;
															#line 662 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
};
// This generated class is to be used only via createNodeSwath()
															#line 56 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
class CreateNodeSwathActor final : public Actor<Void>, public ActorCallback< CreateNodeSwathActor, 0, uint64_t >, public ActorCallback< CreateNodeSwathActor, 1, uint64_t >, public ActorCallback< CreateNodeSwathActor, 2, Void >, public ActorCallback< CreateNodeSwathActor, 3, Void >, public FastAllocated<CreateNodeSwathActor>, public CreateNodeSwathActorState<CreateNodeSwathActor> {
															#line 667 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
public:
	using FastAllocated<CreateNodeSwathActor>::operator new;
	using FastAllocated<CreateNodeSwathActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16613824409864078336UL, 3274303321009033984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CreateNodeSwathActor, 0, uint64_t >;
friend struct ActorCallback< CreateNodeSwathActor, 1, uint64_t >;
friend struct ActorCallback< CreateNodeSwathActor, 2, Void >;
friend struct ActorCallback< CreateNodeSwathActor, 3, Void >;
															#line 56 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
	CreateNodeSwathActor(PubSubMultiplesWorkload* const& self,int const& actor,Database const& cx) 
															#line 687 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
		 : Actor<Void>(),
		   CreateNodeSwathActorState<CreateNodeSwathActor>(self, actor, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("createNodeSwath", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6045943999470419968UL, 15074709651986110208UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNodeSwathActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("createNodeSwath");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("createNodeSwath", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CreateNodeSwathActor, 0, uint64_t >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CreateNodeSwathActor, 1, uint64_t >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CreateNodeSwathActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CreateNodeSwathActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 56 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
[[nodiscard]] Future<Void> createNodeSwath( PubSubMultiplesWorkload* const& self, int const& actor, Database const& cx ) {
															#line 56 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
	return Future<Void>(new CreateNodeSwathActor(self, actor, cx));
															#line 722 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
}

#line 84 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"

																#line 727 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
// This generated class is to be used only via createNodes()
															#line 85 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
template <class CreateNodesActor>
															#line 85 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
class CreateNodesActorState {
															#line 733 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
public:
															#line 85 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
	CreateNodesActorState(PubSubMultiplesWorkload* const& self,Database const& cx) 
															#line 85 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
															#line 85 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		 : self(self),
															#line 85 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		   cx(cx),
															#line 86 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		   ps(cx)
															#line 744 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
	{
		fdb_probe_actor_create("createNodes", reinterpret_cast<unsigned long>(this));

	}
	~CreateNodesActorState() 
	{
		fdb_probe_actor_destroy("createNodes", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 87 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
			std::vector<Future<Void>> actors;
															#line 88 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
			actors.reserve(self->actorCount);
															#line 89 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
			for(int i = 0;i < self->actorCount;i++) {
															#line 90 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
				actors.push_back(self->createNodeSwath(self, i, cx->clone()));
															#line 765 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
			}
															#line 91 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(actors);
															#line 91 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
			if (static_cast<CreateNodesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 771 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CreateNodesActor*>(this)->actor_wait_state = 1;
															#line 91 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CreateNodesActor, 0, Void >*>(static_cast<CreateNodesActor*>(this)));
															#line 776 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CreateNodesActorState();
		static_cast<CreateNodesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 92 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		TraceEvent("PSMNodesCreated").detail("ClientIdx", self->clientId);
															#line 93 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		if (!static_cast<CreateNodesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateNodesActorState(); static_cast<CreateNodesActor*>(this)->destroy(); return 0; }
															#line 801 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
		new (&static_cast<CreateNodesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateNodesActorState();
		static_cast<CreateNodesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 92 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		TraceEvent("PSMNodesCreated").detail("ClientIdx", self->clientId);
															#line 93 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		if (!static_cast<CreateNodesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateNodesActorState(); static_cast<CreateNodesActor*>(this)->destroy(); return 0; }
															#line 815 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
		new (&static_cast<CreateNodesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateNodesActorState();
		static_cast<CreateNodesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CreateNodesActor*>(this)->actor_wait_state > 0) static_cast<CreateNodesActor*>(this)->actor_wait_state = 0;
		static_cast<CreateNodesActor*>(this)->ActorCallback< CreateNodesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateNodesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createNodes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNodesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createNodes", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CreateNodesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createNodes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNodesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createNodes", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CreateNodesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createNodes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNodesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createNodes", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 85 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
	PubSubMultiplesWorkload* self;
															#line 85 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
	Database cx;
															#line 86 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
	PubSub ps;
															#line 904 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
};
// This generated class is to be used only via createNodes()
															#line 85 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
class CreateNodesActor final : public Actor<Void>, public ActorCallback< CreateNodesActor, 0, Void >, public FastAllocated<CreateNodesActor>, public CreateNodesActorState<CreateNodesActor> {
															#line 909 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
public:
	using FastAllocated<CreateNodesActor>::operator new;
	using FastAllocated<CreateNodesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8680388033175576320UL, 10681535191140859136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CreateNodesActor, 0, Void >;
															#line 85 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
	CreateNodesActor(PubSubMultiplesWorkload* const& self,Database const& cx) 
															#line 926 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
		 : Actor<Void>(),
		   CreateNodesActorState<CreateNodesActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("createNodes", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11891154053594141952UL, 13979038455813414144UL);
		ActorExecutionContextHelper __helper(static_cast<CreateNodesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("createNodes");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("createNodes", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CreateNodesActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 85 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
[[nodiscard]] Future<Void> createNodes( PubSubMultiplesWorkload* const& self, Database const& cx ) {
															#line 85 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
	return Future<Void>(new CreateNodesActor(self, cx));
															#line 958 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
}

#line 95 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"

	/*ACTOR*/ Future<Void> createSubscriptions(PubSubMultiplesWorkload* self, int actor, Database cx) {
		// create the "multiples" subscriptions for each owned inbox
		return Void();
	}

	/*ACTOR*/ Future<Void> messageSender(PubSubMultiplesWorkload* self, Database cx) {
		// use a possion loop and post messages to feeds
		return Void();
	}

																#line 973 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
// This generated class is to be used only via startTests()
															#line 106 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
template <class StartTestsActor>
															#line 106 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
class StartTestsActorState {
															#line 979 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
public:
															#line 106 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
	StartTestsActorState(PubSubMultiplesWorkload* const& self,Database const& cx) 
															#line 106 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
															#line 106 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		 : self(self),
															#line 106 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		   cx(cx)
															#line 988 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
	{
		fdb_probe_actor_create("startTests", reinterpret_cast<unsigned long>(this));

	}
	~StartTestsActorState() 
	{
		fdb_probe_actor_destroy("startTests", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 107 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
			std::vector<Future<Void>> subscribers;
															#line 108 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
			subscribers.reserve(self->actorCount);
															#line 109 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
			for(int i = 0;i < self->actorCount;i++) {
															#line 110 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
				subscribers.push_back(self->createSubscriptions(self, i, cx));
															#line 1009 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
			}
															#line 111 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(subscribers);
															#line 111 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
			if (static_cast<StartTestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1015 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartTestsActor*>(this)->actor_wait_state = 1;
															#line 111 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartTestsActor, 0, Void >*>(static_cast<StartTestsActor*>(this)));
															#line 1020 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartTestsActorState();
		static_cast<StartTestsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 113 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		sender = self->messageSender(self, cx);
															#line 114 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		if (!static_cast<StartTestsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartTestsActorState(); static_cast<StartTestsActor*>(this)->destroy(); return 0; }
															#line 1045 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
		new (&static_cast<StartTestsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartTestsActorState();
		static_cast<StartTestsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 113 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		sender = self->messageSender(self, cx);
															#line 114 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
		if (!static_cast<StartTestsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartTestsActorState(); static_cast<StartTestsActor*>(this)->destroy(); return 0; }
															#line 1059 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
		new (&static_cast<StartTestsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartTestsActorState();
		static_cast<StartTestsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartTestsActor*>(this)->actor_wait_state > 0) static_cast<StartTestsActor*>(this)->actor_wait_state = 0;
		static_cast<StartTestsActor*>(this)->ActorCallback< StartTestsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartTestsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startTests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartTestsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startTests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartTestsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startTests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTests", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 106 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
	PubSubMultiplesWorkload* self;
															#line 106 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
	Database cx;
															#line 113 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
	Future<Void> sender;
															#line 1148 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
};
// This generated class is to be used only via startTests()
															#line 106 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
class StartTestsActor final : public Actor<Void>, public ActorCallback< StartTestsActor, 0, Void >, public FastAllocated<StartTestsActor>, public StartTestsActorState<StartTestsActor> {
															#line 1153 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
public:
	using FastAllocated<StartTestsActor>::operator new;
	using FastAllocated<StartTestsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6593249920658950656UL, 3414750135078485248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartTestsActor, 0, Void >;
															#line 106 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
	StartTestsActor(PubSubMultiplesWorkload* const& self,Database const& cx) 
															#line 1170 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
		 : Actor<Void>(),
		   StartTestsActorState<StartTestsActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startTests", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(125876027476427520UL, 3740635013011800064UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startTests");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startTests", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartTestsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 106 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
[[nodiscard]] Future<Void> startTests( PubSubMultiplesWorkload* const& self, Database const& cx ) {
															#line 106 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
	return Future<Void>(new StartTestsActor(self, cx));
															#line 1202 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PubSubMultiples.actor.g.cpp"
}

#line 116 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/PubSubMultiples.actor.cpp"
};

WorkloadFactory<PubSubMultiplesWorkload> PubSubMultiplesWorkloadFactory;
