#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
/*
 * GetMappedRange.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <algorithm>
#include "fdbclient/MutationLogReader.actor.h"
#include "fdbclient/StatusClient.h"
#include "fdbclient/Tuple.h"
#include "fdbserver/workloads/ApiWorkload.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/Knobs.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/flow.h"
#include "flow/actorcompiler.h" // This must be the last #include.

const Value EMPTY = Tuple().pack();
ValueRef SOMETHING = "SOMETHING"_sr;
const KeyRef prefix = "prefix"_sr;
const KeyRef RECORD = "RECORD"_sr;
const KeyRef INDEX = "INDEX"_sr;

int recordSize;
int indexSize;
struct GetMappedRangeWorkload : ApiWorkload {
	static constexpr auto NAME = "GetMappedRange";
	bool enabled;
	Snapshot snapshot = Snapshot::False;

	//	const bool BAD_MAPPER = deterministicRandom()->random01() < 0.1;
	const bool BAD_MAPPER = false;
	//	const bool SPLIT_RECORDS = deterministicRandom()->random01() < 0.5;
	const bool SPLIT_RECORDS = true;
	const static int SPLIT_SIZE = 3;
	double checkStorageQueueSeconds;
	uint64_t queueMaxLength;

	GetMappedRangeWorkload(WorkloadContext const& wcx) : ApiWorkload(wcx) {
		enabled = !clientId; // only do this on the "first" client
		checkStorageQueueSeconds = getOption(options, "checkStorageQueueSeconds"_sr, 60.0);
		queueMaxLength = getOption(options, "queueMaxLength"_sr, UINT64_C(100));
	}

	// TODO: Currently this workload doesn't play well with MachineAttrition, but it probably should
	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override { out.insert("Attrition"); }

	Future<Void> start(Database const& cx) override {
		// This workload is generated different from typical ApiWorkload. So don't use ApiWorkload::_start.
		if (enabled) {
			return GetMappedRangeWorkload::_start(cx, this);
		}
		return Void();
	}

																#line 73 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
// This generated class is to be used only via performSetup()
															#line 71 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
template <class PerformSetupActor>
															#line 71 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
class PerformSetupActorState {
															#line 79 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
public:
															#line 71 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	PerformSetupActorState(Database const& cx,GetMappedRangeWorkload* const& self) 
															#line 71 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
															#line 71 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		 : cx(cx),
															#line 71 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   self(self)
															#line 88 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
	{
		fdb_probe_actor_create("performSetup", reinterpret_cast<unsigned long>(this));

	}
	~PerformSetupActorState() 
	{
		fdb_probe_actor_destroy("performSetup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 72 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			std::vector<TransactionType> types;
															#line 73 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			types.push_back(NATIVE);
															#line 74 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			types.push_back(READ_YOUR_WRITES);
															#line 76 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->chooseTransactionFactory(cx, types);
															#line 76 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			if (static_cast<PerformSetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 111 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PerformSetupActor*>(this)->actor_wait_state = 1;
															#line 76 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PerformSetupActor, 0, Void >*>(static_cast<PerformSetupActor*>(this)));
															#line 116 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PerformSetupActorState();
		static_cast<PerformSetupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 77 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (!static_cast<PerformSetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PerformSetupActorState(); static_cast<PerformSetupActor*>(this)->destroy(); return 0; }
															#line 139 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		new (&static_cast<PerformSetupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PerformSetupActorState();
		static_cast<PerformSetupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 77 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (!static_cast<PerformSetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PerformSetupActorState(); static_cast<PerformSetupActor*>(this)->destroy(); return 0; }
															#line 151 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		new (&static_cast<PerformSetupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PerformSetupActorState();
		static_cast<PerformSetupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PerformSetupActor*>(this)->actor_wait_state > 0) static_cast<PerformSetupActor*>(this)->actor_wait_state = 0;
		static_cast<PerformSetupActor*>(this)->ActorCallback< PerformSetupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PerformSetupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("performSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PerformSetupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("performSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PerformSetupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("performSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerformSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performSetup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 71 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	Database cx;
															#line 71 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	GetMappedRangeWorkload* self;
															#line 238 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
};
// This generated class is to be used only via performSetup()
															#line 71 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
class PerformSetupActor final : public Actor<Void>, public ActorCallback< PerformSetupActor, 0, Void >, public FastAllocated<PerformSetupActor>, public PerformSetupActorState<PerformSetupActor> {
															#line 243 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
public:
	using FastAllocated<PerformSetupActor>::operator new;
	using FastAllocated<PerformSetupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8036292194267578368UL, 11965651568564422912UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PerformSetupActor, 0, Void >;
															#line 71 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	PerformSetupActor(Database const& cx,GetMappedRangeWorkload* const& self) 
															#line 260 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		 : Actor<Void>(),
		   PerformSetupActorState<PerformSetupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("performSetup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(908050500225728256UL, 2892666575110672640UL);
		ActorExecutionContextHelper __helper(static_cast<PerformSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("performSetup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("performSetup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PerformSetupActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 71 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
[[nodiscard]] Future<Void> performSetup( Database const& cx, GetMappedRangeWorkload* const& self ) {
															#line 71 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	return Future<Void>(new PerformSetupActor(cx, self));
															#line 292 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
}

#line 79 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"

	Future<Void> performSetup(Database const& cx) override { return performSetup(cx, this); }

	Future<Void> performTest(Database const& cx, Standalone<VectorRef<KeyValueRef>> const& data) override {
		// Ignore this because we are not using ApiWorkload's default ::start.
		return Future<Void>();
	}

	static Key primaryKey(int i) { return Key(format("primary-key-of-record-%08d", i)); }
	static Key indexKey(int i) { return Key(format("index-key-of-record-%08d", i)); }
	static Value dataOfRecord(int i) { return Key(format("data-of-record-%08d", i)); }
	static Value dataOfRecord(int i, int split) { return Key(format("data-of-record-%08d-split-%08d", i, split)); }

	static Key indexEntryKey(int i) { return Tuple::makeTuple(prefix, INDEX, indexKey(i), primaryKey(i)).pack(); }
	static Key recordKey(int i) { return Tuple::makeTuple(prefix, RECORD, primaryKey(i)).pack(); }
	static Key recordKey(int i, int split) { return Tuple::makeTuple(prefix, RECORD, primaryKey(i), split).pack(); }
	static Value recordValue(int i) { return Tuple::makeTuple(dataOfRecord(i)).pack(); }
	static Value recordValue(int i, int split) { return Tuple::makeTuple(dataOfRecord(i, split)).pack(); }

																#line 315 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
// This generated class is to be used only via fillInRecords()
															#line 98 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
template <class FillInRecordsActor>
															#line 98 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
class FillInRecordsActorState {
															#line 321 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
public:
															#line 98 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	FillInRecordsActorState(Database const& cx,int const& n,GetMappedRangeWorkload* const& self) 
															#line 98 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
															#line 98 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		 : cx(cx),
															#line 98 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   n(n),
															#line 98 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   self(self),
															#line 99 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   tr(cx)
															#line 334 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
	{
		fdb_probe_actor_create("fillInRecords", reinterpret_cast<unsigned long>(this));

	}
	~FillInRecordsActorState() 
	{
		fdb_probe_actor_destroy("fillInRecords", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 100 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			;
															#line 349 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FillInRecordsActorState();
		static_cast<FillInRecordsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 135 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (!static_cast<FillInRecordsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FillInRecordsActorState(); static_cast<FillInRecordsActor*>(this)->destroy(); return 0; }
															#line 372 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		new (&static_cast<FillInRecordsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FillInRecordsActorState();
		static_cast<FillInRecordsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 101 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		std::cout << "start fillInRecords n=" << n << std::endl;
															#line 103 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		recordSize = 0;
															#line 104 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		indexSize = 0;
															#line 395 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		try {
															#line 106 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			for(int i = 0;i < n;i++) {
															#line 107 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				if (self->SPLIT_RECORDS)
															#line 401 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
				{
															#line 108 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					for(int split = 0;split < SPLIT_SIZE;split++) {
															#line 109 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
						tr.set(recordKey(i, split), recordValue(i, split));
															#line 110 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
						if (i == 0)
															#line 409 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
						{
															#line 111 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
							recordSize += recordKey(i, split).size() + recordValue(i, split).size() + sizeof(KeyValueRef);
															#line 413 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
						}
					}
				}
				else
				{
															#line 116 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					tr.set(recordKey(i), recordValue(i));
															#line 117 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					if (i == 0)
															#line 423 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
					{
															#line 118 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
						recordSize += recordKey(i).size() + recordValue(i).size() + sizeof(KeyValueRef);
															#line 427 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
					}
				}
															#line 121 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				tr.set(indexEntryKey(i), EMPTY);
															#line 122 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				if (i == 0)
															#line 434 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
				{
															#line 123 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					indexSize += indexEntryKey(i).size() + sizeof(KeyValueRef);
															#line 438 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
				}
			}
															#line 126 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 126 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			if (static_cast<FillInRecordsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 445 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FillInRecordsActor*>(this)->actor_wait_state = 1;
															#line 126 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FillInRecordsActor, 0, Void >*>(static_cast<FillInRecordsActor*>(this)));
															#line 450 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 131 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			std::cout << "failed fillInRecords, retry" << std::endl;
															#line 132 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 132 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			if (static_cast<FillInRecordsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 489 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FillInRecordsActor*>(this)->actor_wait_state = 2;
															#line 132 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FillInRecordsActor, 1, Void >*>(static_cast<FillInRecordsActor*>(this)));
															#line 494 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 127 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		std::cout << "finished fillInRecords with version " << tr.getCommittedVersion() << " recordSize " << recordSize << " indexSize " << indexSize << std::endl;
															#line 509 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 127 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		std::cout << "finished fillInRecords with version " << tr.getCommittedVersion() << " recordSize " << recordSize << " indexSize " << indexSize << std::endl;
															#line 518 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FillInRecordsActor*>(this)->actor_wait_state > 0) static_cast<FillInRecordsActor*>(this)->actor_wait_state = 0;
		static_cast<FillInRecordsActor*>(this)->ActorCallback< FillInRecordsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FillInRecordsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fillInRecords", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillInRecordsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillInRecords", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FillInRecordsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fillInRecords", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillInRecordsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillInRecords", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FillInRecordsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fillInRecords", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FillInRecordsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillInRecords", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FillInRecordsActor*>(this)->actor_wait_state > 0) static_cast<FillInRecordsActor*>(this)->actor_wait_state = 0;
		static_cast<FillInRecordsActor*>(this)->ActorCallback< FillInRecordsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FillInRecordsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fillInRecords", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillInRecordsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillInRecords", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FillInRecordsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fillInRecords", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillInRecordsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillInRecords", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FillInRecordsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fillInRecords", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FillInRecordsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillInRecords", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 98 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	Database cx;
															#line 98 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	int n;
															#line 98 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	GetMappedRangeWorkload* self;
															#line 99 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	Transaction tr;
															#line 693 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
};
// This generated class is to be used only via fillInRecords()
															#line 98 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
class FillInRecordsActor final : public Actor<Void>, public ActorCallback< FillInRecordsActor, 0, Void >, public ActorCallback< FillInRecordsActor, 1, Void >, public FastAllocated<FillInRecordsActor>, public FillInRecordsActorState<FillInRecordsActor> {
															#line 698 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
public:
	using FastAllocated<FillInRecordsActor>::operator new;
	using FastAllocated<FillInRecordsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8865061625822930176UL, 12349458420209032960UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FillInRecordsActor, 0, Void >;
friend struct ActorCallback< FillInRecordsActor, 1, Void >;
															#line 98 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	FillInRecordsActor(Database const& cx,int const& n,GetMappedRangeWorkload* const& self) 
															#line 716 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		 : Actor<Void>(),
		   FillInRecordsActorState<FillInRecordsActor>(cx, n, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fillInRecords", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12278571467296713984UL, 16197504825907931392UL);
		ActorExecutionContextHelper __helper(static_cast<FillInRecordsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fillInRecords");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fillInRecords", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FillInRecordsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FillInRecordsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 98 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
[[nodiscard]] Future<Void> fillInRecords( Database const& cx, int const& n, GetMappedRangeWorkload* const& self ) {
															#line 98 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	return Future<Void>(new FillInRecordsActor(cx, n, self));
															#line 749 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
}

#line 137 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"

	static void showResult(const RangeResult& result) {
		std::cout << "result size: " << result.size() << std::endl;
		for (const KeyValueRef* it = result.begin(); it != result.end(); it++) {
			std::cout << "key=" << it->key.printable() << ", value=" << it->value.printable() << std::endl;
		}
	}

																#line 761 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
// This generated class is to be used only via scanRange()
															#line 145 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
template <class ScanRangeActor>
															#line 145 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
class ScanRangeActorState {
															#line 767 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
public:
															#line 145 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	ScanRangeActorState(Database const& cx,KeyRangeRef const& range) 
															#line 145 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
															#line 145 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		 : cx(cx),
															#line 145 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   range(range)
															#line 776 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
	{
		fdb_probe_actor_create("scanRange", reinterpret_cast<unsigned long>(this));

	}
	~ScanRangeActorState() 
	{
		fdb_probe_actor_destroy("scanRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 146 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			std::cout << "start scanRange " << range.toString() << std::endl;
															#line 148 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			tr = Transaction(cx);
															#line 149 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			;
															#line 795 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ScanRangeActorState();
		static_cast<ScanRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 158 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		std::cout << "finished scanRange" << std::endl;
															#line 159 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (!static_cast<ScanRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ScanRangeActorState(); static_cast<ScanRangeActor*>(this)->destroy(); return 0; }
															#line 820 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		new (&static_cast<ScanRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ScanRangeActorState();
		static_cast<ScanRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 151 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(range, CLIENT_KNOBS->TOO_MANY);
															#line 151 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			if (static_cast<ScanRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 842 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ScanRangeActor*>(this)->actor_wait_state = 1;
															#line 151 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ScanRangeActor, 0, RangeResult >*>(static_cast<ScanRangeActor*>(this)));
															#line 847 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 155 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 155 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			if (static_cast<ScanRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 884 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ScanRangeActor*>(this)->actor_wait_state = 2;
															#line 155 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ScanRangeActor, 1, Void >*>(static_cast<ScanRangeActor*>(this)));
															#line 889 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& result,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && result,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ScanRangeActor*>(this)->actor_wait_state > 0) static_cast<ScanRangeActor*>(this)->actor_wait_state = 0;
		static_cast<ScanRangeActor*>(this)->ActorCallback< ScanRangeActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ScanRangeActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("scanRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ScanRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("scanRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ScanRangeActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("scanRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ScanRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("scanRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ScanRangeActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("scanRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ScanRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("scanRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ScanRangeActor*>(this)->actor_wait_state > 0) static_cast<ScanRangeActor*>(this)->actor_wait_state = 0;
		static_cast<ScanRangeActor*>(this)->ActorCallback< ScanRangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ScanRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("scanRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ScanRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("scanRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ScanRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("scanRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ScanRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("scanRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ScanRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("scanRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ScanRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("scanRange", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 145 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	Database cx;
															#line 145 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	KeyRangeRef range;
															#line 148 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	Transaction tr;
															#line 1080 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
};
// This generated class is to be used only via scanRange()
															#line 145 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
class ScanRangeActor final : public Actor<Void>, public ActorCallback< ScanRangeActor, 0, RangeResult >, public ActorCallback< ScanRangeActor, 1, Void >, public FastAllocated<ScanRangeActor>, public ScanRangeActorState<ScanRangeActor> {
															#line 1085 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
public:
	using FastAllocated<ScanRangeActor>::operator new;
	using FastAllocated<ScanRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16052212781659964928UL, 4492089577110755328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ScanRangeActor, 0, RangeResult >;
friend struct ActorCallback< ScanRangeActor, 1, Void >;
															#line 145 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	ScanRangeActor(Database const& cx,KeyRangeRef const& range) 
															#line 1103 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		 : Actor<Void>(),
		   ScanRangeActorState<ScanRangeActor>(cx, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("scanRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15606390752957707776UL, 3736937229673647872UL);
		ActorExecutionContextHelper __helper(static_cast<ScanRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("scanRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("scanRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ScanRangeActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ScanRangeActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 145 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
[[nodiscard]] Future<Void> scanRange( Database const& cx, KeyRangeRef const& range ) {
															#line 145 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	return Future<Void>(new ScanRangeActor(cx, range));
															#line 1136 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
}

#line 161 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"

	// Return true if need to retry.
	static bool validateRecord(int expectedId,
	                           const MappedKeyValueRef* it,
	                           GetMappedRangeWorkload* self,
	                           bool allMissing) {
		// std::cout << "validateRecord expectedId " << expectedId << " it->key " << printable(it->key)
		//           << " indexEntryKey(expectedId) " << printable(indexEntryKey(expectedId)) << std::endl;

		ASSERT(it->key == indexEntryKey(expectedId));
		ASSERT(it->value == EMPTY);

		if (self->SPLIT_RECORDS) {
			ASSERT(std::holds_alternative<GetRangeReqAndResultRef>(it->reqAndResult));
			auto& getRange = std::get<GetRangeReqAndResultRef>(it->reqAndResult);
			auto& rangeResult = getRange.result;
			//					std::cout << "rangeResult.size()=" << rangeResult.size() << std::endl;
			// In the future, we may be able to do the continuation more efficiently by combining partial results
			// together and then validate.
			if (rangeResult.more) {
				// Retry if the underlying request is not fully completed.
				return true;
			}
			if (!allMissing) {
				ASSERT(rangeResult.size() == SPLIT_SIZE);
				for (int split = 0; split < SPLIT_SIZE; split++) {
					auto& kv = rangeResult[split];
					//				std::cout << "kv.key=" << printable(kv.key)
					//						   << ", recordKey(id, split)=" << printable(recordKey(id, split)) <<
					// std::endl; std::cout << "kv.value=" << printable(kv.value)
					//						   << ", recordValue(id, split)=" << printable(recordValue(id,split)) <<
					// std::endl;
					ASSERT(kv.key == recordKey(expectedId, split));
					ASSERT(kv.value == recordValue(expectedId, split));
				}
			}

		} else {
			ASSERT(std::holds_alternative<GetValueReqAndResultRef>(it->reqAndResult));
			auto& getValue = std::get<GetValueReqAndResultRef>(it->reqAndResult);
			ASSERT(getValue.key == recordKey(expectedId));
			ASSERT(getValue.result.present());
			ASSERT(getValue.result.get() == recordValue(expectedId));
		}
		return false;
	}

																#line 1187 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
// This generated class is to be used only via scanMappedRangeWithLimits()
															#line 208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
template <class ScanMappedRangeWithLimitsActor>
															#line 208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
class ScanMappedRangeWithLimitsActorState {
															#line 1193 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
public:
															#line 208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	ScanMappedRangeWithLimitsActorState(Database const& cx,KeySelector const& beginSelector,KeySelector const& endSelector,Key const& mapper,int const& limit,int const& byteLimit,int const& expectedBeginId,GetMappedRangeWorkload* const& self,bool const& allMissing) 
															#line 208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
															#line 208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		 : cx(cx),
															#line 208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   beginSelector(beginSelector),
															#line 208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   endSelector(endSelector),
															#line 208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   mapper(mapper),
															#line 208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   limit(limit),
															#line 208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   byteLimit(byteLimit),
															#line 208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   expectedBeginId(expectedBeginId),
															#line 208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   self(self),
															#line 208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   allMissing(allMissing)
															#line 1216 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
	{
		fdb_probe_actor_create("scanMappedRangeWithLimits", reinterpret_cast<unsigned long>(this));

	}
	~ScanMappedRangeWithLimitsActorState() 
	{
		fdb_probe_actor_destroy("scanMappedRangeWithLimits", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 218 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			std::cout << "start scanMappedRangeWithLimits beginSelector:" << beginSelector.toString() << " endSelector:" << endSelector.toString() << " expectedBeginId:" << expectedBeginId << " limit:" << limit << " byteLimit: " << byteLimit << "  recordSize: " << recordSize << " STRICTLY_ENFORCE_BYTE_LIMIT: " << SERVER_KNOBS->STRICTLY_ENFORCE_BYTE_LIMIT << " allMissing " << allMissing << std::endl;
															#line 223 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			;
															#line 1233 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ScanMappedRangeWithLimitsActorState();
		static_cast<ScanMappedRangeWithLimitsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 224 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		tr = self->createTransaction();
															#line 1263 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		try {
															#line 226 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			StrictFuture<MappedRangeResult> __when_expr_0 = tr->getMappedRange(beginSelector, endSelector, mapper, GetRangeLimits(limit, byteLimit), self->snapshot, Reverse::False);
															#line 226 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			if (static_cast<ScanMappedRangeWithLimitsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1269 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ScanMappedRangeWithLimitsActor*>(this)->actor_wait_state = 1;
															#line 226 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ScanMappedRangeWithLimitsActor, 0, MappedRangeResult >*>(static_cast<ScanMappedRangeWithLimitsActor*>(this)));
															#line 1274 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 256 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			if ((self->BAD_MAPPER && e.code() == error_code_mapper_bad_index) || (!SERVER_KNOBS->QUICK_GET_VALUE_FALLBACK && e.code() == error_code_quick_get_value_miss) || (!SERVER_KNOBS->QUICK_GET_KEY_VALUES_FALLBACK && e.code() == error_code_quick_get_key_values_miss))
															#line 1296 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			{
															#line 260 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				TraceEvent("GetMappedRangeWorkloadExpectedErrorDetected").error(e);
															#line 261 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				if (!static_cast<ScanMappedRangeWithLimitsActor*>(this)->SAV<MappedRangeResult>::futures) { (void)(MappedRangeResult()); this->~ScanMappedRangeWithLimitsActorState(); static_cast<ScanMappedRangeWithLimitsActor*>(this)->destroy(); return 0; }
															#line 1302 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
				new (&static_cast<ScanMappedRangeWithLimitsActor*>(this)->SAV< MappedRangeResult >::value()) MappedRangeResult(MappedRangeResult());
				this->~ScanMappedRangeWithLimitsActorState();
				static_cast<ScanMappedRangeWithLimitsActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 262 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				if (e.code() == error_code_commit_proxy_memory_limit_exceeded || e.code() == error_code_operation_cancelled)
															#line 1312 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
				{
															#line 265 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					StrictFuture<Void> __when_expr_1 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 265 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					if (static_cast<ScanMappedRangeWithLimitsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1318 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
					static_cast<ScanMappedRangeWithLimitsActor*>(this)->actor_wait_state = 2;
															#line 265 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ScanMappedRangeWithLimitsActor, 1, Void >*>(static_cast<ScanMappedRangeWithLimitsActor*>(this)));
															#line 1323 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 268 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					std::cout << "scan error " << e.what() << "  code is " << e.code() << std::endl;
															#line 269 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 269 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					if (static_cast<ScanMappedRangeWithLimitsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1334 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when2(__when_expr_2.get(), loopDepth); };
					static_cast<ScanMappedRangeWithLimitsActor*>(this)->actor_wait_state = 3;
															#line 269 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ScanMappedRangeWithLimitsActor, 2, Void >*>(static_cast<ScanMappedRangeWithLimitsActor*>(this)));
															#line 1339 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
					loopDepth = 0;
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(MappedRangeResult const& result,int loopDepth) 
	{
															#line 233 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (self->BAD_MAPPER)
															#line 1356 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		{
															#line 234 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			TraceEvent("GetMappedRangeWorkloadShouldNotReachable").detail("ResultSize", result.size());
															#line 1360 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		}
															#line 236 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		std::cout << "result.size()=" << result.size() << std::endl;
															#line 237 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		std::cout << "result.more=" << result.more << std::endl;
															#line 238 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		ASSERT(result.size() <= limit);
															#line 239 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		int expectedId = expectedBeginId;
															#line 240 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		bool needRetry = false;
															#line 241 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		int cnt = 0;
															#line 242 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		const MappedKeyValueRef* it = result.begin();
															#line 243 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		for(;cnt < result.size();cnt++, it++) {
															#line 244 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			if (validateRecord(expectedId, it, self, allMissing))
															#line 1380 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			{
															#line 245 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				needRetry = true;
															#line 1384 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
				break;
			}
															#line 248 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			expectedId++;
															#line 1389 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		}
															#line 250 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (needRetry)
															#line 1393 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		{
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 253 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		std::cout << "finished scanMappedRangeWithLimits" << std::endl;
															#line 254 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (!static_cast<ScanMappedRangeWithLimitsActor*>(this)->SAV<MappedRangeResult>::futures) { (void)(result); this->~ScanMappedRangeWithLimitsActorState(); static_cast<ScanMappedRangeWithLimitsActor*>(this)->destroy(); return 0; }
															#line 1401 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		new (&static_cast<ScanMappedRangeWithLimitsActor*>(this)->SAV< MappedRangeResult >::value()) MappedRangeResult(result);
		this->~ScanMappedRangeWithLimitsActorState();
		static_cast<ScanMappedRangeWithLimitsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(MappedRangeResult && result,int loopDepth) 
	{
															#line 233 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (self->BAD_MAPPER)
															#line 1413 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		{
															#line 234 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			TraceEvent("GetMappedRangeWorkloadShouldNotReachable").detail("ResultSize", result.size());
															#line 1417 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		}
															#line 236 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		std::cout << "result.size()=" << result.size() << std::endl;
															#line 237 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		std::cout << "result.more=" << result.more << std::endl;
															#line 238 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		ASSERT(result.size() <= limit);
															#line 239 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		int expectedId = expectedBeginId;
															#line 240 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		bool needRetry = false;
															#line 241 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		int cnt = 0;
															#line 242 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		const MappedKeyValueRef* it = result.begin();
															#line 243 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		for(;cnt < result.size();cnt++, it++) {
															#line 244 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			if (validateRecord(expectedId, it, self, allMissing))
															#line 1437 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			{
															#line 245 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				needRetry = true;
															#line 1441 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
				break;
			}
															#line 248 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			expectedId++;
															#line 1446 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		}
															#line 250 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (needRetry)
															#line 1450 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		{
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 253 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		std::cout << "finished scanMappedRangeWithLimits" << std::endl;
															#line 254 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (!static_cast<ScanMappedRangeWithLimitsActor*>(this)->SAV<MappedRangeResult>::futures) { (void)(result); this->~ScanMappedRangeWithLimitsActorState(); static_cast<ScanMappedRangeWithLimitsActor*>(this)->destroy(); return 0; }
															#line 1458 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		new (&static_cast<ScanMappedRangeWithLimitsActor*>(this)->SAV< MappedRangeResult >::value()) MappedRangeResult(result);
		this->~ScanMappedRangeWithLimitsActorState();
		static_cast<ScanMappedRangeWithLimitsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(MappedRangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(MappedRangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ScanMappedRangeWithLimitsActor*>(this)->actor_wait_state > 0) static_cast<ScanMappedRangeWithLimitsActor*>(this)->actor_wait_state = 0;
		static_cast<ScanMappedRangeWithLimitsActor*>(this)->ActorCallback< ScanMappedRangeWithLimitsActor, 0, MappedRangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ScanMappedRangeWithLimitsActor, 0, MappedRangeResult >*,MappedRangeResult const& value) 
	{
		fdb_probe_actor_enter("scanMappedRangeWithLimits", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ScanMappedRangeWithLimitsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("scanMappedRangeWithLimits", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ScanMappedRangeWithLimitsActor, 0, MappedRangeResult >*,MappedRangeResult && value) 
	{
		fdb_probe_actor_enter("scanMappedRangeWithLimits", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ScanMappedRangeWithLimitsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("scanMappedRangeWithLimits", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ScanMappedRangeWithLimitsActor, 0, MappedRangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("scanMappedRangeWithLimits", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ScanMappedRangeWithLimitsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("scanMappedRangeWithLimits", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 271 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		std::cout << "failed scanMappedRangeWithLimits" << std::endl;
															#line 1545 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ScanMappedRangeWithLimitsActor*>(this)->actor_wait_state > 0) static_cast<ScanMappedRangeWithLimitsActor*>(this)->actor_wait_state = 0;
		static_cast<ScanMappedRangeWithLimitsActor*>(this)->ActorCallback< ScanMappedRangeWithLimitsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ScanMappedRangeWithLimitsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("scanMappedRangeWithLimits", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ScanMappedRangeWithLimitsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("scanMappedRangeWithLimits", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ScanMappedRangeWithLimitsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("scanMappedRangeWithLimits", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ScanMappedRangeWithLimitsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("scanMappedRangeWithLimits", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ScanMappedRangeWithLimitsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("scanMappedRangeWithLimits", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ScanMappedRangeWithLimitsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("scanMappedRangeWithLimits", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ScanMappedRangeWithLimitsActor*>(this)->actor_wait_state > 0) static_cast<ScanMappedRangeWithLimitsActor*>(this)->actor_wait_state = 0;
		static_cast<ScanMappedRangeWithLimitsActor*>(this)->ActorCallback< ScanMappedRangeWithLimitsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ScanMappedRangeWithLimitsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("scanMappedRangeWithLimits", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ScanMappedRangeWithLimitsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("scanMappedRangeWithLimits", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ScanMappedRangeWithLimitsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("scanMappedRangeWithLimits", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ScanMappedRangeWithLimitsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("scanMappedRangeWithLimits", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ScanMappedRangeWithLimitsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("scanMappedRangeWithLimits", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ScanMappedRangeWithLimitsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("scanMappedRangeWithLimits", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	Database cx;
															#line 208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	KeySelector beginSelector;
															#line 208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	KeySelector endSelector;
															#line 208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	Key mapper;
															#line 208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	int limit;
															#line 208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	int byteLimit;
															#line 208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	int expectedBeginId;
															#line 208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	GetMappedRangeWorkload* self;
															#line 208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	bool allMissing;
															#line 224 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	Reference<TransactionWrapper> tr;
															#line 1750 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
};
// This generated class is to be used only via scanMappedRangeWithLimits()
															#line 208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
class ScanMappedRangeWithLimitsActor final : public Actor<MappedRangeResult>, public ActorCallback< ScanMappedRangeWithLimitsActor, 0, MappedRangeResult >, public ActorCallback< ScanMappedRangeWithLimitsActor, 1, Void >, public ActorCallback< ScanMappedRangeWithLimitsActor, 2, Void >, public FastAllocated<ScanMappedRangeWithLimitsActor>, public ScanMappedRangeWithLimitsActorState<ScanMappedRangeWithLimitsActor> {
															#line 1755 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
public:
	using FastAllocated<ScanMappedRangeWithLimitsActor>::operator new;
	using FastAllocated<ScanMappedRangeWithLimitsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17996841189729511680UL, 10916001821876086528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<MappedRangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ScanMappedRangeWithLimitsActor, 0, MappedRangeResult >;
friend struct ActorCallback< ScanMappedRangeWithLimitsActor, 1, Void >;
friend struct ActorCallback< ScanMappedRangeWithLimitsActor, 2, Void >;
															#line 208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	ScanMappedRangeWithLimitsActor(Database const& cx,KeySelector const& beginSelector,KeySelector const& endSelector,Key const& mapper,int const& limit,int const& byteLimit,int const& expectedBeginId,GetMappedRangeWorkload* const& self,bool const& allMissing) 
															#line 1774 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		 : Actor<MappedRangeResult>(),
		   ScanMappedRangeWithLimitsActorState<ScanMappedRangeWithLimitsActor>(cx, beginSelector, endSelector, mapper, limit, byteLimit, expectedBeginId, self, allMissing),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("scanMappedRangeWithLimits", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6210236163684550144UL, 13956857045101112320UL);
		ActorExecutionContextHelper __helper(static_cast<ScanMappedRangeWithLimitsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("scanMappedRangeWithLimits");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("scanMappedRangeWithLimits", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ScanMappedRangeWithLimitsActor, 0, MappedRangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ScanMappedRangeWithLimitsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ScanMappedRangeWithLimitsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
[[nodiscard]] Future<MappedRangeResult> scanMappedRangeWithLimits( Database const& cx, KeySelector const& beginSelector, KeySelector const& endSelector, Key const& mapper, int const& limit, int const& byteLimit, int const& expectedBeginId, GetMappedRangeWorkload* const& self, bool const& allMissing ) {
															#line 208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	return Future<MappedRangeResult>(new ScanMappedRangeWithLimitsActor(cx, beginSelector, endSelector, mapper, limit, byteLimit, expectedBeginId, self, allMissing));
															#line 1808 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
}

#line 275 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"

	// if sendFirstRequestIndefinitely is true, then this method would send the first request indefinitely
	// it is in order to test the metric
																#line 1815 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
// This generated class is to be used only via submitSmallRequestIndefinitely()
															#line 278 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
template <class SubmitSmallRequestIndefinitelyActor>
															#line 278 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
class SubmitSmallRequestIndefinitelyActorState {
															#line 1821 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
public:
															#line 278 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	SubmitSmallRequestIndefinitelyActorState(Database const& cx,int const& beginId,int const& endId,Key const& mapper,GetMappedRangeWorkload* const& self) 
															#line 278 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
															#line 278 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		 : cx(cx),
															#line 278 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   beginId(beginId),
															#line 278 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   endId(endId),
															#line 278 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   mapper(mapper),
															#line 278 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   self(self)
															#line 1836 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
	{
		fdb_probe_actor_create("submitSmallRequestIndefinitely", reinterpret_cast<unsigned long>(this));

	}
	~SubmitSmallRequestIndefinitelyActorState() 
	{
		fdb_probe_actor_destroy("submitSmallRequestIndefinitely", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 283 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			Key beginTuple = Tuple().append(prefix).append(INDEX).append(indexKey(beginId)).getDataAsStandalone();
															#line 284 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			beginSelector = KeySelector(firstGreaterOrEqual(beginTuple));
															#line 285 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			Key endTuple = Tuple().append(prefix).append(INDEX).append(indexKey(endId)).getDataAsStandalone();
															#line 286 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			endSelector = KeySelector(firstGreaterOrEqual(endTuple));
															#line 287 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			limit = 1;
															#line 288 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			byteLimit = 10000;
															#line 289 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			;
															#line 1863 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SubmitSmallRequestIndefinitelyActorState();
		static_cast<SubmitSmallRequestIndefinitelyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 290 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		StrictFuture<MappedRangeResult> __when_expr_0 = self->scanMappedRangeWithLimits( cx, beginSelector, endSelector, mapper, limit, byteLimit, beginId, self, false);
															#line 290 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (static_cast<SubmitSmallRequestIndefinitelyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1895 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<SubmitSmallRequestIndefinitelyActor*>(this)->actor_wait_state = 1;
															#line 290 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SubmitSmallRequestIndefinitelyActor, 0, MappedRangeResult >*>(static_cast<SubmitSmallRequestIndefinitelyActor*>(this)));
															#line 1900 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(MappedRangeResult const& result,int loopDepth) 
	{
															#line 292 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (result.empty())
															#line 1909 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		{
															#line 293 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			TraceEvent("EmptyResult");
															#line 1913 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		}
															#line 296 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 296 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (static_cast<SubmitSmallRequestIndefinitelyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1919 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SubmitSmallRequestIndefinitelyActor*>(this)->actor_wait_state = 2;
															#line 296 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SubmitSmallRequestIndefinitelyActor, 1, Void >*>(static_cast<SubmitSmallRequestIndefinitelyActor*>(this)));
															#line 1924 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(MappedRangeResult && result,int loopDepth) 
	{
															#line 292 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (result.empty())
															#line 1933 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		{
															#line 293 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			TraceEvent("EmptyResult");
															#line 1937 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		}
															#line 296 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 296 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (static_cast<SubmitSmallRequestIndefinitelyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1943 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SubmitSmallRequestIndefinitelyActor*>(this)->actor_wait_state = 2;
															#line 296 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SubmitSmallRequestIndefinitelyActor, 1, Void >*>(static_cast<SubmitSmallRequestIndefinitelyActor*>(this)));
															#line 1948 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(MappedRangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(MappedRangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SubmitSmallRequestIndefinitelyActor*>(this)->actor_wait_state > 0) static_cast<SubmitSmallRequestIndefinitelyActor*>(this)->actor_wait_state = 0;
		static_cast<SubmitSmallRequestIndefinitelyActor*>(this)->ActorCallback< SubmitSmallRequestIndefinitelyActor, 0, MappedRangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< SubmitSmallRequestIndefinitelyActor, 0, MappedRangeResult >*,MappedRangeResult const& value) 
	{
		fdb_probe_actor_enter("submitSmallRequestIndefinitely", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitSmallRequestIndefinitelyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitSmallRequestIndefinitely", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SubmitSmallRequestIndefinitelyActor, 0, MappedRangeResult >*,MappedRangeResult && value) 
	{
		fdb_probe_actor_enter("submitSmallRequestIndefinitely", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitSmallRequestIndefinitelyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitSmallRequestIndefinitely", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SubmitSmallRequestIndefinitelyActor, 0, MappedRangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("submitSmallRequestIndefinitely", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitSmallRequestIndefinitelyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitSmallRequestIndefinitely", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SubmitSmallRequestIndefinitelyActor*>(this)->actor_wait_state > 0) static_cast<SubmitSmallRequestIndefinitelyActor*>(this)->actor_wait_state = 0;
		static_cast<SubmitSmallRequestIndefinitelyActor*>(this)->ActorCallback< SubmitSmallRequestIndefinitelyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SubmitSmallRequestIndefinitelyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("submitSmallRequestIndefinitely", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitSmallRequestIndefinitelyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitSmallRequestIndefinitely", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SubmitSmallRequestIndefinitelyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("submitSmallRequestIndefinitely", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitSmallRequestIndefinitelyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitSmallRequestIndefinitely", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SubmitSmallRequestIndefinitelyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("submitSmallRequestIndefinitely", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitSmallRequestIndefinitelyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitSmallRequestIndefinitely", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 278 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	Database cx;
															#line 278 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	int beginId;
															#line 278 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	int endId;
															#line 278 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	Key mapper;
															#line 278 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	GetMappedRangeWorkload* self;
															#line 284 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	KeySelector beginSelector;
															#line 286 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	KeySelector endSelector;
															#line 287 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	int limit;
															#line 288 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	int byteLimit;
															#line 2133 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
};
// This generated class is to be used only via submitSmallRequestIndefinitely()
															#line 278 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
class SubmitSmallRequestIndefinitelyActor final : public Actor<Void>, public ActorCallback< SubmitSmallRequestIndefinitelyActor, 0, MappedRangeResult >, public ActorCallback< SubmitSmallRequestIndefinitelyActor, 1, Void >, public FastAllocated<SubmitSmallRequestIndefinitelyActor>, public SubmitSmallRequestIndefinitelyActorState<SubmitSmallRequestIndefinitelyActor> {
															#line 2138 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
public:
	using FastAllocated<SubmitSmallRequestIndefinitelyActor>::operator new;
	using FastAllocated<SubmitSmallRequestIndefinitelyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(757731524292544000UL, 11285104471590026752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SubmitSmallRequestIndefinitelyActor, 0, MappedRangeResult >;
friend struct ActorCallback< SubmitSmallRequestIndefinitelyActor, 1, Void >;
															#line 278 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	SubmitSmallRequestIndefinitelyActor(Database const& cx,int const& beginId,int const& endId,Key const& mapper,GetMappedRangeWorkload* const& self) 
															#line 2156 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		 : Actor<Void>(),
		   SubmitSmallRequestIndefinitelyActorState<SubmitSmallRequestIndefinitelyActor>(cx, beginId, endId, mapper, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("submitSmallRequestIndefinitely", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3705350612759135232UL, 2343344713383235072UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitSmallRequestIndefinitelyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("submitSmallRequestIndefinitely");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("submitSmallRequestIndefinitely", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SubmitSmallRequestIndefinitelyActor, 0, MappedRangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SubmitSmallRequestIndefinitelyActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 278 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
[[nodiscard]] Future<Void> submitSmallRequestIndefinitely( Database const& cx, int const& beginId, int const& endId, Key const& mapper, GetMappedRangeWorkload* const& self ) {
															#line 278 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	return Future<Void>(new SubmitSmallRequestIndefinitelyActor(cx, beginId, endId, mapper, self));
															#line 2189 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
}

#line 299 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"

																#line 2194 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
// This generated class is to be used only via scanMappedRange()
															#line 300 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
template <class ScanMappedRangeActor>
															#line 300 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
class ScanMappedRangeActorState {
															#line 2200 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
public:
															#line 300 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	ScanMappedRangeActorState(Database const& cx,int const& beginId,int const& endId,Key const& mapper,GetMappedRangeWorkload* const& self,bool const& allMissing = false) 
															#line 300 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
															#line 300 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		 : cx(cx),
															#line 300 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   beginId(beginId),
															#line 300 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   endId(endId),
															#line 300 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   mapper(mapper),
															#line 300 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   self(self),
															#line 300 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   allMissing(allMissing)
															#line 2217 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
	{
		fdb_probe_actor_create("scanMappedRange", reinterpret_cast<unsigned long>(this));

	}
	~ScanMappedRangeActorState() 
	{
		fdb_probe_actor_destroy("scanMappedRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 306 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			Key beginTuple = Tuple::makeTuple(prefix, INDEX, indexKey(beginId)).getDataAsStandalone();
															#line 307 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			beginSelector = KeySelector(firstGreaterOrEqual(beginTuple));
															#line 308 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			Key endTuple = Tuple::makeTuple(prefix, INDEX, indexKey(endId)).getDataAsStandalone();
															#line 309 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			endSelector = KeySelector(firstGreaterOrEqual(endTuple));
															#line 310 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			limit = 100;
															#line 311 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			byteLimit = deterministicRandom()->randomInt(1, 9) * 10000;
															#line 312 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			expectedBeginId = beginId;
															#line 313 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			std::cout << "ByteLimit: " << byteLimit << " limit: " << limit << " FRACTION_INDEX_BYTELIMIT_PREFETCH: " << SERVER_KNOBS->FRACTION_INDEX_BYTELIMIT_PREFETCH << " MAX_PARALLEL_QUICK_GET_VALUE: " << SERVER_KNOBS->MAX_PARALLEL_QUICK_GET_VALUE << std::endl;
															#line 316 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			;
															#line 2248 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ScanMappedRangeActorState();
		static_cast<ScanMappedRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 353 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		ASSERT(expectedBeginId == endId);
															#line 355 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (!static_cast<ScanMappedRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ScanMappedRangeActorState(); static_cast<ScanMappedRangeActor*>(this)->destroy(); return 0; }
															#line 2273 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		new (&static_cast<ScanMappedRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ScanMappedRangeActorState();
		static_cast<ScanMappedRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 317 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		StrictFuture<MappedRangeResult> __when_expr_0 = self->scanMappedRangeWithLimits( cx, beginSelector, endSelector, mapper, limit, byteLimit, expectedBeginId, self, allMissing);
															#line 317 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (static_cast<ScanMappedRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2294 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ScanMappedRangeActor*>(this)->actor_wait_state = 1;
															#line 317 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ScanMappedRangeActor, 0, MappedRangeResult >*>(static_cast<ScanMappedRangeActor*>(this)));
															#line 2299 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(MappedRangeResult const& result,int loopDepth) 
	{
															#line 319 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		expectedBeginId += result.size();
															#line 320 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (result.more)
															#line 2323 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		{
															#line 321 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			if (result.empty())
															#line 2327 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			{
															#line 323 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				std::cout << "not result but have more, try again" << std::endl;
															#line 2331 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			}
			else
			{
															#line 325 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				int size = allMissing ? indexSize : (indexSize + recordSize);
															#line 326 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				int expectedCnt = limit;
															#line 327 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				int indexByteLimit = byteLimit * SERVER_KNOBS->FRACTION_INDEX_BYTELIMIT_PREFETCH;
															#line 328 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				int indexCountByteLimit = indexByteLimit / indexSize + (indexByteLimit % indexSize != 0);
															#line 329 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				int indexCount = std::min(limit, indexCountByteLimit);
															#line 331 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				ASSERT(result.size() <= indexCount);
															#line 333 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				expectedCnt = std::min(expectedCnt, indexCount);
															#line 334 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				int boundByRecord;
															#line 335 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				if (SERVER_KNOBS->STRICTLY_ENFORCE_BYTE_LIMIT)
															#line 2353 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
				{
															#line 337 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					boundByRecord = byteLimit / size + (byteLimit % size != 0);
															#line 2357 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
				}
				else
				{
															#line 340 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					int roundSize = size * SERVER_KNOBS->MAX_PARALLEL_QUICK_GET_VALUE;
															#line 341 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					int round = byteLimit / roundSize + (byteLimit % roundSize != 0);
															#line 342 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					boundByRecord = round * SERVER_KNOBS->MAX_PARALLEL_QUICK_GET_VALUE;
															#line 2367 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
				}
															#line 344 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				expectedCnt = std::min(expectedCnt, boundByRecord);
															#line 345 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				ASSERT_LE(result.size(), expectedCnt);
															#line 346 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				beginSelector = KeySelector(firstGreaterThan(result.back().key));
															#line 2375 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			}
		}
		else
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(MappedRangeResult && result,int loopDepth) 
	{
															#line 319 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		expectedBeginId += result.size();
															#line 320 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (result.more)
															#line 2392 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		{
															#line 321 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			if (result.empty())
															#line 2396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			{
															#line 323 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				std::cout << "not result but have more, try again" << std::endl;
															#line 2400 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			}
			else
			{
															#line 325 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				int size = allMissing ? indexSize : (indexSize + recordSize);
															#line 326 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				int expectedCnt = limit;
															#line 327 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				int indexByteLimit = byteLimit * SERVER_KNOBS->FRACTION_INDEX_BYTELIMIT_PREFETCH;
															#line 328 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				int indexCountByteLimit = indexByteLimit / indexSize + (indexByteLimit % indexSize != 0);
															#line 329 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				int indexCount = std::min(limit, indexCountByteLimit);
															#line 331 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				ASSERT(result.size() <= indexCount);
															#line 333 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				expectedCnt = std::min(expectedCnt, indexCount);
															#line 334 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				int boundByRecord;
															#line 335 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				if (SERVER_KNOBS->STRICTLY_ENFORCE_BYTE_LIMIT)
															#line 2422 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
				{
															#line 337 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					boundByRecord = byteLimit / size + (byteLimit % size != 0);
															#line 2426 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
				}
				else
				{
															#line 340 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					int roundSize = size * SERVER_KNOBS->MAX_PARALLEL_QUICK_GET_VALUE;
															#line 341 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					int round = byteLimit / roundSize + (byteLimit % roundSize != 0);
															#line 342 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					boundByRecord = round * SERVER_KNOBS->MAX_PARALLEL_QUICK_GET_VALUE;
															#line 2436 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
				}
															#line 344 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				expectedCnt = std::min(expectedCnt, boundByRecord);
															#line 345 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				ASSERT_LE(result.size(), expectedCnt);
															#line 346 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				beginSelector = KeySelector(firstGreaterThan(result.back().key));
															#line 2444 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			}
		}
		else
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(MappedRangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(MappedRangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ScanMappedRangeActor*>(this)->actor_wait_state > 0) static_cast<ScanMappedRangeActor*>(this)->actor_wait_state = 0;
		static_cast<ScanMappedRangeActor*>(this)->ActorCallback< ScanMappedRangeActor, 0, MappedRangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ScanMappedRangeActor, 0, MappedRangeResult >*,MappedRangeResult const& value) 
	{
		fdb_probe_actor_enter("scanMappedRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ScanMappedRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("scanMappedRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ScanMappedRangeActor, 0, MappedRangeResult >*,MappedRangeResult && value) 
	{
		fdb_probe_actor_enter("scanMappedRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ScanMappedRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("scanMappedRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ScanMappedRangeActor, 0, MappedRangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("scanMappedRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ScanMappedRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("scanMappedRange", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 300 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	Database cx;
															#line 300 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	int beginId;
															#line 300 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	int endId;
															#line 300 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	Key mapper;
															#line 300 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	GetMappedRangeWorkload* self;
															#line 300 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	bool allMissing;
															#line 307 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	KeySelector beginSelector;
															#line 309 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	KeySelector endSelector;
															#line 310 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	int limit;
															#line 311 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	int byteLimit;
															#line 312 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	int expectedBeginId;
															#line 2552 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
};
// This generated class is to be used only via scanMappedRange()
															#line 300 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
class ScanMappedRangeActor final : public Actor<Void>, public ActorCallback< ScanMappedRangeActor, 0, MappedRangeResult >, public FastAllocated<ScanMappedRangeActor>, public ScanMappedRangeActorState<ScanMappedRangeActor> {
															#line 2557 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
public:
	using FastAllocated<ScanMappedRangeActor>::operator new;
	using FastAllocated<ScanMappedRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5977709207735535360UL, 17537162379864819456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ScanMappedRangeActor, 0, MappedRangeResult >;
															#line 300 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	ScanMappedRangeActor(Database const& cx,int const& beginId,int const& endId,Key const& mapper,GetMappedRangeWorkload* const& self,bool const& allMissing = false) 
															#line 2574 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		 : Actor<Void>(),
		   ScanMappedRangeActorState<ScanMappedRangeActor>(cx, beginId, endId, mapper, self, allMissing),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("scanMappedRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11831263619569871616UL, 6199128693231804928UL);
		ActorExecutionContextHelper __helper(static_cast<ScanMappedRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("scanMappedRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("scanMappedRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ScanMappedRangeActor, 0, MappedRangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 300 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
[[nodiscard]] Future<Void> scanMappedRange( Database const& cx, int const& beginId, int const& endId, Key const& mapper, GetMappedRangeWorkload* const& self, bool const& allMissing = false ) {
															#line 300 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	return Future<Void>(new ScanMappedRangeActor(cx, beginId, endId, mapper, self, allMissing));
															#line 2606 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
}

#line 357 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"

	static void conflictWriteOnRecord(int conflictRecordId,
	                                  Reference<TransactionWrapper>& tr,
	                                  GetMappedRangeWorkload* self) {
		Key writeKey;
		if (deterministicRandom()->random01() < 0.5) {
			// Concurrent write to the primary scanned range
			writeKey = indexEntryKey(conflictRecordId);
		} else {
			// Concurrent write to the underlying scanned ranges/keys
			if (self->SPLIT_RECORDS) {
				// Update one of the splits is sufficient.
				writeKey = recordKey(conflictRecordId, 0);
			} else {
				writeKey = recordKey(conflictRecordId);
			}
		}
		tr->set(writeKey, SOMETHING);
		std::cout << "conflict write to " << printable(writeKey) << std::endl;
	}

	static Future<MappedRangeResult> runGetMappedRange(int beginId,
	                                                   int endId,
	                                                   Reference<TransactionWrapper>& tr,
	                                                   GetMappedRangeWorkload* self) {
		Key mapper = getMapper(self, false);
		Key beginTuple = Tuple::makeTuple(prefix, INDEX, indexKey(beginId)).getDataAsStandalone();
		KeySelector beginSelector = KeySelector(firstGreaterOrEqual(beginTuple));
		Key endTuple = Tuple::makeTuple(prefix, INDEX, indexKey(endId)).getDataAsStandalone();
		KeySelector endSelector = KeySelector(firstGreaterOrEqual(endTuple));
		return tr->getMappedRange(beginSelector,
		                          endSelector,
		                          mapper,
		                          GetRangeLimits(GetRangeLimits::ROW_LIMIT_UNLIMITED),
		                          self->snapshot,
		                          Reverse::False);
	}

	// If another transaction writes to our read set (the scanned ranges) before we commit, the transaction should
	// fail.
																#line 2650 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
// This generated class is to be used only via testSerializableConflicts()
															#line 397 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
template <class TestSerializableConflictsActor>
															#line 397 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
class TestSerializableConflictsActorState {
															#line 2656 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
public:
															#line 397 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	TestSerializableConflictsActorState(GetMappedRangeWorkload* const& self) 
															#line 397 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
															#line 397 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		 : self(self)
															#line 2663 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
	{
		fdb_probe_actor_create("testSerializableConflicts", reinterpret_cast<unsigned long>(this));

	}
	~TestSerializableConflictsActorState() 
	{
		fdb_probe_actor_destroy("testSerializableConflicts", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 398 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			std::cout << "testSerializableConflicts" << std::endl;
															#line 400 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			;
															#line 2680 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestSerializableConflictsActorState();
		static_cast<TestSerializableConflictsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 401 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		tr1 = self->createTransaction();
															#line 2710 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		try {
															#line 403 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			StrictFuture<MappedRangeResult> __when_expr_0 = runGetMappedRange(5, 10, tr1, self);
															#line 403 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			if (static_cast<TestSerializableConflictsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2716 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestSerializableConflictsActor*>(this)->actor_wait_state = 1;
															#line 403 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestSerializableConflictsActor, 0, MappedRangeResult >*>(static_cast<TestSerializableConflictsActor*>(this)));
															#line 2721 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 423 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			if (e.code() == error_code_not_committed)
															#line 2743 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			{
															#line 424 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				std::cout << "tr1 failed because of conflicts (as expected)" << std::endl;
															#line 425 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				TraceEvent("GetMappedRangeWorkloadExpectedErrorDetected").error(e);
															#line 426 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				if (!static_cast<TestSerializableConflictsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestSerializableConflictsActorState(); static_cast<TestSerializableConflictsActor*>(this)->destroy(); return 0; }
															#line 2751 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
				new (&static_cast<TestSerializableConflictsActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~TestSerializableConflictsActorState();
				static_cast<TestSerializableConflictsActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 428 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				std::cout << "tr1 error " << e.what() << std::endl;
															#line 429 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				StrictFuture<Void> __when_expr_4 = tr1->onError(e);
															#line 429 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				if (static_cast<TestSerializableConflictsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2765 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
				static_cast<TestSerializableConflictsActor*>(this)->actor_wait_state = 5;
															#line 429 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestSerializableConflictsActor, 4, Void >*>(static_cast<TestSerializableConflictsActor*>(this)));
															#line 2770 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(MappedRangeResult const& result,int loopDepth) 
	{
															#line 406 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		;
															#line 2786 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(MappedRangeResult && result,int loopDepth) 
	{
															#line 406 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		;
															#line 2795 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(MappedRangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(MappedRangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestSerializableConflictsActor*>(this)->actor_wait_state > 0) static_cast<TestSerializableConflictsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSerializableConflictsActor*>(this)->ActorCallback< TestSerializableConflictsActor, 0, MappedRangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TestSerializableConflictsActor, 0, MappedRangeResult >*,MappedRangeResult const& value) 
	{
		fdb_probe_actor_enter("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSerializableConflictsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestSerializableConflictsActor, 0, MappedRangeResult >*,MappedRangeResult && value) 
	{
		fdb_probe_actor_enter("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSerializableConflictsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestSerializableConflictsActor, 0, MappedRangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSerializableConflictsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 419 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		tr1->set(SOMETHING, SOMETHING);
															#line 420 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr1->commit();
															#line 420 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (static_cast<TestSerializableConflictsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2883 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestSerializableConflictsActor*>(this)->actor_wait_state = 4;
															#line 420 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestSerializableConflictsActor, 3, Void >*>(static_cast<TestSerializableConflictsActor*>(this)));
															#line 2888 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 407 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		tr2 = self->createTransaction();
															#line 2904 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		try {
															#line 409 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			conflictWriteOnRecord(7, tr2, self);
															#line 410 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr2->commit();
															#line 410 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			if (static_cast<TestSerializableConflictsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2912 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont2loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TestSerializableConflictsActor*>(this)->actor_wait_state = 2;
															#line 410 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestSerializableConflictsActor, 1, Void >*>(static_cast<TestSerializableConflictsActor*>(this)));
															#line 2917 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 413 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			std::cout << "tr2 error " << e.what() << std::endl;
															#line 414 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr2->onError(e);
															#line 414 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			if (static_cast<TestSerializableConflictsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2956 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<TestSerializableConflictsActor*>(this)->actor_wait_state = 3;
															#line 414 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestSerializableConflictsActor, 2, Void >*>(static_cast<TestSerializableConflictsActor*>(this)));
															#line 2961 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestSerializableConflictsActor*>(this)->actor_wait_state > 0) static_cast<TestSerializableConflictsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSerializableConflictsActor*>(this)->ActorCallback< TestSerializableConflictsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSerializableConflictsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSerializableConflictsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestSerializableConflictsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSerializableConflictsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestSerializableConflictsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSerializableConflictsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestSerializableConflictsActor*>(this)->actor_wait_state > 0) static_cast<TestSerializableConflictsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSerializableConflictsActor*>(this)->ActorCallback< TestSerializableConflictsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSerializableConflictsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSerializableConflictsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestSerializableConflictsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSerializableConflictsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestSerializableConflictsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSerializableConflictsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 421 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		UNREACHABLE();
															#line 3150 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 421 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		UNREACHABLE();
															#line 3159 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestSerializableConflictsActor*>(this)->actor_wait_state > 0) static_cast<TestSerializableConflictsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSerializableConflictsActor*>(this)->ActorCallback< TestSerializableConflictsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSerializableConflictsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSerializableConflictsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestSerializableConflictsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSerializableConflictsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestSerializableConflictsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSerializableConflictsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestSerializableConflictsActor*>(this)->actor_wait_state > 0) static_cast<TestSerializableConflictsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSerializableConflictsActor*>(this)->ActorCallback< TestSerializableConflictsActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSerializableConflictsActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSerializableConflictsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestSerializableConflictsActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSerializableConflictsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestSerializableConflictsActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSerializableConflictsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSerializableConflicts", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 397 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	GetMappedRangeWorkload* self;
															#line 401 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	Reference<TransactionWrapper> tr1;
															#line 407 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	Reference<TransactionWrapper> tr2;
															#line 3351 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
};
// This generated class is to be used only via testSerializableConflicts()
															#line 397 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
class TestSerializableConflictsActor final : public Actor<Void>, public ActorCallback< TestSerializableConflictsActor, 0, MappedRangeResult >, public ActorCallback< TestSerializableConflictsActor, 1, Void >, public ActorCallback< TestSerializableConflictsActor, 2, Void >, public ActorCallback< TestSerializableConflictsActor, 3, Void >, public ActorCallback< TestSerializableConflictsActor, 4, Void >, public FastAllocated<TestSerializableConflictsActor>, public TestSerializableConflictsActorState<TestSerializableConflictsActor> {
															#line 3356 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
public:
	using FastAllocated<TestSerializableConflictsActor>::operator new;
	using FastAllocated<TestSerializableConflictsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14193634056357863168UL, 17873897417596487424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestSerializableConflictsActor, 0, MappedRangeResult >;
friend struct ActorCallback< TestSerializableConflictsActor, 1, Void >;
friend struct ActorCallback< TestSerializableConflictsActor, 2, Void >;
friend struct ActorCallback< TestSerializableConflictsActor, 3, Void >;
friend struct ActorCallback< TestSerializableConflictsActor, 4, Void >;
															#line 397 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	TestSerializableConflictsActor(GetMappedRangeWorkload* const& self) 
															#line 3377 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		 : Actor<Void>(),
		   TestSerializableConflictsActorState<TestSerializableConflictsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testSerializableConflicts", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14279685257482117632UL, 3797400480396055296UL);
		ActorExecutionContextHelper __helper(static_cast<TestSerializableConflictsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testSerializableConflicts");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testSerializableConflicts", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestSerializableConflictsActor, 0, MappedRangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestSerializableConflictsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestSerializableConflictsActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestSerializableConflictsActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestSerializableConflictsActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 397 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
[[nodiscard]] Future<Void> testSerializableConflicts( GetMappedRangeWorkload* const& self ) {
															#line 397 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	return Future<Void>(new TestSerializableConflictsActor(self));
															#line 3413 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
}

#line 434 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"

	// checking the max storage queue length is bounded
																#line 3419 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
// This generated class is to be used only via reportMetric()
															#line 436 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
template <class ReportMetricActor>
															#line 436 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
class ReportMetricActorState {
															#line 3425 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
public:
															#line 436 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	ReportMetricActorState(GetMappedRangeWorkload* const& self,Database const& cx) 
															#line 436 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
															#line 436 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		 : self(self),
															#line 436 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   cx(cx)
															#line 3434 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
	{
		fdb_probe_actor_create("reportMetric", reinterpret_cast<unsigned long>(this));

	}
	~ReportMetricActorState() 
	{
		fdb_probe_actor_destroy("reportMetric", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 437 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			;
															#line 3449 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReportMetricActorState();
		static_cast<ReportMetricActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 438 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		StrictFuture<StatusObject> __when_expr_0 = StatusClient::statusFetcher(cx);
															#line 438 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (static_cast<ReportMetricActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3481 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ReportMetricActor*>(this)->actor_wait_state = 1;
															#line 438 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReportMetricActor, 0, StatusObject >*>(static_cast<ReportMetricActor*>(this)));
															#line 3486 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(StatusObject const& result,int loopDepth) 
	{
															#line 439 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		StatusObjectReader statusObj(result);
															#line 440 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		statusObjCluster = StatusObjectReader();
															#line 441 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		processesMap = StatusObjectReader();
															#line 442 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		queryQueueMax = 0;
															#line 443 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		waitInterval = 2;
															#line 444 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (!statusObj.get("cluster", statusObjCluster))
															#line 3505 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		{
															#line 445 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			TraceEvent("NoCluster");
															#line 446 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(waitInterval);
															#line 446 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			if (static_cast<ReportMetricActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3513 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReportMetricActor*>(this)->actor_wait_state = 2;
															#line 446 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReportMetricActor, 1, Void >*>(static_cast<ReportMetricActor*>(this)));
															#line 3518 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(StatusObject && result,int loopDepth) 
	{
															#line 439 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		StatusObjectReader statusObj(result);
															#line 440 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		statusObjCluster = StatusObjectReader();
															#line 441 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		processesMap = StatusObjectReader();
															#line 442 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		queryQueueMax = 0;
															#line 443 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		waitInterval = 2;
															#line 444 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (!statusObj.get("cluster", statusObjCluster))
															#line 3542 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		{
															#line 445 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			TraceEvent("NoCluster");
															#line 446 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(waitInterval);
															#line 446 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			if (static_cast<ReportMetricActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3550 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReportMetricActor*>(this)->actor_wait_state = 2;
															#line 446 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReportMetricActor, 1, Void >*>(static_cast<ReportMetricActor*>(this)));
															#line 3555 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(StatusObject const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(StatusObject && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReportMetricActor*>(this)->actor_wait_state > 0) static_cast<ReportMetricActor*>(this)->actor_wait_state = 0;
		static_cast<ReportMetricActor*>(this)->ActorCallback< ReportMetricActor, 0, StatusObject >::remove();

	}
	void a_callback_fire(ActorCallback< ReportMetricActor, 0, StatusObject >*,StatusObject const& value) 
	{
		fdb_probe_actor_enter("reportMetric", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReportMetricActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportMetric", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReportMetricActor, 0, StatusObject >*,StatusObject && value) 
	{
		fdb_probe_actor_enter("reportMetric", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReportMetricActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportMetric", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReportMetricActor, 0, StatusObject >*,Error err) 
	{
		fdb_probe_actor_enter("reportMetric", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReportMetricActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportMetric", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 450 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (!statusObjCluster.get("processes", processesMap))
															#line 3644 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		{
															#line 451 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			TraceEvent("NoProcesses");
															#line 452 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(waitInterval);
															#line 452 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			if (static_cast<ReportMetricActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3652 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<ReportMetricActor*>(this)->actor_wait_state = 3;
															#line 452 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReportMetricActor, 2, Void >*>(static_cast<ReportMetricActor*>(this)));
															#line 3657 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReportMetricActor*>(this)->actor_wait_state > 0) static_cast<ReportMetricActor*>(this)->actor_wait_state = 0;
		static_cast<ReportMetricActor*>(this)->ActorCallback< ReportMetricActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReportMetricActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reportMetric", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReportMetricActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportMetric", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReportMetricActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reportMetric", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReportMetricActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportMetric", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReportMetricActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reportMetric", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReportMetricActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportMetric", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 455 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		for( auto proc : processesMap.obj() ) {
															#line 456 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			StatusObjectReader process(proc.second);
															#line 457 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			if (process.has("roles"))
															#line 3762 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			{
															#line 458 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				StatusArray rolesArray = proc.second.get_obj()["roles"].get_array();
															#line 459 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				for( StatusObjectReader role : rolesArray ) {
															#line 460 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					if (role["role"].get_str() == "storage")
															#line 3770 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
					{
															#line 461 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
						role.get("query_queue_max", queryQueueMax);
															#line 462 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
						CODE_PROBE(queryQueueMax > 0, " SS query queue is non-empty");
															#line 463 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
						TraceEvent(SevDebug, "QueryQueueMax") .detail("Value", queryQueueMax) .detail("MaxLength", self->queueMaxLength);
															#line 466 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
						ASSERT(queryQueueMax < self->queueMaxLength);
															#line 3780 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
					}
				}
			}
			else
			{
															#line 470 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				TraceEvent("NoRoles");
															#line 3788 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			}
		}
															#line 473 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(waitInterval);
															#line 473 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (static_cast<ReportMetricActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3795 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<ReportMetricActor*>(this)->actor_wait_state = 4;
															#line 473 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ReportMetricActor, 3, Void >*>(static_cast<ReportMetricActor*>(this)));
															#line 3800 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ReportMetricActor*>(this)->actor_wait_state > 0) static_cast<ReportMetricActor*>(this)->actor_wait_state = 0;
		static_cast<ReportMetricActor*>(this)->ActorCallback< ReportMetricActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReportMetricActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reportMetric", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReportMetricActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportMetric", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReportMetricActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reportMetric", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReportMetricActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportMetric", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReportMetricActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reportMetric", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReportMetricActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportMetric", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ReportMetricActor*>(this)->actor_wait_state > 0) static_cast<ReportMetricActor*>(this)->actor_wait_state = 0;
		static_cast<ReportMetricActor*>(this)->ActorCallback< ReportMetricActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReportMetricActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reportMetric", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReportMetricActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportMetric", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ReportMetricActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reportMetric", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReportMetricActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportMetric", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ReportMetricActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reportMetric", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReportMetricActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportMetric", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 436 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	GetMappedRangeWorkload* self;
															#line 436 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	Database cx;
															#line 440 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	StatusObjectReader statusObjCluster;
															#line 441 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	StatusObjectReader processesMap;
															#line 442 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	int64_t queryQueueMax;
															#line 443 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	int waitInterval;
															#line 3991 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
};
// This generated class is to be used only via reportMetric()
															#line 436 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
class ReportMetricActor final : public Actor<Void>, public ActorCallback< ReportMetricActor, 0, StatusObject >, public ActorCallback< ReportMetricActor, 1, Void >, public ActorCallback< ReportMetricActor, 2, Void >, public ActorCallback< ReportMetricActor, 3, Void >, public FastAllocated<ReportMetricActor>, public ReportMetricActorState<ReportMetricActor> {
															#line 3996 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
public:
	using FastAllocated<ReportMetricActor>::operator new;
	using FastAllocated<ReportMetricActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5329772561082560256UL, 4327034269486253824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReportMetricActor, 0, StatusObject >;
friend struct ActorCallback< ReportMetricActor, 1, Void >;
friend struct ActorCallback< ReportMetricActor, 2, Void >;
friend struct ActorCallback< ReportMetricActor, 3, Void >;
															#line 436 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	ReportMetricActor(GetMappedRangeWorkload* const& self,Database const& cx) 
															#line 4016 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		 : Actor<Void>(),
		   ReportMetricActorState<ReportMetricActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("reportMetric", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17642107533830512128UL, 706139550601446144UL);
		ActorExecutionContextHelper __helper(static_cast<ReportMetricActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("reportMetric");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("reportMetric", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReportMetricActor, 0, StatusObject >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReportMetricActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ReportMetricActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ReportMetricActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 436 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
[[nodiscard]] static Future<Void> reportMetric( GetMappedRangeWorkload* const& self, Database const& cx ) {
															#line 436 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	return Future<Void>(new ReportMetricActor(self, cx));
															#line 4051 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
}

#line 476 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"

	// If the same transaction writes to the read set (the scanned ranges) before reading, it should throw read your
	// write exception.
																#line 4058 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
// This generated class is to be used only via testRYW()
															#line 479 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
template <class TestRYWActor>
															#line 479 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
class TestRYWActorState {
															#line 4064 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
public:
															#line 479 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	TestRYWActorState(GetMappedRangeWorkload* const& self) 
															#line 479 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
															#line 479 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		 : self(self)
															#line 4071 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
	{
		fdb_probe_actor_create("testRYW", reinterpret_cast<unsigned long>(this));

	}
	~TestRYWActorState() 
	{
		fdb_probe_actor_destroy("testRYW", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 480 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			std::cout << "testRYW" << std::endl;
															#line 481 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			;
															#line 4088 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestRYWActorState();
		static_cast<TestRYWActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 482 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		tr1 = self->createTransaction();
															#line 4118 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		try {
															#line 485 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			conflictWriteOnRecord(7, tr1, self);
															#line 486 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			StrictFuture<MappedRangeResult> __when_expr_0 = runGetMappedRange(5, 10, tr1, self);
															#line 486 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			if (static_cast<TestRYWActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4126 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestRYWActor*>(this)->actor_wait_state = 1;
															#line 486 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestRYWActor, 0, MappedRangeResult >*>(static_cast<TestRYWActor*>(this)));
															#line 4131 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 489 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			if (e.code() == error_code_get_mapped_range_reads_your_writes)
															#line 4153 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			{
															#line 490 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				std::cout << "tr1 failed because of read your writes (as expected)" << std::endl;
															#line 491 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				TraceEvent("GetMappedRangeWorkloadExpectedErrorDetected").error(e);
															#line 492 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				if (!static_cast<TestRYWActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestRYWActorState(); static_cast<TestRYWActor*>(this)->destroy(); return 0; }
															#line 4161 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
				new (&static_cast<TestRYWActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~TestRYWActorState();
				static_cast<TestRYWActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 494 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				std::cout << "tr1 error " << e.what() << std::endl;
															#line 495 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				StrictFuture<Void> __when_expr_1 = tr1->onError(e);
															#line 495 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				if (static_cast<TestRYWActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4175 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
				static_cast<TestRYWActor*>(this)->actor_wait_state = 2;
															#line 495 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestRYWActor, 1, Void >*>(static_cast<TestRYWActor*>(this)));
															#line 4180 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(MappedRangeResult const& result,int loopDepth) 
	{
															#line 487 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		UNREACHABLE();
															#line 4196 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(MappedRangeResult && result,int loopDepth) 
	{
															#line 487 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		UNREACHABLE();
															#line 4205 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(MappedRangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(MappedRangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestRYWActor*>(this)->actor_wait_state > 0) static_cast<TestRYWActor*>(this)->actor_wait_state = 0;
		static_cast<TestRYWActor*>(this)->ActorCallback< TestRYWActor, 0, MappedRangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TestRYWActor, 0, MappedRangeResult >*,MappedRangeResult const& value) 
	{
		fdb_probe_actor_enter("testRYW", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRYWActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRYW", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestRYWActor, 0, MappedRangeResult >*,MappedRangeResult && value) 
	{
		fdb_probe_actor_enter("testRYW", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRYWActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRYW", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestRYWActor, 0, MappedRangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("testRYW", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRYWActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRYW", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestRYWActor*>(this)->actor_wait_state > 0) static_cast<TestRYWActor*>(this)->actor_wait_state = 0;
		static_cast<TestRYWActor*>(this)->ActorCallback< TestRYWActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRYWActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRYW", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRYWActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRYW", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestRYWActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRYW", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRYWActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRYW", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestRYWActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRYW", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRYWActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRYW", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 479 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	GetMappedRangeWorkload* self;
															#line 482 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	Reference<TransactionWrapper> tr1;
															#line 4395 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
};
// This generated class is to be used only via testRYW()
															#line 479 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
class TestRYWActor final : public Actor<Void>, public ActorCallback< TestRYWActor, 0, MappedRangeResult >, public ActorCallback< TestRYWActor, 1, Void >, public FastAllocated<TestRYWActor>, public TestRYWActorState<TestRYWActor> {
															#line 4400 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
public:
	using FastAllocated<TestRYWActor>::operator new;
	using FastAllocated<TestRYWActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14153885262314791680UL, 11719116926007055616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestRYWActor, 0, MappedRangeResult >;
friend struct ActorCallback< TestRYWActor, 1, Void >;
															#line 479 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	TestRYWActor(GetMappedRangeWorkload* const& self) 
															#line 4418 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		 : Actor<Void>(),
		   TestRYWActorState<TestRYWActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testRYW", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2019677710635984896UL, 10033445823457257984UL);
		ActorExecutionContextHelper __helper(static_cast<TestRYWActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testRYW");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testRYW", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestRYWActor, 0, MappedRangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestRYWActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 479 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
[[nodiscard]] Future<Void> testRYW( GetMappedRangeWorkload* const& self ) {
															#line 479 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	return Future<Void>(new TestRYWActor(self));
															#line 4451 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
}

#line 500 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"

																#line 4456 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
// This generated class is to be used only via testMetric()
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
template <class TestMetricActor>
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
class TestMetricActorState {
															#line 4462 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
public:
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	TestMetricActorState(Database const& cx,GetMappedRangeWorkload* const& self,int const& beginId,int const& endId,Key const& mapper,int const& seconds) 
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		 : cx(cx),
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   self(self),
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   beginId(beginId),
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   endId(endId),
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   mapper(mapper),
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   seconds(seconds)
															#line 4479 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
	{
		fdb_probe_actor_create("testMetric", reinterpret_cast<unsigned long>(this));

	}
	~TestMetricActorState() 
	{
		fdb_probe_actor_destroy("testMetric", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 507 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			;
															#line 4494 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestMetricActorState();
		static_cast<TestMetricActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 508 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		StrictFuture<Void> __when_expr_0 = reportMetric(self, cx);
															#line 507 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (static_cast<TestMetricActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4526 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 512 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->submitSmallRequestIndefinitely(cx, 10, 490, mapper, self);
															#line 4530 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
															#line 516 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(seconds);
															#line 4534 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
		static_cast<TestMetricActor*>(this)->actor_wait_state = 1;
															#line 508 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestMetricActor, 0, Void >*>(static_cast<TestMetricActor*>(this)));
															#line 512 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestMetricActor, 1, Void >*>(static_cast<TestMetricActor*>(this)));
															#line 516 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestMetricActor, 2, Void >*>(static_cast<TestMetricActor*>(this)));
															#line 4543 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 509 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		TraceEvent(SevError, "Error: ReportMetric has ended");
															#line 510 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (!static_cast<TestMetricActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestMetricActorState(); static_cast<TestMetricActor*>(this)->destroy(); return 0; }
															#line 4554 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		new (&static_cast<TestMetricActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestMetricActorState();
		static_cast<TestMetricActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 509 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		TraceEvent(SevError, "Error: ReportMetric has ended");
															#line 510 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (!static_cast<TestMetricActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestMetricActorState(); static_cast<TestMetricActor*>(this)->destroy(); return 0; }
															#line 4568 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		new (&static_cast<TestMetricActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestMetricActorState();
		static_cast<TestMetricActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 513 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		TraceEvent(SevError, "Error: submitSmallRequestIndefinitely has ended");
															#line 514 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (!static_cast<TestMetricActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestMetricActorState(); static_cast<TestMetricActor*>(this)->destroy(); return 0; }
															#line 4582 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		new (&static_cast<TestMetricActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestMetricActorState();
		static_cast<TestMetricActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 513 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		TraceEvent(SevError, "Error: submitSmallRequestIndefinitely has ended");
															#line 514 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (!static_cast<TestMetricActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestMetricActorState(); static_cast<TestMetricActor*>(this)->destroy(); return 0; }
															#line 4596 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		new (&static_cast<TestMetricActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestMetricActorState();
		static_cast<TestMetricActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 517 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (!static_cast<TestMetricActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestMetricActorState(); static_cast<TestMetricActor*>(this)->destroy(); return 0; }
															#line 4608 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		new (&static_cast<TestMetricActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestMetricActorState();
		static_cast<TestMetricActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
															#line 517 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (!static_cast<TestMetricActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestMetricActorState(); static_cast<TestMetricActor*>(this)->destroy(); return 0; }
															#line 4620 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		new (&static_cast<TestMetricActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestMetricActorState();
		static_cast<TestMetricActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestMetricActor*>(this)->actor_wait_state > 0) static_cast<TestMetricActor*>(this)->actor_wait_state = 0;
		static_cast<TestMetricActor*>(this)->ActorCallback< TestMetricActor, 0, Void >::remove();
		static_cast<TestMetricActor*>(this)->ActorCallback< TestMetricActor, 1, Void >::remove();
		static_cast<TestMetricActor*>(this)->ActorCallback< TestMetricActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestMetricActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testMetric", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMetricActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMetric", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestMetricActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testMetric", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMetricActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMetric", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestMetricActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testMetric", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestMetricActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMetric", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestMetricActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testMetric", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMetricActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMetric", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestMetricActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testMetric", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMetricActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMetric", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestMetricActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testMetric", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestMetricActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMetric", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestMetricActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testMetric", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMetricActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMetric", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestMetricActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testMetric", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMetricActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMetric", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestMetricActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testMetric", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestMetricActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMetric", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	Database cx;
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	GetMappedRangeWorkload* self;
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	int beginId;
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	int endId;
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	Key mapper;
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	int seconds;
															#line 4819 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
};
// This generated class is to be used only via testMetric()
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
class TestMetricActor final : public Actor<Void>, public ActorCallback< TestMetricActor, 0, Void >, public ActorCallback< TestMetricActor, 1, Void >, public ActorCallback< TestMetricActor, 2, Void >, public FastAllocated<TestMetricActor>, public TestMetricActorState<TestMetricActor> {
															#line 4824 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
public:
	using FastAllocated<TestMetricActor>::operator new;
	using FastAllocated<TestMetricActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8400932399555375616UL, 13440529880162472448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestMetricActor, 0, Void >;
friend struct ActorCallback< TestMetricActor, 1, Void >;
friend struct ActorCallback< TestMetricActor, 2, Void >;
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	TestMetricActor(Database const& cx,GetMappedRangeWorkload* const& self,int const& beginId,int const& endId,Key const& mapper,int const& seconds) 
															#line 4843 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		 : Actor<Void>(),
		   TestMetricActorState<TestMetricActor>(cx, self, beginId, endId, mapper, seconds),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testMetric", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18153418762760033024UL, 18222253873660586496UL);
		ActorExecutionContextHelper __helper(static_cast<TestMetricActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testMetric");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testMetric", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestMetricActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
[[nodiscard]] static Future<Void> testMetric( Database const& cx, GetMappedRangeWorkload* const& self, int const& beginId, int const& endId, Key const& mapper, int const& seconds ) {
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	return Future<Void>(new TestMetricActor(cx, self, beginId, endId, mapper, seconds));
															#line 4875 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
}

#line 521 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"

																#line 4880 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 522 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
template <class _startActor>
															#line 522 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
class _startActorState {
															#line 4886 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
public:
															#line 522 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	_startActorState(Database const& cx,GetMappedRangeWorkload* const& self) 
															#line 522 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
															#line 522 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		 : cx(cx),
															#line 522 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		   self(self)
															#line 4895 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 523 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			TraceEvent("GetMappedRangeWorkloadConfig").detail("BadMapper", self->BAD_MAPPER);
															#line 526 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->fillInRecords(cx, 500, self);
															#line 526 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4914 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 526 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 4919 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 528 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (self->transactionType == NATIVE)
															#line 4942 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		{
															#line 529 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			self->snapshot = Snapshot::True;
															#line 4946 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			loopDepth = a_body1cont2(loopDepth);
		}
		else
		{
															#line 530 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			if (self->transactionType == READ_YOUR_WRITES)
															#line 4953 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			{
															#line 531 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				self->snapshot = Snapshot::False;
															#line 532 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				const double rand = deterministicRandom()->random01();
															#line 533 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				if (rand < 0.1)
															#line 4961 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
				{
															#line 534 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					StrictFuture<Void> __when_expr_1 = self->testSerializableConflicts(self);
															#line 534 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4967 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
					static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 534 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 4972 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 536 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					if (rand < 0.2)
															#line 4979 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
					{
															#line 537 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
						StrictFuture<Void> __when_expr_2 = self->testRYW(self);
															#line 537 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
						if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4985 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
						if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
						static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 537 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
						__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 4990 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
						loopDepth = a_body1cont8(loopDepth);
					}
				}
			}
			else
			{
															#line 543 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				UNREACHABLE();
															#line 5003 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
				loopDepth = a_body1cont4(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 528 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (self->transactionType == NATIVE)
															#line 5014 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		{
															#line 529 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			self->snapshot = Snapshot::True;
															#line 5018 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			loopDepth = a_body1cont2(loopDepth);
		}
		else
		{
															#line 530 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
			if (self->transactionType == READ_YOUR_WRITES)
															#line 5025 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
			{
															#line 531 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				self->snapshot = Snapshot::False;
															#line 532 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				const double rand = deterministicRandom()->random01();
															#line 533 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				if (rand < 0.1)
															#line 5033 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
				{
															#line 534 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					StrictFuture<Void> __when_expr_1 = self->testSerializableConflicts(self);
															#line 534 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5039 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
					static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 534 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 5044 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 536 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
					if (rand < 0.2)
															#line 5051 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
					{
															#line 537 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
						StrictFuture<Void> __when_expr_2 = self->testRYW(self);
															#line 537 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
						if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5057 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
						if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
						static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 537 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
						__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 5062 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
						loopDepth = a_body1cont8(loopDepth);
					}
				}
			}
			else
			{
															#line 543 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
				UNREACHABLE();
															#line 5075 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
				loopDepth = a_body1cont4(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 546 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		std::cout << "Test configuration: transactionType:" << self->transactionType << " snapshot:" << self->snapshot << "bad_mapper:" << self->BAD_MAPPER << std::endl;
															#line 549 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		mapper = getMapper(self, false);
															#line 552 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		originalStrictlyEnforeByteLimit = SERVER_KNOBS->STRICTLY_ENFORCE_BYTE_LIMIT;
															#line 553 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		(const_cast<ServerKnobs*> SERVER_KNOBS)->STRICTLY_ENFORCE_BYTE_LIMIT = deterministicRandom()->coinflip();
															#line 554 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->scanMappedRange(cx, 10, 490, mapper, self);
															#line 554 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5171 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 554 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 5176 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 535 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 5197 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 535 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 5209 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 538 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 5302 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 538 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 5314 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
															#line 555 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		StrictFuture<Void> __when_expr_4 = testMetric(cx, self, 10, 490, mapper, self->checkStorageQueueSeconds);
															#line 555 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5403 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont12when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 555 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 5408 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
															#line 555 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		StrictFuture<Void> __when_expr_4 = testMetric(cx, self, 10, 490, mapper, self->checkStorageQueueSeconds);
															#line 555 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5419 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont12when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 555 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 5424 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont12cont1(Void const& _,int loopDepth) 
	{
															#line 558 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		(const_cast<ServerKnobs*> SERVER_KNOBS)->STRICTLY_ENFORCE_BYTE_LIMIT = originalStrictlyEnforeByteLimit;
															#line 559 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 5510 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont1(Void && _,int loopDepth) 
	{
															#line 558 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		(const_cast<ServerKnobs*> SERVER_KNOBS)->STRICTLY_ENFORCE_BYTE_LIMIT = originalStrictlyEnforeByteLimit;
															#line 559 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 5524 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 522 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	Database cx;
															#line 522 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	GetMappedRangeWorkload* self;
															#line 549 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	Key mapper;
															#line 552 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	bool originalStrictlyEnforeByteLimit;
															#line 5615 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 522 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 5620 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9297938937871823616UL, 15730235045525023488UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
															#line 522 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	_startActor(Database const& cx,GetMappedRangeWorkload* const& self) 
															#line 5641 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 522 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, GetMappedRangeWorkload* const& self ) {
															#line 522 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 5677 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetMappedRange.actor.g.cpp"
}

#line 561 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/workloads/GetMappedRange.actor.cpp"

	static Key getMapper(GetMappedRangeWorkload* self, bool mapperForAllMissing) {
		Tuple mapperTuple;
		if (self->BAD_MAPPER) {
			mapperTuple << prefix << RECORD << "{K[xxx]}"_sr;
		} else {
			mapperTuple << prefix << RECORD << (mapperForAllMissing ? "{K[2]}"_sr : "{K[3]}"_sr);
			if (self->SPLIT_RECORDS) {
				mapperTuple << "{...}"_sr;
			}
		}
		Key mapper = mapperTuple.getDataAsStandalone();
		return mapper;
	}

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<GetMappedRangeWorkload> GetMappedRangeWorkloadFactory;
