#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
/*
 * tester.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cinttypes>
#include <filesystem>
#include <fstream>
#include <functional>
#include <istream>
#include <iterator>
#include <map>
#include <streambuf>
#include <numeric>

#include <fmt/ranges.h>
#include <toml.hpp>

#include "flow/ActorCollection.h"
#include "flow/DeterministicRandom.h"
#include "flow/Histogram.h"
#include "flow/ProcessEvents.h"
#include "fdbrpc/Locality.h"
#include "fdbrpc/SimulatorProcessInfo.h"
#include "fdbrpc/sim_validation.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/Audit.h"
#include "fdbclient/AuditUtils.actor.h"
#include "fdbclient/ClusterInterface.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbclient/DataDistributionConfig.actor.h"
#include "fdbserver/KnobProtectiveGroups.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/QuietDatabase.h"
#include "fdbclient/MonitorLeader.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/MoveKeys.actor.h"
#include "flow/Platform.h"

#include "flow/Trace.h"
#include "flow/actorcompiler.h" // This must be the last #include.

WorkloadContext::WorkloadContext() {}

WorkloadContext::WorkloadContext(const WorkloadContext& r)
  : options(r.options), clientId(r.clientId), clientCount(r.clientCount), sharedRandomNumber(r.sharedRandomNumber),
    dbInfo(r.dbInfo), ccr(r.ccr), defaultTenant(r.defaultTenant), rangesToCheck(r.rangesToCheck) {}

WorkloadContext::~WorkloadContext() {}

const char HEX_CHAR_LOOKUP[16] = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f' };

void emplaceIndex(uint8_t* data, int offset, int64_t index) {
	for (int i = 0; i < 16; i++) {
		data[(15 - i) + offset] = HEX_CHAR_LOOKUP[index & 0xf];
		index = index >> 4;
	}
}

Key doubleToTestKey(double p) {
	return StringRef(format("%016llx", *(uint64_t*)&p));
}

double testKeyToDouble(const KeyRef& p) {
	uint64_t x = 0;
	sscanf(p.toString().c_str(), "%" SCNx64, &x);
	return *(double*)&x;
}

Key doubleToTestKey(double p, const KeyRef& prefix) {
	return doubleToTestKey(p).withPrefix(prefix);
}

Key KVWorkload::getRandomKey() const {
	return getRandomKey(absentFrac);
}

Key KVWorkload::getRandomKey(double absentFrac) const {
	if (absentFrac > 0.0000001) {
		return getRandomKey(deterministicRandom()->random01() < absentFrac);
	} else {
		return getRandomKey(false);
	}
}

Key KVWorkload::getRandomKey(bool absent) const {
	return keyForIndex(deterministicRandom()->randomInt(0, nodeCount), absent);
}

Key KVWorkload::keyForIndex(uint64_t index) const {
	if (absentFrac > 0.0000001) {
		return keyForIndex(index, deterministicRandom()->random01() < absentFrac);
	} else {
		return keyForIndex(index, false);
	}
}

int64_t KVWorkload::indexForKey(const KeyRef& key, bool absent) const {
	int idx = 0;
	if (nodePrefix > 0) {
		ASSERT(keyBytes >= 32);
		idx += 16;
	}
	ASSERT(keyBytes >= 16);
	// extract int64_t index, the reverse process of emplaceIndex()
	auto end = key.size() - idx - (absent ? 1 : 0);
	std::string str((char*)key.begin() + idx, end);
	int64_t res = std::stoll(str, nullptr, 16);
	return res;
}

Key KVWorkload::keyForIndex(uint64_t index, bool absent) const {
	int adjustedKeyBytes = (absent) ? (keyBytes + 1) : keyBytes;
	Key result = makeString(adjustedKeyBytes);
	uint8_t* data = mutateString(result);
	memset(data, '.', adjustedKeyBytes);

	int idx = 0;
	if (nodePrefix > 0) {
		ASSERT(keyBytes >= 32);
		emplaceIndex(data, 0, nodePrefix);
		idx += 16;
	}
	ASSERT(keyBytes >= 16);
	emplaceIndex(data, idx, (int64_t)index);
	// ASSERT(indexForKey(result) == (int64_t)index); // debug assert

	return result;
}

double testKeyToDouble(const KeyRef& p, const KeyRef& prefix) {
	return testKeyToDouble(p.removePrefix(prefix));
}

															#line 157 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via poisson()
															#line 155 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class PoissonActor>
															#line 155 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class PoissonActorState {
															#line 164 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 155 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	PoissonActorState(double* const& last,double const& meanInterval) 
															#line 155 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 155 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : last(last),
															#line 155 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   meanInterval(meanInterval)
															#line 173 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("poisson", reinterpret_cast<unsigned long>(this));

	}
	~PoissonActorState() 
	{
		fdb_probe_actor_destroy("poisson", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 156 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			*last += meanInterval * -log(deterministicRandom()->random01());
															#line 157 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delayUntil(*last);
															#line 157 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<PoissonActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 192 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PoissonActor*>(this)->actor_wait_state = 1;
															#line 157 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PoissonActor, 0, Void >*>(static_cast<PoissonActor*>(this)));
															#line 197 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PoissonActorState();
		static_cast<PoissonActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 158 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<PoissonActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PoissonActorState(); static_cast<PoissonActor*>(this)->destroy(); return 0; }
															#line 220 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<PoissonActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PoissonActorState();
		static_cast<PoissonActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 158 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<PoissonActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PoissonActorState(); static_cast<PoissonActor*>(this)->destroy(); return 0; }
															#line 232 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<PoissonActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PoissonActorState();
		static_cast<PoissonActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PoissonActor*>(this)->actor_wait_state > 0) static_cast<PoissonActor*>(this)->actor_wait_state = 0;
		static_cast<PoissonActor*>(this)->ActorCallback< PoissonActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PoissonActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("poisson", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PoissonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("poisson", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PoissonActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("poisson", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PoissonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("poisson", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PoissonActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("poisson", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PoissonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("poisson", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 155 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double* last;
															#line 155 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double meanInterval;
															#line 319 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via poisson()
															#line 155 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class PoissonActor final : public Actor<Void>, public ActorCallback< PoissonActor, 0, Void >, public FastAllocated<PoissonActor>, public PoissonActorState<PoissonActor> {
															#line 324 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<PoissonActor>::operator new;
	using FastAllocated<PoissonActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6192648830915381248UL, 12801023721750967040UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PoissonActor, 0, Void >;
															#line 155 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	PoissonActor(double* const& last,double const& meanInterval) 
															#line 341 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<Void>(),
		   PoissonActorState<PoissonActor>(last, meanInterval),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("poisson", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(372770731710592768UL, 4255548564490349312UL);
		ActorExecutionContextHelper __helper(static_cast<PoissonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("poisson");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("poisson", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PoissonActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 155 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> poisson( double* const& last, double const& meanInterval ) {
															#line 155 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new PoissonActor(last, meanInterval));
															#line 374 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 160 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 379 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via uniform()
															#line 161 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class UniformActor>
															#line 161 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class UniformActorState {
															#line 386 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 161 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	UniformActorState(double* const& last,double const& meanInterval) 
															#line 161 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 161 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : last(last),
															#line 161 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   meanInterval(meanInterval)
															#line 395 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("uniform", reinterpret_cast<unsigned long>(this));

	}
	~UniformActorState() 
	{
		fdb_probe_actor_destroy("uniform", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 162 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			*last += meanInterval;
															#line 163 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delayUntil(*last);
															#line 163 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<UniformActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 414 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UniformActor*>(this)->actor_wait_state = 1;
															#line 163 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UniformActor, 0, Void >*>(static_cast<UniformActor*>(this)));
															#line 419 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UniformActorState();
		static_cast<UniformActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 164 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<UniformActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UniformActorState(); static_cast<UniformActor*>(this)->destroy(); return 0; }
															#line 442 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<UniformActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UniformActorState();
		static_cast<UniformActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 164 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<UniformActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UniformActorState(); static_cast<UniformActor*>(this)->destroy(); return 0; }
															#line 454 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<UniformActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UniformActorState();
		static_cast<UniformActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UniformActor*>(this)->actor_wait_state > 0) static_cast<UniformActor*>(this)->actor_wait_state = 0;
		static_cast<UniformActor*>(this)->ActorCallback< UniformActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UniformActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("uniform", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UniformActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uniform", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UniformActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("uniform", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UniformActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uniform", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UniformActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("uniform", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UniformActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uniform", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 161 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double* last;
															#line 161 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double meanInterval;
															#line 541 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via uniform()
															#line 161 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class UniformActor final : public Actor<Void>, public ActorCallback< UniformActor, 0, Void >, public FastAllocated<UniformActor>, public UniformActorState<UniformActor> {
															#line 546 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<UniformActor>::operator new;
	using FastAllocated<UniformActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10066849917457195264UL, 674082408048162048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UniformActor, 0, Void >;
															#line 161 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	UniformActor(double* const& last,double const& meanInterval) 
															#line 563 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<Void>(),
		   UniformActorState<UniformActor>(last, meanInterval),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("uniform", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4516370186399252992UL, 2038132372127671808UL);
		ActorExecutionContextHelper __helper(static_cast<UniformActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("uniform");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("uniform", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UniformActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 161 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> uniform( double* const& last, double const& meanInterval ) {
															#line 161 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new UniformActor(last, meanInterval));
															#line 596 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 166 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

Value getOption(VectorRef<KeyValueRef> options, Key key, Value defaultValue) {
	for (int i = 0; i < options.size(); i++)
		if (options[i].key == key) {
			Value value = options[i].value;
			options[i].value = ""_sr;
			return value;
		}

	return defaultValue;
}

int getOption(VectorRef<KeyValueRef> options, Key key, int defaultValue) {
	for (int i = 0; i < options.size(); i++)
		if (options[i].key == key) {
			int r;
			if (sscanf(options[i].value.toString().c_str(), "%d", &r)) {
				options[i].value = ""_sr;
				return r;
			} else {
				TraceEvent(SevError, "InvalidTestOption").detail("OptionName", key);
				throw test_specification_invalid();
			}
		}

	return defaultValue;
}

uint64_t getOption(VectorRef<KeyValueRef> options, Key key, uint64_t defaultValue) {
	for (int i = 0; i < options.size(); i++)
		if (options[i].key == key) {
			uint64_t r;
			if (sscanf(options[i].value.toString().c_str(), "%" SCNd64, &r)) {
				options[i].value = ""_sr;
				return r;
			} else {
				TraceEvent(SevError, "InvalidTestOption").detail("OptionName", key);
				throw test_specification_invalid();
			}
		}

	return defaultValue;
}

int64_t getOption(VectorRef<KeyValueRef> options, Key key, int64_t defaultValue) {
	for (int i = 0; i < options.size(); i++)
		if (options[i].key == key) {
			int64_t r;
			if (sscanf(options[i].value.toString().c_str(), "%" SCNd64, &r)) {
				options[i].value = ""_sr;
				return r;
			} else {
				TraceEvent(SevError, "InvalidTestOption").detail("OptionName", key);
				throw test_specification_invalid();
			}
		}

	return defaultValue;
}

double getOption(VectorRef<KeyValueRef> options, Key key, double defaultValue) {
	for (int i = 0; i < options.size(); i++)
		if (options[i].key == key) {
			float r;
			if (sscanf(options[i].value.toString().c_str(), "%f", &r)) {
				options[i].value = ""_sr;
				return r;
			}
		}

	return defaultValue;
}

bool getOption(VectorRef<KeyValueRef> options, Key key, bool defaultValue) {
	Value p = getOption(options, key, defaultValue ? "true"_sr : "false"_sr);
	if (p == "true"_sr)
		return true;
	if (p == "false"_sr)
		return false;
	ASSERT(false);
	return false; // Assure that compiler is fine with the function
}

std::vector<std::string> getOption(VectorRef<KeyValueRef> options, Key key, std::vector<std::string> defaultValue) {
	for (int i = 0; i < options.size(); i++)
		if (options[i].key == key) {
			std::vector<std::string> v;
			int begin = 0;
			for (int c = 0; c < options[i].value.size(); c++)
				if (options[i].value[c] == ',') {
					v.push_back(options[i].value.substr(begin, c - begin).toString());
					begin = c + 1;
				}
			v.push_back(options[i].value.substr(begin).toString());
			options[i].value = ""_sr;
			return v;
		}
	return defaultValue;
}

std::vector<int> getOption(VectorRef<KeyValueRef> options, Key key, std::vector<int> defaultValue) {
	for (int i = 0; i < options.size(); i++)
		if (options[i].key == key) {
			std::vector<int> v;
			int begin = 0;
			for (int c = 0; c < options[i].value.size(); c++)
				if (options[i].value[c] == ',') {
					v.push_back(atoi((char*)options[i].value.begin() + begin));
					begin = c + 1;
				}
			v.push_back(atoi((char*)options[i].value.begin() + begin));
			options[i].value = ""_sr;
			return v;
		}
	return defaultValue;
}

bool hasOption(VectorRef<KeyValueRef> options, Key key) {
	for (const auto& option : options) {
		if (option.key == key) {
			return true;
		}
	}
	return false;
}

// returns unconsumed options
Standalone<VectorRef<KeyValueRef>> checkAllOptionsConsumed(VectorRef<KeyValueRef> options) {
	static StringRef nothing = ""_sr;
	Standalone<VectorRef<KeyValueRef>> unconsumed;
	for (int i = 0; i < options.size(); i++)
		if (!(options[i].value == nothing)) {
			TraceEvent(SevError, "OptionNotConsumed")
			    .detail("Key", options[i].key.toString().c_str())
			    .detail("Value", options[i].value.toString().c_str());
			unconsumed.push_back_deep(unconsumed.arena(), options[i]);
		}
	return unconsumed;
}

CompoundWorkload::CompoundWorkload(WorkloadContext& wcx) : TestWorkload(wcx) {}

CompoundWorkload* CompoundWorkload::add(Reference<TestWorkload>&& w) {
	workloads.push_back(std::move(w));
	return this;
}

std::string CompoundWorkload::description() const {
	std::vector<std::string> names;
	names.reserve(workloads.size());
	for (auto const& w : workloads) {
		names.push_back(w->description());
	}
	return fmt::format("{}", fmt::join(std::move(names), ";"));
}
Future<Void> CompoundWorkload::setup(Database const& cx) {
	std::vector<Future<Void>> all;
	all.reserve(workloads.size());
	for (int w = 0; w < workloads.size(); w++)
		all.push_back(workloads[w]->setup(cx));
	auto done = waitForAll(all);
	if (failureInjection.empty()) {
		return done;
	}
	std::vector<Future<Void>> res;
	res.reserve(failureInjection.size());
	for (auto& f : failureInjection) {
		res.push_back(f->setupInjectionWorkload(cx, done));
	}
	return waitForAll(res);
}

Future<Void> CompoundWorkload::start(Database const& cx) {
	std::vector<Future<Void>> all;
	all.reserve(workloads.size() + failureInjection.size());
	auto wCount = std::make_shared<unsigned>(0);
	auto startWorkload = [&](TestWorkload& workload) -> Future<Void> {
		auto workloadName = workload.description();
		++(*wCount);
		TraceEvent("WorkloadRunStatus").detail("Name", workloadName).detail("Count", *wCount).detail("Phase", "Start");
		return fmap(
		    [workloadName, wCount](Void value) {
			    --(*wCount);
			    TraceEvent("WorkloadRunStatus")
			        .detail("Name", workloadName)
			        .detail("Remaining", *wCount)
			        .detail("Phase", "End");
			    return Void();
		    },
		    workload.start(cx));
	};
	for (auto& workload : workloads) {
		all.push_back(startWorkload(*workload));
	}
	for (auto& workload : failureInjection) {
		all.push_back(startWorkload(*workload));
	}
	return waitForAll(all);
}

Future<bool> CompoundWorkload::check(Database const& cx) {
	std::vector<Future<bool>> all;
	all.reserve(workloads.size() + failureInjection.size());
	auto wCount = std::make_shared<unsigned>(0);
	auto starter = [&](TestWorkload& workload) -> Future<bool> {
		++(*wCount);
		std::string workloadName = workload.description();
		TraceEvent("WorkloadCheckStatus")
		    .detail("Name", workloadName)
		    .detail("Count", *wCount)
		    .detail("Phase", "Start");
		return fmap(
		    [workloadName, wCount](bool ret) {
			    --(*wCount);
			    TraceEvent("WorkloadCheckStatus")
			        .detail("Name", workloadName)
			        .detail("Remaining", *wCount)
			        .detail("Phase", "End");
			    return ret;
		    },
		    workload.check(cx));
	};
	for (auto& workload : workloads) {
		all.push_back(starter(*workload));
	}
	for (auto& workload : failureInjection) {
		all.push_back(starter(*workload));
	}
	return allTrue(all);
}

															#line 831 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via getMetricsCompoundWorkload()
															#line 397 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class GetMetricsCompoundWorkloadActor>
															#line 397 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class GetMetricsCompoundWorkloadActorState {
															#line 838 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 397 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	GetMetricsCompoundWorkloadActorState(CompoundWorkload* const& self) 
															#line 397 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 397 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : self(self),
															#line 398 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   results()
															#line 847 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("getMetricsCompoundWorkload", reinterpret_cast<unsigned long>(this));

	}
	~GetMetricsCompoundWorkloadActorState() 
	{
		fdb_probe_actor_destroy("getMetricsCompoundWorkload", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 399 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for(int w = 0;w < self->workloads.size();w++) {
															#line 400 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				std::vector<PerfMetric> p;
															#line 401 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				results.push_back(self->workloads[w]->getMetrics());
															#line 866 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 403 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(results);
															#line 403 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<GetMetricsCompoundWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 872 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetMetricsCompoundWorkloadActor*>(this)->actor_wait_state = 1;
															#line 403 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetMetricsCompoundWorkloadActor, 0, Void >*>(static_cast<GetMetricsCompoundWorkloadActor*>(this)));
															#line 877 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetMetricsCompoundWorkloadActorState();
		static_cast<GetMetricsCompoundWorkloadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 404 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		std::vector<PerfMetric> res;
															#line 405 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < results.size();++i) {
															#line 406 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			auto const& p = results[i].get();
															#line 407 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for( auto const& m : p ) {
															#line 408 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				res.push_back(m.withPrefix(self->workloads[i]->description() + "."));
															#line 908 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
		}
															#line 411 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<GetMetricsCompoundWorkloadActor*>(this)->SAV<std::vector<PerfMetric>>::futures) { (void)(res); this->~GetMetricsCompoundWorkloadActorState(); static_cast<GetMetricsCompoundWorkloadActor*>(this)->destroy(); return 0; }
															#line 913 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<GetMetricsCompoundWorkloadActor*>(this)->SAV< std::vector<PerfMetric> >::value()) std::vector<PerfMetric>(res);
		this->~GetMetricsCompoundWorkloadActorState();
		static_cast<GetMetricsCompoundWorkloadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 404 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		std::vector<PerfMetric> res;
															#line 405 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < results.size();++i) {
															#line 406 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			auto const& p = results[i].get();
															#line 407 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for( auto const& m : p ) {
															#line 408 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				res.push_back(m.withPrefix(self->workloads[i]->description() + "."));
															#line 933 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
		}
															#line 411 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<GetMetricsCompoundWorkloadActor*>(this)->SAV<std::vector<PerfMetric>>::futures) { (void)(res); this->~GetMetricsCompoundWorkloadActorState(); static_cast<GetMetricsCompoundWorkloadActor*>(this)->destroy(); return 0; }
															#line 938 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<GetMetricsCompoundWorkloadActor*>(this)->SAV< std::vector<PerfMetric> >::value()) std::vector<PerfMetric>(res);
		this->~GetMetricsCompoundWorkloadActorState();
		static_cast<GetMetricsCompoundWorkloadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetMetricsCompoundWorkloadActor*>(this)->actor_wait_state > 0) static_cast<GetMetricsCompoundWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<GetMetricsCompoundWorkloadActor*>(this)->ActorCallback< GetMetricsCompoundWorkloadActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetMetricsCompoundWorkloadActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getMetricsCompoundWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMetricsCompoundWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMetricsCompoundWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetMetricsCompoundWorkloadActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getMetricsCompoundWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMetricsCompoundWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMetricsCompoundWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetMetricsCompoundWorkloadActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getMetricsCompoundWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetMetricsCompoundWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMetricsCompoundWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 397 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	CompoundWorkload* self;
															#line 398 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<Future<std::vector<PerfMetric>>> results;
															#line 1025 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via getMetricsCompoundWorkload()
															#line 397 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class GetMetricsCompoundWorkloadActor final : public Actor<std::vector<PerfMetric>>, public ActorCallback< GetMetricsCompoundWorkloadActor, 0, Void >, public FastAllocated<GetMetricsCompoundWorkloadActor>, public GetMetricsCompoundWorkloadActorState<GetMetricsCompoundWorkloadActor> {
															#line 1030 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<GetMetricsCompoundWorkloadActor>::operator new;
	using FastAllocated<GetMetricsCompoundWorkloadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9977906494226188544UL, 14697250088748575232UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<PerfMetric>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetMetricsCompoundWorkloadActor, 0, Void >;
															#line 397 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	GetMetricsCompoundWorkloadActor(CompoundWorkload* const& self) 
															#line 1047 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<std::vector<PerfMetric>>(),
		   GetMetricsCompoundWorkloadActorState<GetMetricsCompoundWorkloadActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getMetricsCompoundWorkload", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3322871087501164032UL, 10981941028814264320UL);
		ActorExecutionContextHelper __helper(static_cast<GetMetricsCompoundWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getMetricsCompoundWorkload");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getMetricsCompoundWorkload", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetMetricsCompoundWorkloadActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 397 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<std::vector<PerfMetric>> getMetricsCompoundWorkload( CompoundWorkload* const& self ) {
															#line 397 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<std::vector<PerfMetric>>(new GetMetricsCompoundWorkloadActor(self));
															#line 1080 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 413 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

void CompoundWorkload::addFailureInjection(WorkloadRequest& work) {
	if (!work.runFailureWorkloads) {
		return;
	}
	// Some workloads won't work with some failure injection workloads
	std::set<std::string> disabledWorkloads;
	for (auto const& w : workloads) {
		w->disableFailureInjectionWorkloads(disabledWorkloads);
	}
	if (disabledWorkloads.contains("all")) {
		return;
	}
	auto& factories = IFailureInjectorFactory::factories();
	DeterministicRandom random(sharedRandomNumber);
	for (auto& factory : factories) {
		auto workload = factory->create(*this);
		if (disabledWorkloads.contains(workload->description())) {
			continue;
		}
		if (std::find(work.disabledFailureInjectionWorkloads.begin(),
		              work.disabledFailureInjectionWorkloads.end(),
		              workload->description()) != work.disabledFailureInjectionWorkloads.end()) {
			continue;
		}
		while (shouldInjectFailure(random, work, workload)) {
			workload->initFailureInjectionMode(random);
			TraceEvent("AddFailureInjectionWorkload")
			    .detail("Name", workload->description())
			    .detail("ClientID", work.clientId)
			    .detail("ClientCount", clientCount)
			    .detail("Title", work.title);
			failureInjection.push_back(workload);
			workload = factory->create(*this);
		}
	}
}

bool CompoundWorkload::shouldInjectFailure(DeterministicRandom& random,
                                           const WorkloadRequest& work,
                                           Reference<FailureInjectionWorkload> failure) const {
	auto desc = failure->description();
	unsigned alreadyAdded =
	    std::count_if(workloads.begin(), workloads.end(), [&desc](auto const& w) { return w->description() == desc; });
	alreadyAdded += std::count_if(
	    failureInjection.begin(), failureInjection.end(), [&desc](auto const& w) { return w->description() == desc; });
	return failure->shouldInject(random, work, alreadyAdded);
}

Future<std::vector<PerfMetric>> CompoundWorkload::getMetrics() {
	return getMetricsCompoundWorkload(this);
}

double CompoundWorkload::getCheckTimeout() const {
	double m = 0;
	for (int w = 0; w < workloads.size(); w++)
		m = std::max(workloads[w]->getCheckTimeout(), m);
	return m;
}

void CompoundWorkload::getMetrics(std::vector<PerfMetric>&) {
	ASSERT(false);
}

void TestWorkload::disableFailureInjectionWorkloads(std::set<std::string>& out) const {}

FailureInjectionWorkload::FailureInjectionWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {}

void FailureInjectionWorkload::initFailureInjectionMode(DeterministicRandom& random) {}

bool FailureInjectionWorkload::shouldInject(DeterministicRandom& random,
                                            const WorkloadRequest& work,
                                            const unsigned alreadyAdded) const {
	return alreadyAdded < 3 && work.useDatabase && 0.1 / (1 + alreadyAdded) > random.random01();
}

Future<Void> FailureInjectionWorkload::setupInjectionWorkload(const Database& cx, Future<Void> done) {
	return holdWhile(this->setup(cx), done);
}

Future<Void> FailureInjectionWorkload::startInjectionWorkload(const Database& cx, Future<Void> done) {
	return holdWhile(this->start(cx), done);
}

Future<bool> FailureInjectionWorkload::checkInjectionWorkload(const Database& cx, Future<bool> done) {
	return holdWhile(this->check(cx), done);
}

															#line 1172 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via getWorkloadIface()
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class GetWorkloadIfaceActor>
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class GetWorkloadIfaceActorState {
															#line 1179 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	GetWorkloadIfaceActorState(WorkloadRequest const& work,Reference<IClusterConnectionRecord> const& ccr,VectorRef<KeyValueRef> const& options,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : work(work),
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   ccr(ccr),
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   options(options),
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   dbInfo(dbInfo),
															#line 505 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   workload(),
															#line 506 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   testName(getOption(options, "testName"_sr, "no-test-specified"_sr))
															#line 1196 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("getWorkloadIface", reinterpret_cast<unsigned long>(this));

	}
	~GetWorkloadIfaceActorState() 
	{
		fdb_probe_actor_destroy("getWorkloadIface", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 507 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			WorkloadContext wcx;
															#line 508 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.clientId = work.clientId;
															#line 509 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.clientCount = work.clientCount;
															#line 510 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.ccr = ccr;
															#line 511 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.dbInfo = dbInfo;
															#line 512 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.options = options;
															#line 513 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.sharedRandomNumber = work.sharedRandomNumber;
															#line 514 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.defaultTenant = work.defaultTenant.castTo<TenantName>();
															#line 515 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.rangesToCheck = work.rangesToCheck;
															#line 517 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			workload = IWorkloadFactory::create(testName.toString(), wcx);
															#line 518 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (workload)
															#line 1231 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 519 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_0 = workload->initialized();
															#line 519 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<GetWorkloadIfaceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1237 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetWorkloadIfaceActor*>(this)->actor_wait_state = 1;
															#line 519 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetWorkloadIfaceActor, 0, Void >*>(static_cast<GetWorkloadIfaceActor*>(this)));
															#line 1242 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetWorkloadIfaceActorState();
		static_cast<GetWorkloadIfaceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 522 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auto unconsumedOptions = checkAllOptionsConsumed(workload ? workload->options : VectorRef<KeyValueRef>());
															#line 523 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!workload || unconsumedOptions.size())
															#line 1272 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 524 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent evt(SevError, "TestCreationError");
															#line 525 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			evt.detail("TestName", testName);
															#line 526 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (!workload)
															#line 1280 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 527 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				evt.detail("Reason", "Null workload");
															#line 528 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				fprintf(stderr, "ERROR: Workload could not be created, perhaps testName (%s) is not a valid workload\n", printable(testName).c_str());
															#line 1286 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
			else
			{
															#line 532 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				evt.detail("Reason", "Not all options consumed");
															#line 533 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				fprintf(stderr, "ERROR: Workload had invalid options. The following were unrecognized:\n");
															#line 534 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				for(int i = 0;i < unconsumedOptions.size();i++) {
															#line 535 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					fprintf(stderr, " '%s' = '%s'\n", unconsumedOptions[i].key.toString().c_str(), unconsumedOptions[i].value.toString().c_str());
															#line 1298 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				}
			}
															#line 540 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			return a_body1Catch1(test_specification_invalid(), loopDepth);
															#line 1303 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 542 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<GetWorkloadIfaceActor*>(this)->SAV<Reference<TestWorkload>>::futures) { (void)(workload); this->~GetWorkloadIfaceActorState(); static_cast<GetWorkloadIfaceActor*>(this)->destroy(); return 0; }
															#line 1307 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<GetWorkloadIfaceActor*>(this)->SAV< Reference<TestWorkload> >::value()) Reference<TestWorkload>(std::move(workload)); // state_var_RVO
		this->~GetWorkloadIfaceActorState();
		static_cast<GetWorkloadIfaceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetWorkloadIfaceActor*>(this)->actor_wait_state > 0) static_cast<GetWorkloadIfaceActor*>(this)->actor_wait_state = 0;
		static_cast<GetWorkloadIfaceActor*>(this)->ActorCallback< GetWorkloadIfaceActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetWorkloadIfaceActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getWorkloadIface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkloadIfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkloadIface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetWorkloadIfaceActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getWorkloadIface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkloadIfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkloadIface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetWorkloadIfaceActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getWorkloadIface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkloadIfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkloadIface", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	WorkloadRequest work;
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<IClusterConnectionRecord> ccr;
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	VectorRef<KeyValueRef> options;
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 505 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<TestWorkload> workload;
															#line 506 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Value testName;
															#line 1414 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via getWorkloadIface()
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class GetWorkloadIfaceActor final : public Actor<Reference<TestWorkload>>, public ActorCallback< GetWorkloadIfaceActor, 0, Void >, public FastAllocated<GetWorkloadIfaceActor>, public GetWorkloadIfaceActorState<GetWorkloadIfaceActor> {
															#line 1419 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<GetWorkloadIfaceActor>::operator new;
	using FastAllocated<GetWorkloadIfaceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8283544488474969088UL, 4228094200812724224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<TestWorkload>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetWorkloadIfaceActor, 0, Void >;
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	GetWorkloadIfaceActor(WorkloadRequest const& work,Reference<IClusterConnectionRecord> const& ccr,VectorRef<KeyValueRef> const& options,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 1436 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<Reference<TestWorkload>>(),
		   GetWorkloadIfaceActorState<GetWorkloadIfaceActor>(work, ccr, options, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getWorkloadIface", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11963719953278435840UL, 7704475868573170176UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkloadIfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getWorkloadIface");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getWorkloadIface", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetWorkloadIfaceActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Reference<TestWorkload>> getWorkloadIface( WorkloadRequest const& work, Reference<IClusterConnectionRecord> const& ccr, VectorRef<KeyValueRef> const& options, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Reference<TestWorkload>>(new GetWorkloadIfaceActor(work, ccr, options, dbInfo));
															#line 1469 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 544 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 1474 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via getWorkloadIface()
															#line 545 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class GetWorkloadIfaceActor1>
															#line 545 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class GetWorkloadIfaceActor1State {
															#line 1481 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 545 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	GetWorkloadIfaceActor1State(WorkloadRequest const& work,Reference<IClusterConnectionRecord> const& ccr,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 545 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 545 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : work(work),
															#line 545 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   ccr(ccr),
															#line 545 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   dbInfo(dbInfo),
															#line 548 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   wcx(),
															#line 549 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   ifaces()
															#line 1496 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("getWorkloadIface", reinterpret_cast<unsigned long>(this));

	}
	~GetWorkloadIfaceActor1State() 
	{
		fdb_probe_actor_destroy("getWorkloadIface", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 550 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (work.options.size() < 1)
															#line 1511 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 551 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent(SevError, "TestCreationError").detail("Reason", "No options provided");
															#line 552 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				fprintf(stderr, "ERROR: No options were provided for workload.\n");
															#line 553 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				return a_body1Catch1(test_specification_invalid(), loopDepth);
															#line 1519 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 556 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.clientId = work.clientId;
															#line 557 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.clientCount = work.clientCount;
															#line 558 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.sharedRandomNumber = work.sharedRandomNumber;
															#line 559 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.ccr = ccr;
															#line 560 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.dbInfo = dbInfo;
															#line 561 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.defaultTenant = work.defaultTenant.castTo<TenantName>();
															#line 562 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.rangesToCheck = work.rangesToCheck;
															#line 565 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for(int i = 0;i < work.options.size();i++) {
															#line 566 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				ifaces.push_back(getWorkloadIface(work, ccr, work.options[i], dbInfo));
															#line 1539 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 568 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(ifaces);
															#line 568 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<GetWorkloadIfaceActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1545 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetWorkloadIfaceActor1*>(this)->actor_wait_state = 1;
															#line 568 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetWorkloadIfaceActor1, 0, Void >*>(static_cast<GetWorkloadIfaceActor1*>(this)));
															#line 1550 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetWorkloadIfaceActor1State();
		static_cast<GetWorkloadIfaceActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 569 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auto compound = makeReference<CompoundWorkload>(wcx);
															#line 570 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < work.options.size();i++) {
															#line 571 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			compound->add(ifaces[i].getValue());
															#line 1577 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 573 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		compound->addFailureInjection(work);
															#line 574 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<GetWorkloadIfaceActor1*>(this)->SAV<Reference<TestWorkload>>::futures) { (void)(compound); this->~GetWorkloadIfaceActor1State(); static_cast<GetWorkloadIfaceActor1*>(this)->destroy(); return 0; }
															#line 1583 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<GetWorkloadIfaceActor1*>(this)->SAV< Reference<TestWorkload> >::value()) Reference<TestWorkload>(compound);
		this->~GetWorkloadIfaceActor1State();
		static_cast<GetWorkloadIfaceActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 569 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auto compound = makeReference<CompoundWorkload>(wcx);
															#line 570 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < work.options.size();i++) {
															#line 571 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			compound->add(ifaces[i].getValue());
															#line 1599 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 573 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		compound->addFailureInjection(work);
															#line 574 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<GetWorkloadIfaceActor1*>(this)->SAV<Reference<TestWorkload>>::futures) { (void)(compound); this->~GetWorkloadIfaceActor1State(); static_cast<GetWorkloadIfaceActor1*>(this)->destroy(); return 0; }
															#line 1605 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<GetWorkloadIfaceActor1*>(this)->SAV< Reference<TestWorkload> >::value()) Reference<TestWorkload>(compound);
		this->~GetWorkloadIfaceActor1State();
		static_cast<GetWorkloadIfaceActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetWorkloadIfaceActor1*>(this)->actor_wait_state > 0) static_cast<GetWorkloadIfaceActor1*>(this)->actor_wait_state = 0;
		static_cast<GetWorkloadIfaceActor1*>(this)->ActorCallback< GetWorkloadIfaceActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetWorkloadIfaceActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getWorkloadIface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkloadIfaceActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkloadIface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetWorkloadIfaceActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getWorkloadIface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkloadIfaceActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkloadIface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetWorkloadIfaceActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getWorkloadIface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkloadIfaceActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkloadIface", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 545 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	WorkloadRequest work;
															#line 545 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<IClusterConnectionRecord> ccr;
															#line 545 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 548 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	WorkloadContext wcx;
															#line 549 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<Future<Reference<TestWorkload>>> ifaces;
															#line 1698 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via getWorkloadIface()
															#line 545 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class GetWorkloadIfaceActor1 final : public Actor<Reference<TestWorkload>>, public ActorCallback< GetWorkloadIfaceActor1, 0, Void >, public FastAllocated<GetWorkloadIfaceActor1>, public GetWorkloadIfaceActor1State<GetWorkloadIfaceActor1> {
															#line 1703 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<GetWorkloadIfaceActor1>::operator new;
	using FastAllocated<GetWorkloadIfaceActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8283544488474969088UL, 4228094200812724224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<TestWorkload>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetWorkloadIfaceActor1, 0, Void >;
															#line 545 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	GetWorkloadIfaceActor1(WorkloadRequest const& work,Reference<IClusterConnectionRecord> const& ccr,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 1720 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<Reference<TestWorkload>>(),
		   GetWorkloadIfaceActor1State<GetWorkloadIfaceActor1>(work, ccr, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getWorkloadIface", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5911781519368835840UL, 7249850539022595328UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkloadIfaceActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getWorkloadIface");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getWorkloadIface", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetWorkloadIfaceActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 545 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Reference<TestWorkload>> getWorkloadIface( WorkloadRequest const& work, Reference<IClusterConnectionRecord> const& ccr, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 545 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Reference<TestWorkload>>(new GetWorkloadIfaceActor1(work, ccr, dbInfo));
															#line 1753 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 576 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

/**
 * Only works in simulation. This method prints all simulated processes in a human readable form to stdout. It groups
 * processes by data center, data hall, zone, and machine (in this order).
 */
void printSimulatedTopology() {
	if (!g_network->isSimulated()) {
		return;
	}
	auto processes = g_simulator->getAllProcesses();
	std::sort(processes.begin(), processes.end(), [](ISimulator::ProcessInfo* lhs, ISimulator::ProcessInfo* rhs) {
		auto l = lhs->locality;
		auto r = rhs->locality;
		if (l.dcId() != r.dcId()) {
			return l.dcId() < r.dcId();
		}
		if (l.dataHallId() != r.dataHallId()) {
			return l.dataHallId() < r.dataHallId();
		}
		if (l.zoneId() != r.zoneId()) {
			return l.zoneId() < r.zoneId();
		}
		if (l.machineId() != r.zoneId()) {
			return l.machineId() < r.machineId();
		}
		return lhs->address < rhs->address;
	});
	printf("Simulated Cluster Topology:\n");
	printf("===========================\n");
	Optional<Standalone<StringRef>> dcId, dataHallId, zoneId, machineId;
	for (auto p : processes) {
		std::string indent = "";
		if (dcId != p->locality.dcId()) {
			dcId = p->locality.dcId();
			printf("%sdcId: %s\n", indent.c_str(), p->locality.describeDcId().c_str());
		}
		indent += "  ";
		if (dataHallId != p->locality.dataHallId()) {
			dataHallId = p->locality.dataHallId();
			printf("%sdataHallId: %s\n", indent.c_str(), p->locality.describeDataHall().c_str());
		}
		indent += "  ";
		if (zoneId != p->locality.zoneId()) {
			zoneId = p->locality.zoneId();
			printf("%szoneId: %s\n", indent.c_str(), p->locality.describeZone().c_str());
		}
		indent += "  ";
		if (machineId != p->locality.machineId()) {
			machineId = p->locality.machineId();
			printf("%smachineId: %s\n", indent.c_str(), p->locality.describeMachineId().c_str());
		}
		indent += "  ";
		printf("%sAddress: %s\n", indent.c_str(), p->address.toString().c_str());
		indent += "  ";
		printf("%sClass: %s\n", indent.c_str(), p->startingClass.toString().c_str());
		printf("%sName: %s\n", indent.c_str(), p->name.c_str());
	}
}

															#line 1816 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via databaseWarmer()
															#line 635 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class DatabaseWarmerActor>
															#line 635 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class DatabaseWarmerActorState {
															#line 1823 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 635 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	DatabaseWarmerActorState(Database const& cx) 
															#line 635 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 635 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cx(cx)
															#line 1830 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("databaseWarmer", reinterpret_cast<unsigned long>(this));

	}
	~DatabaseWarmerActorState() 
	{
		fdb_probe_actor_destroy("databaseWarmer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 636 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 1845 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DatabaseWarmerActorState();
		static_cast<DatabaseWarmerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 637 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		tr = Transaction(cx);
															#line 638 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_0 = success(tr.getReadVersion());
															#line 638 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<DatabaseWarmerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1879 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DatabaseWarmerActor*>(this)->actor_wait_state = 1;
															#line 638 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DatabaseWarmerActor, 0, Void >*>(static_cast<DatabaseWarmerActor*>(this)));
															#line 1884 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 639 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0.25);
															#line 639 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<DatabaseWarmerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1895 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DatabaseWarmerActor*>(this)->actor_wait_state = 2;
															#line 639 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DatabaseWarmerActor, 1, Void >*>(static_cast<DatabaseWarmerActor*>(this)));
															#line 1900 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 639 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0.25);
															#line 639 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<DatabaseWarmerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1911 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DatabaseWarmerActor*>(this)->actor_wait_state = 2;
															#line 639 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DatabaseWarmerActor, 1, Void >*>(static_cast<DatabaseWarmerActor*>(this)));
															#line 1916 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DatabaseWarmerActor*>(this)->actor_wait_state > 0) static_cast<DatabaseWarmerActor*>(this)->actor_wait_state = 0;
		static_cast<DatabaseWarmerActor*>(this)->ActorCallback< DatabaseWarmerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DatabaseWarmerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("databaseWarmer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DatabaseWarmerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("databaseWarmer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DatabaseWarmerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("databaseWarmer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DatabaseWarmerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("databaseWarmer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DatabaseWarmerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("databaseWarmer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DatabaseWarmerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("databaseWarmer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DatabaseWarmerActor*>(this)->actor_wait_state > 0) static_cast<DatabaseWarmerActor*>(this)->actor_wait_state = 0;
		static_cast<DatabaseWarmerActor*>(this)->ActorCallback< DatabaseWarmerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DatabaseWarmerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("databaseWarmer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DatabaseWarmerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("databaseWarmer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DatabaseWarmerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("databaseWarmer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DatabaseWarmerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("databaseWarmer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DatabaseWarmerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("databaseWarmer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DatabaseWarmerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("databaseWarmer", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 635 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 637 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Transaction tr;
															#line 2087 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via databaseWarmer()
															#line 635 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class DatabaseWarmerActor final : public Actor<Void>, public ActorCallback< DatabaseWarmerActor, 0, Void >, public ActorCallback< DatabaseWarmerActor, 1, Void >, public FastAllocated<DatabaseWarmerActor>, public DatabaseWarmerActorState<DatabaseWarmerActor> {
															#line 2092 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<DatabaseWarmerActor>::operator new;
	using FastAllocated<DatabaseWarmerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4048358573931938560UL, 18277195806549570304UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DatabaseWarmerActor, 0, Void >;
friend struct ActorCallback< DatabaseWarmerActor, 1, Void >;
															#line 635 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	DatabaseWarmerActor(Database const& cx) 
															#line 2110 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<Void>(),
		   DatabaseWarmerActorState<DatabaseWarmerActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("databaseWarmer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7353933346527739648UL, 7270446683880026624UL);
		ActorExecutionContextHelper __helper(static_cast<DatabaseWarmerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("databaseWarmer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("databaseWarmer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DatabaseWarmerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DatabaseWarmerActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 635 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> databaseWarmer( Database const& cx ) {
															#line 635 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new DatabaseWarmerActor(cx));
															#line 2144 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 642 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

// Tries indefinitely to commit a simple, self conflicting transaction
															#line 2150 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via pingDatabase()
															#line 644 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class PingDatabaseActor>
															#line 644 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class PingDatabaseActorState {
															#line 2157 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 644 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	PingDatabaseActorState(Database const& cx) 
															#line 644 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 644 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cx(cx),
															#line 645 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   tr(cx)
															#line 2166 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("pingDatabase", reinterpret_cast<unsigned long>(this));

	}
	~PingDatabaseActorState() 
	{
		fdb_probe_actor_destroy("pingDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 646 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 2181 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PingDatabaseActorState();
		static_cast<PingDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 648 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 649 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 650 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(StringRef("/Liveness/" + deterministicRandom()->randomUniqueID().toString()));
															#line 650 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<PingDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2218 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PingDatabaseActor*>(this)->actor_wait_state = 1;
															#line 650 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PingDatabaseActor, 0, Optional<Value> >*>(static_cast<PingDatabaseActor*>(this)));
															#line 2223 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 656 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("PingingDatabaseTransactionError").error(e);
															#line 657 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 657 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<PingDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2249 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<PingDatabaseActor*>(this)->actor_wait_state = 3;
															#line 657 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PingDatabaseActor, 2, Void >*>(static_cast<PingDatabaseActor*>(this)));
															#line 2254 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& v,int loopDepth) 
	{
															#line 652 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		tr.makeSelfConflicting();
															#line 653 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 653 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<PingDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2273 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PingDatabaseActor*>(this)->actor_wait_state = 2;
															#line 653 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PingDatabaseActor, 1, Void >*>(static_cast<PingDatabaseActor*>(this)));
															#line 2278 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && v,int loopDepth) 
	{
															#line 652 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		tr.makeSelfConflicting();
															#line 653 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 653 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<PingDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2291 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PingDatabaseActor*>(this)->actor_wait_state = 2;
															#line 653 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PingDatabaseActor, 1, Void >*>(static_cast<PingDatabaseActor*>(this)));
															#line 2296 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PingDatabaseActor*>(this)->actor_wait_state > 0) static_cast<PingDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<PingDatabaseActor*>(this)->ActorCallback< PingDatabaseActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< PingDatabaseActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("pingDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PingDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pingDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PingDatabaseActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("pingDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PingDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pingDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PingDatabaseActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("pingDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PingDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pingDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 654 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<PingDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PingDatabaseActorState(); static_cast<PingDatabaseActor*>(this)->destroy(); return 0; }
															#line 2380 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<PingDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PingDatabaseActorState();
		static_cast<PingDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 654 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<PingDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PingDatabaseActorState(); static_cast<PingDatabaseActor*>(this)->destroy(); return 0; }
															#line 2392 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<PingDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PingDatabaseActorState();
		static_cast<PingDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PingDatabaseActor*>(this)->actor_wait_state > 0) static_cast<PingDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<PingDatabaseActor*>(this)->ActorCallback< PingDatabaseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PingDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pingDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PingDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pingDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PingDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pingDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PingDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pingDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PingDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pingDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PingDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pingDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PingDatabaseActor*>(this)->actor_wait_state > 0) static_cast<PingDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<PingDatabaseActor*>(this)->ActorCallback< PingDatabaseActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PingDatabaseActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pingDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PingDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pingDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PingDatabaseActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pingDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PingDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pingDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PingDatabaseActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pingDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PingDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pingDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 644 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 645 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Transaction tr;
															#line 2566 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via pingDatabase()
															#line 644 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class PingDatabaseActor final : public Actor<Void>, public ActorCallback< PingDatabaseActor, 0, Optional<Value> >, public ActorCallback< PingDatabaseActor, 1, Void >, public ActorCallback< PingDatabaseActor, 2, Void >, public FastAllocated<PingDatabaseActor>, public PingDatabaseActorState<PingDatabaseActor> {
															#line 2571 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<PingDatabaseActor>::operator new;
	using FastAllocated<PingDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10157054245865812736UL, 2107171309688618240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PingDatabaseActor, 0, Optional<Value> >;
friend struct ActorCallback< PingDatabaseActor, 1, Void >;
friend struct ActorCallback< PingDatabaseActor, 2, Void >;
															#line 644 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	PingDatabaseActor(Database const& cx) 
															#line 2590 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<Void>(),
		   PingDatabaseActorState<PingDatabaseActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("pingDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11933478825624451072UL, 18326457518002748416UL);
		ActorExecutionContextHelper __helper(static_cast<PingDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("pingDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("pingDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PingDatabaseActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PingDatabaseActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PingDatabaseActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 644 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> pingDatabase( Database const& cx ) {
															#line 644 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new PingDatabaseActor(cx));
															#line 2625 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 661 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 2630 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via testDatabaseLiveness()
															#line 662 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class TestDatabaseLivenessActor>
															#line 662 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class TestDatabaseLivenessActorState {
															#line 2637 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 662 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TestDatabaseLivenessActorState(Database const& cx,double const& databasePingDelay,std::string const& context,double const& startDelay = 0.0) 
															#line 662 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 662 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cx(cx),
															#line 662 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   databasePingDelay(databasePingDelay),
															#line 662 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   context(context),
															#line 662 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   startDelay(startDelay)
															#line 2650 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("testDatabaseLiveness", reinterpret_cast<unsigned long>(this));

	}
	~TestDatabaseLivenessActorState() 
	{
		fdb_probe_actor_destroy("testDatabaseLiveness", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 666 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(startDelay);
															#line 666 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2667 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state = 1;
															#line 666 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestDatabaseLivenessActor, 0, Void >*>(static_cast<TestDatabaseLivenessActor*>(this)));
															#line 2672 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestDatabaseLivenessActorState();
		static_cast<TestDatabaseLivenessActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 667 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		;
															#line 2695 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 667 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		;
															#line 2704 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state > 0) static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state = 0;
		static_cast<TestDatabaseLivenessActor*>(this)->ActorCallback< TestDatabaseLivenessActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestDatabaseLivenessActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestDatabaseLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestDatabaseLivenessActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestDatabaseLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestDatabaseLivenessActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestDatabaseLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 669 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			start = now();
															#line 670 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			auto traceMsg = "PingingDatabaseLiveness_" + context;
															#line 671 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(traceMsg.c_str()).log();
															#line 672 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_1 = timeoutError(pingDatabase(cx), databasePingDelay);
															#line 672 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2804 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state = 2;
															#line 672 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestDatabaseLivenessActor, 1, Void >*>(static_cast<TestDatabaseLivenessActor*>(this)));
															#line 2809 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 678 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 2831 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 679 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent(SevError, ("PingingDatabaseLivenessError_" + context).c_str()) .error(e) .detail("PingDelay", databasePingDelay);
															#line 2835 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 682 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 2839 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 673 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		double pingTime = now() - start;
															#line 674 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ASSERT(pingTime > 0);
															#line 675 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(("PingingDatabaseLivenessDone_" + context).c_str()).detail("TimeTaken", pingTime);
															#line 676 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(databasePingDelay - pingTime);
															#line 676 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2861 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state = 3;
															#line 676 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestDatabaseLivenessActor, 2, Void >*>(static_cast<TestDatabaseLivenessActor*>(this)));
															#line 2866 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 673 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		double pingTime = now() - start;
															#line 674 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ASSERT(pingTime > 0);
															#line 675 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(("PingingDatabaseLivenessDone_" + context).c_str()).detail("TimeTaken", pingTime);
															#line 676 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(databasePingDelay - pingTime);
															#line 676 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2883 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state = 3;
															#line 676 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestDatabaseLivenessActor, 2, Void >*>(static_cast<TestDatabaseLivenessActor*>(this)));
															#line 2888 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state > 0) static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state = 0;
		static_cast<TestDatabaseLivenessActor*>(this)->ActorCallback< TestDatabaseLivenessActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestDatabaseLivenessActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestDatabaseLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestDatabaseLivenessActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestDatabaseLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestDatabaseLivenessActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestDatabaseLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state > 0) static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state = 0;
		static_cast<TestDatabaseLivenessActor*>(this)->ActorCallback< TestDatabaseLivenessActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestDatabaseLivenessActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestDatabaseLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestDatabaseLivenessActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestDatabaseLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestDatabaseLivenessActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestDatabaseLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 662 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 662 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double databasePingDelay;
															#line 662 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::string context;
															#line 662 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double startDelay;
															#line 669 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double start;
															#line 3078 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via testDatabaseLiveness()
															#line 662 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class TestDatabaseLivenessActor final : public Actor<Void>, public ActorCallback< TestDatabaseLivenessActor, 0, Void >, public ActorCallback< TestDatabaseLivenessActor, 1, Void >, public ActorCallback< TestDatabaseLivenessActor, 2, Void >, public FastAllocated<TestDatabaseLivenessActor>, public TestDatabaseLivenessActorState<TestDatabaseLivenessActor> {
															#line 3083 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<TestDatabaseLivenessActor>::operator new;
	using FastAllocated<TestDatabaseLivenessActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1604794758613053440UL, 1152077482695550720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestDatabaseLivenessActor, 0, Void >;
friend struct ActorCallback< TestDatabaseLivenessActor, 1, Void >;
friend struct ActorCallback< TestDatabaseLivenessActor, 2, Void >;
															#line 662 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TestDatabaseLivenessActor(Database const& cx,double const& databasePingDelay,std::string const& context,double const& startDelay = 0.0) 
															#line 3102 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<Void>(),
		   TestDatabaseLivenessActorState<TestDatabaseLivenessActor>(cx, databasePingDelay, context, startDelay),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17809113238497153536UL, 12303323411469534464UL);
		ActorExecutionContextHelper __helper(static_cast<TestDatabaseLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testDatabaseLiveness");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestDatabaseLivenessActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestDatabaseLivenessActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestDatabaseLivenessActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 662 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> testDatabaseLiveness( Database const& cx, double const& databasePingDelay, std::string const& context, double const& startDelay = 0.0 ) {
															#line 662 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new TestDatabaseLivenessActor(cx, databasePingDelay, context, startDelay));
															#line 3137 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 686 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

template <class T>
void sendResult(ReplyPromise<T>& reply, Optional<ErrorOr<T>> const& result) {
	auto& res = result.get();
	if (res.isError())
		reply.sendError(res.getError());
	else
		reply.send(res.get());
}

															#line 3151 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via getConsistencyCheckUrgentWorkloadIface()
															#line 696 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class GetConsistencyCheckUrgentWorkloadIfaceActor>
															#line 696 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class GetConsistencyCheckUrgentWorkloadIfaceActorState {
															#line 3158 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 696 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	GetConsistencyCheckUrgentWorkloadIfaceActorState(WorkloadRequest const& work,Reference<IClusterConnectionRecord> const& ccr,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 696 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 696 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : work(work),
															#line 696 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   ccr(ccr),
															#line 696 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   dbInfo(dbInfo),
															#line 700 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   wcx()
															#line 3171 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("getConsistencyCheckUrgentWorkloadIface", reinterpret_cast<unsigned long>(this));

	}
	~GetConsistencyCheckUrgentWorkloadIfaceActorState() 
	{
		fdb_probe_actor_destroy("getConsistencyCheckUrgentWorkloadIface", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 701 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.clientId = work.clientId;
															#line 702 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.clientCount = work.clientCount;
															#line 703 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.sharedRandomNumber = work.sharedRandomNumber;
															#line 704 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.ccr = ccr;
															#line 705 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.dbInfo = dbInfo;
															#line 706 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.defaultTenant = work.defaultTenant.castTo<TenantName>();
															#line 707 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.rangesToCheck = work.rangesToCheck;
															#line 708 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Reference<TestWorkload>> __when_expr_0 = getWorkloadIface(work, ccr, work.options[0], dbInfo);
															#line 708 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3202 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->actor_wait_state = 1;
															#line 708 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetConsistencyCheckUrgentWorkloadIfaceActor, 0, Reference<TestWorkload> >*>(static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)));
															#line 3207 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetConsistencyCheckUrgentWorkloadIfaceActorState();
		static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<TestWorkload> const& iface,int loopDepth) 
	{
															#line 709 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->SAV<Reference<TestWorkload>>::futures) { (void)(iface); this->~GetConsistencyCheckUrgentWorkloadIfaceActorState(); static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->destroy(); return 0; }
															#line 3230 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->SAV< Reference<TestWorkload> >::value()) Reference<TestWorkload>(iface);
		this->~GetConsistencyCheckUrgentWorkloadIfaceActorState();
		static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<TestWorkload> && iface,int loopDepth) 
	{
															#line 709 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->SAV<Reference<TestWorkload>>::futures) { (void)(iface); this->~GetConsistencyCheckUrgentWorkloadIfaceActorState(); static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->destroy(); return 0; }
															#line 3242 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->SAV< Reference<TestWorkload> >::value()) Reference<TestWorkload>(iface);
		this->~GetConsistencyCheckUrgentWorkloadIfaceActorState();
		static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Reference<TestWorkload> const& iface,int loopDepth) 
	{
		loopDepth = a_body1cont1(iface, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<TestWorkload> && iface,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(iface), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->actor_wait_state > 0) static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->actor_wait_state = 0;
		static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->ActorCallback< GetConsistencyCheckUrgentWorkloadIfaceActor, 0, Reference<TestWorkload> >::remove();

	}
	void a_callback_fire(ActorCallback< GetConsistencyCheckUrgentWorkloadIfaceActor, 0, Reference<TestWorkload> >*,Reference<TestWorkload> const& value) 
	{
		fdb_probe_actor_enter("getConsistencyCheckUrgentWorkloadIface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConsistencyCheckUrgentWorkloadIface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetConsistencyCheckUrgentWorkloadIfaceActor, 0, Reference<TestWorkload> >*,Reference<TestWorkload> && value) 
	{
		fdb_probe_actor_enter("getConsistencyCheckUrgentWorkloadIface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConsistencyCheckUrgentWorkloadIface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetConsistencyCheckUrgentWorkloadIfaceActor, 0, Reference<TestWorkload> >*,Error err) 
	{
		fdb_probe_actor_enter("getConsistencyCheckUrgentWorkloadIface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConsistencyCheckUrgentWorkloadIface", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 696 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	WorkloadRequest work;
															#line 696 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<IClusterConnectionRecord> ccr;
															#line 696 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 700 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	WorkloadContext wcx;
															#line 3333 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via getConsistencyCheckUrgentWorkloadIface()
															#line 696 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class GetConsistencyCheckUrgentWorkloadIfaceActor final : public Actor<Reference<TestWorkload>>, public ActorCallback< GetConsistencyCheckUrgentWorkloadIfaceActor, 0, Reference<TestWorkload> >, public FastAllocated<GetConsistencyCheckUrgentWorkloadIfaceActor>, public GetConsistencyCheckUrgentWorkloadIfaceActorState<GetConsistencyCheckUrgentWorkloadIfaceActor> {
															#line 3338 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<GetConsistencyCheckUrgentWorkloadIfaceActor>::operator new;
	using FastAllocated<GetConsistencyCheckUrgentWorkloadIfaceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18203277785595149312UL, 16592225262846817280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<TestWorkload>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetConsistencyCheckUrgentWorkloadIfaceActor, 0, Reference<TestWorkload> >;
															#line 696 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	GetConsistencyCheckUrgentWorkloadIfaceActor(WorkloadRequest const& work,Reference<IClusterConnectionRecord> const& ccr,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 3355 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<Reference<TestWorkload>>(),
		   GetConsistencyCheckUrgentWorkloadIfaceActorState<GetConsistencyCheckUrgentWorkloadIfaceActor>(work, ccr, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getConsistencyCheckUrgentWorkloadIface", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12728771481979822592UL, 4317977112143097856UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getConsistencyCheckUrgentWorkloadIface");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getConsistencyCheckUrgentWorkloadIface", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetConsistencyCheckUrgentWorkloadIfaceActor, 0, Reference<TestWorkload> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 696 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Reference<TestWorkload>> getConsistencyCheckUrgentWorkloadIface( WorkloadRequest const& work, Reference<IClusterConnectionRecord> const& ccr, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 696 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Reference<TestWorkload>>(new GetConsistencyCheckUrgentWorkloadIfaceActor(work, ccr, dbInfo));
															#line 3388 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 711 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 3393 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via runConsistencyCheckUrgentWorkloadAsync()
															#line 712 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class RunConsistencyCheckUrgentWorkloadAsyncActor>
															#line 712 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunConsistencyCheckUrgentWorkloadAsyncActorState {
															#line 3400 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 712 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunConsistencyCheckUrgentWorkloadAsyncActorState(Database const& cx,WorkloadInterface const& workIface,Reference<TestWorkload> const& workload) 
															#line 712 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 712 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cx(cx),
															#line 712 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   workIface(workIface),
															#line 712 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   workload(workload),
															#line 715 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   jobReq()
															#line 3413 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this));

	}
	~RunConsistencyCheckUrgentWorkloadAsyncActorState() 
	{
		fdb_probe_actor_destroy("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 716 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 3428 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunConsistencyCheckUrgentWorkloadAsyncActorState();
		static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 740 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunConsistencyCheckUrgentWorkloadAsyncActorState(); static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->destroy(); return 0; }
															#line 3451 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunConsistencyCheckUrgentWorkloadAsyncActorState();
		static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 717 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auto __when_expr_0 = workIface.start.getFuture();
															#line 3470 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<ReplyPromise<Void>>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<ReplyPromise<Void>>>::value, "invalid type");
															#line 716 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3474 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->actor_wait_state = 1;
															#line 717 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 0, ReplyPromise<Void> >*>(static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)));
															#line 3479 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ReplyPromise<Void> const& req,int loopDepth) 
	{
															#line 718 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		jobReq = req;
															#line 3501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		try {
															#line 720 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterWorkloadReceived", workIface.id()) .detail("WorkloadName", workload->description()) .detail("ClientCount", workload->clientCount) .detail("ClientId", workload->clientId);
															#line 724 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_1 = workload->start(cx);
															#line 724 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->actor_wait_state < 0) return a_body1loopBody1when1Catch1(actor_cancelled(), loopDepth);
															#line 3509 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1when1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->actor_wait_state = 2;
															#line 724 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 1, Void >*>(static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)));
															#line 3514 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1when1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1when1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ReplyPromise<Void> && req,int loopDepth) 
	{
															#line 718 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		jobReq = req;
															#line 3529 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		try {
															#line 720 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterWorkloadReceived", workIface.id()) .detail("WorkloadName", workload->description()) .detail("ClientCount", workload->clientCount) .detail("ClientId", workload->clientId);
															#line 724 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_1 = workload->start(cx);
															#line 724 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->actor_wait_state < 0) return a_body1loopBody1when1Catch1(actor_cancelled(), loopDepth);
															#line 3537 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1when1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->actor_wait_state = 2;
															#line 724 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 1, Void >*>(static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)));
															#line 3542 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1when1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1when1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->actor_wait_state > 0) static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->ActorSingleCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 0, ReplyPromise<Void> >::remove();

	}
	int a_body1loopBody1when1cont1(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 727 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 3570 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 728 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 3574 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 730 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterWorkloadError", workIface.id()) .errorUnsuppressed(e) .detail("WorkloadName", workload->description()) .detail("ClientCount", workload->clientCount) .detail("ClientId", workload->clientId);
															#line 735 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			jobReq.sendError(consistency_check_urgent_task_failed());
															#line 3580 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = a_body1loopBody1when1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1when1cont2(Void const& _,int loopDepth) 
	{
															#line 725 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		jobReq.send(Void());
															#line 3595 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1loopBody1when1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1cont2(Void && _,int loopDepth) 
	{
															#line 725 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		jobReq.send(Void());
															#line 3604 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1loopBody1when1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->actor_wait_state > 0) static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->ActorCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1when1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1when1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1when1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1when1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1when1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	void a_callback_fire(ActorSingleCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 0, ReplyPromise<Void> >*,ReplyPromise<Void> const& value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 0, ReplyPromise<Void> >*,ReplyPromise<Void> && value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 0, ReplyPromise<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 712 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 712 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	WorkloadInterface workIface;
															#line 712 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<TestWorkload> workload;
															#line 715 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	ReplyPromise<Void> jobReq;
															#line 3762 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via runConsistencyCheckUrgentWorkloadAsync()
															#line 712 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunConsistencyCheckUrgentWorkloadAsyncActor final : public Actor<Void>, public ActorSingleCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 0, ReplyPromise<Void> >, public ActorCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 1, Void >, public FastAllocated<RunConsistencyCheckUrgentWorkloadAsyncActor>, public RunConsistencyCheckUrgentWorkloadAsyncActorState<RunConsistencyCheckUrgentWorkloadAsyncActor> {
															#line 3767 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<RunConsistencyCheckUrgentWorkloadAsyncActor>::operator new;
	using FastAllocated<RunConsistencyCheckUrgentWorkloadAsyncActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10239833065119146496UL, 11627007813031380224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 0, ReplyPromise<Void> >;
friend struct ActorCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 1, Void >;
															#line 712 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunConsistencyCheckUrgentWorkloadAsyncActor(Database const& cx,WorkloadInterface const& workIface,Reference<TestWorkload> const& workload) 
															#line 3785 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<Void>(),
		   RunConsistencyCheckUrgentWorkloadAsyncActorState<RunConsistencyCheckUrgentWorkloadAsyncActor>(cx, workIface, workload),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9698761713318437888UL, 14742129748971403776UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runConsistencyCheckUrgentWorkloadAsync");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 0, ReplyPromise<Void> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 712 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> runConsistencyCheckUrgentWorkloadAsync( Database const& cx, WorkloadInterface const& workIface, Reference<TestWorkload> const& workload ) {
															#line 712 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new RunConsistencyCheckUrgentWorkloadAsyncActor(cx, workIface, workload));
															#line 3819 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 742 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 3824 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via testerServerConsistencyCheckerUrgentWorkload()
															#line 743 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class TesterServerConsistencyCheckerUrgentWorkloadActor>
															#line 743 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class TesterServerConsistencyCheckerUrgentWorkloadActorState {
															#line 3831 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 743 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TesterServerConsistencyCheckerUrgentWorkloadActorState(WorkloadRequest const& work,Reference<IClusterConnectionRecord> const& ccr,Reference<AsyncVar<struct ServerDBInfo> const> const& dbInfo) 
															#line 743 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 743 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : work(work),
															#line 743 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   ccr(ccr),
															#line 743 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   dbInfo(dbInfo),
															#line 746 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   workIface(),
															#line 747 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   replied(false)
															#line 3846 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this));

	}
	~TesterServerConsistencyCheckerUrgentWorkloadActorState() 
	{
		fdb_probe_actor_destroy("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 749 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				cx = openDBOnServer(dbInfo);
															#line 750 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(1.0);
															#line 750 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3866 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state = 1;
															#line 750 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 0, Void >*>(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)));
															#line 3871 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TesterServerConsistencyCheckerUrgentWorkloadActorState();
		static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 765 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TesterServerConsistencyCheckerUrgentWorkloadActorState(); static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->destroy(); return 0; }
															#line 3900 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TesterServerConsistencyCheckerUrgentWorkloadActorState();
		static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 757 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 3913 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 758 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 3917 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 760 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevWarn, "ConsistencyCheckUrgent_TesterRunWorkloadFailed").errorUnsuppressed(e);
															#line 761 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (!replied)
															#line 3923 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 762 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				work.reply.sendError(e);
															#line 3927 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 751 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Reference<TestWorkload>> __when_expr_1 = getConsistencyCheckUrgentWorkloadIface(work, ccr, dbInfo);
															#line 751 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3945 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state = 2;
															#line 751 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 1, Reference<TestWorkload> >*>(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)));
															#line 3950 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 751 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Reference<TestWorkload>> __when_expr_1 = getConsistencyCheckUrgentWorkloadIface(work, ccr, dbInfo);
															#line 751 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3961 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state = 2;
															#line 751 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 1, Reference<TestWorkload> >*>(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)));
															#line 3966 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state > 0) static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Reference<TestWorkload> const& workload,int loopDepth) 
	{
															#line 752 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		Future<Void> test = runConsistencyCheckUrgentWorkloadAsync(cx, workIface, workload);
															#line 753 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		work.reply.send(workIface);
															#line 754 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		replied = true;
															#line 755 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_2 = test;
															#line 755 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4058 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state = 3;
															#line 755 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 2, Void >*>(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)));
															#line 4063 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Reference<TestWorkload> && workload,int loopDepth) 
	{
															#line 752 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		Future<Void> test = runConsistencyCheckUrgentWorkloadAsync(cx, workIface, workload);
															#line 753 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		work.reply.send(workIface);
															#line 754 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		replied = true;
															#line 755 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_2 = test;
															#line 755 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4080 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state = 3;
															#line 755 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 2, Void >*>(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)));
															#line 4085 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Reference<TestWorkload> const& workload,int loopDepth) 
	{
		loopDepth = a_body1cont3(workload, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Reference<TestWorkload> && workload,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(workload), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state > 0) static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 1, Reference<TestWorkload> >::remove();

	}
	void a_callback_fire(ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 1, Reference<TestWorkload> >*,Reference<TestWorkload> const& value) 
	{
		fdb_probe_actor_enter("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 1, Reference<TestWorkload> >*,Reference<TestWorkload> && value) 
	{
		fdb_probe_actor_enter("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 1, Reference<TestWorkload> >*,Error err) 
	{
		fdb_probe_actor_enter("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state > 0) static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 743 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	WorkloadRequest work;
															#line 743 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<IClusterConnectionRecord> ccr;
															#line 743 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<struct ServerDBInfo> const> dbInfo;
															#line 746 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	WorkloadInterface workIface;
															#line 747 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	bool replied;
															#line 749 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 4277 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via testerServerConsistencyCheckerUrgentWorkload()
															#line 743 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class TesterServerConsistencyCheckerUrgentWorkloadActor final : public Actor<Void>, public ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 0, Void >, public ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 1, Reference<TestWorkload> >, public ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 2, Void >, public FastAllocated<TesterServerConsistencyCheckerUrgentWorkloadActor>, public TesterServerConsistencyCheckerUrgentWorkloadActorState<TesterServerConsistencyCheckerUrgentWorkloadActor> {
															#line 4282 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<TesterServerConsistencyCheckerUrgentWorkloadActor>::operator new;
	using FastAllocated<TesterServerConsistencyCheckerUrgentWorkloadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4128236677158238464UL, 18310896595619774464UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 0, Void >;
friend struct ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 1, Reference<TestWorkload> >;
friend struct ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 2, Void >;
															#line 743 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TesterServerConsistencyCheckerUrgentWorkloadActor(WorkloadRequest const& work,Reference<IClusterConnectionRecord> const& ccr,Reference<AsyncVar<struct ServerDBInfo> const> const& dbInfo) 
															#line 4301 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<Void>(),
		   TesterServerConsistencyCheckerUrgentWorkloadActorState<TesterServerConsistencyCheckerUrgentWorkloadActor>(work, ccr, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8596843326291973632UL, 1793775326075062016UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testerServerConsistencyCheckerUrgentWorkload");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 1, Reference<TestWorkload> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 743 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> testerServerConsistencyCheckerUrgentWorkload( WorkloadRequest const& work, Reference<IClusterConnectionRecord> const& ccr, Reference<AsyncVar<struct ServerDBInfo> const> const& dbInfo ) {
															#line 743 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new TesterServerConsistencyCheckerUrgentWorkloadActor(work, ccr, dbInfo));
															#line 4336 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 767 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 4341 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via runWorkloadAsync()
															#line 768 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class RunWorkloadAsyncActor>
															#line 768 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunWorkloadAsyncActorState {
															#line 4348 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 768 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunWorkloadAsyncActorState(Database const& cx,WorkloadInterface const& workIface,Reference<TestWorkload> const& workload,double const& databasePingDelay) 
															#line 768 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 768 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cx(cx),
															#line 768 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   workIface(workIface),
															#line 768 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   workload(workload),
															#line 768 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   databasePingDelay(databasePingDelay),
															#line 772 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   setupResult(),
															#line 773 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   startResult(),
															#line 774 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   checkResult(),
															#line 775 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   setupReq(),
															#line 776 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   startReq(),
															#line 777 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   checkReq()
															#line 4373 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("runWorkloadAsync", reinterpret_cast<unsigned long>(this));

	}
	~RunWorkloadAsyncActorState() 
	{
		fdb_probe_actor_destroy("runWorkloadAsync", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 779 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("TestBeginAsync", workIface.id()) .detail("Workload", workload->description()) .detail("DatabasePingDelay", databasePingDelay);
															#line 783 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			databaseError = databasePingDelay == 0.0 ? Never() : testDatabaseLiveness(cx, databasePingDelay, "RunWorkloadAsync");
															#line 786 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 4392 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunWorkloadAsyncActorState();
		static_cast<RunWorkloadAsyncActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 871 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<RunWorkloadAsyncActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunWorkloadAsyncActorState(); static_cast<RunWorkloadAsyncActor*>(this)->destroy(); return 0; }
															#line 4415 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<RunWorkloadAsyncActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunWorkloadAsyncActorState();
		static_cast<RunWorkloadAsyncActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 787 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auto __when_expr_0 = workIface.setup.getFuture();
															#line 4434 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<ReplyPromise<Void>>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<ReplyPromise<Void>>>::value, "invalid type");
															#line 786 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4438 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 807 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auto __when_expr_1 = workIface.start.getFuture();
															#line 4442 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<ReplyPromise<Void>>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<ReplyPromise<Void>>>::value, "invalid type");
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
															#line 831 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auto __when_expr_2 = workIface.check.getFuture();
															#line 4447 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_2), FutureStream<ReplyPromise<CheckReply>>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<ReplyPromise<CheckReply>>>::value, "invalid type");
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.pop(), loopDepth); };
															#line 853 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auto __when_expr_3 = workIface.metrics.getFuture();
															#line 4452 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_3), FutureStream<ReplyPromise<std::vector<PerfMetric>>>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<ReplyPromise<std::vector<PerfMetric>>>>::value, "invalid type");
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4(__when_expr_3.pop(), loopDepth); };
															#line 866 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auto __when_expr_4 = workIface.stop.getFuture();
															#line 4457 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_4), FutureStream<ReplyPromise<Void>>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<ReplyPromise<Void>>>::value, "invalid type");
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when5(__when_expr_4.pop(), loopDepth); };
		static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 1;
															#line 787 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< RunWorkloadAsyncActor, 0, ReplyPromise<Void> >*>(static_cast<RunWorkloadAsyncActor*>(this)));
															#line 807 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< RunWorkloadAsyncActor, 1, ReplyPromise<Void> >*>(static_cast<RunWorkloadAsyncActor*>(this)));
															#line 831 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< RunWorkloadAsyncActor, 2, ReplyPromise<CheckReply> >*>(static_cast<RunWorkloadAsyncActor*>(this)));
															#line 853 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< RunWorkloadAsyncActor, 3, ReplyPromise<std::vector<PerfMetric>> >*>(static_cast<RunWorkloadAsyncActor*>(this)));
															#line 866 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< RunWorkloadAsyncActor, 4, ReplyPromise<Void> >*>(static_cast<RunWorkloadAsyncActor*>(this)));
															#line 4471 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(ReplyPromise<Void> const& req,int loopDepth) 
	{
															#line 788 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("Test received trigger for setup...\n");
															#line 789 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestSetupBeginning", workIface.id()).detail("Workload", workload->description());
															#line 790 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		setupReq = req;
															#line 791 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!setupResult.present())
															#line 4505 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
			try {
															#line 793 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_5 = workload->setup(cx) || databaseError;
															#line 793 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state < 0) return a_body1loopBody1when1Catch1(actor_cancelled(), loopDepth);
															#line 4512 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1when1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1when1when1(__when_expr_5.get(), loopDepth); };
				static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 2;
															#line 793 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadAsyncActor, 5, Void >*>(static_cast<RunWorkloadAsyncActor*>(this)));
															#line 4517 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1when1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1when1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1when1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ReplyPromise<Void> && req,int loopDepth) 
	{
															#line 788 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("Test received trigger for setup...\n");
															#line 789 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestSetupBeginning", workIface.id()).detail("Workload", workload->description());
															#line 790 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		setupReq = req;
															#line 791 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!setupResult.present())
															#line 4543 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
			try {
															#line 793 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_5 = workload->setup(cx) || databaseError;
															#line 793 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state < 0) return a_body1loopBody1when1Catch1(actor_cancelled(), loopDepth);
															#line 4550 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1when1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1when1when1(__when_expr_5.get(), loopDepth); };
				static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 2;
															#line 793 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadAsyncActor, 5, Void >*>(static_cast<RunWorkloadAsyncActor*>(this)));
															#line 4555 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1when1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1when1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1when1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when2(ReplyPromise<Void> const& req,int loopDepth) 
	{
															#line 808 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		startReq = req;
															#line 809 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!startResult.present())
															#line 4577 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
			try {
															#line 811 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent("TestStarting", workIface.id()).detail("Workload", workload->description());
															#line 812 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_6 = workload->start(cx) || databaseError;
															#line 812 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state < 0) return a_body1loopBody1when2Catch1(actor_cancelled(), loopDepth);
															#line 4586 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1when2Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1when2when1(__when_expr_6.get(), loopDepth); };
				static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 3;
															#line 812 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadAsyncActor, 6, Void >*>(static_cast<RunWorkloadAsyncActor*>(this)));
															#line 4591 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1when2Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1when2Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1when2cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when2(ReplyPromise<Void> && req,int loopDepth) 
	{
															#line 808 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		startReq = req;
															#line 809 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!startResult.present())
															#line 4613 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
			try {
															#line 811 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent("TestStarting", workIface.id()).detail("Workload", workload->description());
															#line 812 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_6 = workload->start(cx) || databaseError;
															#line 812 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state < 0) return a_body1loopBody1when2Catch1(actor_cancelled(), loopDepth);
															#line 4622 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1when2Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1when2when1(__when_expr_6.get(), loopDepth); };
				static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 3;
															#line 812 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadAsyncActor, 6, Void >*>(static_cast<RunWorkloadAsyncActor*>(this)));
															#line 4627 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1when2Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1when2Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1when2cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when3(ReplyPromise<CheckReply> const& req,int loopDepth) 
	{
															#line 832 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		checkReq = req;
															#line 833 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!checkResult.present())
															#line 4649 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
			try {
															#line 835 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent("TestChecking", workIface.id()).detail("Workload", workload->description());
															#line 836 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<bool> __when_expr_7 = timeoutError(workload->check(cx), workload->getCheckTimeout());
															#line 836 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state < 0) return a_body1loopBody1when3Catch1(actor_cancelled(), loopDepth);
															#line 4658 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1when3Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1when3when1(__when_expr_7.get(), loopDepth); };
				static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 4;
															#line 836 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadAsyncActor, 7, bool >*>(static_cast<RunWorkloadAsyncActor*>(this)));
															#line 4663 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1when3Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1when3Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1when3cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when3(ReplyPromise<CheckReply> && req,int loopDepth) 
	{
															#line 832 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		checkReq = req;
															#line 833 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!checkResult.present())
															#line 4685 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
			try {
															#line 835 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent("TestChecking", workIface.id()).detail("Workload", workload->description());
															#line 836 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<bool> __when_expr_7 = timeoutError(workload->check(cx), workload->getCheckTimeout());
															#line 836 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state < 0) return a_body1loopBody1when3Catch1(actor_cancelled(), loopDepth);
															#line 4694 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1when3Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1when3when1(__when_expr_7.get(), loopDepth); };
				static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 4;
															#line 836 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadAsyncActor, 7, bool >*>(static_cast<RunWorkloadAsyncActor*>(this)));
															#line 4699 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1when3Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1when3Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1when3cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when4(ReplyPromise<std::vector<PerfMetric>> const& req,int loopDepth) 
	{
															#line 854 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		s_req = req;
															#line 4719 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		try {
															#line 856 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<std::vector<PerfMetric>> __when_expr_8 = workload->getMetrics();
															#line 856 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state < 0) return a_body1loopBody1when4Catch1(actor_cancelled(), loopDepth);
															#line 4725 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1when4Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1when4when1(__when_expr_8.get(), loopDepth); };
			static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 5;
															#line 856 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadAsyncActor, 8, std::vector<PerfMetric> >*>(static_cast<RunWorkloadAsyncActor*>(this)));
															#line 4730 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1when4Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1when4Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when4(ReplyPromise<std::vector<PerfMetric>> && req,int loopDepth) 
	{
															#line 854 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		s_req = req;
															#line 4745 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		try {
															#line 856 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<std::vector<PerfMetric>> __when_expr_8 = workload->getMetrics();
															#line 856 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state < 0) return a_body1loopBody1when4Catch1(actor_cancelled(), loopDepth);
															#line 4751 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1when4Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1when4when1(__when_expr_8.get(), loopDepth); };
			static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 5;
															#line 856 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadAsyncActor, 8, std::vector<PerfMetric> >*>(static_cast<RunWorkloadAsyncActor*>(this)));
															#line 4756 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1when4Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1when4Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when5(ReplyPromise<Void> const& r,int loopDepth) 
	{
															#line 867 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		r.send(Void());
															#line 4771 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when5(ReplyPromise<Void> && r,int loopDepth) 
	{
															#line 867 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		r.send(Void());
															#line 4780 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state > 0) static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<RunWorkloadAsyncActor*>(this)->ActorSingleCallback< RunWorkloadAsyncActor, 0, ReplyPromise<Void> >::remove();
		static_cast<RunWorkloadAsyncActor*>(this)->ActorSingleCallback< RunWorkloadAsyncActor, 1, ReplyPromise<Void> >::remove();
		static_cast<RunWorkloadAsyncActor*>(this)->ActorSingleCallback< RunWorkloadAsyncActor, 2, ReplyPromise<CheckReply> >::remove();
		static_cast<RunWorkloadAsyncActor*>(this)->ActorSingleCallback< RunWorkloadAsyncActor, 3, ReplyPromise<std::vector<PerfMetric>> >::remove();
		static_cast<RunWorkloadAsyncActor*>(this)->ActorSingleCallback< RunWorkloadAsyncActor, 4, ReplyPromise<Void> >::remove();

	}
	int a_body1loopBody1when1cont1(int loopDepth) 
	{
															#line 805 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		sendResult(setupReq, setupResult);
															#line 4799 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 797 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			setupResult = operation_failed();
															#line 798 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevError, "TestSetupError", workIface.id()) .error(e) .detail("Workload", workload->description());
															#line 801 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (e.code() == error_code_please_reboot || e.code() == error_code_please_reboot_delete)
															#line 4819 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 802 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 4823 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
			loopDepth = a_body1loopBody1when1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1when1cont3(Void const& _,int loopDepth) 
	{
															#line 794 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestSetupComplete", workIface.id()).detail("Workload", workload->description());
															#line 795 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		setupResult = Void();
															#line 4841 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1loopBody1when1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1cont3(Void && _,int loopDepth) 
	{
															#line 794 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestSetupComplete", workIface.id()).detail("Workload", workload->description());
															#line 795 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		setupResult = Void();
															#line 4852 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1loopBody1when1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state > 0) static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<RunWorkloadAsyncActor*>(this)->ActorCallback< RunWorkloadAsyncActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunWorkloadAsyncActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1when1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RunWorkloadAsyncActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1when1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RunWorkloadAsyncActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1when1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1when1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1when1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	void a_callback_fire(ActorSingleCallback< RunWorkloadAsyncActor, 0, ReplyPromise<Void> >*,ReplyPromise<Void> const& value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< RunWorkloadAsyncActor, 0, ReplyPromise<Void> >*,ReplyPromise<Void> && value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< RunWorkloadAsyncActor, 0, ReplyPromise<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1when2cont1(int loopDepth) 
	{
															#line 829 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		sendResult(startReq, startResult);
															#line 5006 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont2(int loopDepth) 
	{
															#line 824 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestComplete", workIface.id()) .detail("Workload", workload->description()) .detail("OK", !startResult.get().isError());
															#line 827 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("%s complete\n", workload->description().c_str());
															#line 5017 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1loopBody1when2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 815 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			startResult = operation_failed();
															#line 816 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (e.code() == error_code_please_reboot || e.code() == error_code_please_reboot_delete)
															#line 5029 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 817 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 5033 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 818 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevError, "TestFailure", workIface.id()) .errorUnsuppressed(e) .detail("Reason", "Error starting workload") .detail("Workload", workload->description());
															#line 5037 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = a_body1loopBody1when2cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1when2cont3(Void const& _,int loopDepth) 
	{
															#line 813 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		startResult = Void();
															#line 5052 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1loopBody1when2cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont3(Void && _,int loopDepth) 
	{
															#line 813 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		startResult = Void();
															#line 5061 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1loopBody1when2cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state > 0) static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<RunWorkloadAsyncActor*>(this)->ActorCallback< RunWorkloadAsyncActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunWorkloadAsyncActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1when2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RunWorkloadAsyncActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1when2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RunWorkloadAsyncActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1when2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1when2cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1when2cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	void a_callback_fire(ActorSingleCallback< RunWorkloadAsyncActor, 1, ReplyPromise<Void> >*,ReplyPromise<Void> const& value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< RunWorkloadAsyncActor, 1, ReplyPromise<Void> >*,ReplyPromise<Void> && value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< RunWorkloadAsyncActor, 1, ReplyPromise<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1when3cont1(int loopDepth) 
	{
															#line 851 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		sendResult(checkReq, checkResult);
															#line 5215 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3cont2(int loopDepth) 
	{
															#line 848 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestCheckComplete", workIface.id()).detail("Workload", workload->description());
															#line 5224 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1loopBody1when3cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 839 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			checkResult = operation_failed();
															#line 840 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (e.code() == error_code_please_reboot || e.code() == error_code_please_reboot_delete)
															#line 5236 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 841 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 5240 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 842 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevError, "TestFailure", workIface.id()) .error(e) .detail("Reason", "Error checking workload") .detail("Workload", workload->description());
															#line 5244 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = a_body1loopBody1when3cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1when3cont3(bool const& check,int loopDepth) 
	{
															#line 837 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		checkResult = CheckReply{ (!startResult.present() || !startResult.get().isError()) && check };
															#line 5259 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1loopBody1when3cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3cont3(bool && check,int loopDepth) 
	{
															#line 837 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		checkResult = CheckReply{ (!startResult.present() || !startResult.get().isError()) && check };
															#line 5268 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1loopBody1when3cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3when1(bool const& check,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when3cont3(check, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3when1(bool && check,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when3cont3(std::move(check), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state > 0) static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<RunWorkloadAsyncActor*>(this)->ActorCallback< RunWorkloadAsyncActor, 7, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunWorkloadAsyncActor, 7, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1when3Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RunWorkloadAsyncActor, 7, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1when3Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< RunWorkloadAsyncActor, 7, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when3Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1when3Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1when3cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1when3cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	void a_callback_fire(ActorSingleCallback< RunWorkloadAsyncActor, 2, ReplyPromise<CheckReply> >*,ReplyPromise<CheckReply> const& value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< RunWorkloadAsyncActor, 2, ReplyPromise<CheckReply> >*,ReplyPromise<CheckReply> && value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< RunWorkloadAsyncActor, 2, ReplyPromise<CheckReply> >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1when4cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 860 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (e.code() == error_code_please_reboot || e.code() == error_code_please_reboot_delete)
															#line 5429 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 861 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 5433 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 862 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevError, "WorkloadSendMetrics", workIface.id()).error(e);
															#line 863 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			s_req.sendError(operation_failed());
															#line 5439 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = a_body1loopBody1when4cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1when4cont2(std::vector<PerfMetric> const& m,int loopDepth) 
	{
															#line 857 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("WorkloadSendMetrics", workIface.id()).detail("Count", m.size());
															#line 858 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		s_req.send(m);
															#line 5456 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1loopBody1when4cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4cont2(std::vector<PerfMetric> && m,int loopDepth) 
	{
															#line 857 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("WorkloadSendMetrics", workIface.id()).detail("Count", m.size());
															#line 858 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		s_req.send(m);
															#line 5467 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1loopBody1when4cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4when1(std::vector<PerfMetric> const& m,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when4cont2(m, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4when1(std::vector<PerfMetric> && m,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when4cont2(std::move(m), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state > 0) static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<RunWorkloadAsyncActor*>(this)->ActorCallback< RunWorkloadAsyncActor, 8, std::vector<PerfMetric> >::remove();

	}
	void a_callback_fire(ActorCallback< RunWorkloadAsyncActor, 8, std::vector<PerfMetric> >*,std::vector<PerfMetric> const& value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1when4Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< RunWorkloadAsyncActor, 8, std::vector<PerfMetric> >*,std::vector<PerfMetric> && value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1when4Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< RunWorkloadAsyncActor, 8, std::vector<PerfMetric> >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when4Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1when4Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1when4cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1when4cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	void a_callback_fire(ActorSingleCallback< RunWorkloadAsyncActor, 3, ReplyPromise<std::vector<PerfMetric>> >*,ReplyPromise<std::vector<PerfMetric>> const& value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< RunWorkloadAsyncActor, 3, ReplyPromise<std::vector<PerfMetric>> >*,ReplyPromise<std::vector<PerfMetric>> && value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< RunWorkloadAsyncActor, 3, ReplyPromise<std::vector<PerfMetric>> >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< RunWorkloadAsyncActor, 4, ReplyPromise<Void> >*,ReplyPromise<Void> const& value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< RunWorkloadAsyncActor, 4, ReplyPromise<Void> >*,ReplyPromise<Void> && value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< RunWorkloadAsyncActor, 4, ReplyPromise<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 768 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 768 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	WorkloadInterface workIface;
															#line 768 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<TestWorkload> workload;
															#line 768 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double databasePingDelay;
															#line 772 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Optional<ErrorOr<Void>> setupResult;
															#line 773 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Optional<ErrorOr<Void>> startResult;
															#line 774 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Optional<ErrorOr<CheckReply>> checkResult;
															#line 775 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	ReplyPromise<Void> setupReq;
															#line 776 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	ReplyPromise<Void> startReq;
															#line 777 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	ReplyPromise<CheckReply> checkReq;
															#line 783 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Future<Void> databaseError;
															#line 854 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	ReplyPromise<std::vector<PerfMetric>> s_req;
															#line 5698 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via runWorkloadAsync()
															#line 768 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunWorkloadAsyncActor final : public Actor<Void>, public ActorSingleCallback< RunWorkloadAsyncActor, 0, ReplyPromise<Void> >, public ActorCallback< RunWorkloadAsyncActor, 5, Void >, public ActorSingleCallback< RunWorkloadAsyncActor, 1, ReplyPromise<Void> >, public ActorCallback< RunWorkloadAsyncActor, 6, Void >, public ActorSingleCallback< RunWorkloadAsyncActor, 2, ReplyPromise<CheckReply> >, public ActorCallback< RunWorkloadAsyncActor, 7, bool >, public ActorSingleCallback< RunWorkloadAsyncActor, 3, ReplyPromise<std::vector<PerfMetric>> >, public ActorCallback< RunWorkloadAsyncActor, 8, std::vector<PerfMetric> >, public ActorSingleCallback< RunWorkloadAsyncActor, 4, ReplyPromise<Void> >, public FastAllocated<RunWorkloadAsyncActor>, public RunWorkloadAsyncActorState<RunWorkloadAsyncActor> {
															#line 5703 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<RunWorkloadAsyncActor>::operator new;
	using FastAllocated<RunWorkloadAsyncActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1073147757498912256UL, 9203631706438273536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< RunWorkloadAsyncActor, 0, ReplyPromise<Void> >;
friend struct ActorCallback< RunWorkloadAsyncActor, 5, Void >;
friend struct ActorSingleCallback< RunWorkloadAsyncActor, 1, ReplyPromise<Void> >;
friend struct ActorCallback< RunWorkloadAsyncActor, 6, Void >;
friend struct ActorSingleCallback< RunWorkloadAsyncActor, 2, ReplyPromise<CheckReply> >;
friend struct ActorCallback< RunWorkloadAsyncActor, 7, bool >;
friend struct ActorSingleCallback< RunWorkloadAsyncActor, 3, ReplyPromise<std::vector<PerfMetric>> >;
friend struct ActorCallback< RunWorkloadAsyncActor, 8, std::vector<PerfMetric> >;
friend struct ActorSingleCallback< RunWorkloadAsyncActor, 4, ReplyPromise<Void> >;
															#line 768 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunWorkloadAsyncActor(Database const& cx,WorkloadInterface const& workIface,Reference<TestWorkload> const& workload,double const& databasePingDelay) 
															#line 5728 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<Void>(),
		   RunWorkloadAsyncActorState<RunWorkloadAsyncActor>(cx, workIface, workload, databasePingDelay),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17968685797001769216UL, 9430172446286135040UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runWorkloadAsync");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< RunWorkloadAsyncActor, 0, ReplyPromise<Void> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunWorkloadAsyncActor, 5, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunWorkloadAsyncActor, 6, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunWorkloadAsyncActor, 7, bool >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RunWorkloadAsyncActor, 8, std::vector<PerfMetric> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 768 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> runWorkloadAsync( Database const& cx, WorkloadInterface const& workIface, Reference<TestWorkload> const& workload, double const& databasePingDelay ) {
															#line 768 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new RunWorkloadAsyncActor(cx, workIface, workload, databasePingDelay));
															#line 5765 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 873 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 5770 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via testerServerWorkload()
															#line 874 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class TesterServerWorkloadActor>
															#line 874 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class TesterServerWorkloadActorState {
															#line 5777 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 874 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TesterServerWorkloadActorState(WorkloadRequest const& work,Reference<IClusterConnectionRecord> const& ccr,Reference<AsyncVar<struct ServerDBInfo> const> const& dbInfo,LocalityData const& locality) 
															#line 874 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 874 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : work(work),
															#line 874 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   ccr(ccr),
															#line 874 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   dbInfo(dbInfo),
															#line 874 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   locality(locality),
															#line 878 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   workIface(),
															#line 879 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   replied(false),
															#line 880 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   cx()
															#line 5796 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("testerServerWorkload", reinterpret_cast<unsigned long>(this));

	}
	~TesterServerWorkloadActorState() 
	{
		fdb_probe_actor_destroy("testerServerWorkload", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 882 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				std::map<std::string, std::string> details;
															#line 883 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				details["WorkloadTitle"] = printable(work.title);
															#line 884 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				details["ClientId"] = format("%d", work.clientId);
															#line 885 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				details["ClientCount"] = format("%d", work.clientCount);
															#line 886 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				details["WorkloadTimeout"] = format("%d", work.timeout);
															#line 887 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				startRole(Role::TESTER, workIface.id(), UID(), details);
															#line 889 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (work.useDatabase)
															#line 5824 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				{
															#line 890 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					cx = Database::createDatabase(ccr, ApiVersion::LATEST_VERSION, IsInternal::True, locality);
															#line 891 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					cx->defaultTenant = work.defaultTenant.castTo<TenantName>();
															#line 892 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					StrictFuture<Void> __when_expr_0 = delay(1.0);
															#line 892 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					if (static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5834 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state = 1;
															#line 892 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TesterServerWorkloadActor, 0, Void >*>(static_cast<TesterServerWorkloadActor*>(this)));
															#line 5839 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TesterServerWorkloadActorState();
		static_cast<TesterServerWorkloadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 932 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<TesterServerWorkloadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TesterServerWorkloadActorState(); static_cast<TesterServerWorkloadActor*>(this)->destroy(); return 0; }
															#line 5873 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<TesterServerWorkloadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TesterServerWorkloadActorState();
		static_cast<TesterServerWorkloadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 916 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevDebug, "TesterWorkloadFailed").errorUnsuppressed(e);
															#line 917 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (!replied)
															#line 5888 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 918 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (e.code() == error_code_test_specification_invalid)
															#line 5892 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				{
															#line 919 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					work.reply.sendError(e);
															#line 5896 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				}
				else
				{
															#line 921 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					work.reply.sendError(operation_failed());
															#line 5902 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				}
			}
															#line 924 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			bool ok = e.code() == error_code_please_reboot || e.code() == error_code_please_reboot_delete || e.code() == error_code_actor_cancelled;
															#line 926 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			endRole(Role::TESTER, workIface.id(), "Error", ok, e);
															#line 928 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (e.code() != error_code_test_specification_invalid && e.code() != error_code_timed_out)
															#line 5911 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 929 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 5915 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 896 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("WorkloadReceived", workIface.id()).detail("Title", work.title);
															#line 897 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Reference<TestWorkload>> __when_expr_1 = getWorkloadIface(work, ccr, dbInfo);
															#line 897 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5935 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state = 2;
															#line 897 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TesterServerWorkloadActor, 1, Reference<TestWorkload> >*>(static_cast<TesterServerWorkloadActor*>(this)));
															#line 5940 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state > 0) static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<TesterServerWorkloadActor*>(this)->ActorCallback< TesterServerWorkloadActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TesterServerWorkloadActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testerServerWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TesterServerWorkloadActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testerServerWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TesterServerWorkloadActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testerServerWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Reference<TestWorkload> const& workload,int loopDepth) 
	{
															#line 898 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!workload)
															#line 6036 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 899 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("TestCreationError").detail("Reason", "Workload could not be created");
															#line 900 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			fprintf(stderr, "ERROR: The workload could not be created.\n");
															#line 901 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			return a_body1Catch2(test_specification_invalid(), loopDepth);
															#line 6044 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 903 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		Future<Void> test = runWorkloadAsync(cx, workIface, workload, work.databasePingDelay) || traceRole(Role::TESTER, workIface.id());
															#line 905 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		work.reply.send(workIface);
															#line 906 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		replied = true;
															#line 908 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (work.timeout > 0)
															#line 6054 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 909 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			test = timeoutError(test, work.timeout);
															#line 6058 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 912 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_2 = test;
															#line 912 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6064 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state = 3;
															#line 912 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TesterServerWorkloadActor, 2, Void >*>(static_cast<TesterServerWorkloadActor*>(this)));
															#line 6069 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Reference<TestWorkload> && workload,int loopDepth) 
	{
															#line 898 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!workload)
															#line 6078 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 899 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("TestCreationError").detail("Reason", "Workload could not be created");
															#line 900 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			fprintf(stderr, "ERROR: The workload could not be created.\n");
															#line 901 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			return a_body1Catch2(test_specification_invalid(), loopDepth);
															#line 6086 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 903 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		Future<Void> test = runWorkloadAsync(cx, workIface, workload, work.databasePingDelay) || traceRole(Role::TESTER, workIface.id());
															#line 905 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		work.reply.send(workIface);
															#line 906 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		replied = true;
															#line 908 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (work.timeout > 0)
															#line 6096 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 909 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			test = timeoutError(test, work.timeout);
															#line 6100 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 912 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_2 = test;
															#line 912 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6106 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state = 3;
															#line 912 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TesterServerWorkloadActor, 2, Void >*>(static_cast<TesterServerWorkloadActor*>(this)));
															#line 6111 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Reference<TestWorkload> const& workload,int loopDepth) 
	{
		loopDepth = a_body1cont4(workload, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Reference<TestWorkload> && workload,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(workload), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state > 0) static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<TesterServerWorkloadActor*>(this)->ActorCallback< TesterServerWorkloadActor, 1, Reference<TestWorkload> >::remove();

	}
	void a_callback_fire(ActorCallback< TesterServerWorkloadActor, 1, Reference<TestWorkload> >*,Reference<TestWorkload> const& value) 
	{
		fdb_probe_actor_enter("testerServerWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TesterServerWorkloadActor, 1, Reference<TestWorkload> >*,Reference<TestWorkload> && value) 
	{
		fdb_probe_actor_enter("testerServerWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TesterServerWorkloadActor, 1, Reference<TestWorkload> >*,Error err) 
	{
		fdb_probe_actor_enter("testerServerWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 914 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		endRole(Role::TESTER, workIface.id(), "Complete");
															#line 6195 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 914 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		endRole(Role::TESTER, workIface.id(), "Complete");
															#line 6204 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state > 0) static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<TesterServerWorkloadActor*>(this)->ActorCallback< TesterServerWorkloadActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TesterServerWorkloadActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testerServerWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TesterServerWorkloadActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testerServerWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TesterServerWorkloadActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testerServerWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 874 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	WorkloadRequest work;
															#line 874 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<IClusterConnectionRecord> ccr;
															#line 874 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<struct ServerDBInfo> const> dbInfo;
															#line 874 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	LocalityData locality;
															#line 878 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	WorkloadInterface workIface;
															#line 879 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	bool replied;
															#line 880 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 6311 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via testerServerWorkload()
															#line 874 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class TesterServerWorkloadActor final : public Actor<Void>, public ActorCallback< TesterServerWorkloadActor, 0, Void >, public ActorCallback< TesterServerWorkloadActor, 1, Reference<TestWorkload> >, public ActorCallback< TesterServerWorkloadActor, 2, Void >, public FastAllocated<TesterServerWorkloadActor>, public TesterServerWorkloadActorState<TesterServerWorkloadActor> {
															#line 6316 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<TesterServerWorkloadActor>::operator new;
	using FastAllocated<TesterServerWorkloadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11387357936410357760UL, 5053412029865874432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TesterServerWorkloadActor, 0, Void >;
friend struct ActorCallback< TesterServerWorkloadActor, 1, Reference<TestWorkload> >;
friend struct ActorCallback< TesterServerWorkloadActor, 2, Void >;
															#line 874 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TesterServerWorkloadActor(WorkloadRequest const& work,Reference<IClusterConnectionRecord> const& ccr,Reference<AsyncVar<struct ServerDBInfo> const> const& dbInfo,LocalityData const& locality) 
															#line 6335 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<Void>(),
		   TesterServerWorkloadActorState<TesterServerWorkloadActor>(work, ccr, dbInfo, locality),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testerServerWorkload", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15163297854158783232UL, 16242971039806691584UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testerServerWorkload");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testerServerWorkload", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TesterServerWorkloadActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TesterServerWorkloadActor, 1, Reference<TestWorkload> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TesterServerWorkloadActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 874 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> testerServerWorkload( WorkloadRequest const& work, Reference<IClusterConnectionRecord> const& ccr, Reference<AsyncVar<struct ServerDBInfo> const> const& dbInfo, LocalityData const& locality ) {
															#line 874 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new TesterServerWorkloadActor(work, ccr, dbInfo, locality));
															#line 6370 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 934 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 6375 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via testerServerCore()
															#line 935 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class TesterServerCoreActor>
															#line 935 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class TesterServerCoreActorState {
															#line 6382 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 935 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TesterServerCoreActorState(TesterInterface const& interf,Reference<IClusterConnectionRecord> const& ccr,Reference<AsyncVar<struct ServerDBInfo> const> const& dbInfo,LocalityData const& locality,Optional<std::string> const& expectedWorkLoad) 
															#line 935 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 935 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : interf(interf),
															#line 935 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   ccr(ccr),
															#line 935 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   dbInfo(dbInfo),
															#line 935 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   locality(locality),
															#line 935 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   expectedWorkLoad(expectedWorkLoad),
															#line 940 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   addWorkload(),
															#line 941 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   workerFatalError(actorCollection(addWorkload.getFuture())),
															#line 945 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   consistencyCheckerUrgentTester(std::make_pair(0, Future<Void>()))
															#line 6403 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("testerServerCore", reinterpret_cast<unsigned long>(this));

	}
	~TesterServerCoreActorState() 
	{
		fdb_probe_actor_destroy("testerServerCore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 947 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("StartingTesterServerCore", interf.id()) .detail("ExpectedWorkload", expectedWorkLoad.present() ? expectedWorkLoad.get() : "[Unset]");
															#line 949 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 6420 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TesterServerCoreActorState();
		static_cast<TesterServerCoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 950 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_0 = workerFatalError;
															#line 949 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<TesterServerCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6452 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 951 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = consistencyCheckerUrgentTester.second.isValid() ? consistencyCheckerUrgentTester.second : Never();
															#line 6456 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
															#line 957 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auto __when_expr_2 = interf.recruitments.getFuture();
															#line 6460 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_2), FutureStream<WorkloadRequest>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<WorkloadRequest>>::value, "invalid type");
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.pop(), loopDepth); };
		static_cast<TesterServerCoreActor*>(this)->actor_wait_state = 1;
															#line 950 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TesterServerCoreActor, 0, Void >*>(static_cast<TesterServerCoreActor*>(this)));
															#line 951 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TesterServerCoreActor, 1, Void >*>(static_cast<TesterServerCoreActor*>(this)));
															#line 957 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< TesterServerCoreActor, 2, WorkloadRequest >*>(static_cast<TesterServerCoreActor*>(this)));
															#line 6470 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 952 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ASSERT(consistencyCheckerUrgentTester.first != 0);
															#line 953 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterWorkloadEnd", interf.id()) .detail("ConsistencyCheckerId", consistencyCheckerUrgentTester.first);
															#line 955 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		consistencyCheckerUrgentTester = std::make_pair(0, Future<Void>());
															#line 6501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 952 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ASSERT(consistencyCheckerUrgentTester.first != 0);
															#line 953 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterWorkloadEnd", interf.id()) .detail("ConsistencyCheckerId", consistencyCheckerUrgentTester.first);
															#line 955 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		consistencyCheckerUrgentTester = std::make_pair(0, Future<Void>());
															#line 6514 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(WorkloadRequest const& work,int loopDepth) 
	{
															#line 958 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (expectedWorkLoad.present() && expectedWorkLoad.get() != work.title)
															#line 6523 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 959 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevError, "StartingTesterServerCoreUnexpectedWorkload", interf.id()) .detail("ClientId", work.clientId) .detail("ClientCount", work.clientCount) .detail("ExpectedWorkLoad", expectedWorkLoad.get()) .detail("WorkLoad", work.title);
															#line 6527 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
		else
		{
															#line 965 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (work.title == "ConsistencyCheckUrgent")
															#line 6533 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 967 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (work.sharedRandomNumber == consistencyCheckerUrgentTester.first)
															#line 6537 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				{
															#line 970 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					TraceEvent(SevWarn, "ConsistencyCheckUrgent_TesterDuplicatedRequest", interf.id()) .detail("ConsistencyCheckerId", work.sharedRandomNumber) .detail("ClientId", work.clientId) .detail("ClientCount", work.clientCount);
															#line 974 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					work.reply.sendError(consistency_check_urgent_duplicate_request());
															#line 6543 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				}
				else
				{
															#line 980 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					if (consistencyCheckerUrgentTester.second.isValid() && !consistencyCheckerUrgentTester.second.isReady())
															#line 6549 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
					{
															#line 982 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
						TraceEvent(SevWarnAlways, "ConsistencyCheckUrgent_TesterWorkloadConflict", interf.id()) .detail("ExistingConsistencyCheckerId", consistencyCheckerUrgentTester.first) .detail("ArrivingConsistencyCheckerId", work.sharedRandomNumber) .detail("ClientId", work.clientId) .detail("ClientCount", work.clientCount);
															#line 6553 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
					}
															#line 988 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					consistencyCheckerUrgentTester = std::make_pair( work.sharedRandomNumber, testerServerConsistencyCheckerUrgentWorkload(work, ccr, dbInfo));
															#line 990 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterWorkloadInitialized", interf.id()) .detail("ConsistencyCheckerId", consistencyCheckerUrgentTester.first) .detail("ClientId", work.clientId) .detail("ClientCount", work.clientCount);
															#line 6559 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				}
			}
			else
			{
															#line 996 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				addWorkload.send(testerServerWorkload(work, ccr, dbInfo, locality));
															#line 6566 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(WorkloadRequest && work,int loopDepth) 
	{
															#line 958 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (expectedWorkLoad.present() && expectedWorkLoad.get() != work.title)
															#line 6577 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 959 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevError, "StartingTesterServerCoreUnexpectedWorkload", interf.id()) .detail("ClientId", work.clientId) .detail("ClientCount", work.clientCount) .detail("ExpectedWorkLoad", expectedWorkLoad.get()) .detail("WorkLoad", work.title);
															#line 6581 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
		else
		{
															#line 965 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (work.title == "ConsistencyCheckUrgent")
															#line 6587 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 967 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (work.sharedRandomNumber == consistencyCheckerUrgentTester.first)
															#line 6591 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				{
															#line 970 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					TraceEvent(SevWarn, "ConsistencyCheckUrgent_TesterDuplicatedRequest", interf.id()) .detail("ConsistencyCheckerId", work.sharedRandomNumber) .detail("ClientId", work.clientId) .detail("ClientCount", work.clientCount);
															#line 974 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					work.reply.sendError(consistency_check_urgent_duplicate_request());
															#line 6597 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				}
				else
				{
															#line 980 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					if (consistencyCheckerUrgentTester.second.isValid() && !consistencyCheckerUrgentTester.second.isReady())
															#line 6603 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
					{
															#line 982 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
						TraceEvent(SevWarnAlways, "ConsistencyCheckUrgent_TesterWorkloadConflict", interf.id()) .detail("ExistingConsistencyCheckerId", consistencyCheckerUrgentTester.first) .detail("ArrivingConsistencyCheckerId", work.sharedRandomNumber) .detail("ClientId", work.clientId) .detail("ClientCount", work.clientCount);
															#line 6607 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
					}
															#line 988 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					consistencyCheckerUrgentTester = std::make_pair( work.sharedRandomNumber, testerServerConsistencyCheckerUrgentWorkload(work, ccr, dbInfo));
															#line 990 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterWorkloadInitialized", interf.id()) .detail("ConsistencyCheckerId", consistencyCheckerUrgentTester.first) .detail("ClientId", work.clientId) .detail("ClientCount", work.clientCount);
															#line 6613 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				}
			}
			else
			{
															#line 996 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				addWorkload.send(testerServerWorkload(work, ccr, dbInfo, locality));
															#line 6620 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TesterServerCoreActor*>(this)->actor_wait_state > 0) static_cast<TesterServerCoreActor*>(this)->actor_wait_state = 0;
		static_cast<TesterServerCoreActor*>(this)->ActorCallback< TesterServerCoreActor, 0, Void >::remove();
		static_cast<TesterServerCoreActor*>(this)->ActorCallback< TesterServerCoreActor, 1, Void >::remove();
		static_cast<TesterServerCoreActor*>(this)->ActorSingleCallback< TesterServerCoreActor, 2, WorkloadRequest >::remove();

	}
	void a_callback_fire(ActorCallback< TesterServerCoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testerServerCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TesterServerCoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testerServerCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TesterServerCoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testerServerCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TesterServerCoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testerServerCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TesterServerCoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testerServerCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TesterServerCoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testerServerCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< TesterServerCoreActor, 2, WorkloadRequest >*,WorkloadRequest const& value) 
	{
		fdb_probe_actor_enter("testerServerCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< TesterServerCoreActor, 2, WorkloadRequest >*,WorkloadRequest && value) 
	{
		fdb_probe_actor_enter("testerServerCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< TesterServerCoreActor, 2, WorkloadRequest >*,Error err) 
	{
		fdb_probe_actor_enter("testerServerCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerCore", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 935 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TesterInterface interf;
															#line 935 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<IClusterConnectionRecord> ccr;
															#line 935 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<struct ServerDBInfo> const> dbInfo;
															#line 935 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	LocalityData locality;
															#line 935 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Optional<std::string> expectedWorkLoad;
															#line 940 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	PromiseStream<Future<Void>> addWorkload;
															#line 941 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Future<Void> workerFatalError;
															#line 945 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::pair<int64_t, Future<Void>> consistencyCheckerUrgentTester;
															#line 6822 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via testerServerCore()
															#line 935 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class TesterServerCoreActor final : public Actor<Void>, public ActorCallback< TesterServerCoreActor, 0, Void >, public ActorCallback< TesterServerCoreActor, 1, Void >, public ActorSingleCallback< TesterServerCoreActor, 2, WorkloadRequest >, public FastAllocated<TesterServerCoreActor>, public TesterServerCoreActorState<TesterServerCoreActor> {
															#line 6827 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<TesterServerCoreActor>::operator new;
	using FastAllocated<TesterServerCoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5428463974152867072UL, 16691932563288750592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TesterServerCoreActor, 0, Void >;
friend struct ActorCallback< TesterServerCoreActor, 1, Void >;
friend struct ActorSingleCallback< TesterServerCoreActor, 2, WorkloadRequest >;
															#line 935 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TesterServerCoreActor(TesterInterface const& interf,Reference<IClusterConnectionRecord> const& ccr,Reference<AsyncVar<struct ServerDBInfo> const> const& dbInfo,LocalityData const& locality,Optional<std::string> const& expectedWorkLoad) 
															#line 6846 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<Void>(),
		   TesterServerCoreActorState<TesterServerCoreActor>(interf, ccr, dbInfo, locality, expectedWorkLoad),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testerServerCore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4251760122969733632UL, 1427709497491200768UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testerServerCore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testerServerCore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TesterServerCoreActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 935 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> testerServerCore( TesterInterface const& interf, Reference<IClusterConnectionRecord> const& ccr, Reference<AsyncVar<struct ServerDBInfo> const> const& dbInfo, LocalityData const& locality, Optional<std::string> const& expectedWorkLoad ) {
															#line 935 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new TesterServerCoreActor(interf, ccr, dbInfo, locality, expectedWorkLoad));
															#line 6879 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 1001 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 6884 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via clearData()
															#line 1002 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class ClearDataActor>
															#line 1002 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class ClearDataActorState {
															#line 6891 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 1002 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	ClearDataActorState(Database const& cx,Optional<TenantName> const& defaultTenant) 
															#line 1002 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 1002 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cx(cx),
															#line 1002 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   defaultTenant(defaultTenant),
															#line 1003 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   tr(cx)
															#line 6902 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("clearData", reinterpret_cast<unsigned long>(this));

	}
	~ClearDataActorState() 
	{
		fdb_probe_actor_destroy("clearData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1005 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 6917 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearDataActorState();
		static_cast<ClearDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1026 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		tr = Transaction(cx);
															#line 1027 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		;
															#line 6942 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1007 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			tr.debugTransaction(debugRandom()->randomUniqueID());
															#line 1008 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			ASSERT(tr.trState->readOptions.present() && tr.trState->readOptions.get().debugID.present());
															#line 1009 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("TesterClearingDatabaseStart", tr.trState->readOptions.get().debugID.get()).log();
															#line 1012 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			tr.clear(normalKeys);
															#line 1013 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			tr.makeSelfConflicting();
															#line 1014 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 1014 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<ClearDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6971 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearDataActor*>(this)->actor_wait_state = 1;
															#line 1014 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearDataActor, 0, Version >*>(static_cast<ClearDataActor*>(this)));
															#line 6976 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1021 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevWarn, "TesterClearingDatabaseError", tr.trState->readOptions.get().debugID.get()).error(e);
															#line 1022 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 1022 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<ClearDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7015 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ClearDataActor*>(this)->actor_wait_state = 3;
															#line 1022 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClearDataActor, 2, Void >*>(static_cast<ClearDataActor*>(this)));
															#line 7020 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& rv,int loopDepth) 
	{
															#line 1015 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TesterClearingDatabaseRV", tr.trState->readOptions.get().debugID.get()).detail("RV", rv);
															#line 1016 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 1016 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<ClearDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7039 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClearDataActor*>(this)->actor_wait_state = 2;
															#line 1016 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearDataActor, 1, Void >*>(static_cast<ClearDataActor*>(this)));
															#line 7044 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && rv,int loopDepth) 
	{
															#line 1015 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TesterClearingDatabaseRV", tr.trState->readOptions.get().debugID.get()).detail("RV", rv);
															#line 1016 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 1016 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<ClearDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7057 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClearDataActor*>(this)->actor_wait_state = 2;
															#line 1016 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearDataActor, 1, Void >*>(static_cast<ClearDataActor*>(this)));
															#line 7062 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& rv,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(rv, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && rv,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(rv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearDataActor*>(this)->actor_wait_state > 0) static_cast<ClearDataActor*>(this)->actor_wait_state = 0;
		static_cast<ClearDataActor*>(this)->ActorCallback< ClearDataActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearDataActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1017 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TesterClearingDatabase", tr.trState->readOptions.get().debugID.get()) .detail("AtVersion", tr.getCommittedVersion());
															#line 7146 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1017 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TesterClearingDatabase", tr.trState->readOptions.get().debugID.get()) .detail("AtVersion", tr.getCommittedVersion());
															#line 7155 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClearDataActor*>(this)->actor_wait_state > 0) static_cast<ClearDataActor*>(this)->actor_wait_state = 0;
		static_cast<ClearDataActor*>(this)->ActorCallback< ClearDataActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClearDataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClearDataActor*>(this)->actor_wait_state > 0) static_cast<ClearDataActor*>(this)->actor_wait_state = 0;
		static_cast<ClearDataActor*>(this)->ActorCallback< ClearDataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClearDataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1067 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		tr = Transaction(cx);
															#line 1068 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		;
															#line 7328 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 1029 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			tr.debugTransaction(debugRandom()->randomUniqueID());
															#line 1030 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			ASSERT(tr.trState->readOptions.present() && tr.trState->readOptions.get().debugID.present());
															#line 1031 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("TesterClearingTenantsStart", tr.trState->readOptions.get().debugID.get());
															#line 1032 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>>> __when_expr_3 = TenantMetadata::tenantMap().getRange(&tr, {}, {}, 1000);
															#line 1032 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<ClearDataActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7353 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_3.get(), loopDepth); };
			static_cast<ClearDataActor*>(this)->actor_wait_state = 4;
															#line 1032 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ClearDataActor, 3, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >*>(static_cast<ClearDataActor*>(this)));
															#line 7358 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1062 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevWarn, "TesterClearingTenantsError", tr.trState->readOptions.get().debugID.get()).error(e);
															#line 1063 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_6 = tr.onError(e);
															#line 1063 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<ClearDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7397 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
			static_cast<ClearDataActor*>(this)->actor_wait_state = 7;
															#line 1063 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ClearDataActor, 6, Void >*>(static_cast<ClearDataActor*>(this)));
															#line 7402 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 1035 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TesterClearingTenantsDeletingBatch", tr.trState->readOptions.get().debugID.get()) .detail("FirstTenant", tenants.results.empty() ? "<none>"_sr : tenants.results[0].second.tenantName) .detail("BatchSize", tenants.results.size());
															#line 1039 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		std::vector<Future<Void>> deleteFutures;
															#line 1040 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for( auto const& [id, entry] : tenants.results ) {
															#line 1041 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (!defaultTenant.present() || entry.tenantName != defaultTenant.get())
															#line 7423 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 1042 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				deleteFutures.push_back(TenantAPI::deleteTenantTransaction(&tr, id));
															#line 7427 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
		}
															#line 1046 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		CODE_PROBE(deleteFutures.size() > 0, "Clearing tenants after test");
															#line 1048 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_4 = waitForAll(deleteFutures);
															#line 1048 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<ClearDataActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7436 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_4.get(), loopDepth); };
		static_cast<ClearDataActor*>(this)->actor_wait_state = 5;
															#line 1048 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ClearDataActor, 4, Void >*>(static_cast<ClearDataActor*>(this)));
															#line 7441 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> const& __tenants,int loopDepth) 
	{
															#line 1032 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		tenants = __tenants;
															#line 7450 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> && __tenants,int loopDepth) 
	{
		tenants = std::move(__tenants);
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ClearDataActor*>(this)->actor_wait_state > 0) static_cast<ClearDataActor*>(this)->actor_wait_state = 0;
		static_cast<ClearDataActor*>(this)->ActorCallback< ClearDataActor, 3, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 3, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >*,KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> const& value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 3, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >*,KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> && value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ClearDataActor, 3, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1049 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_5 = tr.commit();
															#line 1049 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<ClearDataActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7531 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_5.get(), loopDepth); };
		static_cast<ClearDataActor*>(this)->actor_wait_state = 6;
															#line 1049 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ClearDataActor, 5, Void >*>(static_cast<ClearDataActor*>(this)));
															#line 7536 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1049 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_5 = tr.commit();
															#line 1049 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<ClearDataActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7547 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_5.get(), loopDepth); };
		static_cast<ClearDataActor*>(this)->actor_wait_state = 6;
															#line 1049 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ClearDataActor, 5, Void >*>(static_cast<ClearDataActor*>(this)));
															#line 7552 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ClearDataActor*>(this)->actor_wait_state > 0) static_cast<ClearDataActor*>(this)->actor_wait_state = 0;
		static_cast<ClearDataActor*>(this)->ActorCallback< ClearDataActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ClearDataActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 1051 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TesterClearingTenantsDeletedBatch", tr.trState->readOptions.get().debugID.get()) .detail("FirstTenant", tenants.results.empty() ? "<none>"_sr : tenants.results[0].second.tenantName) .detail("BatchSize", tenants.results.size());
															#line 1055 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!tenants.more)
															#line 7638 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 1056 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("TesterClearingTenantsComplete", tr.trState->readOptions.get().debugID.get()) .detail("AtVersion", tr.getCommittedVersion());
															#line 7642 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1060 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		tr.reset();
															#line 7647 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 1051 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TesterClearingTenantsDeletedBatch", tr.trState->readOptions.get().debugID.get()) .detail("FirstTenant", tenants.results.empty() ? "<none>"_sr : tenants.results[0].second.tenantName) .detail("BatchSize", tenants.results.size());
															#line 1055 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!tenants.more)
															#line 7658 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 1056 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("TesterClearingTenantsComplete", tr.trState->readOptions.get().debugID.get()) .detail("AtVersion", tr.getCommittedVersion());
															#line 7662 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1060 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		tr.reset();
															#line 7667 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ClearDataActor*>(this)->actor_wait_state > 0) static_cast<ClearDataActor*>(this)->actor_wait_state = 0;
		static_cast<ClearDataActor*>(this)->ActorCallback< ClearDataActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ClearDataActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ClearDataActor*>(this)->actor_wait_state > 0) static_cast<ClearDataActor*>(this)->actor_wait_state = 0;
		static_cast<ClearDataActor*>(this)->ActorCallback< ClearDataActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ClearDataActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1105 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<ClearDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearDataActorState(); static_cast<ClearDataActor*>(this)->destroy(); return 0; }
															#line 7851 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<ClearDataActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearDataActorState();
		static_cast<ClearDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 1070 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			tr.debugTransaction(debugRandom()->randomUniqueID());
															#line 1071 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			tr.setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1072 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<RangeResult> __when_expr_7 = tr.getRange(normalKeys, 1);
															#line 1072 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<ClearDataActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7877 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont2loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_7.get(), loopDepth); };
			static_cast<ClearDataActor*>(this)->actor_wait_state = 8;
															#line 1072 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ClearDataActor, 7, RangeResult >*>(static_cast<ClearDataActor*>(this)));
															#line 7882 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1100 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevWarn, "TesterCheckDatabaseClearedError", tr.trState->readOptions.get().debugID.get()) .error(e);
															#line 1102 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_9 = tr.onError(e);
															#line 1102 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<ClearDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7921 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_9.get(), loopDepth); };
			static_cast<ClearDataActor*>(this)->actor_wait_state = 10;
															#line 1102 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ClearDataActor, 9, Void >*>(static_cast<ClearDataActor*>(this)));
															#line 7926 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(int loopDepth) 
	{
															#line 1073 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		tenantPrefix = Optional<Key>();
															#line 1083 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!rangeResult.empty())
															#line 7943 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 1084 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (cx->defaultTenant.present())
															#line 7947 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 1085 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<TenantMapEntry> __when_expr_8 = TenantAPI::getTenant(cx.getReference(), cx->defaultTenant.get());
															#line 1085 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<ClearDataActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7953 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont2loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont2loopBody1cont2when1(__when_expr_8.get(), loopDepth); };
				static_cast<ClearDataActor*>(this)->actor_wait_state = 9;
															#line 1085 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ClearDataActor, 8, TenantMapEntry >*>(static_cast<ClearDataActor*>(this)));
															#line 7958 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont2loopBody1cont4(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(RangeResult const& __rangeResult,int loopDepth) 
	{
															#line 1072 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		rangeResult = __rangeResult;
															#line 7977 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(RangeResult && __rangeResult,int loopDepth) 
	{
		rangeResult = std::move(__rangeResult);
		loopDepth = a_body1cont2loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<ClearDataActor*>(this)->actor_wait_state > 0) static_cast<ClearDataActor*>(this)->actor_wait_state = 0;
		static_cast<ClearDataActor*>(this)->ActorCallback< ClearDataActor, 7, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 7, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 7, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ClearDataActor, 7, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont2loopBody1cont3(int loopDepth) 
	{
															#line 1096 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ASSERT(tr.trState->readOptions.present() && tr.trState->readOptions.get().debugID.present());
															#line 1097 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TesterCheckDatabaseClearedDone", tr.trState->readOptions.get().debugID.get());
															#line 8058 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont4(int loopDepth) 
	{
															#line 1089 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevError, "TesterClearFailure") .detail("DefaultTenant", cx->defaultTenant) .detail("TenantPrefix", tenantPrefix) .detail("FirstKey", rangeResult[0].key);
															#line 1094 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ASSERT(false);
															#line 8069 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont5(TenantMapEntry const& entry,int loopDepth) 
	{
															#line 1086 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		tenantPrefix = entry.prefix;
															#line 8078 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont5(TenantMapEntry && entry,int loopDepth) 
	{
															#line 1086 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		tenantPrefix = entry.prefix;
															#line 8087 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(TenantMapEntry const& entry,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(entry, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(TenantMapEntry && entry,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<ClearDataActor*>(this)->actor_wait_state > 0) static_cast<ClearDataActor*>(this)->actor_wait_state = 0;
		static_cast<ClearDataActor*>(this)->ActorCallback< ClearDataActor, 8, TenantMapEntry >::remove();

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 8, TenantMapEntry >*,TenantMapEntry const& value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont2loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 8, TenantMapEntry >*,TenantMapEntry && value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont2loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ClearDataActor, 8, TenantMapEntry >*,Error err) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<ClearDataActor*>(this)->actor_wait_state > 0) static_cast<ClearDataActor*>(this)->actor_wait_state = 0;
		static_cast<ClearDataActor*>(this)->ActorCallback< ClearDataActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ClearDataActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 1002 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 1002 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Optional<TenantName> defaultTenant;
															#line 1003 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Transaction tr;
															#line 1032 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> tenants;
															#line 1072 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RangeResult rangeResult;
															#line 1073 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Optional<Key> tenantPrefix;
															#line 8266 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via clearData()
															#line 1002 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class ClearDataActor final : public Actor<Void>, public ActorCallback< ClearDataActor, 0, Version >, public ActorCallback< ClearDataActor, 1, Void >, public ActorCallback< ClearDataActor, 2, Void >, public ActorCallback< ClearDataActor, 3, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >, public ActorCallback< ClearDataActor, 4, Void >, public ActorCallback< ClearDataActor, 5, Void >, public ActorCallback< ClearDataActor, 6, Void >, public ActorCallback< ClearDataActor, 7, RangeResult >, public ActorCallback< ClearDataActor, 8, TenantMapEntry >, public ActorCallback< ClearDataActor, 9, Void >, public FastAllocated<ClearDataActor>, public ClearDataActorState<ClearDataActor> {
															#line 8271 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<ClearDataActor>::operator new;
	using FastAllocated<ClearDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17071434670249811968UL, 11987251180972432640UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearDataActor, 0, Version >;
friend struct ActorCallback< ClearDataActor, 1, Void >;
friend struct ActorCallback< ClearDataActor, 2, Void >;
friend struct ActorCallback< ClearDataActor, 3, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >;
friend struct ActorCallback< ClearDataActor, 4, Void >;
friend struct ActorCallback< ClearDataActor, 5, Void >;
friend struct ActorCallback< ClearDataActor, 6, Void >;
friend struct ActorCallback< ClearDataActor, 7, RangeResult >;
friend struct ActorCallback< ClearDataActor, 8, TenantMapEntry >;
friend struct ActorCallback< ClearDataActor, 9, Void >;
															#line 1002 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	ClearDataActor(Database const& cx,Optional<TenantName> const& defaultTenant) 
															#line 8297 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<Void>(),
		   ClearDataActorState<ClearDataActor>(cx, defaultTenant),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5520910524537141504UL, 13876443903069959424UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearDataActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClearDataActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClearDataActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ClearDataActor, 3, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ClearDataActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ClearDataActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ClearDataActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< ClearDataActor, 7, RangeResult >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< ClearDataActor, 8, TenantMapEntry >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< ClearDataActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1002 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> clearData( Database const& cx, Optional<TenantName> const& defaultTenant ) {
															#line 1002 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new ClearDataActor(cx, defaultTenant));
															#line 8339 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 1107 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

Future<Void> dumpDatabase(Database const& cx, std::string const& outputFilename, KeyRange const& range);

int passCount = 0;
int failCount = 0;

std::vector<PerfMetric> aggregateMetrics(std::vector<std::vector<PerfMetric>> metrics) {
	std::map<std::string, std::vector<PerfMetric>> metricMap;
	for (int i = 0; i < metrics.size(); i++) {
		std::vector<PerfMetric> workloadMetrics = metrics[i];
		TraceEvent("MetricsReturned").detail("Count", workloadMetrics.size());
		for (int m = 0; m < workloadMetrics.size(); m++) {
			printf("Metric (%d, %d): %s, %f, %s\n",
			       i,
			       m,
			       workloadMetrics[m].name().c_str(),
			       workloadMetrics[m].value(),
			       workloadMetrics[m].formatted().c_str());
			metricMap[workloadMetrics[m].name()].push_back(workloadMetrics[m]);
		}
	}
	TraceEvent("Metric")
	    .detail("Name", "Reporting Clients")
	    .detail("Value", (double)metrics.size())
	    .detail("Formatted", format("%d", metrics.size()).c_str());

	std::vector<PerfMetric> result;
	std::map<std::string, std::vector<PerfMetric>>::iterator it;
	for (it = metricMap.begin(); it != metricMap.end(); it++) {
		auto& vec = it->second;
		if (!vec.size())
			continue;
		double sum = 0;
		for (int i = 0; i < vec.size(); i++)
			sum += vec[i].value();
		if (vec[0].averaged() && vec.size())
			sum /= vec.size();
		result.emplace_back(vec[0].name(), sum, Averaged::False, vec[0].format_code());
	}
	return result;
}

void logMetrics(std::vector<PerfMetric> metrics) {
	for (int idx = 0; idx < metrics.size(); idx++)
		TraceEvent("Metric")
		    .detail("Name", metrics[idx].name())
		    .detail("Value", metrics[idx].value())
		    .detail("Formatted", format(metrics[idx].format_code().c_str(), metrics[idx].value()));
}

template <class T>
void throwIfError(const std::vector<Future<ErrorOr<T>>>& futures, std::string errorMsg) {
	for (auto& future : futures) {
		if (future.get().isError()) {
			TraceEvent(SevError, errorMsg.c_str()).error(future.get().getError());
			throw future.get().getError();
		}
	}
}

struct TesterConsistencyScanState {
	bool enabled = false;
	bool enableAfter = false;
	bool waitForComplete = false;
};

															#line 8409 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via checkConsistencyScanAfterTest()
															#line 1173 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class CheckConsistencyScanAfterTestActor>
															#line 1173 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class CheckConsistencyScanAfterTestActorState {
															#line 8416 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 1173 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	CheckConsistencyScanAfterTestActorState(Database const& cx,TesterConsistencyScanState* const& csState) 
															#line 1173 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 1173 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cx(cx),
															#line 1173 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   csState(csState)
															#line 8425 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this));

	}
	~CheckConsistencyScanAfterTestActorState() 
	{
		fdb_probe_actor_destroy("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1174 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (!csState->enabled)
															#line 8440 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 1175 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (!static_cast<CheckConsistencyScanAfterTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckConsistencyScanAfterTestActorState(); static_cast<CheckConsistencyScanAfterTestActor*>(this)->destroy(); return 0; }
															#line 8444 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				new (&static_cast<CheckConsistencyScanAfterTestActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CheckConsistencyScanAfterTestActorState();
				static_cast<CheckConsistencyScanAfterTestActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1179 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			csState->enabled = false;
															#line 1181 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (csState->enableAfter || csState->waitForComplete)
															#line 8454 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 1182 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				printf("Enabling consistency scan after test ...\n");
															#line 1183 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_0 = enableConsistencyScanInSim(cx);
															#line 1183 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<CheckConsistencyScanAfterTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8462 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CheckConsistencyScanAfterTestActor*>(this)->actor_wait_state = 1;
															#line 1183 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckConsistencyScanAfterTestActor, 0, Void >*>(static_cast<CheckConsistencyScanAfterTestActor*>(this)));
															#line 8467 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckConsistencyScanAfterTestActorState();
		static_cast<CheckConsistencyScanAfterTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1187 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = disableConsistencyScanInSim(cx, csState->waitForComplete);
															#line 1187 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<CheckConsistencyScanAfterTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8497 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckConsistencyScanAfterTestActor*>(this)->actor_wait_state = 2;
															#line 1187 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckConsistencyScanAfterTestActor, 1, Void >*>(static_cast<CheckConsistencyScanAfterTestActor*>(this)));
															#line 8502 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1184 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("Enabled consistency scan after test.\n");
															#line 8511 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1184 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("Enabled consistency scan after test.\n");
															#line 8520 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckConsistencyScanAfterTestActor*>(this)->actor_wait_state > 0) static_cast<CheckConsistencyScanAfterTestActor*>(this)->actor_wait_state = 0;
		static_cast<CheckConsistencyScanAfterTestActor*>(this)->ActorCallback< CheckConsistencyScanAfterTestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckConsistencyScanAfterTestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanAfterTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckConsistencyScanAfterTestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanAfterTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckConsistencyScanAfterTestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanAfterTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 1189 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<CheckConsistencyScanAfterTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckConsistencyScanAfterTestActorState(); static_cast<CheckConsistencyScanAfterTestActor*>(this)->destroy(); return 0; }
															#line 8604 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<CheckConsistencyScanAfterTestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckConsistencyScanAfterTestActorState();
		static_cast<CheckConsistencyScanAfterTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 1189 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<CheckConsistencyScanAfterTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckConsistencyScanAfterTestActorState(); static_cast<CheckConsistencyScanAfterTestActor*>(this)->destroy(); return 0; }
															#line 8616 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<CheckConsistencyScanAfterTestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckConsistencyScanAfterTestActorState();
		static_cast<CheckConsistencyScanAfterTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckConsistencyScanAfterTestActor*>(this)->actor_wait_state > 0) static_cast<CheckConsistencyScanAfterTestActor*>(this)->actor_wait_state = 0;
		static_cast<CheckConsistencyScanAfterTestActor*>(this)->ActorCallback< CheckConsistencyScanAfterTestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckConsistencyScanAfterTestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanAfterTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckConsistencyScanAfterTestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanAfterTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckConsistencyScanAfterTestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanAfterTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1173 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 1173 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TesterConsistencyScanState* csState;
															#line 8703 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via checkConsistencyScanAfterTest()
															#line 1173 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class CheckConsistencyScanAfterTestActor final : public Actor<Void>, public ActorCallback< CheckConsistencyScanAfterTestActor, 0, Void >, public ActorCallback< CheckConsistencyScanAfterTestActor, 1, Void >, public FastAllocated<CheckConsistencyScanAfterTestActor>, public CheckConsistencyScanAfterTestActorState<CheckConsistencyScanAfterTestActor> {
															#line 8708 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<CheckConsistencyScanAfterTestActor>::operator new;
	using FastAllocated<CheckConsistencyScanAfterTestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10787316003489179136UL, 164600965825183232UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckConsistencyScanAfterTestActor, 0, Void >;
friend struct ActorCallback< CheckConsistencyScanAfterTestActor, 1, Void >;
															#line 1173 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	CheckConsistencyScanAfterTestActor(Database const& cx,TesterConsistencyScanState* const& csState) 
															#line 8726 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<Void>(),
		   CheckConsistencyScanAfterTestActorState<CheckConsistencyScanAfterTestActor>(cx, csState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2578644973355073280UL, 10560269047676019712UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanAfterTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkConsistencyScanAfterTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckConsistencyScanAfterTestActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckConsistencyScanAfterTestActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1173 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> checkConsistencyScanAfterTest( Database const& cx, TesterConsistencyScanState* const& csState ) {
															#line 1173 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new CheckConsistencyScanAfterTestActor(cx, csState));
															#line 8760 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 1191 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 8765 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via runWorkload()
															#line 1192 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class RunWorkloadActor>
															#line 1192 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunWorkloadActorState {
															#line 8772 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 1192 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunWorkloadActorState(Database const& cx,std::vector<TesterInterface> const& testers,TestSpec const& spec,Optional<TenantName> const& defaultTenant) 
															#line 1192 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 1192 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cx(cx),
															#line 1192 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   testers(testers),
															#line 1192 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   spec(spec),
															#line 1192 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   defaultTenant(defaultTenant)
															#line 8785 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("runWorkload", reinterpret_cast<unsigned long>(this));

	}
	~RunWorkloadActorState() 
	{
		fdb_probe_actor_destroy("runWorkload", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1196 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("TestRunning") .detail("WorkloadTitle", spec.title) .detail("TesterCount", testers.size()) .detail("Phases", spec.phases) .detail("TestTimeout", spec.timeout);
															#line 1202 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			workRequests = std::vector<Future<WorkloadInterface>>();
															#line 1203 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			metricsResults = std::vector<std::vector<PerfMetric>>();
															#line 1205 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			i = 0;
															#line 1206 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			success = 0;
															#line 1207 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			failure = 0;
															#line 1208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			int64_t sharedRandom = deterministicRandom()->randomInt64(0, 10000000);
															#line 1209 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for(;i < testers.size();i++) {
															#line 1210 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				WorkloadRequest req;
															#line 1211 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.title = spec.title;
															#line 1212 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.useDatabase = spec.useDB;
															#line 1213 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.runFailureWorkloads = spec.runFailureWorkloads;
															#line 1214 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.timeout = spec.timeout;
															#line 1215 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.databasePingDelay = spec.useDB ? spec.databasePingDelay : 0.0;
															#line 1216 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.options = spec.options;
															#line 1217 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.clientId = i;
															#line 1218 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.clientCount = testers.size();
															#line 1219 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.sharedRandomNumber = sharedRandom;
															#line 1220 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.defaultTenant = defaultTenant.castTo<TenantNameRef>();
															#line 1221 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.disabledFailureInjectionWorkloads = spec.disabledFailureInjectionWorkloads;
															#line 1222 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				workRequests.push_back(testers[i].recruitments.getReply(req));
															#line 8840 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 1225 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<std::vector<WorkloadInterface>> __when_expr_0 = getAll(workRequests);
															#line 1225 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8846 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunWorkloadActor*>(this)->actor_wait_state = 1;
															#line 1225 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadActor, 0, std::vector<WorkloadInterface> >*>(static_cast<RunWorkloadActor*>(this)));
															#line 8851 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunWorkloadActorState();
		static_cast<RunWorkloadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1226 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		waitForFailureTime = g_network->isSimulated() ? 24 * 60 * 60 : 60;
															#line 1227 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (g_network->isSimulated() && spec.simCheckRelocationDuration)
															#line 8876 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 1228 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			debug_setCheckRelocationDuration(true);
															#line 8880 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 1230 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (spec.phases & TestWorkload::SETUP)
															#line 8884 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 1231 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			setups = std::vector<Future<ErrorOr<Void>>>();
															#line 1232 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			printf("setting up test (%s)...\n", printable(spec.title).c_str());
															#line 1233 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("TestSetupStart").detail("WorkloadTitle", spec.title);
															#line 1234 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			setups.reserve(workloads.size());
															#line 1235 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for(int i = 0;i < workloads.size();i++) {
															#line 1236 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				setups.push_back(workloads[i].setup.template getReplyUnlessFailedFor<Void>(waitForFailureTime, 0));
															#line 8898 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 1237 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_1 = waitForAll(setups);
															#line 1237 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8904 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunWorkloadActor*>(this)->actor_wait_state = 2;
															#line 1237 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadActor, 1, Void >*>(static_cast<RunWorkloadActor*>(this)));
															#line 8909 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkloadInterface> const& __workloads,int loopDepth) 
	{
															#line 1225 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		workloads = __workloads;
															#line 8923 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkloadInterface> && __workloads,int loopDepth) 
	{
		workloads = std::move(__workloads);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunWorkloadActor*>(this)->actor_wait_state > 0) static_cast<RunWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<RunWorkloadActor*>(this)->ActorCallback< RunWorkloadActor, 0, std::vector<WorkloadInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< RunWorkloadActor, 0, std::vector<WorkloadInterface> >*,std::vector<WorkloadInterface> const& value) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunWorkloadActor, 0, std::vector<WorkloadInterface> >*,std::vector<WorkloadInterface> && value) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunWorkloadActor, 0, std::vector<WorkloadInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1242 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (spec.phases & TestWorkload::EXECUTION)
															#line 9002 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 1243 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("TestStarting").detail("WorkloadTitle", spec.title);
															#line 1244 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			printf("running test (%s)...\n", printable(spec.title).c_str());
															#line 1245 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			starts = std::vector<Future<ErrorOr<Void>>>();
															#line 1246 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			starts.reserve(workloads.size());
															#line 1247 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for(int i = 0;i < workloads.size();i++) {
															#line 1248 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				starts.push_back(workloads[i].start.template getReplyUnlessFailedFor<Void>(waitForFailureTime, 0));
															#line 9016 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 1249 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_2 = waitForAll(starts);
															#line 1249 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9022 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunWorkloadActor*>(this)->actor_wait_state = 3;
															#line 1249 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadActor, 2, Void >*>(static_cast<RunWorkloadActor*>(this)));
															#line 9027 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 1238 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		throwIfError(setups, "SetupFailedForWorkload" + printable(spec.title));
															#line 1239 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestSetupComplete").detail("WorkloadTitle", spec.title);
															#line 9043 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 1238 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		throwIfError(setups, "SetupFailedForWorkload" + printable(spec.title));
															#line 1239 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestSetupComplete").detail("WorkloadTitle", spec.title);
															#line 9054 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunWorkloadActor*>(this)->actor_wait_state > 0) static_cast<RunWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<RunWorkloadActor*>(this)->ActorCallback< RunWorkloadActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunWorkloadActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunWorkloadActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunWorkloadActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 1255 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (spec.phases & TestWorkload::CHECK)
															#line 9138 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 1256 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (spec.useDB && (spec.phases & TestWorkload::EXECUTION))
															#line 9142 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 1257 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_3 = delay(3.0);
															#line 1257 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9148 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont8when1(__when_expr_3.get(), loopDepth); };
				static_cast<RunWorkloadActor*>(this)->actor_wait_state = 4;
															#line 1257 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadActor, 3, Void >*>(static_cast<RunWorkloadActor*>(this)));
															#line 9153 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont13(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont12(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 1250 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		throwIfError(starts, "StartFailedForWorkload" + printable(spec.title));
															#line 1251 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("%s complete\n", printable(spec.title).c_str());
															#line 1252 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestComplete").detail("WorkloadTitle", spec.title);
															#line 9176 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 1250 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		throwIfError(starts, "StartFailedForWorkload" + printable(spec.title));
															#line 1251 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("%s complete\n", printable(spec.title).c_str());
															#line 1252 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestComplete").detail("WorkloadTitle", spec.title);
															#line 9189 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunWorkloadActor*>(this)->actor_wait_state > 0) static_cast<RunWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<RunWorkloadActor*>(this)->ActorCallback< RunWorkloadActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunWorkloadActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunWorkloadActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunWorkloadActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont12(int loopDepth) 
	{
															#line 1281 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (spec.phases & TestWorkload::METRICS)
															#line 9273 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 1282 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			metricTasks = std::vector<Future<ErrorOr<std::vector<PerfMetric>>>>();
															#line 1283 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			printf("fetching metrics (%s)...\n", printable(spec.title).c_str());
															#line 1284 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("TestFetchingMetrics").detail("WorkloadTitle", spec.title);
															#line 1285 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			metricTasks.reserve(workloads.size());
															#line 1286 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for(int i = 0;i < workloads.size();i++) {
															#line 1287 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				metricTasks.push_back( workloads[i].metrics.template getReplyUnlessFailedFor<std::vector<PerfMetric>>(waitForFailureTime, 0));
															#line 9287 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 1289 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_5 = waitForAll(metricTasks);
															#line 1289 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9293 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont12when1(__when_expr_5.get(), loopDepth); };
			static_cast<RunWorkloadActor*>(this)->actor_wait_state = 6;
															#line 1289 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadActor, 5, Void >*>(static_cast<RunWorkloadActor*>(this)));
															#line 9298 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13(int loopDepth) 
	{
															#line 1260 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		checks = std::vector<Future<ErrorOr<CheckReply>>>();
															#line 1261 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestCheckingResults").detail("WorkloadTitle", spec.title);
															#line 1263 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("checking test (%s)...\n", printable(spec.title).c_str());
															#line 1265 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		checks.reserve(workloads.size());
															#line 1266 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < workloads.size();i++) {
															#line 1267 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			checks.push_back(workloads[i].check.template getReplyUnlessFailedFor<CheckReply>(waitForFailureTime, 0));
															#line 9322 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 1268 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_4 = waitForAll(checks);
															#line 1268 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9328 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont13when1(__when_expr_4.get(), loopDepth); };
		static_cast<RunWorkloadActor*>(this)->actor_wait_state = 5;
															#line 1268 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadActor, 4, Void >*>(static_cast<RunWorkloadActor*>(this)));
															#line 9333 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont14(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunWorkloadActor*>(this)->actor_wait_state > 0) static_cast<RunWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<RunWorkloadActor*>(this)->ActorCallback< RunWorkloadActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunWorkloadActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunWorkloadActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunWorkloadActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont13cont1(Void const& _,int loopDepth) 
	{
															#line 1270 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		throwIfError(checks, "CheckFailedForWorkload" + printable(spec.title));
															#line 1272 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < checks.size();i++) {
															#line 1273 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (checks[i].get().get().value)
															#line 9433 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 1274 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				success++;
															#line 9437 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
			else
			{
															#line 1276 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				failure++;
															#line 9443 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
		}
															#line 1278 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestCheckComplete").detail("WorkloadTitle", spec.title);
															#line 9448 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont1(Void && _,int loopDepth) 
	{
															#line 1270 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		throwIfError(checks, "CheckFailedForWorkload" + printable(spec.title));
															#line 1272 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < checks.size();i++) {
															#line 1273 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (checks[i].get().get().value)
															#line 9461 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 1274 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				success++;
															#line 9465 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
			else
			{
															#line 1276 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				failure++;
															#line 9471 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
		}
															#line 1278 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestCheckComplete").detail("WorkloadTitle", spec.title);
															#line 9476 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont13when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont13when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RunWorkloadActor*>(this)->actor_wait_state > 0) static_cast<RunWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<RunWorkloadActor*>(this)->ActorCallback< RunWorkloadActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunWorkloadActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont13when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RunWorkloadActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont13when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RunWorkloadActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12cont1(int loopDepth) 
	{
															#line 1298 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < workloads.size();i++) {
															#line 1299 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			workloads[i].stop.send(ReplyPromise<Void>());
															#line 9562 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 1301 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<RunWorkloadActor*>(this)->SAV<DistributedTestResults>::futures) { (void)(DistributedTestResults(aggregateMetrics(metricsResults), success, failure)); this->~RunWorkloadActorState(); static_cast<RunWorkloadActor*>(this)->destroy(); return 0; }
															#line 9566 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<RunWorkloadActor*>(this)->SAV< DistributedTestResults >::value()) DistributedTestResults(DistributedTestResults(aggregateMetrics(metricsResults), success, failure));
		this->~RunWorkloadActorState();
		static_cast<RunWorkloadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont2(Void const& _,int loopDepth) 
	{
															#line 1290 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		throwIfError(metricTasks, "MetricFailedForWorkload" + printable(spec.title));
															#line 1291 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < metricTasks.size();i++) {
															#line 1292 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			metricsResults.push_back(metricTasks[i].get().get());
															#line 9582 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2(Void && _,int loopDepth) 
	{
															#line 1290 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		throwIfError(metricTasks, "MetricFailedForWorkload" + printable(spec.title));
															#line 1291 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < metricTasks.size();i++) {
															#line 1292 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			metricsResults.push_back(metricTasks[i].get().get());
															#line 9596 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RunWorkloadActor*>(this)->actor_wait_state > 0) static_cast<RunWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<RunWorkloadActor*>(this)->ActorCallback< RunWorkloadActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunWorkloadActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RunWorkloadActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RunWorkloadActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 1192 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 1192 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<TesterInterface> testers;
															#line 1192 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TestSpec spec;
															#line 1192 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Optional<TenantName> defaultTenant;
															#line 1202 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<Future<WorkloadInterface>> workRequests;
															#line 1203 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<std::vector<PerfMetric>> metricsResults;
															#line 1205 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	int i;
															#line 1206 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	int success;
															#line 1207 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	int failure;
															#line 1225 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<WorkloadInterface> workloads;
															#line 1226 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double waitForFailureTime;
															#line 1231 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<Future<ErrorOr<Void>>> setups;
															#line 1245 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<Future<ErrorOr<Void>>> starts;
															#line 1260 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<Future<ErrorOr<CheckReply>>> checks;
															#line 1282 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<Future<ErrorOr<std::vector<PerfMetric>>>> metricTasks;
															#line 9707 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via runWorkload()
															#line 1192 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunWorkloadActor final : public Actor<DistributedTestResults>, public ActorCallback< RunWorkloadActor, 0, std::vector<WorkloadInterface> >, public ActorCallback< RunWorkloadActor, 1, Void >, public ActorCallback< RunWorkloadActor, 2, Void >, public ActorCallback< RunWorkloadActor, 3, Void >, public ActorCallback< RunWorkloadActor, 4, Void >, public ActorCallback< RunWorkloadActor, 5, Void >, public FastAllocated<RunWorkloadActor>, public RunWorkloadActorState<RunWorkloadActor> {
															#line 9712 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<RunWorkloadActor>::operator new;
	using FastAllocated<RunWorkloadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16129632344421734400UL, 1334177331649544192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<DistributedTestResults>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunWorkloadActor, 0, std::vector<WorkloadInterface> >;
friend struct ActorCallback< RunWorkloadActor, 1, Void >;
friend struct ActorCallback< RunWorkloadActor, 2, Void >;
friend struct ActorCallback< RunWorkloadActor, 3, Void >;
friend struct ActorCallback< RunWorkloadActor, 4, Void >;
friend struct ActorCallback< RunWorkloadActor, 5, Void >;
															#line 1192 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunWorkloadActor(Database const& cx,std::vector<TesterInterface> const& testers,TestSpec const& spec,Optional<TenantName> const& defaultTenant) 
															#line 9734 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<DistributedTestResults>(),
		   RunWorkloadActorState<RunWorkloadActor>(cx, testers, spec, defaultTenant),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1693389394735498752UL, 3664295469201664512UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runWorkload");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunWorkloadActor, 0, std::vector<WorkloadInterface> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunWorkloadActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunWorkloadActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunWorkloadActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RunWorkloadActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RunWorkloadActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1192 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<DistributedTestResults> runWorkload( Database const& cx, std::vector<TesterInterface> const& testers, TestSpec const& spec, Optional<TenantName> const& defaultTenant ) {
															#line 1192 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<DistributedTestResults>(new RunWorkloadActor(cx, testers, spec, defaultTenant));
															#line 9772 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 1303 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

// Sets the database configuration by running the ChangeConfig workload
															#line 9778 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via changeConfiguration()
															#line 1305 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class ChangeConfigurationActor>
															#line 1305 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class ChangeConfigurationActorState {
															#line 9785 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 1305 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	ChangeConfigurationActorState(Database const& cx,std::vector<TesterInterface> const& testers,StringRef const& configMode) 
															#line 1305 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 1305 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cx(cx),
															#line 1305 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   testers(testers),
															#line 1305 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   configMode(configMode),
															#line 1306 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   spec()
															#line 9798 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("changeConfiguration", reinterpret_cast<unsigned long>(this));

	}
	~ChangeConfigurationActorState() 
	{
		fdb_probe_actor_destroy("changeConfiguration", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1307 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			Standalone<VectorRef<KeyValueRef>> options;
															#line 1308 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			spec.title = "ChangeConfig"_sr;
															#line 1309 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			spec.runFailureWorkloads = false;
															#line 1310 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			options.push_back_deep(options.arena(), KeyValueRef("testName"_sr, "ChangeConfig"_sr));
															#line 1311 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			options.push_back_deep(options.arena(), KeyValueRef("configMode"_sr, configMode));
															#line 1312 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			spec.options.push_back_deep(spec.options.arena(), options);
															#line 1314 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<DistributedTestResults> __when_expr_0 = runWorkload(cx, testers, spec, Optional<TenantName>());
															#line 1314 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<ChangeConfigurationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9827 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ChangeConfigurationActor*>(this)->actor_wait_state = 1;
															#line 1314 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigurationActor, 0, DistributedTestResults >*>(static_cast<ChangeConfigurationActor*>(this)));
															#line 9832 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeConfigurationActorState();
		static_cast<ChangeConfigurationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(DistributedTestResults const& testResults,int loopDepth) 
	{
															#line 1316 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<ChangeConfigurationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeConfigurationActorState(); static_cast<ChangeConfigurationActor*>(this)->destroy(); return 0; }
															#line 9855 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<ChangeConfigurationActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeConfigurationActorState();
		static_cast<ChangeConfigurationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(DistributedTestResults && testResults,int loopDepth) 
	{
															#line 1316 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<ChangeConfigurationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeConfigurationActorState(); static_cast<ChangeConfigurationActor*>(this)->destroy(); return 0; }
															#line 9867 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<ChangeConfigurationActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeConfigurationActorState();
		static_cast<ChangeConfigurationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(DistributedTestResults const& testResults,int loopDepth) 
	{
		loopDepth = a_body1cont1(testResults, loopDepth);

		return loopDepth;
	}
	int a_body1when1(DistributedTestResults && testResults,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(testResults), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeConfigurationActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigurationActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigurationActor*>(this)->ActorCallback< ChangeConfigurationActor, 0, DistributedTestResults >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigurationActor, 0, DistributedTestResults >*,DistributedTestResults const& value) 
	{
		fdb_probe_actor_enter("changeConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeConfigurationActor, 0, DistributedTestResults >*,DistributedTestResults && value) 
	{
		fdb_probe_actor_enter("changeConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeConfigurationActor, 0, DistributedTestResults >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1305 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 1305 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<TesterInterface> testers;
															#line 1305 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	StringRef configMode;
															#line 1306 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TestSpec spec;
															#line 9958 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via changeConfiguration()
															#line 1305 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class ChangeConfigurationActor final : public Actor<Void>, public ActorCallback< ChangeConfigurationActor, 0, DistributedTestResults >, public FastAllocated<ChangeConfigurationActor>, public ChangeConfigurationActorState<ChangeConfigurationActor> {
															#line 9963 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<ChangeConfigurationActor>::operator new;
	using FastAllocated<ChangeConfigurationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17121133842389657856UL, 13112040985702699520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeConfigurationActor, 0, DistributedTestResults >;
															#line 1305 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	ChangeConfigurationActor(Database const& cx,std::vector<TesterInterface> const& testers,StringRef const& configMode) 
															#line 9980 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<Void>(),
		   ChangeConfigurationActorState<ChangeConfigurationActor>(cx, testers, configMode),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeConfiguration", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10067441070874341888UL, 15153484123940199936UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeConfiguration");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeConfiguration", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeConfigurationActor, 0, DistributedTestResults >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1305 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> changeConfiguration( Database const& cx, std::vector<TesterInterface> const& testers, StringRef const& configMode ) {
															#line 1305 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new ChangeConfigurationActor(cx, testers, configMode));
															#line 10013 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 1318 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 10018 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via auditStorageCorrectness()
															#line 1319 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class AuditStorageCorrectnessActor>
															#line 1319 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class AuditStorageCorrectnessActorState {
															#line 10025 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 1319 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	AuditStorageCorrectnessActorState(Reference<AsyncVar<ServerDBInfo>> const& dbInfo,AuditType const& auditType) 
															#line 1319 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 1319 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : dbInfo(dbInfo),
															#line 1319 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   auditType(auditType)
															#line 10034 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("auditStorageCorrectness", reinterpret_cast<unsigned long>(this));

	}
	~AuditStorageCorrectnessActorState() 
	{
		fdb_probe_actor_destroy("auditStorageCorrectness", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1320 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (SERVER_KNOBS->DISABLE_AUDIT_STORAGE_FINAL_REPLICA_CHECK_IN_SIM && (auditType == AuditType::ValidateHA || auditType == AuditType::ValidateReplica))
															#line 10049 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 1322 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (!static_cast<AuditStorageCorrectnessActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AuditStorageCorrectnessActorState(); static_cast<AuditStorageCorrectnessActor*>(this)->destroy(); return 0; }
															#line 10053 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				new (&static_cast<AuditStorageCorrectnessActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~AuditStorageCorrectnessActorState();
				static_cast<AuditStorageCorrectnessActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1324 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevDebug, "AuditStorageCorrectnessBegin").detail("AuditType", auditType);
															#line 1325 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			cx = Database();
															#line 1326 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			auditId = UID();
															#line 1327 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			auditState = AuditStorageState();
															#line 1328 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 10069 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AuditStorageCorrectnessActorState();
		static_cast<AuditStorageCorrectnessActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1349 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		retryCount = 0;
															#line 1350 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		;
															#line 10094 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1330 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 10111 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1342 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevWarn, "AuditStorageCorrectnessTriggerError") .errorUnsuppressed(e) .detail("AuditID", auditId) .detail("AuditType", auditType);
															#line 1346 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(1);
															#line 1346 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10150 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state = 3;
															#line 1346 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AuditStorageCorrectnessActor, 2, Void >*>(static_cast<AuditStorageCorrectnessActor*>(this)));
															#line 10155 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1334 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TriggerAuditRequest req(auditType, allKeys, KeyValueStoreType::END);
															#line 1335 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<UID> __when_expr_1 = timeoutError(dbInfo->get().distributor.get().triggerAudit.getReply(req), 300);
															#line 1335 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10174 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state = 2;
															#line 1335 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AuditStorageCorrectnessActor, 1, UID >*>(static_cast<AuditStorageCorrectnessActor*>(this)));
															#line 10179 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 1330 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!(dbInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS || !dbInfo->get().distributor.present()))
															#line 10195 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1332 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_0 = dbInfo->onChange();
															#line 1332 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10203 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state = 1;
															#line 1332 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AuditStorageCorrectnessActor, 0, Void >*>(static_cast<AuditStorageCorrectnessActor*>(this)));
															#line 10208 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageCorrectnessActor*>(this)->ActorCallback< AuditStorageCorrectnessActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageCorrectnessActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AuditStorageCorrectnessActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AuditStorageCorrectnessActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(UID const& auditId_,int loopDepth) 
	{
															#line 1336 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auditId = auditId_;
															#line 1337 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevDebug, "AuditStorageCorrectnessTriggered") .detail("AuditID", auditId) .detail("AuditType", auditType);
															#line 10319 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(UID && auditId_,int loopDepth) 
	{
															#line 1336 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auditId = auditId_;
															#line 1337 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevDebug, "AuditStorageCorrectnessTriggered") .detail("AuditID", auditId) .detail("AuditType", auditType);
															#line 10330 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(UID const& auditId_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(auditId_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(UID && auditId_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(auditId_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageCorrectnessActor*>(this)->ActorCallback< AuditStorageCorrectnessActor, 1, UID >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageCorrectnessActor, 1, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AuditStorageCorrectnessActor, 1, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AuditStorageCorrectnessActor, 1, UID >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageCorrectnessActor*>(this)->ActorCallback< AuditStorageCorrectnessActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageCorrectnessActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AuditStorageCorrectnessActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AuditStorageCorrectnessActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1387 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("AuditStorageCorrectnessWaitEnd") .detail("AuditID", auditId) .detail("AuditType", auditType) .detail("AuditState", auditState.toString());
															#line 1392 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<AuditStorageCorrectnessActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AuditStorageCorrectnessActorState(); static_cast<AuditStorageCorrectnessActor*>(this)->destroy(); return 0; }
															#line 10503 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<AuditStorageCorrectnessActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AuditStorageCorrectnessActorState();
		static_cast<AuditStorageCorrectnessActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 1352 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			cx = openDBOnServer(dbInfo);
															#line 1353 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<AuditStorageState> __when_expr_3 = getAuditState(cx, auditType, auditId);
															#line 1353 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10527 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_3.get(), loopDepth); };
			static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state = 4;
															#line 1353 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< AuditStorageCorrectnessActor, 3, AuditStorageState >*>(static_cast<AuditStorageCorrectnessActor*>(this)));
															#line 10532 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1379 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("AuditStorageCorrectnessWaitError") .errorUnsuppressed(e) .detail("AuditID", auditId) .detail("AuditType", auditType) .detail("AuditState", auditState.toString());
															#line 1384 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_5 = delay(1);
															#line 1384 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10571 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state = 6;
															#line 1384 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< AuditStorageCorrectnessActor, 5, Void >*>(static_cast<AuditStorageCorrectnessActor*>(this)));
															#line 10576 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(AuditStorageState const& auditState_,int loopDepth) 
	{
															#line 1354 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auditState = auditState_;
															#line 1355 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (auditState.getPhase() == AuditPhase::Complete)
															#line 10593 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 1357 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (auditState.getPhase() == AuditPhase::Running)
															#line 10601 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 1358 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent("AuditStorageCorrectnessWait") .detail("AuditID", auditId) .detail("AuditType", auditType) .detail("RetryCount", retryCount);
															#line 1362 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_4 = delay(25);
															#line 1362 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10609 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_4.get(), loopDepth); };
				static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state = 5;
															#line 1362 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< AuditStorageCorrectnessActor, 4, Void >*>(static_cast<AuditStorageCorrectnessActor*>(this)));
															#line 10614 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1371 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (auditState.getPhase() == AuditPhase::Error)
															#line 10621 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				{
					return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
				}
				else
				{
															#line 1373 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					if (auditState.getPhase() == AuditPhase::Failed)
															#line 10629 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
					{
						return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
					}
					else
					{
															#line 1376 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
						UNREACHABLE();
															#line 10637 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
					}
				}
				loopDepth = a_body1cont1loopBody1cont5(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(AuditStorageState && auditState_,int loopDepth) 
	{
															#line 1354 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auditState = auditState_;
															#line 1355 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (auditState.getPhase() == AuditPhase::Complete)
															#line 10652 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 1357 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (auditState.getPhase() == AuditPhase::Running)
															#line 10660 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 1358 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent("AuditStorageCorrectnessWait") .detail("AuditID", auditId) .detail("AuditType", auditType) .detail("RetryCount", retryCount);
															#line 1362 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_4 = delay(25);
															#line 1362 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10668 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_4.get(), loopDepth); };
				static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state = 5;
															#line 1362 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< AuditStorageCorrectnessActor, 4, Void >*>(static_cast<AuditStorageCorrectnessActor*>(this)));
															#line 10673 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1371 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (auditState.getPhase() == AuditPhase::Error)
															#line 10680 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				{
					return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
				}
				else
				{
															#line 1373 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					if (auditState.getPhase() == AuditPhase::Failed)
															#line 10688 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
					{
						return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
					}
					else
					{
															#line 1376 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
						UNREACHABLE();
															#line 10696 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
					}
				}
				loopDepth = a_body1cont1loopBody1cont5(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(AuditStorageState const& auditState_,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(auditState_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(AuditStorageState && auditState_,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(auditState_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageCorrectnessActor*>(this)->ActorCallback< AuditStorageCorrectnessActor, 3, AuditStorageState >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageCorrectnessActor, 3, AuditStorageState >*,AuditStorageState const& value) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< AuditStorageCorrectnessActor, 3, AuditStorageState >*,AuditStorageState && value) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< AuditStorageCorrectnessActor, 3, AuditStorageState >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 1363 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (retryCount > 20)
															#line 10796 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 1364 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("AuditStorageCorrectnessWaitFailed") .detail("AuditID", auditId) .detail("AuditType", auditType);
															#line 10800 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1369 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		retryCount++;
															#line 10805 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		return a_body1cont1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 1363 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (retryCount > 20)
															#line 10814 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 1364 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("AuditStorageCorrectnessWaitFailed") .detail("AuditID", auditId) .detail("AuditType", auditType);
															#line 10818 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1369 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		retryCount++;
															#line 10823 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		return a_body1cont1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageCorrectnessActor*>(this)->ActorCallback< AuditStorageCorrectnessActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageCorrectnessActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< AuditStorageCorrectnessActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< AuditStorageCorrectnessActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont14(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageCorrectnessActor*>(this)->ActorCallback< AuditStorageCorrectnessActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageCorrectnessActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< AuditStorageCorrectnessActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< AuditStorageCorrectnessActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 1319 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> dbInfo;
															#line 1319 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	AuditType auditType;
															#line 1325 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 1326 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	UID auditId;
															#line 1327 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	AuditStorageState auditState;
															#line 1349 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	int retryCount;
															#line 11015 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via auditStorageCorrectness()
															#line 1319 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class AuditStorageCorrectnessActor final : public Actor<Void>, public ActorCallback< AuditStorageCorrectnessActor, 0, Void >, public ActorCallback< AuditStorageCorrectnessActor, 1, UID >, public ActorCallback< AuditStorageCorrectnessActor, 2, Void >, public ActorCallback< AuditStorageCorrectnessActor, 3, AuditStorageState >, public ActorCallback< AuditStorageCorrectnessActor, 4, Void >, public ActorCallback< AuditStorageCorrectnessActor, 5, Void >, public FastAllocated<AuditStorageCorrectnessActor>, public AuditStorageCorrectnessActorState<AuditStorageCorrectnessActor> {
															#line 11020 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<AuditStorageCorrectnessActor>::operator new;
	using FastAllocated<AuditStorageCorrectnessActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5197456370656524032UL, 15452064240756521216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AuditStorageCorrectnessActor, 0, Void >;
friend struct ActorCallback< AuditStorageCorrectnessActor, 1, UID >;
friend struct ActorCallback< AuditStorageCorrectnessActor, 2, Void >;
friend struct ActorCallback< AuditStorageCorrectnessActor, 3, AuditStorageState >;
friend struct ActorCallback< AuditStorageCorrectnessActor, 4, Void >;
friend struct ActorCallback< AuditStorageCorrectnessActor, 5, Void >;
															#line 1319 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	AuditStorageCorrectnessActor(Reference<AsyncVar<ServerDBInfo>> const& dbInfo,AuditType const& auditType) 
															#line 11042 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<Void>(),
		   AuditStorageCorrectnessActorState<AuditStorageCorrectnessActor>(dbInfo, auditType),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9031458630016760320UL, 3311672436545492736UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("auditStorageCorrectness");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AuditStorageCorrectnessActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AuditStorageCorrectnessActor, 1, UID >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AuditStorageCorrectnessActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< AuditStorageCorrectnessActor, 3, AuditStorageState >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< AuditStorageCorrectnessActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< AuditStorageCorrectnessActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1319 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> auditStorageCorrectness( Reference<AsyncVar<ServerDBInfo>> const& dbInfo, AuditType const& auditType ) {
															#line 1319 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new AuditStorageCorrectnessActor(dbInfo, auditType));
															#line 11080 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 1394 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

// Runs the consistency check workload, which verifies that the database is in a consistent state
															#line 11086 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via checkConsistency()
															#line 1396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class CheckConsistencyActor>
															#line 1396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class CheckConsistencyActorState {
															#line 11093 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 1396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	CheckConsistencyActorState(Database const& cx,std::vector<TesterInterface> const& testers,bool const& doQuiescentCheck,bool const& doTSSCheck,double const& maxDDRunTime,double const& softTimeLimit,double const& databasePingDelay,Reference<AsyncVar<ServerDBInfo>> const& dbInfo) 
															#line 1396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 1396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cx(cx),
															#line 1396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   testers(testers),
															#line 1396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   doQuiescentCheck(doQuiescentCheck),
															#line 1396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   doTSSCheck(doTSSCheck),
															#line 1396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   maxDDRunTime(maxDDRunTime),
															#line 1396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   softTimeLimit(softTimeLimit),
															#line 1396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   databasePingDelay(databasePingDelay),
															#line 1396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   dbInfo(dbInfo),
															#line 1404 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   spec(),
															#line 1406 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   connectionFailures()
															#line 11118 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("checkConsistency", reinterpret_cast<unsigned long>(this));

	}
	~CheckConsistencyActorState() 
	{
		fdb_probe_actor_destroy("checkConsistency", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1407 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (g_network->isSimulated())
															#line 11133 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 1409 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				connectionFailures = g_simulator->connectionFailuresDisableDuration;
															#line 1410 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				disableConnectionFailures("ConsistencyCheck");
															#line 1411 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->isConsistencyChecked = true;
															#line 11141 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 1414 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			Standalone<VectorRef<KeyValueRef>> options;
															#line 1415 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StringRef performQuiescent = "false"_sr;
															#line 1416 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StringRef performTSSCheck = "false"_sr;
															#line 1417 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (doQuiescentCheck)
															#line 11151 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 1418 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				performQuiescent = "true"_sr;
															#line 1419 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				spec.restorePerpetualWiggleSetting = false;
															#line 11157 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 1421 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (doTSSCheck)
															#line 11161 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 1422 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				performTSSCheck = "true"_sr;
															#line 11165 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 1424 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			spec.title = "ConsistencyCheck"_sr;
															#line 1425 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			spec.databasePingDelay = databasePingDelay;
															#line 1426 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			spec.runFailureWorkloads = false;
															#line 1427 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			spec.timeout = 32000;
															#line 1428 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			options.push_back_deep(options.arena(), KeyValueRef("testName"_sr, "ConsistencyCheck"_sr));
															#line 1429 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			options.push_back_deep(options.arena(), KeyValueRef("performQuiescentChecks"_sr, performQuiescent));
															#line 1430 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			options.push_back_deep(options.arena(), KeyValueRef("performTSSCheck"_sr, performTSSCheck));
															#line 1431 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			options.push_back_deep(options.arena(), KeyValueRef("maxDDRunTime"_sr, ValueRef(options.arena(), format("%f", maxDDRunTime))));
															#line 1433 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			options.push_back_deep(options.arena(), KeyValueRef("distributed"_sr, "false"_sr));
															#line 1434 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			spec.options.push_back_deep(spec.options.arena(), options);
															#line 1436 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			start = now();
															#line 1437 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			lastRun = false;
															#line 1438 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 11193 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckConsistencyActorState();
		static_cast<CheckConsistencyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1439 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<DistributedTestResults> __when_expr_0 = runWorkload(cx, testers, spec, Optional<TenantName>());
															#line 1439 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<CheckConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11225 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CheckConsistencyActor*>(this)->actor_wait_state = 1;
															#line 1439 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckConsistencyActor, 0, DistributedTestResults >*>(static_cast<CheckConsistencyActor*>(this)));
															#line 11230 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(DistributedTestResults const& testResults,int loopDepth) 
	{
															#line 1440 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (testResults.ok() || lastRun)
															#line 11239 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 1441 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (g_network->isSimulated())
															#line 11243 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 1442 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->connectionFailuresDisableDuration = connectionFailures;
															#line 1443 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->isConsistencyChecked = false;
															#line 11249 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 1445 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (!static_cast<CheckConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckConsistencyActorState(); static_cast<CheckConsistencyActor*>(this)->destroy(); return 0; }
															#line 11253 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			new (&static_cast<CheckConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckConsistencyActorState();
			static_cast<CheckConsistencyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1447 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (now() - start > softTimeLimit)
															#line 11261 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 1448 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			spec.options[0].push_back_deep(spec.options.arena(), KeyValueRef("failureIsError"_sr, "true"_sr));
															#line 1449 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			lastRun = true;
															#line 11267 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 1452 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = repairDeadDatacenter(cx, dbInfo, "ConsistencyCheck");
															#line 1452 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<CheckConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11273 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckConsistencyActor*>(this)->actor_wait_state = 2;
															#line 1452 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckConsistencyActor, 1, Void >*>(static_cast<CheckConsistencyActor*>(this)));
															#line 11278 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(DistributedTestResults && testResults,int loopDepth) 
	{
															#line 1440 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (testResults.ok() || lastRun)
															#line 11287 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 1441 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (g_network->isSimulated())
															#line 11291 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 1442 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->connectionFailuresDisableDuration = connectionFailures;
															#line 1443 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->isConsistencyChecked = false;
															#line 11297 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 1445 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (!static_cast<CheckConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckConsistencyActorState(); static_cast<CheckConsistencyActor*>(this)->destroy(); return 0; }
															#line 11301 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			new (&static_cast<CheckConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckConsistencyActorState();
			static_cast<CheckConsistencyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1447 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (now() - start > softTimeLimit)
															#line 11309 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 1448 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			spec.options[0].push_back_deep(spec.options.arena(), KeyValueRef("failureIsError"_sr, "true"_sr));
															#line 1449 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			lastRun = true;
															#line 11315 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 1452 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = repairDeadDatacenter(cx, dbInfo, "ConsistencyCheck");
															#line 1452 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<CheckConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11321 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckConsistencyActor*>(this)->actor_wait_state = 2;
															#line 1452 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckConsistencyActor, 1, Void >*>(static_cast<CheckConsistencyActor*>(this)));
															#line 11326 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(DistributedTestResults const& testResults,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(testResults, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(DistributedTestResults && testResults,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(testResults), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckConsistencyActor*>(this)->ActorCallback< CheckConsistencyActor, 0, DistributedTestResults >::remove();

	}
	void a_callback_fire(ActorCallback< CheckConsistencyActor, 0, DistributedTestResults >*,DistributedTestResults const& value) 
	{
		fdb_probe_actor_enter("checkConsistency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistency", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckConsistencyActor, 0, DistributedTestResults >*,DistributedTestResults && value) 
	{
		fdb_probe_actor_enter("checkConsistency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistency", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckConsistencyActor, 0, DistributedTestResults >*,Error err) 
	{
		fdb_probe_actor_enter("checkConsistency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistency", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckConsistencyActor*>(this)->ActorCallback< CheckConsistencyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckConsistencyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkConsistency", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistency", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckConsistencyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkConsistency", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistency", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckConsistencyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkConsistency", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistency", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 1396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<TesterInterface> testers;
															#line 1396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	bool doQuiescentCheck;
															#line 1396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	bool doTSSCheck;
															#line 1396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double maxDDRunTime;
															#line 1396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double softTimeLimit;
															#line 1396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double databasePingDelay;
															#line 1396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> dbInfo;
															#line 1404 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TestSpec spec;
															#line 1406 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double connectionFailures;
															#line 1436 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double start;
															#line 1437 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	bool lastRun;
															#line 11517 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via checkConsistency()
															#line 1396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class CheckConsistencyActor final : public Actor<Void>, public ActorCallback< CheckConsistencyActor, 0, DistributedTestResults >, public ActorCallback< CheckConsistencyActor, 1, Void >, public FastAllocated<CheckConsistencyActor>, public CheckConsistencyActorState<CheckConsistencyActor> {
															#line 11522 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<CheckConsistencyActor>::operator new;
	using FastAllocated<CheckConsistencyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6711241315703744768UL, 10900983566501605888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckConsistencyActor, 0, DistributedTestResults >;
friend struct ActorCallback< CheckConsistencyActor, 1, Void >;
															#line 1396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	CheckConsistencyActor(Database const& cx,std::vector<TesterInterface> const& testers,bool const& doQuiescentCheck,bool const& doTSSCheck,double const& maxDDRunTime,double const& softTimeLimit,double const& databasePingDelay,Reference<AsyncVar<ServerDBInfo>> const& dbInfo) 
															#line 11540 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<Void>(),
		   CheckConsistencyActorState<CheckConsistencyActor>(cx, testers, doQuiescentCheck, doTSSCheck, maxDDRunTime, softTimeLimit, databasePingDelay, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkConsistency", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5013688168915807232UL, 8279475379598191872UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkConsistency");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkConsistency", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckConsistencyActor, 0, DistributedTestResults >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckConsistencyActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> checkConsistency( Database const& cx, std::vector<TesterInterface> const& testers, bool const& doQuiescentCheck, bool const& doTSSCheck, double const& maxDDRunTime, double const& softTimeLimit, double const& databasePingDelay, Reference<AsyncVar<ServerDBInfo>> const& dbInfo ) {
															#line 1396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new CheckConsistencyActor(cx, testers, doQuiescentCheck, doTSSCheck, maxDDRunTime, softTimeLimit, databasePingDelay, dbInfo));
															#line 11574 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 1455 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 11579 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via runUrgentConsistencyCheckWorkload()
															#line 1456 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class RunUrgentConsistencyCheckWorkloadActor>
															#line 1456 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunUrgentConsistencyCheckWorkloadActorState {
															#line 11586 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 1456 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunUrgentConsistencyCheckWorkloadActorState(Database const& cx,std::vector<TesterInterface> const& testers,int64_t const& consistencyCheckerId,std::unordered_map<int, std::vector<KeyRange>> const& assignment) 
															#line 1456 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 1456 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cx(cx),
															#line 1456 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   testers(testers),
															#line 1456 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   consistencyCheckerId(consistencyCheckerId),
															#line 1456 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   assignment(assignment)
															#line 11599 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this));

	}
	~RunUrgentConsistencyCheckWorkloadActorState() 
	{
		fdb_probe_actor_destroy("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1461 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevInfo, "ConsistencyCheckUrgent_DispatchWorkloads") .detail("TesterCount", testers.size()) .detail("ConsistencyCheckerId", consistencyCheckerId);
															#line 1466 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			workRequests = std::vector<Future<ErrorOr<WorkloadInterface>>>();
															#line 1467 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			Standalone<VectorRef<KeyValueRef>> option;
															#line 1468 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			option.push_back_deep(option.arena(), KeyValueRef("testName"_sr, "ConsistencyCheckUrgent"_sr));
															#line 1469 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			Standalone<VectorRef<VectorRef<KeyValueRef>>> options;
															#line 1470 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			options.push_back_deep(options.arena(), option);
															#line 1471 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for(int i = 0;i < testers.size();i++) {
															#line 1472 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				WorkloadRequest req;
															#line 1473 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.title = "ConsistencyCheckUrgent"_sr;
															#line 1474 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.useDatabase = true;
															#line 1475 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.timeout = 0.0;
															#line 1476 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.databasePingDelay = 0.0;
															#line 1477 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.options = options;
															#line 1478 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.clientId = i;
															#line 1479 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.clientCount = testers.size();
															#line 1480 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.sharedRandomNumber = consistencyCheckerId;
															#line 1481 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.rangesToCheck = assignment[i];
															#line 1482 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				workRequests.push_back(testers[i].recruitments.getReplyUnlessFailedFor(req, 10, 0));
															#line 11648 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 1485 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(workRequests);
															#line 1485 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11654 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->actor_wait_state = 1;
															#line 1485 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 0, Void >*>(static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)));
															#line 11659 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunUrgentConsistencyCheckWorkloadActorState();
		static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1488 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_TriggerWorkloads") .detail("TesterCount", testers.size()) .detail("ConsistencyCheckerId", consistencyCheckerId);
															#line 1491 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		completeClientIds = std::unordered_set<int>();
															#line 1492 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		clientIds = std::vector<int>();
															#line 1493 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		jobs = std::vector<Future<ErrorOr<Void>>>();
															#line 1494 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < workRequests.size();i++) {
															#line 1495 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			ASSERT(workRequests[i].isReady());
															#line 1496 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (workRequests[i].get().isError())
															#line 11694 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 1497 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent(SevInfo, "ConsistencyCheckUrgent_FailedToContactTester") .error(workRequests[i].get().getError()) .detail("TesterCount", testers.size()) .detail("TesterId", i) .detail("ConsistencyCheckerId", consistencyCheckerId);
															#line 11698 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
			else
			{
															#line 1503 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				jobs.push_back(workRequests[i].get().get().start.template getReplyUnlessFailedFor<Void>(10, 0));
															#line 1504 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				clientIds.push_back(i);
															#line 11706 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
		}
															#line 1507 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(jobs);
															#line 1507 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11713 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->actor_wait_state = 2;
															#line 1507 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 1, Void >*>(static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)));
															#line 11718 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1488 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_TriggerWorkloads") .detail("TesterCount", testers.size()) .detail("ConsistencyCheckerId", consistencyCheckerId);
															#line 1491 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		completeClientIds = std::unordered_set<int>();
															#line 1492 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		clientIds = std::vector<int>();
															#line 1493 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		jobs = std::vector<Future<ErrorOr<Void>>>();
															#line 1494 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < workRequests.size();i++) {
															#line 1495 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			ASSERT(workRequests[i].isReady());
															#line 1496 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (workRequests[i].get().isError())
															#line 11739 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 1497 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent(SevInfo, "ConsistencyCheckUrgent_FailedToContactTester") .error(workRequests[i].get().getError()) .detail("TesterCount", testers.size()) .detail("TesterId", i) .detail("ConsistencyCheckerId", consistencyCheckerId);
															#line 11743 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
			else
			{
															#line 1503 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				jobs.push_back(workRequests[i].get().get().start.template getReplyUnlessFailedFor<Void>(10, 0));
															#line 1504 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				clientIds.push_back(i);
															#line 11751 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
		}
															#line 1507 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(jobs);
															#line 1507 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11758 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->actor_wait_state = 2;
															#line 1507 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 1, Void >*>(static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)));
															#line 11763 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->actor_wait_state > 0) static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1508 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < jobs.size();i++) {
															#line 1509 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (jobs[i].isError())
															#line 11849 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 1510 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent(SevInfo, "ConsistencyCheckUrgent_RunWorkloadError1") .errorUnsuppressed(jobs[i].getError()) .detail("ClientId", clientIds[i]) .detail("ClientCount", testers.size()) .detail("ConsistencyCheckerId", consistencyCheckerId);
															#line 11853 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
			else
			{
															#line 1515 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (jobs[i].get().isError())
															#line 11859 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				{
															#line 1516 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					TraceEvent(SevInfo, "ConsistencyCheckUrgent_RunWorkloadError2") .errorUnsuppressed(jobs[i].get().getError()) .detail("ClientId", clientIds[i]) .detail("ClientCount", testers.size()) .detail("ConsistencyCheckerId", consistencyCheckerId);
															#line 11863 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				}
				else
				{
															#line 1522 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					TraceEvent(SevInfo, "ConsistencyCheckUrgent_RunWorkloadComplete") .detail("ClientId", clientIds[i]) .detail("ClientCount", testers.size()) .detail("ConsistencyCheckerId", consistencyCheckerId);
															#line 1526 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					completeClientIds.insert(clientIds[i]);
															#line 11871 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				}
			}
		}
															#line 1530 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_DispatchWorkloadEnd") .detail("TesterCount", testers.size()) .detail("ConsistencyCheckerId", consistencyCheckerId);
															#line 1534 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->SAV<std::unordered_set<int>>::futures) { (void)(completeClientIds); this->~RunUrgentConsistencyCheckWorkloadActorState(); static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->destroy(); return 0; }
															#line 11879 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->SAV< std::unordered_set<int> >::value()) std::unordered_set<int>(std::move(completeClientIds)); // state_var_RVO
		this->~RunUrgentConsistencyCheckWorkloadActorState();
		static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1508 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < jobs.size();i++) {
															#line 1509 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (jobs[i].isError())
															#line 11893 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 1510 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent(SevInfo, "ConsistencyCheckUrgent_RunWorkloadError1") .errorUnsuppressed(jobs[i].getError()) .detail("ClientId", clientIds[i]) .detail("ClientCount", testers.size()) .detail("ConsistencyCheckerId", consistencyCheckerId);
															#line 11897 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
			else
			{
															#line 1515 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (jobs[i].get().isError())
															#line 11903 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				{
															#line 1516 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					TraceEvent(SevInfo, "ConsistencyCheckUrgent_RunWorkloadError2") .errorUnsuppressed(jobs[i].get().getError()) .detail("ClientId", clientIds[i]) .detail("ClientCount", testers.size()) .detail("ConsistencyCheckerId", consistencyCheckerId);
															#line 11907 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				}
				else
				{
															#line 1522 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					TraceEvent(SevInfo, "ConsistencyCheckUrgent_RunWorkloadComplete") .detail("ClientId", clientIds[i]) .detail("ClientCount", testers.size()) .detail("ConsistencyCheckerId", consistencyCheckerId);
															#line 1526 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					completeClientIds.insert(clientIds[i]);
															#line 11915 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				}
			}
		}
															#line 1530 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_DispatchWorkloadEnd") .detail("TesterCount", testers.size()) .detail("ConsistencyCheckerId", consistencyCheckerId);
															#line 1534 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->SAV<std::unordered_set<int>>::futures) { (void)(completeClientIds); this->~RunUrgentConsistencyCheckWorkloadActorState(); static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->destroy(); return 0; }
															#line 11923 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->SAV< std::unordered_set<int> >::value()) std::unordered_set<int>(std::move(completeClientIds)); // state_var_RVO
		this->~RunUrgentConsistencyCheckWorkloadActorState();
		static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->actor_wait_state > 0) static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1456 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 1456 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<TesterInterface> testers;
															#line 1456 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	int64_t consistencyCheckerId;
															#line 1456 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::unordered_map<int, std::vector<KeyRange>> assignment;
															#line 1466 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<Future<ErrorOr<WorkloadInterface>>> workRequests;
															#line 1491 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::unordered_set<int> completeClientIds;
															#line 1492 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<int> clientIds;
															#line 1493 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<Future<ErrorOr<Void>>> jobs;
															#line 12022 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via runUrgentConsistencyCheckWorkload()
															#line 1456 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunUrgentConsistencyCheckWorkloadActor final : public Actor<std::unordered_set<int>>, public ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 0, Void >, public ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 1, Void >, public FastAllocated<RunUrgentConsistencyCheckWorkloadActor>, public RunUrgentConsistencyCheckWorkloadActorState<RunUrgentConsistencyCheckWorkloadActor> {
															#line 12027 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<RunUrgentConsistencyCheckWorkloadActor>::operator new;
	using FastAllocated<RunUrgentConsistencyCheckWorkloadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7339625868633403136UL, 6977202256821683712UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::unordered_set<int>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 0, Void >;
friend struct ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 1, Void >;
															#line 1456 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunUrgentConsistencyCheckWorkloadActor(Database const& cx,std::vector<TesterInterface> const& testers,int64_t const& consistencyCheckerId,std::unordered_map<int, std::vector<KeyRange>> const& assignment) 
															#line 12045 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<std::unordered_set<int>>(),
		   RunUrgentConsistencyCheckWorkloadActorState<RunUrgentConsistencyCheckWorkloadActor>(cx, testers, consistencyCheckerId, assignment),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10978757743012301568UL, 6078238994598819584UL);
		ActorExecutionContextHelper __helper(static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runUrgentConsistencyCheckWorkload");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1456 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<std::unordered_set<int>> runUrgentConsistencyCheckWorkload( Database const& cx, std::vector<TesterInterface> const& testers, int64_t const& consistencyCheckerId, std::unordered_map<int, std::vector<KeyRange>> const& assignment ) {
															#line 1456 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<std::unordered_set<int>>(new RunUrgentConsistencyCheckWorkloadActor(cx, testers, consistencyCheckerId, assignment));
															#line 12079 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 1536 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 12084 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via getConsistencyCheckShards()
															#line 1537 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class GetConsistencyCheckShardsActor>
															#line 1537 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class GetConsistencyCheckShardsActorState {
															#line 12091 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 1537 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	GetConsistencyCheckShardsActorState(Database const& cx,std::vector<KeyRange> const& ranges) 
															#line 1537 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 1537 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cx(cx),
															#line 1537 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   ranges(ranges),
															#line 1539 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   beginKeyToReadKeyServer(),
															#line 1540 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   endKeyToReadKeyServer()
															#line 12104 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this));

	}
	~GetConsistencyCheckShardsActorState() 
	{
		fdb_probe_actor_destroy("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1541 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for(int i = 0;i < ranges.size();i++) {
															#line 1542 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (i == 0 || ranges[i].begin < beginKeyToReadKeyServer)
															#line 12121 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				{
															#line 1543 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					beginKeyToReadKeyServer = ranges[i].begin;
															#line 12125 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				}
															#line 1545 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (i == 0 || ranges[i].end > endKeyToReadKeyServer)
															#line 12129 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				{
															#line 1546 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					endKeyToReadKeyServer = ranges[i].end;
															#line 12133 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				}
			}
															#line 1549 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevInfo, "ConsistencyCheckUrgent_GetConsistencyCheckShards") .detail("RangeBegin", beginKeyToReadKeyServer) .detail("RangeEnd", endKeyToReadKeyServer);
															#line 1553 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			res = std::vector<KeyRange>();
															#line 1554 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			tr = Transaction(cx);
															#line 1555 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 12144 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetConsistencyCheckShardsActorState();
		static_cast<GetConsistencyCheckShardsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1589 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<GetConsistencyCheckShardsActor*>(this)->SAV<std::vector<KeyRange>>::futures) { (void)(res); this->~GetConsistencyCheckShardsActorState(); static_cast<GetConsistencyCheckShardsActor*>(this)->destroy(); return 0; }
															#line 12167 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<GetConsistencyCheckShardsActor*>(this)->SAV< std::vector<KeyRange> >::value()) std::vector<KeyRange>(std::move(res)); // state_var_RVO
		this->~GetConsistencyCheckShardsActorState();
		static_cast<GetConsistencyCheckShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1557 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1558 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1559 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1560 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			KeyRange rangeToRead = Standalone(KeyRangeRef(beginKeyToReadKeyServer, endKeyToReadKeyServer));
															#line 1561 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = krmGetRanges(&tr, keyServersPrefix, rangeToRead, SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT, SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT_BYTES);
															#line 1561 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<GetConsistencyCheckShardsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12197 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetConsistencyCheckShardsActor*>(this)->actor_wait_state = 1;
															#line 1561 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetConsistencyCheckShardsActor, 0, RangeResult >*>(static_cast<GetConsistencyCheckShardsActor*>(this)));
															#line 12202 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1585 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevInfo, "ConsistencyCheckUrgent_GetConsistencyCheckShardsRetry").error(e);
															#line 1586 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 1586 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<GetConsistencyCheckShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12241 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetConsistencyCheckShardsActor*>(this)->actor_wait_state = 2;
															#line 1586 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetConsistencyCheckShardsActor, 1, Void >*>(static_cast<GetConsistencyCheckShardsActor*>(this)));
															#line 12246 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& readResult,int loopDepth) 
	{
															#line 1566 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < readResult.size() - 1;++i) {
															#line 1567 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			KeyRange rangeToCheck = Standalone(KeyRangeRef(readResult[i].key, readResult[i + 1].key));
															#line 1568 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			Value valueToCheck = Standalone(readResult[i].value);
															#line 1569 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			bool toAdd = false;
															#line 1570 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for( const auto& range : ranges ) {
															#line 1571 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (rangeToCheck.intersects(range) == true)
															#line 12271 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				{
															#line 1572 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					toAdd = true;
															#line 12275 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
					break;
				}
			}
															#line 1576 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (toAdd == true)
															#line 12281 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 1577 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				res.push_back(rangeToCheck);
															#line 12285 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 1579 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			beginKeyToReadKeyServer = readResult[i + 1].key;
															#line 12289 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 1581 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (beginKeyToReadKeyServer >= endKeyToReadKeyServer)
															#line 12293 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && readResult,int loopDepth) 
	{
															#line 1566 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < readResult.size() - 1;++i) {
															#line 1567 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			KeyRange rangeToCheck = Standalone(KeyRangeRef(readResult[i].key, readResult[i + 1].key));
															#line 1568 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			Value valueToCheck = Standalone(readResult[i].value);
															#line 1569 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			bool toAdd = false;
															#line 1570 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for( const auto& range : ranges ) {
															#line 1571 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (rangeToCheck.intersects(range) == true)
															#line 12315 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				{
															#line 1572 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					toAdd = true;
															#line 12319 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
					break;
				}
			}
															#line 1576 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (toAdd == true)
															#line 12325 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 1577 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				res.push_back(rangeToCheck);
															#line 12329 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 1579 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			beginKeyToReadKeyServer = readResult[i + 1].key;
															#line 12333 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 1581 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (beginKeyToReadKeyServer >= endKeyToReadKeyServer)
															#line 12337 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& readResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(readResult, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && readResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(readResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetConsistencyCheckShardsActor*>(this)->actor_wait_state > 0) static_cast<GetConsistencyCheckShardsActor*>(this)->actor_wait_state = 0;
		static_cast<GetConsistencyCheckShardsActor*>(this)->ActorCallback< GetConsistencyCheckShardsActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetConsistencyCheckShardsActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetConsistencyCheckShardsActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetConsistencyCheckShardsActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetConsistencyCheckShardsActor*>(this)->actor_wait_state > 0) static_cast<GetConsistencyCheckShardsActor*>(this)->actor_wait_state = 0;
		static_cast<GetConsistencyCheckShardsActor*>(this)->ActorCallback< GetConsistencyCheckShardsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetConsistencyCheckShardsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetConsistencyCheckShardsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetConsistencyCheckShardsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1537 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 1537 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<KeyRange> ranges;
															#line 1539 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Key beginKeyToReadKeyServer;
															#line 1540 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Key endKeyToReadKeyServer;
															#line 1553 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<KeyRange> res;
															#line 1554 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Transaction tr;
															#line 12532 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via getConsistencyCheckShards()
															#line 1537 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class GetConsistencyCheckShardsActor final : public Actor<std::vector<KeyRange>>, public ActorCallback< GetConsistencyCheckShardsActor, 0, RangeResult >, public ActorCallback< GetConsistencyCheckShardsActor, 1, Void >, public FastAllocated<GetConsistencyCheckShardsActor>, public GetConsistencyCheckShardsActorState<GetConsistencyCheckShardsActor> {
															#line 12537 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<GetConsistencyCheckShardsActor>::operator new;
	using FastAllocated<GetConsistencyCheckShardsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15525574069870694144UL, 13785841552288384768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<KeyRange>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetConsistencyCheckShardsActor, 0, RangeResult >;
friend struct ActorCallback< GetConsistencyCheckShardsActor, 1, Void >;
															#line 1537 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	GetConsistencyCheckShardsActor(Database const& cx,std::vector<KeyRange> const& ranges) 
															#line 12555 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<std::vector<KeyRange>>(),
		   GetConsistencyCheckShardsActorState<GetConsistencyCheckShardsActor>(cx, ranges),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16459118065812089344UL, 9734862755223687168UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getConsistencyCheckShards");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetConsistencyCheckShardsActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetConsistencyCheckShardsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1537 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<std::vector<KeyRange>> getConsistencyCheckShards( Database const& cx, std::vector<KeyRange> const& ranges ) {
															#line 1537 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<std::vector<KeyRange>>(new GetConsistencyCheckShardsActor(cx, ranges));
															#line 12589 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 1591 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 12594 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via getTesters()
															#line 1592 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class GetTestersActor>
															#line 1592 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class GetTestersActorState {
															#line 12601 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 1592 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	GetTestersActorState(Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> const& cc,int const& minTestersExpected) 
															#line 1592 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 1592 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cc(cc),
															#line 1592 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   minTestersExpected(minTestersExpected),
															#line 1595 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   flags(GetWorkersRequest::TESTER_CLASS_ONLY | GetWorkersRequest::NON_EXCLUDED_PROCESSES_ONLY),
															#line 1596 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   testerTimeout(delay(600.0)),
															#line 1597 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   workers()
															#line 12616 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("getTesters", reinterpret_cast<unsigned long>(this));

	}
	~GetTestersActorState() 
	{
		fdb_probe_actor_destroy("getTesters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1598 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 12631 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTestersActorState();
		static_cast<GetTestersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1617 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ts = std::vector<TesterInterface>();
															#line 1618 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ts.reserve(workers.size());
															#line 1619 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < workers.size();i++) {
															#line 1620 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			ts.push_back(workers[i].interf.testerInterface);
															#line 12660 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 1621 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		deterministicRandom()->randomShuffle(ts);
															#line 1622 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<GetTestersActor*>(this)->SAV<std::vector<TesterInterface>>::futures) { (void)(ts); this->~GetTestersActorState(); static_cast<GetTestersActor*>(this)->destroy(); return 0; }
															#line 12666 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<GetTestersActor*>(this)->SAV< std::vector<TesterInterface> >::value()) std::vector<TesterInterface>(std::move(ts)); // state_var_RVO
		this->~GetTestersActorState();
		static_cast<GetTestersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1600 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = cc->get().present() ? brokenPromiseToNever(cc->get().get().getWorkers.getReply(GetWorkersRequest(flags))) : Never();
															#line 1599 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<GetTestersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12687 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 1610 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cc->onChange();
															#line 12691 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
															#line 1611 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_2 = testerTimeout;
															#line 12695 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
		static_cast<GetTestersActor*>(this)->actor_wait_state = 1;
															#line 1600 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTestersActor, 0, std::vector<WorkerDetails> >*>(static_cast<GetTestersActor*>(this)));
															#line 1610 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetTestersActor, 1, Void >*>(static_cast<GetTestersActor*>(this)));
															#line 1611 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetTestersActor, 2, Void >*>(static_cast<GetTestersActor*>(this)));
															#line 12704 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<WorkerDetails> const& w,int loopDepth) 
	{
															#line 1604 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (w.size() >= minTestersExpected)
															#line 12732 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 1605 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			workers = w;
															#line 12736 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1608 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->WORKER_POLL_DELAY);
															#line 1608 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<GetTestersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12743 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetTestersActor*>(this)->actor_wait_state = 2;
															#line 1608 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetTestersActor, 3, Void >*>(static_cast<GetTestersActor*>(this)));
															#line 12748 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<WorkerDetails> && w,int loopDepth) 
	{
															#line 1604 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (w.size() >= minTestersExpected)
															#line 12757 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 1605 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			workers = w;
															#line 12761 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1608 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->WORKER_POLL_DELAY);
															#line 1608 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<GetTestersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12768 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetTestersActor*>(this)->actor_wait_state = 2;
															#line 1608 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetTestersActor, 3, Void >*>(static_cast<GetTestersActor*>(this)));
															#line 12773 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 1612 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevWarnAlways, "TesterRecruitmentTimeout");
															#line 1613 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		return a_body1Catch1(timed_out(), std::max(0, loopDepth - 1));
															#line 12796 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
															#line 1612 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevWarnAlways, "TesterRecruitmentTimeout");
															#line 1613 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		return a_body1Catch1(timed_out(), std::max(0, loopDepth - 1));
															#line 12806 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTestersActor*>(this)->actor_wait_state > 0) static_cast<GetTestersActor*>(this)->actor_wait_state = 0;
		static_cast<GetTestersActor*>(this)->ActorCallback< GetTestersActor, 0, std::vector<WorkerDetails> >::remove();
		static_cast<GetTestersActor*>(this)->ActorCallback< GetTestersActor, 1, Void >::remove();
		static_cast<GetTestersActor*>(this)->ActorCallback< GetTestersActor, 2, Void >::remove();

	}
	int a_body1loopBody1when1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetTestersActor*>(this)->actor_wait_state > 0) static_cast<GetTestersActor*>(this)->actor_wait_state = 0;
		static_cast<GetTestersActor*>(this)->ActorCallback< GetTestersActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetTestersActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetTestersActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetTestersActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetTestersActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTestersActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTestersActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTestersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetTestersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetTestersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetTestersActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetTestersActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetTestersActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1592 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> cc;
															#line 1592 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	int minTestersExpected;
															#line 1595 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	int flags;
															#line 1596 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Future<Void> testerTimeout;
															#line 1597 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 1617 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<TesterInterface> ts;
															#line 13088 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via getTesters()
															#line 1592 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class GetTestersActor final : public Actor<std::vector<TesterInterface>>, public ActorCallback< GetTestersActor, 0, std::vector<WorkerDetails> >, public ActorCallback< GetTestersActor, 3, Void >, public ActorCallback< GetTestersActor, 1, Void >, public ActorCallback< GetTestersActor, 2, Void >, public FastAllocated<GetTestersActor>, public GetTestersActorState<GetTestersActor> {
															#line 13093 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<GetTestersActor>::operator new;
	using FastAllocated<GetTestersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2248470818391245312UL, 475720856336917248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<TesterInterface>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTestersActor, 0, std::vector<WorkerDetails> >;
friend struct ActorCallback< GetTestersActor, 3, Void >;
friend struct ActorCallback< GetTestersActor, 1, Void >;
friend struct ActorCallback< GetTestersActor, 2, Void >;
															#line 1592 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	GetTestersActor(Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> const& cc,int const& minTestersExpected) 
															#line 13113 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<std::vector<TesterInterface>>(),
		   GetTestersActorState<GetTestersActor>(cc, minTestersExpected),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12020919305826439936UL, 12275217311193987072UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTesters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTestersActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetTestersActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1592 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<std::vector<TesterInterface>> getTesters( Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> const& cc, int const& minTestersExpected ) {
															#line 1592 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<std::vector<TesterInterface>>(new GetTestersActor(cc, minTestersExpected));
															#line 13147 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 1624 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

const std::unordered_map<char, uint8_t> parseCharMap{
	{ '0', 0 },  { '1', 1 },  { '2', 2 },  { '3', 3 },  { '4', 4 },  { '5', 5 },  { '6', 6 },  { '7', 7 },
	{ '8', 8 },  { '9', 9 },  { 'a', 10 }, { 'b', 11 }, { 'c', 12 }, { 'd', 13 }, { 'e', 14 }, { 'f', 15 },
	{ 'A', 10 }, { 'B', 11 }, { 'C', 12 }, { 'D', 13 }, { 'E', 14 }, { 'F', 15 },
};

Optional<Key> getKeyFromString(const std::string& str) {
	Key emptyKey;
	if (str.size() == 0) {
		return emptyKey;
	}
	if (str.size() % 4 != 0) {
		TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways, "ConsistencyCheckUrgent_GetKeyFromStringError")
		    .setMaxEventLength(-1)
		    .setMaxFieldLength(-1)
		    .detail("Reason", "WrongLength")
		    .detail("InputStr", str);
		return Optional<Key>();
	}
	std::vector<uint8_t> byteList;
	for (int i = 0; i < str.size(); i += 4) {
		if (str.at(i + 0) != '\\' || str.at(i + 1) != 'x') {
			TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways,
			           "ConsistencyCheckUrgent_GetKeyFromStringError")
			    .setMaxEventLength(-1)
			    .setMaxFieldLength(-1)
			    .detail("Reason", "WrongBytePrefix")
			    .detail("InputStr", str);
			return Optional<Key>();
		}
		const char first = str.at(i + 2);
		const char second = str.at(i + 3);
		if (!parseCharMap.contains(first) || !parseCharMap.contains(second)) {
			TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways,
			           "ConsistencyCheckUrgent_GetKeyFromStringError")
			    .setMaxEventLength(-1)
			    .setMaxFieldLength(-1)
			    .detail("Reason", "WrongByteContent")
			    .detail("InputStr", str);
			return Optional<Key>();
		}
		uint8_t parsedValue = parseCharMap.at(first) * 16 + parseCharMap.at(second);
		byteList.push_back(parsedValue);
	}
	return Standalone(StringRef(byteList.data(), byteList.size()));
}

Optional<std::vector<KeyRange>> loadRangesToCheckFromKnob() {
	// Load string from knob
	std::vector<std::string> beginKeyStrs = {
		CLIENT_KNOBS->CONSISTENCY_CHECK_URGENT_RANGE_BEGIN_0,
		CLIENT_KNOBS->CONSISTENCY_CHECK_URGENT_RANGE_BEGIN_1,
		CLIENT_KNOBS->CONSISTENCY_CHECK_URGENT_RANGE_BEGIN_2,
		CLIENT_KNOBS->CONSISTENCY_CHECK_URGENT_RANGE_BEGIN_3,
	};
	std::vector<std::string> endKeyStrs = {
		CLIENT_KNOBS->CONSISTENCY_CHECK_URGENT_RANGE_END_0,
		CLIENT_KNOBS->CONSISTENCY_CHECK_URGENT_RANGE_END_1,
		CLIENT_KNOBS->CONSISTENCY_CHECK_URGENT_RANGE_END_2,
		CLIENT_KNOBS->CONSISTENCY_CHECK_URGENT_RANGE_END_3,
	};

	// Get keys from strings
	std::vector<Key> beginKeys;
	for (const auto& beginKeyStr : beginKeyStrs) {
		Optional<Key> key = getKeyFromString(beginKeyStr);
		if (key.present()) {
			beginKeys.push_back(key.get());
		} else {
			return Optional<std::vector<KeyRange>>();
		}
	}
	std::vector<Key> endKeys;
	for (const auto& endKeyStr : endKeyStrs) {
		Optional<Key> key = getKeyFromString(endKeyStr);
		if (key.present()) {
			endKeys.push_back(key.get());
		} else {
			return Optional<std::vector<KeyRange>>();
		}
	}
	if (beginKeys.size() != endKeys.size()) {
		TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways, "ConsistencyCheckUrgent_GetKeyFromStringError")
		    .detail("Reason", "MismatchBeginKeysAndEndKeys");
		return Optional<std::vector<KeyRange>>();
	}

	// Get ranges
	KeyRangeMap<bool> rangeToCheckMap;
	for (int i = 0; i < beginKeys.size(); i++) {
		Key rangeBegin = beginKeys[i];
		Key rangeEnd = endKeys[i];
		if (rangeBegin.empty() && rangeEnd.empty()) {
			continue;
		}
		if (rangeBegin > allKeys.end) {
			rangeBegin = allKeys.end;
		}
		if (rangeEnd > allKeys.end) {
			TraceEvent(SevInfo, "ConsistencyCheckUrgent_ReverseInputRange")
			    .setMaxEventLength(-1)
			    .setMaxFieldLength(-1)
			    .detail("Index", i)
			    .detail("RangeBegin", rangeBegin)
			    .detail("RangeEnd", rangeEnd);
			rangeEnd = allKeys.end;
		}

		KeyRange rangeToCheck;
		if (rangeBegin < rangeEnd) {
			rangeToCheck = Standalone(KeyRangeRef(rangeBegin, rangeEnd));
		} else if (rangeBegin > rangeEnd) {
			rangeToCheck = Standalone(KeyRangeRef(rangeEnd, rangeBegin));
		} else {
			TraceEvent(SevInfo, "ConsistencyCheckUrgent_EmptyInputRange")
			    .setMaxEventLength(-1)
			    .setMaxFieldLength(-1)
			    .detail("Index", i)
			    .detail("RangeBegin", rangeBegin)
			    .detail("RangeEnd", rangeEnd);
			continue;
		}
		rangeToCheckMap.insert(rangeToCheck, true);
	}

	rangeToCheckMap.coalesce(allKeys);

	std::vector<KeyRange> res;
	for (auto rangeToCheck : rangeToCheckMap.ranges()) {
		if (rangeToCheck.value() == true) {
			res.push_back(rangeToCheck.range());
		}
	}
	TraceEvent e(SevInfo, "ConsistencyCheckUrgent_LoadedInputRange");
	e.setMaxEventLength(-1);
	e.setMaxFieldLength(-1);
	for (int i = 0; i < res.size(); i++) {
		e.detail("RangeBegin" + std::to_string(i), res[i].begin);
		e.detail("RangeEnd" + std::to_string(i), res[i].end);
	}
	return res;
}

std::unordered_map<int, std::vector<KeyRange>> makeTaskAssignment(Database cx,
                                                                  int64_t consistencyCheckerId,
                                                                  std::vector<KeyRange> shardsToCheck,
                                                                  int testersCount,
                                                                  int round) {
	ASSERT(testersCount >= 1);
	std::unordered_map<int, std::vector<KeyRange>> assignment;

	std::vector<size_t> shuffledIndices(testersCount);
	std::iota(shuffledIndices.begin(), shuffledIndices.end(), 0); // creates [0, 1, ..., testersCount - 1]
	deterministicRandom()->randomShuffle(shuffledIndices);

	int batchSize = CLIENT_KNOBS->CONSISTENCY_CHECK_URGENT_BATCH_SHARD_COUNT;
	int startingPoint = 0;
	if (shardsToCheck.size() > batchSize * testersCount) {
		startingPoint = deterministicRandom()->randomInt(0, shardsToCheck.size() - batchSize * testersCount);
		// We randomly pick a set of successive shards:
		// (1) We want to retry for different shards to avoid repeated failure on the same shards
		// (2) We want to check successive shards to avoid inefficiency incurred by fragments
	}
	assignment.clear();
	for (int i = startingPoint; i < shardsToCheck.size(); i++) {
		int testerIdx = (i - startingPoint) / batchSize;
		if (testerIdx > testersCount - 1) {
			break; // Have filled up all testers
		}
		// When assigning a shards/batch to a tester idx, there are certain edge cases which can result in urgent
		// consistency checker being infinetely stuck in a loop. Examples:
		//      1. if there is 1 remaining shard, and tester 0 consistently fails, we will still always pick tester 0
		//      2. if there are 10 remaining shards, and batch size is 10, and tester 0 consistently fails, we will
		//      still always pick tester 0
		//      3. if there are 20 remaining shards, and batch size is 10, and testers {0, 1} consistently fail, we will
		//      keep picking testers {0, 1}
		// To avoid repeatedly picking the same testers even though they could be failing, shuffledIndices provides an
		// indirection to a random tester idx. That way, each invocation of makeTaskAssignment won't
		// result in the same task assignment for the class of edge cases mentioned above.
		assignment[shuffledIndices[testerIdx]].push_back(shardsToCheck[i]);
	}
	std::unordered_map<int, std::vector<KeyRange>>::iterator assignIt;
	for (assignIt = assignment.begin(); assignIt != assignment.end(); assignIt++) {
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_AssignTaskToTesters")
		    .detail("ConsistencyCheckerId", consistencyCheckerId)
		    .detail("Round", round)
		    .detail("ClientId", assignIt->first)
		    .detail("ShardsCount", assignIt->second.size());
	}
	return assignment;
}

															#line 13344 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via runConsistencyCheckerUrgentCore()
															#line 1817 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class RunConsistencyCheckerUrgentCoreActor>
															#line 1817 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunConsistencyCheckerUrgentCoreActorState {
															#line 13351 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 1817 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunConsistencyCheckerUrgentCoreActorState(Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> const& cc,Database const& cx,Optional<std::vector<TesterInterface>> const& testers,int const& minTestersExpected) 
															#line 1817 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 1817 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cc(cc),
															#line 1817 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   cx(cx),
															#line 1817 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   testers(testers),
															#line 1817 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   minTestersExpected(minTestersExpected),
															#line 1821 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   globalProgressMap(),
															#line 1822 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   assignment(),
															#line 1823 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   ts(),
															#line 1824 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   rangesToCheck(),
															#line 1825 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   shardsToCheck(),
															#line 1826 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   whenFailedToGetTesterStart()
															#line 13376 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this));

	}
	~RunConsistencyCheckerUrgentCoreActorState() 
	{
		fdb_probe_actor_destroy("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1829 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			Optional<std::vector<KeyRange>> rangesToCheck_ = loadRangesToCheckFromKnob();
															#line 1830 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (rangesToCheck_.present())
															#line 13393 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 1831 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				globalProgressMap.insert(allKeys, true);
															#line 1832 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				for( const auto& rangeToCheck : rangesToCheck_.get() ) {
															#line 1835 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					globalProgressMap.insert(rangeToCheck, false);
															#line 13401 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				}
															#line 1837 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				globalProgressMap.coalesce(allKeys);
															#line 13405 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
			else
			{
															#line 1839 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent(SevInfo, "ConsistencyCheckUrgent_FailedToLoadRangeFromKnob");
															#line 1840 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				globalProgressMap.insert(allKeys, false);
															#line 13413 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 1843 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			consistencyCheckerId = deterministicRandom()->randomInt64(1, 10000000);
															#line 1844 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			retryTimes = 0;
															#line 1845 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			round = 0;
															#line 1848 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 13423 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunConsistencyCheckerUrgentCoreActorState();
		static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1851 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevInfo, "ConsistencyCheckUrgent_RoundBegin") .detail("ConsistencyCheckerId", consistencyCheckerId) .detail("RetryTimes", retryTimes) .detail("TesterCount", ts.size()) .detail("Round", round);
															#line 1856 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			rangesToCheck.clear();
															#line 1857 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for( auto& range : globalProgressMap.ranges() ) {
															#line 1858 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (!range.value())
															#line 13460 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				{
															#line 1859 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					rangesToCheck.push_back(range.range());
															#line 13464 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				}
			}
															#line 1862 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (rangesToCheck.size() == 0)
															#line 13469 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 1863 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent(SevInfo, "ConsistencyCheckUrgent_Complete") .detail("ConsistencyCheckerId", consistencyCheckerId) .detail("RetryTimes", retryTimes) .detail("Round", round);
															#line 1867 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (!static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunConsistencyCheckerUrgentCoreActorState(); static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->destroy(); return 0; }
															#line 13475 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				new (&static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~RunConsistencyCheckerUrgentCoreActorState();
				static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1871 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			ts.clear();
															#line 1872 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (!testers.present())
															#line 13485 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
				try {
															#line 1874 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					StrictFuture<Void> __when_expr_0 = store(ts, getTesters(cc, minTestersExpected));
															#line 1874 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					if (static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch2(actor_cancelled(), loopDepth);
															#line 13492 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
					static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state = 1;
															#line 1874 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunConsistencyCheckerUrgentCoreActor, 0, Void >*>(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)));
															#line 13497 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1loopBody1Catch2(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1loopBody1Catch2(unknown_error(), loopDepth);
				}
			}
			else
			{
															#line 1890 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				ts = testers.get();
															#line 13510 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1948 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(10.0);
															#line 1948 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13528 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state = 5;
															#line 1948 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RunConsistencyCheckerUrgentCoreActor, 4, Void >*>(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)));
															#line 13533 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1935 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 13543 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 1936 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 13547 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
			else
			{
															#line 1938 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent(SevInfo, "ConsistencyCheckUrgent_CoreWithRetriableFailure") .errorUnsuppressed(e) .detail("ConsistencyCheckerId", consistencyCheckerId) .detail("RetryTimes", retryTimes) .detail("Round", round);
															#line 1943 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_3 = delay(10.0);
															#line 1943 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13557 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
				static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state = 4;
															#line 1943 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunConsistencyCheckerUrgentCoreActor, 3, Void >*>(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)));
															#line 13562 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1892 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_GotTesters") .detail("ConsistencyCheckerId", consistencyCheckerId) .detail("Round", round) .detail("RetryTimes", retryTimes) .detail("TesterCount", ts.size());
															#line 1900 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		shardsToCheck.clear();
															#line 1901 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(shardsToCheck, getConsistencyCheckShards(cx, rangesToCheck));
															#line 1901 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13584 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state = 2;
															#line 1901 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunConsistencyCheckerUrgentCoreActor, 1, Void >*>(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)));
															#line 13589 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
															#line 1886 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (g_network->isSimulated() && deterministicRandom()->random01() < 0.05)
															#line 13598 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 1887 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			return a_body1loopBody1Catch1(operation_failed(), loopDepth);
															#line 13602 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1877 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 13613 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 1878 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (!whenFailedToGetTesterStart.present())
															#line 13617 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				{
															#line 1879 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					whenFailedToGetTesterStart = now();
															#line 13621 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				}
				else
				{
															#line 1880 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					if (now() - whenFailedToGetTesterStart.get() > 3600 * 24)
															#line 13627 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
					{
															#line 1881 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
						TraceEvent(SevError, "TesterRecruitmentTimeout");
															#line 13631 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
					}
				}
			}
															#line 1884 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			return a_body1loopBody1Catch1(e, loopDepth);
															#line 13637 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 1875 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		whenFailedToGetTesterStart.reset();
															#line 13651 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 1875 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		whenFailedToGetTesterStart.reset();
															#line 13660 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state > 0) static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state = 0;
		static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->ActorCallback< RunConsistencyCheckerUrgentCoreActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont13(Void const& _,int loopDepth) 
	{
															#line 1902 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_GotShardsToCheck") .detail("ConsistencyCheckerId", consistencyCheckerId) .detail("Round", round) .detail("RetryTimes", retryTimes) .detail("TesterCount", ts.size()) .detail("ShardCount", shardsToCheck.size());
															#line 1910 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		assignment.clear();
															#line 1911 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		assignment = makeTaskAssignment(cx, consistencyCheckerId, shardsToCheck, ts.size(), round);
															#line 1914 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<std::unordered_set<int>> __when_expr_2 = runUrgentConsistencyCheckWorkload(cx, ts, consistencyCheckerId, assignment);
															#line 1914 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13765 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont13when1(__when_expr_2.get(), loopDepth); };
		static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state = 3;
															#line 1914 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunConsistencyCheckerUrgentCoreActor, 2, std::unordered_set<int> >*>(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)));
															#line 13770 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont13(Void && _,int loopDepth) 
	{
															#line 1902 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_GotShardsToCheck") .detail("ConsistencyCheckerId", consistencyCheckerId) .detail("Round", round) .detail("RetryTimes", retryTimes) .detail("TesterCount", ts.size()) .detail("ShardCount", shardsToCheck.size());
															#line 1910 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		assignment.clear();
															#line 1911 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		assignment = makeTaskAssignment(cx, consistencyCheckerId, shardsToCheck, ts.size(), round);
															#line 1914 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<std::unordered_set<int>> __when_expr_2 = runUrgentConsistencyCheckWorkload(cx, ts, consistencyCheckerId, assignment);
															#line 1914 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13787 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont13when1(__when_expr_2.get(), loopDepth); };
		static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state = 3;
															#line 1914 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunConsistencyCheckerUrgentCoreActor, 2, std::unordered_set<int> >*>(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)));
															#line 13792 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state > 0) static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state = 0;
		static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->ActorCallback< RunConsistencyCheckerUrgentCoreActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont13cont1(std::unordered_set<int> const& completeClients,int loopDepth) 
	{
															#line 1916 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (g_network->isSimulated() && deterministicRandom()->random01() < 0.05)
															#line 13876 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 1917 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			return a_body1loopBody1Catch1(operation_failed(), loopDepth);
															#line 13880 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 1920 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for( const auto& clientId : completeClients ) {
															#line 1921 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for( const auto& range : assignment[clientId] ) {
															#line 1922 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				globalProgressMap.insert(range, true);
															#line 13888 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
		}
															#line 1925 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_RoundEnd") .detail("ConsistencyCheckerId", consistencyCheckerId) .detail("RetryTimes", retryTimes) .detail("SucceedTesterCount", completeClients.size()) .detail("SucceedTesters", describe(completeClients)) .detail("TesterCount", ts.size()) .detail("Round", round);
															#line 1932 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		round++;
															#line 13895 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1loopBody1cont13cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13cont1(std::unordered_set<int> && completeClients,int loopDepth) 
	{
															#line 1916 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (g_network->isSimulated() && deterministicRandom()->random01() < 0.05)
															#line 13904 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 1917 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			return a_body1loopBody1Catch1(operation_failed(), loopDepth);
															#line 13908 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 1920 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for( const auto& clientId : completeClients ) {
															#line 1921 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for( const auto& range : assignment[clientId] ) {
															#line 1922 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				globalProgressMap.insert(range, true);
															#line 13916 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
		}
															#line 1925 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_RoundEnd") .detail("ConsistencyCheckerId", consistencyCheckerId) .detail("RetryTimes", retryTimes) .detail("SucceedTesterCount", completeClients.size()) .detail("SucceedTesters", describe(completeClients)) .detail("TesterCount", ts.size()) .detail("Round", round);
															#line 1932 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		round++;
															#line 13923 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1loopBody1cont13cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13when1(std::unordered_set<int> const& completeClients,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13cont1(completeClients, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13when1(std::unordered_set<int> && completeClients,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13cont1(std::move(completeClients), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state > 0) static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state = 0;
		static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->ActorCallback< RunConsistencyCheckerUrgentCoreActor, 2, std::unordered_set<int> >::remove();

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 2, std::unordered_set<int> >*,std::unordered_set<int> const& value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont13when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 2, std::unordered_set<int> >*,std::unordered_set<int> && value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont13when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 2, std::unordered_set<int> >*,Error err) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont13cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
															#line 1944 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		retryTimes++;
															#line 14026 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
															#line 1944 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		retryTimes++;
															#line 14035 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state > 0) static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state = 0;
		static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->ActorCallback< RunConsistencyCheckerUrgentCoreActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont14(Void const& _,int loopDepth) 
	{
															#line 1951 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		consistencyCheckerId = deterministicRandom()->randomInt64(1, 10000000);
															#line 14119 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void && _,int loopDepth) 
	{
															#line 1951 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		consistencyCheckerId = deterministicRandom()->randomInt64(1, 10000000);
															#line 14128 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state > 0) static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state = 0;
		static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->ActorCallback< RunConsistencyCheckerUrgentCoreActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1817 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> cc;
															#line 1817 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 1817 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Optional<std::vector<TesterInterface>> testers;
															#line 1817 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	int minTestersExpected;
															#line 1821 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	KeyRangeMap<bool> globalProgressMap;
															#line 1822 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::unordered_map<int, std::vector<KeyRange>> assignment;
															#line 1823 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<TesterInterface> ts;
															#line 1824 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<KeyRange> rangesToCheck;
															#line 1825 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<KeyRange> shardsToCheck;
															#line 1826 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Optional<double> whenFailedToGetTesterStart;
															#line 1843 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	int64_t consistencyCheckerId;
															#line 1844 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	int retryTimes;
															#line 1845 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	int round;
															#line 14234 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via runConsistencyCheckerUrgentCore()
															#line 1817 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunConsistencyCheckerUrgentCoreActor final : public Actor<Void>, public ActorCallback< RunConsistencyCheckerUrgentCoreActor, 0, Void >, public ActorCallback< RunConsistencyCheckerUrgentCoreActor, 1, Void >, public ActorCallback< RunConsistencyCheckerUrgentCoreActor, 2, std::unordered_set<int> >, public ActorCallback< RunConsistencyCheckerUrgentCoreActor, 3, Void >, public ActorCallback< RunConsistencyCheckerUrgentCoreActor, 4, Void >, public FastAllocated<RunConsistencyCheckerUrgentCoreActor>, public RunConsistencyCheckerUrgentCoreActorState<RunConsistencyCheckerUrgentCoreActor> {
															#line 14239 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<RunConsistencyCheckerUrgentCoreActor>::operator new;
	using FastAllocated<RunConsistencyCheckerUrgentCoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8088276385986562304UL, 11841607698545732608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunConsistencyCheckerUrgentCoreActor, 0, Void >;
friend struct ActorCallback< RunConsistencyCheckerUrgentCoreActor, 1, Void >;
friend struct ActorCallback< RunConsistencyCheckerUrgentCoreActor, 2, std::unordered_set<int> >;
friend struct ActorCallback< RunConsistencyCheckerUrgentCoreActor, 3, Void >;
friend struct ActorCallback< RunConsistencyCheckerUrgentCoreActor, 4, Void >;
															#line 1817 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunConsistencyCheckerUrgentCoreActor(Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> const& cc,Database const& cx,Optional<std::vector<TesterInterface>> const& testers,int const& minTestersExpected) 
															#line 14260 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<Void>(),
		   RunConsistencyCheckerUrgentCoreActorState<RunConsistencyCheckerUrgentCoreActor>(cc, cx, testers, minTestersExpected),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10940115967878822656UL, 1660588988548103680UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runConsistencyCheckerUrgentCore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunConsistencyCheckerUrgentCoreActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunConsistencyCheckerUrgentCoreActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunConsistencyCheckerUrgentCoreActor, 2, std::unordered_set<int> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunConsistencyCheckerUrgentCoreActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RunConsistencyCheckerUrgentCoreActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1817 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> runConsistencyCheckerUrgentCore( Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> const& cc, Database const& cx, Optional<std::vector<TesterInterface>> const& testers, int const& minTestersExpected ) {
															#line 1817 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new RunConsistencyCheckerUrgentCoreActor(cc, cx, testers, minTestersExpected));
															#line 14297 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 1954 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 14302 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via runConsistencyCheckerUrgentHolder()
															#line 1955 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class RunConsistencyCheckerUrgentHolderActor>
															#line 1955 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunConsistencyCheckerUrgentHolderActorState {
															#line 14309 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 1955 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunConsistencyCheckerUrgentHolderActorState(Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> const& cc,Database const& cx,Optional<std::vector<TesterInterface>> const& testers,int const& minTestersExpected,bool const& repeatRun) 
															#line 1955 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 1955 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cc(cc),
															#line 1955 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   cx(cx),
															#line 1955 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   testers(testers),
															#line 1955 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   minTestersExpected(minTestersExpected),
															#line 1955 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   repeatRun(repeatRun)
															#line 14324 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this));

	}
	~RunConsistencyCheckerUrgentHolderActorState() 
	{
		fdb_probe_actor_destroy("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1960 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 14339 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunConsistencyCheckerUrgentHolderActorState();
		static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1967 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunConsistencyCheckerUrgentHolderActorState(); static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->destroy(); return 0; }
															#line 14362 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunConsistencyCheckerUrgentHolderActorState();
		static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1961 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_0 = runConsistencyCheckerUrgentCore(cc, cx, testers, minTestersExpected);
															#line 1961 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14383 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->actor_wait_state = 1;
															#line 1961 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunConsistencyCheckerUrgentHolderActor, 0, Void >*>(static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)));
															#line 14388 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1962 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!repeatRun)
															#line 14410 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1965 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(CLIENT_KNOBS->CONSISTENCY_CHECK_URGENT_NEXT_WAIT_TIME);
															#line 1965 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14418 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->actor_wait_state = 2;
															#line 1965 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunConsistencyCheckerUrgentHolderActor, 1, Void >*>(static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)));
															#line 14423 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1962 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!repeatRun)
															#line 14432 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1965 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(CLIENT_KNOBS->CONSISTENCY_CHECK_URGENT_NEXT_WAIT_TIME);
															#line 1965 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14440 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->actor_wait_state = 2;
															#line 1965 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunConsistencyCheckerUrgentHolderActor, 1, Void >*>(static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)));
															#line 14445 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->actor_wait_state > 0) static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->actor_wait_state = 0;
		static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->ActorCallback< RunConsistencyCheckerUrgentHolderActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentHolderActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentHolderActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunConsistencyCheckerUrgentHolderActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->actor_wait_state > 0) static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->actor_wait_state = 0;
		static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->ActorCallback< RunConsistencyCheckerUrgentHolderActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentHolderActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentHolderActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunConsistencyCheckerUrgentHolderActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1955 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> cc;
															#line 1955 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 1955 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Optional<std::vector<TesterInterface>> testers;
															#line 1955 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	int minTestersExpected;
															#line 1955 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	bool repeatRun;
															#line 14622 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via runConsistencyCheckerUrgentHolder()
															#line 1955 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunConsistencyCheckerUrgentHolderActor final : public Actor<Void>, public ActorCallback< RunConsistencyCheckerUrgentHolderActor, 0, Void >, public ActorCallback< RunConsistencyCheckerUrgentHolderActor, 1, Void >, public FastAllocated<RunConsistencyCheckerUrgentHolderActor>, public RunConsistencyCheckerUrgentHolderActorState<RunConsistencyCheckerUrgentHolderActor> {
															#line 14627 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<RunConsistencyCheckerUrgentHolderActor>::operator new;
	using FastAllocated<RunConsistencyCheckerUrgentHolderActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17202354069034902272UL, 12557637143432017664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunConsistencyCheckerUrgentHolderActor, 0, Void >;
friend struct ActorCallback< RunConsistencyCheckerUrgentHolderActor, 1, Void >;
															#line 1955 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunConsistencyCheckerUrgentHolderActor(Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> const& cc,Database const& cx,Optional<std::vector<TesterInterface>> const& testers,int const& minTestersExpected,bool const& repeatRun) 
															#line 14645 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<Void>(),
		   RunConsistencyCheckerUrgentHolderActorState<RunConsistencyCheckerUrgentHolderActor>(cc, cx, testers, minTestersExpected, repeatRun),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2071602810193994496UL, 16357947033855925504UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runConsistencyCheckerUrgentHolder");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunConsistencyCheckerUrgentHolderActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunConsistencyCheckerUrgentHolderActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1955 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> runConsistencyCheckerUrgentHolder( Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> const& cc, Database const& cx, Optional<std::vector<TesterInterface>> const& testers, int const& minTestersExpected, bool const& repeatRun ) {
															#line 1955 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new RunConsistencyCheckerUrgentHolderActor(cc, cx, testers, minTestersExpected, repeatRun));
															#line 14679 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 1969 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

Future<Void> checkConsistencyUrgentSim(Database cx, std::vector<TesterInterface> testers) {
	if (SERVER_KNOBS->DISABLE_AUDIT_STORAGE_FINAL_REPLICA_CHECK_IN_SIM) {
		return Void();
	}
	return runConsistencyCheckerUrgentHolder(
	    Reference<AsyncVar<Optional<ClusterControllerFullInterface>>>(), cx, testers, 1, /*repeatRun=*/false);
}

															#line 14692 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via runTest()
															#line 1978 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class RunTestActor>
															#line 1978 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunTestActorState {
															#line 14699 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 1978 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunTestActorState(Database const& cx,std::vector<TesterInterface> const& testers,TestSpec const& spec,Reference<AsyncVar<ServerDBInfo>> const& dbInfo,Optional<TenantName> const& defaultTenant,TesterConsistencyScanState* const& consistencyScanState) 
															#line 1978 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 1978 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cx(cx),
															#line 1978 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   testers(testers),
															#line 1978 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   spec(spec),
															#line 1978 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   dbInfo(dbInfo),
															#line 1978 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   defaultTenant(defaultTenant),
															#line 1978 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   consistencyScanState(consistencyScanState),
															#line 1984 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   testResults(),
															#line 1985 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   savedDisableDuration(0)
															#line 14720 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("runTest", reinterpret_cast<unsigned long>(this));

	}
	~RunTestActorState() 
	{
		fdb_probe_actor_destroy("runTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1988 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				Future<DistributedTestResults> fTestResults = runWorkload(cx, testers, spec, defaultTenant);
															#line 1989 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (g_network->isSimulated() && spec.simConnectionFailuresDisableDuration > 0)
															#line 14738 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				{
															#line 1990 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					savedDisableDuration = g_simulator->connectionFailuresDisableDuration;
															#line 1991 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					g_simulator->connectionFailuresDisableDuration = spec.simConnectionFailuresDisableDuration;
															#line 14744 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				}
															#line 1993 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (spec.timeout > 0)
															#line 14748 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				{
															#line 1994 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					fTestResults = timeoutError(fTestResults, spec.timeout);
															#line 14752 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				}
															#line 1996 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<DistributedTestResults> __when_expr_0 = fTestResults;
															#line 1996 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 14758 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RunTestActor*>(this)->actor_wait_state = 1;
															#line 1996 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 0, DistributedTestResults >*>(static_cast<RunTestActor*>(this)));
															#line 14763 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunTestActorState();
		static_cast<RunTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2018 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ok = testResults.ok();
															#line 2020 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (spec.useDB)
															#line 14794 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2021 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			printf("%d test clients passed; %d test clients failed\n", testResults.successes, testResults.failures);
															#line 2022 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (spec.dumpAfterTest)
															#line 14800 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
				try {
															#line 2024 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					StrictFuture<Void> __when_expr_1 = timeoutError(dumpDatabase(cx, "dump after " + printable(spec.title) + ".html", allKeys), 30.0);
															#line 2024 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 14807 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
					static_cast<RunTestActor*>(this)->actor_wait_state = 2;
															#line 2024 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 1, Void >*>(static_cast<RunTestActor*>(this)));
															#line 14812 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1cont1Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont9(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2004 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 14838 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 2005 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				auto msg = fmt::format("Process timed out after {} seconds", spec.timeout);
															#line 2006 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				ProcessEvents::trigger("Timeout"_sr, StringRef(msg), e);
															#line 2007 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent(SevError, "TestFailure") .error(e) .detail("Reason", "Test timed out") .detail("Timeout", spec.timeout);
															#line 2011 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				fprintf(stderr, "ERROR: Test timed out after %d seconds.\n", spec.timeout);
															#line 2012 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				testResults.failures = testers.size();
															#line 2013 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				testResults.successes = 0;
															#line 14852 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
			else
			{
															#line 2015 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 14858 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(DistributedTestResults const& _testResults,int loopDepth) 
	{
															#line 1997 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("Test complete\n");
															#line 1998 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		testResults = _testResults;
															#line 1999 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		logMetrics(testResults.metrics);
															#line 2000 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (g_network->isSimulated() && savedDisableDuration > 0)
															#line 14880 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2001 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->connectionFailuresDisableDuration = savedDisableDuration;
															#line 14884 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(DistributedTestResults && _testResults,int loopDepth) 
	{
															#line 1997 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("Test complete\n");
															#line 1998 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		testResults = _testResults;
															#line 1999 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		logMetrics(testResults.metrics);
															#line 2000 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (g_network->isSimulated() && savedDisableDuration > 0)
															#line 14900 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2001 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->connectionFailuresDisableDuration = savedDisableDuration;
															#line 14904 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1when1(DistributedTestResults const& _testResults,int loopDepth) 
	{
		loopDepth = a_body1cont2(_testResults, loopDepth);

		return loopDepth;
	}
	int a_body1when1(DistributedTestResults && _testResults,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_testResults), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 0, DistributedTestResults >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 0, DistributedTestResults >*,DistributedTestResults const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 0, DistributedTestResults >*,DistributedTestResults && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunTestActor, 0, DistributedTestResults >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(int loopDepth) 
	{
															#line 2083 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(ok ? SevInfo : SevWarnAlways, "TestResults").detail("Workload", spec.title).detail("Passed", (int)ok);
															#line 2086 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (ok)
															#line 15004 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2087 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			passCount++;
															#line 15008 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
		else
		{
															#line 2089 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			failCount++;
															#line 15014 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 2092 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("%d test clients passed; %d test clients failed\n", testResults.successes, testResults.failures);
															#line 2094 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (spec.useDB && spec.clearAfterTest)
															#line 15020 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
			try {
															#line 2096 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent("TesterClearingDatabase").log();
															#line 2097 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_10 = timeoutError(clearData(cx, defaultTenant), 1000.0);
															#line 2097 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont8Catch1(actor_cancelled(), loopDepth);
															#line 15029 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont8Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont8when1(__when_expr_10.get(), loopDepth); };
				static_cast<RunTestActor*>(this)->actor_wait_state = 11;
															#line 2097 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 10, Void >*>(static_cast<RunTestActor*>(this)));
															#line 15034 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont8Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont8Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont13(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
															#line 2035 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_3 = checkConsistencyScanAfterTest(cx, consistencyScanState);
															#line 2035 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15056 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont9when1(__when_expr_3.get(), loopDepth); };
		static_cast<RunTestActor*>(this)->actor_wait_state = 4;
															#line 2035 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 3, Void >*>(static_cast<RunTestActor*>(this)));
															#line 15061 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(int loopDepth) 
	{
															#line 2030 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(1.0);
															#line 2030 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15072 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont10when1(__when_expr_2.get(), loopDepth); };
		static_cast<RunTestActor*>(this)->actor_wait_state = 3;
															#line 2030 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 2, Void >*>(static_cast<RunTestActor*>(this)));
															#line 15077 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2026 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevError, "TestFailure").error(e).detail("Reason", "Unable to dump database");
															#line 2027 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			ok = false;
															#line 15089 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = a_body1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunTestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont11cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunTestActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
															#line 2036 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("Consistency scan done\n");
															#line 2039 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (spec.runConsistencyCheck)
															#line 15293 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2040 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			quiescent = g_network->isSimulated() ? !BUGGIFY : spec.waitForQuiescenceEnd;
															#line 15297 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			try {
															#line 2042 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				printf("Running urgent consistency check...\n");
															#line 2044 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_4 = timeoutError(checkConsistencyUrgentSim(cx, testers), 20000.0);
															#line 2044 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont12Catch1(actor_cancelled(), loopDepth);
															#line 15305 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont12Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont12when1(__when_expr_4.get(), loopDepth); };
				static_cast<RunTestActor*>(this)->actor_wait_state = 5;
															#line 2044 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 4, Void >*>(static_cast<RunTestActor*>(this)));
															#line 15310 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont12Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont12Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont12cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
															#line 2036 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("Consistency scan done\n");
															#line 2039 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (spec.runConsistencyCheck)
															#line 15332 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2040 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			quiescent = g_network->isSimulated() ? !BUGGIFY : spec.waitForQuiescenceEnd;
															#line 15336 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			try {
															#line 2042 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				printf("Running urgent consistency check...\n");
															#line 2044 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_4 = timeoutError(checkConsistencyUrgentSim(cx, testers), 20000.0);
															#line 2044 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont12Catch1(actor_cancelled(), loopDepth);
															#line 15344 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont12Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont12when1(__when_expr_4.get(), loopDepth); };
				static_cast<RunTestActor*>(this)->actor_wait_state = 5;
															#line 2044 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 4, Void >*>(static_cast<RunTestActor*>(this)));
															#line 15349 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont12Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont12Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont12cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunTestActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont12cont1(int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2(int loopDepth) 
	{
															#line 2062 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (quiescent && g_network->isSimulated())
															#line 15450 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
			try {
															#line 2064 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent("AuditStorageStart");
															#line 2065 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_6 = timeoutError(auditStorageCorrectness(dbInfo, AuditType::ValidateHA), 1500.0);
															#line 2065 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2Catch1(actor_cancelled(), loopDepth);
															#line 15459 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont12cont2Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont12cont2when1(__when_expr_6.get(), loopDepth); };
				static_cast<RunTestActor*>(this)->actor_wait_state = 7;
															#line 2065 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 6, Void >*>(static_cast<RunTestActor*>(this)));
															#line 15464 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont12cont2Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont12cont2Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont12cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2057 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevError, "TestFailure").error(e).detail("Reason", "Unable to perform consistency check");
															#line 2058 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			ok = false;
															#line 15487 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = a_body1cont12cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont3(Void const& _,int loopDepth) 
	{
															#line 2045 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("Urgent consistency check done\nRunning consistency check...\n");
															#line 2046 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_5 = timeoutError(checkConsistency(cx, testers, quiescent, spec.runConsistencyCheckOnTSS, spec.maxDDRunTime > 0 ? spec.maxDDRunTime : 10000.0, 5000, spec.databasePingDelay, dbInfo), 20000.0);
															#line 2046 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont12Catch1(actor_cancelled(), loopDepth);
															#line 15506 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont12Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont12cont3when1(__when_expr_5.get(), loopDepth); };
		static_cast<RunTestActor*>(this)->actor_wait_state = 6;
															#line 2046 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 5, Void >*>(static_cast<RunTestActor*>(this)));
															#line 15511 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont3(Void && _,int loopDepth) 
	{
															#line 2045 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("Urgent consistency check done\nRunning consistency check...\n");
															#line 2046 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_5 = timeoutError(checkConsistency(cx, testers, quiescent, spec.runConsistencyCheckOnTSS, spec.maxDDRunTime > 0 ? spec.maxDDRunTime : 10000.0, 5000, spec.databasePingDelay, dbInfo), 20000.0);
															#line 2046 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont12Catch1(actor_cancelled(), loopDepth);
															#line 15524 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont12Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont12cont3when1(__when_expr_5.get(), loopDepth); };
		static_cast<RunTestActor*>(this)->actor_wait_state = 6;
															#line 2046 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 5, Void >*>(static_cast<RunTestActor*>(this)));
															#line 15529 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12Catch1(error, 0);
		} catch (...) {
			a_body1cont12Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12Catch1(error, 0);
		} catch (...) {
			a_body1cont12Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RunTestActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont12Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12Catch1(error, 0);
		} catch (...) {
			a_body1cont12Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12cont4(Void const& _,int loopDepth) 
	{
															#line 2055 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("Consistency check done\n");
															#line 15613 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont12cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4(Void && _,int loopDepth) 
	{
															#line 2055 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("Consistency check done\n");
															#line 15622 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont12cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12Catch1(error, 0);
		} catch (...) {
			a_body1cont12Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12Catch1(error, 0);
		} catch (...) {
			a_body1cont12Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RunTestActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12Catch1(error, 0);
		} catch (...) {
			a_body1cont12Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont12cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont12cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont7(int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont8(int loopDepth) 
	{
		loopDepth = a_body1cont12cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2074 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			ok = false;
															#line 2075 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevError, "TestFailure") .error(e) .detail("Reason", "Unable to perform auditStorage check.");
															#line 15734 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = a_body1cont12cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont9(Void const& _,int loopDepth) 
	{
															#line 2066 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("AuditStorageCorrectnessHADone");
															#line 2067 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_7 = timeoutError(auditStorageCorrectness(dbInfo, AuditType::ValidateReplica), 1500.0);
															#line 2067 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2Catch1(actor_cancelled(), loopDepth);
															#line 15753 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont12cont2Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont12cont9when1(__when_expr_7.get(), loopDepth); };
		static_cast<RunTestActor*>(this)->actor_wait_state = 8;
															#line 2067 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 7, Void >*>(static_cast<RunTestActor*>(this)));
															#line 15758 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont9(Void && _,int loopDepth) 
	{
															#line 2066 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("AuditStorageCorrectnessHADone");
															#line 2067 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_7 = timeoutError(auditStorageCorrectness(dbInfo, AuditType::ValidateReplica), 1500.0);
															#line 2067 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2Catch1(actor_cancelled(), loopDepth);
															#line 15771 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont12cont2Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont12cont9when1(__when_expr_7.get(), loopDepth); };
		static_cast<RunTestActor*>(this)->actor_wait_state = 8;
															#line 2067 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 7, Void >*>(static_cast<RunTestActor*>(this)));
															#line 15776 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RunTestActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont12cont10(Void const& _,int loopDepth) 
	{
															#line 2068 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("AuditStorageCorrectnessReplicaDone");
															#line 2069 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_8 = timeoutError(auditStorageCorrectness(dbInfo, AuditType::ValidateLocationMetadata), 1500.0);
															#line 2069 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2Catch1(actor_cancelled(), loopDepth);
															#line 15864 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont12cont2Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont12cont10when1(__when_expr_8.get(), loopDepth); };
		static_cast<RunTestActor*>(this)->actor_wait_state = 9;
															#line 2069 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 8, Void >*>(static_cast<RunTestActor*>(this)));
															#line 15869 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10(Void && _,int loopDepth) 
	{
															#line 2068 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("AuditStorageCorrectnessReplicaDone");
															#line 2069 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_8 = timeoutError(auditStorageCorrectness(dbInfo, AuditType::ValidateLocationMetadata), 1500.0);
															#line 2069 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2Catch1(actor_cancelled(), loopDepth);
															#line 15882 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont12cont2Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont12cont10when1(__when_expr_8.get(), loopDepth); };
		static_cast<RunTestActor*>(this)->actor_wait_state = 9;
															#line 2069 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 8, Void >*>(static_cast<RunTestActor*>(this)));
															#line 15887 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< RunTestActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont12cont10cont1(Void const& _,int loopDepth) 
	{
															#line 2070 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("AuditStorageCorrectnessLocationMetadataDone");
															#line 2071 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_9 = timeoutError(auditStorageCorrectness(dbInfo, AuditType::ValidateStorageServerShard), 1500.0);
															#line 2071 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2Catch1(actor_cancelled(), loopDepth);
															#line 15975 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont12cont2Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont12cont10cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<RunTestActor*>(this)->actor_wait_state = 10;
															#line 2071 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 9, Void >*>(static_cast<RunTestActor*>(this)));
															#line 15980 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont1(Void && _,int loopDepth) 
	{
															#line 2070 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("AuditStorageCorrectnessLocationMetadataDone");
															#line 2071 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_9 = timeoutError(auditStorageCorrectness(dbInfo, AuditType::ValidateStorageServerShard), 1500.0);
															#line 2071 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2Catch1(actor_cancelled(), loopDepth);
															#line 15993 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont12cont2Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont12cont10cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<RunTestActor*>(this)->actor_wait_state = 10;
															#line 2071 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 9, Void >*>(static_cast<RunTestActor*>(this)));
															#line 15998 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< RunTestActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont12cont10cont2(Void const& _,int loopDepth) 
	{
															#line 2072 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("AuditStorageCorrectnessStorageServerShardDone");
															#line 16082 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont12cont10cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont2(Void && _,int loopDepth) 
	{
															#line 2072 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("AuditStorageCorrectnessStorageServerShardDone");
															#line 16091 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont12cont10cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont12cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont12cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< RunTestActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont12cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont12cont10cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont12cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13(int loopDepth) 
	{
															#line 2106 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<RunTestActor*>(this)->SAV<bool>::futures) { (void)(ok); this->~RunTestActorState(); static_cast<RunTestActor*>(this)->destroy(); return 0; }
															#line 16188 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<RunTestActor*>(this)->SAV< bool >::value()) bool(std::move(ok)); // state_var_RVO
		this->~RunTestActorState();
		static_cast<RunTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont16(int loopDepth) 
	{
															#line 2103 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_11 = delay(1.0);
															#line 2103 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16202 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont16when1(__when_expr_11.get(), loopDepth); };
		static_cast<RunTestActor*>(this)->actor_wait_state = 12;
															#line 2103 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 11, Void >*>(static_cast<RunTestActor*>(this)));
															#line 16207 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2099 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevError, "ErrorClearingDatabaseAfterTest").error(e);
															#line 2100 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 16219 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont17(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont17cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont17(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont17cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont17(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont17(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< RunTestActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont8Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont17cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont16(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont16cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont16cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont16when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont16when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont16when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont16when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< RunTestActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 11);

	}
															#line 1978 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 1978 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<TesterInterface> testers;
															#line 1978 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TestSpec spec;
															#line 1978 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> dbInfo;
															#line 1978 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Optional<TenantName> defaultTenant;
															#line 1978 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TesterConsistencyScanState* consistencyScanState;
															#line 1984 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	DistributedTestResults testResults;
															#line 1985 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double savedDisableDuration;
															#line 2018 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	bool ok;
															#line 2040 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	bool quiescent;
															#line 16436 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via runTest()
															#line 1978 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunTestActor final : public Actor<bool>, public ActorCallback< RunTestActor, 0, DistributedTestResults >, public ActorCallback< RunTestActor, 1, Void >, public ActorCallback< RunTestActor, 2, Void >, public ActorCallback< RunTestActor, 3, Void >, public ActorCallback< RunTestActor, 4, Void >, public ActorCallback< RunTestActor, 5, Void >, public ActorCallback< RunTestActor, 6, Void >, public ActorCallback< RunTestActor, 7, Void >, public ActorCallback< RunTestActor, 8, Void >, public ActorCallback< RunTestActor, 9, Void >, public ActorCallback< RunTestActor, 10, Void >, public ActorCallback< RunTestActor, 11, Void >, public FastAllocated<RunTestActor>, public RunTestActorState<RunTestActor> {
															#line 16441 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<RunTestActor>::operator new;
	using FastAllocated<RunTestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16227594616607698688UL, 2086934706585430272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunTestActor, 0, DistributedTestResults >;
friend struct ActorCallback< RunTestActor, 1, Void >;
friend struct ActorCallback< RunTestActor, 2, Void >;
friend struct ActorCallback< RunTestActor, 3, Void >;
friend struct ActorCallback< RunTestActor, 4, Void >;
friend struct ActorCallback< RunTestActor, 5, Void >;
friend struct ActorCallback< RunTestActor, 6, Void >;
friend struct ActorCallback< RunTestActor, 7, Void >;
friend struct ActorCallback< RunTestActor, 8, Void >;
friend struct ActorCallback< RunTestActor, 9, Void >;
friend struct ActorCallback< RunTestActor, 10, Void >;
friend struct ActorCallback< RunTestActor, 11, Void >;
															#line 1978 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunTestActor(Database const& cx,std::vector<TesterInterface> const& testers,TestSpec const& spec,Reference<AsyncVar<ServerDBInfo>> const& dbInfo,Optional<TenantName> const& defaultTenant,TesterConsistencyScanState* const& consistencyScanState) 
															#line 16469 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<bool>(),
		   RunTestActorState<RunTestActor>(cx, testers, spec, dbInfo, defaultTenant, consistencyScanState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12013671372596341504UL, 10273208522725205248UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunTestActor, 0, DistributedTestResults >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunTestActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunTestActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunTestActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RunTestActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RunTestActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< RunTestActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< RunTestActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< RunTestActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< RunTestActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< RunTestActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< RunTestActor, 11, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1978 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<bool> runTest( Database const& cx, std::vector<TesterInterface> const& testers, TestSpec const& spec, Reference<AsyncVar<ServerDBInfo>> const& dbInfo, Optional<TenantName> const& defaultTenant, TesterConsistencyScanState* const& consistencyScanState ) {
															#line 1978 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<bool>(new RunTestActor(cx, testers, spec, dbInfo, defaultTenant, consistencyScanState));
															#line 16513 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 2108 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

std::map<std::string, std::function<void(const std::string&)>> testSpecGlobalKeys = {
	// These are read by SimulatedCluster and used before testers exist.  Thus, they must
	// be recognized and accepted, but there's no point in placing them into a testSpec.
	// testClass and testPriority are only used for TestHarness, we'll ignore those here
	{ "testClass", [](std::string const&) {} },
	{ "testPriority", [](std::string const&) {} },
	{ "extraDatabaseMode",
	  [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedExtraDatabaseMode", ""); } },
	{ "extraDatabaseCount",
	  [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedExtraDatabaseCount", ""); } },
	{ "configureLocked",
	  [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedConfigureLocked", ""); } },
	{ "minimumReplication",
	  [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedMinimumReplication", ""); } },
	{ "minimumRegions",
	  [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedMinimumRegions", ""); } },
	{ "logAntiQuorum",
	  [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedLogAntiQuorum", ""); } },
	{ "buggify", [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedBuggify", value); } },
	// The test harness handles NewSeverity events specially.
	{ "StderrSeverity", [](const std::string& value) { TraceEvent("StderrSeverity").detail("NewSeverity", value); } },
	{ "ClientInfoLogging",
	  [](const std::string& value) {
	      if (value == "false") {
		      setNetworkOption(FDBNetworkOptions::DISABLE_CLIENT_STATISTICS_LOGGING);
	      }
	      // else { } It is enable by default for tester
	      TraceEvent("TestParserTest").detail("ClientInfoLogging", value);
	  } },
	{ "startIncompatibleProcess",
	  [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedStartIncompatibleProcess", value); } },
	{ "storageEngineExcludeTypes",
	  [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedStorageEngineExcludeTypes", ""); } },
	{ "maxTLogVersion",
	  [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedMaxTLogVersion", ""); } },
	{ "disableTss", [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedDisableTSS", ""); } },
	{ "disableHostname",
	  [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedDisableHostname", ""); } },
	{ "disableRemoteKVS",
	  [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedRemoteKVS", ""); } },
	{ "allowDefaultTenant",
	  [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedDefaultTenant", ""); } }
};

std::map<std::string, std::function<void(const std::string& value, TestSpec* spec)>> testSpecTestKeys = {
	{ "testTitle",
	  [](const std::string& value, TestSpec* spec) {
	      spec->title = value;
	      TraceEvent("TestParserTest").detail("ParsedTest", spec->title);
	  } },
	{ "timeout",
	  [](const std::string& value, TestSpec* spec) {
	      sscanf(value.c_str(), "%d", &(spec->timeout));
	      ASSERT(spec->timeout > 0);
	      TraceEvent("TestParserTest").detail("ParsedTimeout", spec->timeout);
	  } },
	{ "databasePingDelay",
	  [](const std::string& value, TestSpec* spec) {
	      double databasePingDelay;
	      sscanf(value.c_str(), "%lf", &databasePingDelay);
	      ASSERT(databasePingDelay >= 0);
	      if (!spec->useDB && databasePingDelay > 0) {
		      TraceEvent(SevError, "TestParserError")
		          .detail("Reason", "Cannot have non-zero ping delay on test that does not use database")
		          .detail("PingDelay", databasePingDelay)
		          .detail("UseDB", spec->useDB);
		      ASSERT(false);
	      }
	      spec->databasePingDelay = databasePingDelay;
	      TraceEvent("TestParserTest").detail("ParsedPingDelay", spec->databasePingDelay);
	  } },
	{ "runSetup",
	  [](const std::string& value, TestSpec* spec) {
	      spec->phases = TestWorkload::EXECUTION | TestWorkload::CHECK | TestWorkload::METRICS;
	      if (value == "true")
		      spec->phases |= TestWorkload::SETUP;
	      TraceEvent("TestParserTest").detail("ParsedSetupFlag", (spec->phases & TestWorkload::SETUP) != 0);
	  } },
	{ "dumpAfterTest",
	  [](const std::string& value, TestSpec* spec) {
	      spec->dumpAfterTest = (value == "true");
	      TraceEvent("TestParserTest").detail("ParsedDumpAfter", spec->dumpAfterTest);
	  } },
	{ "clearAfterTest",
	  [](const std::string& value, TestSpec* spec) {
	      spec->clearAfterTest = (value == "true");
	      TraceEvent("TestParserTest").detail("ParsedClearAfter", spec->clearAfterTest);
	  } },
	{ "useDB",
	  [](const std::string& value, TestSpec* spec) {
	      spec->useDB = (value == "true");
	      TraceEvent("TestParserTest").detail("ParsedUseDB", spec->useDB);
	      if (!spec->useDB)
		      spec->databasePingDelay = 0.0;
	  } },
	{ "startDelay",
	  [](const std::string& value, TestSpec* spec) {
	      sscanf(value.c_str(), "%lf", &spec->startDelay);
	      TraceEvent("TestParserTest").detail("ParsedStartDelay", spec->startDelay);
	  } },
	{ "runConsistencyCheck",
	  [](const std::string& value, TestSpec* spec) {
	      spec->runConsistencyCheck = (value == "true");
	      TraceEvent("TestParserTest").detail("ParsedRunConsistencyCheck", spec->runConsistencyCheck);
	  } },
	{ "runConsistencyCheckOnTSS",
	  [](const std::string& value, TestSpec* spec) {
	      spec->runConsistencyCheckOnTSS = (value == "true");
	      TraceEvent("TestParserTest").detail("ParsedRunConsistencyCheckOnTSS", spec->runConsistencyCheckOnTSS);
	  } },
	{ "maxDDRunTime",
	  [](const std::string& value, TestSpec* spec) {
	      sscanf(value.c_str(), "%lf", &(spec->maxDDRunTime));
	      ASSERT(spec->maxDDRunTime >= 0);
	      TraceEvent("TestParserTest").detail("ParsedMaxDDRunTime", spec->maxDDRunTime);
	  } },
	{ "waitForQuiescence",
	  [](const std::string& value, TestSpec* spec) {
	      bool toWait = value == "true";
	      spec->waitForQuiescenceBegin = toWait;
	      spec->waitForQuiescenceEnd = toWait;
	      TraceEvent("TestParserTest").detail("ParsedWaitForQuiescence", toWait);
	  } },
	{ "waitForQuiescenceBegin",
	  [](const std::string& value, TestSpec* spec) {
	      bool toWait = value == "true";
	      spec->waitForQuiescenceBegin = toWait;
	      TraceEvent("TestParserTest").detail("ParsedWaitForQuiescenceBegin", toWait);
	  } },
	{ "waitForQuiescenceEnd",
	  [](const std::string& value, TestSpec* spec) {
	      bool toWait = value == "true";
	      spec->waitForQuiescenceEnd = toWait;
	      TraceEvent("TestParserTest").detail("ParsedWaitForQuiescenceEnd", toWait);
	  } },
	{ "simCheckRelocationDuration",
	  [](const std::string& value, TestSpec* spec) {
	      spec->simCheckRelocationDuration = (value == "true");
	      TraceEvent("TestParserTest").detail("ParsedSimCheckRelocationDuration", spec->simCheckRelocationDuration);
	  } },
	{ "connectionFailuresDisableDuration",
	  [](const std::string& value, TestSpec* spec) {
	      double connectionFailuresDisableDuration;
	      sscanf(value.c_str(), "%lf", &connectionFailuresDisableDuration);
	      ASSERT(connectionFailuresDisableDuration >= 0);
	      spec->simConnectionFailuresDisableDuration = connectionFailuresDisableDuration;
	      TraceEvent("TestParserTest")
	          .detail("ParsedSimConnectionFailuresDisableDuration", spec->simConnectionFailuresDisableDuration);
	  } },
	{ "simBackupAgents",
	  [](const std::string& value, TestSpec* spec) {
	      if (value == "BackupToFile" || value == "BackupToFileAndDB")
		      spec->simBackupAgents = ISimulator::BackupAgentType::BackupToFile;
	      else
		      spec->simBackupAgents = ISimulator::BackupAgentType::NoBackupAgents;
	      TraceEvent("TestParserTest").detail("ParsedSimBackupAgents", spec->simBackupAgents);

	      if (value == "BackupToDB" || value == "BackupToFileAndDB")
		      spec->simDrAgents = ISimulator::BackupAgentType::BackupToDB;
	      else
		      spec->simDrAgents = ISimulator::BackupAgentType::NoBackupAgents;
	      TraceEvent("TestParserTest").detail("ParsedSimDrAgents", spec->simDrAgents);
	  } },
	{ "checkOnly",
	  [](const std::string& value, TestSpec* spec) {
	      if (value == "true")
		      spec->phases = TestWorkload::CHECK;
	  } },
	{ "restorePerpetualWiggleSetting",
	  [](const std::string& value, TestSpec* spec) {
	      if (value == "false")
		      spec->restorePerpetualWiggleSetting = false;
	  } },
	{ "runFailureWorkloads",
	  [](const std::string& value, TestSpec* spec) { spec->runFailureWorkloads = (value == "true"); } },
	{ "disabledFailureInjectionWorkloads",
	  [](const std::string& value, TestSpec* spec) {
	      // Expects a comma separated list of workload names in "value".
	      // This custom encoding is needed because both text and toml files need to be supported
	      // and "value" is passed in as a string.
	      std::stringstream ss(value);
	      while (ss.good()) {
		      std::string substr;
		      getline(ss, substr, ',');
		      substr = removeWhitespace(substr);
		      if (!substr.empty()) {
			      spec->disabledFailureInjectionWorkloads.push_back(substr);
		      }
	      }
	  } },
};

std::vector<TestSpec> readTests(std::ifstream& ifs) {
	TestSpec spec;
	std::vector<TestSpec> result;
	Standalone<VectorRef<KeyValueRef>> workloadOptions;
	std::string cline;
	bool beforeFirstTest = true;
	bool parsingWorkloads = false;

	while (ifs.good()) {
		getline(ifs, cline);
		std::string line = removeWhitespace(cline);
		if (!line.size() || line.find(';') == 0)
			continue;

		size_t found = line.find('=');
		if (found == std::string::npos)
			// hmmm, not good
			continue;
		std::string attrib = removeWhitespace(line.substr(0, found));
		std::string value = removeWhitespace(line.substr(found + 1));

		if (attrib == "testTitle") {
			beforeFirstTest = false;
			parsingWorkloads = false;
			if (workloadOptions.size()) {
				spec.options.push_back_deep(spec.options.arena(), workloadOptions);
				workloadOptions = Standalone<VectorRef<KeyValueRef>>();
			}
			if (spec.options.size() && spec.title.size()) {
				result.push_back(spec);
				spec = TestSpec();
			}

			testSpecTestKeys[attrib](value, &spec);
		} else if (testSpecTestKeys.find(attrib) != testSpecTestKeys.end()) {
			if (parsingWorkloads)
				TraceEvent(SevError, "TestSpecTestParamInWorkload").detail("Attrib", attrib).detail("Value", value);
			testSpecTestKeys[attrib](value, &spec);
		} else if (testSpecGlobalKeys.find(attrib) != testSpecGlobalKeys.end()) {
			if (!beforeFirstTest)
				TraceEvent(SevError, "TestSpecGlobalParamInTest").detail("Attrib", attrib).detail("Value", value);
			testSpecGlobalKeys[attrib](value);
		} else {
			if (attrib == "testName") {
				parsingWorkloads = true;
				if (workloadOptions.size()) {
					TraceEvent("TestParserFlush").detail("Reason", "new (compound) test");
					spec.options.push_back_deep(spec.options.arena(), workloadOptions);
					workloadOptions = Standalone<VectorRef<KeyValueRef>>();
				}
			}

			workloadOptions.push_back_deep(workloadOptions.arena(), KeyValueRef(StringRef(attrib), StringRef(value)));
			TraceEvent("TestParserOption").detail("ParsedKey", attrib).detail("ParsedValue", value);
		}
	}
	if (workloadOptions.size())
		spec.options.push_back_deep(spec.options.arena(), workloadOptions);
	if (spec.options.size() && spec.title.size()) {
		result.push_back(spec);
	}

	return result;
}

template <typename T>
std::string toml_to_string(const T& value) {
	// TOML formatting converts numbers to strings exactly how they're in the file
	// and thus, is equivalent to testspec.  However, strings are quoted, so we
	// must remove the quotes.
	if (value.type() == toml::value_t::string) {
		const std::string& formatted = toml::format(value);
		return formatted.substr(1, formatted.size() - 2);
	} else {
		return toml::format(value);
	}
}

struct TestSet {
	KnobKeyValuePairs overrideKnobs;
	std::vector<TestSpec> testSpecs;
};

namespace {

// In the current TOML scope, look for "knobs" field. If exists, translate all
// key value pairs into KnobKeyValuePairs
KnobKeyValuePairs getOverriddenKnobKeyValues(const toml::value& context) {
	KnobKeyValuePairs result;

	try {
		const toml::array& overrideKnobs = toml::find(context, "knobs").as_array();
		for (const toml::value& knob : overrideKnobs) {
			for (const auto& [key, value_] : knob.as_table()) {
				const std::string& value = toml_to_string(value_);
				ParsedKnobValue parsedValue = CLIENT_KNOBS->parseKnobValue(key, value);
				if (std::get_if<NoKnobFound>(&parsedValue)) {
					parsedValue = SERVER_KNOBS->parseKnobValue(key, value);
				}
				if (std::get_if<NoKnobFound>(&parsedValue)) {
					parsedValue = FLOW_KNOBS->parseKnobValue(key, value);
				}
				if (std::get_if<NoKnobFound>(&parsedValue)) {
					TraceEvent(SevError, "TestSpecUnrecognizedKnob")
					    .detail("KnobName", key)
					    .detail("OverrideValue", value);
					continue;
				}
				result.set(key, parsedValue);
			}
		}
	} catch (const std::out_of_range&) {
		// No knobs field in this scope, this is not an error
	}

	return result;
}

} // namespace

TestSet readTOMLTests_(std::string fileName) {
	Standalone<VectorRef<KeyValueRef>> workloadOptions;
	TestSet result;

	const toml::value& conf = toml::parse(fileName);

	// Parse the global knob changes
	result.overrideKnobs = getOverriddenKnobKeyValues(conf);

	// Then parse each test
	const toml::array& tests = toml::find(conf, "test").as_array();
	for (const toml::value& test : tests) {
		TestSpec spec;

		// First handle all test-level settings
		for (const auto& [k, v] : test.as_table()) {
			if (k == "workload" || k == "knobs") {
				continue;
			}
			if (testSpecTestKeys.find(k) != testSpecTestKeys.end()) {
				testSpecTestKeys[k](toml_to_string(v), &spec);
			} else {
				TraceEvent(SevError, "TestSpecUnrecognizedTestParam")
				    .detail("Attrib", k)
				    .detail("Value", toml_to_string(v));
			}
		}

		// And then copy the workload attributes to spec.options
		const toml::array& workloads = toml::find(test, "workload").as_array();
		for (const toml::value& workload : workloads) {
			workloadOptions = Standalone<VectorRef<KeyValueRef>>();
			TraceEvent("TestParserFlush").detail("Reason", "new (compound) test");
			for (const auto& [attrib, v] : workload.as_table()) {
				const std::string& value = toml_to_string(v);
				workloadOptions.push_back_deep(workloadOptions.arena(),
				                               KeyValueRef(StringRef(attrib), StringRef(value)));
				TraceEvent("TestParserOption").detail("ParsedKey", attrib).detail("ParsedValue", value);
			}
			spec.options.push_back_deep(spec.options.arena(), workloadOptions);
		}

		// And then copy the knob attributes to spec.overrideKnobs
		spec.overrideKnobs = getOverriddenKnobKeyValues(test);

		result.testSpecs.push_back(spec);
	}

	return result;
}

// A hack to catch and log std::exception, because TOML11 has very useful
// error messages, but the actor framework can't handle std::exception.
TestSet readTOMLTests(std::string fileName) {
	try {
		return readTOMLTests_(fileName);
	} catch (std::exception& e) {
		std::cerr << e.what() << std::endl;
		TraceEvent("TOMLParseError").detail("Error", printable(e.what()));
		// TODO: replace with toml_parse_error();
		throw unknown_error();
	}
}

															#line 16894 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorServerDBInfo()
															#line 2485 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class MonitorServerDBInfoActor>
															#line 2485 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class MonitorServerDBInfoActorState {
															#line 16901 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 2485 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	MonitorServerDBInfoActorState(Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> const& ccInterface,LocalityData const& locality,Reference<AsyncVar<ServerDBInfo>> const& dbInfo) 
															#line 2485 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 2485 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : ccInterface(ccInterface),
															#line 2485 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   locality(locality),
															#line 2485 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   dbInfo(dbInfo)
															#line 16912 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorServerDBInfo", reinterpret_cast<unsigned long>(this));

	}
	~MonitorServerDBInfoActorState() 
	{
		fdb_probe_actor_destroy("monitorServerDBInfo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2489 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			ServerDBInfo localInfo;
															#line 2490 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			localInfo.myLocality = locality;
															#line 2491 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			dbInfo->set(localInfo);
															#line 2493 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 16933 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorServerDBInfoActorState();
		static_cast<MonitorServerDBInfoActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2494 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		GetServerDBInfoRequest req;
															#line 2495 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		req.knownServerInfoID = dbInfo->get().id;
															#line 2498 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<ServerDBInfo> __when_expr_0 = ccInterface->get().present() ? brokenPromiseToNever(ccInterface->get().get().getServerDBInfo.getReply(req)) : Never();
															#line 2497 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<MonitorServerDBInfoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16969 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 2513 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = ccInterface->onChange();
															#line 16973 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorServerDBInfoActor*>(this)->actor_wait_state = 1;
															#line 2498 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorServerDBInfoActor, 0, ServerDBInfo >*>(static_cast<MonitorServerDBInfoActor*>(this)));
															#line 2513 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorServerDBInfoActor, 1, Void >*>(static_cast<MonitorServerDBInfoActor*>(this)));
															#line 16980 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(ServerDBInfo const& _localInfo,int loopDepth) 
	{
															#line 2502 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ServerDBInfo localInfo = _localInfo;
															#line 2503 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("GotServerDBInfoChange") .detail("ChangeID", localInfo.id) .detail("MasterID", localInfo.master.id()) .detail("RatekeeperID", localInfo.ratekeeper.present() ? localInfo.ratekeeper.get().id() : UID()) .detail("DataDistributorID", localInfo.distributor.present() ? localInfo.distributor.get().id() : UID());
															#line 2510 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		localInfo.myLocality = locality;
															#line 2511 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		dbInfo->set(localInfo);
															#line 17001 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ServerDBInfo && _localInfo,int loopDepth) 
	{
															#line 2502 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ServerDBInfo localInfo = _localInfo;
															#line 2503 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("GotServerDBInfoChange") .detail("ChangeID", localInfo.id) .detail("MasterID", localInfo.master.id()) .detail("RatekeeperID", localInfo.ratekeeper.present() ? localInfo.ratekeeper.get().id() : UID()) .detail("DataDistributorID", localInfo.distributor.present() ? localInfo.distributor.get().id() : UID());
															#line 2510 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		localInfo.myLocality = locality;
															#line 2511 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		dbInfo->set(localInfo);
															#line 17016 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 2514 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (ccInterface->get().present())
															#line 17025 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2515 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("GotCCInterfaceChange") .detail("CCID", ccInterface->get().get().id()) .detail("CCMachine", ccInterface->get().get().getWorkers.getEndpoint().getPrimaryAddress());
															#line 17029 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 2514 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (ccInterface->get().present())
															#line 17039 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2515 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("GotCCInterfaceChange") .detail("CCID", ccInterface->get().get().id()) .detail("CCMachine", ccInterface->get().get().getWorkers.getEndpoint().getPrimaryAddress());
															#line 17043 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorServerDBInfoActor*>(this)->actor_wait_state > 0) static_cast<MonitorServerDBInfoActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorServerDBInfoActor*>(this)->ActorCallback< MonitorServerDBInfoActor, 0, ServerDBInfo >::remove();
		static_cast<MonitorServerDBInfoActor*>(this)->ActorCallback< MonitorServerDBInfoActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorServerDBInfoActor, 0, ServerDBInfo >*,ServerDBInfo const& value) 
	{
		fdb_probe_actor_enter("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerDBInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorServerDBInfoActor, 0, ServerDBInfo >*,ServerDBInfo && value) 
	{
		fdb_probe_actor_enter("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerDBInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorServerDBInfoActor, 0, ServerDBInfo >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerDBInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorServerDBInfoActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerDBInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorServerDBInfoActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerDBInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorServerDBInfoActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerDBInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2485 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> ccInterface;
															#line 2485 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	LocalityData locality;
															#line 2485 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> dbInfo;
															#line 17176 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via monitorServerDBInfo()
															#line 2485 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class MonitorServerDBInfoActor final : public Actor<Void>, public ActorCallback< MonitorServerDBInfoActor, 0, ServerDBInfo >, public ActorCallback< MonitorServerDBInfoActor, 1, Void >, public FastAllocated<MonitorServerDBInfoActor>, public MonitorServerDBInfoActorState<MonitorServerDBInfoActor> {
															#line 17181 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<MonitorServerDBInfoActor>::operator new;
	using FastAllocated<MonitorServerDBInfoActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14677604514198193408UL, 11188564307749281280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorServerDBInfoActor, 0, ServerDBInfo >;
friend struct ActorCallback< MonitorServerDBInfoActor, 1, Void >;
															#line 2485 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	MonitorServerDBInfoActor(Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> const& ccInterface,LocalityData const& locality,Reference<AsyncVar<ServerDBInfo>> const& dbInfo) 
															#line 17199 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorServerDBInfoActorState<MonitorServerDBInfoActor>(ccInterface, locality, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13073893316168406016UL, 9873335748166095872UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerDBInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorServerDBInfo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorServerDBInfoActor, 0, ServerDBInfo >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2485 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> monitorServerDBInfo( Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> const& ccInterface, LocalityData const& locality, Reference<AsyncVar<ServerDBInfo>> const& dbInfo ) {
															#line 2485 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new MonitorServerDBInfoActor(ccInterface, locality, dbInfo));
															#line 17232 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 2522 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 17237 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via initializeSimConfig()
															#line 2523 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class InitializeSimConfigActor>
															#line 2523 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class InitializeSimConfigActorState {
															#line 17244 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 2523 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	InitializeSimConfigActorState(Database const& db) 
															#line 2523 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 2523 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : db(db),
															#line 2524 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   tr(db)
															#line 17253 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("initializeSimConfig", reinterpret_cast<unsigned long>(this));

	}
	~InitializeSimConfigActorState() 
	{
		fdb_probe_actor_destroy("initializeSimConfig", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2525 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			ASSERT(g_network->isSimulated());
															#line 2526 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 17270 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~InitializeSimConfigActorState();
		static_cast<InitializeSimConfigActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2528 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<DatabaseConfiguration> __when_expr_0 = getDatabaseConfiguration(&tr);
															#line 2528 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<InitializeSimConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17303 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<InitializeSimConfigActor*>(this)->actor_wait_state = 1;
															#line 2528 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< InitializeSimConfigActor, 0, DatabaseConfiguration >*>(static_cast<InitializeSimConfigActor*>(this)));
															#line 17308 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2573 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 2573 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<InitializeSimConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17332 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<InitializeSimConfigActor*>(this)->actor_wait_state = 2;
															#line 2573 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< InitializeSimConfigActor, 1, Void >*>(static_cast<InitializeSimConfigActor*>(this)));
															#line 17337 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(DatabaseConfiguration const& dbConfig,int loopDepth) 
	{
															#line 2529 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->storagePolicy = dbConfig.storagePolicy;
															#line 2530 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->tLogPolicy = dbConfig.tLogPolicy;
															#line 2531 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->tLogWriteAntiQuorum = dbConfig.tLogWriteAntiQuorum;
															#line 2532 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->usableRegions = dbConfig.usableRegions;
															#line 2538 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		bool foundSharedDcId = false;
															#line 2539 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		std::set<Key> dcIds;
															#line 2540 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		int maxSatelliteReplication = 0;
															#line 2541 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for( auto const& r : dbConfig.regions ) {
															#line 2542 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (!dcIds.insert(r.dcId).second)
															#line 17368 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 2543 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				foundSharedDcId = true;
															#line 17372 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 2545 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (!r.satellites.empty() && r.satelliteTLogReplicationFactor > 0 && r.satelliteTLogUsableDcs > 0)
															#line 17376 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 2546 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				for( auto const& s : r.satellites ) {
															#line 2547 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					if (!dcIds.insert(s.dcId).second)
															#line 17382 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
					{
															#line 2548 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
						foundSharedDcId = true;
															#line 17386 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
					}
				}
															#line 2552 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				maxSatelliteReplication = std::max(maxSatelliteReplication, r.satelliteTLogReplicationFactor / r.satelliteTLogUsableDcs);
															#line 17391 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
		}
															#line 2557 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (foundSharedDcId)
															#line 17396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2558 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			int totalRequired = std::max(dbConfig.tLogReplicationFactor, dbConfig.remoteTLogReplicationFactor) + maxSatelliteReplication;
															#line 2560 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->remoteTLogPolicy = Reference<IReplicationPolicy>( new PolicyAcross(totalRequired, "zoneid", Reference<IReplicationPolicy>(new PolicyOne())));
															#line 2562 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("ChangingSimTLogPolicyForSharedRemote") .detail("TotalRequired", totalRequired) .detail("MaxSatelliteReplication", maxSatelliteReplication) .detail("ActualPolicy", dbConfig.getRemoteTLogPolicy()->info()) .detail("SimulatorPolicy", g_simulator->remoteTLogPolicy->info());
															#line 17404 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
		else
		{
															#line 2568 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->remoteTLogPolicy = dbConfig.getRemoteTLogPolicy();
															#line 17410 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 2571 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<InitializeSimConfigActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InitializeSimConfigActorState(); static_cast<InitializeSimConfigActor*>(this)->destroy(); return 0; }
															#line 17414 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<InitializeSimConfigActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InitializeSimConfigActorState();
		static_cast<InitializeSimConfigActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(DatabaseConfiguration && dbConfig,int loopDepth) 
	{
															#line 2529 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->storagePolicy = dbConfig.storagePolicy;
															#line 2530 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->tLogPolicy = dbConfig.tLogPolicy;
															#line 2531 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->tLogWriteAntiQuorum = dbConfig.tLogWriteAntiQuorum;
															#line 2532 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->usableRegions = dbConfig.usableRegions;
															#line 2538 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		bool foundSharedDcId = false;
															#line 2539 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		std::set<Key> dcIds;
															#line 2540 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		int maxSatelliteReplication = 0;
															#line 2541 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for( auto const& r : dbConfig.regions ) {
															#line 2542 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (!dcIds.insert(r.dcId).second)
															#line 17442 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 2543 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				foundSharedDcId = true;
															#line 17446 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 2545 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (!r.satellites.empty() && r.satelliteTLogReplicationFactor > 0 && r.satelliteTLogUsableDcs > 0)
															#line 17450 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 2546 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				for( auto const& s : r.satellites ) {
															#line 2547 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					if (!dcIds.insert(s.dcId).second)
															#line 17456 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
					{
															#line 2548 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
						foundSharedDcId = true;
															#line 17460 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
					}
				}
															#line 2552 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				maxSatelliteReplication = std::max(maxSatelliteReplication, r.satelliteTLogReplicationFactor / r.satelliteTLogUsableDcs);
															#line 17465 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
		}
															#line 2557 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (foundSharedDcId)
															#line 17470 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2558 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			int totalRequired = std::max(dbConfig.tLogReplicationFactor, dbConfig.remoteTLogReplicationFactor) + maxSatelliteReplication;
															#line 2560 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->remoteTLogPolicy = Reference<IReplicationPolicy>( new PolicyAcross(totalRequired, "zoneid", Reference<IReplicationPolicy>(new PolicyOne())));
															#line 2562 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("ChangingSimTLogPolicyForSharedRemote") .detail("TotalRequired", totalRequired) .detail("MaxSatelliteReplication", maxSatelliteReplication) .detail("ActualPolicy", dbConfig.getRemoteTLogPolicy()->info()) .detail("SimulatorPolicy", g_simulator->remoteTLogPolicy->info());
															#line 17478 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
		else
		{
															#line 2568 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->remoteTLogPolicy = dbConfig.getRemoteTLogPolicy();
															#line 17484 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 2571 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<InitializeSimConfigActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InitializeSimConfigActorState(); static_cast<InitializeSimConfigActor*>(this)->destroy(); return 0; }
															#line 17488 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<InitializeSimConfigActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InitializeSimConfigActorState();
		static_cast<InitializeSimConfigActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(DatabaseConfiguration const& dbConfig,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(dbConfig, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(DatabaseConfiguration && dbConfig,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(dbConfig), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<InitializeSimConfigActor*>(this)->actor_wait_state > 0) static_cast<InitializeSimConfigActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeSimConfigActor*>(this)->ActorCallback< InitializeSimConfigActor, 0, DatabaseConfiguration >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeSimConfigActor, 0, DatabaseConfiguration >*,DatabaseConfiguration const& value) 
	{
		fdb_probe_actor_enter("initializeSimConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeSimConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeSimConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< InitializeSimConfigActor, 0, DatabaseConfiguration >*,DatabaseConfiguration && value) 
	{
		fdb_probe_actor_enter("initializeSimConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeSimConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeSimConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< InitializeSimConfigActor, 0, DatabaseConfiguration >*,Error err) 
	{
		fdb_probe_actor_enter("initializeSimConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeSimConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeSimConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<InitializeSimConfigActor*>(this)->actor_wait_state > 0) static_cast<InitializeSimConfigActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeSimConfigActor*>(this)->ActorCallback< InitializeSimConfigActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeSimConfigActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initializeSimConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeSimConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeSimConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< InitializeSimConfigActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initializeSimConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeSimConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeSimConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< InitializeSimConfigActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initializeSimConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeSimConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeSimConfig", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2523 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database db;
															#line 2524 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Transaction tr;
															#line 17662 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via initializeSimConfig()
															#line 2523 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class InitializeSimConfigActor final : public Actor<Void>, public ActorCallback< InitializeSimConfigActor, 0, DatabaseConfiguration >, public ActorCallback< InitializeSimConfigActor, 1, Void >, public FastAllocated<InitializeSimConfigActor>, public InitializeSimConfigActorState<InitializeSimConfigActor> {
															#line 17667 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<InitializeSimConfigActor>::operator new;
	using FastAllocated<InitializeSimConfigActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8262133236554591744UL, 4519705418713817856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< InitializeSimConfigActor, 0, DatabaseConfiguration >;
friend struct ActorCallback< InitializeSimConfigActor, 1, Void >;
															#line 2523 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	InitializeSimConfigActor(Database const& db) 
															#line 17685 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<Void>(),
		   InitializeSimConfigActorState<InitializeSimConfigActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("initializeSimConfig", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5496461681839818496UL, 4488760119134195712UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeSimConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("initializeSimConfig");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("initializeSimConfig", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< InitializeSimConfigActor, 0, DatabaseConfiguration >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< InitializeSimConfigActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2523 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> initializeSimConfig( Database const& db ) {
															#line 2523 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new InitializeSimConfigActor(db));
															#line 17719 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 2577 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

void encryptionAtRestPlaintextMarkerCheck() {
	if (!g_network->isSimulated() || !g_simulator->dataAtRestPlaintextMarker.present()) {
		// Encryption at-rest was not enabled, do nothing
		return;
	}

	namespace fs = std::filesystem;

	printf("EncryptionAtRestPlaintextMarkerCheckStart\n");
	TraceEvent("EncryptionAtRestPlaintextMarkerCheckStart");
	fs::path p("simfdb/");
	fs::recursive_directory_iterator end;
	int scanned = 0;
	bool success = true;
	// Enumerate all files in the "simfdb/" folder and look for "marker" string
	for (fs::recursive_directory_iterator itr(p); itr != end; ++itr) {
		if (fs::is_regular_file(itr->path())) {
			std::ifstream f(itr->path());
			if (f) {
				std::string buf;
				int count = 0;
				while (std::getline(f, buf)) {
					// SOMEDAY: using 'std::boyer_moore_horspool_searcher' would significantly improve search
					// time
					if (!g_network->isSimulated() || !ENABLE_MUTATION_TRACKING_WITH_BLOB_CIPHER) {
						if (buf.find(g_simulator->dataAtRestPlaintextMarker.get()) != std::string::npos) {
							TraceEvent(SevError, "EncryptionAtRestPlaintextMarkerCheckPanic")
							    .detail("Filename", itr->path().string())
							    .detail("LineBuf", buf)
							    .detail("Marker", g_simulator->dataAtRestPlaintextMarker.get());
							success = false;
						}
					}
					count++;
				}
				TraceEvent("EncryptionAtRestPlaintextMarkerCheckScanned")
				    .detail("Filename", itr->path().string())
				    .detail("NumLines", count);
				scanned++;
				if (itr->path().string().find("storage") != std::string::npos) {
					CODE_PROBE(true,
					           "EncryptionAtRestPlaintextMarkerCheckScanned storage file scanned",
					           probe::decoration::rare);
				} else if (itr->path().string().find("logqueue") != std::string::npos) {
					CODE_PROBE(
					    true, "EncryptionAtRestPlaintextMarkerCheckScanned TLog file scanned", probe::decoration::rare);
				} else if (itr->path().string().find("backup") != std::string::npos) {
					CODE_PROBE(true,
					           "EncryptionAtRestPlaintextMarkerCheckScanned KVBackup file scanned",
					           probe::decoration::rare);
				}
			} else {
				TraceEvent(SevError, "FileOpenError").detail("Filename", itr->path().string());
			}
		}
		ASSERT(success);
	}
	printf("EncryptionAtRestPlaintextMarkerCheckEnd NumFiles: %d\n", scanned);
	TraceEvent("EncryptionAtRestPlaintextMarkerCheckEnd").detail("NumFiles", scanned);
}

// Disables connection failures after the given time seconds
															#line 17786 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via disableConnectionFailuresAfter()
															#line 2640 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class DisableConnectionFailuresAfterActor>
															#line 2640 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class DisableConnectionFailuresAfterActorState {
															#line 17793 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 2640 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	DisableConnectionFailuresAfterActorState(double const& seconds,std::string const& context) 
															#line 2640 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 2640 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : seconds(seconds),
															#line 2640 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   context(context)
															#line 17802 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this));

	}
	~DisableConnectionFailuresAfterActorState() 
	{
		fdb_probe_actor_destroy("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2641 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (g_network->isSimulated())
															#line 17817 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 2642 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent(SevWarnAlways, ("ScheduleDisableConnectionFailures_" + context).c_str()) .detail("At", now() + seconds);
															#line 2644 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(seconds);
															#line 2644 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<DisableConnectionFailuresAfterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17825 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DisableConnectionFailuresAfterActor*>(this)->actor_wait_state = 1;
															#line 2644 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DisableConnectionFailuresAfterActor, 0, Void >*>(static_cast<DisableConnectionFailuresAfterActor*>(this)));
															#line 17830 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DisableConnectionFailuresAfterActorState();
		static_cast<DisableConnectionFailuresAfterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2656 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<DisableConnectionFailuresAfterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DisableConnectionFailuresAfterActorState(); static_cast<DisableConnectionFailuresAfterActor*>(this)->destroy(); return 0; }
															#line 17858 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		new (&static_cast<DisableConnectionFailuresAfterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DisableConnectionFailuresAfterActorState();
		static_cast<DisableConnectionFailuresAfterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2645 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		;
															#line 17870 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2645 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		;
															#line 17879 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DisableConnectionFailuresAfterActor*>(this)->actor_wait_state > 0) static_cast<DisableConnectionFailuresAfterActor*>(this)->actor_wait_state = 0;
		static_cast<DisableConnectionFailuresAfterActor*>(this)->ActorCallback< DisableConnectionFailuresAfterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DisableConnectionFailuresAfterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConnectionFailuresAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DisableConnectionFailuresAfterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConnectionFailuresAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DisableConnectionFailuresAfterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConnectionFailuresAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 2646 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		double delaySeconds = disableConnectionFailures(context, ForceDisable::False);
															#line 2647 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (delaySeconds > DISABLE_CONNECTION_FAILURE_MIN_INTERVAL)
															#line 17978 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2648 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(delaySeconds);
															#line 2648 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<DisableConnectionFailuresAfterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17984 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DisableConnectionFailuresAfterActor*>(this)->actor_wait_state = 2;
															#line 2648 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DisableConnectionFailuresAfterActor, 1, Void >*>(static_cast<DisableConnectionFailuresAfterActor*>(this)));
															#line 17989 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DisableConnectionFailuresAfterActor*>(this)->actor_wait_state > 0) static_cast<DisableConnectionFailuresAfterActor*>(this)->actor_wait_state = 0;
		static_cast<DisableConnectionFailuresAfterActor*>(this)->ActorCallback< DisableConnectionFailuresAfterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DisableConnectionFailuresAfterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConnectionFailuresAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DisableConnectionFailuresAfterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConnectionFailuresAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DisableConnectionFailuresAfterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConnectionFailuresAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2640 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double seconds;
															#line 2640 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::string context;
															#line 18109 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
};
// This generated class is to be used only via disableConnectionFailuresAfter()
															#line 2640 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class DisableConnectionFailuresAfterActor final : public Actor<Void>, public ActorCallback< DisableConnectionFailuresAfterActor, 0, Void >, public ActorCallback< DisableConnectionFailuresAfterActor, 1, Void >, public FastAllocated<DisableConnectionFailuresAfterActor>, public DisableConnectionFailuresAfterActorState<DisableConnectionFailuresAfterActor> {
															#line 18114 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
	using FastAllocated<DisableConnectionFailuresAfterActor>::operator new;
	using FastAllocated<DisableConnectionFailuresAfterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1907216124940660224UL, 14200668474477431296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DisableConnectionFailuresAfterActor, 0, Void >;
friend struct ActorCallback< DisableConnectionFailuresAfterActor, 1, Void >;
															#line 2640 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	DisableConnectionFailuresAfterActor(double const& seconds,std::string const& context) 
															#line 18132 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		 : Actor<Void>(),
		   DisableConnectionFailuresAfterActorState<DisableConnectionFailuresAfterActor>(seconds, context),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13243507383148206080UL, 6263835815856420864UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConnectionFailuresAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("disableConnectionFailuresAfter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DisableConnectionFailuresAfterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DisableConnectionFailuresAfterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2640 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> disableConnectionFailuresAfter( double const& seconds, std::string const& context ) {
															#line 2640 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new DisableConnectionFailuresAfterActor(seconds, context));
															#line 18166 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
}

#line 2658 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

/**
 * \brief Test orchestrator: sends test specification to testers in the right order and collects the results.
 *
 * There are multiple actors in this file with similar names (runTest, runTests) and slightly different signatures.
 *
 * This is the actual orchestrator. It reads the test specifications (from tests), prepares the cluster (by running the
 * configure command given in startingConfiguration) and then runs the workload.
 *
 * \param cc The cluster controller interface
 * \param ci Same as cc.clientInterface
 * \param testers The interfaces of the testers that should run the actual workloads
 * \param tests The test specifications to run
 * \param startingConfiguration If non-empty, the orchestrator will attempt to set this configuration before starting
 * the tests.
 * \param locality client locality (it seems this is unused?)
 *
 * \returns A future which will be set after all tests finished.
 */
															#line 18189 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
namespace {
// This generated class is to be used only via runTests()
															#line 2677 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class RunTestsActor>
															#line 2677 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunTestsActorState {
															#line 18196 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
public:
															#line 2677 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunTestsActorState(Reference<AsyncVar<Optional<struct ClusterControllerFullInterface>>> const& cc,Reference<AsyncVar<Optional<struct ClusterInterface>>> const& ci,std::vector<TesterInterface> const& testers,std::vector<TestSpec> const& tests,StringRef const& startingConfiguration,LocalityData const& locality,Optional<TenantName> const& defaultTenant,Standalone<VectorRef<TenantNameRef>> const& tenantsToCreate,bool const& restartingTest) 
															#line 2677 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 2677 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cc(cc),
															#line 2677 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   ci(ci),
															#line 2677 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   testers(testers),
															#line 2677 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   tests(tests),
															#line 2677 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   startingConfiguration(startingConfiguration),
															#line 2677 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   locality(locality),
															#line 2677 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   defaultTenant(defaultTenant),
															#line 2677 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   tenantsToCreate(tenantsToCreate),
															#line 2677 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   restartingTest(restartingTest),
															#line 2686 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   cx(),
															#line 2687 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   dbInfo(new AsyncVar<ServerDBInfo>),
															#line 2688 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   ccMonitor(monitorServerDBInfo(cc, LocalityData(), dbInfo)),
															#line 2690 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   useDB(false),
															#line 2691 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   waitForQuiescenceBegin(false),
															#line 2692 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   waitForQuiescenceEnd(false),
															#line 2693 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   restorePerpetualWiggleSetting(false),
															#line 2694 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   perpetualWiggleEnabled(false),
															#line 2695 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   backupWorkerEnabled(false),
															#line 2696 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   startDelay(0.0),
															#line 2697 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   databasePingDelay(1e9),
															#line 2698 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   simBackupAgents(ISimulator::BackupAgentType::NoBackupAgents),
															#line 2699 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   simDrAgents(ISimulator::BackupAgentType::NoBackupAgents),
															#line 2700 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   enableDD(false),
															#line 2701 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   consistencyScanState()
															#line 18249 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
	{
		fdb_probe_actor_create("runTests", reinterpret_cast<unsigned long>(this));

	}
	~RunTestsActorState() 
	{
		fdb_probe_actor_destroy("runTests", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2705 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_0 = yield();
															#line 2705 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunTestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18266 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunTestsActor*>(this)->actor_wait_state = 1;
															#line 2705 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunTestsActor, 0, Void >*>(static_cast<RunTestsActor*>(this)));
															#line 18271 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunTestsActorState();
		static_cast<RunTestsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2707 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (tests.empty())
															#line 18294 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2708 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			useDB = true;
															#line 18298 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 2709 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(auto iter = tests.begin();iter != tests.end();++iter) {
															#line 2710 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (iter->useDB)
															#line 18304 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 2711 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				useDB = true;
															#line 18308 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 2712 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (iter->waitForQuiescenceBegin)
															#line 18312 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 2713 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				waitForQuiescenceBegin = true;
															#line 18316 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 2714 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (iter->waitForQuiescenceEnd)
															#line 18320 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 2715 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				waitForQuiescenceEnd = true;
															#line 18324 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 2716 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (iter->restorePerpetualWiggleSetting)
															#line 18328 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 2717 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				restorePerpetualWiggleSetting = true;
															#line 18332 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 2718 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			startDelay = std::max(startDelay, iter->startDelay);
															#line 2719 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			databasePingDelay = std::min(databasePingDelay, iter->databasePingDelay);
															#line 2720 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (iter->simBackupAgents != ISimulator::BackupAgentType::NoBackupAgents)
															#line 18340 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 2721 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				simBackupAgents = iter->simBackupAgents;
															#line 18344 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 2723 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (iter->simDrAgents != ISimulator::BackupAgentType::NoBackupAgents)
															#line 18348 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 2724 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				simDrAgents = iter->simDrAgents;
															#line 18352 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 2726 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			enableDD = enableDD || getOption(iter->options[0], "enableDD"_sr, false);
															#line 18356 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 2729 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (g_network->isSimulated())
															#line 18360 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2730 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->backupAgents = simBackupAgents;
															#line 2731 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->drAgents = simDrAgents;
															#line 18366 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 2735 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!useDB)
															#line 18370 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2736 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			databasePingDelay = 0.0;
															#line 18374 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 2738 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (useDB)
															#line 18378 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2739 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			cx = openDBOnServer(dbInfo);
															#line 2740 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			cx->defaultTenant = defaultTenant;
															#line 18384 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 2743 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		consistencyScanState.enabled = g_network->isSimulated() && deterministicRandom()->coinflip();
															#line 2744 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		consistencyScanState.waitForComplete = consistencyScanState.enabled && waitForQuiescenceEnd && deterministicRandom()->coinflip();
															#line 2746 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		consistencyScanState.enableAfter = consistencyScanState.waitForComplete && deterministicRandom()->random01() < 0.1;
															#line 2748 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		disableConnectionFailures("Tester");
															#line 2751 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("startingConfiguration:%s start\n", startingConfiguration.toString().c_str());
															#line 2752 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		fmt::print("useDB: {}\n", useDB);
															#line 2753 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printSimulatedTopology();
															#line 2754 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (useDB && startingConfiguration != StringRef())
															#line 18402 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
			try {
															#line 2756 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_1 = timeoutError(changeConfiguration(cx, testers, startingConfiguration), 2000.0);
															#line 2756 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunTestsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 18409 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<RunTestsActor*>(this)->actor_wait_state = 2;
															#line 2756 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunTestsActor, 1, Void >*>(static_cast<RunTestsActor*>(this)));
															#line 18414 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2707 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (tests.empty())
															#line 18434 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2708 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			useDB = true;
															#line 18438 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 2709 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(auto iter = tests.begin();iter != tests.end();++iter) {
															#line 2710 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (iter->useDB)
															#line 18444 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 2711 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				useDB = true;
															#line 18448 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 2712 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (iter->waitForQuiescenceBegin)
															#line 18452 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 2713 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				waitForQuiescenceBegin = true;
															#line 18456 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 2714 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (iter->waitForQuiescenceEnd)
															#line 18460 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 2715 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				waitForQuiescenceEnd = true;
															#line 18464 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 2716 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (iter->restorePerpetualWiggleSetting)
															#line 18468 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 2717 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				restorePerpetualWiggleSetting = true;
															#line 18472 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 2718 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			startDelay = std::max(startDelay, iter->startDelay);
															#line 2719 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			databasePingDelay = std::min(databasePingDelay, iter->databasePingDelay);
															#line 2720 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (iter->simBackupAgents != ISimulator::BackupAgentType::NoBackupAgents)
															#line 18480 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 2721 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				simBackupAgents = iter->simBackupAgents;
															#line 18484 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 2723 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (iter->simDrAgents != ISimulator::BackupAgentType::NoBackupAgents)
															#line 18488 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 2724 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				simDrAgents = iter->simDrAgents;
															#line 18492 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 2726 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			enableDD = enableDD || getOption(iter->options[0], "enableDD"_sr, false);
															#line 18496 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 2729 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (g_network->isSimulated())
															#line 18500 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2730 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->backupAgents = simBackupAgents;
															#line 2731 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->drAgents = simDrAgents;
															#line 18506 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 2735 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!useDB)
															#line 18510 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2736 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			databasePingDelay = 0.0;
															#line 18514 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 2738 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (useDB)
															#line 18518 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2739 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			cx = openDBOnServer(dbInfo);
															#line 2740 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			cx->defaultTenant = defaultTenant;
															#line 18524 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 2743 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		consistencyScanState.enabled = g_network->isSimulated() && deterministicRandom()->coinflip();
															#line 2744 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		consistencyScanState.waitForComplete = consistencyScanState.enabled && waitForQuiescenceEnd && deterministicRandom()->coinflip();
															#line 2746 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		consistencyScanState.enableAfter = consistencyScanState.waitForComplete && deterministicRandom()->random01() < 0.1;
															#line 2748 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		disableConnectionFailures("Tester");
															#line 2751 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("startingConfiguration:%s start\n", startingConfiguration.toString().c_str());
															#line 2752 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		fmt::print("useDB: {}\n", useDB);
															#line 2753 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printSimulatedTopology();
															#line 2754 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (useDB && startingConfiguration != StringRef())
															#line 18542 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
			try {
															#line 2756 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_1 = timeoutError(changeConfiguration(cx, testers, startingConfiguration), 2000.0);
															#line 2756 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunTestsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 18549 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<RunTestsActor*>(this)->actor_wait_state = 2;
															#line 2756 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunTestsActor, 1, Void >*>(static_cast<RunTestsActor*>(this)));
															#line 18554 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunTestsActor*>(this)->actor_wait_state > 0) static_cast<RunTestsActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestsActor*>(this)->ActorCallback< RunTestsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunTestsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunTestsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2780 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (useDB && g_network->isSimulated())
															#line 18649 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2781 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<DatabaseConfiguration> __when_expr_3 = getDatabaseConfiguration(cx);
															#line 2781 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunTestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18655 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2when1(__when_expr_3.get(), loopDepth); };
			static_cast<RunTestsActor*>(this)->actor_wait_state = 4;
															#line 2781 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunTestsActor, 3, DatabaseConfiguration >*>(static_cast<RunTestsActor*>(this)));
															#line 18660 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont16(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14(int loopDepth) 
	{
															#line 2763 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		std::string_view confView(reinterpret_cast<const char*>(startingConfiguration.begin()), startingConfiguration.size());
															#line 2765 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (restorePerpetualWiggleSetting)
															#line 18676 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2766 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			const std::string setting = "perpetual_storage_wiggle:=";
															#line 2767 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			auto pos = confView.find(setting);
															#line 2768 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (pos != confView.npos && confView.at(pos + setting.size()) == '1')
															#line 18684 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 2769 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				perpetualWiggleEnabled = true;
															#line 18688 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
		}
															#line 2772 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		const std::string bwSetting = "backup_worker_enabled:=";
															#line 2773 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auto pos = confView.find(bwSetting);
															#line 2774 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (pos != confView.npos && confView.at(pos + bwSetting.size()) == '1')
															#line 18697 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2775 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			backupWorkerEnabled = true;
															#line 18701 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2761 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevError, "TestFailure").error(e).detail("Reason", "Unable to set starting configuration");
															#line 18712 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = a_body1cont14(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont15(Void const& _,int loopDepth) 
	{
															#line 2757 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (g_network->isSimulated() && enableDD)
															#line 18727 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2758 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_2 = success(setDDMode(cx, 1));
															#line 2758 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunTestsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 18733 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont15when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunTestsActor*>(this)->actor_wait_state = 3;
															#line 2758 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunTestsActor, 2, Void >*>(static_cast<RunTestsActor*>(this)));
															#line 18738 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont15cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont15(Void && _,int loopDepth) 
	{
															#line 2757 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (g_network->isSimulated() && enableDD)
															#line 18752 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2758 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_2 = success(setDDMode(cx, 1));
															#line 2758 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunTestsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 18758 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont15when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunTestsActor*>(this)->actor_wait_state = 3;
															#line 2758 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunTestsActor, 2, Void >*>(static_cast<RunTestsActor*>(this)));
															#line 18763 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont15cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunTestsActor*>(this)->actor_wait_state > 0) static_cast<RunTestsActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestsActor*>(this)->ActorCallback< RunTestsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunTestsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunTestsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont15cont1(int loopDepth) 
	{
		loopDepth = a_body1cont15cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont15when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont15when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunTestsActor*>(this)->actor_wait_state > 0) static_cast<RunTestsActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestsActor*>(this)->ActorCallback< RunTestsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont15when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunTestsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont15when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunTestsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont15cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont14(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont16(int loopDepth) 
	{
															#line 2837 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (useDB)
															#line 18958 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2838 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			std::vector<Future<Void>> tenantFutures;
															#line 2839 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for( auto tenant : tenantsToCreate ) {
															#line 2840 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TenantMapEntry entry;
															#line 2841 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (deterministicRandom()->coinflip())
															#line 18968 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				{
															#line 2842 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					entry.tenantGroup = "TestTenantGroup"_sr;
															#line 18972 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
				}
															#line 2844 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent("CreatingTenant").detail("Tenant", tenant).detail("TenantGroup", entry.tenantGroup);
															#line 2845 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				tenantFutures.push_back(success(TenantAPI::createTenant(cx.getReference(), tenant, entry)));
															#line 18978 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 2848 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_5 = waitForAll(tenantFutures);
															#line 2848 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunTestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18984 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont16when1(__when_expr_5.get(), loopDepth); };
			static_cast<RunTestsActor*>(this)->actor_wait_state = 6;
															#line 2848 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunTestsActor, 5, Void >*>(static_cast<RunTestsActor*>(this)));
															#line 18989 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont16cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont17(DatabaseConfiguration const& configuration,int loopDepth) 
	{
															#line 2783 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->storagePolicy = configuration.storagePolicy;
															#line 2784 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->tLogPolicy = configuration.tLogPolicy;
															#line 2785 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->tLogWriteAntiQuorum = configuration.tLogWriteAntiQuorum;
															#line 2786 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->remoteTLogPolicy = configuration.remoteTLogPolicy;
															#line 2787 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->usableRegions = configuration.usableRegions;
															#line 2788 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (configuration.regions.size() > 0)
															#line 19013 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2789 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->primaryDcId = configuration.regions[0].dcId;
															#line 2790 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->hasSatelliteReplication = configuration.regions[0].satelliteTLogReplicationFactor > 0;
															#line 2791 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (configuration.regions[0].satelliteTLogUsableDcsFallback > 0)
															#line 19021 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			{
															#line 2792 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->satelliteTLogPolicyFallback = configuration.regions[0].satelliteTLogPolicyFallback;
															#line 2793 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->satelliteTLogWriteAntiQuorumFallback = configuration.regions[0].satelliteTLogWriteAntiQuorumFallback;
															#line 19027 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
			else
			{
															#line 2796 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->satelliteTLogPolicyFallback = configuration.regions[0].satelliteTLogPolicy;
															#line 2797 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->satelliteTLogWriteAntiQuorumFallback = configuration.regions[0].satelliteTLogWriteAntiQuorum;
															#line 19035 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
															#line 2800 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->satelliteTLogPolicy = configuration.regions[0].satelliteTLogPolicy;
															#line 2801 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->satelliteTLogWriteAntiQuorum = configuration.regions[0].satelliteTLogWriteAntiQuorum;
															#line 2803 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for( auto s : configuration.regions[0].satellites ) {
															#line 2804 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->primarySatelliteDcIds.push_back(s.dcId);
															#line 19045 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
		}
		else
		{
															#line 2807 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->hasSatelliteReplication = false;
															#line 2808 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->satelliteTLogWriteAntiQuorum = 0;
															#line 19054 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 2811 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (configuration.regions.size() == 2)
															#line 19058 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2812 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->remoteDcId = configuration.regions[1].dcId;
															#line 2813 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			ASSERT((!configuration.regions[0].satelliteTLogPolicy && !configuration.regions[1].satelliteTLogPolicy) || configuration.regions[0].satelliteTLogPolicy->info() == configuration.regions[1].satelliteTLogPolicy->info());
															#line 2817 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for( auto s : configuration.regions[1].satellites ) {
															#line 2818 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->remoteSatelliteDcIds.push_back(s.dcId);
															#line 19068 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			}
		}
															#line 2822 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (restartingTest || g_simulator->usableRegions < 2 || !g_simulator->hasSatelliteReplication)
															#line 19073 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2823 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->allowLogSetKills = false;
															#line 19077 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		}
															#line 2826 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ASSERT(g_simulator->storagePolicy && g_simulator->tLogPolicy);
															#line 2827 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ASSERT(!g_simulator->hasSatelliteReplication || g_simulator->satelliteTLogPolicy);
															#line 2832 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (deterministicRandom()->random01() < 0.25)
															#line 19085 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
		{
															#line 2833 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_4 = customShardConfigWorkload(cx);
															#line 2833 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunTestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19091 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont17when1(__when_expr_4.get(), loopDepth); };
			static_cast<RunTestsActor*>(this)->actor_wait_state = 5;
															#line 2833 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_4.addCallb