#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
/*
 * TestTLogServer.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/TestTLogServer.actor.h"

#include <filesystem>
#include <vector>

#include "fdbrpc/Locality.h"
#include "fdbrpc/ReplicationPolicy.h"
#include "fdbserver/TLogInterface.h"
#include "fdbserver/ServerDBInfo.actor.h"
#include "fdbserver/IDiskQueue.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbserver/LogSystem.h"
#include "fdbserver/Knobs.h"
#include "flow/IRandom.h"
#include "flow/DebugTrace.h"

#include "flow/actorcompiler.h" // must be last include

namespace {

OldTLogConf buildOldTLogConf(const TLogTestContext& oldCtx, int numLogServers, int8_t primaryLocality) {
	OldTLogConf oldTLogConf;
	oldTLogConf.tLogs = oldCtx.dbInfo.logSystemConfig.tLogs;
	for (int i = 0; i < numLogServers && i < oldTLogConf.tLogs.size(); ++i) {
		oldTLogConf.tLogs[i].locality = primaryLocality;
		oldTLogConf.tLogs[i].isLocal = true;
	}
	oldTLogConf.epochBegin = oldCtx.initVersion;
	oldTLogConf.epochEnd = oldCtx.numCommits;
	oldTLogConf.logRouterTags = 0;
	oldTLogConf.recoverAt = oldCtx.initVersion;
	oldTLogConf.epoch = oldCtx.epoch;
	return oldTLogConf;
}

std::string makeDiskQueueBasename(const TLogTestContext& ctx, UID tLogId) {
	return ctx.diskQueueBasename + "." + tLogId.toString() + "." + std::to_string(ctx.epoch) + ".";
}

std::string makeKVStoreBasename(const TestTLogOptions& options, const TLogTestContext& ctx, UID tLogId) {
	return options.kvStoreFilename + "." + tLogId.toString() + "." + std::to_string(ctx.epoch) + ".";
}

InitializeTLogRequest buildInitializeRequest(const TLogTestContext& ctx) {
	InitializeTLogRequest req;
	std::vector<Tag> tags;
	tags.reserve(ctx.numTags);
	for (uint32_t tagID = 0; tagID < ctx.numTags; tagID++) {
		tags.emplace_back(ctx.tagLocality, tagID);
	}
	req.epoch = 1;
	req.allTags = tags;
	req.isPrimary = true;
	req.locality = ctx.primaryLocality;
	req.recoveryTransactionVersion = ctx.initVersion;
	return req;
}

struct TempStorageFiles {
	std::string queueBase;
	std::string queueExt;
	std::string kvBase;
	std::string kvExt;
	bool active{ false };

	TempStorageFiles() = default;
	TempStorageFiles(std::string queueBase, std::string queueExt, std::string kvBase, std::string kvExt)
	  : queueBase(std::move(queueBase)), queueExt(std::move(queueExt)), kvBase(std::move(kvBase)),
	    kvExt(std::move(kvExt)), active(true) {}

	~TempStorageFiles() { cleanup(); }

	void cleanup() {
		if (!active)
			return;
		if (!queueBase.empty()) {
			deleteFile(queueBase + "0." + queueExt);
			deleteFile(queueBase + "1." + queueExt);
		}
		if (!kvBase.empty()) {
			deleteFile(kvBase + "0." + kvExt);
			deleteFile(kvBase + "1." + kvExt);
		}
		active = false;
	}
};

struct StorageResources {
	std::string diskQueueFilename;
	std::string kvStoreFilename;
	TempStorageFiles tempFiles;

	StorageResources() = default;
	StorageResources(std::string dq, std::string kv, TempStorageFiles files)
	  : diskQueueFilename(std::move(dq)), kvStoreFilename(std::move(kv)), tempFiles(std::move(files)) {}
};

StorageResources setupPersistentStorage(Reference<TLogContext> tLogContext,
                                        const TLogTestContext& testContext,
                                        const TestTLogOptions& options) {
	std::string diskQueueFilename = options.dataFolder + "/" + makeDiskQueueBasename(testContext, tLogContext->tLogID);
	tLogContext->persistentQueue =
	    openDiskQueue(diskQueueFilename, options.diskQueueExtension, tLogContext->tLogID, DiskQueueVersion::V2);

	std::string kvStoreFilename =
	    options.dataFolder + "/" + makeKVStoreBasename(options, testContext, tLogContext->tLogID);
	tLogContext->persistentData = keyValueStoreMemory(kvStoreFilename,
	                                                  tLogContext->tLogID,
	                                                  options.kvMemoryLimit,
	                                                  options.kvStoreExtension,
	                                                  KeyValueStoreType::MEMORY_RADIXTREE);

	TempStorageFiles tempFiles(
	    diskQueueFilename, options.diskQueueExtension, kvStoreFilename, options.kvStoreExtension);
	return StorageResources(diskQueueFilename, kvStoreFilename, std::move(tempFiles));
}

Reference<TLogTestContext> initTLogTestContext(TestTLogOptions tLogOptions,
                                               Optional<Reference<TLogTestContext>> oldTLogTestContext) {
	Reference<TLogTestContext> context(new TLogTestContext(tLogOptions));
	context->logID = deterministicRandom()->randomUniqueID();
	context->workerID = deterministicRandom()->randomUniqueID();
	context->diskQueueBasename = tLogOptions.diskQueueBasename;
	context->numCommits = tLogOptions.numCommits;
	context->numTags = tLogOptions.numTags;
	context->numLogServers = tLogOptions.numLogServers;
	context->dcID = "test"_sr;
	context->tagLocality = context->primaryLocality;
	context->dbInfo = ServerDBInfo();
	if (oldTLogTestContext.present()) {
		const TLogTestContext& oldCtx = *oldTLogTestContext.get();
		context->dbInfo.logSystemConfig.oldTLogs.push_back(
		    buildOldTLogConf(oldCtx, context->numLogServers, oldCtx.primaryLocality));
		context->tagLocality = oldCtx.primaryLocality;
		context->epoch = oldCtx.epoch + 1;
		context->commitHistory = oldCtx.commitHistory;
	}
	context->dbInfo.logSystemConfig.logSystemType = LogSystemType::tagPartitioned;
	context->dbInfo.logSystemConfig.recruitmentID = deterministicRandom()->randomUniqueID();
	context->initVersion = tLogOptions.initVersion;
	context->recover = tLogOptions.recover;
	context->dbInfoRef = makeReference<AsyncVar<ServerDBInfo>>(context->dbInfo);

	return context;
}

} // namespace

// Create and start a tLog. If optional parmeters are set, the tLog is a new generation of "tLogID"
// as described by initReq. Otherwise, it is a newborn generation 0 tLog.
															#line 173 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
namespace {
// This generated class is to be used only via getTLogCreateActor()
															#line 171 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
template <class GetTLogCreateActorActor>
															#line 171 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
class GetTLogCreateActorActorState {
															#line 180 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
public:
															#line 171 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	GetTLogCreateActorActorState(Reference<TLogTestContext> const& pTLogTestContext,TestTLogOptions const& tLogOptions,uint16_t const& processID,InitializeTLogRequest* const& initReq = nullptr,UID const& tLogID = UID()) 
															#line 171 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
															#line 171 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		 : pTLogTestContext(pTLogTestContext),
															#line 171 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		   tLogOptions(tLogOptions),
															#line 171 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		   processID(processID),
															#line 171 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		   initReq(initReq),
															#line 171 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		   tLogID(tLogID),
															#line 178 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		   pTLogContext(pTLogTestContext->pTLogContextList[processID])
															#line 197 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
	{
		fdb_probe_actor_create("getTLogCreateActor", reinterpret_cast<unsigned long>(this));

	}
	~GetTLogCreateActorActorState() 
	{
		fdb_probe_actor_destroy("getTLogCreateActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 179 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			pTLogContext->tagProcessID = processID;
															#line 181 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			pTLogContext->tLogID = tLogID != UID(0, 0) ? tLogID : deterministicRandom()->randomUniqueID();
															#line 183 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			TraceEvent("TestTLogServerEnterGetTLogCreateActor", pTLogContext->tLogID).detail("Epoch", pTLogTestContext->epoch);
															#line 185 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			std::filesystem::create_directory(tLogOptions.dataFolder);
															#line 188 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			storage = setupPersistentStorage(pTLogContext, *pTLogTestContext, tLogOptions);
															#line 191 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			Standalone<StringRef> machineID = "machine"_sr;
															#line 192 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			LocalityData localities( Optional<Standalone<StringRef>>(), pTLogTestContext->zoneID, machineID, pTLogTestContext->dcID);
															#line 194 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			localities.set(StringRef("datacenter"_sr), pTLogTestContext->dcID);
															#line 196 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			Reference<AsyncVar<bool>> isDegraded = FlowTransport::transport().getDegraded();
															#line 197 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			Reference<AsyncVar<UID>> activeSharedTLog(new AsyncVar<UID>(pTLogContext->tLogID));
															#line 198 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			Reference<AsyncVar<bool>> enablePrimaryTxnSystemHealthCheck(new AsyncVar<bool>(false));
															#line 199 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			promiseStream = PromiseStream<InitializeTLogRequest>();
															#line 200 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			Promise<Void> oldLog;
															#line 201 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			Promise<Void> recovery;
															#line 204 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			tl = ::tLog(pTLogContext->persistentData, pTLogContext->persistentQueue, pTLogTestContext->dbInfoRef, localities, promiseStream, pTLogContext->tLogID, pTLogTestContext->workerID, false, oldLog, recovery, pTLogTestContext->diskQueueBasename, isDegraded, activeSharedTLog, enablePrimaryTxnSystemHealthCheck);
															#line 219 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			initTLogReq = initReq != nullptr ? *initReq : buildInitializeRequest(*pTLogTestContext);
															#line 221 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			StrictFuture<TLogInterface> __when_expr_0 = promiseStream.getReply(initTLogReq);
															#line 221 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			if (static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 246 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state = 1;
															#line 221 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTLogCreateActorActor, 0, TLogInterface >*>(static_cast<GetTLogCreateActorActor*>(this)));
															#line 251 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTLogCreateActorActorState();
		static_cast<GetTLogCreateActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(TLogInterface const& interface,int loopDepth) 
	{
															#line 222 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogContext->TestTLogInterface = interface;
															#line 223 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogContext->init = promiseStream;
															#line 226 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogContext->TLogCreated.send(true);
															#line 228 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerInitializedTLog", pTLogContext->tLogID);
															#line 232 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tl;
															#line 231 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 284 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 233 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<bool> __when_expr_2 = pTLogContext->TestTLogServerCompleted.getFuture();
															#line 288 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
		static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state = 2;
															#line 232 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetTLogCreateActorActor, 1, Void >*>(static_cast<GetTLogCreateActorActor*>(this)));
															#line 233 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetTLogCreateActorActor, 2, bool >*>(static_cast<GetTLogCreateActorActor*>(this)));
															#line 295 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(TLogInterface && interface,int loopDepth) 
	{
															#line 222 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogContext->TestTLogInterface = interface;
															#line 223 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogContext->init = promiseStream;
															#line 226 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogContext->TLogCreated.send(true);
															#line 228 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerInitializedTLog", pTLogContext->tLogID);
															#line 232 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tl;
															#line 231 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 314 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 233 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<bool> __when_expr_2 = pTLogContext->TestTLogServerCompleted.getFuture();
															#line 318 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
		static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state = 2;
															#line 232 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetTLogCreateActorActor, 1, Void >*>(static_cast<GetTLogCreateActorActor*>(this)));
															#line 233 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetTLogCreateActorActor, 2, bool >*>(static_cast<GetTLogCreateActorActor*>(this)));
															#line 325 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(TLogInterface const& interface,int loopDepth) 
	{
		loopDepth = a_body1cont1(interface, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TLogInterface && interface,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(interface), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state > 0) static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetTLogCreateActorActor*>(this)->ActorCallback< GetTLogCreateActorActor, 0, TLogInterface >::remove();

	}
	void a_callback_fire(ActorCallback< GetTLogCreateActorActor, 0, TLogInterface >*,TLogInterface const& value) 
	{
		fdb_probe_actor_enter("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogCreateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTLogCreateActorActor, 0, TLogInterface >*,TLogInterface && value) 
	{
		fdb_probe_actor_enter("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogCreateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTLogCreateActorActor, 0, TLogInterface >*,Error err) 
	{
		fdb_probe_actor_enter("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogCreateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 238 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(1.0);
															#line 238 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 411 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state = 3;
															#line 238 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetTLogCreateActorActor, 3, Void >*>(static_cast<GetTLogCreateActorActor*>(this)));
															#line 416 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(bool const& testCompleted,int loopDepth) 
	{
															#line 234 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_EQ(testCompleted, true);
															#line 437 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(bool && testCompleted,int loopDepth) 
	{
															#line 234 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_EQ(testCompleted, true);
															#line 446 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state > 0) static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetTLogCreateActorActor*>(this)->ActorCallback< GetTLogCreateActorActor, 1, Void >::remove();
		static_cast<GetTLogCreateActorActor*>(this)->ActorCallback< GetTLogCreateActorActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< GetTLogCreateActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogCreateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetTLogCreateActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogCreateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetTLogCreateActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogCreateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetTLogCreateActorActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogCreateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetTLogCreateActorActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogCreateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetTLogCreateActorActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogCreateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 240 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		storage.tempFiles.cleanup();
															#line 242 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!static_cast<GetTLogCreateActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTLogCreateActorActorState(); static_cast<GetTLogCreateActorActor*>(this)->destroy(); return 0; }
															#line 578 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		new (&static_cast<GetTLogCreateActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetTLogCreateActorActorState();
		static_cast<GetTLogCreateActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 240 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		storage.tempFiles.cleanup();
															#line 242 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!static_cast<GetTLogCreateActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTLogCreateActorActorState(); static_cast<GetTLogCreateActorActor*>(this)->destroy(); return 0; }
															#line 592 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		new (&static_cast<GetTLogCreateActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetTLogCreateActorActorState();
		static_cast<GetTLogCreateActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state > 0) static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetTLogCreateActorActor*>(this)->ActorCallback< GetTLogCreateActorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetTLogCreateActorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogCreateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetTLogCreateActorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogCreateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetTLogCreateActorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogCreateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 171 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Reference<TLogTestContext> pTLogTestContext;
															#line 171 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	TestTLogOptions tLogOptions;
															#line 171 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	uint16_t processID;
															#line 171 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	InitializeTLogRequest* initReq;
															#line 171 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	UID tLogID;
															#line 178 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Reference<TLogContext> pTLogContext;
															#line 188 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	StorageResources storage;
															#line 199 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	PromiseStream<InitializeTLogRequest> promiseStream;
															#line 204 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Future<Void> tl;
															#line 219 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	InitializeTLogRequest initTLogReq;
															#line 695 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
};
// This generated class is to be used only via getTLogCreateActor()
															#line 171 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
class GetTLogCreateActorActor final : public Actor<Void>, public ActorCallback< GetTLogCreateActorActor, 0, TLogInterface >, public ActorCallback< GetTLogCreateActorActor, 1, Void >, public ActorCallback< GetTLogCreateActorActor, 2, bool >, public ActorCallback< GetTLogCreateActorActor, 3, Void >, public FastAllocated<GetTLogCreateActorActor>, public GetTLogCreateActorActorState<GetTLogCreateActorActor> {
															#line 700 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
public:
	using FastAllocated<GetTLogCreateActorActor>::operator new;
	using FastAllocated<GetTLogCreateActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14590432202443663360UL, 5597068420340152576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTLogCreateActorActor, 0, TLogInterface >;
friend struct ActorCallback< GetTLogCreateActorActor, 1, Void >;
friend struct ActorCallback< GetTLogCreateActorActor, 2, bool >;
friend struct ActorCallback< GetTLogCreateActorActor, 3, Void >;
															#line 171 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	GetTLogCreateActorActor(Reference<TLogTestContext> const& pTLogTestContext,TestTLogOptions const& tLogOptions,uint16_t const& processID,InitializeTLogRequest* const& initReq = nullptr,UID const& tLogID = UID()) 
															#line 720 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		 : Actor<Void>(),
		   GetTLogCreateActorActorState<GetTLogCreateActorActor>(pTLogTestContext, tLogOptions, processID, initReq, tLogID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTLogCreateActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3521649769377054720UL, 8142649606987485952UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogCreateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTLogCreateActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTLogCreateActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTLogCreateActorActor, 0, TLogInterface >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetTLogCreateActorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetTLogCreateActorActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 171 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
[[nodiscard]] Future<Void> getTLogCreateActor( Reference<TLogTestContext> const& pTLogTestContext, TestTLogOptions const& tLogOptions, uint16_t const& processID, InitializeTLogRequest* const& initReq = nullptr, UID const& tLogID = UID() ) {
															#line 171 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	return Future<Void>(new GetTLogCreateActorActor(pTLogTestContext, tLogOptions, processID, initReq, tLogID));
															#line 755 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
}

#line 244 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"

															#line 760 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
// This generated class is to be used only via sendPushMessages()
															#line 245 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
template <class TLogTestContext_SendPushMessagesActor>
															#line 245 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
class TLogTestContext_SendPushMessagesActorState {
															#line 766 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
public:
															#line 245 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	TLogTestContext_SendPushMessagesActorState(TLogTestContext* const& pTLogTestContext) 
															#line 245 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
															#line 245 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		 : pTLogTestContext(pTLogTestContext)
															#line 773 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
	{
		fdb_probe_actor_create("sendPushMessages", reinterpret_cast<unsigned long>(this));

	}
	~TLogTestContext_SendPushMessagesActorState() 
	{
		fdb_probe_actor_destroy("sendPushMessages", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 247 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			TraceEvent("TestTLogServerEnterPush", pTLogTestContext->workerID);
															#line 249 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			logID = 0;
															#line 250 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			;
															#line 792 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TLogTestContext_SendPushMessagesActorState();
		static_cast<TLogTestContext_SendPushMessagesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 256 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		i = 0;
															#line 257 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		prev = pTLogTestContext->initVersion - 1;
															#line 258 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		next = pTLogTestContext->initVersion;
															#line 260 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		;
															#line 821 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 250 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!(logID < pTLogTestContext->numLogServers))
															#line 837 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 251 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogContext = pTLogTestContext->pTLogContextList[logID];
															#line 252 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<bool> __when_expr_0 = pTLogContext->TLogStarted.getFuture();
															#line 252 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (static_cast<TLogTestContext_SendPushMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 847 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TLogTestContext_SendPushMessagesActor*>(this)->actor_wait_state = 1;
															#line 252 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TLogTestContext_SendPushMessagesActor, 0, bool >*>(static_cast<TLogTestContext_SendPushMessagesActor*>(this)));
															#line 852 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool const& tLogReady,int loopDepth) 
	{
															#line 253 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_EQ(tLogReady, true);
															#line 250 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		logID++;
															#line 876 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool && tLogReady,int loopDepth) 
	{
															#line 253 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_EQ(tLogReady, true);
															#line 250 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		logID++;
															#line 887 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& tLogReady,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(tLogReady, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && tLogReady,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(tLogReady), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TLogTestContext_SendPushMessagesActor*>(this)->actor_wait_state > 0) static_cast<TLogTestContext_SendPushMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<TLogTestContext_SendPushMessagesActor*>(this)->ActorCallback< TLogTestContext_SendPushMessagesActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< TLogTestContext_SendPushMessagesActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("sendPushMessages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_SendPushMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendPushMessages", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TLogTestContext_SendPushMessagesActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("sendPushMessages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_SendPushMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendPushMessages", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TLogTestContext_SendPushMessagesActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("sendPushMessages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_SendPushMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendPushMessages", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 303 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerExitPush", pTLogTestContext->workerID) .detail("NumVersions", pTLogTestContext->tLogOptions.versions.size());
															#line 306 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!static_cast<TLogTestContext_SendPushMessagesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogTestContext_SendPushMessagesActorState(); static_cast<TLogTestContext_SendPushMessagesActor*>(this)->destroy(); return 0; }
															#line 973 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		new (&static_cast<TLogTestContext_SendPushMessagesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TLogTestContext_SendPushMessagesActorState();
		static_cast<TLogTestContext_SendPushMessagesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 260 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!(i < pTLogTestContext->numCommits))
															#line 992 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 261 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		Standalone<StringRef> key = StringRef(format("key %d", i));
															#line 262 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		Standalone<StringRef> val = StringRef(format("value %d", i));
															#line 263 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		MutationRef m(MutationRef::Type::SetValue, key, val);
															#line 266 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		LogPushData toCommit(pTLogTestContext->ls, pTLogTestContext->numLogServers);
															#line 268 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		toCommit.addTransactionInfo(SpanContext());
															#line 270 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		std::unordered_map<uint16_t, Version> tpcvMap;
															#line 272 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		uint32_t replicaCount = pTLogTestContext->tLogOptions.replicaCount;
															#line 273 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		uint32_t startLogServer = 0;
															#line 274 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		uint32_t teamSize = pTLogTestContext->numLogServers / replicaCount;
															#line 275 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		for(uint32_t tagID = 0;tagID < pTLogTestContext->numTags;tagID++, startLogServer++) {
															#line 276 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			for(uint32_t logServer = startLogServer;logServer < pTLogTestContext->numLogServers;logServer += teamSize) {
															#line 282 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				Tag tag(pTLogTestContext->tagLocality, tagID);
															#line 283 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				std::vector<Tag> tags = { tag };
															#line 284 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				toCommit.addTags(tags);
															#line 285 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				toCommit.writeTypedMessage(m, false, true);
															#line 286 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				tpcvMap[logServer] = prev;
															#line 287 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				pTLogTestContext->commitHistory[std::tuple(tagID, logServer)].push_back(next);
															#line 288 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				TraceEvent("AddTags").detail("C", i).detail("T", tag).detail("L", logServer).detail("N", next);
															#line 1032 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			}
		}
															#line 291 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (toCommit.getMutationCount())
															#line 1037 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		{
															#line 292 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			const auto versionSet = ILogSystem::PushVersionSet{ prev, next, prev, prev };
															#line 293 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			Future<Version> loggingComplete = pTLogTestContext->ls->push(versionSet, toCommit, SpanContext(), UID(), tpcvMap);
															#line 295 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			StrictFuture<Version> __when_expr_1 = loggingComplete;
															#line 295 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			if (static_cast<TLogTestContext_SendPushMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1047 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TLogTestContext_SendPushMessagesActor*>(this)->actor_wait_state = 2;
															#line 295 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TLogTestContext_SendPushMessagesActor, 1, Version >*>(static_cast<TLogTestContext_SendPushMessagesActor*>(this)));
															#line 1052 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 298 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		prev = next;
															#line 299 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogTestContext->tLogOptions.versions.push_back(next);
															#line 300 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		next += SERVER_KNOBS->VERSIONS_PER_SECOND + deterministicRandom()->randomInt(0, 20);
															#line 260 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		i++;
															#line 1085 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Version const& ver,int loopDepth) 
	{
															#line 296 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_LE(ver, next);
															#line 1094 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Version && ver,int loopDepth) 
	{
															#line 296 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_LE(ver, next);
															#line 1103 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Version const& ver,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(ver, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Version && ver,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(std::move(ver), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TLogTestContext_SendPushMessagesActor*>(this)->actor_wait_state > 0) static_cast<TLogTestContext_SendPushMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<TLogTestContext_SendPushMessagesActor*>(this)->ActorCallback< TLogTestContext_SendPushMessagesActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< TLogTestContext_SendPushMessagesActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("sendPushMessages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_SendPushMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendPushMessages", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TLogTestContext_SendPushMessagesActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("sendPushMessages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_SendPushMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendPushMessages", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TLogTestContext_SendPushMessagesActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("sendPushMessages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_SendPushMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendPushMessages", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 245 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	TLogTestContext* pTLogTestContext;
															#line 249 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	uint16_t logID;
															#line 251 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Reference<TLogContext> pTLogContext;
															#line 256 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	uint32_t i;
															#line 257 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Version prev;
															#line 258 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Version next;
															#line 1195 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
};
// This generated class is to be used only via sendPushMessages()
															#line 245 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
class TLogTestContext_SendPushMessagesActor final : public Actor<Void>, public ActorCallback< TLogTestContext_SendPushMessagesActor, 0, bool >, public ActorCallback< TLogTestContext_SendPushMessagesActor, 1, Version >, public FastAllocated<TLogTestContext_SendPushMessagesActor>, public TLogTestContext_SendPushMessagesActorState<TLogTestContext_SendPushMessagesActor> {
															#line 1200 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
public:
	using FastAllocated<TLogTestContext_SendPushMessagesActor>::operator new;
	using FastAllocated<TLogTestContext_SendPushMessagesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17949376594412548608UL, 9737344831269087488UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TLogTestContext_SendPushMessagesActor, 0, bool >;
friend struct ActorCallback< TLogTestContext_SendPushMessagesActor, 1, Version >;
															#line 245 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	TLogTestContext_SendPushMessagesActor(TLogTestContext* const& pTLogTestContext) 
															#line 1218 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		 : Actor<Void>(),
		   TLogTestContext_SendPushMessagesActorState<TLogTestContext_SendPushMessagesActor>(pTLogTestContext),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("sendPushMessages", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4548844552927987968UL, 794732782488230400UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_SendPushMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("sendPushMessages");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("sendPushMessages", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TLogTestContext_SendPushMessagesActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TLogTestContext_SendPushMessagesActor, 1, Version >*)0, actor_cancelled()); break;
		}

	}
};
															#line 245 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
[[nodiscard]] Future<Void> TLogTestContext::sendPushMessages( TLogTestContext* const& pTLogTestContext ) {
															#line 245 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	return Future<Void>(new TLogTestContext_SendPushMessagesActor(pTLogTestContext));
															#line 1251 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
}

#line 308 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"

// send peek/pop through a given TLog interface and tag
															#line 1257 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
// This generated class is to be used only via peekCommitMessages()
															#line 310 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
template <class TLogTestContext_PeekCommitMessagesActor>
															#line 310 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
class TLogTestContext_PeekCommitMessagesActorState {
															#line 1263 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
public:
															#line 310 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	TLogTestContext_PeekCommitMessagesActorState(TLogTestContext* const& pTLogTestContext,uint16_t const& tagID,uint32_t const& logID) 
															#line 310 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
															#line 310 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		 : pTLogTestContext(pTLogTestContext),
															#line 310 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		   tagID(tagID),
															#line 310 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		   logID(logID),
															#line 313 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		   pTLogContext(pTLogTestContext->pTLogContextList[logID])
															#line 1276 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
	{
		fdb_probe_actor_create("peekCommitMessages", reinterpret_cast<unsigned long>(this));

	}
	~TLogTestContext_PeekCommitMessagesActorState() 
	{
		fdb_probe_actor_destroy("peekCommitMessages", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 314 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			StrictFuture<bool> __when_expr_0 = pTLogContext->TLogStarted.getFuture();
															#line 314 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			if (static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1293 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state = 1;
															#line 314 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TLogTestContext_PeekCommitMessagesActor, 0, bool >*>(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)));
															#line 1298 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TLogTestContext_PeekCommitMessagesActorState();
		static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& tLogReady,int loopDepth) 
	{
															#line 315 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_EQ(tLogReady, true);
															#line 318 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		tag = Tag(pTLogTestContext->tagLocality, tagID);
															#line 320 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerEnterPeek", pTLogTestContext->workerID).detail("LogID", logID).detail("Tag", tag);
															#line 322 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		i = 0;
															#line 323 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		versions = pTLogTestContext->commitHistory[std::tuple(tagID, logID)];
															#line 324 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		RangeForbody1cont1Iterator0 = std::begin(versions);
															#line 1331 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(bool && tLogReady,int loopDepth) 
	{
															#line 315 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_EQ(tLogReady, true);
															#line 318 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		tag = Tag(pTLogTestContext->tagLocality, tagID);
															#line 320 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerEnterPeek", pTLogTestContext->workerID).detail("LogID", logID).detail("Tag", tag);
															#line 322 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		i = 0;
															#line 323 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		versions = pTLogTestContext->commitHistory[std::tuple(tagID, logID)];
															#line 324 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		RangeForbody1cont1Iterator0 = std::begin(versions);
															#line 1350 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool const& tLogReady,int loopDepth) 
	{
		loopDepth = a_body1cont1(tLogReady, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && tLogReady,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tLogReady), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state > 0) static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->ActorCallback< TLogTestContext_PeekCommitMessagesActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< TLogTestContext_PeekCommitMessagesActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("peekCommitMessages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekCommitMessages", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TLogTestContext_PeekCommitMessagesActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("peekCommitMessages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekCommitMessages", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TLogTestContext_PeekCommitMessagesActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("peekCommitMessages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekCommitMessages", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 389 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerExitPeek", pTLogTestContext->workerID).detail("LogID", logID).detail("TagID", tag);
															#line 391 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogTestContext_PeekCommitMessagesActorState(); static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->destroy(); return 0; }
															#line 1436 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		new (&static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TLogTestContext_PeekCommitMessagesActorState();
		static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 324 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!(RangeForbody1cont1Iterator0 != std::end(versions)))
															#line 1455 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 324 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		Version v = *RangeForbody1cont1Iterator0;
															#line 1461 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		{
															#line 325 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			begin = v;
															#line 327 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			::TLogPeekRequest request(begin, tag, false, false);
															#line 328 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			StrictFuture<::TLogPeekReply> __when_expr_1 = pTLogContext->TestTLogInterface.peekMessages.getReply(request);
															#line 328 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			if (static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1471 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state = 2;
															#line 328 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TLogTestContext_PeekCommitMessagesActor, 1, ::TLogPeekReply >*>(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)));
															#line 1476 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 324 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		++RangeForbody1cont1Iterator0;
															#line 1499 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(::TLogPeekReply const& reply,int loopDepth) 
	{
															#line 329 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerTryValidateDataOnPeek", pTLogTestContext->workerID) .detail("R", begin) .detail("B", reply.begin.present() ? reply.begin.get() : -1) .detail("P", reply.popped) .detail("To", pTLogContext->TestTLogInterface.toString());
															#line 335 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (reply.popped.present() && reply.popped.get() > begin)
															#line 1510 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 339 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_GE(reply.maxKnownVersion, i);
															#line 342 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ArenaReader rd = ArenaReader(reply.arena, reply.messages, AssumeVersion(g_network->protocolVersion()));
															#line 343 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_EQ(*(int32_t*)rd.peekBytes(4), VERSION_HEADER);
															#line 344 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		int32_t dummy;
															#line 345 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		Version ver;
															#line 346 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		rd >> dummy >> ver;
															#line 349 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		int32_t messageLength;
															#line 350 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		uint16_t tagCount;
															#line 351 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		uint32_t sub = 1;
															#line 352 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (FLOW_KNOBS->WRITE_TRACING_ENABLED)
															#line 1534 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		{
															#line 353 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			rd >> messageLength >> sub >> tagCount;
															#line 354 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			rd.readBytes(tagCount * sizeof(Tag));
															#line 357 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			if (sub == 1)
															#line 1542 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			{
															#line 358 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				SpanContextMessage contextMessage;
															#line 359 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				rd >> contextMessage;
															#line 1548 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			}
		}
															#line 364 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (sub == 1)
															#line 1553 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		{
															#line 365 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			rd >> messageLength >> sub >> tagCount;
															#line 366 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			rd.readBytes(tagCount * sizeof(Tag));
															#line 1559 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		}
															#line 369 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		MutationRef m;
															#line 370 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		rd >> m;
															#line 373 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		Standalone<StringRef> expectedKey = StringRef(format("key %d", i));
															#line 374 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		Standalone<StringRef> expectedVal = StringRef(format("value %d", i));
															#line 375 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_WE_THINK(m.param1 == expectedKey);
															#line 376 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_WE_THINK(m.param2 == expectedVal);
															#line 378 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerValidatedDataOnPeek", pTLogTestContext->workerID) .detail("CommitCount", i) .detail("LogID", logID) .detail("TagID", tag);
															#line 384 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		::TLogPopRequest requestPop(begin, begin, tag);
															#line 385 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = pTLogContext->TestTLogInterface.popMessages.getReply(requestPop);
															#line 385 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1581 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state = 3;
															#line 385 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TLogTestContext_PeekCommitMessagesActor, 2, Void >*>(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)));
															#line 1586 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(::TLogPeekReply && reply,int loopDepth) 
	{
															#line 329 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerTryValidateDataOnPeek", pTLogTestContext->workerID) .detail("R", begin) .detail("B", reply.begin.present() ? reply.begin.get() : -1) .detail("P", reply.popped) .detail("To", pTLogContext->TestTLogInterface.toString());
															#line 335 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (reply.popped.present() && reply.popped.get() > begin)
															#line 1597 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 339 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_GE(reply.maxKnownVersion, i);
															#line 342 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ArenaReader rd = ArenaReader(reply.arena, reply.messages, AssumeVersion(g_network->protocolVersion()));
															#line 343 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_EQ(*(int32_t*)rd.peekBytes(4), VERSION_HEADER);
															#line 344 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		int32_t dummy;
															#line 345 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		Version ver;
															#line 346 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		rd >> dummy >> ver;
															#line 349 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		int32_t messageLength;
															#line 350 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		uint16_t tagCount;
															#line 351 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		uint32_t sub = 1;
															#line 352 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (FLOW_KNOBS->WRITE_TRACING_ENABLED)
															#line 1621 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		{
															#line 353 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			rd >> messageLength >> sub >> tagCount;
															#line 354 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			rd.readBytes(tagCount * sizeof(Tag));
															#line 357 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			if (sub == 1)
															#line 1629 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			{
															#line 358 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				SpanContextMessage contextMessage;
															#line 359 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				rd >> contextMessage;
															#line 1635 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			}
		}
															#line 364 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (sub == 1)
															#line 1640 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		{
															#line 365 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			rd >> messageLength >> sub >> tagCount;
															#line 366 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			rd.readBytes(tagCount * sizeof(Tag));
															#line 1646 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		}
															#line 369 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		MutationRef m;
															#line 370 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		rd >> m;
															#line 373 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		Standalone<StringRef> expectedKey = StringRef(format("key %d", i));
															#line 374 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		Standalone<StringRef> expectedVal = StringRef(format("value %d", i));
															#line 375 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_WE_THINK(m.param1 == expectedKey);
															#line 376 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_WE_THINK(m.param2 == expectedVal);
															#line 378 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerValidatedDataOnPeek", pTLogTestContext->workerID) .detail("CommitCount", i) .detail("LogID", logID) .detail("TagID", tag);
															#line 384 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		::TLogPopRequest requestPop(begin, begin, tag);
															#line 385 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = pTLogContext->TestTLogInterface.popMessages.getReply(requestPop);
															#line 385 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1668 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state = 3;
															#line 385 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TLogTestContext_PeekCommitMessagesActor, 2, Void >*>(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)));
															#line 1673 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(::TLogPeekReply const& reply,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(reply, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(::TLogPeekReply && reply,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state > 0) static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->ActorCallback< TLogTestContext_PeekCommitMessagesActor, 1, ::TLogPeekReply >::remove();

	}
	void a_callback_fire(ActorCallback< TLogTestContext_PeekCommitMessagesActor, 1, ::TLogPeekReply >*,::TLogPeekReply const& value) 
	{
		fdb_probe_actor_enter("peekCommitMessages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekCommitMessages", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TLogTestContext_PeekCommitMessagesActor, 1, ::TLogPeekReply >*,::TLogPeekReply && value) 
	{
		fdb_probe_actor_enter("peekCommitMessages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekCommitMessages", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TLogTestContext_PeekCommitMessagesActor, 1, ::TLogPeekReply >*,Error err) 
	{
		fdb_probe_actor_enter("peekCommitMessages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekCommitMessages", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 386 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		i++;
															#line 1757 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 386 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		i++;
															#line 1766 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state > 0) static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->ActorCallback< TLogTestContext_PeekCommitMessagesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TLogTestContext_PeekCommitMessagesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("peekCommitMessages", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekCommitMessages", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TLogTestContext_PeekCommitMessagesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("peekCommitMessages", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekCommitMessages", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TLogTestContext_PeekCommitMessagesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("peekCommitMessages", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekCommitMessages", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 310 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	TLogTestContext* pTLogTestContext;
															#line 310 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	uint16_t tagID;
															#line 310 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	uint32_t logID;
															#line 313 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Reference<TLogContext> pTLogContext;
															#line 318 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Tag tag;
															#line 322 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	uint32_t i;
															#line 323 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	std::vector<Version> versions;
															#line 324 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	decltype(std::begin(std::declval<std::vector<Version>>())) RangeForbody1cont1Iterator0;
															#line 325 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Version begin;
															#line 1864 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
};
// This generated class is to be used only via peekCommitMessages()
															#line 310 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
class TLogTestContext_PeekCommitMessagesActor final : public Actor<Void>, public ActorCallback< TLogTestContext_PeekCommitMessagesActor, 0, bool >, public ActorCallback< TLogTestContext_PeekCommitMessagesActor, 1, ::TLogPeekReply >, public ActorCallback< TLogTestContext_PeekCommitMessagesActor, 2, Void >, public FastAllocated<TLogTestContext_PeekCommitMessagesActor>, public TLogTestContext_PeekCommitMessagesActorState<TLogTestContext_PeekCommitMessagesActor> {
															#line 1869 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
public:
	using FastAllocated<TLogTestContext_PeekCommitMessagesActor>::operator new;
	using FastAllocated<TLogTestContext_PeekCommitMessagesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17752551784121157888UL, 4502678747859738112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TLogTestContext_PeekCommitMessagesActor, 0, bool >;
friend struct ActorCallback< TLogTestContext_PeekCommitMessagesActor, 1, ::TLogPeekReply >;
friend struct ActorCallback< TLogTestContext_PeekCommitMessagesActor, 2, Void >;
															#line 310 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	TLogTestContext_PeekCommitMessagesActor(TLogTestContext* const& pTLogTestContext,uint16_t const& tagID,uint32_t const& logID) 
															#line 1888 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		 : Actor<Void>(),
		   TLogTestContext_PeekCommitMessagesActorState<TLogTestContext_PeekCommitMessagesActor>(pTLogTestContext, tagID, logID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("peekCommitMessages", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8229782662284358144UL, 11780833728886292736UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("peekCommitMessages");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("peekCommitMessages", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TLogTestContext_PeekCommitMessagesActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TLogTestContext_PeekCommitMessagesActor, 1, ::TLogPeekReply >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TLogTestContext_PeekCommitMessagesActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 310 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
[[nodiscard]] Future<Void> TLogTestContext::peekCommitMessages( TLogTestContext* const& pTLogTestContext, uint16_t const& tagID, uint32_t const& logID ) {
															#line 310 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	return Future<Void>(new TLogTestContext_PeekCommitMessagesActor(pTLogTestContext, tagID, logID));
															#line 1922 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
}

#line 393 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"

															#line 1927 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
namespace {
// This generated class is to be used only via buildTLogSet()
															#line 394 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
template <class BuildTLogSetActor>
															#line 394 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
class BuildTLogSetActorState {
															#line 1934 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
public:
															#line 394 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	BuildTLogSetActorState(Reference<TLogTestContext> const& pTLogTestContext) 
															#line 394 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
															#line 394 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		 : pTLogTestContext(pTLogTestContext),
															#line 395 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		   tLogSet(),
															#line 396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		   processID(0)
															#line 1945 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
	{
		fdb_probe_actor_create("buildTLogSet", reinterpret_cast<unsigned long>(this));

	}
	~BuildTLogSetActorState() 
	{
		fdb_probe_actor_destroy("buildTLogSet", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 398 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			tLogSet.tLogLocalities.push_back(LocalityData());
															#line 399 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			tLogSet.tLogPolicy = Reference<IReplicationPolicy>(new PolicyOne());
															#line 400 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			tLogSet.locality = pTLogTestContext->primaryLocality;
															#line 401 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			tLogSet.isLocal = true;
															#line 402 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			tLogSet.tLogVersion = TLogVersion::V6;
															#line 403 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			tLogSet.tLogReplicationFactor = 1;
															#line 404 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			;
															#line 1972 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BuildTLogSetActorState();
		static_cast<BuildTLogSetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 411 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogTestContext->dbInfo.logSystemConfig.tLogs.push_back(tLogSet);
															#line 412 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		for(processID = 0;processID < pTLogTestContext->numLogServers;processID++) {
															#line 413 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			Reference<TLogContext> pTLogContext = pTLogTestContext->pTLogContextList[processID];
															#line 415 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			pTLogContext->TLogStarted.send(true);
															#line 2001 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		}
															#line 417 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!static_cast<BuildTLogSetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BuildTLogSetActorState(); static_cast<BuildTLogSetActor*>(this)->destroy(); return 0; }
															#line 2005 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		new (&static_cast<BuildTLogSetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BuildTLogSetActorState();
		static_cast<BuildTLogSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 404 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!(processID < pTLogTestContext->numLogServers))
															#line 2024 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 405 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogContext = pTLogTestContext->pTLogContextList[processID];
															#line 406 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<bool> __when_expr_0 = pTLogContext->TLogCreated.getFuture();
															#line 406 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (static_cast<BuildTLogSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2034 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<BuildTLogSetActor*>(this)->actor_wait_state = 1;
															#line 406 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BuildTLogSetActor, 0, bool >*>(static_cast<BuildTLogSetActor*>(this)));
															#line 2039 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool const& isCreated,int loopDepth) 
	{
															#line 407 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_EQ(isCreated, true);
															#line 409 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		tLogSet.tLogs.push_back(OptionalInterface<TLogInterface>(pTLogContext->TestTLogInterface));
															#line 404 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		processID++;
															#line 2065 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool && isCreated,int loopDepth) 
	{
															#line 407 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_EQ(isCreated, true);
															#line 409 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		tLogSet.tLogs.push_back(OptionalInterface<TLogInterface>(pTLogContext->TestTLogInterface));
															#line 404 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		processID++;
															#line 2078 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& isCreated,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(isCreated, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && isCreated,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(isCreated), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BuildTLogSetActor*>(this)->actor_wait_state > 0) static_cast<BuildTLogSetActor*>(this)->actor_wait_state = 0;
		static_cast<BuildTLogSetActor*>(this)->ActorCallback< BuildTLogSetActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BuildTLogSetActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("buildTLogSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BuildTLogSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buildTLogSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BuildTLogSetActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("buildTLogSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BuildTLogSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buildTLogSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BuildTLogSetActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("buildTLogSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BuildTLogSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buildTLogSet", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 394 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Reference<TLogTestContext> pTLogTestContext;
															#line 395 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	TLogSet tLogSet;
															#line 396 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	uint16_t processID;
															#line 405 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Reference<TLogContext> pTLogContext;
															#line 2166 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
};
// This generated class is to be used only via buildTLogSet()
															#line 394 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
class BuildTLogSetActor final : public Actor<Void>, public ActorCallback< BuildTLogSetActor, 0, bool >, public FastAllocated<BuildTLogSetActor>, public BuildTLogSetActorState<BuildTLogSetActor> {
															#line 2171 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
public:
	using FastAllocated<BuildTLogSetActor>::operator new;
	using FastAllocated<BuildTLogSetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9565188842390446080UL, 3349431951930429952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BuildTLogSetActor, 0, bool >;
															#line 394 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	BuildTLogSetActor(Reference<TLogTestContext> const& pTLogTestContext) 
															#line 2188 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		 : Actor<Void>(),
		   BuildTLogSetActorState<BuildTLogSetActor>(pTLogTestContext),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("buildTLogSet", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14320124991897615872UL, 5530170740630234112UL);
		ActorExecutionContextHelper __helper(static_cast<BuildTLogSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("buildTLogSet");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("buildTLogSet", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BuildTLogSetActor, 0, bool >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 394 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
[[nodiscard]] Future<Void> buildTLogSet( Reference<TLogTestContext> const& pTLogTestContext ) {
															#line 394 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	return Future<Void>(new BuildTLogSetActor(pTLogTestContext));
															#line 2221 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
}

#line 419 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"

// This test creates a tLog and pushes data to it. the If the recovery
// test switch is on, a new "generation" of tLogs is then created. These enter recover mode
// and pull data from the old generation. The data is peeked from either the old or new generation
// depending on the recovery switch, validated, and popped.

															#line 2231 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
namespace {
// This generated class is to be used only via startTestsTLogRecoveryActors()
															#line 425 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
template <class StartTestsTLogRecoveryActorsActor>
															#line 425 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
class StartTestsTLogRecoveryActorsActorState {
															#line 2238 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
public:
															#line 425 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	StartTestsTLogRecoveryActorsActorState(TestTLogOptions const& params) 
															#line 425 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
															#line 425 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		 : params(params),
															#line 426 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		   tLogActors(),
															#line 427 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		   pTLogTestContextEpochOne(initTLogTestContext(params, Optional<Reference<TLogTestContext>>()))
															#line 2249 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
	{
		fdb_probe_actor_create("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this));

	}
	~StartTestsTLogRecoveryActorsActorState() 
	{
		fdb_probe_actor_destroy("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 430 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			FlowTransport::createInstance(false, 1, WLTOKEN_RESERVED_COUNT);
															#line 432 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			tLogIdx = 0;
															#line 434 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			TraceEvent("TestTLogServerEnterRecoveryTest");
															#line 437 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			for(tLogIdx = 0;tLogIdx < pTLogTestContextEpochOne->numLogServers;tLogIdx++) {
															#line 438 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				Reference<TLogContext> pTLogContext(new TLogContext(tLogIdx));
															#line 439 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				pTLogTestContextEpochOne->pTLogContextList.push_back(pTLogContext);
															#line 440 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				tLogActors.emplace_back( getTLogCreateActor(pTLogTestContextEpochOne, pTLogTestContextEpochOne->tLogOptions, tLogIdx));
															#line 2276 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			}
															#line 445 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = buildTLogSet(pTLogTestContextEpochOne);
															#line 445 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2282 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 1;
															#line 445 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartTestsTLogRecoveryActorsActor, 0, Void >*>(static_cast<StartTestsTLogRecoveryActorsActor*>(this)));
															#line 2287 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartTestsTLogRecoveryActorsActorState();
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 447 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		PromiseStream<Future<Void>> promises;
															#line 449 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogTestContextEpochOne->ls = ILogSystem::fromServerDBInfo( pTLogTestContextEpochOne->logID, pTLogTestContextEpochOne->dbInfo, false, promises);
															#line 452 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = pTLogTestContextEpochOne->sendPushMessages();
															#line 452 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2316 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 2;
															#line 452 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartTestsTLogRecoveryActorsActor, 1, Void >*>(static_cast<StartTestsTLogRecoveryActorsActor*>(this)));
															#line 2321 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 447 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		PromiseStream<Future<Void>> promises;
															#line 449 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogTestContextEpochOne->ls = ILogSystem::fromServerDBInfo( pTLogTestContextEpochOne->logID, pTLogTestContextEpochOne->dbInfo, false, promises);
															#line 452 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = pTLogTestContextEpochOne->sendPushMessages();
															#line 452 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2336 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 2;
															#line 452 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartTestsTLogRecoveryActorsActor, 1, Void >*>(static_cast<StartTestsTLogRecoveryActorsActor*>(this)));
															#line 2341 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state > 0) static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 0;
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->ActorCallback< StartTestsTLogRecoveryActorsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartTestsTLogRecoveryActorsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 454 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		tagID = 0;
															#line 455 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		commitHistory = std::map<std::tuple<uint32_t, uint32_t>, std::vector<Version>>();
															#line 457 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!pTLogTestContextEpochOne->recover)
															#line 2429 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		{
															#line 458 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			commitHistory = pTLogTestContextEpochOne->commitHistory;
															#line 459 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			RangeForbody1cont3Iterator0 = std::begin(commitHistory);
															#line 2435 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = a_body1cont3loopHead1(loopDepth);
		}
		else
		{
															#line 464 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			pTLogTestContextEpochTwo = initTLogTestContext(TestTLogOptions(params), pTLogTestContextEpochOne);
															#line 467 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			pTLogTestContextEpochTwo->tLogOptions.versions = pTLogTestContextEpochOne->tLogOptions.versions;
															#line 468 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			commitHistory = pTLogTestContextEpochTwo->commitHistory;
															#line 469 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			pTLogTestContextEpochTwo->pTLogContextList.resize(commitHistory.size());
															#line 470 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			RangeForbody1cont3Iterator1 = std::begin(commitHistory);
															#line 2450 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = a_body1cont3loopHead2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 454 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		tagID = 0;
															#line 455 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		commitHistory = std::map<std::tuple<uint32_t, uint32_t>, std::vector<Version>>();
															#line 457 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!pTLogTestContextEpochOne->recover)
															#line 2464 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		{
															#line 458 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			commitHistory = pTLogTestContextEpochOne->commitHistory;
															#line 459 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			RangeForbody1cont3Iterator0 = std::begin(commitHistory);
															#line 2470 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = a_body1cont3loopHead1(loopDepth);
		}
		else
		{
															#line 464 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			pTLogTestContextEpochTwo = initTLogTestContext(TestTLogOptions(params), pTLogTestContextEpochOne);
															#line 467 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			pTLogTestContextEpochTwo->tLogOptions.versions = pTLogTestContextEpochOne->tLogOptions.versions;
															#line 468 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			commitHistory = pTLogTestContextEpochTwo->commitHistory;
															#line 469 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			pTLogTestContextEpochTwo->pTLogContextList.resize(commitHistory.size());
															#line 470 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			RangeForbody1cont3Iterator1 = std::begin(commitHistory);
															#line 2485 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = a_body1cont3loopHead2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state > 0) static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 0;
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->ActorCallback< StartTestsTLogRecoveryActorsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StartTestsTLogRecoveryActorsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 525 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		for(tLogIdx = 0;tLogIdx < pTLogTestContextEpochOne->numLogServers;tLogIdx++) {
															#line 526 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			pTLogTestContextEpochOne->pTLogContextList[tLogIdx]->TestTLogServerCompleted.send(true);
															#line 2572 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		}
															#line 530 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_6 = waitForAll(tLogActors);
															#line 530 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2578 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont4when1(__when_expr_6.get(), loopDepth); };
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 7;
															#line 530 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< StartTestsTLogRecoveryActorsActor, 6, Void >*>(static_cast<StartTestsTLogRecoveryActorsActor*>(this)));
															#line 2583 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 459 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!(RangeForbody1cont3Iterator0 != std::end(commitHistory)))
															#line 2605 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 459 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		const auto& [loc, ver] = *RangeForbody1cont3Iterator0;
															#line 2611 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		{
															#line 460 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_2 = pTLogTestContextEpochOne->peekCommitMessages(std::get<0>(loc), std::get<1>(loc));
															#line 460 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2617 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 3;
															#line 460 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartTestsTLogRecoveryActorsActor, 2, Void >*>(static_cast<StartTestsTLogRecoveryActorsActor*>(this)));
															#line 2622 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int loopDepth) 
	{
															#line 459 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		++RangeForbody1cont3Iterator0;
															#line 2645 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state > 0) static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 0;
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->ActorCallback< StartTestsTLogRecoveryActorsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StartTestsTLogRecoveryActorsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 515 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		RangeForbody1cont6Iterator0 = std::begin(commitHistory);
															#line 2741 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopHead2(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody2(int loopDepth) 
	{
															#line 470 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!(RangeForbody1cont3Iterator1 != std::end(commitHistory)))
															#line 2757 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		{
			return a_body1cont3break2(loopDepth==0?0:loopDepth-1); // break
		}
															#line 470 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		const auto& [loc, ver] = *RangeForbody1cont3Iterator1;
															#line 2763 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		{
															#line 471 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			tLogIdx = std::get<1>(loc);
															#line 472 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			tagID = std::get<0>(loc);
															#line 473 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			StrictFuture<TLogLockResult> __when_expr_3 = pTLogTestContextEpochOne->pTLogContextList[tLogIdx] ->TestTLogInterface.lock.template getReply<TLogLockResult>();
															#line 473 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2773 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody2when1(__when_expr_3.get(), loopDepth); };
			static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 4;
															#line 473 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StartTestsTLogRecoveryActorsActor, 3, TLogLockResult >*>(static_cast<StartTestsTLogRecoveryActorsActor*>(this)));
															#line 2778 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont3break2(int loopDepth) 
	{
		try {
			return a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody2cont1(int loopDepth) 
	{
															#line 470 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		++RangeForbody1cont3Iterator1;
															#line 2801 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead2(0);

		return loopDepth;
	}
	int a_body1cont3loopBody2cont3(TLogLockResult const& data,int loopDepth) 
	{
															#line 475 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerLockResult") .detail("KCV", data.knownCommittedVersion) .detail("T", tagID) .detail("L", tLogIdx);
															#line 480 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		Reference<TLogContext> pNewTLogContext(new TLogContext(tLogIdx));
															#line 481 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogTestContextEpochTwo->pTLogContextList[tLogIdx] = pNewTLogContext;
															#line 482 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req = InitializeTLogRequest();
															#line 483 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.recruitmentID = pTLogTestContextEpochTwo->dbInfo.logSystemConfig.recruitmentID;
															#line 484 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.recoverAt = pTLogTestContextEpochOne->tLogOptions.versions.back();
															#line 489 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.startVersion = pTLogTestContextEpochOne->initVersion + 1;
															#line 490 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.recoveryTransactionVersion = pTLogTestContextEpochOne->initVersion;
															#line 491 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.knownCommittedVersion = 0;
															#line 492 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.epoch = pTLogTestContextEpochTwo->epoch;
															#line 493 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.logVersion = TLogVersion::V6;
															#line 494 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.locality = pTLogTestContextEpochTwo->primaryLocality;
															#line 495 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.isPrimary = true;
															#line 496 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.logRouterTags = 0;
															#line 497 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.recoverTags = { Tag(pTLogTestContextEpochTwo->primaryLocality, tagID) };
															#line 498 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.recoverFrom = pTLogTestContextEpochOne->dbInfo.logSystemConfig;
															#line 499 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.recoverFrom.logRouterTags = 0;
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		const TestTLogOptions& tLogOptions = pTLogTestContextEpochTwo->tLogOptions;
															#line 503 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		tLogActors.emplace_back(getTLogCreateActor(pTLogTestContextEpochTwo, tLogOptions, tLogIdx, &req, pTLogTestContextEpochOne->pTLogContextList[tLogIdx]->tLogID));
															#line 509 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogContext = pTLogTestContextEpochTwo->pTLogContextList[tLogIdx];
															#line 510 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<bool> __when_expr_4 = pTLogContext->TLogCreated.getFuture();
															#line 510 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2852 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody2cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 5;
															#line 510 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< StartTestsTLogRecoveryActorsActor, 4, bool >*>(static_cast<StartTestsTLogRecoveryActorsActor*>(this)));
															#line 2857 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody2cont3(TLogLockResult && data,int loopDepth) 
	{
															#line 475 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerLockResult") .detail("KCV", data.knownCommittedVersion) .detail("T", tagID) .detail("L", tLogIdx);
															#line 480 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		Reference<TLogContext> pNewTLogContext(new TLogContext(tLogIdx));
															#line 481 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogTestContextEpochTwo->pTLogContextList[tLogIdx] = pNewTLogContext;
															#line 482 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req = InitializeTLogRequest();
															#line 483 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.recruitmentID = pTLogTestContextEpochTwo->dbInfo.logSystemConfig.recruitmentID;
															#line 484 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.recoverAt = pTLogTestContextEpochOne->tLogOptions.versions.back();
															#line 489 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.startVersion = pTLogTestContextEpochOne->initVersion + 1;
															#line 490 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.recoveryTransactionVersion = pTLogTestContextEpochOne->initVersion;
															#line 491 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.knownCommittedVersion = 0;
															#line 492 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.epoch = pTLogTestContextEpochTwo->epoch;
															#line 493 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.logVersion = TLogVersion::V6;
															#line 494 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.locality = pTLogTestContextEpochTwo->primaryLocality;
															#line 495 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.isPrimary = true;
															#line 496 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.logRouterTags = 0;
															#line 497 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.recoverTags = { Tag(pTLogTestContextEpochTwo->primaryLocality, tagID) };
															#line 498 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.recoverFrom = pTLogTestContextEpochOne->dbInfo.logSystemConfig;
															#line 499 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.recoverFrom.logRouterTags = 0;
															#line 501 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		const TestTLogOptions& tLogOptions = pTLogTestContextEpochTwo->tLogOptions;
															#line 503 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		tLogActors.emplace_back(getTLogCreateActor(pTLogTestContextEpochTwo, tLogOptions, tLogIdx, &req, pTLogTestContextEpochOne->pTLogContextList[tLogIdx]->tLogID));
															#line 509 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogContext = pTLogTestContextEpochTwo->pTLogContextList[tLogIdx];
															#line 510 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<bool> __when_expr_4 = pTLogContext->TLogCreated.getFuture();
															#line 510 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2908 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody2cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 5;
															#line 510 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< StartTestsTLogRecoveryActorsActor, 4, bool >*>(static_cast<StartTestsTLogRecoveryActorsActor*>(this)));
															#line 2913 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody2when1(TLogLockResult const& data,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody2cont3(data, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody2when1(TLogLockResult && data,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody2cont3(std::move(data), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state > 0) static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 0;
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->ActorCallback< StartTestsTLogRecoveryActorsActor, 3, TLogLockResult >::remove();

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 3, TLogLockResult >*,TLogLockResult const& value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 3, TLogLockResult >*,TLogLockResult && value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StartTestsTLogRecoveryActorsActor, 3, TLogLockResult >*,Error err) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont3loopBody2cont4(bool const& isCreated,int loopDepth) 
	{
															#line 511 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_EQ(isCreated, true);
															#line 512 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogContext->TLogStarted.send(true);
															#line 2999 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = a_body1cont3loopBody2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody2cont4(bool && isCreated,int loopDepth) 
	{
															#line 511 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_EQ(isCreated, true);
															#line 512 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogContext->TLogStarted.send(true);
															#line 3010 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = a_body1cont3loopBody2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody2cont3when1(bool const& isCreated,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody2cont4(isCreated, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody2cont3when1(bool && isCreated,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody2cont4(std::move(isCreated), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state > 0) static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 0;
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->ActorCallback< StartTestsTLogRecoveryActorsActor, 4, bool >::remove();

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 4, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody2cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 4, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody2cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< StartTestsTLogRecoveryActorsActor, 4, bool >*,Error err) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 520 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		for(tLogIdx = 0;tLogIdx < pTLogTestContextEpochOne->numLogServers;tLogIdx++) {
															#line 521 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			pTLogTestContextEpochTwo->pTLogContextList[tLogIdx]->TestTLogServerCompleted.send(true);
															#line 3096 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1(int loopDepth) 
	{
															#line 515 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!(RangeForbody1cont6Iterator0 != std::end(commitHistory)))
															#line 3113 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		{
			return a_body1cont6break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 515 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		const auto& [loc, ver] = *RangeForbody1cont6Iterator0;
															#line 3119 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		{
															#line 516 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_5 = pTLogTestContextEpochTwo->peekCommitMessages(std::get<0>(loc), std::get<1>(loc));
															#line 516 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3125 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1when1(__when_expr_5.get(), loopDepth); };
			static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 6;
															#line 516 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< StartTestsTLogRecoveryActorsActor, 5, Void >*>(static_cast<StartTestsTLogRecoveryActorsActor*>(this)));
															#line 3130 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont6break1(int loopDepth) 
	{
		try {
			return a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(int loopDepth) 
	{
															#line 515 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		++RangeForbody1cont6Iterator0;
															#line 3153 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state > 0) static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 0;
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->ActorCallback< StartTestsTLogRecoveryActorsActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< StartTestsTLogRecoveryActorsActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 532 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerExitRecoveryTest");
															#line 534 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!static_cast<StartTestsTLogRecoveryActorsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartTestsTLogRecoveryActorsActorState(); static_cast<StartTestsTLogRecoveryActorsActor*>(this)->destroy(); return 0; }
															#line 3251 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		new (&static_cast<StartTestsTLogRecoveryActorsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartTestsTLogRecoveryActorsActorState();
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 532 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerExitRecoveryTest");
															#line 534 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!static_cast<StartTestsTLogRecoveryActorsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartTestsTLogRecoveryActorsActorState(); static_cast<StartTestsTLogRecoveryActorsActor*>(this)->destroy(); return 0; }
															#line 3265 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		new (&static_cast<StartTestsTLogRecoveryActorsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartTestsTLogRecoveryActorsActorState();
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state > 0) static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 0;
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->ActorCallback< StartTestsTLogRecoveryActorsActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< StartTestsTLogRecoveryActorsActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 425 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	TestTLogOptions params;
															#line 426 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	std::vector<Future<Void>> tLogActors;
															#line 427 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Reference<TLogTestContext> pTLogTestContextEpochOne;
															#line 432 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	uint16_t tLogIdx;
															#line 454 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	uint32_t tagID;
															#line 455 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	std::map<std::tuple<uint32_t, uint32_t>, std::vector<Version>> commitHistory;
															#line 459 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	decltype(std::begin(std::declval<std::map<std::tuple<uint32_t, uint32_t>, std::vector<Version>>>())) RangeForbody1cont3Iterator0;
															#line 464 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Reference<TLogTestContext> pTLogTestContextEpochTwo;
															#line 470 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	decltype(std::begin(std::declval<std::map<std::tuple<uint32_t, uint32_t>, std::vector<Version>>>())) RangeForbody1cont3Iterator1;
															#line 482 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	InitializeTLogRequest req;
															#line 509 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Reference<TLogContext> pTLogContext;
															#line 515 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	decltype(std::begin(std::declval<std::map<std::tuple<uint32_t, uint32_t>, std::vector<Version>>>())) RangeForbody1cont6Iterator0;
															#line 3372 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
};
// This generated class is to be used only via startTestsTLogRecoveryActors()
															#line 425 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
class StartTestsTLogRecoveryActorsActor final : public Actor<Void>, public ActorCallback< StartTestsTLogRecoveryActorsActor, 0, Void >, public ActorCallback< StartTestsTLogRecoveryActorsActor, 1, Void >, public ActorCallback< StartTestsTLogRecoveryActorsActor, 2, Void >, public ActorCallback< StartTestsTLogRecoveryActorsActor, 3, TLogLockResult >, public ActorCallback< StartTestsTLogRecoveryActorsActor, 4, bool >, public ActorCallback< StartTestsTLogRecoveryActorsActor, 5, Void >, public ActorCallback< StartTestsTLogRecoveryActorsActor, 6, Void >, public FastAllocated<StartTestsTLogRecoveryActorsActor>, public StartTestsTLogRecoveryActorsActorState<StartTestsTLogRecoveryActorsActor> {
															#line 3377 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
public:
	using FastAllocated<StartTestsTLogRecoveryActorsActor>::operator new;
	using FastAllocated<StartTestsTLogRecoveryActorsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7543840013247010048UL, 8125478183760181248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartTestsTLogRecoveryActorsActor, 0, Void >;
friend struct ActorCallback< StartTestsTLogRecoveryActorsActor, 1, Void >;
friend struct ActorCallback< StartTestsTLogRecoveryActorsActor, 2, Void >;
friend struct ActorCallback< StartTestsTLogRecoveryActorsActor, 3, TLogLockResult >;
friend struct ActorCallback< StartTestsTLogRecoveryActorsActor, 4, bool >;
friend struct ActorCallback< StartTestsTLogRecoveryActorsActor, 5, Void >;
friend struct ActorCallback< StartTestsTLogRecoveryActorsActor, 6, Void >;
															#line 425 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	StartTestsTLogRecoveryActorsActor(TestTLogOptions const& params) 
															#line 3400 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
		 : Actor<Void>(),
		   StartTestsTLogRecoveryActorsActorState<StartTestsTLogRecoveryActorsActor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5529212507314564864UL, 18021143452755378688UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startTestsTLogRecoveryActors");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartTestsTLogRecoveryActorsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StartTestsTLogRecoveryActorsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StartTestsTLogRecoveryActorsActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< StartTestsTLogRecoveryActorsActor, 3, TLogLockResult >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< StartTestsTLogRecoveryActorsActor, 4, bool >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< StartTestsTLogRecoveryActorsActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< StartTestsTLogRecoveryActorsActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 425 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
[[nodiscard]] Future<Void> startTestsTLogRecoveryActors( TestTLogOptions const& params ) {
															#line 425 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	return Future<Void>(new StartTestsTLogRecoveryActorsActor(params));
															#line 3439 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/fdbserver/TestTLogServer.actor.g.cpp"
}

#line 536 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/fdbserver/TestTLogServer.actor.cpp"

// TEST_CASE("/fdbserver/test/TestTLogCommits") {
// 	params.set("recover", static_cast<int64_t>(0));
// 	TestTLogOptions testTLogOptions(params);
// 	wait(startTestsTLogRecoveryActors(testTLogOptions));
// 	return Void();
// }

// // Two tlogs, one tag. Write 10 commits up to version V. Start recovery with RV set to V+10.
// TEST_CASE("/fdbserver/test/TestTLogRecovery1") {
// 	TestTLogOptions testTLogOptions(params);
// 	wait(startTestsTLogRecoveryActors(testTLogOptions));
// 	return Void();
// }

// // Four tlogs, two tags.
// TEST_CASE("/fdbserver/test/TestTLogRecovery2") {
// 	params.set("numLogServers", static_cast<int64_t>(4));
// 	params.set("numTags", static_cast<int64_t>(2));

// 	TestTLogOptions testTLogOptions(params);
// 	wait(startTestsTLogRecoveryActors(testTLogOptions));
// 	return Void();
// }
