#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
/*
 * print_in_order.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2025 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fmt/format.h"
#include "flow/flow.h"
#include "flow/Platform.h"
#include "flow/DeterministicRandom.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "flow/TLSConfig.actor.h"
#include "flow/actorcompiler.h"

#include <functional>
#include <iostream>
#include <memory>
#include <unordered_map>
#include <vector>

// Solution to https://leetcode.com/problems/print-in-order/description/
//
// This is a super basic concurrency exercise useful as a day 1
// exercise in a new environment. To try this yourself, delete the
// next two functions, then write a solution from scratch.

															#line 44 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
namespace {
// This generated class is to be used only via print_msg_when_ready()
															#line 42 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
template <class Print_msg_when_readyActor>
															#line 42 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
class Print_msg_when_readyActorState {
															#line 51 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
public:
															#line 42 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
	Print_msg_when_readyActorState(Future<Void> const& ready,std::string const& msg) 
															#line 42 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
															#line 42 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		 : ready(ready),
															#line 42 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		   msg(msg)
															#line 60 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
	{
		fdb_probe_actor_create("print_msg_when_ready", reinterpret_cast<unsigned long>(this));

	}
	~Print_msg_when_readyActorState() 
	{
		fdb_probe_actor_destroy("print_msg_when_ready", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 43 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
			int delay_msec = deterministicRandom()->randomInt(0, 1000);
															#line 44 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
			double delay_sec = static_cast<double>(delay_msec) / 1000.0;
															#line 45 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(delay_sec);
															#line 45 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
			if (static_cast<Print_msg_when_readyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 81 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Print_msg_when_readyActor*>(this)->actor_wait_state = 1;
															#line 45 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Print_msg_when_readyActor, 0, Void >*>(static_cast<Print_msg_when_readyActor*>(this)));
															#line 86 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Print_msg_when_readyActorState();
		static_cast<Print_msg_when_readyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 47 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		StrictFuture<Void> __when_expr_1 = ready;
															#line 47 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		if (static_cast<Print_msg_when_readyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 111 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<Print_msg_when_readyActor*>(this)->actor_wait_state = 2;
															#line 47 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Print_msg_when_readyActor, 1, Void >*>(static_cast<Print_msg_when_readyActor*>(this)));
															#line 116 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 47 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		StrictFuture<Void> __when_expr_1 = ready;
															#line 47 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		if (static_cast<Print_msg_when_readyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 127 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<Print_msg_when_readyActor*>(this)->actor_wait_state = 2;
															#line 47 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Print_msg_when_readyActor, 1, Void >*>(static_cast<Print_msg_when_readyActor*>(this)));
															#line 132 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Print_msg_when_readyActor*>(this)->actor_wait_state > 0) static_cast<Print_msg_when_readyActor*>(this)->actor_wait_state = 0;
		static_cast<Print_msg_when_readyActor*>(this)->ActorCallback< Print_msg_when_readyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Print_msg_when_readyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("print_msg_when_ready", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Print_msg_when_readyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("print_msg_when_ready", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Print_msg_when_readyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("print_msg_when_ready", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Print_msg_when_readyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("print_msg_when_ready", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Print_msg_when_readyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("print_msg_when_ready", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Print_msg_when_readyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("print_msg_when_ready", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 48 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		std::cout << msg << std::endl;
															#line 49 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(0.1);
															#line 49 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		if (static_cast<Print_msg_when_readyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 220 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<Print_msg_when_readyActor*>(this)->actor_wait_state = 3;
															#line 49 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< Print_msg_when_readyActor, 2, Void >*>(static_cast<Print_msg_when_readyActor*>(this)));
															#line 225 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 48 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		std::cout << msg << std::endl;
															#line 49 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(0.1);
															#line 49 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		if (static_cast<Print_msg_when_readyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 238 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<Print_msg_when_readyActor*>(this)->actor_wait_state = 3;
															#line 49 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< Print_msg_when_readyActor, 2, Void >*>(static_cast<Print_msg_when_readyActor*>(this)));
															#line 243 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<Print_msg_when_readyActor*>(this)->actor_wait_state > 0) static_cast<Print_msg_when_readyActor*>(this)->actor_wait_state = 0;
		static_cast<Print_msg_when_readyActor*>(this)->ActorCallback< Print_msg_when_readyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Print_msg_when_readyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("print_msg_when_ready", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Print_msg_when_readyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("print_msg_when_ready", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< Print_msg_when_readyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("print_msg_when_ready", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Print_msg_when_readyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("print_msg_when_ready", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< Print_msg_when_readyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("print_msg_when_ready", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Print_msg_when_readyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("print_msg_when_ready", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 50 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		if (!static_cast<Print_msg_when_readyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Print_msg_when_readyActorState(); static_cast<Print_msg_when_readyActor*>(this)->destroy(); return 0; }
															#line 327 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
		new (&static_cast<Print_msg_when_readyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~Print_msg_when_readyActorState();
		static_cast<Print_msg_when_readyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 50 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		if (!static_cast<Print_msg_when_readyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Print_msg_when_readyActorState(); static_cast<Print_msg_when_readyActor*>(this)->destroy(); return 0; }
															#line 339 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
		new (&static_cast<Print_msg_when_readyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~Print_msg_when_readyActorState();
		static_cast<Print_msg_when_readyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<Print_msg_when_readyActor*>(this)->actor_wait_state > 0) static_cast<Print_msg_when_readyActor*>(this)->actor_wait_state = 0;
		static_cast<Print_msg_when_readyActor*>(this)->ActorCallback< Print_msg_when_readyActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Print_msg_when_readyActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("print_msg_when_ready", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Print_msg_when_readyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("print_msg_when_ready", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< Print_msg_when_readyActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("print_msg_when_ready", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Print_msg_when_readyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("print_msg_when_ready", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< Print_msg_when_readyActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("print_msg_when_ready", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Print_msg_when_readyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("print_msg_when_ready", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 42 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
	Future<Void> ready;
															#line 42 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
	std::string msg;
															#line 426 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
};
// This generated class is to be used only via print_msg_when_ready()
															#line 42 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
class Print_msg_when_readyActor final : public Actor<Void>, public ActorCallback< Print_msg_when_readyActor, 0, Void >, public ActorCallback< Print_msg_when_readyActor, 1, Void >, public ActorCallback< Print_msg_when_readyActor, 2, Void >, public FastAllocated<Print_msg_when_readyActor>, public Print_msg_when_readyActorState<Print_msg_when_readyActor> {
															#line 431 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
public:
	using FastAllocated<Print_msg_when_readyActor>::operator new;
	using FastAllocated<Print_msg_when_readyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4238530655742081536UL, 15316993911287870976UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Print_msg_when_readyActor, 0, Void >;
friend struct ActorCallback< Print_msg_when_readyActor, 1, Void >;
friend struct ActorCallback< Print_msg_when_readyActor, 2, Void >;
															#line 42 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
	Print_msg_when_readyActor(Future<Void> const& ready,std::string const& msg) 
															#line 450 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
		 : Actor<Void>(),
		   Print_msg_when_readyActorState<Print_msg_when_readyActor>(ready, msg),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("print_msg_when_ready", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13312858925057281280UL, 5578400703746987520UL);
		ActorExecutionContextHelper __helper(static_cast<Print_msg_when_readyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("print_msg_when_ready");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("print_msg_when_ready", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Print_msg_when_readyActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< Print_msg_when_readyActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< Print_msg_when_readyActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 42 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
[[nodiscard]] Future<Void> print_msg_when_ready( Future<Void> const& ready, std::string const& msg ) {
															#line 42 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
	return Future<Void>(new Print_msg_when_readyActor(ready, msg));
															#line 485 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
}

#line 52 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"

															#line 490 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
namespace {
// This generated class is to be used only via orchestrate()
															#line 53 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
template <class OrchestrateActor>
															#line 53 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
class OrchestrateActorState {
															#line 497 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
public:
															#line 53 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
	OrchestrateActorState() 
															#line 53 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
															#line 54 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		 : p_third(),
															#line 55 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		   first_ready(p_first.getFuture()),
															#line 56 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		   second_ready(p_second.getFuture()),
															#line 57 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		   third_ready(p_third.getFuture()),
															#line 59 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		   first(print_msg_when_ready(first_ready, "First")),
															#line 60 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		   second(print_msg_when_ready(second_ready, "Second")),
															#line 61 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		   third(print_msg_when_ready(third_ready, "Third"))
															#line 516 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
	{
		fdb_probe_actor_create("orchestrate", reinterpret_cast<unsigned long>(this));

	}
	~OrchestrateActorState() 
	{
		fdb_probe_actor_destroy("orchestrate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 71 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
			p_first.send(Void());
															#line 72 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
			StrictFuture<Void> __when_expr_0 = first;
															#line 72 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
			if (static_cast<OrchestrateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 535 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<OrchestrateActor*>(this)->actor_wait_state = 1;
															#line 72 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OrchestrateActor, 0, Void >*>(static_cast<OrchestrateActor*>(this)));
															#line 540 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OrchestrateActorState();
		static_cast<OrchestrateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 73 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		p_second.send(Void());
															#line 74 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		StrictFuture<Void> __when_expr_1 = second;
															#line 74 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		if (static_cast<OrchestrateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 567 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<OrchestrateActor*>(this)->actor_wait_state = 2;
															#line 74 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OrchestrateActor, 1, Void >*>(static_cast<OrchestrateActor*>(this)));
															#line 572 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 73 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		p_second.send(Void());
															#line 74 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		StrictFuture<Void> __when_expr_1 = second;
															#line 74 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		if (static_cast<OrchestrateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 585 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<OrchestrateActor*>(this)->actor_wait_state = 2;
															#line 74 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OrchestrateActor, 1, Void >*>(static_cast<OrchestrateActor*>(this)));
															#line 590 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OrchestrateActor*>(this)->actor_wait_state > 0) static_cast<OrchestrateActor*>(this)->actor_wait_state = 0;
		static_cast<OrchestrateActor*>(this)->ActorCallback< OrchestrateActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OrchestrateActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("orchestrate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OrchestrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orchestrate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OrchestrateActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("orchestrate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OrchestrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orchestrate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OrchestrateActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("orchestrate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OrchestrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orchestrate", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 75 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		p_third.send(Void());
															#line 76 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		StrictFuture<Void> __when_expr_2 = third;
															#line 76 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		if (static_cast<OrchestrateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 678 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<OrchestrateActor*>(this)->actor_wait_state = 3;
															#line 76 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< OrchestrateActor, 2, Void >*>(static_cast<OrchestrateActor*>(this)));
															#line 683 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 75 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		p_third.send(Void());
															#line 76 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		StrictFuture<Void> __when_expr_2 = third;
															#line 76 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		if (static_cast<OrchestrateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 696 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<OrchestrateActor*>(this)->actor_wait_state = 3;
															#line 76 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< OrchestrateActor, 2, Void >*>(static_cast<OrchestrateActor*>(this)));
															#line 701 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<OrchestrateActor*>(this)->actor_wait_state > 0) static_cast<OrchestrateActor*>(this)->actor_wait_state = 0;
		static_cast<OrchestrateActor*>(this)->ActorCallback< OrchestrateActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OrchestrateActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("orchestrate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OrchestrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orchestrate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< OrchestrateActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("orchestrate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OrchestrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orchestrate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< OrchestrateActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("orchestrate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OrchestrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orchestrate", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 78 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		if (!static_cast<OrchestrateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OrchestrateActorState(); static_cast<OrchestrateActor*>(this)->destroy(); return 0; }
															#line 785 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
		new (&static_cast<OrchestrateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~OrchestrateActorState();
		static_cast<OrchestrateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 78 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
		if (!static_cast<OrchestrateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OrchestrateActorState(); static_cast<OrchestrateActor*>(this)->destroy(); return 0; }
															#line 797 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
		new (&static_cast<OrchestrateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~OrchestrateActorState();
		static_cast<OrchestrateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<OrchestrateActor*>(this)->actor_wait_state > 0) static_cast<OrchestrateActor*>(this)->actor_wait_state = 0;
		static_cast<OrchestrateActor*>(this)->ActorCallback< OrchestrateActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OrchestrateActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("orchestrate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OrchestrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orchestrate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< OrchestrateActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("orchestrate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OrchestrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orchestrate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< OrchestrateActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("orchestrate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OrchestrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orchestrate", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 54 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
	Promise<Void> p_first, p_second, p_third;
															#line 55 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
	Future<Void> first_ready;
															#line 56 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
	Future<Void> second_ready;
															#line 57 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
	Future<Void> third_ready;
															#line 59 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
	Future<Void> first;
															#line 60 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
	Future<Void> second;
															#line 61 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
	Future<Void> third;
															#line 894 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
};
// This generated class is to be used only via orchestrate()
															#line 53 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
class OrchestrateActor final : public Actor<Void>, public ActorCallback< OrchestrateActor, 0, Void >, public ActorCallback< OrchestrateActor, 1, Void >, public ActorCallback< OrchestrateActor, 2, Void >, public FastAllocated<OrchestrateActor>, public OrchestrateActorState<OrchestrateActor> {
															#line 899 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
public:
	using FastAllocated<OrchestrateActor>::operator new;
	using FastAllocated<OrchestrateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14729703582232971264UL, 8366722837862895616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< OrchestrateActor, 0, Void >;
friend struct ActorCallback< OrchestrateActor, 1, Void >;
friend struct ActorCallback< OrchestrateActor, 2, Void >;
															#line 53 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
	OrchestrateActor() 
															#line 918 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
		 : Actor<Void>(),
		   OrchestrateActorState<OrchestrateActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("orchestrate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5914937709223385600UL, 2065269787122121216UL);
		ActorExecutionContextHelper __helper(static_cast<OrchestrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("orchestrate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("orchestrate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OrchestrateActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< OrchestrateActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< OrchestrateActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 53 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
[[nodiscard]] Future<Void> orchestrate(  ) {
															#line 53 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"
	return Future<Void>(new OrchestrateActor());
															#line 953 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/build_output/documentation/tutorial/print_in_order.actor.g.cpp"
}

#line 80 "/codebuild/output/src2118757142/src/github.com/apple/foundationdb/documentation/tutorial/print_in_order.actor.cpp"

int main(int argc, char** argv) {
	// Cargo-culted from tutorial.actor.cpp.
	platformInit();
	g_network = newNet2(TLSConfig(), false, true);

	std::vector<Future<Void>> all;

	all.emplace_back(orchestrate());

	auto f = stopAfter(waitForAll(all));
	g_network->run();

	return 0;
}
