/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.MutationType;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.TransactionContext;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public interface Transaction
extends AutoCloseable,
ReadTransaction,
TransactionContext {
    public void addReadConflictRange(byte[] var1, byte[] var2);

    public void addReadConflictKey(byte[] var1);

    public void addWriteConflictRange(byte[] var1, byte[] var2);

    public void addWriteConflictKey(byte[] var1);

    public void set(byte[] var1, byte[] var2);

    public void clear(byte[] var1);

    public void clear(byte[] var1, byte[] var2);

    public void clear(Range var1);

    @Deprecated
    public void clearRangeStartsWith(byte[] var1);

    public void mutate(MutationType var1, byte[] var2, byte[] var3);

    public CompletableFuture<Void> commit();

    public Long getCommittedVersion();

    public CompletableFuture<byte[]> getVersionstamp();

    public CompletableFuture<Long> getApproximateSize();

    public CompletableFuture<Transaction> onError(Throwable var1);

    public void cancel();

    public CompletableFuture<Void> watch(byte[] var1) throws FDBException;

    public Database getDatabase();

    @Override
    public <T> T run(Function<? super Transaction, T> var1);

    @Override
    public <T> CompletableFuture<T> runAsync(Function<? super Transaction, ? extends CompletableFuture<T>> var1);

    @Override
    public void close();
}

