#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
/*
 * genericactors.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "flow/flow.h"
#include "flow/UnitTest.h"
#include "flow/actorcompiler.h" // This must be the last #include.

															#line 27 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
namespace {
// This generated class is to be used only via allTrue()
															#line 25 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
template <class AllTrueActor>
															#line 25 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class AllTrueActorState {
															#line 34 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
															#line 25 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	AllTrueActorState(std::vector<Future<bool>> const& all) 
															#line 25 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
															#line 25 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		 : all(all),
															#line 26 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   i(0)
															#line 43 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
	{
		fdb_probe_actor_create("allTrue", reinterpret_cast<unsigned long>(this));

	}
	~AllTrueActorState() 
	{
		fdb_probe_actor_destroy("allTrue", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 27 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			;
															#line 58 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AllTrueActorState();
		static_cast<AllTrueActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 33 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!static_cast<AllTrueActor*>(this)->SAV<bool>::futures) { (void)(true); this->~AllTrueActorState(); static_cast<AllTrueActor*>(this)->destroy(); return 0; }
															#line 81 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		new (&static_cast<AllTrueActor*>(this)->SAV< bool >::value()) bool(true);
		this->~AllTrueActorState();
		static_cast<AllTrueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 27 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!(i != all.size()))
															#line 100 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 28 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		StrictFuture<bool> __when_expr_0 = all[i];
															#line 28 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (static_cast<AllTrueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 108 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<AllTrueActor*>(this)->actor_wait_state = 1;
															#line 28 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AllTrueActor, 0, bool >*>(static_cast<AllTrueActor*>(this)));
															#line 113 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool const& r,int loopDepth) 
	{
															#line 29 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!r)
															#line 135 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		{
															#line 30 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			if (!static_cast<AllTrueActor*>(this)->SAV<bool>::futures) { (void)(false); this->~AllTrueActorState(); static_cast<AllTrueActor*>(this)->destroy(); return 0; }
															#line 139 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			new (&static_cast<AllTrueActor*>(this)->SAV< bool >::value()) bool(false);
			this->~AllTrueActorState();
			static_cast<AllTrueActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 31 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		i++;
															#line 147 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool && r,int loopDepth) 
	{
															#line 29 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!r)
															#line 156 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		{
															#line 30 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			if (!static_cast<AllTrueActor*>(this)->SAV<bool>::futures) { (void)(false); this->~AllTrueActorState(); static_cast<AllTrueActor*>(this)->destroy(); return 0; }
															#line 160 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			new (&static_cast<AllTrueActor*>(this)->SAV< bool >::value()) bool(false);
			this->~AllTrueActorState();
			static_cast<AllTrueActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 31 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		i++;
															#line 168 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& r,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(r, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && r,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(r), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AllTrueActor*>(this)->actor_wait_state > 0) static_cast<AllTrueActor*>(this)->actor_wait_state = 0;
		static_cast<AllTrueActor*>(this)->ActorCallback< AllTrueActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< AllTrueActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("allTrue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AllTrueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("allTrue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AllTrueActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("allTrue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AllTrueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("allTrue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AllTrueActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("allTrue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AllTrueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("allTrue", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 25 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	std::vector<Future<bool>> all;
															#line 26 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	int i;
															#line 252 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
};
// This generated class is to be used only via allTrue()
															#line 25 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class AllTrueActor final : public Actor<bool>, public ActorCallback< AllTrueActor, 0, bool >, public FastAllocated<AllTrueActor>, public AllTrueActorState<AllTrueActor> {
															#line 257 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
	using FastAllocated<AllTrueActor>::operator new;
	using FastAllocated<AllTrueActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1138342058695179008UL, 14010712855206345216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AllTrueActor, 0, bool >;
															#line 25 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	AllTrueActor(std::vector<Future<bool>> const& all) 
															#line 274 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		 : Actor<bool>(),
		   AllTrueActorState<AllTrueActor>(all),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("allTrue", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7189173746046038528UL, 13173950247784048640UL);
		ActorExecutionContextHelper __helper(static_cast<AllTrueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("allTrue");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("allTrue", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AllTrueActor, 0, bool >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 25 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
[[nodiscard]] Future<bool> allTrue( std::vector<Future<bool>> const& all ) {
															#line 25 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	return Future<bool>(new AllTrueActor(all));
															#line 307 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
}

#line 35 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"

															#line 312 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
namespace {
// This generated class is to be used only via anyTrue()
															#line 36 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
template <class AnyTrueActor>
															#line 36 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class AnyTrueActorState {
															#line 319 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
															#line 36 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	AnyTrueActorState(std::vector<Reference<AsyncVar<bool>>> const& input,Reference<AsyncVar<bool>> const& output) 
															#line 36 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
															#line 36 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		 : input(input),
															#line 36 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   output(output)
															#line 328 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
	{
		fdb_probe_actor_create("anyTrue", reinterpret_cast<unsigned long>(this));

	}
	~AnyTrueActorState() 
	{
		fdb_probe_actor_destroy("anyTrue", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 37 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			;
															#line 343 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AnyTrueActorState();
		static_cast<AnyTrueActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 38 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		bool oneTrue = false;
															#line 39 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		std::vector<Future<Void>> changes;
															#line 40 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		for( auto it : input ) {
															#line 41 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			if (it->get())
															#line 379 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			{
															#line 42 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
				oneTrue = true;
															#line 383 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			}
															#line 43 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			changes.push_back(it->onChange());
															#line 387 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		}
															#line 45 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		output->set(oneTrue);
															#line 46 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		StrictFuture<Void> __when_expr_0 = waitForAny(changes);
															#line 46 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (static_cast<AnyTrueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 395 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<AnyTrueActor*>(this)->actor_wait_state = 1;
															#line 46 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AnyTrueActor, 0, Void >*>(static_cast<AnyTrueActor*>(this)));
															#line 400 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AnyTrueActor*>(this)->actor_wait_state > 0) static_cast<AnyTrueActor*>(this)->actor_wait_state = 0;
		static_cast<AnyTrueActor*>(this)->ActorCallback< AnyTrueActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AnyTrueActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("anyTrue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AnyTrueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyTrue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AnyTrueActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("anyTrue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AnyTrueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyTrue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AnyTrueActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("anyTrue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AnyTrueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyTrue", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 36 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	std::vector<Reference<AsyncVar<bool>>> input;
															#line 36 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	Reference<AsyncVar<bool>> output;
															#line 496 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
};
// This generated class is to be used only via anyTrue()
															#line 36 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class AnyTrueActor final : public Actor<Void>, public ActorCallback< AnyTrueActor, 0, Void >, public FastAllocated<AnyTrueActor>, public AnyTrueActorState<AnyTrueActor> {
															#line 501 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
	using FastAllocated<AnyTrueActor>::operator new;
	using FastAllocated<AnyTrueActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3599146064369279232UL, 3249817665351062528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AnyTrueActor, 0, Void >;
															#line 36 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	AnyTrueActor(std::vector<Reference<AsyncVar<bool>>> const& input,Reference<AsyncVar<bool>> const& output) 
															#line 518 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		 : Actor<Void>(),
		   AnyTrueActorState<AnyTrueActor>(input, output),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("anyTrue", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10875311714850722304UL, 943611906455639296UL);
		ActorExecutionContextHelper __helper(static_cast<AnyTrueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("anyTrue");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("anyTrue", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AnyTrueActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 36 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
[[nodiscard]] Future<Void> anyTrue( std::vector<Reference<AsyncVar<bool>>> const& input, Reference<AsyncVar<bool>> const& output ) {
															#line 36 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	return Future<Void>(new AnyTrueActor(input, output));
															#line 551 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
}

#line 49 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"

															#line 556 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
namespace {
// This generated class is to be used only via cancelOnly()
															#line 50 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
template <class CancelOnlyActor>
															#line 50 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class CancelOnlyActorState {
															#line 563 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
															#line 50 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	CancelOnlyActorState(std::vector<Future<Void>> const& futures) 
															#line 50 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
															#line 50 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		 : futures(futures)
															#line 570 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
	{
		fdb_probe_actor_create("cancelOnly", reinterpret_cast<unsigned long>(this));

	}
	~CancelOnlyActorState() 
	{
		fdb_probe_actor_destroy("cancelOnly", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 53 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Never();
															#line 53 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			if (static_cast<CancelOnlyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 587 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CancelOnlyActor*>(this)->actor_wait_state = 1;
															#line 53 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CancelOnlyActor, 0, Void >*>(static_cast<CancelOnlyActor*>(this)));
															#line 592 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CancelOnlyActorState();
		static_cast<CancelOnlyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 54 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!static_cast<CancelOnlyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CancelOnlyActorState(); static_cast<CancelOnlyActor*>(this)->destroy(); return 0; }
															#line 615 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		new (&static_cast<CancelOnlyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CancelOnlyActorState();
		static_cast<CancelOnlyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 54 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!static_cast<CancelOnlyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CancelOnlyActorState(); static_cast<CancelOnlyActor*>(this)->destroy(); return 0; }
															#line 627 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		new (&static_cast<CancelOnlyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CancelOnlyActorState();
		static_cast<CancelOnlyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CancelOnlyActor*>(this)->actor_wait_state > 0) static_cast<CancelOnlyActor*>(this)->actor_wait_state = 0;
		static_cast<CancelOnlyActor*>(this)->ActorCallback< CancelOnlyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CancelOnlyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cancelOnly", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelOnlyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelOnly", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CancelOnlyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cancelOnly", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelOnlyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelOnly", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CancelOnlyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cancelOnly", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CancelOnlyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelOnly", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 50 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	std::vector<Future<Void>> futures;
															#line 712 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
};
// This generated class is to be used only via cancelOnly()
															#line 50 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class CancelOnlyActor final : public Actor<Void>, public ActorCallback< CancelOnlyActor, 0, Void >, public FastAllocated<CancelOnlyActor>, public CancelOnlyActorState<CancelOnlyActor> {
															#line 717 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
	using FastAllocated<CancelOnlyActor>::operator new;
	using FastAllocated<CancelOnlyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3669315631288180480UL, 4598514797852819712UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CancelOnlyActor, 0, Void >;
															#line 50 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	CancelOnlyActor(std::vector<Future<Void>> const& futures) 
															#line 734 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		 : Actor<Void>(),
		   CancelOnlyActorState<CancelOnlyActor>(futures),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cancelOnly", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15523941007626945280UL, 6074127371030526464UL);
		ActorExecutionContextHelper __helper(static_cast<CancelOnlyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cancelOnly");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cancelOnly", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CancelOnlyActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 50 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
[[nodiscard]] Future<Void> cancelOnly( std::vector<Future<Void>> const& futures ) {
															#line 50 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	return Future<Void>(new CancelOnlyActor(futures));
															#line 767 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
}

#line 56 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"

															#line 772 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
namespace {
// This generated class is to be used only via timeoutWarningCollector()
															#line 57 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
template <class TimeoutWarningCollectorActor>
															#line 57 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class TimeoutWarningCollectorActorState {
															#line 779 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
															#line 57 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	TimeoutWarningCollectorActorState(FutureStream<Void> const& input,double const& logDelay,const char* const& context,UID const& id) 
															#line 57 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
															#line 57 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		 : input(input),
															#line 57 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   logDelay(logDelay),
															#line 57 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   context(context),
															#line 57 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   id(id),
															#line 58 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   counter(0),
															#line 59 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   end(delay(logDelay))
															#line 796 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
	{
		fdb_probe_actor_create("timeoutWarningCollector", reinterpret_cast<unsigned long>(this));

	}
	~TimeoutWarningCollectorActorState() 
	{
		fdb_probe_actor_destroy("timeoutWarningCollector", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 60 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			;
															#line 811 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TimeoutWarningCollectorActorState();
		static_cast<TimeoutWarningCollectorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 61 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		auto __when_expr_0 = input;
															#line 841 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<Void>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<Void>>::value, "invalid type");
															#line 60 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (static_cast<TimeoutWarningCollectorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 845 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 64 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		StrictFuture<Void> __when_expr_1 = end;
															#line 849 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<TimeoutWarningCollectorActor*>(this)->actor_wait_state = 1;
															#line 61 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< TimeoutWarningCollectorActor, 0, Void >*>(static_cast<TimeoutWarningCollectorActor*>(this)));
															#line 64 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TimeoutWarningCollectorActor, 1, Void >*>(static_cast<TimeoutWarningCollectorActor*>(this)));
															#line 856 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 62 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		counter++;
															#line 871 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 62 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		counter++;
															#line 880 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 65 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (counter)
															#line 889 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		{
															#line 66 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			TraceEvent(SevWarn, context, id).detail("LateProcessCount", counter).detail("LoggingDelay", logDelay);
															#line 893 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		}
															#line 67 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		end = delay(logDelay);
															#line 68 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		counter = 0;
															#line 899 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 65 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (counter)
															#line 908 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		{
															#line 66 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			TraceEvent(SevWarn, context, id).detail("LateProcessCount", counter).detail("LoggingDelay", logDelay);
															#line 912 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		}
															#line 67 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		end = delay(logDelay);
															#line 68 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		counter = 0;
															#line 918 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TimeoutWarningCollectorActor*>(this)->actor_wait_state > 0) static_cast<TimeoutWarningCollectorActor*>(this)->actor_wait_state = 0;
		static_cast<TimeoutWarningCollectorActor*>(this)->ActorSingleCallback< TimeoutWarningCollectorActor, 0, Void >::remove();
		static_cast<TimeoutWarningCollectorActor*>(this)->ActorCallback< TimeoutWarningCollectorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< TimeoutWarningCollectorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeoutWarningCollector", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutWarningCollectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutWarningCollector", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< TimeoutWarningCollectorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeoutWarningCollector", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutWarningCollectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutWarningCollector", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< TimeoutWarningCollectorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeoutWarningCollector", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutWarningCollectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutWarningCollector", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeoutWarningCollectorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeoutWarningCollector", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutWarningCollectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutWarningCollector", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TimeoutWarningCollectorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeoutWarningCollector", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutWarningCollectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutWarningCollector", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TimeoutWarningCollectorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeoutWarningCollector", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutWarningCollectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutWarningCollector", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 57 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	FutureStream<Void> input;
															#line 57 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	double logDelay;
															#line 57 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	const char* context;
															#line 57 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	UID id;
															#line 58 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	uint64_t counter;
															#line 59 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	Future<Void> end;
															#line 1056 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
};
// This generated class is to be used only via timeoutWarningCollector()
															#line 57 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class TimeoutWarningCollectorActor final : public Actor<Void>, public ActorSingleCallback< TimeoutWarningCollectorActor, 0, Void >, public ActorCallback< TimeoutWarningCollectorActor, 1, Void >, public FastAllocated<TimeoutWarningCollectorActor>, public TimeoutWarningCollectorActorState<TimeoutWarningCollectorActor> {
															#line 1061 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
	using FastAllocated<TimeoutWarningCollectorActor>::operator new;
	using FastAllocated<TimeoutWarningCollectorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9722088668984601600UL, 3928415507963383296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< TimeoutWarningCollectorActor, 0, Void >;
friend struct ActorCallback< TimeoutWarningCollectorActor, 1, Void >;
															#line 57 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	TimeoutWarningCollectorActor(FutureStream<Void> const& input,double const& logDelay,const char* const& context,UID const& id) 
															#line 1079 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		 : Actor<Void>(),
		   TimeoutWarningCollectorActorState<TimeoutWarningCollectorActor>(input, logDelay, context, id),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("timeoutWarningCollector", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11490253793827176960UL, 13060370156217959424UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutWarningCollectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("timeoutWarningCollector");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("timeoutWarningCollector", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< TimeoutWarningCollectorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 57 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
[[nodiscard]] Future<Void> timeoutWarningCollector( FutureStream<Void> const& input, double const& logDelay, const char* const& context, UID const& id ) {
															#line 57 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	return Future<Void>(new TimeoutWarningCollectorActor(input, logDelay, context, id));
															#line 1112 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
}

#line 72 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"

															#line 1117 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
namespace {
// This generated class is to be used only via waitForMost()
															#line 73 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
template <class WaitForMostActor>
															#line 73 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class WaitForMostActorState {
															#line 1124 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
															#line 73 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	WaitForMostActorState(std::vector<Future<ErrorOr<Void>>> const& futures,int const& faultTolerance,Error const& e,double const& waitMultiplierForSlowFutures) 
															#line 73 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
															#line 73 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		 : futures(futures),
															#line 73 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   faultTolerance(faultTolerance),
															#line 73 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   e(e),
															#line 73 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   waitMultiplierForSlowFutures(waitMultiplierForSlowFutures),
															#line 77 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   successFutures(),
															#line 78 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   startTime(now())
															#line 1141 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
	{
		fdb_probe_actor_create("waitForMost", reinterpret_cast<unsigned long>(this));

	}
	~WaitForMostActorState() 
	{
		fdb_probe_actor_destroy("waitForMost", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 79 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			successFutures.reserve(futures.size());
															#line 80 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			for( const auto& future : futures ) {
															#line 81 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
				successFutures.push_back(fmap([](auto const& result) { return result.present(); }, future));
															#line 1160 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			}
															#line 83 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			StrictFuture<bool> __when_expr_0 = quorumEqualsTrue(successFutures, successFutures.size() - faultTolerance);
															#line 83 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			if (static_cast<WaitForMostActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1166 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WaitForMostActor*>(this)->actor_wait_state = 1;
															#line 83 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForMostActor, 0, bool >*>(static_cast<WaitForMostActor*>(this)));
															#line 1171 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForMostActorState();
		static_cast<WaitForMostActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& success,int loopDepth) 
	{
															#line 84 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!success)
															#line 1194 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		{
															#line 85 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 1198 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		}
															#line 87 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay((now() - startTime) * waitMultiplierForSlowFutures) || waitForAll(successFutures);
															#line 87 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (static_cast<WaitForMostActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1204 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WaitForMostActor*>(this)->actor_wait_state = 2;
															#line 87 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForMostActor, 1, Void >*>(static_cast<WaitForMostActor*>(this)));
															#line 1209 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool && success,int loopDepth) 
	{
															#line 84 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!success)
															#line 1218 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		{
															#line 85 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 1222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		}
															#line 87 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay((now() - startTime) * waitMultiplierForSlowFutures) || waitForAll(successFutures);
															#line 87 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (static_cast<WaitForMostActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1228 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WaitForMostActor*>(this)->actor_wait_state = 2;
															#line 87 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForMostActor, 1, Void >*>(static_cast<WaitForMostActor*>(this)));
															#line 1233 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(bool const& success,int loopDepth) 
	{
		loopDepth = a_body1cont1(success, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && success,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(success), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForMostActor*>(this)->actor_wait_state > 0) static_cast<WaitForMostActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForMostActor*>(this)->ActorCallback< WaitForMostActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForMostActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("waitForMost", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForMostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForMost", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForMostActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("waitForMost", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForMostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForMost", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForMostActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("waitForMost", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForMostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForMost", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 88 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!static_cast<WaitForMostActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForMostActorState(); static_cast<WaitForMostActor*>(this)->destroy(); return 0; }
															#line 1317 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		new (&static_cast<WaitForMostActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitForMostActorState();
		static_cast<WaitForMostActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 88 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!static_cast<WaitForMostActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForMostActorState(); static_cast<WaitForMostActor*>(this)->destroy(); return 0; }
															#line 1329 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		new (&static_cast<WaitForMostActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitForMostActorState();
		static_cast<WaitForMostActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitForMostActor*>(this)->actor_wait_state > 0) static_cast<WaitForMostActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForMostActor*>(this)->ActorCallback< WaitForMostActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForMostActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForMost", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForMostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForMost", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitForMostActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForMost", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForMostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForMost", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitForMostActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForMost", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForMostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForMost", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 73 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	std::vector<Future<ErrorOr<Void>>> futures;
															#line 73 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	int faultTolerance;
															#line 73 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	Error e;
															#line 73 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	double waitMultiplierForSlowFutures;
															#line 77 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	std::vector<Future<bool>> successFutures;
															#line 78 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	double startTime;
															#line 1424 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
};
// This generated class is to be used only via waitForMost()
															#line 73 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class WaitForMostActor final : public Actor<Void>, public ActorCallback< WaitForMostActor, 0, bool >, public ActorCallback< WaitForMostActor, 1, Void >, public FastAllocated<WaitForMostActor>, public WaitForMostActorState<WaitForMostActor> {
															#line 1429 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
	using FastAllocated<WaitForMostActor>::operator new;
	using FastAllocated<WaitForMostActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(916238952433092096UL, 15073956100619260672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForMostActor, 0, bool >;
friend struct ActorCallback< WaitForMostActor, 1, Void >;
															#line 73 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	WaitForMostActor(std::vector<Future<ErrorOr<Void>>> const& futures,int const& faultTolerance,Error const& e,double const& waitMultiplierForSlowFutures) 
															#line 1447 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		 : Actor<Void>(),
		   WaitForMostActorState<WaitForMostActor>(futures, faultTolerance, e, waitMultiplierForSlowFutures),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForMost", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17372222770952750848UL, 4769225080473513984UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForMostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForMost");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForMost", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForMostActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitForMostActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 73 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
[[nodiscard]] Future<Void> waitForMost( std::vector<Future<ErrorOr<Void>>> const& futures, int const& faultTolerance, Error const& e, double const& waitMultiplierForSlowFutures ) {
															#line 73 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	return Future<Void>(new WaitForMostActor(futures, faultTolerance, e, waitMultiplierForSlowFutures));
															#line 1481 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
}

#line 90 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"

															#line 1486 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
namespace {
// This generated class is to be used only via quorumEqualsTrue()
															#line 91 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
template <class QuorumEqualsTrueActor>
															#line 91 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class QuorumEqualsTrueActorState {
															#line 1493 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
															#line 91 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	QuorumEqualsTrueActorState(std::vector<Future<bool>> const& futures,int const& required) 
															#line 91 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
															#line 91 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		 : futures(futures),
															#line 91 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   required(required),
															#line 92 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   true_futures(),
															#line 93 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   false_futures()
															#line 1506 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
	{
		fdb_probe_actor_create("quorumEqualsTrue", reinterpret_cast<unsigned long>(this));

	}
	~QuorumEqualsTrueActorState() 
	{
		fdb_probe_actor_destroy("quorumEqualsTrue", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 94 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			true_futures.reserve(futures.size());
															#line 95 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			false_futures.reserve(futures.size());
															#line 96 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			for(int i = 0;i < futures.size();i++) {
															#line 97 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
				true_futures.push_back(onEqual(futures[i], true));
															#line 98 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
				false_futures.push_back(onEqual(futures[i], false));
															#line 1529 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			}
															#line 102 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			StrictFuture<Void> __when_expr_0 = quorum(true_futures, required);
															#line 101 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			if (static_cast<QuorumEqualsTrueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1535 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 105 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			StrictFuture<Void> __when_expr_1 = quorum(false_futures, futures.size() - required + 1);
															#line 1539 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<QuorumEqualsTrueActor*>(this)->actor_wait_state = 1;
															#line 102 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< QuorumEqualsTrueActor, 0, Void >*>(static_cast<QuorumEqualsTrueActor*>(this)));
															#line 105 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< QuorumEqualsTrueActor, 1, Void >*>(static_cast<QuorumEqualsTrueActor*>(this)));
															#line 1546 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~QuorumEqualsTrueActorState();
		static_cast<QuorumEqualsTrueActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
															#line 103 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!static_cast<QuorumEqualsTrueActor*>(this)->SAV<bool>::futures) { (void)(true); this->~QuorumEqualsTrueActorState(); static_cast<QuorumEqualsTrueActor*>(this)->destroy(); return 0; }
															#line 1569 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		new (&static_cast<QuorumEqualsTrueActor*>(this)->SAV< bool >::value()) bool(true);
		this->~QuorumEqualsTrueActorState();
		static_cast<QuorumEqualsTrueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
															#line 103 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!static_cast<QuorumEqualsTrueActor*>(this)->SAV<bool>::futures) { (void)(true); this->~QuorumEqualsTrueActorState(); static_cast<QuorumEqualsTrueActor*>(this)->destroy(); return 0; }
															#line 1581 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		new (&static_cast<QuorumEqualsTrueActor*>(this)->SAV< bool >::value()) bool(true);
		this->~QuorumEqualsTrueActorState();
		static_cast<QuorumEqualsTrueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 106 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!static_cast<QuorumEqualsTrueActor*>(this)->SAV<bool>::futures) { (void)(false); this->~QuorumEqualsTrueActorState(); static_cast<QuorumEqualsTrueActor*>(this)->destroy(); return 0; }
															#line 1593 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		new (&static_cast<QuorumEqualsTrueActor*>(this)->SAV< bool >::value()) bool(false);
		this->~QuorumEqualsTrueActorState();
		static_cast<QuorumEqualsTrueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 106 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!static_cast<QuorumEqualsTrueActor*>(this)->SAV<bool>::futures) { (void)(false); this->~QuorumEqualsTrueActorState(); static_cast<QuorumEqualsTrueActor*>(this)->destroy(); return 0; }
															#line 1605 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		new (&static_cast<QuorumEqualsTrueActor*>(this)->SAV< bool >::value()) bool(false);
		this->~QuorumEqualsTrueActorState();
		static_cast<QuorumEqualsTrueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<QuorumEqualsTrueActor*>(this)->actor_wait_state > 0) static_cast<QuorumEqualsTrueActor*>(this)->actor_wait_state = 0;
		static_cast<QuorumEqualsTrueActor*>(this)->ActorCallback< QuorumEqualsTrueActor, 0, Void >::remove();
		static_cast<QuorumEqualsTrueActor*>(this)->ActorCallback< QuorumEqualsTrueActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< QuorumEqualsTrueActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("quorumEqualsTrue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QuorumEqualsTrueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quorumEqualsTrue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< QuorumEqualsTrueActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("quorumEqualsTrue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QuorumEqualsTrueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quorumEqualsTrue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< QuorumEqualsTrueActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("quorumEqualsTrue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<QuorumEqualsTrueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quorumEqualsTrue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< QuorumEqualsTrueActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("quorumEqualsTrue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QuorumEqualsTrueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quorumEqualsTrue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< QuorumEqualsTrueActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("quorumEqualsTrue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QuorumEqualsTrueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quorumEqualsTrue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< QuorumEqualsTrueActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("quorumEqualsTrue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<QuorumEqualsTrueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quorumEqualsTrue", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 91 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	std::vector<Future<bool>> futures;
															#line 91 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	int required;
															#line 92 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	std::vector<Future<Void>> true_futures;
															#line 93 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	std::vector<Future<Void>> false_futures;
															#line 1742 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
};
// This generated class is to be used only via quorumEqualsTrue()
															#line 91 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class QuorumEqualsTrueActor final : public Actor<bool>, public ActorCallback< QuorumEqualsTrueActor, 0, Void >, public ActorCallback< QuorumEqualsTrueActor, 1, Void >, public FastAllocated<QuorumEqualsTrueActor>, public QuorumEqualsTrueActorState<QuorumEqualsTrueActor> {
															#line 1747 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
	using FastAllocated<QuorumEqualsTrueActor>::operator new;
	using FastAllocated<QuorumEqualsTrueActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(129081360490096640UL, 16413743133754169600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< QuorumEqualsTrueActor, 0, Void >;
friend struct ActorCallback< QuorumEqualsTrueActor, 1, Void >;
															#line 91 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	QuorumEqualsTrueActor(std::vector<Future<bool>> const& futures,int const& required) 
															#line 1765 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		 : Actor<bool>(),
		   QuorumEqualsTrueActorState<QuorumEqualsTrueActor>(futures, required),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("quorumEqualsTrue", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16541746845745254656UL, 7221999343300293632UL);
		ActorExecutionContextHelper __helper(static_cast<QuorumEqualsTrueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("quorumEqualsTrue");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("quorumEqualsTrue", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< QuorumEqualsTrueActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 91 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
[[nodiscard]] Future<bool> quorumEqualsTrue( std::vector<Future<bool>> const& futures, int const& required ) {
															#line 91 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	return Future<bool>(new QuorumEqualsTrueActor(futures, required));
															#line 1798 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
}

#line 110 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"

															#line 1803 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
namespace {
// This generated class is to be used only via shortCircuitAny()
															#line 111 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
template <class ShortCircuitAnyActor>
															#line 111 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class ShortCircuitAnyActorState {
															#line 1810 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
															#line 111 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	ShortCircuitAnyActorState(std::vector<Future<bool>> const& f) 
															#line 111 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
															#line 111 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		 : f(f)
															#line 1817 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
	{
		fdb_probe_actor_create("shortCircuitAny", reinterpret_cast<unsigned long>(this));

	}
	~ShortCircuitAnyActorState() 
	{
		fdb_probe_actor_destroy("shortCircuitAny", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 112 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			std::vector<Future<Void>> sc;
															#line 113 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			sc.reserve(f.size());
															#line 114 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			for( Future<bool> fut : f ) {
															#line 115 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
				sc.push_back(returnIfTrue(fut));
															#line 1838 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			}
															#line 119 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(f);
															#line 118 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			if (static_cast<ShortCircuitAnyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1844 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 130 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			StrictFuture<Void> __when_expr_1 = waitForAny(sc);
															#line 1848 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<ShortCircuitAnyActor*>(this)->actor_wait_state = 1;
															#line 119 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ShortCircuitAnyActor, 0, Void >*>(static_cast<ShortCircuitAnyActor*>(this)));
															#line 130 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ShortCircuitAnyActor, 1, Void >*>(static_cast<ShortCircuitAnyActor*>(this)));
															#line 1855 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ShortCircuitAnyActorState();
		static_cast<ShortCircuitAnyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
															#line 123 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		for( const auto& fut : f ) {
															#line 124 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			if (fut.get())
															#line 1880 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			{
															#line 125 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
				if (!static_cast<ShortCircuitAnyActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ShortCircuitAnyActorState(); static_cast<ShortCircuitAnyActor*>(this)->destroy(); return 0; }
															#line 1884 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
				new (&static_cast<ShortCircuitAnyActor*>(this)->SAV< bool >::value()) bool(true);
				this->~ShortCircuitAnyActorState();
				static_cast<ShortCircuitAnyActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 128 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!static_cast<ShortCircuitAnyActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ShortCircuitAnyActorState(); static_cast<ShortCircuitAnyActor*>(this)->destroy(); return 0; }
															#line 1893 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		new (&static_cast<ShortCircuitAnyActor*>(this)->SAV< bool >::value()) bool(false);
		this->~ShortCircuitAnyActorState();
		static_cast<ShortCircuitAnyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
															#line 123 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		for( const auto& fut : f ) {
															#line 124 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			if (fut.get())
															#line 1907 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			{
															#line 125 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
				if (!static_cast<ShortCircuitAnyActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ShortCircuitAnyActorState(); static_cast<ShortCircuitAnyActor*>(this)->destroy(); return 0; }
															#line 1911 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
				new (&static_cast<ShortCircuitAnyActor*>(this)->SAV< bool >::value()) bool(true);
				this->~ShortCircuitAnyActorState();
				static_cast<ShortCircuitAnyActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 128 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!static_cast<ShortCircuitAnyActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ShortCircuitAnyActorState(); static_cast<ShortCircuitAnyActor*>(this)->destroy(); return 0; }
															#line 1920 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		new (&static_cast<ShortCircuitAnyActor*>(this)->SAV< bool >::value()) bool(false);
		this->~ShortCircuitAnyActorState();
		static_cast<ShortCircuitAnyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 131 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!static_cast<ShortCircuitAnyActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ShortCircuitAnyActorState(); static_cast<ShortCircuitAnyActor*>(this)->destroy(); return 0; }
															#line 1932 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		new (&static_cast<ShortCircuitAnyActor*>(this)->SAV< bool >::value()) bool(true);
		this->~ShortCircuitAnyActorState();
		static_cast<ShortCircuitAnyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 131 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!static_cast<ShortCircuitAnyActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ShortCircuitAnyActorState(); static_cast<ShortCircuitAnyActor*>(this)->destroy(); return 0; }
															#line 1944 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		new (&static_cast<ShortCircuitAnyActor*>(this)->SAV< bool >::value()) bool(true);
		this->~ShortCircuitAnyActorState();
		static_cast<ShortCircuitAnyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ShortCircuitAnyActor*>(this)->actor_wait_state > 0) static_cast<ShortCircuitAnyActor*>(this)->actor_wait_state = 0;
		static_cast<ShortCircuitAnyActor*>(this)->ActorCallback< ShortCircuitAnyActor, 0, Void >::remove();
		static_cast<ShortCircuitAnyActor*>(this)->ActorCallback< ShortCircuitAnyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShortCircuitAnyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shortCircuitAny", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShortCircuitAnyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shortCircuitAny", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ShortCircuitAnyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shortCircuitAny", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShortCircuitAnyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shortCircuitAny", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ShortCircuitAnyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shortCircuitAny", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShortCircuitAnyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shortCircuitAny", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ShortCircuitAnyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shortCircuitAny", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShortCircuitAnyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shortCircuitAny", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ShortCircuitAnyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shortCircuitAny", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShortCircuitAnyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shortCircuitAny", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ShortCircuitAnyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shortCircuitAny", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShortCircuitAnyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shortCircuitAny", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 111 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	std::vector<Future<bool>> f;
															#line 2075 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
};
// This generated class is to be used only via shortCircuitAny()
															#line 111 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class ShortCircuitAnyActor final : public Actor<bool>, public ActorCallback< ShortCircuitAnyActor, 0, Void >, public ActorCallback< ShortCircuitAnyActor, 1, Void >, public FastAllocated<ShortCircuitAnyActor>, public ShortCircuitAnyActorState<ShortCircuitAnyActor> {
															#line 2080 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
	using FastAllocated<ShortCircuitAnyActor>::operator new;
	using FastAllocated<ShortCircuitAnyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11289532956388669952UL, 4461283346305289728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ShortCircuitAnyActor, 0, Void >;
friend struct ActorCallback< ShortCircuitAnyActor, 1, Void >;
															#line 111 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	ShortCircuitAnyActor(std::vector<Future<bool>> const& f) 
															#line 2098 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		 : Actor<bool>(),
		   ShortCircuitAnyActorState<ShortCircuitAnyActor>(f),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("shortCircuitAny", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2378236156450593792UL, 13214904227269367808UL);
		ActorExecutionContextHelper __helper(static_cast<ShortCircuitAnyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("shortCircuitAny");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("shortCircuitAny", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ShortCircuitAnyActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 111 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
[[nodiscard]] Future<bool> shortCircuitAny( std::vector<Future<bool>> const& f ) {
															#line 111 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	return Future<bool>(new ShortCircuitAnyActor(f));
															#line 2131 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
}

#line 135 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"

Future<Void> orYield(Future<Void> f) {
	if (f.isReady()) {
		if (f.isError())
			return tagError<Void>(yield(), f.getError());
		else
			return yield();
	} else
		return f;
}

															#line 2146 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
namespace {
// This generated class is to be used only via returnIfTrue()
															#line 146 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
template <class ReturnIfTrueActor>
															#line 146 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class ReturnIfTrueActorState {
															#line 2153 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
															#line 146 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	ReturnIfTrueActorState(Future<bool> const& f) 
															#line 146 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
															#line 146 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		 : f(f)
															#line 2160 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
	{
		fdb_probe_actor_create("returnIfTrue", reinterpret_cast<unsigned long>(this));

	}
	~ReturnIfTrueActorState() 
	{
		fdb_probe_actor_destroy("returnIfTrue", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 147 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			StrictFuture<bool> __when_expr_0 = f;
															#line 147 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			if (static_cast<ReturnIfTrueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2177 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReturnIfTrueActor*>(this)->actor_wait_state = 1;
															#line 147 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReturnIfTrueActor, 0, bool >*>(static_cast<ReturnIfTrueActor*>(this)));
															#line 2182 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReturnIfTrueActorState();
		static_cast<ReturnIfTrueActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& b,int loopDepth) 
	{
															#line 148 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (b)
															#line 2205 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		{
															#line 149 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			if (!static_cast<ReturnIfTrueActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReturnIfTrueActorState(); static_cast<ReturnIfTrueActor*>(this)->destroy(); return 0; }
															#line 2209 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			new (&static_cast<ReturnIfTrueActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ReturnIfTrueActorState();
			static_cast<ReturnIfTrueActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 151 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		StrictFuture<Void> __when_expr_1 = Never();
															#line 151 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (static_cast<ReturnIfTrueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2219 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReturnIfTrueActor*>(this)->actor_wait_state = 2;
															#line 151 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReturnIfTrueActor, 1, Void >*>(static_cast<ReturnIfTrueActor*>(this)));
															#line 2224 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool && b,int loopDepth) 
	{
															#line 148 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (b)
															#line 2233 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		{
															#line 149 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			if (!static_cast<ReturnIfTrueActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReturnIfTrueActorState(); static_cast<ReturnIfTrueActor*>(this)->destroy(); return 0; }
															#line 2237 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			new (&static_cast<ReturnIfTrueActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ReturnIfTrueActorState();
			static_cast<ReturnIfTrueActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 151 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		StrictFuture<Void> __when_expr_1 = Never();
															#line 151 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (static_cast<ReturnIfTrueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2247 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReturnIfTrueActor*>(this)->actor_wait_state = 2;
															#line 151 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReturnIfTrueActor, 1, Void >*>(static_cast<ReturnIfTrueActor*>(this)));
															#line 2252 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(bool const& b,int loopDepth) 
	{
		loopDepth = a_body1cont1(b, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && b,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(b), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReturnIfTrueActor*>(this)->actor_wait_state > 0) static_cast<ReturnIfTrueActor*>(this)->actor_wait_state = 0;
		static_cast<ReturnIfTrueActor*>(this)->ActorCallback< ReturnIfTrueActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ReturnIfTrueActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("returnIfTrue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReturnIfTrueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("returnIfTrue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReturnIfTrueActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("returnIfTrue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReturnIfTrueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("returnIfTrue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReturnIfTrueActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("returnIfTrue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReturnIfTrueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("returnIfTrue", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 152 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 2336 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 152 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 2344 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReturnIfTrueActor*>(this)->actor_wait_state > 0) static_cast<ReturnIfTrueActor*>(this)->actor_wait_state = 0;
		static_cast<ReturnIfTrueActor*>(this)->ActorCallback< ReturnIfTrueActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReturnIfTrueActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("returnIfTrue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReturnIfTrueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("returnIfTrue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReturnIfTrueActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("returnIfTrue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReturnIfTrueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("returnIfTrue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReturnIfTrueActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("returnIfTrue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReturnIfTrueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("returnIfTrue", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 146 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	Future<bool> f;
															#line 2425 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
};
// This generated class is to be used only via returnIfTrue()
															#line 146 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class ReturnIfTrueActor final : public Actor<Void>, public ActorCallback< ReturnIfTrueActor, 0, bool >, public ActorCallback< ReturnIfTrueActor, 1, Void >, public FastAllocated<ReturnIfTrueActor>, public ReturnIfTrueActorState<ReturnIfTrueActor> {
															#line 2430 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
	using FastAllocated<ReturnIfTrueActor>::operator new;
	using FastAllocated<ReturnIfTrueActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16047809578758391552UL, 11533027513096457984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReturnIfTrueActor, 0, bool >;
friend struct ActorCallback< ReturnIfTrueActor, 1, Void >;
															#line 146 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	ReturnIfTrueActor(Future<bool> const& f) 
															#line 2448 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		 : Actor<Void>(),
		   ReturnIfTrueActorState<ReturnIfTrueActor>(f),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("returnIfTrue", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13503475436224705536UL, 1602539062077328896UL);
		ActorExecutionContextHelper __helper(static_cast<ReturnIfTrueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("returnIfTrue");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("returnIfTrue", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReturnIfTrueActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReturnIfTrueActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 146 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
[[nodiscard]] Future<Void> returnIfTrue( Future<bool> const& f ) {
															#line 146 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	return Future<Void>(new ReturnIfTrueActor(f));
															#line 2482 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
}

#line 154 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"

															#line 2487 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
namespace {
// This generated class is to be used only via lowPriorityDelay()
															#line 155 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
template <class LowPriorityDelayActor>
															#line 155 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class LowPriorityDelayActorState {
															#line 2494 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
															#line 155 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	LowPriorityDelayActorState(double const& waitTime) 
															#line 155 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
															#line 155 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		 : waitTime(waitTime),
															#line 156 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   loopCount(0),
															#line 157 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   totalLoops(std::max<int>(waitTime / FLOW_KNOBS->LOW_PRIORITY_MAX_DELAY, FLOW_KNOBS->LOW_PRIORITY_DELAY_COUNT))
															#line 2505 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
	{
		fdb_probe_actor_create("lowPriorityDelay", reinterpret_cast<unsigned long>(this));

	}
	~LowPriorityDelayActorState() 
	{
		fdb_probe_actor_destroy("lowPriorityDelay", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 160 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			;
															#line 2520 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LowPriorityDelayActorState();
		static_cast<LowPriorityDelayActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 164 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!static_cast<LowPriorityDelayActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LowPriorityDelayActorState(); static_cast<LowPriorityDelayActor*>(this)->destroy(); return 0; }
															#line 2543 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		new (&static_cast<LowPriorityDelayActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LowPriorityDelayActorState();
		static_cast<LowPriorityDelayActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 160 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!(loopCount < totalLoops))
															#line 2562 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 161 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(waitTime / totalLoops, TaskPriority::Low);
															#line 161 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (static_cast<LowPriorityDelayActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2570 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<LowPriorityDelayActor*>(this)->actor_wait_state = 1;
															#line 161 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LowPriorityDelayActor, 0, Void >*>(static_cast<LowPriorityDelayActor*>(this)));
															#line 2575 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 162 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		loopCount++;
															#line 2597 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 162 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		loopCount++;
															#line 2606 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LowPriorityDelayActor*>(this)->actor_wait_state > 0) static_cast<LowPriorityDelayActor*>(this)->actor_wait_state = 0;
		static_cast<LowPriorityDelayActor*>(this)->ActorCallback< LowPriorityDelayActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LowPriorityDelayActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lowPriorityDelay", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LowPriorityDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lowPriorityDelay", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LowPriorityDelayActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lowPriorityDelay", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LowPriorityDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lowPriorityDelay", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LowPriorityDelayActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lowPriorityDelay", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LowPriorityDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lowPriorityDelay", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 155 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	double waitTime;
															#line 156 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	int loopCount;
															#line 157 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	int totalLoops;
															#line 2692 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
};
// This generated class is to be used only via lowPriorityDelay()
															#line 155 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class LowPriorityDelayActor final : public Actor<Void>, public ActorCallback< LowPriorityDelayActor, 0, Void >, public FastAllocated<LowPriorityDelayActor>, public LowPriorityDelayActorState<LowPriorityDelayActor> {
															#line 2697 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
	using FastAllocated<LowPriorityDelayActor>::operator new;
	using FastAllocated<LowPriorityDelayActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12633476524891649792UL, 13375328814775271936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LowPriorityDelayActor, 0, Void >;
															#line 155 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	LowPriorityDelayActor(double const& waitTime) 
															#line 2714 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		 : Actor<Void>(),
		   LowPriorityDelayActorState<LowPriorityDelayActor>(waitTime),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("lowPriorityDelay", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6964124770601332992UL, 9412501736838146816UL);
		ActorExecutionContextHelper __helper(static_cast<LowPriorityDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("lowPriorityDelay");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("lowPriorityDelay", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LowPriorityDelayActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 155 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
[[nodiscard]] Future<Void> lowPriorityDelay( double const& waitTime ) {
															#line 155 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	return Future<Void>(new LowPriorityDelayActor(waitTime));
															#line 2747 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
}

#line 166 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"

															#line 2752 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
namespace {
// This generated class is to be used only via delayAfterCleared()
															#line 167 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
template <class DelayAfterClearedActor>
															#line 167 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class DelayAfterClearedActorState {
															#line 2759 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
															#line 167 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	DelayAfterClearedActorState(Reference<AsyncVar<bool>> const& condition,double const& time,TaskPriority const& taskID) 
															#line 167 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
															#line 167 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		 : condition(condition),
															#line 167 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   time(time),
															#line 167 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   taskID(taskID),
															#line 168 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   timer(condition->get() ? Never() : delay(time, taskID)),
															#line 169 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   previousState(condition->get())
															#line 2774 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
	{
		fdb_probe_actor_create("delayAfterCleared", reinterpret_cast<unsigned long>(this));

	}
	~DelayAfterClearedActorState() 
	{
		fdb_probe_actor_destroy("delayAfterCleared", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 170 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			;
															#line 2789 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DelayAfterClearedActorState();
		static_cast<DelayAfterClearedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 171 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		StrictFuture<Void> __when_expr_0 = timer;
															#line 170 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (static_cast<DelayAfterClearedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2821 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 174 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		StrictFuture<Void> __when_expr_1 = condition->onChange();
															#line 2825 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<DelayAfterClearedActor*>(this)->actor_wait_state = 1;
															#line 171 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DelayAfterClearedActor, 0, Void >*>(static_cast<DelayAfterClearedActor*>(this)));
															#line 174 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DelayAfterClearedActor, 1, Void >*>(static_cast<DelayAfterClearedActor*>(this)));
															#line 2832 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 172 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!static_cast<DelayAfterClearedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DelayAfterClearedActorState(); static_cast<DelayAfterClearedActor*>(this)->destroy(); return 0; }
															#line 2847 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		new (&static_cast<DelayAfterClearedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DelayAfterClearedActorState();
		static_cast<DelayAfterClearedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 172 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!static_cast<DelayAfterClearedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DelayAfterClearedActorState(); static_cast<DelayAfterClearedActor*>(this)->destroy(); return 0; }
															#line 2859 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		new (&static_cast<DelayAfterClearedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DelayAfterClearedActorState();
		static_cast<DelayAfterClearedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 175 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		bool currentState = condition->get();
															#line 176 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (currentState != previousState)
															#line 2873 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		{
															#line 177 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			timer = currentState ? Never() : delay(time, taskID);
															#line 178 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			previousState = currentState;
															#line 2879 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 175 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		bool currentState = condition->get();
															#line 176 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (currentState != previousState)
															#line 2891 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		{
															#line 177 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			timer = currentState ? Never() : delay(time, taskID);
															#line 178 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			previousState = currentState;
															#line 2897 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DelayAfterClearedActor*>(this)->actor_wait_state > 0) static_cast<DelayAfterClearedActor*>(this)->actor_wait_state = 0;
		static_cast<DelayAfterClearedActor*>(this)->ActorCallback< DelayAfterClearedActor, 0, Void >::remove();
		static_cast<DelayAfterClearedActor*>(this)->ActorCallback< DelayAfterClearedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DelayAfterClearedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("delayAfterCleared", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DelayAfterClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayAfterCleared", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DelayAfterClearedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("delayAfterCleared", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DelayAfterClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayAfterCleared", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DelayAfterClearedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("delayAfterCleared", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DelayAfterClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayAfterCleared", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DelayAfterClearedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("delayAfterCleared", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DelayAfterClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayAfterCleared", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DelayAfterClearedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("delayAfterCleared", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DelayAfterClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayAfterCleared", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DelayAfterClearedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("delayAfterCleared", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DelayAfterClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayAfterCleared", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 167 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	Reference<AsyncVar<bool>> condition;
															#line 167 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	double time;
															#line 167 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	TaskPriority taskID;
															#line 168 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	Future<Void> timer;
															#line 169 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	bool previousState;
															#line 3034 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
};
// This generated class is to be used only via delayAfterCleared()
															#line 167 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class DelayAfterClearedActor final : public Actor<Void>, public ActorCallback< DelayAfterClearedActor, 0, Void >, public ActorCallback< DelayAfterClearedActor, 1, Void >, public FastAllocated<DelayAfterClearedActor>, public DelayAfterClearedActorState<DelayAfterClearedActor> {
															#line 3039 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
	using FastAllocated<DelayAfterClearedActor>::operator new;
	using FastAllocated<DelayAfterClearedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(453207022214942464UL, 1588128006003549440UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DelayAfterClearedActor, 0, Void >;
friend struct ActorCallback< DelayAfterClearedActor, 1, Void >;
															#line 167 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	DelayAfterClearedActor(Reference<AsyncVar<bool>> const& condition,double const& time,TaskPriority const& taskID) 
															#line 3057 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		 : Actor<Void>(),
		   DelayAfterClearedActorState<DelayAfterClearedActor>(condition, time, taskID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("delayAfterCleared", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6768784054106552064UL, 13813701722770179584UL);
		ActorExecutionContextHelper __helper(static_cast<DelayAfterClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("delayAfterCleared");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("delayAfterCleared", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DelayAfterClearedActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 167 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
[[nodiscard]] Future<Void> delayAfterCleared( Reference<AsyncVar<bool>> const& condition, double const& time, TaskPriority const& taskID ) {
															#line 167 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	return Future<Void>(new DelayAfterClearedActor(condition, time, taskID));
															#line 3090 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
}

#line 183 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"

// Same as delayAfterCleared, but use lowPriorityDelay.
															#line 3096 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
namespace {
// This generated class is to be used only via lowPriorityDelayAfterCleared()
															#line 185 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
template <class LowPriorityDelayAfterClearedActor>
															#line 185 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class LowPriorityDelayAfterClearedActorState {
															#line 3103 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
															#line 185 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	LowPriorityDelayAfterClearedActorState(Reference<AsyncVar<bool>> const& condition,double const& time) 
															#line 185 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
															#line 185 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		 : condition(condition),
															#line 185 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   time(time),
															#line 186 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   timer(condition->get() ? Never() : lowPriorityDelay(time)),
															#line 187 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   previousState(condition->get())
															#line 3116 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
	{
		fdb_probe_actor_create("lowPriorityDelayAfterCleared", reinterpret_cast<unsigned long>(this));

	}
	~LowPriorityDelayAfterClearedActorState() 
	{
		fdb_probe_actor_destroy("lowPriorityDelayAfterCleared", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 188 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			;
															#line 3131 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LowPriorityDelayAfterClearedActorState();
		static_cast<LowPriorityDelayAfterClearedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 189 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		StrictFuture<Void> __when_expr_0 = timer;
															#line 188 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (static_cast<LowPriorityDelayAfterClearedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3163 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 192 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		StrictFuture<Void> __when_expr_1 = condition->onChange();
															#line 3167 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<LowPriorityDelayAfterClearedActor*>(this)->actor_wait_state = 1;
															#line 189 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LowPriorityDelayAfterClearedActor, 0, Void >*>(static_cast<LowPriorityDelayAfterClearedActor*>(this)));
															#line 192 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LowPriorityDelayAfterClearedActor, 1, Void >*>(static_cast<LowPriorityDelayAfterClearedActor*>(this)));
															#line 3174 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 190 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!static_cast<LowPriorityDelayAfterClearedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LowPriorityDelayAfterClearedActorState(); static_cast<LowPriorityDelayAfterClearedActor*>(this)->destroy(); return 0; }
															#line 3189 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		new (&static_cast<LowPriorityDelayAfterClearedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LowPriorityDelayAfterClearedActorState();
		static_cast<LowPriorityDelayAfterClearedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 190 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!static_cast<LowPriorityDelayAfterClearedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LowPriorityDelayAfterClearedActorState(); static_cast<LowPriorityDelayAfterClearedActor*>(this)->destroy(); return 0; }
															#line 3201 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		new (&static_cast<LowPriorityDelayAfterClearedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LowPriorityDelayAfterClearedActorState();
		static_cast<LowPriorityDelayAfterClearedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 193 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		bool currentState = condition->get();
															#line 194 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (currentState != previousState)
															#line 3215 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		{
															#line 195 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			timer = currentState ? Never() : lowPriorityDelay(time);
															#line 196 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			previousState = currentState;
															#line 3221 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 193 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		bool currentState = condition->get();
															#line 194 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (currentState != previousState)
															#line 3233 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		{
															#line 195 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			timer = currentState ? Never() : lowPriorityDelay(time);
															#line 196 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			previousState = currentState;
															#line 3239 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LowPriorityDelayAfterClearedActor*>(this)->actor_wait_state > 0) static_cast<LowPriorityDelayAfterClearedActor*>(this)->actor_wait_state = 0;
		static_cast<LowPriorityDelayAfterClearedActor*>(this)->ActorCallback< LowPriorityDelayAfterClearedActor, 0, Void >::remove();
		static_cast<LowPriorityDelayAfterClearedActor*>(this)->ActorCallback< LowPriorityDelayAfterClearedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LowPriorityDelayAfterClearedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lowPriorityDelayAfterCleared", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LowPriorityDelayAfterClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lowPriorityDelayAfterCleared", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LowPriorityDelayAfterClearedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lowPriorityDelayAfterCleared", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LowPriorityDelayAfterClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lowPriorityDelayAfterCleared", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LowPriorityDelayAfterClearedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lowPriorityDelayAfterCleared", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LowPriorityDelayAfterClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lowPriorityDelayAfterCleared", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LowPriorityDelayAfterClearedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lowPriorityDelayAfterCleared", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LowPriorityDelayAfterClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lowPriorityDelayAfterCleared", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LowPriorityDelayAfterClearedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lowPriorityDelayAfterCleared", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LowPriorityDelayAfterClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lowPriorityDelayAfterCleared", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LowPriorityDelayAfterClearedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lowPriorityDelayAfterCleared", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LowPriorityDelayAfterClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lowPriorityDelayAfterCleared", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 185 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	Reference<AsyncVar<bool>> condition;
															#line 185 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	double time;
															#line 186 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	Future<Void> timer;
															#line 187 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	bool previousState;
															#line 3374 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
};
// This generated class is to be used only via lowPriorityDelayAfterCleared()
															#line 185 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class LowPriorityDelayAfterClearedActor final : public Actor<Void>, public ActorCallback< LowPriorityDelayAfterClearedActor, 0, Void >, public ActorCallback< LowPriorityDelayAfterClearedActor, 1, Void >, public FastAllocated<LowPriorityDelayAfterClearedActor>, public LowPriorityDelayAfterClearedActorState<LowPriorityDelayAfterClearedActor> {
															#line 3379 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
	using FastAllocated<LowPriorityDelayAfterClearedActor>::operator new;
	using FastAllocated<LowPriorityDelayAfterClearedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15364226380077475840UL, 9093903316928338688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LowPriorityDelayAfterClearedActor, 0, Void >;
friend struct ActorCallback< LowPriorityDelayAfterClearedActor, 1, Void >;
															#line 185 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	LowPriorityDelayAfterClearedActor(Reference<AsyncVar<bool>> const& condition,double const& time) 
															#line 3397 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		 : Actor<Void>(),
		   LowPriorityDelayAfterClearedActorState<LowPriorityDelayAfterClearedActor>(condition, time),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("lowPriorityDelayAfterCleared", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13404726083648391424UL, 17870539835434748160UL);
		ActorExecutionContextHelper __helper(static_cast<LowPriorityDelayAfterClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("lowPriorityDelayAfterCleared");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("lowPriorityDelayAfterCleared", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LowPriorityDelayAfterClearedActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 185 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
[[nodiscard]] Future<Void> lowPriorityDelayAfterCleared( Reference<AsyncVar<bool>> const& condition, double const& time ) {
															#line 185 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	return Future<Void>(new LowPriorityDelayAfterClearedActor(condition, time));
															#line 3430 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
}

#line 201 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"

namespace {

struct DummyState {
	int changed{ 0 };
	int unchanged{ 0 };
	bool operator==(DummyState const& rhs) const { return changed == rhs.changed && unchanged == rhs.unchanged; }
	bool operator!=(DummyState const& rhs) const { return !(*this == rhs); }
};

															#line 3444 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
// This generated class is to be used only via testPublisher()
															#line 211 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
template <class TestPublisherActor>
															#line 211 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class TestPublisherActorState {
															#line 3450 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
															#line 211 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	TestPublisherActorState(Reference<AsyncVar<DummyState>> const& input) 
															#line 211 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
															#line 211 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		 : input(input),
															#line 212 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   i(0)
															#line 3459 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
	{
		fdb_probe_actor_create("testPublisher", reinterpret_cast<unsigned long>(this));

	}
	~TestPublisherActorState() 
	{
		fdb_probe_actor_destroy("testPublisher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 213 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			;
															#line 3474 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestPublisherActorState();
		static_cast<TestPublisherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 219 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!static_cast<TestPublisherActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestPublisherActorState(); static_cast<TestPublisherActor*>(this)->destroy(); return 0; }
															#line 3497 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		new (&static_cast<TestPublisherActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestPublisherActorState();
		static_cast<TestPublisherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 213 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!(i < 100))
															#line 3516 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 214 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(deterministicRandom()->random01());
															#line 214 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (static_cast<TestPublisherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3524 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TestPublisherActor*>(this)->actor_wait_state = 1;
															#line 214 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestPublisherActor, 0, Void >*>(static_cast<TestPublisherActor*>(this)));
															#line 3529 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 215 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		auto var = input->get();
															#line 216 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		++var.changed;
															#line 217 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		input->set(var);
															#line 213 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		++i;
															#line 3557 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 215 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		auto var = input->get();
															#line 216 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		++var.changed;
															#line 217 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		input->set(var);
															#line 213 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		++i;
															#line 3572 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestPublisherActor*>(this)->actor_wait_state > 0) static_cast<TestPublisherActor*>(this)->actor_wait_state = 0;
		static_cast<TestPublisherActor*>(this)->ActorCallback< TestPublisherActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestPublisherActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testPublisher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestPublisherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testPublisher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestPublisherActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testPublisher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestPublisherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testPublisher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestPublisherActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testPublisher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestPublisherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testPublisher", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 211 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	Reference<AsyncVar<DummyState>> input;
															#line 212 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	int i;
															#line 3656 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
};
// This generated class is to be used only via testPublisher()
															#line 211 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class TestPublisherActor final : public Actor<Void>, public ActorCallback< TestPublisherActor, 0, Void >, public FastAllocated<TestPublisherActor>, public TestPublisherActorState<TestPublisherActor> {
															#line 3661 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
	using FastAllocated<TestPublisherActor>::operator new;
	using FastAllocated<TestPublisherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8216607464069093888UL, 17603197644659465728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestPublisherActor, 0, Void >;
															#line 211 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	TestPublisherActor(Reference<AsyncVar<DummyState>> const& input) 
															#line 3678 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		 : Actor<Void>(),
		   TestPublisherActorState<TestPublisherActor>(input),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testPublisher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8410825004752377088UL, 14821281430137113856UL);
		ActorExecutionContextHelper __helper(static_cast<TestPublisherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testPublisher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testPublisher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestPublisherActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 211 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
[[nodiscard]] Future<Void> testPublisher( Reference<AsyncVar<DummyState>> const& input ) {
															#line 211 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	return Future<Void>(new TestPublisherActor(input));
															#line 3710 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
}

#line 221 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"

															#line 3715 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
// This generated class is to be used only via testSubscriber()
															#line 222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
template <class TestSubscriberActor>
															#line 222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class TestSubscriberActorState {
															#line 3721 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
															#line 222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	TestSubscriberActorState(Reference<IAsyncListener<int>> const& output,Optional<int> const& expected) 
															#line 222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
															#line 222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		 : output(output),
															#line 222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   expected(expected)
															#line 3730 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
	{
		fdb_probe_actor_create("testSubscriber", reinterpret_cast<unsigned long>(this));

	}
	~TestSubscriberActorState() 
	{
		fdb_probe_actor_destroy("testSubscriber", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 223 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			;
															#line 3745 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestSubscriberActorState();
		static_cast<TestSubscriberActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 224 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		StrictFuture<Void> __when_expr_0 = output->onChange();
															#line 224 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (static_cast<TestSubscriberActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3777 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TestSubscriberActor*>(this)->actor_wait_state = 1;
															#line 224 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestSubscriberActor, 0, Void >*>(static_cast<TestSubscriberActor*>(this)));
															#line 3782 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 225 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		ASSERT(expected.present());
															#line 226 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (output->get() == expected.get())
															#line 3793 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		{
															#line 227 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			if (!static_cast<TestSubscriberActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestSubscriberActorState(); static_cast<TestSubscriberActor*>(this)->destroy(); return 0; }
															#line 3797 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			new (&static_cast<TestSubscriberActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TestSubscriberActorState();
			static_cast<TestSubscriberActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 225 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		ASSERT(expected.present());
															#line 226 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (output->get() == expected.get())
															#line 3813 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		{
															#line 227 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			if (!static_cast<TestSubscriberActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestSubscriberActorState(); static_cast<TestSubscriberActor*>(this)->destroy(); return 0; }
															#line 3817 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			new (&static_cast<TestSubscriberActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TestSubscriberActorState();
			static_cast<TestSubscriberActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestSubscriberActor*>(this)->actor_wait_state > 0) static_cast<TestSubscriberActor*>(this)->actor_wait_state = 0;
		static_cast<TestSubscriberActor*>(this)->ActorCallback< TestSubscriberActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSubscriberActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSubscriber", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSubscriberActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSubscriber", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestSubscriberActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSubscriber", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSubscriberActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSubscriber", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestSubscriberActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSubscriber", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSubscriberActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSubscriber", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	Reference<IAsyncListener<int>> output;
															#line 222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	Optional<int> expected;
															#line 3906 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
};
// This generated class is to be used only via testSubscriber()
															#line 222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class TestSubscriberActor final : public Actor<Void>, public ActorCallback< TestSubscriberActor, 0, Void >, public FastAllocated<TestSubscriberActor>, public TestSubscriberActorState<TestSubscriberActor> {
															#line 3911 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
	using FastAllocated<TestSubscriberActor>::operator new;
	using FastAllocated<TestSubscriberActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14640039373483713024UL, 15436960764993757952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestSubscriberActor, 0, Void >;
															#line 222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	TestSubscriberActor(Reference<IAsyncListener<int>> const& output,Optional<int> const& expected) 
															#line 3928 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		 : Actor<Void>(),
		   TestSubscriberActorState<TestSubscriberActor>(output, expected),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testSubscriber", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7946754385693061120UL, 2419321222358514688UL);
		ActorExecutionContextHelper __helper(static_cast<TestSubscriberActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testSubscriber");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testSubscriber", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestSubscriberActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
[[nodiscard]] Future<Void> testSubscriber( Reference<IAsyncListener<int>> const& output, Optional<int> const& expected ) {
															#line 222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	return Future<Void>(new TestSubscriberActor(output, expected));
															#line 3960 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
}

#line 231 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"

static Future<ErrorOr<Void>> goodTestFuture(double duration) {
	return tag(delay(duration), ErrorOr<Void>(Void()));
}

static Future<ErrorOr<Void>> badTestFuture(double duration, Error e) {
	return tag(delay(duration), ErrorOr<Void>(e));
}

} // namespace

															#line 3975 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase242()
															#line 242 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
template <class FlowTestCase242Actor>
															#line 242 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class FlowTestCase242ActorState {
															#line 3982 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
															#line 242 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	FlowTestCase242ActorState(UnitTestParameters const& params) 
															#line 242 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
															#line 242 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		 : params(params)
															#line 3989 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase242", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase242ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase242", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 243 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			auto input = makeReference<AsyncVar<DummyState>>();
															#line 244 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			subscriber1 = testSubscriber(IAsyncListener<int>::create(input, [](auto const& var) { return var.changed; }), 100);
															#line 246 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			subscriber2 = testSubscriber(IAsyncListener<int>::create(input, [](auto const& var) { return var.unchanged; }), {});
															#line 248 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			StrictFuture<Void> __when_expr_0 = subscriber1 && testPublisher(input);
															#line 248 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			if (static_cast<FlowTestCase242Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4012 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase242Actor*>(this)->actor_wait_state = 1;
															#line 248 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase242Actor, 0, Void >*>(static_cast<FlowTestCase242Actor*>(this)));
															#line 4017 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase242ActorState();
		static_cast<FlowTestCase242Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 249 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		ASSERT(!subscriber2.isReady());
															#line 250 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!static_cast<FlowTestCase242Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase242ActorState(); static_cast<FlowTestCase242Actor*>(this)->destroy(); return 0; }
															#line 4042 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		new (&static_cast<FlowTestCase242Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase242ActorState();
		static_cast<FlowTestCase242Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 249 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		ASSERT(!subscriber2.isReady());
															#line 250 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!static_cast<FlowTestCase242Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase242ActorState(); static_cast<FlowTestCase242Actor*>(this)->destroy(); return 0; }
															#line 4056 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		new (&static_cast<FlowTestCase242Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase242ActorState();
		static_cast<FlowTestCase242Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase242Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase242Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase242Actor*>(this)->ActorCallback< FlowTestCase242Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase242Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase242", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase242Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase242", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase242Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase242", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase242Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase242", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase242Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase242", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase242Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase242", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 242 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	UnitTestParameters params;
															#line 244 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	Future<Void> subscriber1;
															#line 246 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	Future<Void> subscriber2;
															#line 4145 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase242()
															#line 242 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class FlowTestCase242Actor final : public Actor<Void>, public ActorCallback< FlowTestCase242Actor, 0, Void >, public FastAllocated<FlowTestCase242Actor>, public FlowTestCase242ActorState<FlowTestCase242Actor> {
															#line 4150 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase242Actor>::operator new;
	using FastAllocated<FlowTestCase242Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5682702332789186560UL, 18268994716530315008UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase242Actor, 0, Void >;
															#line 242 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	FlowTestCase242Actor(UnitTestParameters const& params) 
															#line 4167 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase242ActorState<FlowTestCase242Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase242", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2822182176824976640UL, 17533110519103100160UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase242Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase242");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase242", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase242Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 242 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
static Future<Void> flowTestCase242( UnitTestParameters const& params ) {
															#line 242 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	return Future<Void>(new FlowTestCase242Actor(params));
															#line 4200 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase242, "/flow/genericactors/AsyncListener")

#line 252 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"

															#line 4206 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase253()
															#line 253 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
template <class FlowTestCase253Actor>
															#line 253 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class FlowTestCase253ActorState {
															#line 4213 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
															#line 253 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	FlowTestCase253ActorState(UnitTestParameters const& params) 
															#line 253 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
															#line 253 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		 : params(params),
															#line 254 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   futures()
															#line 4222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase253", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase253ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase253", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			{
															#line 256 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
				futures = { goodTestFuture(1), goodTestFuture(2), goodTestFuture(3) };
															#line 257 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
				StrictFuture<Void> __when_expr_0 = waitForMost(futures, 1, operation_failed(), 0.0);
															#line 257 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
				if (static_cast<FlowTestCase253Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4242 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<FlowTestCase253Actor*>(this)->actor_wait_state = 1;
															#line 257 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase253Actor, 0, Void >*>(static_cast<FlowTestCase253Actor*>(this)));
															#line 4247 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase253ActorState();
		static_cast<FlowTestCase253Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		{
															#line 261 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			futures = { goodTestFuture(1), goodTestFuture(2), goodTestFuture(3) };
															#line 262 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			StrictFuture<Void> __when_expr_1 = waitForMost(futures, 0, operation_failed(), 0.0);
															#line 262 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			if (static_cast<FlowTestCase253Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4276 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FlowTestCase253Actor*>(this)->actor_wait_state = 2;
															#line 262 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase253Actor, 1, Void >*>(static_cast<FlowTestCase253Actor*>(this)));
															#line 4281 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 258 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		ASSERT(!futures[2].isReady());
															#line 4291 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 258 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		ASSERT(!futures[2].isReady());
															#line 4300 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase253Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase253Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase253Actor*>(this)->ActorCallback< FlowTestCase253Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase253Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase253", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase253Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase253", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase253Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase253", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase253Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase253", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase253Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase253", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase253Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase253", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		{
															#line 266 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			futures = { goodTestFuture(1), goodTestFuture(2), goodTestFuture(3) };
															#line 267 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			StrictFuture<Void> __when_expr_2 = waitForMost(futures, 1, operation_failed(), 1.0);
															#line 267 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			if (static_cast<FlowTestCase253Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4389 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
			static_cast<FlowTestCase253Actor*>(this)->actor_wait_state = 3;
															#line 267 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase253Actor, 2, Void >*>(static_cast<FlowTestCase253Actor*>(this)));
															#line 4394 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 263 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		ASSERT(futures[2].isReady());
															#line 4404 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 263 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		ASSERT(futures[2].isReady());
															#line 4413 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase253Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase253Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase253Actor*>(this)->ActorCallback< FlowTestCase253Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase253Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase253", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase253Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase253", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase253Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase253", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase253Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase253", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase253Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase253", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase253Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase253", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
		{
															#line 271 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			futures = { goodTestFuture(1), goodTestFuture(2), badTestFuture(1, success()) };
															#line 272 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			StrictFuture<Void> __when_expr_3 = waitForMost(futures, 1, operation_failed(), 1.0);
															#line 272 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			if (static_cast<FlowTestCase253Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4502 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont7when1(__when_expr_3.get(), loopDepth); };
			static_cast<FlowTestCase253Actor*>(this)->actor_wait_state = 4;
															#line 272 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase253Actor, 3, Void >*>(static_cast<FlowTestCase253Actor*>(this)));
															#line 4507 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 268 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		ASSERT(futures[2].isReady());
															#line 4517 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 268 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		ASSERT(futures[2].isReady());
															#line 4526 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase253Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase253Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase253Actor*>(this)->ActorCallback< FlowTestCase253Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase253Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase253", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase253Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase253", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase253Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase253", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase253Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase253", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase253Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase253", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase253Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase253", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont10(int loopDepth) 
	{
		{
															#line 275 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			futures = { goodTestFuture(1), goodTestFuture(2), badTestFuture(1, success()) };
															#line 4611 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			try {
															#line 277 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
				StrictFuture<Void> __when_expr_4 = waitForMost(futures, 0, operation_failed(), 1.0);
															#line 277 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
				if (static_cast<FlowTestCase253Actor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 4617 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont10Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont10when1(__when_expr_4.get(), loopDepth); };
				static_cast<FlowTestCase253Actor*>(this)->actor_wait_state = 5;
															#line 277 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase253Actor, 4, Void >*>(static_cast<FlowTestCase253Actor*>(this)));
															#line 4622 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont10Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont10Catch1(unknown_error(), loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase253Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase253Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase253Actor*>(this)->ActorCallback< FlowTestCase253Actor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase253Actor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase253", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase253Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase253", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FlowTestCase253Actor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase253", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase253Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase253", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FlowTestCase253Actor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase253", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase253Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase253", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
															#line 283 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!static_cast<FlowTestCase253Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase253ActorState(); static_cast<FlowTestCase253Actor*>(this)->destroy(); return 0; }
															#line 4725 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		new (&static_cast<FlowTestCase253Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase253ActorState();
		static_cast<FlowTestCase253Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont2(int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 280 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			ASSERT_EQ(e.code(), error_code_operation_failed);
															#line 4744 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			loopDepth = a_body1cont10cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont3(Void const& _,int loopDepth) 
	{
															#line 278 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		ASSERT(false);
															#line 4759 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		loopDepth = a_body1cont10cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3(Void && _,int loopDepth) 
	{
															#line 278 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		ASSERT(false);
															#line 4768 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		loopDepth = a_body1cont10cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FlowTestCase253Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase253Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase253Actor*>(this)->ActorCallback< FlowTestCase253Actor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase253Actor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase253", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase253Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase253", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FlowTestCase253Actor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase253", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase253Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase253", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FlowTestCase253Actor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase253", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase253Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase253", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont10cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont10cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 253 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	UnitTestParameters params;
															#line 254 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	std::vector<Future<ErrorOr<Void>>> futures;
															#line 4865 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase253()
															#line 253 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class FlowTestCase253Actor final : public Actor<Void>, public ActorCallback< FlowTestCase253Actor, 0, Void >, public ActorCallback< FlowTestCase253Actor, 1, Void >, public ActorCallback< FlowTestCase253Actor, 2, Void >, public ActorCallback< FlowTestCase253Actor, 3, Void >, public ActorCallback< FlowTestCase253Actor, 4, Void >, public FastAllocated<FlowTestCase253Actor>, public FlowTestCase253ActorState<FlowTestCase253Actor> {
															#line 4870 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase253Actor>::operator new;
	using FastAllocated<FlowTestCase253Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9128874905363779584UL, 12494346710002272000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase253Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase253Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase253Actor, 2, Void >;
friend struct ActorCallback< FlowTestCase253Actor, 3, Void >;
friend struct ActorCallback< FlowTestCase253Actor, 4, Void >;
															#line 253 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	FlowTestCase253Actor(UnitTestParameters const& params) 
															#line 4891 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase253ActorState<FlowTestCase253Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase253", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3345900416937358592UL, 3285266716463017728UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase253Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase253");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase253", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase253Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase253Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase253Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FlowTestCase253Actor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FlowTestCase253Actor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 253 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
static Future<Void> flowTestCase253( UnitTestParameters const& params ) {
															#line 253 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	return Future<Void>(new FlowTestCase253Actor(params));
															#line 4928 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase253, "/flow/genericactors/WaitForMost")

#line 285 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"

#if false
															#line 4935 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase287()
															#line 287 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
template <class FlowTestCase287Actor>
															#line 287 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class FlowTestCase287ActorState {
															#line 4942 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
															#line 287 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	FlowTestCase287ActorState(UnitTestParameters const& params) 
															#line 287 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
															#line 287 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		 : params(params),
															#line 288 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   resA(),
															#line 289 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   resB(),
															#line 290 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   resC(),
															#line 292 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		   promise()
															#line 4957 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase287", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase287ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase287", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 294 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			auto future = storeTuple(promise.getFuture(), resA, resB, resC);
															#line 296 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			promise.send(std::make_tuple(std::vector<UID>(10), 15, 2.0));
															#line 297 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			StrictFuture<Void> __when_expr_0 = ready(future);
															#line 297 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			if (static_cast<FlowTestCase287Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4978 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase287Actor*>(this)->actor_wait_state = 1;
															#line 297 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase287Actor, 0, Void >*>(static_cast<FlowTestCase287Actor*>(this)));
															#line 4983 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase287ActorState();
		static_cast<FlowTestCase287Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 298 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		ASSERT(resA.size() == 10);
															#line 299 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		ASSERT(resB == 15);
															#line 300 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		ASSERT(resC == 2.0);
															#line 301 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!static_cast<FlowTestCase287Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase287ActorState(); static_cast<FlowTestCase287Actor*>(this)->destroy(); return 0; }
															#line 5012 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		new (&static_cast<FlowTestCase287Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase287ActorState();
		static_cast<FlowTestCase287Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 298 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		ASSERT(resA.size() == 10);
															#line 299 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		ASSERT(resB == 15);
															#line 300 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		ASSERT(resC == 2.0);
															#line 301 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
		if (!static_cast<FlowTestCase287Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase287ActorState(); static_cast<FlowTestCase287Actor*>(this)->destroy(); return 0; }
															#line 5030 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		new (&static_cast<FlowTestCase287Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase287ActorState();
		static_cast<FlowTestCase287Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase287Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase287Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase287Actor*>(this)->ActorCallback< FlowTestCase287Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase287Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase287", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase287Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase287", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase287Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase287", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase287Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase287", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase287Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase287", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase287Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase287", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 287 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	UnitTestParameters params;
															#line 288 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	std::vector<UID> resA;
															#line 289 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	int resB;
															#line 290 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	double resC;
															#line 292 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	Promise<std::tuple<std::vector<UID>, int, double>> promise;
															#line 5123 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase287()
															#line 287 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
class FlowTestCase287Actor final : public Actor<Void>, public ActorCallback< FlowTestCase287Actor, 0, Void >, public FastAllocated<FlowTestCase287Actor>, public FlowTestCase287ActorState<FlowTestCase287Actor> {
															#line 5128 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase287Actor>::operator new;
	using FastAllocated<FlowTestCase287Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1374811607954724096UL, 11889173310714086912UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase287Actor, 0, Void >;
															#line 287 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	FlowTestCase287Actor(UnitTestParameters const& params) 
															#line 5145 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase287ActorState<FlowTestCase287Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase287", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2810935470179410688UL, 1895767694338287616UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase287Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase287");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase287", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase287Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 287 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
static Future<Void> flowTestCase287( UnitTestParameters const& params ) {
															#line 287 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
	return Future<Void>(new FlowTestCase287Actor(params));
															#line 5178 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/flow/genericactors.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase287, "/flow/genericactors/generic/storeTuple")

#line 303 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/flow/genericactors.actor.cpp"
#endif
