#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
/*
 * TransactionCost.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/ReadYourWrites.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h"

class TransactionCostWorkload : public TestWorkload {
	int iterations{ 1000 };
	Key prefix;
	bool debugTransactions{ false };

	Key getKey(uint64_t testNumber, uint64_t index = 0) const {
		BinaryWriter bw(Unversioned());
		bw << bigEndian64(testNumber);
		bw << bigEndian64(index);
		return bw.toValue().withPrefix(prefix);
	}

	static Value getValue(uint32_t size) { return ValueRef(std::string(size, '\x00')); }

	static UID getDebugID(uint64_t testNumber) { return UID(testNumber << 32, testNumber << 32); }

	class ITest {
	protected:
		uint64_t testNumber;
		explicit ITest(uint64_t testNumber) : testNumber(testNumber) {}

	public:
		void debugTransaction(ReadYourWritesTransaction& tr) { tr.debugTransaction(getDebugID(testNumber)); }
		virtual Future<Void> setup(TransactionCostWorkload const& workload, Database const&) { return Void(); }
		virtual Future<Void> exec(TransactionCostWorkload const& workload, Reference<ReadYourWritesTransaction>) = 0;
		virtual int64_t expectedFinalCost() const = 0;
		virtual ~ITest() = default;
	};

	class ReadEmptyTest : public ITest {
	public:
		explicit ReadEmptyTest(uint64_t testNumber) : ITest(testNumber) {}

		Future<Void> exec(TransactionCostWorkload const& workload, Reference<ReadYourWritesTransaction> tr) override {
			return success(tr->get(workload.getKey(testNumber)));
		}

		int64_t expectedFinalCost() const override { return CLIENT_KNOBS->TAG_THROTTLING_PAGE_SIZE; }
	};

	class ReadLargeValueTest : public ITest {
																	#line 68 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
// This generated class is to be used only via setup()
															#line 66 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
template <class SetupActor>
															#line 66 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
class SetupActorState {
															#line 74 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
public:
															#line 66 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	SetupActorState(TransactionCostWorkload const* const& workload,ReadLargeValueTest* const& self,Database const& cx) 
															#line 66 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
															#line 66 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		 : workload(workload),
															#line 66 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		   self(self),
															#line 66 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		   cx(cx),
															#line 69 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		   tr(cx)
															#line 87 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
	{
		fdb_probe_actor_create("setup", reinterpret_cast<unsigned long>(this));

	}
	~SetupActorState() 
	{
		fdb_probe_actor_destroy("setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 70 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			;
															#line 102 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetupActorState();
		static_cast<SetupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 72 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			tr.set(workload->getKey(self->testNumber), getValue(CLIENT_KNOBS->TAG_THROTTLING_PAGE_SIZE));
															#line 73 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 73 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			if (static_cast<SetupActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 137 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetupActor*>(this)->actor_wait_state = 1;
															#line 73 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetupActor, 0, Void >*>(static_cast<SetupActor*>(this)));
															#line 142 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 76 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 76 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			if (static_cast<SetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 166 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SetupActor*>(this)->actor_wait_state = 2;
															#line 76 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetupActor, 1, Void >*>(static_cast<SetupActor*>(this)));
															#line 171 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 74 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		if (!static_cast<SetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActorState(); static_cast<SetupActor*>(this)->destroy(); return 0; }
															#line 186 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		new (&static_cast<SetupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupActorState();
		static_cast<SetupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 74 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		if (!static_cast<SetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActorState(); static_cast<SetupActor*>(this)->destroy(); return 0; }
															#line 198 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		new (&static_cast<SetupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupActorState();
		static_cast<SetupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetupActor*>(this)->actor_wait_state > 0) static_cast<SetupActor*>(this)->actor_wait_state = 0;
		static_cast<SetupActor*>(this)->ActorCallback< SetupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetupActor*>(this)->actor_wait_state > 0) static_cast<SetupActor*>(this)->actor_wait_state = 0;
		static_cast<SetupActor*>(this)->ActorCallback< SetupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 66 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	TransactionCostWorkload const* workload;
															#line 66 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	ReadLargeValueTest* self;
															#line 66 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	Database cx;
															#line 69 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	Transaction tr;
															#line 376 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
};
// This generated class is to be used only via setup()
															#line 66 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
class SetupActor final : public Actor<Void>, public ActorCallback< SetupActor, 0, Void >, public ActorCallback< SetupActor, 1, Void >, public FastAllocated<SetupActor>, public SetupActorState<SetupActor> {
															#line 381 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
public:
	using FastAllocated<SetupActor>::operator new;
	using FastAllocated<SetupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17828048376669483520UL, 11436026822826176512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetupActor, 0, Void >;
friend struct ActorCallback< SetupActor, 1, Void >;
															#line 66 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	SetupActor(TransactionCostWorkload const* const& workload,ReadLargeValueTest* const& self,Database const& cx) 
															#line 399 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		 : Actor<Void>(),
		   SetupActorState<SetupActor>(workload, self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13998344965578828288UL, 688267501332814080UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetupActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 66 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
[[nodiscard]] static Future<Void> setup( TransactionCostWorkload const* const& workload, ReadLargeValueTest* const& self, Database const& cx ) {
															#line 66 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	return Future<Void>(new SetupActor(workload, self, cx));
															#line 432 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
}

#line 80 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"

	public:
		explicit ReadLargeValueTest(int64_t testNumber) : ITest(testNumber) {}

		Future<Void> setup(TransactionCostWorkload const& workload, Database const& cx) override {
			return setup(&workload, this, cx);
		}

		Future<Void> exec(TransactionCostWorkload const& workload, Reference<ReadYourWritesTransaction> tr) override {
			return success(tr->get(workload.getKey(testNumber)));
		}

		int64_t expectedFinalCost() const override { return 2 * CLIENT_KNOBS->TAG_THROTTLING_PAGE_SIZE; }
	};

	class WriteTest : public ITest {
	public:
		explicit WriteTest(int64_t testNumber) : ITest(testNumber) {}

		Future<Void> exec(TransactionCostWorkload const& workload, Reference<ReadYourWritesTransaction> tr) override {
			tr->set(workload.getKey(testNumber), getValue(20));
			return Void();
		}

		int64_t expectedFinalCost() const override {
			return CLIENT_KNOBS->GLOBAL_TAG_THROTTLING_RW_FUNGIBILITY_RATIO * CLIENT_KNOBS->TAG_THROTTLING_PAGE_SIZE;
		}
	};

	class WriteLargeValueTest : public ITest {
	public:
		explicit WriteLargeValueTest(int64_t testNumber) : ITest(testNumber) {}

		Future<Void> exec(TransactionCostWorkload const& workload, Reference<ReadYourWritesTransaction> tr) override {
			tr->set(workload.getKey(testNumber), getValue(CLIENT_KNOBS->TAG_THROTTLING_PAGE_SIZE));
			return Void();
		}

		int64_t expectedFinalCost() const override {
			return 2 * CLIENT_KNOBS->GLOBAL_TAG_THROTTLING_RW_FUNGIBILITY_RATIO *
			       CLIENT_KNOBS->TAG_THROTTLING_PAGE_SIZE;
		}
	};

	class WriteMultipleValuesTest : public ITest {
	public:
		explicit WriteMultipleValuesTest(int64_t testNumber) : ITest(testNumber) {}

		Future<Void> exec(TransactionCostWorkload const& workload, Reference<ReadYourWritesTransaction> tr) override {
			for (int i = 0; i < 10; ++i) {
				tr->set(workload.getKey(testNumber, i), getValue(20));
			}
			return Void();
		}

		int64_t expectedFinalCost() const override {
			return 10 * CLIENT_KNOBS->GLOBAL_TAG_THROTTLING_RW_FUNGIBILITY_RATIO *
			       CLIENT_KNOBS->TAG_THROTTLING_PAGE_SIZE;
		}
	};

	class ClearTest : public ITest {
	public:
		explicit ClearTest(int64_t testNumber) : ITest(testNumber) {}

		Future<Void> exec(TransactionCostWorkload const& workload, Reference<ReadYourWritesTransaction> tr) override {
			tr->clear(singleKeyRange(workload.getKey(testNumber)));
			return Void();
		}

		int64_t expectedFinalCost() const override { return CLIENT_KNOBS->TAG_THROTTLING_PAGE_SIZE; }
	};

	class ReadRangeTest : public ITest {
																	#line 510 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
// This generated class is to be used only via setup()
															#line 154 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
template <class SetupActor1>
															#line 154 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
class SetupActor1State {
															#line 516 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
public:
															#line 154 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	SetupActor1State(ReadRangeTest* const& self,TransactionCostWorkload const* const& workload,Database const& cx) 
															#line 154 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
															#line 154 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		 : self(self),
															#line 154 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		   workload(workload),
															#line 154 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		   cx(cx),
															#line 155 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		   tr(cx)
															#line 529 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
	{
		fdb_probe_actor_create("setup", reinterpret_cast<unsigned long>(this));

	}
	~SetupActor1State() 
	{
		fdb_probe_actor_destroy("setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 156 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			;
															#line 544 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetupActor1State();
		static_cast<SetupActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 158 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			for(int i = 0;i < 10;++i) {
															#line 159 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
				tr.set(workload->getKey(self->testNumber, i), workload->getValue(20));
															#line 577 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			}
															#line 161 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 161 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			if (static_cast<SetupActor1*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 583 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetupActor1*>(this)->actor_wait_state = 1;
															#line 161 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetupActor1, 0, Void >*>(static_cast<SetupActor1*>(this)));
															#line 588 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 164 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 164 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			if (static_cast<SetupActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 612 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SetupActor1*>(this)->actor_wait_state = 2;
															#line 164 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetupActor1, 1, Void >*>(static_cast<SetupActor1*>(this)));
															#line 617 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 162 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		if (!static_cast<SetupActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActor1State(); static_cast<SetupActor1*>(this)->destroy(); return 0; }
															#line 632 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		new (&static_cast<SetupActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupActor1State();
		static_cast<SetupActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 162 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		if (!static_cast<SetupActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActor1State(); static_cast<SetupActor1*>(this)->destroy(); return 0; }
															#line 644 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		new (&static_cast<SetupActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupActor1State();
		static_cast<SetupActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetupActor1*>(this)->actor_wait_state > 0) static_cast<SetupActor1*>(this)->actor_wait_state = 0;
		static_cast<SetupActor1*>(this)->ActorCallback< SetupActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetupActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetupActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetupActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetupActor1*>(this)->actor_wait_state > 0) static_cast<SetupActor1*>(this)->actor_wait_state = 0;
		static_cast<SetupActor1*>(this)->ActorCallback< SetupActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetupActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetupActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetupActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 154 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	ReadRangeTest* self;
															#line 154 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	TransactionCostWorkload const* workload;
															#line 154 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	Database cx;
															#line 155 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	Transaction tr;
															#line 822 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
};
// This generated class is to be used only via setup()
															#line 154 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
class SetupActor1 final : public Actor<Void>, public ActorCallback< SetupActor1, 0, Void >, public ActorCallback< SetupActor1, 1, Void >, public FastAllocated<SetupActor1>, public SetupActor1State<SetupActor1> {
															#line 827 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
public:
	using FastAllocated<SetupActor1>::operator new;
	using FastAllocated<SetupActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17828048376669483520UL, 11436026822826176512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetupActor1, 0, Void >;
friend struct ActorCallback< SetupActor1, 1, Void >;
															#line 154 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	SetupActor1(ReadRangeTest* const& self,TransactionCostWorkload const* const& workload,Database const& cx) 
															#line 845 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		 : Actor<Void>(),
		   SetupActor1State<SetupActor1>(self, workload, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7554903555599063552UL, 3002477495560883968UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetupActor1, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetupActor1, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 154 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
[[nodiscard]] static Future<Void> setup( ReadRangeTest* const& self, TransactionCostWorkload const* const& workload, Database const& cx ) {
															#line 154 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	return Future<Void>(new SetupActor1(self, workload, cx));
															#line 878 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
}

#line 168 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"

	public:
		explicit ReadRangeTest(int64_t testNumber) : ITest(testNumber) {}

		Future<Void> setup(TransactionCostWorkload const& workload, Database const& cx) override {
			return setup(this, &workload, cx);
		}

		Future<Void> exec(TransactionCostWorkload const& workload, Reference<ReadYourWritesTransaction> tr) override {
			KeyRange const keys = KeyRangeRef(workload.getKey(testNumber, 0), workload.getKey(testNumber, 10));
			return success(tr->getRange(keys, 10));
		}

		int64_t expectedFinalCost() const override { return CLIENT_KNOBS->TAG_THROTTLING_PAGE_SIZE; }
	};

	class ReadMultipleValuesTest : public ITest {
																	#line 899 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
// This generated class is to be used only via setup()
															#line 185 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
template <class SetupActor2>
															#line 185 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
class SetupActor2State {
															#line 905 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
public:
															#line 185 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	SetupActor2State(ReadMultipleValuesTest* const& self,TransactionCostWorkload const* const& workload,Database const& cx) 
															#line 185 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
															#line 185 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		 : self(self),
															#line 185 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		   workload(workload),
															#line 185 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		   cx(cx),
															#line 188 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		   tr(cx)
															#line 918 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
	{
		fdb_probe_actor_create("setup", reinterpret_cast<unsigned long>(this));

	}
	~SetupActor2State() 
	{
		fdb_probe_actor_destroy("setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 189 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			;
															#line 933 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetupActor2State();
		static_cast<SetupActor2*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 191 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			for(int i = 0;i < 10;++i) {
															#line 192 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
				tr.set(workload->getKey(self->testNumber, i), workload->getValue(20));
															#line 966 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			}
															#line 194 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 194 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			if (static_cast<SetupActor2*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 972 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetupActor2*>(this)->actor_wait_state = 1;
															#line 194 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetupActor2, 0, Void >*>(static_cast<SetupActor2*>(this)));
															#line 977 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 197 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 197 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			if (static_cast<SetupActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1001 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SetupActor2*>(this)->actor_wait_state = 2;
															#line 197 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetupActor2, 1, Void >*>(static_cast<SetupActor2*>(this)));
															#line 1006 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 195 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		if (!static_cast<SetupActor2*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActor2State(); static_cast<SetupActor2*>(this)->destroy(); return 0; }
															#line 1021 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		new (&static_cast<SetupActor2*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupActor2State();
		static_cast<SetupActor2*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 195 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		if (!static_cast<SetupActor2*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActor2State(); static_cast<SetupActor2*>(this)->destroy(); return 0; }
															#line 1033 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		new (&static_cast<SetupActor2*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupActor2State();
		static_cast<SetupActor2*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetupActor2*>(this)->actor_wait_state > 0) static_cast<SetupActor2*>(this)->actor_wait_state = 0;
		static_cast<SetupActor2*>(this)->ActorCallback< SetupActor2, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetupActor2, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetupActor2, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetupActor2, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetupActor2*>(this)->actor_wait_state > 0) static_cast<SetupActor2*>(this)->actor_wait_state = 0;
		static_cast<SetupActor2*>(this)->ActorCallback< SetupActor2, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetupActor2, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetupActor2, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetupActor2, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 185 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	ReadMultipleValuesTest* self;
															#line 185 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	TransactionCostWorkload const* workload;
															#line 185 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	Database cx;
															#line 188 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	Transaction tr;
															#line 1211 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
};
// This generated class is to be used only via setup()
															#line 185 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
class SetupActor2 final : public Actor<Void>, public ActorCallback< SetupActor2, 0, Void >, public ActorCallback< SetupActor2, 1, Void >, public FastAllocated<SetupActor2>, public SetupActor2State<SetupActor2> {
															#line 1216 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
public:
	using FastAllocated<SetupActor2>::operator new;
	using FastAllocated<SetupActor2>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17828048376669483520UL, 11436026822826176512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetupActor2, 0, Void >;
friend struct ActorCallback< SetupActor2, 1, Void >;
															#line 185 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	SetupActor2(ReadMultipleValuesTest* const& self,TransactionCostWorkload const* const& workload,Database const& cx) 
															#line 1234 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		 : Actor<Void>(),
		   SetupActor2State<SetupActor2>(self, workload, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(605885446803886848UL, 8965722389878324480UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetupActor2, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetupActor2, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 185 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
[[nodiscard]] static Future<Void> setup( ReadMultipleValuesTest* const& self, TransactionCostWorkload const* const& workload, Database const& cx ) {
															#line 185 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	return Future<Void>(new SetupActor2(self, workload, cx));
															#line 1267 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
}

#line 201 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"

	public:
		explicit ReadMultipleValuesTest(int64_t testNumber) : ITest(testNumber) {}

		Future<Void> setup(TransactionCostWorkload const& workload, Database const& cx) override {
			return setup(this, &workload, cx);
		}

		Future<Void> exec(TransactionCostWorkload const& workload, Reference<ReadYourWritesTransaction> tr) override {
			std::vector<Future<Void>> futures;
			for (int i = 0; i < 10; ++i) {
				futures.push_back(success(tr->get(workload.getKey(testNumber, i))));
			}
			return waitForAll(futures);
		}

		int64_t expectedFinalCost() const override { return 10 * CLIENT_KNOBS->TAG_THROTTLING_PAGE_SIZE; }
	};

	class LargeReadRangeTest : public ITest {
																	#line 1291 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
// This generated class is to be used only via setup()
															#line 221 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
template <class SetupActor3>
															#line 221 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
class SetupActor3State {
															#line 1297 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
public:
															#line 221 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	SetupActor3State(LargeReadRangeTest* const& self,TransactionCostWorkload const* const& workload,Database const& cx) 
															#line 221 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
															#line 221 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		 : self(self),
															#line 221 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		   workload(workload),
															#line 221 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		   cx(cx),
															#line 224 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		   tr(cx)
															#line 1310 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
	{
		fdb_probe_actor_create("setup", reinterpret_cast<unsigned long>(this));

	}
	~SetupActor3State() 
	{
		fdb_probe_actor_destroy("setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 225 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			;
															#line 1325 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetupActor3State();
		static_cast<SetupActor3*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 227 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			for(int i = 0;i < 10;++i) {
															#line 228 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
				tr.set(workload->getKey(self->testNumber, i), workload->getValue(CLIENT_KNOBS->TAG_THROTTLING_PAGE_SIZE));
															#line 1358 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			}
															#line 231 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 231 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			if (static_cast<SetupActor3*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1364 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetupActor3*>(this)->actor_wait_state = 1;
															#line 231 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetupActor3, 0, Void >*>(static_cast<SetupActor3*>(this)));
															#line 1369 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 234 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 234 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			if (static_cast<SetupActor3*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1393 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SetupActor3*>(this)->actor_wait_state = 2;
															#line 234 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetupActor3, 1, Void >*>(static_cast<SetupActor3*>(this)));
															#line 1398 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 232 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		if (!static_cast<SetupActor3*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActor3State(); static_cast<SetupActor3*>(this)->destroy(); return 0; }
															#line 1413 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		new (&static_cast<SetupActor3*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupActor3State();
		static_cast<SetupActor3*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 232 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		if (!static_cast<SetupActor3*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActor3State(); static_cast<SetupActor3*>(this)->destroy(); return 0; }
															#line 1425 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		new (&static_cast<SetupActor3*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupActor3State();
		static_cast<SetupActor3*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetupActor3*>(this)->actor_wait_state > 0) static_cast<SetupActor3*>(this)->actor_wait_state = 0;
		static_cast<SetupActor3*>(this)->ActorCallback< SetupActor3, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetupActor3, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetupActor3, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetupActor3, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetupActor3*>(this)->actor_wait_state > 0) static_cast<SetupActor3*>(this)->actor_wait_state = 0;
		static_cast<SetupActor3*>(this)->ActorCallback< SetupActor3, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetupActor3, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetupActor3, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetupActor3, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 221 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	LargeReadRangeTest* self;
															#line 221 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	TransactionCostWorkload const* workload;
															#line 221 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	Database cx;
															#line 224 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	Transaction tr;
															#line 1603 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
};
// This generated class is to be used only via setup()
															#line 221 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
class SetupActor3 final : public Actor<Void>, public ActorCallback< SetupActor3, 0, Void >, public ActorCallback< SetupActor3, 1, Void >, public FastAllocated<SetupActor3>, public SetupActor3State<SetupActor3> {
															#line 1608 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
public:
	using FastAllocated<SetupActor3>::operator new;
	using FastAllocated<SetupActor3>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17828048376669483520UL, 11436026822826176512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetupActor3, 0, Void >;
friend struct ActorCallback< SetupActor3, 1, Void >;
															#line 221 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	SetupActor3(LargeReadRangeTest* const& self,TransactionCostWorkload const* const& workload,Database const& cx) 
															#line 1626 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		 : Actor<Void>(),
		   SetupActor3State<SetupActor3>(self, workload, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16261625564325380864UL, 14294723163051731456UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetupActor3, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetupActor3, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 221 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
[[nodiscard]] static Future<Void> setup( LargeReadRangeTest* const& self, TransactionCostWorkload const* const& workload, Database const& cx ) {
															#line 221 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	return Future<Void>(new SetupActor3(self, workload, cx));
															#line 1659 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
}

#line 238 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"

	public:
		explicit LargeReadRangeTest(int64_t testNumber) : ITest(testNumber) {}

		Future<Void> setup(TransactionCostWorkload const& workload, Database const& cx) override {
			return setup(this, &workload, cx);
		}

		Future<Void> exec(TransactionCostWorkload const& workload, Reference<ReadYourWritesTransaction> tr) override {
			KeyRange const keys = KeyRangeRef(workload.getKey(testNumber, 0), workload.getKey(testNumber, 10));
			return success(tr->getRange(keys, 10));
		}

		int64_t expectedFinalCost() const override { return 11 * CLIENT_KNOBS->TAG_THROTTLING_PAGE_SIZE; }
	};

	static std::unique_ptr<ITest> createRandomTest(int64_t testNumber) {
		auto const rand = deterministicRandom()->randomInt(0, 9);
		if (rand == 0) {
			return std::make_unique<ReadEmptyTest>(testNumber);
		} else if (rand == 1) {
			return std::make_unique<ReadLargeValueTest>(testNumber);
		} else if (rand == 2) {
			return std::make_unique<ReadMultipleValuesTest>(testNumber);
		} else if (rand == 3) {
			return std::make_unique<WriteTest>(testNumber);
		} else if (rand == 4) {
			return std::make_unique<WriteLargeValueTest>(testNumber);
		} else if (rand == 5) {
			return std::make_unique<WriteMultipleValuesTest>(testNumber);
		} else if (rand == 6) {
			return std::make_unique<ClearTest>(testNumber);
		} else if (rand == 7) {
			return std::make_unique<ReadRangeTest>(testNumber);
		} else {
			return std::make_unique<LargeReadRangeTest>(testNumber);
		}
	}

																#line 1702 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
// This generated class is to be used only via runTest()
															#line 277 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
template <class RunTestActor>
															#line 277 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
class RunTestActorState {
															#line 1708 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
public:
															#line 277 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	RunTestActorState(TransactionCostWorkload* const& self,Database const& cx,ITest* const& test) 
															#line 277 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
															#line 277 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		 : self(self),
															#line 277 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		   cx(cx),
															#line 277 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		   test(test)
															#line 1719 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
	{
		fdb_probe_actor_create("runTest", reinterpret_cast<unsigned long>(this));

	}
	~RunTestActorState() 
	{
		fdb_probe_actor_destroy("runTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 278 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			StrictFuture<Void> __when_expr_0 = test->setup(*self, cx);
															#line 278 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1736 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunTestActor*>(this)->actor_wait_state = 1;
															#line 278 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 0, Void >*>(static_cast<RunTestActor*>(this)));
															#line 1741 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunTestActorState();
		static_cast<RunTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 279 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		tr = makeReference<ReadYourWritesTransaction>(cx);
															#line 280 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		if (self->debugTransactions)
															#line 1766 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		{
															#line 281 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			test->debugTransaction(*tr);
															#line 1770 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		}
															#line 283 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		;
															#line 1774 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 279 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		tr = makeReference<ReadYourWritesTransaction>(cx);
															#line 280 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		if (self->debugTransactions)
															#line 1785 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		{
															#line 281 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			test->debugTransaction(*tr);
															#line 1789 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		}
															#line 283 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		;
															#line 1793 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunTestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 285 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			StrictFuture<Void> __when_expr_1 = test->exec(*self, tr);
															#line 285 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1887 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunTestActor*>(this)->actor_wait_state = 2;
															#line 285 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 1, Void >*>(static_cast<RunTestActor*>(this)));
															#line 1892 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 290 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 290 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1916 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<RunTestActor*>(this)->actor_wait_state = 4;
															#line 290 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 3, Void >*>(static_cast<RunTestActor*>(this)));
															#line 1921 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 286 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 286 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1938 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<RunTestActor*>(this)->actor_wait_state = 3;
															#line 286 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 2, Void >*>(static_cast<RunTestActor*>(this)));
															#line 1943 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 286 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 286 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1954 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<RunTestActor*>(this)->actor_wait_state = 3;
															#line 286 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 2, Void >*>(static_cast<RunTestActor*>(this)));
															#line 1959 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunTestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 287 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		ASSERT_EQ(tr->getTotalCost(), test->expectedFinalCost());
															#line 288 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		if (!static_cast<RunTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunTestActorState(); static_cast<RunTestActor*>(this)->destroy(); return 0; }
															#line 2045 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		new (&static_cast<RunTestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunTestActorState();
		static_cast<RunTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 287 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		ASSERT_EQ(tr->getTotalCost(), test->expectedFinalCost());
															#line 288 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		if (!static_cast<RunTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunTestActorState(); static_cast<RunTestActor*>(this)->destroy(); return 0; }
															#line 2059 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		new (&static_cast<RunTestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunTestActorState();
		static_cast<RunTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunTestActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunTestActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 277 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	TransactionCostWorkload* self;
															#line 277 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	Database cx;
															#line 277 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	ITest* test;
															#line 279 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2237 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
};
// This generated class is to be used only via runTest()
															#line 277 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
class RunTestActor final : public Actor<Void>, public ActorCallback< RunTestActor, 0, Void >, public ActorCallback< RunTestActor, 1, Void >, public ActorCallback< RunTestActor, 2, Void >, public ActorCallback< RunTestActor, 3, Void >, public FastAllocated<RunTestActor>, public RunTestActorState<RunTestActor> {
															#line 2242 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
public:
	using FastAllocated<RunTestActor>::operator new;
	using FastAllocated<RunTestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2896555348489106688UL, 11897376652940029696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunTestActor, 0, Void >;
friend struct ActorCallback< RunTestActor, 1, Void >;
friend struct ActorCallback< RunTestActor, 2, Void >;
friend struct ActorCallback< RunTestActor, 3, Void >;
															#line 277 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	RunTestActor(TransactionCostWorkload* const& self,Database const& cx,ITest* const& test) 
															#line 2262 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		 : Actor<Void>(),
		   RunTestActorState<RunTestActor>(self, cx, test),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12013671372596341504UL, 10273208522725205248UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunTestActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunTestActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunTestActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunTestActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 277 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
[[nodiscard]] static Future<Void> runTest( TransactionCostWorkload* const& self, Database const& cx, ITest* const& test ) {
															#line 277 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	return Future<Void>(new RunTestActor(self, cx, test));
															#line 2297 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
}

#line 294 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"

																#line 2302 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
// This generated class is to be used only via start()
															#line 295 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
template <class StartActor>
															#line 295 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
class StartActorState {
															#line 2308 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
public:
															#line 295 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	StartActorState(TransactionCostWorkload* const& self,Database const& cx) 
															#line 295 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
															#line 295 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		 : self(self),
															#line 295 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		   cx(cx),
															#line 296 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		   testNumber(0),
															#line 297 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		   f(),
															#line 299 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		   test()
															#line 2323 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
	{
		fdb_probe_actor_create("start", reinterpret_cast<unsigned long>(this));

	}
	~StartActorState() 
	{
		fdb_probe_actor_destroy("start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 300 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
			;
															#line 2338 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartActorState();
		static_cast<StartActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 304 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		if (!static_cast<StartActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartActorState(); static_cast<StartActor*>(this)->destroy(); return 0; }
															#line 2361 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		new (&static_cast<StartActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartActorState();
		static_cast<StartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 300 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		if (!(testNumber < self->iterations))
															#line 2380 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 301 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		test = createRandomTest(testNumber);
															#line 302 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		StrictFuture<Void> __when_expr_0 = runTest(self, cx, test.get());
															#line 302 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		if (static_cast<StartActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2390 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<StartActor*>(this)->actor_wait_state = 1;
															#line 302 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartActor, 0, Void >*>(static_cast<StartActor*>(this)));
															#line 2395 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 300 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		++testNumber;
															#line 2417 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 300 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
		++testNumber;
															#line 2426 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartActor*>(this)->actor_wait_state > 0) static_cast<StartActor*>(this)->actor_wait_state = 0;
		static_cast<StartActor*>(this)->ActorCallback< StartActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("start", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 295 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	TransactionCostWorkload* self;
															#line 295 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	Database cx;
															#line 296 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	uint64_t testNumber;
															#line 297 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	Future<Void> f;
															#line 299 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	std::shared_ptr<ITest> test;
															#line 2516 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
};
// This generated class is to be used only via start()
															#line 295 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
class StartActor final : public Actor<Void>, public ActorCallback< StartActor, 0, Void >, public FastAllocated<StartActor>, public StartActorState<StartActor> {
															#line 2521 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
public:
	using FastAllocated<StartActor>::operator new;
	using FastAllocated<StartActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9513717160840455168UL, 17844299030031408128UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartActor, 0, Void >;
															#line 295 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	StartActor(TransactionCostWorkload* const& self,Database const& cx) 
															#line 2538 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
		 : Actor<Void>(),
		   StartActorState<StartActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10219404671476595456UL, 16609373904378240000UL);
		ActorExecutionContextHelper __helper(static_cast<StartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 295 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
[[nodiscard]] static Future<Void> start( TransactionCostWorkload* const& self, Database const& cx ) {
															#line 295 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"
	return Future<Void>(new StartActor(self, cx));
															#line 2570 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TransactionCost.actor.g.cpp"
}

#line 306 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/TransactionCost.actor.cpp"

public:
	TransactionCostWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		iterations = getOption(options, "iterations"_sr, 1000);
		prefix = getOption(options, "prefix"_sr, "transactionCost/"_sr);
		debugTransactions = getOption(options, "debug"_sr, false);
	}

	static constexpr auto NAME = "TransactionCost";

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override { return clientId ? Void() : start(this, cx); }

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<TransactionCostWorkload> TransactionCostWorkloadFactory;
