#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
#include <algorithm>
#include <cstdint>
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/Status.h"
#include "fdbclient/StatusClient.h"
#include "fdbrpc/PerfMetric.h"
#include "fdbrpc/SimulatorProcessInfo.h"
#include "fdbrpc/simulator.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/ServerDBInfo.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/Buggify.h"
#include "flow/Error.h"
#include "flow/IPAddress.h"
#include "flow/IRandom.h"
#include "flow/NetworkAddress.h"
#include "flow/Optional.h"
#include "flow/Trace.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

struct ClogRemoteTLog : TestWorkload {
	static constexpr auto NAME = "ClogRemoteTLog";

	bool enabled{ false };
	bool doCheck{ false };
	double testDuration{ 0.0 };
	double lagMeasurementFrequency{ 0 };
	double clogInitDelay{ 0 };
	double lagThreshold{ 0 };

	enum TestState { TEST_INIT, SS_LAG_NORMAL, SS_LAG_HIGH, CLOGGED_REMOTE_TLOG_EXCLUDED };
	struct StatePath {
		std::vector<TestState> path;
		bool prefixMatch{ true };
	};
	const std::vector<StatePath> expectedStatePaths{
		{ .path = { TEST_INIT, SS_LAG_NORMAL, SS_LAG_HIGH, SS_LAG_NORMAL } },
		// For some topology and process placements, it's possible that the lag does not recover. However, we still
		// allow the test to pass as long as the bad/clogged remote tlog was excluded by gray failure.
		{ .path = { TEST_INIT, SS_LAG_NORMAL, SS_LAG_HIGH, CLOGGED_REMOTE_TLOG_EXCLUDED } },
		{ .path = { TEST_INIT, SS_LAG_NORMAL, CLOGGED_REMOTE_TLOG_EXCLUDED } },
		{ .path = { TEST_INIT, SS_LAG_HIGH, CLOGGED_REMOTE_TLOG_EXCLUDED } },
		{ .path = { TEST_INIT, SS_LAG_HIGH, SS_LAG_NORMAL } }
	};
	std::vector<TestState>
	    actualStatePath; // to be populated when the test runs, and finally checked at the end in check()

	Optional<NetworkAddress>
	    cloggedRemoteTLog; // set after clogging is done, we use this state to ensure that it's
	                       // eventually not present in dbInfo (which implies it was excluded by gray failure)

	ClogRemoteTLog(const WorkloadContext& wctx) : TestWorkload(wctx) {
		enabled =
		    (clientId == 0); // only run this workload for a single client, and that too the first client (by its id)
		testDuration = getOption(options, "testDuration"_sr, 120);
		lagMeasurementFrequency = getOption(options, "lagMeasurementFrequency"_sr, 5);
		clogInitDelay = getOption(options, "clogInitDelay"_sr, 10);
		lagThreshold = getOption(options, "lagThreshold"_sr, 20);
	}

	Future<Void> setup(const Database& db) override { return Void(); }

	Future<Void> start(const Database& db) override {
		if (!g_network->isSimulated() || !enabled) {
			return Void();
		}
		return timeout(reportErrors(workload(this, db), "ClogRemoteTLogError"), testDuration, Void());
	}

	Future<bool> check(const Database& db) override {
		if (!g_network->isSimulated() || !enabled) {
			return true;
		}
		// First, emit trace event for potential debugging if test fails
		auto stateToStr = [](const TestState testState) -> std::string {
			switch (testState) {
			case (TEST_INIT): {
				return "TEST_INIT";
			}
			case (SS_LAG_NORMAL): {
				return "SS_LAG_NORMAL";
			}
			case (SS_LAG_HIGH): {
				return "SS_LAG_HIGH";
			}
			case (CLOGGED_REMOTE_TLOG_EXCLUDED): {
				return "CLOGGED_REMOTE_TLOG_EXCLUDED";
			}
			default: {
				ASSERT(false);
				return "";
			}
			};
		};
		auto print = [&stateToStr](const std::vector<TestState>& path) {
			std::string ret;
			for (size_t i = 0; i < path.size(); ++i) {
				const auto pathState = path[i];
				ret += stateToStr(pathState) + (i < path.size() - 1 ? std::string{ " -> " } : std::string{ "" });
			}
			return ret;
		};
		TraceEvent("ClogRemoteTLogCheck").detail("ActualStatePath", print(actualStatePath)).detail("DoCheck", doCheck);
		if (!doCheck || isGeneralBuggifyEnabled()) {
			return true;
		}

		// Then, do the actual check
		auto match =
		    [](const std::vector<TestState>& actualPath,
		       const std::vector<TestState>& expectedPath,
		       const bool
		           allowPrefix /* when true, relaxes match as long as a prefix of actualPath matches expectedPath */)
		    -> bool {
			if (!allowPrefix && actualPath.size() != expectedPath.size()) {
				return false;
			} else if (allowPrefix && actualPath.size() < expectedPath.size()) {
				return false;
			}
			for (size_t i = 0; i < std::min(actualPath.size(), expectedPath.size()); ++i) {
				if (actualPath[i] != expectedPath[i]) {
					return false;
				}
			}
			return true;
		};
		for (const auto& expectedPath : expectedStatePaths) {
			if (match(actualStatePath, expectedPath.path, expectedPath.prefixMatch)) {
				return true;
			}
		}
		TraceEvent(SevError, "ClogRemoteTLogCheckFailed");
		return false;
	}

	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 144 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
// This generated class is to be used only via measureMaxSSLag()
															#line 142 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
template <class MeasureMaxSSLagActor>
															#line 142 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
class MeasureMaxSSLagActorState {
															#line 150 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
public:
															#line 142 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	MeasureMaxSSLagActorState(ClogRemoteTLog* const& self,Database const& db) 
															#line 142 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
															#line 142 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		 : self(self),
															#line 142 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		   db(db)
															#line 159 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
	{
		fdb_probe_actor_create("measureMaxSSLag", reinterpret_cast<unsigned long>(this));

	}
	~MeasureMaxSSLagActorState() 
	{
		fdb_probe_actor_destroy("measureMaxSSLag", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 143 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			StrictFuture<StatusObject> __when_expr_0 = StatusClient::statusFetcher(db);
															#line 143 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (static_cast<MeasureMaxSSLagActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 176 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MeasureMaxSSLagActor*>(this)->actor_wait_state = 1;
															#line 143 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MeasureMaxSSLagActor, 0, StatusObject >*>(static_cast<MeasureMaxSSLagActor*>(this)));
															#line 181 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MeasureMaxSSLagActorState();
		static_cast<MeasureMaxSSLagActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(StatusObject const& status,int loopDepth) 
	{
															#line 144 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		StatusObjectReader reader(status);
															#line 145 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		StatusObjectReader cluster;
															#line 146 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		StatusObjectReader processMap;
															#line 147 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (!reader.get("cluster", cluster))
															#line 210 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		{
															#line 148 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			TraceEvent("NoCluster");
															#line 149 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (!static_cast<MeasureMaxSSLagActor*>(this)->SAV<Optional<double>>::futures) { (void)(Optional<double>()); this->~MeasureMaxSSLagActorState(); static_cast<MeasureMaxSSLagActor*>(this)->destroy(); return 0; }
															#line 216 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			new (&static_cast<MeasureMaxSSLagActor*>(this)->SAV< Optional<double> >::value()) Optional<double>(Optional<double>());
			this->~MeasureMaxSSLagActorState();
			static_cast<MeasureMaxSSLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 151 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (!cluster.get("processes", processMap))
															#line 224 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		{
															#line 152 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			TraceEvent("NoProcesses");
															#line 153 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (!static_cast<MeasureMaxSSLagActor*>(this)->SAV<Optional<double>>::futures) { (void)(Optional<double>()); this->~MeasureMaxSSLagActorState(); static_cast<MeasureMaxSSLagActor*>(this)->destroy(); return 0; }
															#line 230 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			new (&static_cast<MeasureMaxSSLagActor*>(this)->SAV< Optional<double> >::value()) Optional<double>(Optional<double>());
			this->~MeasureMaxSSLagActorState();
			static_cast<MeasureMaxSSLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 155 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		double maxSSLag{ -1 };
															#line 156 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		for( auto p : processMap.obj() ) {
															#line 157 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			StatusObjectReader process(p.second);
															#line 158 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (process.has("roles"))
															#line 244 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			{
															#line 159 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
				StatusArray roles = p.second.get_obj()["roles"].get_array();
															#line 160 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
				for( StatusObjectReader role : roles ) {
															#line 161 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
					ASSERT(role.has("role"));
															#line 162 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
					if (role.has("data_lag"))
															#line 254 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
					{
															#line 163 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
						ASSERT(role["role"].get_str() == "storage");
															#line 164 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
						auto dataLag = role["data_lag"].get_obj();
															#line 165 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
						ASSERT(dataLag.contains("seconds"));
															#line 166 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
						ASSERT(dataLag.contains("versions"));
															#line 167 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
						TraceEvent("SSDataLag") .detail("Process", p.first) .detail("Role", role["role"].get_str()) .detail("SecondLag", dataLag["seconds"].get_value<double>()) .detail("VersionLag", dataLag["versions"].get_int64());
															#line 172 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
						maxSSLag = std::max(maxSSLag, dataLag["seconds"].get_value<double>());
															#line 268 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
					}
				}
			}
		}
															#line 177 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		TraceEvent("MaxSSDataLag") .detail("SecondLag", maxSSLag == -1 ? "none" : std::to_string(maxSSLag)) .detail("SecondThreshold", self->lagThreshold);
															#line 180 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (maxSSLag == -1)
															#line 277 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		{
															#line 181 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (!static_cast<MeasureMaxSSLagActor*>(this)->SAV<Optional<double>>::futures) { (void)(Optional<double>()); this->~MeasureMaxSSLagActorState(); static_cast<MeasureMaxSSLagActor*>(this)->destroy(); return 0; }
															#line 281 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			new (&static_cast<MeasureMaxSSLagActor*>(this)->SAV< Optional<double> >::value()) Optional<double>(Optional<double>());
			this->~MeasureMaxSSLagActorState();
			static_cast<MeasureMaxSSLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 183 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (!static_cast<MeasureMaxSSLagActor*>(this)->SAV<Optional<double>>::futures) { (void)(maxSSLag); this->~MeasureMaxSSLagActorState(); static_cast<MeasureMaxSSLagActor*>(this)->destroy(); return 0; }
															#line 291 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			new (&static_cast<MeasureMaxSSLagActor*>(this)->SAV< Optional<double> >::value()) Optional<double>(maxSSLag);
			this->~MeasureMaxSSLagActorState();
			static_cast<MeasureMaxSSLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1cont1(StatusObject && status,int loopDepth) 
	{
															#line 144 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		StatusObjectReader reader(status);
															#line 145 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		StatusObjectReader cluster;
															#line 146 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		StatusObjectReader processMap;
															#line 147 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (!reader.get("cluster", cluster))
															#line 310 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		{
															#line 148 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			TraceEvent("NoCluster");
															#line 149 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (!static_cast<MeasureMaxSSLagActor*>(this)->SAV<Optional<double>>::futures) { (void)(Optional<double>()); this->~MeasureMaxSSLagActorState(); static_cast<MeasureMaxSSLagActor*>(this)->destroy(); return 0; }
															#line 316 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			new (&static_cast<MeasureMaxSSLagActor*>(this)->SAV< Optional<double> >::value()) Optional<double>(Optional<double>());
			this->~MeasureMaxSSLagActorState();
			static_cast<MeasureMaxSSLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 151 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (!cluster.get("processes", processMap))
															#line 324 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		{
															#line 152 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			TraceEvent("NoProcesses");
															#line 153 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (!static_cast<MeasureMaxSSLagActor*>(this)->SAV<Optional<double>>::futures) { (void)(Optional<double>()); this->~MeasureMaxSSLagActorState(); static_cast<MeasureMaxSSLagActor*>(this)->destroy(); return 0; }
															#line 330 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			new (&static_cast<MeasureMaxSSLagActor*>(this)->SAV< Optional<double> >::value()) Optional<double>(Optional<double>());
			this->~MeasureMaxSSLagActorState();
			static_cast<MeasureMaxSSLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 155 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		double maxSSLag{ -1 };
															#line 156 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		for( auto p : processMap.obj() ) {
															#line 157 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			StatusObjectReader process(p.second);
															#line 158 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (process.has("roles"))
															#line 344 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			{
															#line 159 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
				StatusArray roles = p.second.get_obj()["roles"].get_array();
															#line 160 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
				for( StatusObjectReader role : roles ) {
															#line 161 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
					ASSERT(role.has("role"));
															#line 162 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
					if (role.has("data_lag"))
															#line 354 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
					{
															#line 163 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
						ASSERT(role["role"].get_str() == "storage");
															#line 164 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
						auto dataLag = role["data_lag"].get_obj();
															#line 165 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
						ASSERT(dataLag.contains("seconds"));
															#line 166 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
						ASSERT(dataLag.contains("versions"));
															#line 167 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
						TraceEvent("SSDataLag") .detail("Process", p.first) .detail("Role", role["role"].get_str()) .detail("SecondLag", dataLag["seconds"].get_value<double>()) .detail("VersionLag", dataLag["versions"].get_int64());
															#line 172 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
						maxSSLag = std::max(maxSSLag, dataLag["seconds"].get_value<double>());
															#line 368 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
					}
				}
			}
		}
															#line 177 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		TraceEvent("MaxSSDataLag") .detail("SecondLag", maxSSLag == -1 ? "none" : std::to_string(maxSSLag)) .detail("SecondThreshold", self->lagThreshold);
															#line 180 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (maxSSLag == -1)
															#line 377 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		{
															#line 181 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (!static_cast<MeasureMaxSSLagActor*>(this)->SAV<Optional<double>>::futures) { (void)(Optional<double>()); this->~MeasureMaxSSLagActorState(); static_cast<MeasureMaxSSLagActor*>(this)->destroy(); return 0; }
															#line 381 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			new (&static_cast<MeasureMaxSSLagActor*>(this)->SAV< Optional<double> >::value()) Optional<double>(Optional<double>());
			this->~MeasureMaxSSLagActorState();
			static_cast<MeasureMaxSSLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 183 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (!static_cast<MeasureMaxSSLagActor*>(this)->SAV<Optional<double>>::futures) { (void)(maxSSLag); this->~MeasureMaxSSLagActorState(); static_cast<MeasureMaxSSLagActor*>(this)->destroy(); return 0; }
															#line 391 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			new (&static_cast<MeasureMaxSSLagActor*>(this)->SAV< Optional<double> >::value()) Optional<double>(maxSSLag);
			this->~MeasureMaxSSLagActorState();
			static_cast<MeasureMaxSSLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1when1(StatusObject const& status,int loopDepth) 
	{
		loopDepth = a_body1cont1(status, loopDepth);

		return loopDepth;
	}
	int a_body1when1(StatusObject && status,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(status), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MeasureMaxSSLagActor*>(this)->actor_wait_state > 0) static_cast<MeasureMaxSSLagActor*>(this)->actor_wait_state = 0;
		static_cast<MeasureMaxSSLagActor*>(this)->ActorCallback< MeasureMaxSSLagActor, 0, StatusObject >::remove();

	}
	void a_callback_fire(ActorCallback< MeasureMaxSSLagActor, 0, StatusObject >*,StatusObject const& value) 
	{
		fdb_probe_actor_enter("measureMaxSSLag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MeasureMaxSSLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("measureMaxSSLag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MeasureMaxSSLagActor, 0, StatusObject >*,StatusObject && value) 
	{
		fdb_probe_actor_enter("measureMaxSSLag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MeasureMaxSSLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("measureMaxSSLag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MeasureMaxSSLagActor, 0, StatusObject >*,Error err) 
	{
		fdb_probe_actor_enter("measureMaxSSLag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MeasureMaxSSLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("measureMaxSSLag", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 142 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	ClogRemoteTLog* self;
															#line 142 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	Database db;
															#line 479 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
};
// This generated class is to be used only via measureMaxSSLag()
															#line 142 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
class MeasureMaxSSLagActor final : public Actor<Optional<double>>, public ActorCallback< MeasureMaxSSLagActor, 0, StatusObject >, public FastAllocated<MeasureMaxSSLagActor>, public MeasureMaxSSLagActorState<MeasureMaxSSLagActor> {
															#line 484 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
public:
	using FastAllocated<MeasureMaxSSLagActor>::operator new;
	using FastAllocated<MeasureMaxSSLagActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10442044351411711488UL, 8167489392143331584UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<double>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MeasureMaxSSLagActor, 0, StatusObject >;
															#line 142 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	MeasureMaxSSLagActor(ClogRemoteTLog* const& self,Database const& db) 
															#line 501 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		 : Actor<Optional<double>>(),
		   MeasureMaxSSLagActorState<MeasureMaxSSLagActor>(self, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("measureMaxSSLag", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(658222051430509312UL, 8885159623953715200UL);
		ActorExecutionContextHelper __helper(static_cast<MeasureMaxSSLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("measureMaxSSLag");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("measureMaxSSLag", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MeasureMaxSSLagActor, 0, StatusObject >*)0, actor_cancelled()); break;
		}

	}
};
															#line 142 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
[[nodiscard]] static Future<Optional<double>> measureMaxSSLag( ClogRemoteTLog* const& self, Database const& db ) {
															#line 142 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	return Future<Optional<double>>(new MeasureMaxSSLagActor(self, db));
															#line 533 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
}

#line 186 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"

	// Returns true if and only if there's a general error in fetching status json
	// An example failure is network issue from client to CC (server)
	static bool statusError(StatusObjectReader reader) {
		static const auto errors{ []() {
			std::unordered_set<std::string> errors;
			std::for_each(messageTypeToName.begin(), messageTypeToName.end(), [&errors](const auto& kvPair) {
				errors.insert(kvPair.second);
			});
			return errors;
		}() };

		StatusObjectReader client;
		if (!reader.get("client", client)) {
			TraceEvent("NoClient");
			return true;
		}

		StatusObjectReader cluster;
		if (!reader.get("cluster", cluster)) {
			TraceEvent("NoCluster");
			return true;
		}

		ASSERT(client.has("messages"));
		StatusArray messages = client["messages"].get_array();
		for (StatusObjectReader message : messages) {
			if (message.has("name") && errors.contains(message["name"].get_str())) {
				TraceEvent("StatusError").detail("Name", message["name"].get_str());
				return true;
			}
		}

		return false;
	}

																#line 573 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
// This generated class is to be used only via grayFailureStatusCheck()
															#line 222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
template <class GrayFailureStatusCheckActor>
															#line 222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
class GrayFailureStatusCheckActorState {
															#line 579 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
public:
															#line 222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	GrayFailureStatusCheckActorState(Database const& db,NetworkAddress const& cloggedRemoteTLog) 
															#line 222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
															#line 222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		 : db(db),
															#line 222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		   cloggedRemoteTLog(cloggedRemoteTLog)
															#line 588 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
	{
		fdb_probe_actor_create("grayFailureStatusCheck", reinterpret_cast<unsigned long>(this));

	}
	~GrayFailureStatusCheckActorState() 
	{
		fdb_probe_actor_destroy("grayFailureStatusCheck", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 223 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			StrictFuture<StatusObject> __when_expr_0 = StatusClient::statusFetcher(db);
															#line 223 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (static_cast<GrayFailureStatusCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 605 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GrayFailureStatusCheckActor*>(this)->actor_wait_state = 1;
															#line 223 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GrayFailureStatusCheckActor, 0, StatusObject >*>(static_cast<GrayFailureStatusCheckActor*>(this)));
															#line 610 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GrayFailureStatusCheckActorState();
		static_cast<GrayFailureStatusCheckActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(StatusObject const& status,int loopDepth) 
	{
															#line 224 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		StatusObjectReader reader(status);
															#line 226 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (statusError(reader))
															#line 635 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		{
															#line 229 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (!static_cast<GrayFailureStatusCheckActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GrayFailureStatusCheckActorState(); static_cast<GrayFailureStatusCheckActor*>(this)->destroy(); return 0; }
															#line 639 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			new (&static_cast<GrayFailureStatusCheckActor*>(this)->SAV< bool >::value()) bool(true);
			this->~GrayFailureStatusCheckActorState();
			static_cast<GrayFailureStatusCheckActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 232 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		StatusObjectReader cluster;
															#line 233 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		ASSERT(reader.get("cluster", cluster));
															#line 234 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		StatusObjectReader grayFailure;
															#line 235 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (!cluster.get("gray_failure", grayFailure))
															#line 653 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		{
															#line 236 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			TraceEvent("NoGrayFailure");
															#line 237 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (!static_cast<GrayFailureStatusCheckActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GrayFailureStatusCheckActorState(); static_cast<GrayFailureStatusCheckActor*>(this)->destroy(); return 0; }
															#line 659 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			new (&static_cast<GrayFailureStatusCheckActor*>(this)->SAV< bool >::value()) bool(false);
			this->~GrayFailureStatusCheckActorState();
			static_cast<GrayFailureStatusCheckActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 239 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		ASSERT(grayFailure.has("excluded_servers"));
															#line 240 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		StatusArray excludedProcesses = grayFailure["excluded_servers"].get_array();
															#line 241 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		for( StatusObjectReader process : excludedProcesses ) {
															#line 242 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			ASSERT(process.has("address"));
															#line 243 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			ASSERT(process.has("time"));
															#line 244 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			TraceEvent("GrayFailureStatus") .detail("Address", process["address"].get_str()) .detail("Ts", process["time"].get_real());
															#line 677 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		}
															#line 248 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (!static_cast<GrayFailureStatusCheckActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GrayFailureStatusCheckActorState(); static_cast<GrayFailureStatusCheckActor*>(this)->destroy(); return 0; }
															#line 681 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		new (&static_cast<GrayFailureStatusCheckActor*>(this)->SAV< bool >::value()) bool(true);
		this->~GrayFailureStatusCheckActorState();
		static_cast<GrayFailureStatusCheckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(StatusObject && status,int loopDepth) 
	{
															#line 224 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		StatusObjectReader reader(status);
															#line 226 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (statusError(reader))
															#line 695 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		{
															#line 229 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (!static_cast<GrayFailureStatusCheckActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GrayFailureStatusCheckActorState(); static_cast<GrayFailureStatusCheckActor*>(this)->destroy(); return 0; }
															#line 699 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			new (&static_cast<GrayFailureStatusCheckActor*>(this)->SAV< bool >::value()) bool(true);
			this->~GrayFailureStatusCheckActorState();
			static_cast<GrayFailureStatusCheckActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 232 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		StatusObjectReader cluster;
															#line 233 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		ASSERT(reader.get("cluster", cluster));
															#line 234 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		StatusObjectReader grayFailure;
															#line 235 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (!cluster.get("gray_failure", grayFailure))
															#line 713 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		{
															#line 236 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			TraceEvent("NoGrayFailure");
															#line 237 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (!static_cast<GrayFailureStatusCheckActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GrayFailureStatusCheckActorState(); static_cast<GrayFailureStatusCheckActor*>(this)->destroy(); return 0; }
															#line 719 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			new (&static_cast<GrayFailureStatusCheckActor*>(this)->SAV< bool >::value()) bool(false);
			this->~GrayFailureStatusCheckActorState();
			static_cast<GrayFailureStatusCheckActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 239 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		ASSERT(grayFailure.has("excluded_servers"));
															#line 240 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		StatusArray excludedProcesses = grayFailure["excluded_servers"].get_array();
															#line 241 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		for( StatusObjectReader process : excludedProcesses ) {
															#line 242 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			ASSERT(process.has("address"));
															#line 243 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			ASSERT(process.has("time"));
															#line 244 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			TraceEvent("GrayFailureStatus") .detail("Address", process["address"].get_str()) .detail("Ts", process["time"].get_real());
															#line 737 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		}
															#line 248 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (!static_cast<GrayFailureStatusCheckActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GrayFailureStatusCheckActorState(); static_cast<GrayFailureStatusCheckActor*>(this)->destroy(); return 0; }
															#line 741 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		new (&static_cast<GrayFailureStatusCheckActor*>(this)->SAV< bool >::value()) bool(true);
		this->~GrayFailureStatusCheckActorState();
		static_cast<GrayFailureStatusCheckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(StatusObject const& status,int loopDepth) 
	{
		loopDepth = a_body1cont1(status, loopDepth);

		return loopDepth;
	}
	int a_body1when1(StatusObject && status,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(status), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GrayFailureStatusCheckActor*>(this)->actor_wait_state > 0) static_cast<GrayFailureStatusCheckActor*>(this)->actor_wait_state = 0;
		static_cast<GrayFailureStatusCheckActor*>(this)->ActorCallback< GrayFailureStatusCheckActor, 0, StatusObject >::remove();

	}
	void a_callback_fire(ActorCallback< GrayFailureStatusCheckActor, 0, StatusObject >*,StatusObject const& value) 
	{
		fdb_probe_actor_enter("grayFailureStatusCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GrayFailureStatusCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grayFailureStatusCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GrayFailureStatusCheckActor, 0, StatusObject >*,StatusObject && value) 
	{
		fdb_probe_actor_enter("grayFailureStatusCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GrayFailureStatusCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grayFailureStatusCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GrayFailureStatusCheckActor, 0, StatusObject >*,Error err) 
	{
		fdb_probe_actor_enter("grayFailureStatusCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GrayFailureStatusCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grayFailureStatusCheck", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	Database db;
															#line 222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	NetworkAddress cloggedRemoteTLog;
															#line 828 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
};
// This generated class is to be used only via grayFailureStatusCheck()
															#line 222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
class GrayFailureStatusCheckActor final : public Actor<bool>, public ActorCallback< GrayFailureStatusCheckActor, 0, StatusObject >, public FastAllocated<GrayFailureStatusCheckActor>, public GrayFailureStatusCheckActorState<GrayFailureStatusCheckActor> {
															#line 833 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
public:
	using FastAllocated<GrayFailureStatusCheckActor>::operator new;
	using FastAllocated<GrayFailureStatusCheckActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13268250807706721536UL, 12752958531483824640UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GrayFailureStatusCheckActor, 0, StatusObject >;
															#line 222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	GrayFailureStatusCheckActor(Database const& db,NetworkAddress const& cloggedRemoteTLog) 
															#line 850 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		 : Actor<bool>(),
		   GrayFailureStatusCheckActorState<GrayFailureStatusCheckActor>(db, cloggedRemoteTLog),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("grayFailureStatusCheck", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(303314730933582848UL, 7939907357427156992UL);
		ActorExecutionContextHelper __helper(static_cast<GrayFailureStatusCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("grayFailureStatusCheck");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("grayFailureStatusCheck", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GrayFailureStatusCheckActor, 0, StatusObject >*)0, actor_cancelled()); break;
		}

	}
};
															#line 222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
[[nodiscard]] static Future<bool> grayFailureStatusCheck( Database const& db, NetworkAddress const& cloggedRemoteTLog ) {
															#line 222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	return Future<bool>(new GrayFailureStatusCheckActor(db, cloggedRemoteTLog));
															#line 882 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
}

#line 250 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"

																#line 887 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
// This generated class is to be used only via getRemoteSSIPs()
															#line 251 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
template <class GetRemoteSSIPsActor>
															#line 251 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
class GetRemoteSSIPsActorState {
															#line 893 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
public:
															#line 251 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	GetRemoteSSIPsActorState(Database const& db) 
															#line 251 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
															#line 251 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		 : db(db),
															#line 252 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		   ret(),
															#line 253 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		   tr(db)
															#line 904 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
	{
		fdb_probe_actor_create("getRemoteSSIPs", reinterpret_cast<unsigned long>(this));

	}
	~GetRemoteSSIPsActorState() 
	{
		fdb_probe_actor_destroy("getRemoteSSIPs", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 254 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			;
															#line 919 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRemoteSSIPsActorState();
		static_cast<GetRemoteSSIPsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 256 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 257 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 258 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 259 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			StrictFuture<std::vector<std::pair<StorageServerInterface, ProcessClass>>> __when_expr_0 = NativeAPI::getServerListAndProcessClasses(&tr);
															#line 259 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (static_cast<GetRemoteSSIPsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 958 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetRemoteSSIPsActor*>(this)->actor_wait_state = 1;
															#line 259 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRemoteSSIPsActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*>(static_cast<GetRemoteSSIPsActor*>(this)));
															#line 963 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 269 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 985 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			{
															#line 270 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
				TraceEvent("GetRemoteSSIPsError").error(e);
															#line 989 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			}
															#line 272 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 272 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (static_cast<GetRemoteSSIPsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 995 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetRemoteSSIPsActor*>(this)->actor_wait_state = 2;
															#line 272 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRemoteSSIPsActor, 1, Void >*>(static_cast<GetRemoteSSIPsActor*>(this)));
															#line 1000 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::vector<std::pair<StorageServerInterface, ProcessClass>> const& results,int loopDepth) 
	{
															#line 261 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		for( auto& [ssi, p] : results ) {
															#line 262 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (ssi.locality.dcId().present() && g_simulator->remoteDcId.present() && ssi.locality.dcId().get() == g_simulator->remoteDcId.get())
															#line 1017 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			{
															#line 264 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
				ret.push_back(ssi.address().ip);
															#line 1021 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			}
		}
															#line 267 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (!static_cast<GetRemoteSSIPsActor*>(this)->SAV<std::vector<IPAddress>>::futures) { (void)(ret); this->~GetRemoteSSIPsActorState(); static_cast<GetRemoteSSIPsActor*>(this)->destroy(); return 0; }
															#line 1026 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		new (&static_cast<GetRemoteSSIPsActor*>(this)->SAV< std::vector<IPAddress> >::value()) std::vector<IPAddress>(std::move(ret)); // state_var_RVO
		this->~GetRemoteSSIPsActorState();
		static_cast<GetRemoteSSIPsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::vector<std::pair<StorageServerInterface, ProcessClass>> && results,int loopDepth) 
	{
															#line 261 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		for( auto& [ssi, p] : results ) {
															#line 262 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (ssi.locality.dcId().present() && g_simulator->remoteDcId.present() && ssi.locality.dcId().get() == g_simulator->remoteDcId.get())
															#line 1040 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			{
															#line 264 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
				ret.push_back(ssi.address().ip);
															#line 1044 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			}
		}
															#line 267 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (!static_cast<GetRemoteSSIPsActor*>(this)->SAV<std::vector<IPAddress>>::futures) { (void)(ret); this->~GetRemoteSSIPsActorState(); static_cast<GetRemoteSSIPsActor*>(this)->destroy(); return 0; }
															#line 1049 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		new (&static_cast<GetRemoteSSIPsActor*>(this)->SAV< std::vector<IPAddress> >::value()) std::vector<IPAddress>(std::move(ret)); // state_var_RVO
		this->~GetRemoteSSIPsActorState();
		static_cast<GetRemoteSSIPsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<std::pair<StorageServerInterface, ProcessClass>> const& results,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(results, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<std::pair<StorageServerInterface, ProcessClass>> && results,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRemoteSSIPsActor*>(this)->actor_wait_state > 0) static_cast<GetRemoteSSIPsActor*>(this)->actor_wait_state = 0;
		static_cast<GetRemoteSSIPsActor*>(this)->ActorCallback< GetRemoteSSIPsActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetRemoteSSIPsActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*,std::vector<std::pair<StorageServerInterface, ProcessClass>> const& value) 
	{
		fdb_probe_actor_enter("getRemoteSSIPs", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRemoteSSIPsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRemoteSSIPs", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRemoteSSIPsActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*,std::vector<std::pair<StorageServerInterface, ProcessClass>> && value) 
	{
		fdb_probe_actor_enter("getRemoteSSIPs", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRemoteSSIPsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRemoteSSIPs", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRemoteSSIPsActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*,Error err) 
	{
		fdb_probe_actor_enter("getRemoteSSIPs", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRemoteSSIPsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRemoteSSIPs", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetRemoteSSIPsActor*>(this)->actor_wait_state > 0) static_cast<GetRemoteSSIPsActor*>(this)->actor_wait_state = 0;
		static_cast<GetRemoteSSIPsActor*>(this)->ActorCallback< GetRemoteSSIPsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRemoteSSIPsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRemoteSSIPs", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRemoteSSIPsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRemoteSSIPs", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRemoteSSIPsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRemoteSSIPs", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRemoteSSIPsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRemoteSSIPs", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRemoteSSIPsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRemoteSSIPs", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRemoteSSIPsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRemoteSSIPs", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 251 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	Database db;
															#line 252 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	std::vector<IPAddress> ret;
															#line 253 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	Transaction tr;
															#line 1225 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
};
// This generated class is to be used only via getRemoteSSIPs()
															#line 251 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
class GetRemoteSSIPsActor final : public Actor<std::vector<IPAddress>>, public ActorCallback< GetRemoteSSIPsActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >, public ActorCallback< GetRemoteSSIPsActor, 1, Void >, public FastAllocated<GetRemoteSSIPsActor>, public GetRemoteSSIPsActorState<GetRemoteSSIPsActor> {
															#line 1230 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
public:
	using FastAllocated<GetRemoteSSIPsActor>::operator new;
	using FastAllocated<GetRemoteSSIPsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1385724796386369792UL, 13392149099660154368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<IPAddress>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRemoteSSIPsActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >;
friend struct ActorCallback< GetRemoteSSIPsActor, 1, Void >;
															#line 251 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	GetRemoteSSIPsActor(Database const& db) 
															#line 1248 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		 : Actor<std::vector<IPAddress>>(),
		   GetRemoteSSIPsActorState<GetRemoteSSIPsActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRemoteSSIPs", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11621981849107400192UL, 14440376923228148736UL);
		ActorExecutionContextHelper __helper(static_cast<GetRemoteSSIPsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRemoteSSIPs");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRemoteSSIPs", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRemoteSSIPsActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetRemoteSSIPsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 251 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
[[nodiscard]] static Future<std::vector<IPAddress>> getRemoteSSIPs( Database const& db ) {
															#line 251 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	return Future<std::vector<IPAddress>>(new GetRemoteSSIPsActor(db));
															#line 1281 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
}

#line 276 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"

	static std::vector<NetworkAddress> getRemoteTLogs(ClogRemoteTLog* self) {
		std::vector<NetworkAddress> remoteTLogIPs;
		for (const auto& tLogSet : self->dbInfo->get().logSystemConfig.tLogs) {
			if (tLogSet.isLocal) {
				continue;
			}
			for (const auto& tLog : tLogSet.tLogs) {
				remoteTLogIPs.push_back(tLog.interf().address());
			}
		}
		return remoteTLogIPs;
	}

																#line 1299 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
// This generated class is to be used only via clogRemoteTLog()
															#line 290 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
template <class ClogRemoteTLogActor>
															#line 290 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
class ClogRemoteTLogActorState {
															#line 1305 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
public:
															#line 290 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	ClogRemoteTLogActorState(ClogRemoteTLog* const& self,Database const& db) 
															#line 290 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
															#line 290 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		 : self(self),
															#line 290 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		   db(db)
															#line 1314 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
	{
		fdb_probe_actor_create("clogRemoteTLog", reinterpret_cast<unsigned long>(this));

	}
	~ClogRemoteTLogActorState() 
	{
		fdb_probe_actor_destroy("clogRemoteTLog", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 291 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(self->clogInitDelay);
															#line 291 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (static_cast<ClogRemoteTLogActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1331 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClogRemoteTLogActor*>(this)->actor_wait_state = 1;
															#line 291 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClogRemoteTLogActor, 0, Void >*>(static_cast<ClogRemoteTLogActor*>(this)));
															#line 1336 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClogRemoteTLogActorState();
		static_cast<ClogRemoteTLogActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 294 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		;
															#line 1359 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 294 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		;
															#line 1368 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClogRemoteTLogActor*>(this)->actor_wait_state > 0) static_cast<ClogRemoteTLogActor*>(this)->actor_wait_state = 0;
		static_cast<ClogRemoteTLogActor*>(this)->ActorCallback< ClogRemoteTLogActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClogRemoteTLogActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clogRemoteTLog", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogRemoteTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogRemoteTLog", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClogRemoteTLogActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clogRemoteTLog", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogRemoteTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogRemoteTLog", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClogRemoteTLogActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clogRemoteTLog", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClogRemoteTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogRemoteTLog", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 299 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		remoteTLogs = getRemoteTLogs(self);
															#line 300 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		ASSERT(!remoteTLogs.empty());
															#line 303 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		StrictFuture<std::vector<IPAddress>> __when_expr_2 = getRemoteSSIPs(db);
															#line 303 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (static_cast<ClogRemoteTLogActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1458 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ClogRemoteTLogActor*>(this)->actor_wait_state = 3;
															#line 303 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClogRemoteTLogActor, 2, std::vector<IPAddress> >*>(static_cast<ClogRemoteTLogActor*>(this)));
															#line 1463 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 294 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (!(self->dbInfo->get().recoveryState < RecoveryState::FULLY_RECOVERED))
															#line 1479 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 295 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->dbInfo->onChange();
															#line 295 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (static_cast<ClogRemoteTLogActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1487 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClogRemoteTLogActor*>(this)->actor_wait_state = 2;
															#line 295 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClogRemoteTLogActor, 1, Void >*>(static_cast<ClogRemoteTLogActor*>(this)));
															#line 1492 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClogRemoteTLogActor*>(this)->actor_wait_state > 0) static_cast<ClogRemoteTLogActor*>(this)->actor_wait_state = 0;
		static_cast<ClogRemoteTLogActor*>(this)->ActorCallback< ClogRemoteTLogActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClogRemoteTLogActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clogRemoteTLog", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogRemoteTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogRemoteTLog", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClogRemoteTLogActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clogRemoteTLog", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogRemoteTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogRemoteTLog", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClogRemoteTLogActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clogRemoteTLog", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClogRemoteTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogRemoteTLog", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(std::vector<IPAddress> const& remoteSSIPs,int loopDepth) 
	{
															#line 304 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		ASSERT(!remoteSSIPs.empty());
															#line 307 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		Optional<NetworkAddress> isolatedRemoteTLog;
															#line 308 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		for( const auto& addr : remoteTLogs ) {
															#line 309 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (std::find(remoteSSIPs.begin(), remoteSSIPs.end(), addr.ip) == remoteSSIPs.end())
															#line 1607 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			{
															#line 310 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
				isolatedRemoteTLog = addr;
															#line 1611 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			}
		}
															#line 317 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		self->cloggedRemoteTLog = isolatedRemoteTLog.present() ? isolatedRemoteTLog.get() : self->cloggedRemoteTLog = remoteTLogs[deterministicRandom()->randomInt(0, remoteTLogs.size())];
															#line 321 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		ASSERT(self->cloggedRemoteTLog.present());
															#line 324 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		IPAddress cc = self->dbInfo->get().clusterInterface.address().ip;
															#line 325 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		processes = std::vector<IPAddress>();
															#line 326 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		for( const auto& process : g_simulator->getAllProcesses() ) {
															#line 327 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			const auto& ip = process->address.ip;
															#line 328 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (process->startingClass != ProcessClass::TesterClass && ip != cc)
															#line 1628 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			{
															#line 329 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
				processes.push_back(ip);
															#line 1632 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			}
		}
															#line 332 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		ASSERT(!processes.empty());
															#line 335 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		int numClogged{ 0 };
															#line 336 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		for( const auto& ip : processes ) {
															#line 337 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (self->cloggedRemoteTLog.get().ip == ip)
															#line 1643 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			{
				continue;
			}
															#line 340 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			double clogDuration = self->testDuration * (0.5 + 0.4 * deterministicRandom()->random01());
															#line 342 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			g_simulator->clogPair(ip, self->cloggedRemoteTLog.get().ip, clogDuration);
															#line 343 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			TraceEvent("ClogRemoteTLog") .detail("SrcIP", self->cloggedRemoteTLog->ip) .detail("DstIP", ip) .detail("Duration", clogDuration);
															#line 347 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			numClogged++;
															#line 1655 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		}
															#line 350 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (isolatedRemoteTLog.present() && numClogged > 1)
															#line 1659 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		{
															#line 351 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			self->doCheck = true;
															#line 1663 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		}
															#line 354 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		StrictFuture<Void> __when_expr_3 = Never();
															#line 354 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (static_cast<ClogRemoteTLogActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1669 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<ClogRemoteTLogActor*>(this)->actor_wait_state = 4;
															#line 354 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ClogRemoteTLogActor, 3, Void >*>(static_cast<ClogRemoteTLogActor*>(this)));
															#line 1674 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(std::vector<IPAddress> && remoteSSIPs,int loopDepth) 
	{
															#line 304 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		ASSERT(!remoteSSIPs.empty());
															#line 307 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		Optional<NetworkAddress> isolatedRemoteTLog;
															#line 308 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		for( const auto& addr : remoteTLogs ) {
															#line 309 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (std::find(remoteSSIPs.begin(), remoteSSIPs.end(), addr.ip) == remoteSSIPs.end())
															#line 1689 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			{
															#line 310 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
				isolatedRemoteTLog = addr;
															#line 1693 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			}
		}
															#line 317 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		self->cloggedRemoteTLog = isolatedRemoteTLog.present() ? isolatedRemoteTLog.get() : self->cloggedRemoteTLog = remoteTLogs[deterministicRandom()->randomInt(0, remoteTLogs.size())];
															#line 321 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		ASSERT(self->cloggedRemoteTLog.present());
															#line 324 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		IPAddress cc = self->dbInfo->get().clusterInterface.address().ip;
															#line 325 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		processes = std::vector<IPAddress>();
															#line 326 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		for( const auto& process : g_simulator->getAllProcesses() ) {
															#line 327 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			const auto& ip = process->address.ip;
															#line 328 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (process->startingClass != ProcessClass::TesterClass && ip != cc)
															#line 1710 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			{
															#line 329 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
				processes.push_back(ip);
															#line 1714 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			}
		}
															#line 332 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		ASSERT(!processes.empty());
															#line 335 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		int numClogged{ 0 };
															#line 336 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		for( const auto& ip : processes ) {
															#line 337 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (self->cloggedRemoteTLog.get().ip == ip)
															#line 1725 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			{
				continue;
			}
															#line 340 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			double clogDuration = self->testDuration * (0.5 + 0.4 * deterministicRandom()->random01());
															#line 342 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			g_simulator->clogPair(ip, self->cloggedRemoteTLog.get().ip, clogDuration);
															#line 343 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			TraceEvent("ClogRemoteTLog") .detail("SrcIP", self->cloggedRemoteTLog->ip) .detail("DstIP", ip) .detail("Duration", clogDuration);
															#line 347 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			numClogged++;
															#line 1737 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		}
															#line 350 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (isolatedRemoteTLog.present() && numClogged > 1)
															#line 1741 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		{
															#line 351 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			self->doCheck = true;
															#line 1745 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		}
															#line 354 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		StrictFuture<Void> __when_expr_3 = Never();
															#line 354 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (static_cast<ClogRemoteTLogActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1751 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<ClogRemoteTLogActor*>(this)->actor_wait_state = 4;
															#line 354 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ClogRemoteTLogActor, 3, Void >*>(static_cast<ClogRemoteTLogActor*>(this)));
															#line 1756 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<IPAddress> const& remoteSSIPs,int loopDepth) 
	{
		loopDepth = a_body1cont3(remoteSSIPs, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<IPAddress> && remoteSSIPs,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(remoteSSIPs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClogRemoteTLogActor*>(this)->actor_wait_state > 0) static_cast<ClogRemoteTLogActor*>(this)->actor_wait_state = 0;
		static_cast<ClogRemoteTLogActor*>(this)->ActorCallback< ClogRemoteTLogActor, 2, std::vector<IPAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< ClogRemoteTLogActor, 2, std::vector<IPAddress> >*,std::vector<IPAddress> const& value) 
	{
		fdb_probe_actor_enter("clogRemoteTLog", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogRemoteTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogRemoteTLog", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClogRemoteTLogActor, 2, std::vector<IPAddress> >*,std::vector<IPAddress> && value) 
	{
		fdb_probe_actor_enter("clogRemoteTLog", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogRemoteTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogRemoteTLog", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClogRemoteTLogActor, 2, std::vector<IPAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("clogRemoteTLog", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClogRemoteTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogRemoteTLog", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 355 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (!static_cast<ClogRemoteTLogActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClogRemoteTLogActorState(); static_cast<ClogRemoteTLogActor*>(this)->destroy(); return 0; }
															#line 1840 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		new (&static_cast<ClogRemoteTLogActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClogRemoteTLogActorState();
		static_cast<ClogRemoteTLogActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 355 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (!static_cast<ClogRemoteTLogActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClogRemoteTLogActorState(); static_cast<ClogRemoteTLogActor*>(this)->destroy(); return 0; }
															#line 1852 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		new (&static_cast<ClogRemoteTLogActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClogRemoteTLogActorState();
		static_cast<ClogRemoteTLogActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ClogRemoteTLogActor*>(this)->actor_wait_state > 0) static_cast<ClogRemoteTLogActor*>(this)->actor_wait_state = 0;
		static_cast<ClogRemoteTLogActor*>(this)->ActorCallback< ClogRemoteTLogActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClogRemoteTLogActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clogRemoteTLog", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogRemoteTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogRemoteTLog", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ClogRemoteTLogActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clogRemoteTLog", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogRemoteTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogRemoteTLog", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ClogRemoteTLogActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clogRemoteTLog", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClogRemoteTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogRemoteTLog", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 290 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	ClogRemoteTLog* self;
															#line 290 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	Database db;
															#line 299 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	std::vector<NetworkAddress> remoteTLogs;
															#line 325 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	std::vector<IPAddress> processes;
															#line 1943 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
};
// This generated class is to be used only via clogRemoteTLog()
															#line 290 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
class ClogRemoteTLogActor final : public Actor<Void>, public ActorCallback< ClogRemoteTLogActor, 0, Void >, public ActorCallback< ClogRemoteTLogActor, 1, Void >, public ActorCallback< ClogRemoteTLogActor, 2, std::vector<IPAddress> >, public ActorCallback< ClogRemoteTLogActor, 3, Void >, public FastAllocated<ClogRemoteTLogActor>, public ClogRemoteTLogActorState<ClogRemoteTLogActor> {
															#line 1948 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
public:
	using FastAllocated<ClogRemoteTLogActor>::operator new;
	using FastAllocated<ClogRemoteTLogActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17344727842740703232UL, 17307620886603516160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClogRemoteTLogActor, 0, Void >;
friend struct ActorCallback< ClogRemoteTLogActor, 1, Void >;
friend struct ActorCallback< ClogRemoteTLogActor, 2, std::vector<IPAddress> >;
friend struct ActorCallback< ClogRemoteTLogActor, 3, Void >;
															#line 290 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	ClogRemoteTLogActor(ClogRemoteTLog* const& self,Database const& db) 
															#line 1968 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		 : Actor<Void>(),
		   ClogRemoteTLogActorState<ClogRemoteTLogActor>(self, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clogRemoteTLog", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14880868891670526208UL, 10443577749208982528UL);
		ActorExecutionContextHelper __helper(static_cast<ClogRemoteTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clogRemoteTLog");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clogRemoteTLog", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClogRemoteTLogActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClogRemoteTLogActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClogRemoteTLogActor, 2, std::vector<IPAddress> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ClogRemoteTLogActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 290 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
[[nodiscard]] static Future<Void> clogRemoteTLog( ClogRemoteTLog* const& self, Database const& db ) {
															#line 290 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	return Future<Void>(new ClogRemoteTLogActor(self, db));
															#line 2003 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
}

#line 357 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"

	// Returns true if and only if the provided remote tlog `addr` is not in dbInfo
	static bool remoteTLogNotInDbInfo(const NetworkAddress& addr, const ServerDBInfo& dbInfo) {
		for (const auto& tLogSet : dbInfo.logSystemConfig.tLogs) {
			if (tLogSet.isLocal) {
				continue;
			}
			for (const auto& tLog : tLogSet.tLogs) {
				if (tLog.present() && tLog.interf().addresses().contains(addr)) {
					return false;
				}
			}
		}
		return true;
	}

																#line 2023 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
// This generated class is to be used only via workload()
															#line 373 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
template <class WorkloadActor>
															#line 373 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
class WorkloadActorState {
															#line 2029 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
public:
															#line 373 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	WorkloadActorState(ClogRemoteTLog* const& self,Database const& db) 
															#line 373 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
															#line 373 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		 : self(self),
															#line 373 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		   db(db),
															#line 374 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		   clog(self->clogRemoteTLog(self, db)),
															#line 375 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		   testState(TestState::TEST_INIT)
															#line 2042 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
	{
		fdb_probe_actor_create("workload", reinterpret_cast<unsigned long>(this));

	}
	~WorkloadActorState() 
	{
		fdb_probe_actor_destroy("workload", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 376 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			self->actualStatePath.push_back(testState);
															#line 377 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			statusCheckPassed = false;
															#line 378 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			;
															#line 2061 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkloadActorState();
		static_cast<WorkloadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 379 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(self->lagMeasurementFrequency);
															#line 379 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (static_cast<WorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2093 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WorkloadActor*>(this)->actor_wait_state = 1;
															#line 379 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkloadActor, 0, Void >*>(static_cast<WorkloadActor*>(this)));
															#line 2098 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 380 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		StrictFuture<Optional<double>> __when_expr_1 = measureMaxSSLag(self, db);
															#line 380 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (static_cast<WorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2109 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WorkloadActor*>(this)->actor_wait_state = 2;
															#line 380 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkloadActor, 1, Optional<double> >*>(static_cast<WorkloadActor*>(this)));
															#line 2114 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 380 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		StrictFuture<Optional<double>> __when_expr_1 = measureMaxSSLag(self, db);
															#line 380 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (static_cast<WorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2125 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WorkloadActor*>(this)->actor_wait_state = 2;
															#line 380 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkloadActor, 1, Optional<double> >*>(static_cast<WorkloadActor*>(this)));
															#line 2130 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkloadActor*>(this)->actor_wait_state > 0) static_cast<WorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<WorkloadActor*>(this)->ActorCallback< WorkloadActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkloadActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkloadActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkloadActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workload", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Optional<double> const& ssLag,int loopDepth) 
	{
															#line 381 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (!ssLag.present())
															#line 2214 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		{
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 385 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		localState = ssLag.get() < self->lagThreshold ? TestState::SS_LAG_NORMAL : TestState::SS_LAG_HIGH;
															#line 387 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		stateTransition = localState != testState;
															#line 389 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (!stateTransition)
															#line 2224 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		{
															#line 390 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			const bool acceptingCommits = self->dbInfo->get().recoveryState >= RecoveryState::ACCEPTING_COMMITS;
															#line 391 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			TraceEvent("ClogRemoteTLogMoreInfo") .detail("CloggedRemoteTLogPresent", self->cloggedRemoteTLog.present()) .detail("Addr", self->cloggedRemoteTLog.present() ? self->cloggedRemoteTLog.get().toString() : "DidNotFind") .detail("NotInDbInfo", self->cloggedRemoteTLog.present() ? remoteTLogNotInDbInfo(self->cloggedRemoteTLog.get(), self->dbInfo->get()) : false) .detail("AcceptingCommits", acceptingCommits) .detail("RecoveryState", self->dbInfo->get().recoveryState);
															#line 401 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (acceptingCommits && self->cloggedRemoteTLog.present() && remoteTLogNotInDbInfo(self->cloggedRemoteTLog.get(), self->dbInfo->get()))
															#line 2232 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			{
															#line 403 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
				localState = TestState::CLOGGED_REMOTE_TLOG_EXCLUDED;
															#line 404 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
				if (!statusCheckPassed)
															#line 2238 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
				{
															#line 405 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
					StrictFuture<Void> __when_expr_2 = store(statusCheckPassed, grayFailureStatusCheck(db, self->cloggedRemoteTLog.get()));
															#line 405 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
					if (static_cast<WorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2244 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
					static_cast<WorkloadActor*>(this)->actor_wait_state = 3;
															#line 405 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WorkloadActor, 2, Void >*>(static_cast<WorkloadActor*>(this)));
															#line 2249 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1loopBody1cont6(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1loopBody1cont5(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<double> && ssLag,int loopDepth) 
	{
															#line 381 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (!ssLag.present())
															#line 2273 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		{
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 385 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		localState = ssLag.get() < self->lagThreshold ? TestState::SS_LAG_NORMAL : TestState::SS_LAG_HIGH;
															#line 387 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		stateTransition = localState != testState;
															#line 389 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (!stateTransition)
															#line 2283 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		{
															#line 390 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			const bool acceptingCommits = self->dbInfo->get().recoveryState >= RecoveryState::ACCEPTING_COMMITS;
															#line 391 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			TraceEvent("ClogRemoteTLogMoreInfo") .detail("CloggedRemoteTLogPresent", self->cloggedRemoteTLog.present()) .detail("Addr", self->cloggedRemoteTLog.present() ? self->cloggedRemoteTLog.get().toString() : "DidNotFind") .detail("NotInDbInfo", self->cloggedRemoteTLog.present() ? remoteTLogNotInDbInfo(self->cloggedRemoteTLog.get(), self->dbInfo->get()) : false) .detail("AcceptingCommits", acceptingCommits) .detail("RecoveryState", self->dbInfo->get().recoveryState);
															#line 401 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			if (acceptingCommits && self->cloggedRemoteTLog.present() && remoteTLogNotInDbInfo(self->cloggedRemoteTLog.get(), self->dbInfo->get()))
															#line 2291 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
			{
															#line 403 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
				localState = TestState::CLOGGED_REMOTE_TLOG_EXCLUDED;
															#line 404 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
				if (!statusCheckPassed)
															#line 2297 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
				{
															#line 405 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
					StrictFuture<Void> __when_expr_2 = store(statusCheckPassed, grayFailureStatusCheck(db, self->cloggedRemoteTLog.get()));
															#line 405 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
					if (static_cast<WorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2303 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
					static_cast<WorkloadActor*>(this)->actor_wait_state = 3;
															#line 405 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WorkloadActor, 2, Void >*>(static_cast<WorkloadActor*>(this)));
															#line 2308 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1loopBody1cont6(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1loopBody1cont5(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Optional<double> const& ssLag,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(ssLag, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Optional<double> && ssLag,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(ssLag), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WorkloadActor*>(this)->actor_wait_state > 0) static_cast<WorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<WorkloadActor*>(this)->ActorCallback< WorkloadActor, 1, Optional<double> >::remove();

	}
	void a_callback_fire(ActorCallback< WorkloadActor, 1, Optional<double> >*,Optional<double> const& value) 
	{
		fdb_probe_actor_enter("workload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkloadActor, 1, Optional<double> >*,Optional<double> && value) 
	{
		fdb_probe_actor_enter("workload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WorkloadActor, 1, Optional<double> >*,Error err) 
	{
		fdb_probe_actor_enter("workload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workload", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 412 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		if (stateTransition)
															#line 2407 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		{
															#line 413 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			self->actualStatePath.push_back(localState);
															#line 414 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
			testState = localState;
															#line 2413 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
															#line 408 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		stateTransition = localState != testState;
															#line 2429 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 406 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		ASSERT(statusCheckPassed);
															#line 2438 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 406 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
		ASSERT(statusCheckPassed);
															#line 2447 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WorkloadActor*>(this)->actor_wait_state > 0) static_cast<WorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<WorkloadActor*>(this)->ActorCallback< WorkloadActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkloadActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workload", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WorkloadActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workload", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WorkloadActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workload", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 373 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	ClogRemoteTLog* self;
															#line 373 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	Database db;
															#line 374 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	Future<Void> clog;
															#line 375 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	TestState testState;
															#line 377 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	bool statusCheckPassed;
															#line 385 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	TestState localState;
															#line 387 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	bool stateTransition;
															#line 2541 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
};
// This generated class is to be used only via workload()
															#line 373 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
class WorkloadActor final : public Actor<Void>, public ActorCallback< WorkloadActor, 0, Void >, public ActorCallback< WorkloadActor, 1, Optional<double> >, public ActorCallback< WorkloadActor, 2, Void >, public FastAllocated<WorkloadActor>, public WorkloadActorState<WorkloadActor> {
															#line 2546 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
public:
	using FastAllocated<WorkloadActor>::operator new;
	using FastAllocated<WorkloadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7931610324806500352UL, 13894829823576207104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkloadActor, 0, Void >;
friend struct ActorCallback< WorkloadActor, 1, Optional<double> >;
friend struct ActorCallback< WorkloadActor, 2, Void >;
															#line 373 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	WorkloadActor(ClogRemoteTLog* const& self,Database const& db) 
															#line 2565 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
		 : Actor<Void>(),
		   WorkloadActorState<WorkloadActor>(self, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("workload", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6662893632963641600UL, 18424590834130018048UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("workload");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("workload", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkloadActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WorkloadActor, 1, Optional<double> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WorkloadActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 373 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
[[nodiscard]] Future<Void> workload( ClogRemoteTLog* const& self, Database const& db ) {
															#line 373 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
	return Future<Void>(new WorkloadActor(self, db));
															#line 2599 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogRemoteTLog.actor.g.cpp"
}

#line 418 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClogRemoteTLog.actor.cpp"
};

WorkloadFactory<ClogRemoteTLog> ClogRemoteTLogWorkloadFactory;
